/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.resources.ResourceContentType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum ResourceType {
    CODE(ResourceContentType.CONTENT_BINARY, ".dex", ".jar", ".class"),
    XML(ResourceContentType.CONTENT_TEXT, ".xml"),
    ARSC(ResourceContentType.CONTENT_TEXT, ".arsc"),
    APK(ResourceContentType.CONTENT_BINARY, ".apk", ".apkm", ".apks"),
    FONT(ResourceContentType.CONTENT_BINARY, ".ttf", ".ttc", ".otf"),
    IMG(ResourceContentType.CONTENT_BINARY, ".png", ".gif", ".jpg", ".jpeg", ".webp", ".bmp", ".tiff"),
    ARCHIVE(ResourceContentType.CONTENT_BINARY, ".zip", ".rar", ".7zip", ".7z", ".arj", ".tar", ".gzip", ".bzip", ".bzip2", ".cab", ".cpio", ".ar", ".gz", ".tgz", ".bz2"),
    VIDEOS(ResourceContentType.CONTENT_BINARY, ".mp4", ".mkv", ".webm", ".avi", ".flv", ".3gp"),
    SOUNDS(ResourceContentType.CONTENT_BINARY, ".aac", ".ogg", ".opus", ".mp3", ".wav", ".wma", ".mid", ".midi"),
    JSON(ResourceContentType.CONTENT_TEXT, ".json"),
    TEXT(ResourceContentType.CONTENT_TEXT, ".txt", ".ini", ".conf", ".yaml", ".properties", ".js", ".java", ".kt", ".md"),
    HTML(ResourceContentType.CONTENT_TEXT, ".html", ".htm"),
    LIB(ResourceContentType.CONTENT_BINARY, ".so"),
    MANIFEST(ResourceContentType.CONTENT_TEXT, new String[0]),
    UNKNOWN_BIN(ResourceContentType.CONTENT_BINARY, ".bin"),
    UNKNOWN(ResourceContentType.CONTENT_UNKNOWN, new String[0]);

    private final ResourceContentType contentType;
    private final String[] exts;
    private static final Map<String, ResourceType> EXT_MAP;

    private ResourceType(ResourceContentType contentType, String ... exts) {
        this.contentType = contentType;
        this.exts = exts;
    }

    public ResourceContentType getContentType() {
        return this.contentType;
    }

    public String[] getExts() {
        return this.exts;
    }

    public static ResourceType getFileType(String fileName) {
        String ext;
        ResourceType resType;
        if (fileName.endsWith("/resources.pb")) {
            return ARSC;
        }
        int dot = fileName.lastIndexOf(46);
        if (dot != -1 && (resType = EXT_MAP.get(ext = fileName.substring(dot).toLowerCase(Locale.ROOT))) != null) {
            if (resType == XML && fileName.equals("AndroidManifest.xml")) {
                return MANIFEST;
            }
            return resType;
        }
        return UNKNOWN;
    }

    static {
        EXT_MAP = new HashMap<String, ResourceType>();
        for (ResourceType type : ResourceType.values()) {
            for (String ext : type.getExts()) {
                ResourceType prev = EXT_MAP.put(ext, type);
                if (prev == null) continue;
                throw new JadxRuntimeException("Duplicate extension in ResourceType: " + ext);
            }
        }
    }
}

