/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.data.impl;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.IJavaNodeRef;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadxNodeRef
implements IJavaNodeRef {
    private IJavaNodeRef.RefType refType;
    private String declClass;
    @Nullable
    private String shortId;
    private static final Comparator<IJavaNodeRef> COMPARATOR = Comparator.comparing(IJavaNodeRef::getType).thenComparing(IJavaNodeRef::getDeclaringClass).thenComparing(IJavaNodeRef::getShortId);

    @Nullable
    public static JadxNodeRef forJavaNode(JavaNode javaNode) {
        if (javaNode instanceof JavaClass) {
            return JadxNodeRef.forCls((JavaClass)javaNode);
        }
        if (javaNode instanceof JavaMethod) {
            return JadxNodeRef.forMth((JavaMethod)javaNode);
        }
        if (javaNode instanceof JavaField) {
            return JadxNodeRef.forFld((JavaField)javaNode);
        }
        return null;
    }

    public static JadxNodeRef forCls(JavaClass cls) {
        return new JadxNodeRef(IJavaNodeRef.RefType.CLASS, JadxNodeRef.getClassRefStr(cls), null);
    }

    public static JadxNodeRef forCls(String clsFullName) {
        return new JadxNodeRef(IJavaNodeRef.RefType.CLASS, clsFullName, null);
    }

    public static JadxNodeRef forMth(JavaMethod mth) {
        return new JadxNodeRef(IJavaNodeRef.RefType.METHOD, JadxNodeRef.getClassRefStr(mth.getDeclaringClass()), mth.getMethodNode().getMethodInfo().getShortId());
    }

    public static JadxNodeRef forFld(JavaField fld) {
        return new JadxNodeRef(IJavaNodeRef.RefType.FIELD, JadxNodeRef.getClassRefStr(fld.getDeclaringClass()), fld.getFieldNode().getFieldInfo().getShortId());
    }

    public static JadxNodeRef forPkg(String pkgFullName) {
        return new JadxNodeRef(IJavaNodeRef.RefType.PKG, pkgFullName, "");
    }

    private static String getClassRefStr(JavaClass cls) {
        return cls.getClassNode().getClassInfo().getRawName();
    }

    public JadxNodeRef(IJavaNodeRef.RefType refType, String declClass, @Nullable String shortId) {
        this.refType = refType;
        this.declClass = declClass;
        this.shortId = shortId;
    }

    public JadxNodeRef() {
    }

    @Override
    public IJavaNodeRef.RefType getType() {
        return this.refType;
    }

    public void setRefType(IJavaNodeRef.RefType refType) {
        this.refType = refType;
    }

    @Override
    public String getDeclaringClass() {
        return this.declClass;
    }

    public void setDeclClass(String declClass) {
        this.declClass = declClass;
    }

    @Override
    @Nullable
    public String getShortId() {
        return this.shortId;
    }

    public void setShortId(@Nullable String shortId) {
        this.shortId = shortId;
    }

    @Override
    public int compareTo(@NotNull IJavaNodeRef other) {
        return COMPARATOR.compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.refType, this.declClass, this.shortId});
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof JadxNodeRef)) {
            return false;
        }
        JadxNodeRef that = (JadxNodeRef)o15;
        return this.refType == that.refType && Objects.equals(this.declClass, that.declClass) && Objects.equals(this.shortId, that.shortId);
    }

    public String toString() {
        switch (this.refType) {
            case CLASS: 
            case PKG: {
                return this.declClass;
            }
            case FIELD: 
            case METHOD: {
                return this.declClass + "->" + this.shortId;
            }
        }
        return "unknown node ref type";
    }
}

