/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static <T> void addToList(Collection<T> list2, @Nullable T item) {
        if (item != null) {
            list2.add(item);
        }
    }

    public static <T, I> void addToList(Collection<T> list2, @Nullable I item, Function<I, T> map) {
        T value;
        if (item != null && (value = map.apply(item)) != null) {
            list2.add(value);
        }
    }

    public static <T> List<T> concat(List<T> a15, List<T> b15) {
        int aSize = a15.size();
        int bSize = b15.size();
        if (aSize == 0 && bSize == 0) {
            return Collections.emptyList();
        }
        if (aSize == 0) {
            return b15;
        }
        if (bSize == 0) {
            return a15;
        }
        ArrayList<T> list2 = new ArrayList<T>(aSize + bSize);
        list2.addAll(a15);
        list2.addAll(b15);
        return list2;
    }

    public static <T> List<T> concatDistinct(List<T> a15, List<T> b15) {
        int aSize = a15.size();
        int bSize = b15.size();
        if (aSize == 0 && bSize == 0) {
            return Collections.emptyList();
        }
        if (aSize == 0) {
            return b15;
        }
        if (bSize == 0) {
            return a15;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(aSize + bSize);
        set.addAll(a15);
        set.addAll(b15);
        return new ArrayList(set);
    }

    public static <T> String listToStr(List<T> list2) {
        if (list2 == null) {
            return "null";
        }
        if (list2.isEmpty()) {
            return "";
        }
        if (list2.size() == 1) {
            return Objects.toString(list2.get(0));
        }
        StringBuilder sb5 = new StringBuilder();
        Iterator<T> it = list2.iterator();
        sb5.append(it.next());
        while (it.hasNext()) {
            sb5.append(", ").append(it.next());
        }
        return sb5.toString();
    }

    public static String formatOffset(int offset) {
        return String.format("0x%04x", offset);
    }

    @SafeVarargs
    public static <T> Set<T> constSet(T ... arr) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(arr)));
    }
}

