/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli.clst;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.args.UseSourceNameAsClassNameAlias;
import jadx.core.clsp.ClsSet;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToClsSet {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToClsSet.class);

    public static void usage() {
        LOG.info("<android API level (number)> <output .jcst file> <several input dex or jar files> ");
        LOG.info("Arguments to update core.jcst: <android API level (number)> <jadx root>/jadx-core/src/main/resources/clst/core.jcst <sdk_root>/platforms/android-<api level>/android.jar<sdk_root>/platforms/android-<api level>/optional/android.car.jar <sdk_root>/platforms/android-<api level>/optional/org.apache.http.legacy.jar");
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            ConvertToClsSet.usage();
            System.exit(1);
        }
        int androidApiLevel = Integer.parseInt(args[0]);
        List<Path> inputPaths = Stream.of(args).skip(1L).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        Path output = (Path)inputPaths.remove(0);
        JadxArgs jadxArgs = new JadxArgs();
        jadxArgs.setInputFiles(FileUtils.toFiles(inputPaths));
        jadxArgs.setDeobfuscationOn(false);
        jadxArgs.setRenameFlags(EnumSet.noneOf(JadxArgs.RenameEnum.class));
        jadxArgs.setUseSourceNameAsClassNameAlias(UseSourceNameAsClassNameAlias.NEVER);
        jadxArgs.setMoveInnerClasses(false);
        jadxArgs.setInlineAnonymousClasses(false);
        jadxArgs.setInlineMethods(false);
        jadxArgs.setLoadJadxClsSetFile(false);
        try (JadxDecompiler decompiler = new JadxDecompiler(jadxArgs);){
            decompiler.load();
            RootNode root = decompiler.getRoot();
            ClsSet set = new ClsSet(root);
            set.setAndroidApiLevel(androidApiLevel);
            set.loadFrom(root);
            set.save(output);
            LOG.info("Output: {}", (Object)output);
            LOG.info("done");
        }
        catch (Exception e15) {
            LOG.error("Failed with error", e15);
        }
    }
}

