/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class LimitedQueue<T>
extends AbstractQueue<T> {
    private final Deque<T> deque = new ArrayDeque<T>();
    private final int limit;

    public LimitedQueue(int limit) {
        this.limit = limit;
    }

    @Override
    public Iterator<T> iterator() {
        return this.deque.iterator();
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public boolean offer(T t15) {
        this.deque.addLast(t15);
        if (this.deque.size() > this.limit) {
            this.deque.removeFirst();
        }
        return true;
    }

    @Override
    public T poll() {
        return this.deque.poll();
    }

    @Override
    public T peek() {
        return this.deque.peek();
    }

    @Override
    public void clear() {
        this.deque.clear();
    }
}

