/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.ArrayUtils;

public class HexInspectorPanel
extends JPanel {
    private final List<ValueFormatter> formatters = new ArrayList<ValueFormatter>();
    private byte[] bytes = null;
    private Integer offset = null;
    private boolean isLittleEndian;
    private int row = 0;

    public HexInspectorPanel() {
        this.setLayout(new GridBagLayout());
        this.addValueFormat("Signed 8 bit", 1, b15 -> Integer.toString(b15.get()));
        this.addValueFormat("Unsigned 8 bit", 1, b15 -> Integer.toString(b15.get() & 0xFF));
        this.addValueFormat("Signed 16 bit", 2, b15 -> Short.toString(b15.getShort()));
        this.addValueFormat("Unsigned 16 bit", 2, b15 -> Integer.toString(b15.getShort() & 0xFFFF));
        this.addValueFormat("Float 32 bit", 4, b15 -> Float.toString(b15.getFloat()));
        this.addValueFormat("Signed 32 bit", 4, b15 -> Integer.toString(b15.getInt()));
        this.addValueFormat("Unsigned 32 bit", 4, b15 -> Integer.toUnsignedString(b15.getInt()));
        this.addValueFormat("Signed 64 bit", 8, b15 -> Long.toString(b15.getLong()));
        this.addValueFormat("Float 64 bit", 8, b15 -> Double.toString(b15.getDouble()));
        this.addValueFormat("Unsigned 64 bit", 8, b15 -> Long.toUnsignedString(b15.getLong()));
        this.addValueFormat("Hexadecimal", 1, b15 -> Integer.toString(b15.get(), 16));
        this.addValueFormat("Octal", 1, b15 -> Integer.toString(b15.get(), 8));
        this.addValueFormat("Binary", 1, b15 -> Integer.toString(b15.get(), 2));
        GridBagConstraints constraints = this.getConstraints();
        constraints.gridwidth = 2;
        JCheckBox littleEndianCheckBox = new JCheckBox("Little endian", false);
        littleEndianCheckBox.addItemListener(ev4 -> {
            this.isLittleEndian = ev4.getStateChange() == 1;
            this.reloadOffset();
        });
        this.add((Component)littleEndianCheckBox, constraints);
        constraints = this.getConstraints();
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(" "), constraints);
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.reloadOffset();
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    private void reloadOffset() {
        if (this.bytes == null || this.offset == null) {
            return;
        }
        for (int i15 = 0; i15 < this.formatters.size(); ++i15) {
            ValueFormatter formatter = this.formatters.get(i15);
            if (!this.canDisplay(this.offset, formatter.dataSize)) continue;
            ByteBuffer buffer = this.decodeByteArray(this.offset, formatter.dataSize);
            String value = formatter.function.apply(buffer);
            ((JTextField)this.getComponent(i15 * 2 + 1)).setText(value);
        }
    }

    private GridBagConstraints getConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridy = this.row++;
        return constraints;
    }

    private void addValueFormat(String name, int dataSize, Function<ByteBuffer, String> formatter) {
        this.formatters.add(new ValueFormatter(dataSize, formatter));
        GridBagConstraints constraints = this.getConstraints();
        constraints.gridx = 0;
        constraints.anchor = 17;
        this.add((Component)new JLabel(name), constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        JTextField textField = new JTextField();
        textField.setEditable(false);
        this.add((Component)textField, constraints);
    }

    private boolean canDisplay(int offset, int size) {
        return offset + size <= this.bytes.length;
    }

    private ByteBuffer decodeByteArray(int offset, int size) {
        byte[] chunk = this.sliceBytes(offset, size);
        if (this.isLittleEndian) {
            ArrayUtils.reverse(chunk);
        }
        return ByteBuffer.wrap(chunk);
    }

    private byte[] sliceBytes(int offset, int size) {
        byte[] slice = new byte[size];
        System.arraycopy(this.bytes, offset, slice, 0, size);
        return slice;
    }

    private static class ValueFormatter {
        public final int dataSize;
        public final Function<ByteBuffer, String> function;

        public ValueFormatter(int dataSize, Function<ByteBuffer, String> function) {
            this.dataSize = dataSize;
            this.function = function;
        }
    }
}

