/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.shortcut;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.data.ShortcutsWrapper;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.action.ActionCategory;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.IShortcutAction;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.Shortcut;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutsController {
    private static final Logger LOG = LoggerFactory.getLogger(ShortcutsController.class);
    private final JadxSettings settings;
    private final Map<ActionModel, Set<IShortcutAction>> boundActions = new EnumMap<ActionModel, Set<IShortcutAction>>(ActionModel.class);
    private final Map<Integer, List<IShortcutAction>> mouseActions = new HashMap<Integer, List<IShortcutAction>>();
    private ShortcutsWrapper shortcuts;

    public ShortcutsController(JadxSettings settings) {
        this.settings = settings;
    }

    public void loadSettings() {
        this.shortcuts = this.settings.getShortcuts();
        this.indexMouseActions();
        this.boundActions.forEach((actionModel, actions) -> {
            if (actions != null) {
                Shortcut shortcut = this.get((ActionModel)((Object)actionModel));
                for (IShortcutAction action : actions) {
                    action.setShortcut(shortcut);
                }
            }
        });
    }

    @Nullable
    public Shortcut get(ActionModel actionModel) {
        return this.shortcuts.get(actionModel);
    }

    public KeyStroke getKeyStroke(ActionModel actionModel) {
        Shortcut shortcut = this.get(actionModel);
        if (shortcut != null && shortcut.isKeyboard()) {
            return shortcut.toKeyStroke();
        }
        return null;
    }

    public void bind(IShortcutAction action) {
        if (action.getShortcutComponent() == null) {
            LOG.warn("No shortcut component in action: {}", (Object)action, (Object)new JadxRuntimeException());
            return;
        }
        this.boundActions.computeIfAbsent(action.getActionModel(), k15 -> new HashSet()).add(action);
    }

    public void bindImmediate(IShortcutAction action) {
        this.bind(action);
        Shortcut shortcut = this.get(action.getActionModel());
        action.setShortcut(shortcut);
    }

    public static Map<ActionModel, Shortcut> getDefault() {
        HashMap<ActionModel, Shortcut> shortcuts = new HashMap<ActionModel, Shortcut>();
        for (ActionModel actionModel : ActionModel.values()) {
            shortcuts.put(actionModel, actionModel.getDefaultShortcut());
        }
        return shortcuts;
    }

    public void registerMouseEventListener(MainWindow mw4) {
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (mw4.isSettingsOpen()) {
                return;
            }
            if (!(event instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getID() != 501) {
                return;
            }
            List<IShortcutAction> actions = this.mouseActions.get(mouseEvent.getButton());
            if (actions != null) {
                for (IShortcutAction action : actions) {
                    if (action == null) continue;
                    mouseEvent.consume();
                    UiUtils.uiRun(action::performAction);
                }
            }
        }, 16L);
    }

    private void indexMouseActions() {
        this.mouseActions.clear();
        for (ActionModel actionModel : ActionModel.values()) {
            Set<IShortcutAction> actions;
            Shortcut shortcut = this.shortcuts.get(actionModel);
            if (shortcut == null || !shortcut.isMouse() || (actions = this.boundActions.get((Object)actionModel)) == null || actions.isEmpty()) continue;
            this.mouseActions.computeIfAbsent(shortcut.getMouseButton(), i15 -> new ArrayList()).addAll(actions);
        }
    }

    public void unbindActionsForComponent(JComponent component) {
        for (Set<IShortcutAction> actions : this.boundActions.values()) {
            if (actions == null) continue;
            actions.removeIf(action -> action == null || action.getShortcutComponent() == null || action.getShortcutComponent() == component);
        }
    }

    public void reset() {
        for (ActionModel actionModel : ActionModel.values()) {
            if (actionModel.getCategory() == ActionCategory.MENU_TOOLBAR) continue;
            this.boundActions.remove((Object)actionModel);
        }
    }
}

