/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.protobuf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import kotlin.metadata.internal.protobuf.ByteString;
import kotlin.metadata.internal.protobuf.Internal;
import kotlin.metadata.internal.protobuf.LazyStringList;
import kotlin.metadata.internal.protobuf.UnmodifiableLazyStringList;

public class LazyStringArrayList
extends AbstractList<String>
implements RandomAccess,
LazyStringList {
    public static final LazyStringList EMPTY = new LazyStringArrayList().getUnmodifiableView();
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    public LazyStringArrayList(LazyStringList from) {
        this.list = new ArrayList<Object>(from.size());
        this.addAll(from);
    }

    @Override
    public String get(int index) {
        Object o15 = this.list.get(index);
        if (o15 instanceof String) {
            return (String)o15;
        }
        if (o15 instanceof ByteString) {
            ByteString bs4 = (ByteString)o15;
            String s15 = bs4.toStringUtf8();
            if (bs4.isValidUtf8()) {
                this.list.set(index, s15);
            }
            return s15;
        }
        byte[] ba5 = (byte[])o15;
        String s16 = Internal.toStringUtf8(ba5);
        if (Internal.isValidUtf8(ba5)) {
            this.list.set(index, s16);
        }
        return s16;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index, String s15) {
        Object o15 = this.list.set(index, s15);
        return LazyStringArrayList.asString(o15);
    }

    @Override
    public void add(int index, String element) {
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c15) {
        return this.addAll(this.size(), c15);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c15) {
        Collection<? extends String> collection = c15 instanceof LazyStringList ? ((LazyStringList)c15).getUnderlyingElements() : c15;
        boolean ret = this.list.addAll(index, collection);
        ++this.modCount;
        return ret;
    }

    @Override
    public String remove(int index) {
        Object o15 = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(o15);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public ByteString getByteString(int index) {
        Object o15 = this.list.get(index);
        ByteString b15 = LazyStringArrayList.asByteString(o15);
        if (b15 != o15) {
            this.list.set(index, b15);
        }
        return b15;
    }

    private static String asString(Object o15) {
        if (o15 instanceof String) {
            return (String)o15;
        }
        if (o15 instanceof ByteString) {
            return ((ByteString)o15).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])o15);
    }

    private static ByteString asByteString(Object o15) {
        if (o15 instanceof ByteString) {
            return (ByteString)o15;
        }
        if (o15 instanceof String) {
            return ByteString.copyFromUtf8((String)o15);
        }
        return ByteString.copyFrom((byte[])o15);
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        return new UnmodifiableLazyStringList(this);
    }
}

