/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.stringtemplate.language.GroupLexer;
import org.antlr.stringtemplate.language.GroupParser;

public class StringTemplateGroup {
    protected String name;
    protected Map templates = new HashMap();
    protected Map maps = new HashMap();
    protected Class templateLexerClass = null;
    protected static Class defaultTemplateLexerClass = DefaultTemplateLexer.class;
    protected String rootDir = null;
    protected static Map nameToGroupMap = Collections.synchronizedMap(new HashMap());
    protected static Map nameToInterfaceMap = Collections.synchronizedMap(new HashMap());
    protected StringTemplateGroup superGroup = null;
    protected List interfaces = null;
    protected boolean templatesDefinedInGroupFile = false;
    protected Class userSpecifiedWriter;
    protected boolean debugTemplateOutput = false;
    protected Set noDebugStartStopStrings;
    protected Map attributeRenderers;
    private static StringTemplateGroupLoader groupLoader = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String s15, Throwable e15) {
            System.err.println(s15);
            if (e15 != null) {
                e15.printStackTrace(System.err);
            }
        }

        public void warning(String s15) {
            System.out.println(s15);
        }
    };
    protected static final StringTemplate NOT_FOUND_ST = new StringTemplate();
    protected int refreshIntervalInSeconds = 2147483;
    protected long lastCheckedDisk = 0L;
    String fileCharEncoding = System.getProperty("file.encoding");

    public StringTemplateGroup(String name, String rootDir) {
        this(name, rootDir, DefaultTemplateLexer.class);
    }

    public StringTemplateGroup(String name, String rootDir, Class lexer) {
        this.name = name;
        this.rootDir = rootDir;
        this.lastCheckedDisk = System.currentTimeMillis();
        nameToGroupMap.put(name, this);
        this.templateLexerClass = lexer;
    }

    public StringTemplateGroup(String name) {
        this(name, null, null);
    }

    public StringTemplateGroup(String name, Class lexer) {
        this(name, null, lexer);
    }

    public StringTemplateGroup(Reader r15) {
        this(r15, AngleBracketTemplateLexer.class, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroup(Reader r15, StringTemplateErrorListener errors) {
        this(r15, AngleBracketTemplateLexer.class, errors, null);
    }

    public StringTemplateGroup(Reader r15, Class lexer) {
        this(r15, lexer, null, null);
    }

    public StringTemplateGroup(Reader r15, Class lexer, StringTemplateErrorListener errors) {
        this(r15, lexer, errors, null);
    }

    public StringTemplateGroup(Reader r15, Class lexer, StringTemplateErrorListener errors, StringTemplateGroup superGroup) {
        this.templatesDefinedInGroupFile = true;
        if (lexer == null) {
            lexer = AngleBracketTemplateLexer.class;
        }
        this.templateLexerClass = lexer;
        if (errors != null) {
            this.listener = errors;
        }
        this.setSuperGroup(superGroup);
        this.parseGroup(r15);
        nameToGroupMap.put(this.name, this);
        this.verifyInterfaceImplementations();
    }

    public Class getTemplateLexerClass() {
        if (this.templateLexerClass != null) {
            return this.templateLexerClass;
        }
        return defaultTemplateLexerClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuperGroup(StringTemplateGroup superGroup) {
        this.superGroup = superGroup;
    }

    public void setSuperGroup(String superGroupName) {
        StringTemplateGroup superGroup = (StringTemplateGroup)nameToGroupMap.get(superGroupName);
        if (superGroup != null) {
            this.setSuperGroup(superGroup);
            return;
        }
        superGroup = StringTemplateGroup.loadGroup(superGroupName, this.templateLexerClass, null);
        if (superGroup != null) {
            nameToGroupMap.put(superGroupName, superGroup);
            this.setSuperGroup(superGroup);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public void implementInterface(StringTemplateGroupInterface I11) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList();
        }
        this.interfaces.add(I11);
    }

    public void implementInterface(String interfaceName) {
        StringTemplateGroupInterface I11 = (StringTemplateGroupInterface)nameToInterfaceMap.get(interfaceName);
        if (I11 != null) {
            this.implementInterface(I11);
            return;
        }
        I11 = StringTemplateGroup.loadInterface(interfaceName);
        if (I11 != null) {
            nameToInterfaceMap.put(interfaceName, I11);
            this.implementInterface(I11);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public StringTemplateGroup getSuperGroup() {
        return this.superGroup;
    }

    public String getGroupHierarchyStackString() {
        LinkedList<String> groupNames = new LinkedList<String>();
        StringTemplateGroup p15 = this;
        while (p15 != null) {
            groupNames.add(0, p15.name);
            p15 = p15.superGroup;
        }
        return ((Object)groupNames).toString().replaceAll(",", "");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public StringTemplate createStringTemplate() {
        StringTemplate st4 = new StringTemplate();
        return st4;
    }

    protected StringTemplate getInstanceOf(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        StringTemplate st4 = this.lookupTemplate(enclosingInstance, name);
        if (st4 != null) {
            StringTemplate instanceST = st4.getInstanceOf();
            return instanceST;
        }
        return null;
    }

    public StringTemplate getInstanceOf(String name) {
        return this.getInstanceOf(null, name);
    }

    public StringTemplate getInstanceOf(String name, Map attributes) {
        StringTemplate st4 = this.getInstanceOf(name);
        st4.attributes = attributes;
        return st4;
    }

    public StringTemplate getEmbeddedInstanceOf(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        StringTemplate st4 = null;
        st4 = name.startsWith("super.") ? enclosingInstance.getNativeGroup().getInstanceOf(enclosingInstance, name) : this.getInstanceOf(enclosingInstance, name);
        st4.setGroup(this);
        st4.setEnclosingInstance(enclosingInstance);
        return st4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringTemplate lookupTemplate(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        if (name.startsWith("super.")) {
            if (this.superGroup == null) throw new IllegalArgumentException(this.getName() + " has no super group; invalid template: " + name);
            int dot = name.indexOf(46);
            name = name.substring(dot + 1, name.length());
            return this.superGroup.lookupTemplate(enclosingInstance, name);
        }
        this.checkRefreshInterval();
        StringTemplate st4 = (StringTemplate)this.templates.get(name);
        if (st4 == null) {
            if (!this.templatesDefinedInGroupFile) {
                st4 = this.loadTemplateFromBeneathRootDirOrCLASSPATH(this.getFileNameFromTemplateName(name));
            }
            if (st4 == null && this.superGroup != null && (st4 = this.superGroup.getInstanceOf(name)) != null) {
                st4.setGroup(this);
            }
            if (st4 == null) {
                this.templates.put(name, NOT_FOUND_ST);
                String context = "";
                if (enclosingInstance != null) {
                    context = "; context is " + enclosingInstance.getEnclosingInstanceStackString();
                }
                String hier = this.getGroupHierarchyStackString();
                context = context + "; group hierarchy is " + hier;
                throw new IllegalArgumentException("Can't find template " + this.getFileNameFromTemplateName(name) + context);
            }
        } else {
            if (st4 != NOT_FOUND_ST) return st4;
            return null;
        }
        this.templates.put(name, st4);
        return st4;
    }

    public StringTemplate lookupTemplate(String name) {
        return this.lookupTemplate(null, name);
    }

    protected void checkRefreshInterval() {
        boolean timeToFlush;
        if (this.templatesDefinedInGroupFile) {
            return;
        }
        boolean bl4 = timeToFlush = this.refreshIntervalInSeconds == 0 || System.currentTimeMillis() - this.lastCheckedDisk >= (long)(this.refreshIntervalInSeconds * 1000);
        if (timeToFlush) {
            this.templates.clear();
            this.lastCheckedDisk = System.currentTimeMillis();
        }
    }

    protected StringTemplate loadTemplate(String name, BufferedReader r15) throws IOException {
        String line;
        String nl4 = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer(300);
        while ((line = r15.readLine()) != null) {
            buf.append(line);
            buf.append(nl4);
        }
        String pattern = buf.toString().trim();
        if (pattern.length() == 0) {
            this.error("no text in template '" + name + "'");
            return null;
        }
        return this.defineTemplate(name, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringTemplate loadTemplateFromBeneathRootDirOrCLASSPATH(String fileName) {
        StringTemplate template = null;
        String name = this.getTemplateNameFromFileName(fileName);
        if (this.rootDir == null) {
            ClassLoader cl4 = Thread.currentThread().getContextClassLoader();
            InputStream is4 = cl4.getResourceAsStream(fileName);
            if (is4 == null) {
                cl4 = this.getClass().getClassLoader();
                is4 = cl4.getResourceAsStream(fileName);
            }
            if (is4 == null) {
                return null;
            }
            BufferedReader br4 = null;
            try {
                br4 = new BufferedReader(this.getInputStreamReader(is4));
                template = this.loadTemplate(name, br4);
            }
            catch (IOException ioe) {
                this.error("Problem reading template file: " + fileName, ioe);
            }
            finally {
                if (br4 != null) {
                    try {
                        br4.close();
                    }
                    catch (IOException ioe2) {
                        this.error("Cannot close template file: " + fileName, ioe2);
                    }
                }
            }
            return template;
        }
        template = this.loadTemplate(name, this.rootDir + "/" + fileName);
        return template;
    }

    public String getFileNameFromTemplateName(String templateName) {
        return templateName + ".st";
    }

    public String getTemplateNameFromFileName(String fileName) {
        String name = fileName;
        int suffix = name.lastIndexOf(".st");
        if (suffix >= 0) {
            name = name.substring(0, suffix);
        }
        return name;
    }

    protected StringTemplate loadTemplate(String name, String fileName) {
        StringTemplate template;
        block4: {
            BufferedReader br4 = null;
            template = null;
            try {
                FileInputStream fin = new FileInputStream(fileName);
                InputStreamReader isr = this.getInputStreamReader(fin);
                br4 = new BufferedReader(isr);
                template = this.loadTemplate(name, br4);
                br4.close();
                br4 = null;
            }
            catch (IOException ioe) {
                if (br4 == null) break block4;
                try {
                    br4.close();
                }
                catch (IOException ioe2) {
                    this.error("Cannot close template file: " + fileName);
                }
            }
        }
        return template;
    }

    protected InputStreamReader getInputStreamReader(InputStream in4) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in4, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return isr;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String fileCharEncoding) {
        this.fileCharEncoding = fileCharEncoding;
    }

    public synchronized StringTemplate defineTemplate(String name, String template) {
        if (name != null && name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in template names");
        }
        StringTemplate st4 = this.createStringTemplate();
        st4.setName(name);
        st4.setGroup(this);
        st4.setNativeGroup(this);
        st4.setTemplate(template);
        st4.setErrorListener(this.listener);
        this.templates.put(name, st4);
        return st4;
    }

    public StringTemplate defineRegionTemplate(String enclosingTemplateName, String regionName, String template, int type) {
        String mangledName = this.getMangledRegionName(enclosingTemplateName, regionName);
        StringTemplate regionST = this.defineTemplate(mangledName, template);
        regionST.setIsRegion(true);
        regionST.setRegionDefType(type);
        return regionST;
    }

    public StringTemplate defineRegionTemplate(StringTemplate enclosingTemplate, String regionName, String template, int type) {
        StringTemplate regionST = this.defineRegionTemplate(enclosingTemplate.getOutermostName(), regionName, template, type);
        enclosingTemplate.getOutermostEnclosingInstance().addRegionName(regionName);
        return regionST;
    }

    public StringTemplate defineImplicitRegionTemplate(StringTemplate enclosingTemplate, String name) {
        return this.defineRegionTemplate(enclosingTemplate, name, "", 1);
    }

    public String getMangledRegionName(String enclosingTemplateName, String name) {
        return "region__" + enclosingTemplateName + "__" + name;
    }

    public String getUnMangledTemplateName(String mangledName) {
        return mangledName.substring("region__".length(), mangledName.lastIndexOf("__"));
    }

    public synchronized StringTemplate defineTemplateAlias(String name, String target) {
        StringTemplate targetST = this.getTemplateDefinition(target);
        if (targetST == null) {
            this.error("cannot alias " + name + " to undefined template: " + target);
            return null;
        }
        this.templates.put(name, targetST);
        return targetST;
    }

    public synchronized boolean isDefinedInThisGroup(String name) {
        StringTemplate st4 = (StringTemplate)this.templates.get(name);
        if (st4 != null) {
            return !st4.isRegion() || st4.getRegionDefType() != 1;
        }
        return false;
    }

    public synchronized StringTemplate getTemplateDefinition(String name) {
        return (StringTemplate)this.templates.get(name);
    }

    public boolean isDefined(String name) {
        try {
            return this.lookupTemplate(name) != null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    protected void parseGroup(Reader r15) {
        try {
            GroupLexer lexer = new GroupLexer(r15);
            GroupParser parser = new GroupParser(lexer);
            parser.group(this);
        }
        catch (Exception e15) {
            String name = "<unknown>";
            if (this.getName() != null) {
                name = this.getName();
            }
            this.error("problem parsing group " + name + ": " + e15, e15);
        }
    }

    protected void verifyInterfaceImplementations() {
        for (int i15 = 0; this.interfaces != null && i15 < this.interfaces.size(); ++i15) {
            StringTemplateGroupInterface I11 = (StringTemplateGroupInterface)this.interfaces.get(i15);
            List missing = I11.getMissingTemplates(this);
            List mismatched = I11.getMismatchedTemplates(this);
            if (missing != null) {
                this.error("group " + this.getName() + " does not satisfy interface " + I11.getName() + ": missing templates " + missing);
            }
            if (mismatched == null) continue;
            this.error("group " + this.getName() + " does not satisfy interface " + I11.getName() + ": mismatched arguments on these templates " + mismatched);
        }
    }

    public int getRefreshInterval() {
        return this.refreshIntervalInSeconds;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshIntervalInSeconds = refreshInterval;
    }

    public void setErrorListener(StringTemplateErrorListener listener) {
        this.listener = listener;
    }

    public StringTemplateErrorListener getErrorListener() {
        return this.listener;
    }

    public void setStringTemplateWriter(Class c15) {
        this.userSpecifiedWriter = c15;
    }

    public StringTemplateWriter getStringTemplateWriter(Writer w15) {
        StringTemplateWriter stw = null;
        if (this.userSpecifiedWriter != null) {
            try {
                Constructor ctor = this.userSpecifiedWriter.getConstructor(Writer.class);
                stw = (StringTemplateWriter)ctor.newInstance(w15);
            }
            catch (Exception e15) {
                this.error("problems getting StringTemplateWriter", e15);
            }
        }
        if (stw == null) {
            stw = new AutoIndentWriter(w15);
        }
        return stw;
    }

    public void setAttributeRenderers(Map renderers) {
        this.attributeRenderers = renderers;
    }

    public void registerRenderer(Class attributeClassType, Object renderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = Collections.synchronizedMap(new HashMap());
        }
        this.attributeRenderers.put(attributeClassType, renderer);
    }

    public AttributeRenderer getAttributeRenderer(Class attributeClassType) {
        if (this.attributeRenderers == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getAttributeRenderer(attributeClassType);
        }
        AttributeRenderer renderer = (AttributeRenderer)this.attributeRenderers.get(attributeClassType);
        if (renderer == null && this.superGroup != null) {
            renderer = this.superGroup.getAttributeRenderer(attributeClassType);
        }
        return renderer;
    }

    public Map getMap(String name) {
        if (this.maps == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getMap(name);
        }
        Map m15 = (Map)this.maps.get(name);
        if (m15 == null && this.superGroup != null) {
            m15 = this.superGroup.getMap(name);
        }
        return m15;
    }

    public void defineMap(String name, Map mapping) {
        this.maps.put(name, mapping);
    }

    public static void registerDefaultLexer(Class lexerClass) {
        defaultTemplateLexerClass = lexerClass;
    }

    public static void registerGroupLoader(StringTemplateGroupLoader loader) {
        groupLoader = loader;
    }

    public static StringTemplateGroup loadGroup(String name) {
        return StringTemplateGroup.loadGroup(name, null, null);
    }

    public static StringTemplateGroup loadGroup(String name, StringTemplateGroup superGroup) {
        return StringTemplateGroup.loadGroup(name, null, superGroup);
    }

    public static StringTemplateGroup loadGroup(String name, Class lexer, StringTemplateGroup superGroup) {
        if (groupLoader != null) {
            return groupLoader.loadGroup(name, lexer, superGroup);
        }
        return null;
    }

    public static StringTemplateGroupInterface loadInterface(String name) {
        if (groupLoader != null) {
            return groupLoader.loadInterface(name);
        }
        return null;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e15) {
        if (this.listener != null) {
            this.listener.error(msg, e15);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e15 != null) {
                e15.printStackTrace();
            }
        }
    }

    public synchronized Set getTemplateNames() {
        return this.templates.keySet();
    }

    public void emitDebugStartStopStrings(boolean emit) {
        this.debugTemplateOutput = emit;
    }

    public void doNotEmitDebugStringsForTemplate(String templateName) {
        if (this.noDebugStartStopStrings == null) {
            this.noDebugStartStopStrings = new HashSet();
        }
        this.noDebugStartStopStrings.add(templateName);
    }

    public void emitTemplateStartDebugString(StringTemplate st4, StringTemplateWriter out) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(st4.getName())) {
            String groupPrefix = "";
            if (!st4.getName().startsWith("if") && !st4.getName().startsWith("else")) {
                groupPrefix = st4.getNativeGroup() != null ? st4.getNativeGroup().getName() + "." : st4.getGroup().getName() + ".";
            }
            out.write("<" + groupPrefix + st4.getName() + ">");
        }
    }

    public void emitTemplateStopDebugString(StringTemplate st4, StringTemplateWriter out) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(st4.getName())) {
            String groupPrefix = "";
            if (!st4.getName().startsWith("if") && !st4.getName().startsWith("else")) {
                groupPrefix = st4.getNativeGroup() != null ? st4.getNativeGroup().getName() + "." : st4.getGroup().getName() + ".";
            }
            out.write("</" + groupPrefix + st4.getName() + ">");
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showTemplatePatterns) {
        StringBuffer buf = new StringBuffer();
        Set templateNameSet = this.templates.keySet();
        ArrayList sortedNames = new ArrayList(templateNameSet);
        Collections.sort(sortedNames);
        Iterator iter = sortedNames.iterator();
        buf.append("group " + this.getName() + ";\n");
        StringTemplate formalArgs = new StringTemplate("$args;separator=\",\"$");
        while (iter.hasNext()) {
            String tname = (String)iter.next();
            StringTemplate st4 = (StringTemplate)this.templates.get(tname);
            if (st4 == NOT_FOUND_ST) continue;
            formalArgs = formalArgs.getInstanceOf();
            formalArgs.setAttribute("args", st4.getFormalArguments());
            buf.append(tname + "(" + formalArgs + ")");
            if (showTemplatePatterns) {
                buf.append(" ::= <<");
                buf.append(st4.getTemplate());
                buf.append(">>\n");
                continue;
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

