/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.SimilarityInput;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public static LevenshteinDistance getDefaultInstance() {
        return INSTANCE;
    }

    private static <E> int limitedCompare(SimilarityInput<E> left, SimilarityInput<E> right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n15 = left.length();
        int m15 = right.length();
        if (n15 == 0) {
            return m15 <= threshold ? m15 : -1;
        }
        if (m15 == 0) {
            return n15 <= threshold ? n15 : -1;
        }
        if (n15 > m15) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n15 = m15;
            m15 = right.length();
        }
        if (m15 - n15 > threshold) {
            return -1;
        }
        int[] p15 = new int[n15 + 1];
        int[] d15 = new int[n15 + 1];
        int boundary = Math.min(n15, threshold) + 1;
        for (int i15 = 0; i15 < boundary; ++i15) {
            p15[i15] = i15;
        }
        Arrays.fill(p15, boundary, p15.length, Integer.MAX_VALUE);
        Arrays.fill(d15, Integer.MAX_VALUE);
        for (int j15 = 1; j15 <= m15; ++j15) {
            int max;
            E rightJ = right.at(j15 - 1);
            d15[0] = j15;
            int min = Math.max(1, j15 - threshold);
            int n16 = max = j15 > Integer.MAX_VALUE - threshold ? n15 : Math.min(n15, j15 + threshold);
            if (min > 1) {
                d15[min - 1] = Integer.MAX_VALUE;
            }
            int lowerBound = Integer.MAX_VALUE;
            for (int i16 = min; i16 <= max; ++i16) {
                d15[i16] = left.at(i16 - 1).equals(rightJ) ? p15[i16 - 1] : 1 + Math.min(Math.min(d15[i16 - 1], p15[i16]), p15[i16 - 1]);
                lowerBound = Math.min(lowerBound, d15[i16]);
            }
            if (lowerBound > threshold) {
                return -1;
            }
            int[] tempD = p15;
            p15 = d15;
            d15 = tempD;
        }
        if (p15[n15] <= threshold) {
            return p15[n15];
        }
        return -1;
    }

    private static <E> int unlimitedCompare(SimilarityInput<E> left, SimilarityInput<E> right) {
        int i15;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n15 = left.length();
        int m15 = right.length();
        if (n15 == 0) {
            return m15;
        }
        if (m15 == 0) {
            return n15;
        }
        if (n15 > m15) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n15 = m15;
            m15 = right.length();
        }
        int[] p15 = new int[n15 + 1];
        for (i15 = 0; i15 <= n15; ++i15) {
            p15[i15] = i15;
        }
        for (int j15 = 1; j15 <= m15; ++j15) {
            int upperLeft = p15[0];
            E rightJ = right.at(j15 - 1);
            p15[0] = j15;
            for (i15 = 1; i15 <= n15; ++i15) {
                int upper = p15[i15];
                int cost = left.at(i15 - 1).equals(rightJ) ? 0 : 1;
                p15[i15] = Math.min(Math.min(p15[i15 - 1] + 1, p15[i15] + 1), upperLeft + cost);
                upperLeft = upper;
            }
        }
        return p15[n15];
    }

    @Deprecated
    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Integer apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

