/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.TokenTypes;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SyntaxScheme
implements Cloneable,
TokenTypes {
    private Style[] styles = new Style[39];
    private static final String VERSION = "*ver1";

    public SyntaxScheme(boolean useDefaults) {
        if (useDefaults) {
            this.restoreDefaults(null);
        }
    }

    public SyntaxScheme(Font baseFont) {
        this(baseFont, true);
    }

    public SyntaxScheme(Font baseFont, boolean fontStyles) {
        this.restoreDefaults(baseFont, fontStyles);
    }

    void changeBaseFont(Font oldFont, Font newFont) {
        for (Style style : this.styles) {
            if (style == null || style.font == null || !style.font.getFamily().equals(oldFont.getFamily()) || style.font.getSize2D() != oldFont.getSize2D()) continue;
            int styleFontStyle = style.font.getStyle();
            style.font = newFont.deriveFont(styleFontStyle);
        }
    }

    public Object clone() {
        SyntaxScheme shcs;
        try {
            shcs = (SyntaxScheme)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
        shcs.styles = new Style[this.styles.length];
        for (int i15 = 0; i15 < this.styles.length; ++i15) {
            Style s15 = this.styles[i15];
            if (s15 == null) continue;
            shcs.styles[i15] = (Style)s15.clone();
        }
        return shcs;
    }

    public boolean equals(Object otherScheme) {
        if (!(otherScheme instanceof SyntaxScheme)) {
            return false;
        }
        Style[] otherSchemes = ((SyntaxScheme)otherScheme).styles;
        int length = this.styles.length;
        for (int i15 = 0; i15 < length; ++i15) {
            if (!(this.styles[i15] == null ? otherSchemes[i15] != null : !this.styles[i15].equals(otherSchemes[i15]))) continue;
            return false;
        }
        return true;
    }

    private static String getHexString(Color c15) {
        return "$" + Integer.toHexString((c15.getRGB() & 0xFFFFFF) + 0x1000000).substring(1);
    }

    public Style getStyle(int index) {
        return this.styles[index];
    }

    public int getStyleCount() {
        return this.styles.length;
    }

    public Style[] getStyles() {
        return this.styles;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Style style : this.styles) {
            if (style == null) continue;
            hashCode ^= style.hashCode();
            break;
        }
        return hashCode;
    }

    public static SyntaxScheme load(Font baseFont, InputStream in4) throws IOException {
        if (baseFont == null) {
            baseFont = RSyntaxTextArea.getDefaultFont();
        }
        return SyntaxSchemeLoader.load(baseFont, in4);
    }

    public static SyntaxScheme loadFromString(String string) {
        return SyntaxScheme.loadFromString(string, 39);
    }

    public static SyntaxScheme loadFromString(String string, int tokenTypeCount) {
        SyntaxScheme scheme = new SyntaxScheme(true);
        try {
            if (string != null) {
                String[] tokens = string.split(",", -1);
                if (tokens.length == 0 || !VERSION.equals(tokens[0])) {
                    return scheme;
                }
                int tokenCount = tokenTypeCount * 7 + 1;
                if (tokens.length != tokenCount) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + tokenCount + ", found " + tokens.length);
                }
                for (int i15 = 0; i15 < tokenTypeCount; ++i15) {
                    int pos = i15 * 7 + 1;
                    int integer = Integer.parseInt(tokens[pos]);
                    if (integer != i15) {
                        throw new Exception("Expected " + i15 + ", found " + integer);
                    }
                    Color fg5 = null;
                    String temp = tokens[pos + 1];
                    if (!"-".equals(temp)) {
                        fg5 = SyntaxScheme.stringToColor(temp);
                    }
                    Color bg5 = null;
                    temp = tokens[pos + 2];
                    if (!"-".equals(temp)) {
                        bg5 = SyntaxScheme.stringToColor(temp);
                    }
                    if (!"t".equals(temp = tokens[pos + 3]) && !"f".equals(temp)) {
                        throw new Exception("Expected 't' or 'f', found " + temp);
                    }
                    boolean underline = "t".equals(temp);
                    Font font = null;
                    String family = tokens[pos + 4];
                    if (!"-".equals(family)) {
                        int style = Integer.parseInt(tokens[pos + 5]);
                        int size = Integer.parseInt(tokens[pos + 6]);
                        HashMap<TextAttribute, String> fontFamilyAttrs = new HashMap<TextAttribute, String>();
                        fontFamilyAttrs.put(TextAttribute.FAMILY, family);
                        font = RSyntaxTextArea.getDefaultFont().deriveFont(fontFamilyAttrs).deriveFont(style, size);
                    }
                    scheme.styles[i15] = new Style(fg5, bg5, font, underline);
                }
            }
        }
        catch (Exception e15) {
            e15.printStackTrace();
        }
        return scheme;
    }

    void refreshFontMetrics(Graphics2D g2d) {
        for (Style s15 : this.styles) {
            if (s15 == null) continue;
            s15.fontMetrics = s15.font == null ? null : g2d.getFontMetrics(s15.font);
        }
    }

    public void restoreDefaults(Font baseFont) {
        this.restoreDefaults(baseFont, true);
    }

    public void restoreDefaults(Font baseFont, boolean fontStyles) {
        Color comment = new Color(0, 128, 0);
        Color docComment = new Color(164, 0, 0);
        Color markupComment = new Color(0, 96, 0);
        Color keyword = Color.BLUE;
        Color dataType = new Color(0, 128, 128);
        Color function = new Color(173, 128, 0);
        Color preprocessor = new Color(128, 128, 128);
        Color operator = new Color(128, 64, 64);
        Color regex = new Color(0, 128, 164);
        Color variable = new Color(255, 153, 0);
        Color literalNumber = new Color(100, 0, 200);
        Color literalString = new Color(220, 0, 156);
        Color error = new Color(148, 148, 0);
        if (baseFont == null) {
            baseFont = RSyntaxTextArea.getDefaultFont();
        }
        Font commentFont = baseFont;
        Font keywordFont = baseFont;
        if (fontStyles) {
            commentFont = baseFont.deriveFont(2);
            keywordFont = baseFont.deriveFont(1);
        }
        this.styles[1] = new Style(comment, null, commentFont);
        this.styles[2] = new Style(comment, null, commentFont);
        this.styles[3] = new Style(docComment, null, commentFont);
        this.styles[4] = new Style(new Color(255, 152, 0), null, commentFont);
        this.styles[5] = new Style(Color.gray, null, commentFont);
        this.styles[6] = new Style(keyword, null, keywordFont);
        this.styles[7] = new Style(keyword, null, keywordFont);
        this.styles[8] = new Style(function);
        this.styles[9] = new Style(literalNumber);
        this.styles[10] = new Style(literalNumber);
        this.styles[11] = new Style(literalNumber);
        this.styles[12] = new Style(literalNumber);
        this.styles[13] = new Style(literalString);
        this.styles[14] = new Style(literalString);
        this.styles[15] = new Style(literalString);
        this.styles[16] = new Style(dataType, null, keywordFont);
        this.styles[17] = new Style(variable);
        this.styles[18] = new Style(regex);
        this.styles[19] = new Style(Color.gray);
        this.styles[20] = new Style(null);
        this.styles[21] = new Style(Color.gray);
        this.styles[22] = new Style(Color.RED);
        this.styles[23] = new Style(operator);
        this.styles[24] = new Style(preprocessor);
        this.styles[25] = new Style(Color.RED);
        this.styles[26] = new Style(Color.BLUE);
        this.styles[27] = new Style(new Color(63, 127, 127));
        this.styles[28] = new Style(literalString);
        this.styles[29] = new Style(markupComment, null, commentFont);
        this.styles[30] = new Style(function);
        this.styles[31] = new Style(preprocessor);
        this.styles[33] = new Style(new Color(0xCC6600));
        this.styles[32] = new Style(new Color(32896));
        this.styles[34] = new Style(dataType);
        this.styles[35] = new Style(error);
        this.styles[36] = new Style(error);
        this.styles[37] = new Style(error);
        this.styles[38] = new Style(error);
        for (int i15 = 0; i15 < this.styles.length; ++i15) {
            if (this.styles[i15] != null) continue;
            this.styles[i15] = new Style();
        }
    }

    public void setStyle(int type, Style style) {
        this.styles[type] = style;
    }

    public void setStyles(Style[] styles) {
        this.styles = styles;
    }

    private static Color stringToColor(String s15) {
        char ch4 = s15.charAt(0);
        return new Color(ch4 == '$' || ch4 == '#' ? Integer.parseInt(s15.substring(1), 16) : Integer.parseInt(s15));
    }

    public String toCommaSeparatedString() {
        StringBuilder sb5 = new StringBuilder(VERSION);
        sb5.append(',');
        for (int i15 = 0; i15 < this.styles.length; ++i15) {
            sb5.append(i15).append(',');
            Style ss4 = this.styles[i15];
            if (ss4 == null) {
                sb5.append("-,-,f,-,,,");
                continue;
            }
            Color c15 = ss4.foreground;
            sb5.append(c15 != null ? SyntaxScheme.getHexString(c15) + "," : "-,");
            c15 = ss4.background;
            sb5.append(c15 != null ? SyntaxScheme.getHexString(c15) + "," : "-,");
            sb5.append(ss4.underline ? "t," : "f,");
            Font font = ss4.font;
            if (font != null) {
                sb5.append(font.getFamily()).append(',').append(font.getStyle()).append(',').append(font.getSize()).append(',');
                continue;
            }
            sb5.append("-,,,");
        }
        return sb5.substring(0, sb5.length() - 1);
    }

    private static class SyntaxSchemeLoader
    extends DefaultHandler {
        private Font baseFont;
        private SyntaxScheme scheme;

        SyntaxSchemeLoader(Font baseFont) {
            this.scheme = new SyntaxScheme(baseFont);
        }

        public static SyntaxScheme load(Font baseFont, InputStream in4) throws IOException {
            SyntaxSchemeLoader parser;
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                parser = new SyntaxSchemeLoader(baseFont);
                parser.baseFont = baseFont;
                reader.setContentHandler(parser);
                InputSource is4 = new InputSource(in4);
                is4.setEncoding("UTF-8");
                reader.parse(is4);
            }
            catch (SAXException se5) {
                throw new IOException(se5.toString());
            }
            return parser.scheme;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if ("style".equals(qName)) {
                Field field;
                String type = attrs.getValue("token");
                try {
                    field = SyntaxScheme.class.getField(type);
                }
                catch (RuntimeException re5) {
                    throw re5;
                }
                catch (Exception e15) {
                    e15.printStackTrace();
                    return;
                }
                if (field.getType() == Integer.TYPE) {
                    String ulineStr;
                    String italicStr;
                    String bgStr;
                    try {
                        int index = field.getInt(this.scheme);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e16) {
                        e16.printStackTrace();
                        return;
                    }
                    String fgStr = attrs.getValue("fg");
                    if (fgStr != null) {
                        Color fg5;
                        ((SyntaxScheme)this.scheme).styles[index].foreground = fg5 = SyntaxScheme.stringToColor(fgStr);
                    }
                    if ((bgStr = attrs.getValue("bg")) != null) {
                        Color bg5;
                        ((SyntaxScheme)this.scheme).styles[index].background = bg5 = SyntaxScheme.stringToColor(bgStr);
                    }
                    boolean styleSpecified = false;
                    boolean bold = false;
                    boolean italic = false;
                    String boldStr = attrs.getValue("bold");
                    if (boldStr != null) {
                        bold = Boolean.parseBoolean(boldStr);
                        styleSpecified = true;
                    }
                    if ((italicStr = attrs.getValue("italic")) != null) {
                        italic = Boolean.parseBoolean(italicStr);
                        styleSpecified = true;
                    }
                    if (styleSpecified) {
                        int style = 0;
                        if (bold) {
                            style |= 1;
                        }
                        if (italic) {
                            style |= 2;
                        }
                        ((SyntaxScheme)this.scheme).styles[index].font = this.baseFont.deriveFont(style);
                    }
                    if ((ulineStr = attrs.getValue("underline")) != null) {
                        boolean uline;
                        ((SyntaxScheme)this.scheme).styles[index].underline = uline = Boolean.parseBoolean(ulineStr);
                    }
                }
            }
        }
    }
}

