/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipWindow;

public class FocusableTip {
    private JTextArea textArea;
    private TipWindow tipWindow;
    private URL imageBase;
    private TextAreaListener textAreaListener;
    private HyperlinkListener hyperlinkListener;
    private String lastText;
    private Dimension maxSize;
    private Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 18;
    private static final int Y_MARGIN = 12;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip");

    public FocusableTip(JTextArea textArea, HyperlinkListener listener) {
        this.setTextArea(textArea);
        this.hyperlinkListener = listener;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    private void computeTipVisibleBounds() {
        Rectangle r15 = this.tipWindow.getBounds();
        Point p15 = r15.getLocation();
        SwingUtilities.convertPointFromScreen(p15, this.textArea);
        r15.setLocation(p15);
        this.tipVisibleBounds.setBounds(r15.x, r15.y - 15, r15.width, r15.height + 30);
    }

    private void createAndShowTipWindow(MouseEvent e15, String text) {
        Window owner = SwingUtilities.getWindowAncestor(this.textArea);
        this.tipWindow = new TipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this.tipWindow);
        }
        this.invokeLater(() -> {
            if (this.tipWindow == null) {
                return;
            }
            this.tipWindow.fixSize();
            ComponentOrientation o15 = this.textArea.getComponentOrientation();
            Point p15 = e15.getPoint();
            SwingUtilities.convertPointToScreen(p15, this.textArea);
            Rectangle sb5 = TipUtil.getScreenBoundsForPoint(p15.x, p15.y);
            int y15 = p15.y + 12;
            if (y15 + this.tipWindow.getHeight() >= sb5.y + sb5.height && (y15 = p15.y - 12 - this.tipWindow.getHeight()) < sb5.y) {
                y15 = sb5.y + 12;
            }
            int x15 = p15.x - 18;
            if (!o15.isLeftToRight()) {
                x15 = p15.x - this.tipWindow.getWidth() + 18;
            }
            if (x15 < sb5.x) {
                x15 = sb5.x;
            } else if (x15 + this.tipWindow.getWidth() > sb5.x + sb5.width) {
                x15 = sb5.x + sb5.width - this.tipWindow.getWidth();
            }
            this.tipWindow.setLocation(x15, y15);
            this.tipWindow.setVisible(true);
            this.computeTipVisibleBounds();
            this.textAreaListener.install(this.textArea);
            this.lastText = text;
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    static String getString(String key) {
        return MSG.getString(key);
    }

    protected void invokeLater(Runnable r15) {
        SwingUtilities.invokeLater(r15);
    }

    public boolean isVisible() {
        return this.tipWindow != null && this.tipWindow.isVisible();
    }

    public boolean possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.textArea.requestFocus();
            return true;
        }
        return false;
    }

    void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    private void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
        ToolTipManager.sharedInstance().registerComponent(textArea);
    }

    public void toolTipRequested(MouseEvent e15, String text) {
        if (text == null || text.isEmpty()) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(e15, text);
        }
    }

    private final class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e15) {
            Object source = e15.getSource();
            if (source == FocusableTip.this.textArea) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e15) {
            this.handleComponentEvent(e15);
        }

        @Override
        public void componentMoved(ComponentEvent e15) {
            this.handleComponentEvent(e15);
        }

        @Override
        public void componentResized(ComponentEvent e15) {
            this.handleComponentEvent(e15);
        }

        @Override
        public void componentShown(ComponentEvent e15) {
            this.handleComponentEvent(e15);
        }

        @Override
        public void focusGained(FocusEvent e15) {
        }

        @Override
        public void focusLost(FocusEvent e15) {
            boolean tipClicked;
            Component c15 = e15.getOppositeComponent();
            boolean bl4 = tipClicked = c15 instanceof TipWindow || c15 != null && SwingUtilities.getWindowAncestor(c15) instanceof TipWindow;
            if (!tipClicked) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        private void handleComponentEvent(ComponentEvent e15) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        protected void install(JTextArea textArea) {
            textArea.addCaretListener(this);
            textArea.addComponentListener(this);
            textArea.addFocusListener(this);
            textArea.addKeyListener(this);
            textArea.addMouseListener(this);
            textArea.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e15) {
            if (e15.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (e15.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed();
                e15.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e15) {
        }

        @Override
        public void keyTyped(KeyEvent e15) {
        }

        @Override
        public void mouseExited(MouseEvent e15) {
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(e15.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        protected void uninstall() {
            FocusableTip.this.textArea.removeCaretListener(this);
            FocusableTip.this.textArea.removeComponentListener(this);
            FocusableTip.this.textArea.removeFocusListener(this);
            FocusableTip.this.textArea.removeKeyListener(this);
            FocusableTip.this.textArea.removeMouseListener(this);
            FocusableTip.this.textArea.removeMouseMotionListener(this);
        }
    }
}

