/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class ChangeableHighlightPainter
extends LayeredHighlighter.LayerPainter
implements Serializable {
    private Paint paint;
    private boolean roundedEdges;
    private transient AlphaComposite alphaComposite;
    private float alpha;
    private static final int ARC_WIDTH = 8;
    private static final int ARC_HEIGHT = 8;

    public ChangeableHighlightPainter() {
        this(null);
    }

    public ChangeableHighlightPainter(Paint paint) {
        this(paint, false);
    }

    public ChangeableHighlightPainter(Paint paint, boolean rounded) {
        this(paint, rounded, 1.0f);
    }

    public ChangeableHighlightPainter(Paint paint, boolean rounded, float alpha) {
        this.setPaint(paint);
        this.setRoundedEdges(rounded);
        this.setAlpha(alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    private AlphaComposite getAlphaComposite() {
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        }
        return this.alphaComposite;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public boolean getRoundedEdges() {
        return this.roundedEdges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g15, int offs0, int offs1, Shape bounds, JTextComponent c15) {
        Rectangle alloc = bounds.getBounds();
        Graphics2D g2d = (Graphics2D)g15;
        Composite originalComposite = null;
        if (this.getAlpha() < 1.0f) {
            originalComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite());
        }
        try {
            TextUI mapper = c15.getUI();
            Rectangle p05 = mapper.modelToView(c15, offs0);
            Rectangle p15 = mapper.modelToView(c15, offs1);
            Paint paint = this.getPaint();
            if (paint == null) {
                g2d.setColor(c15.getSelectionColor());
            } else {
                g2d.setPaint(paint);
            }
            if (p05.y == p15.y) {
                p15.width = 0;
                Rectangle r15 = p05.union(p15);
                g2d.fillRect(r15.x, r15.y, r15.width, r15.height);
            } else {
                int p0ToMarginWidth = alloc.x + alloc.width - p05.x;
                g2d.fillRect(p05.x, p05.y, p0ToMarginWidth, p05.height);
                if (p05.y + p05.height != p15.y) {
                    g2d.fillRect(alloc.x, p05.y + p05.height, alloc.width, p15.y - (p05.y + p05.height));
                }
                g2d.fillRect(alloc.x, p15.y, p15.x - alloc.x, p15.height);
            }
        }
        catch (BadLocationException e15) {
            e15.printStackTrace();
        }
        finally {
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape paintLayer(Graphics g15, int offs0, int offs1, Shape bounds, JTextComponent c15, View view) {
        Paint paint;
        Graphics2D g2d = (Graphics2D)g15;
        Composite originalComposite = null;
        if (this.getAlpha() < 1.0f) {
            originalComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite());
        }
        if ((paint = this.getPaint()) == null) {
            g2d.setColor(c15.getSelectionColor());
        } else {
            g2d.setPaint(paint);
        }
        if (offs0 == offs1) {
            try {
                Shape s15 = view.modelToView(offs0, bounds, Position.Bias.Forward);
                Rectangle r15 = s15.getBounds();
                g15.drawLine(r15.x, r15.y, r15.x, r15.y + r15.height);
                return r15;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            g2d.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
            return alloc;
        }
        try {
            Rectangle r16;
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle rectangle = r16 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.roundedEdges) {
                g2d.fillRoundRect(r16.x, r16.y, r16.width, r16.height, 8, 8);
            } else {
                g2d.fillRect(r16.x, r16.y, r16.width, r16.height);
            }
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
            Rectangle rectangle2 = r16;
            return rectangle2;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        finally {
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream s15) throws ClassNotFoundException, IOException {
        s15.defaultReadObject();
        int rgb = s15.readInt();
        this.paint = rgb == -1 ? null : new Color(rgb);
        this.alphaComposite = null;
    }

    public void setAlpha(float alpha) {
        this.alpha = Math.max(alpha, 0.0f);
        this.alpha = Math.min(1.0f, this.alpha);
        this.alphaComposite = null;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setRoundedEdges(boolean rounded) {
        this.roundedEdges = rounded;
    }

    private void writeObject(ObjectOutputStream s15) throws IOException {
        s15.defaultWriteObject();
        int rgb = -1;
        if (this.paint != null) {
            SystemColor c15 = this.paint instanceof Color ? (Color)this.paint : SystemColor.textHighlight;
            rgb = c15.getRGB();
        }
        s15.writeInt(rgb);
    }
}

