/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler;

import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.ClientImpl;
import shadow.bundletool.com.android.ddmlib.internal.MonitorThread;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;

public final class HandleWait
extends ChunkHandler {
    public static final int CHUNK_WAIT = ChunkHandler.type("WAIT");
    private static final HandleWait mInst = new HandleWait();

    private HandleWait() {
    }

    public static void register(MonitorThread mt4) {
        mt4.registerChunkHandler(CHUNK_WAIT, mInst);
    }

    @Override
    public void clientReady(ClientImpl client) {
    }

    @Override
    public void clientDisconnected(ClientImpl client) {
    }

    @Override
    public void handleChunk(ClientImpl client, int type, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-wait", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_WAIT) {
            assert (!isReply);
            HandleWait.handleWAIT(client, data);
        } else {
            this.handleUnknownChunk(client, type, data, isReply, msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWAIT(ClientImpl client, ByteBuffer data) {
        ClientData cd5;
        byte reason = data.get();
        Log.d("ddm-wait", "WAIT: reason=" + reason);
        ClientData clientData = cd5 = client.getClientData();
        synchronized (clientData) {
            cd5.setDebuggerConnectionStatus(ClientData.DebuggerStatus.WAITING);
        }
        client.update(2);
    }
}

