/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cache;

import java.time.Duration;
import org.keycloak.Config;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.cache.AlternativeLookupProviderFactory;
import org.keycloak.cache.DefaultAlternativeLookupProvider;
import org.keycloak.cache.LocalCache;
import org.keycloak.cache.LocalCacheConfiguration;
import org.keycloak.cache.LocalCacheProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultAlternativeLookupProviderFactory
implements AlternativeLookupProviderFactory {
    private LocalCacheConfiguration<String, String> cacheConfig;
    private LocalCache<String, String> lookupCache;

    public String getId() {
        return "default";
    }

    public AlternativeLookupProvider create(KeycloakSession session) {
        return new DefaultAlternativeLookupProvider(this.lookupCache);
    }

    public void init(Config.Scope config) {
        Integer maximumSize = config.getInt("maximumSize", Integer.valueOf(1000));
        Integer expireAfter = config.getInt("expireAfter", Integer.valueOf(60));
        this.cacheConfig = LocalCacheConfiguration.builder().name("lookup").expiration(Duration.ofMinutes(expireAfter.intValue())).maxSize(maximumSize.intValue()).build();
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.lookupCache = ((LocalCacheProvider)session.getProvider(LocalCacheProvider.class)).create(this.cacheConfig);
            this.cacheConfig = null;
        }
    }

    public void close() {
        if (this.lookupCache != null) {
            this.lookupCache.close();
            this.lookupCache = null;
        }
    }
}

