/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeStatementMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "saml-user-attribute-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Map a custom user attribute to a SAML attribute.";
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        boolean aggregateAttrs;
        String attributeName;
        UserModel user = userSession.getUser();
        Collection attributeValues = KeycloakModelUtils.resolveAttribute((UserModel)user, (String)(attributeName = (String)mappingModel.getConfig().get("user.attribute")), (boolean)(aggregateAttrs = Boolean.valueOf((String)mappingModel.getConfig().get("aggregate.attrs")).booleanValue()));
        if (attributeValues.isEmpty()) {
            return;
        }
        AttributeStatementHelper.addAttributes(attributeStatement, mappingModel, attributeValues);
    }

    public static ProtocolMapperModel createAttributeMapper(String name, String userAttribute, String samlAttributeName, String nameFormat, String friendlyName) {
        String mapperId = PROVIDER_ID;
        return AttributeStatementHelper.createAttributeMapper(name, userAttribute, samlAttributeName, nameFormat, friendlyName, mapperId);
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.attribute");
        property.setLabel("usermodel.attr.label");
        property.setHelpText("usermodel.attr.tooltip");
        property.setType("UserProfileAttributeList");
        property.setRequired(Boolean.TRUE.booleanValue());
        configProperties.add(property);
        AttributeStatementHelper.setConfigProperties(configProperties);
        property = new ProviderConfigProperty();
        property.setName("aggregate.attrs");
        property.setLabel("aggregate.attrs.label");
        property.setHelpText("aggregate.attrs.tooltip");
        property.setType("boolean");
        configProperties.add(property);
    }
}

