/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.ssl;

import io.grpc.BindableService;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.PortsRange;
import org.opensearch.plugins.SecureAuxTransportSettingsProvider;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.grpc.Netty4GrpcServerTransport;

public class SecureNetty4GrpcServerTransport
extends Netty4GrpcServerTransport {
    private static final String[] DEFAULT_SSL_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1"};
    public static final String GRPC_SECURE_TRANSPORT_SETTING_KEY = "secure-transport-grpc";
    public static final Setting<PortsRange> SETTING_GRPC_SECURE_PORT = AUX_TRANSPORT_PORT.getConcreteSettingForNamespace("secure-transport-grpc");

    public SecureNetty4GrpcServerTransport(Settings settings, List<BindableService> services, NetworkService networkService, ThreadPool threadPool, SecureAuxTransportSettingsProvider secureTransportSettingsProvider) {
        super(settings, services, networkService, threadPool);
        this.port = (PortsRange)SETTING_GRPC_SECURE_PORT.get(settings);
        this.portSettingKey = SETTING_GRPC_SECURE_PORT.getKey();
        try {
            JdkSslContext ctxt = this.getSslContext(settings, secureTransportSettingsProvider);
            this.addServerConfig(builder -> builder.sslContext((SslContext)ctxt));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build SslContext for " + SecureNetty4GrpcServerTransport.class.getName(), e);
        }
    }

    @Override
    public String settingKey() {
        return GRPC_SECURE_TRANSPORT_SETTING_KEY;
    }

    private JdkSslContext getSslContext(Settings settings, SecureAuxTransportSettingsProvider provider) throws SSLException {
        Optional<SSLContext> sslContext = provider.buildSecureAuxServerTransportContext(settings, this.settingKey());
        if (sslContext.isEmpty()) {
            try {
                sslContext = Optional.of(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLException("Failed to build default SSLContext for " + SecureNetty4GrpcServerTransport.class.getName(), e);
            }
        }
        SecureAuxTransportSettingsProvider.SecureAuxTransportParameters params = provider.parameters(settings, this.settingKey()).orElseGet(DefaultParameters::new);
        ClientAuth clientAuth = ClientAuth.valueOf((String)((String)params.clientAuth().orElseThrow()).toUpperCase(Locale.ROOT));
        return new JdkSslContext(sslContext.get(), false, (Iterable)params.cipherSuites(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}), clientAuth, DEFAULT_SSL_PROTOCOLS, true);
    }

    private static class DefaultParameters
    implements SecureAuxTransportSettingsProvider.SecureAuxTransportParameters {
        private DefaultParameters() {
        }

        public Optional<String> clientAuth() {
            return Optional.of(ClientAuth.REQUIRE.name());
        }

        public Collection<String> cipherSuites() {
            return List.of();
        }
    }
}

