/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.global;

import java.io.IOException;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.global.GlobalAggregator;
import org.opensearch.search.internal.SearchContext;

public class GlobalAggregatorFactory
extends AggregatorFactory {
    public GlobalAggregatorFactory(String name, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (parent != null) {
            throw new AggregationExecutionException("Aggregation [" + parent.name() + "] cannot have a global sub-aggregation [" + this.name + "]. Global aggregations can only be defined as top level aggregations");
        }
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new AggregationExecutionException("Aggregation [" + this.name() + "] must have cardinality 1 but was [" + String.valueOf(cardinality) + "]");
        }
        return new GlobalAggregator(this.name, this.factories, searchContext, metadata);
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

