/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.Numbers;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnsignedLongTerms;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.streaming.Streamable;
import org.opensearch.search.streaming.StreamingCostMetrics;

public class StreamNumericTermsAggregator
extends TermsAggregator
implements Streamable {
    private final ResultStrategy<?, ?> resultStrategy;
    private final ValuesSource.Numeric valuesSource;
    private final IncludeExclude.LongFilter longFilter;
    private LongKeyedBucketOrds bucketOrds;
    private final CardinalityUpperBound cardinality;

    public StreamNumericTermsAggregator(String name, AggregatorFactories factories, Function<StreamNumericTermsAggregator, ResultStrategy<?, ?>> resultStrategy, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, IncludeExclude.LongFilter longFilter, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, bucketCountThresholds, order, format, subAggCollectMode, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.longFilter = longFilter;
        this.cardinality = cardinality;
    }

    @Override
    public void doReset() {
        super.doReset();
        Releasables.close((Releasable)this.bucketOrds);
        this.bucketOrds = null;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.bucketOrds != null) {
            this.bucketOrds.close();
        }
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), this.cardinality);
        final SortedNumericDocValues values = this.resultStrategy.getValues(ctx);
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        if (StreamNumericTermsAggregator.this.longFilter == null || StreamNumericTermsAggregator.this.longFilter.accept(val)) {
                            long bucketOrdinal = StreamNumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, val);
                            if (bucketOrdinal < 0L) {
                                bucketOrdinal = -1L - bucketOrdinal;
                                StreamNumericTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                            } else {
                                StreamNumericTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                            }
                        }
                        previous = val;
                    }
                }
            }
        });
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregationsBatch(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("total_buckets", this.bucketOrds == null ? 0L : this.bucketOrds.size());
        StreamingCostMetrics metrics = this.getStreamingCostMetrics();
        add.accept("streaming_enabled", metrics.streamable());
        add.accept("streaming_top_n_size", metrics.topNSize());
        add.accept("streaming_estimated_buckets", metrics.estimatedBucketCount());
        add.accept("streaming_estimated_docs", metrics.estimatedDocCount());
        add.accept("streaming_segment_count", metrics.segmentCount());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{() -> super.doClose(), this.bucketOrds, this.resultStrategy});
    }

    @Override
    public StreamingCostMetrics getStreamingCostMetrics() {
        try {
            MappedFieldType mappedFieldType;
            String fieldName = this.valuesSource.getIndexFieldName();
            long totalDocsWithField = PointValues.size((IndexReader)this.context.searcher().getIndexReader(), (String)fieldName);
            int segmentCount = this.context.searcher().getIndexReader().leaves().size();
            if (totalDocsWithField == 0L) {
                return new StreamingCostMetrics(true, this.bucketCountThresholds.getShardSize(), 0L, segmentCount, 0L);
            }
            MappedFieldType fieldType = this.context.getQueryShardContext().fieldMapper(fieldName);
            if (fieldType == null || !((mappedFieldType = fieldType.unwrap()) instanceof NumberFieldMapper.NumberFieldType)) {
                return StreamingCostMetrics.nonStreamable();
            }
            NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)mappedFieldType;
            Number minPoint = numberFieldType.parsePoint(PointValues.getMinPackedValue((IndexReader)this.context.searcher().getIndexReader(), (String)fieldName));
            Number maxPoint = numberFieldType.parsePoint(PointValues.getMaxPackedValue((IndexReader)this.context.searcher().getIndexReader(), (String)fieldName));
            ResultStrategy<?, ?> resultStrategy = this.resultStrategy;
            int n = 0;
            long maxCardinality = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LongTermsResults.class, DoubleTermsResults.class, UnsignedLongTermsResults.class}, resultStrategy, n)) {
                case 0 -> {
                    LongTermsResults ignored = (LongTermsResults)resultStrategy;
                    long min = minPoint.longValue();
                    long max = maxPoint.longValue();
                    yield Math.max(1L, max - min + 1L);
                }
                case 1 -> {
                    DoubleTermsResults ignored = (DoubleTermsResults)resultStrategy;
                    double min = minPoint.doubleValue();
                    double max = maxPoint.doubleValue();
                    yield Math.max(1L, Math.min((long)(max - min + 1.0), totalDocsWithField));
                }
                case 2 -> {
                    UnsignedLongTermsResults ignored = (UnsignedLongTermsResults)resultStrategy;
                    long min = minPoint.longValue();
                    long max = maxPoint.longValue();
                    yield Math.max(1L, max - min + 1L);
                }
                default -> 1L;
            };
            return new StreamingCostMetrics(true, this.bucketCountThresholds.getShardSize(), maxCardinality, segmentCount, totalDocsWithField);
        }
        catch (IOException e) {
            return StreamingCostMetrics.nonStreamable();
        }
    }

    public abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        private InternalAggregation[] buildAggregationsBatch(long[] owningBucketOrds) throws IOException {
            if (StreamNumericTermsAggregator.this.bucketOrds == null) {
                InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    results[ordIdx] = this.buildEmptyResult();
                }
                return results;
            }
            LocalBucketCountThresholds localBucketCountThresholds = StreamNumericTermsAggregator.this.context.asLocalBucketCountThresholds(StreamNumericTermsAggregator.this.bucketCountThresholds);
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCounts = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                StreamNumericTermsAggregator.this.checkCancelled();
                this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
                LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = StreamNumericTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
                ArrayList<B> bucketsPerOwningOrd = new ArrayList<B>();
                while (ordsEnum.next()) {
                    long docCount = StreamNumericTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                    int n = ordIdx;
                    otherDocCounts[n] = otherDocCounts[n] + docCount;
                    if (docCount < localBucketCountThresholds.getMinDocCount()) continue;
                    B finalBucket = this.buildFinalBucket(ordsEnum, docCount, owningBucketOrds[ordIdx]);
                    bucketsPerOwningOrd.add(finalBucket);
                }
                topBucketsPerOrd[ordIdx] = this.buildBuckets(bucketsPerOwningOrd.size());
                for (int i = 0; i < topBucketsPerOrd[ordIdx].length; ++i) {
                    topBucketsPerOrd[ordIdx][i] = (InternalMultiBucketAggregation.InternalBucket)bucketsPerOwningOrd.get(i);
                }
            }
            this.buildSubAggs(topBucketsPerOrd);
            InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
            }
            return result;
        }

        abstract String describe();

        abstract SortedNumericDocValues getValues(LeafReaderContext var1) throws IOException;

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract void collectZeroDocEntriesIfNeeded(long var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract B buildFinalBucket(LongKeyedBucketOrds.BucketOrdsEnum var1, long var2, long var4) throws IOException;
    }

    public class LongTermsResults
    extends StandardTermsResultStrategy<LongTerms, LongTerms.Bucket> {
        public LongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "stream_long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return StreamNumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        LongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new LongTerms.Bucket[size][];
        }

        LongTerms.Bucket[] buildBuckets(int size) {
            return new LongTerms.Bucket[size];
        }

        LongTerms buildResult(long owningBucketOrd, long otherDocCount, LongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new LongTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        LongTerms buildEmptyResult() {
            return new LongTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        LongTerms.Bucket buildFinalBucket(LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount, long owningBucketOrd) {
            LongTerms.Bucket result = new LongTerms.Bucket(ordsEnum.value(), docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ordsEnum.ord();
            result.setDocCountError(0L);
            return result;
        }
    }

    public class DoubleTermsResults
    extends StandardTermsResultStrategy<DoubleTerms, DoubleTerms.Bucket> {
        public DoubleTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "stream_double_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return FieldData.toSortableLongBits(StreamNumericTermsAggregator.this.valuesSource.doubleValues(ctx));
        }

        DoubleTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new DoubleTerms.Bucket[size][];
        }

        DoubleTerms.Bucket[] buildBuckets(int size) {
            return new DoubleTerms.Bucket[size];
        }

        DoubleTerms buildResult(long owningBucketOrd, long otherDocCount, DoubleTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new DoubleTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        DoubleTerms buildEmptyResult() {
            return new DoubleTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        DoubleTerms.Bucket buildFinalBucket(LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount, long owningBucketOrd) {
            DoubleTerms.Bucket result = new DoubleTerms.Bucket(NumericUtils.sortableLongToDouble((long)ordsEnum.value()), docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ordsEnum.ord();
            result.setDocCountError(0L);
            return result;
        }
    }

    public class UnsignedLongTermsResults
    extends StandardTermsResultStrategy<UnsignedLongTerms, UnsignedLongTerms.Bucket> {
        public UnsignedLongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "stream_unsigned_long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return StreamNumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        UnsignedLongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new UnsignedLongTerms.Bucket[size][];
        }

        UnsignedLongTerms.Bucket[] buildBuckets(int size) {
            return new UnsignedLongTerms.Bucket[size];
        }

        UnsignedLongTerms buildResult(long owningBucketOrd, long otherDocCount, UnsignedLongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new UnsignedLongTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        UnsignedLongTerms buildEmptyResult() {
            return new UnsignedLongTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        UnsignedLongTerms.Bucket buildFinalBucket(LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount, long owningBucketOrd) {
            UnsignedLongTerms.Bucket result = new UnsignedLongTerms.Bucket(Numbers.toUnsignedBigInteger((long)ordsEnum.value()), docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ordsEnum.ord();
            result.setDocCountError(0L);
            return result;
        }
    }

    abstract class StandardTermsResultStrategy<R extends InternalMappedTerms<R, B>, B extends InternalTerms.Bucket<B>>
    extends ResultStrategy<R, B> {
        protected final boolean showTermDocCountError;

        StandardTermsResultStrategy(boolean showTermDocCountError) {
            this.showTermDocCountError = showTermDocCountError;
        }

        @Override
        final LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        final void buildSubAggs(B[][] topBucketsPerOrd) throws IOException {
            StreamNumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        final void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
            if (StreamNumericTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(StreamNumericTermsAggregator.this.order) && StreamNumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)StreamNumericTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : StreamNumericTermsAggregator.this.context.searcher().getTopReaderContext().leaves()) {
                SortedNumericDocValues values = this.getValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int v = 0; v < valueCount; ++v) {
                        long value = values.nextValue();
                        if (StreamNumericTermsAggregator.this.longFilter != null && !StreamNumericTermsAggregator.this.longFilter.accept(value)) continue;
                        StreamNumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, value);
                    }
                }
            }
        }

        public final void close() {
        }
    }
}

