/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.NormalizationPhaseResultsProcessor;
import org.opensearch.client.opensearch.search_pipeline.PhaseResultsProcessorVariant;
import org.opensearch.client.opensearch.search_pipeline.ScoreRankerPhaseResultsProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class PhaseResultsProcessor
implements TaggedUnion<Kind, PhaseResultsProcessorVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final PhaseResultsProcessorVariant _value;
    public static final JsonpDeserializer<PhaseResultsProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PhaseResultsProcessor::setupPhaseResultsProcessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final PhaseResultsProcessorVariant _get() {
        return this._value;
    }

    public PhaseResultsProcessor(PhaseResultsProcessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._phaseResultsProcessorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private PhaseResultsProcessor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static PhaseResultsProcessor of(Function<Builder, ObjectBuilder<PhaseResultsProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isNormalizationProcessor() {
        return this._kind == Kind.NormalizationProcessor;
    }

    public NormalizationPhaseResultsProcessor normalizationProcessor() {
        return (NormalizationPhaseResultsProcessor)TaggedUnionUtils.get(this, Kind.NormalizationProcessor);
    }

    public boolean isScoreRankerProcessor() {
        return this._kind == Kind.ScoreRankerProcessor;
    }

    public ScoreRankerPhaseResultsProcessor scoreRankerProcessor() {
        return (ScoreRankerPhaseResultsProcessor)TaggedUnionUtils.get(this, Kind.ScoreRankerProcessor);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPhaseResultsProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::normalizationProcessor, NormalizationPhaseResultsProcessor._DESERIALIZER, "normalization-processor");
        op.add(Builder::scoreRankerProcessor, ScoreRankerPhaseResultsProcessor._DESERIALIZER, "score-ranker-processor");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseResultsProcessor other = (PhaseResultsProcessor)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PhaseResultsProcessor> {
        private Kind _kind;
        private PhaseResultsProcessorVariant _value;

        public Builder() {
        }

        private Builder(PhaseResultsProcessor o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<PhaseResultsProcessor> normalizationProcessor(NormalizationPhaseResultsProcessor v) {
            this._kind = Kind.NormalizationProcessor;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PhaseResultsProcessor> normalizationProcessor(Function<NormalizationPhaseResultsProcessor.Builder, ObjectBuilder<NormalizationPhaseResultsProcessor>> fn) {
            return this.normalizationProcessor(fn.apply(new NormalizationPhaseResultsProcessor.Builder()).build());
        }

        public ObjectBuilder<PhaseResultsProcessor> scoreRankerProcessor(ScoreRankerPhaseResultsProcessor v) {
            this._kind = Kind.ScoreRankerProcessor;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PhaseResultsProcessor> scoreRankerProcessor(Function<ScoreRankerPhaseResultsProcessor.Builder, ObjectBuilder<ScoreRankerPhaseResultsProcessor>> fn) {
            return this.scoreRankerProcessor(fn.apply(new ScoreRankerPhaseResultsProcessor.Builder()).build());
        }

        @Override
        public PhaseResultsProcessor build() {
            this._checkSingleUse();
            return new PhaseResultsProcessor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        NormalizationProcessor("normalization-processor"),
        ScoreRankerProcessor("score-ranker-processor");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

