/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class HkdfInput {
    public DigestAlgorithm _digestAlgorithm;
    public Option<DafnySequence<? extends Byte>> _salt;
    public DafnySequence<? extends Byte> _ikm;
    public DafnySequence<? extends Byte> _info;
    public int _expectedLength;
    private static final TypeDescriptor<HkdfInput> _TYPE = TypeDescriptor.referenceWithInitializer(HkdfInput.class, () -> HkdfInput.Default());
    private static final HkdfInput theDefault = HkdfInput.create(DigestAlgorithm.Default(), Option.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor())), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), 0);

    public HkdfInput(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> info, int expectedLength) {
        this._digestAlgorithm = digestAlgorithm;
        this._salt = salt;
        this._ikm = ikm;
        this._info = info;
        this._expectedLength = expectedLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HkdfInput o = (HkdfInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._salt, o._salt) && Objects.equals(this._ikm, o._ikm) && Objects.equals(this._info, o._info) && this._expectedLength == o._expectedLength;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._salt);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._ikm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._info);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._expectedLength);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.HkdfInput.HkdfInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._salt));
        s.append(", ");
        s.append(Helpers.toString(this._ikm));
        s.append(", ");
        s.append(Helpers.toString(this._info));
        s.append(", ");
        s.append(this._expectedLength);
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<HkdfInput> _typeDescriptor() {
        return _TYPE;
    }

    public static HkdfInput Default() {
        return theDefault;
    }

    public static HkdfInput create(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> info, int expectedLength) {
        return new HkdfInput(digestAlgorithm, salt, ikm, info, expectedLength);
    }

    public static HkdfInput create_HkdfInput(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> info, int expectedLength) {
        return HkdfInput.create(digestAlgorithm, salt, ikm, info, expectedLength);
    }

    public boolean is_HkdfInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public Option<DafnySequence<? extends Byte>> dtor_salt() {
        return this._salt;
    }

    public DafnySequence<? extends Byte> dtor_ikm() {
        return this._ikm;
    }

    public DafnySequence<? extends Byte> dtor_info() {
        return this._info;
    }

    public int dtor_expectedLength() {
        return this._expectedLength;
    }
}

