/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import org.bouncycastle.crypto.Digest;
import org.cryptacular.CryptUtil;
import org.cryptacular.spec.Spec;
import org.cryptacular.util.HashUtil;

public abstract class AbstractHashBean {
    private final Spec<Digest> digestSpec;
    private final int iterations;

    public AbstractHashBean(Spec<Digest> digestSpec) {
        this(digestSpec, 1);
    }

    public AbstractHashBean(Spec<Digest> digestSpec, int iterations) {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be positive");
        }
        this.digestSpec = CryptUtil.assertNotNullArg(digestSpec, "Digest spec cannot be null");
        this.iterations = iterations;
    }

    public Spec<Digest> getDigestSpec() {
        return this.digestSpec;
    }

    public int getIterations() {
        return this.iterations;
    }

    protected byte[] hashInternal(Object ... data) {
        return HashUtil.hash(this.digestSpec.newInstance(), this.iterations, data);
    }

    protected boolean compareInternal(byte[] hash, Object ... data) {
        return HashUtil.compareHash(this.digestSpec.newInstance(), hash, this.iterations, data);
    }
}

