/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.reactor.IOWorkerSelector;
import org.apache.hc.core5.reactor.IOWorkerStats;

final class IOWorkerSelectors {
    IOWorkerSelectors() {
    }

    static IOWorkerSelector newSelector(int workerCount, int start) {
        return IOWorkerSelectors.isPowerOfTwo(workerCount) ? new PowerOfTwoSelector(start) : new GenericSelector(start);
    }

    static IOWorkerSelector newSelector(int workerCount) {
        return IOWorkerSelectors.newSelector(workerCount, 0);
    }

    static boolean isPowerOfTwo(int n) {
        return (n & -n) == n;
    }

    static final class GenericSelector
    implements IOWorkerSelector {
        private final AtomicInteger idx;

        GenericSelector(int n) {
            this.idx = new AtomicInteger(n);
        }

        @Override
        public int select(IOWorkerStats[] dispatchers) {
            return (this.idx.getAndIncrement() & Integer.MAX_VALUE) % dispatchers.length;
        }
    }

    static final class PowerOfTwoSelector
    implements IOWorkerSelector {
        private final AtomicInteger idx;

        PowerOfTwoSelector(int n) {
            this.idx = new AtomicInteger(n);
        }

        @Override
        public int select(IOWorkerStats[] dispatchers) {
            return this.idx.getAndIncrement() & dispatchers.length - 1;
        }
    }
}

