/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlNode;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public abstract class RexWindowBound {
    @Deprecated
    public static RexWindowBound create(SqlNode node, RexNode rexNode) {
        return RexWindowBounds.create(node, rexNode);
    }

    @Pure
    @EnsuresNonNullIf(expression={"getOffset()"}, result=false)
    public boolean isUnbounded() {
        return false;
    }

    public final boolean isUnboundedPreceding() {
        return this.isUnbounded() && this.isPreceding();
    }

    public final boolean isUnboundedFollowing() {
        return this.isUnbounded() && this.isFollowing();
    }

    public boolean isPreceding() {
        return false;
    }

    public boolean isFollowing() {
        return false;
    }

    @Pure
    @EnsuresNonNullIf(expression={"getOffset()"}, result=false)
    public boolean isCurrentRow() {
        return false;
    }

    @Pure
    public @Nullable RexNode getOffset() {
        return null;
    }

    public int getOrderKey() {
        return -1;
    }

    public <R> RexWindowBound accept(RexVisitor<R> visitor) {
        return this;
    }

    public <R, P> RexWindowBound accept(RexBiVisitor<R, P> visitor, P arg) {
        return this;
    }

    public int nodeCount() {
        return 1;
    }
}

