/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MeasureScope
extends DelegatingScope {
    private final SqlSelect select;
    private final List<String> aliasList;
    private final Set<Integer> activeOrdinals = new HashSet<Integer>();

    MeasureScope(SqlValidatorScope selectScope, SqlSelect select) {
        super(selectScope);
        this.select = select;
        ArrayList<String> aliasList = new ArrayList<String>();
        for (SqlNode selectItem : select.getSelectList()) {
            aliasList.add(SqlValidatorUtil.alias(selectItem, aliasList.size()));
        }
        this.aliasList = ImmutableList.copyOf(aliasList);
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.extendedExpandGroupBy(expr, this, this.select);
        this.parent.validateExpr(expanded);
    }

    @Override
    public @Nullable RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlNameMatcher matcher = this.validator.getCatalogReader().nameMatcher();
        int aliasOrdinal = matcher.indexOf(this.aliasList, name);
        if (aliasOrdinal >= 0) {
            SqlNode selectItem = this.select.getSelectList().get(aliasOrdinal);
            SqlNode measure = SqlValidatorUtil.getMeasure(selectItem);
            if (measure != null) {
                try {
                    if (this.activeOrdinals.add(aliasOrdinal)) {
                        RelDataType relDataType = this.validator.deriveType(this, measure);
                        return relDataType;
                    }
                    String dependentMeasures = this.activeOrdinals.stream().map(this.aliasList::get).map(s -> "'" + s + "'").collect(Collectors.joining(", "));
                    throw this.validator.newValidationError(ctx, Static.RESOURCE.measureIsCyclic(name, dependentMeasures));
                }
                finally {
                    this.activeOrdinals.remove(aliasOrdinal);
                }
            }
            SqlNode expression = SqlUtil.stripAs(selectItem);
            return this.validator.deriveType(this.parent, expression);
        }
        return super.resolveColumn(name, ctx);
    }

    public @Nullable SqlNode lookupMeasure(String name) {
        SqlNameMatcher matcher = this.validator.getCatalogReader().nameMatcher();
        int aliasOrdinal = matcher.indexOf(this.aliasList, name);
        if (aliasOrdinal >= 0) {
            SqlNode selectItem = this.select.getSelectList().get(aliasOrdinal);
            @Nullable SqlNode measure = SqlValidatorUtil.getMeasure(selectItem);
            if (measure != null) {
                return measure;
            }
            return SqlUtil.stripAs(selectItem);
        }
        return null;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        SqlQualified qualified;
        if (identifier.isSimple() && (qualified = this.qualifyUsingAlias(this.select, identifier)) != null) {
            return qualified;
        }
        return super.fullyQualify(identifier);
    }
}

