from allauth.socialaccount import app_settings
from allauth.socialaccount.adapter import get_adapter
from allauth.socialaccount.providers.oauth2.views import (
    OAuth2Adapter,
    OAuth2CallbackView,
    OAuth2LoginView,
)


class GumroadOAuth2Adapter(OAuth2Adapter):
    provider_id = "gumroad"

    settings = app_settings.PROVIDERS.get(provider_id, {})
    provider_base_url = settings.get("GUMROAD_URL")
    access_token_url = f"{provider_base_url}/oauth/token"
    authorize_url = f"{provider_base_url}/oauth/authorize"
    profile_url = "https://api.gumroad.com/v2/user"

    def complete_login(self, request, app, token, response):
        with get_adapter().get_requests_session() as sess:
            resp = sess.get(self.profile_url, params={"access_token": token.token})
            resp.raise_for_status()
            extra_data = resp.json()

        return self.get_provider().sociallogin_from_response(
            request, extra_data["user"]
        )


oauth2_login = OAuth2LoginView.adapter_view(GumroadOAuth2Adapter)
oauth2_callback = OAuth2CallbackView.adapter_view(GumroadOAuth2Adapter)
