
# 13 "plugins/ssrmatching/g_ssrmatching.mlg"
 

open Ltac_plugin
open Procq.Constr
open Ssrmatching
open Ssrmatching.Internal

(* Defining grammar rules with "xx" in it automatically declares keywords too,
 * we thus save the lexer to restore it at the end of the file *)
let frozen_lexer = ref None ;;
let () = Mltop.add_init_function "rocq-runtime.plugins.ssreflect" (fun () ->
    frozen_lexer := Some (Procq.freeze ()))


# 18 "plugins/ssrmatching/g_ssrmatching.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ssrmatching"

# 30 "plugins/ssrmatching/g_ssrmatching.mlg"
 

let pr_rpattern _ _ _ = pr_rpattern


# 28 "plugins/ssrmatching/g_ssrmatching.ml"

let (wit_rpattern, rpattern) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssrmatching" ~name:"rpattern" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                        ([(Procq.Production.make
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.nterm lconstr)))
                                                               ((Procq.Symbol.token (Procq.terminal "as"))))
                                                              ((Procq.Symbol.nterm lconstr)))
                                                             ((Procq.Symbol.token (Procq.terminal "in"))))
                                                            ((Procq.Symbol.nterm lconstr)))
                                                           (fun c _ x _ e
                                                           loc -> 
# 51 "plugins/ssrmatching/g_ssrmatching.mlg"
      mk_rpattern (E_As_X_In_T (mk_lterm e None, mk_lterm x None, mk_lterm c None)) 
# 49 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.next
                                                               (Procq.Rule.stop)
                                                               ((Procq.Symbol.nterm lconstr)))
                                                              ((Procq.Symbol.token (Procq.terminal "in"))))
                                                             ((Procq.Symbol.nterm lconstr)))
                                                            ((Procq.Symbol.token (Procq.terminal "in"))))
                                                           ((Procq.Symbol.nterm lconstr)))
                                                          (fun c _ x _ e
                                                          loc -> 
# 49 "plugins/ssrmatching/g_ssrmatching.mlg"
      mk_rpattern (E_In_X_In_T (mk_lterm e None, mk_lterm x None, mk_lterm c None)) 
# 67 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.stop)
                                                              ((Procq.Symbol.token (Procq.terminal "in"))))
                                                             ((Procq.Symbol.nterm lconstr)))
                                                            ((Procq.Symbol.token (Procq.terminal "in"))))
                                                           ((Procq.Symbol.nterm lconstr)))
                                                          (fun c _ x _ loc ->
                                                          
# 47 "plugins/ssrmatching/g_ssrmatching.mlg"
      mk_rpattern (In_X_In_T (mk_lterm x None, mk_lterm c None)) 
# 83 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.stop)
                                                             ((Procq.Symbol.nterm lconstr)))
                                                            ((Procq.Symbol.token (Procq.terminal "in"))))
                                                           ((Procq.Symbol.nterm lconstr)))
                                                          (fun c _ x loc -> 
# 45 "plugins/ssrmatching/g_ssrmatching.mlg"
      mk_rpattern (X_In_T (mk_lterm x None, mk_lterm c None)) 
# 96 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.next
                                                            (Procq.Rule.stop)
                                                            ((Procq.Symbol.token (Procq.terminal "in"))))
                                                           ((Procq.Symbol.nterm lconstr)))
                                                          (fun c _ loc -> 
# 43 "plugins/ssrmatching/g_ssrmatching.mlg"
                             mk_rpattern (In_T (mk_lterm c None)) 
# 107 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.stop)
                                                           ((Procq.Symbol.nterm lconstr)))
                                                          (fun c loc -> 
# 42 "plugins/ssrmatching/g_ssrmatching.mlg"
                        mk_rpattern (T (mk_lterm c None)) 
# 116 "plugins/ssrmatching/g_ssrmatching.ml"
))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.val_tag (Genarg.topwit wit_rpatternty));
                               Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                       
# 40 "plugins/ssrmatching/g_ssrmatching.mlg"
                  glob_rpattern 
# 124 "plugins/ssrmatching/g_ssrmatching.ml"
));
                               Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                      
# 41 "plugins/ssrmatching/g_ssrmatching.mlg"
                   subst_rpattern 
# 130 "plugins/ssrmatching/g_ssrmatching.ml"
);
                               Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                       
# 39 "plugins/ssrmatching/g_ssrmatching.mlg"
                   interp_rpattern 
# 136 "plugins/ssrmatching/g_ssrmatching.ml"
);
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 38 "plugins/ssrmatching/g_ssrmatching.mlg"
               pr_rpattern 
# 142 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                        
# 38 "plugins/ssrmatching/g_ssrmatching.mlg"
               pr_rpattern 
# 147 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                        
# 38 "plugins/ssrmatching/g_ssrmatching.mlg"
               pr_rpattern 
# 152 "plugins/ssrmatching/g_ssrmatching.ml"
));
                               }
let _ = (wit_rpattern, rpattern)


# 54 "plugins/ssrmatching/g_ssrmatching.mlg"
 

let pr_ssrterm _ _ _ = pr_ssrterm


# 164 "plugins/ssrmatching/g_ssrmatching.ml"

let (wit_cpattern, cpattern) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssrmatching" ~name:"cpattern" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                        ([(Procq.Production.make
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.stop)
                                                             ((Procq.Symbol.token (Procq.terminal "Qed"))))
                                                            ((Procq.Symbol.nterm constr)))
                                                           (fun c _ loc -> 
# 66 "plugins/ssrmatching/g_ssrmatching.mlg"
                           mk_lterm c None 
# 178 "plugins/ssrmatching/g_ssrmatching.ml"
))]);
                               Tacentries.arg_tag = None;
                               Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                       
# 63 "plugins/ssrmatching/g_ssrmatching.mlg"
                     glob_cpattern 
# 185 "plugins/ssrmatching/g_ssrmatching.ml"
));
                               Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                      
# 63 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                      subst_ssrterm 
# 191 "plugins/ssrmatching/g_ssrmatching.ml"
);
                               Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                       
# 62 "plugins/ssrmatching/g_ssrmatching.mlg"
                      interp_ssrterm 
# 197 "plugins/ssrmatching/g_ssrmatching.ml"
);
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 64 "plugins/ssrmatching/g_ssrmatching.mlg"
                      pr_ssrterm 
# 203 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                        
# 65 "plugins/ssrmatching/g_ssrmatching.mlg"
                       pr_ssrterm 
# 208 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                        
# 61 "plugins/ssrmatching/g_ssrmatching.mlg"
                  pr_ssrterm 
# 213 "plugins/ssrmatching/g_ssrmatching.ml"
));
                               }
let _ = (wit_cpattern, cpattern)


# 69 "plugins/ssrmatching/g_ssrmatching.mlg"
 

let input_ssrtermkind kwstate strm = match Gramlib.LStream.peek_nth kwstate 0 strm with
  | Tok.KEYWORD "(" -> InParens
  | Tok.KEYWORD "@" -> WithAt
  | _ -> NoFlag
let ssrtermkind = Procq.Entry.(of_parser "ssrtermkind" { parser_fun = input_ssrtermkind })


# 229 "plugins/ssrmatching/g_ssrmatching.ml"

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssrmatching", "g_ssrmatching.mlg:0")
  cpattern
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.nterm ssrtermkind)))
                        ((Procq.Symbol.nterm constr)))
                       (fun c k loc -> 
# 81 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                   
    let pattern = mk_term k c None in
    if loc_of_cpattern pattern <> Some loc && k = InParens
    then mk_term Cpattern c None
    else pattern 
# 246 "plugins/ssrmatching/g_ssrmatching.ml"
)]))
  in ()

let (wit_lcpattern, lcpattern) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssrmatching" ~name:"lcpattern" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                          ([(Procq.Production.make
                                                             (Procq.Rule.next
                                                              (Procq.Rule.next
                                                               (Procq.Rule.stop)
                                                               ((Procq.Symbol.token (Procq.terminal "Qed"))))
                                                              ((Procq.Symbol.nterm lconstr)))
                                                             (fun c _ loc ->
                                                             
# 95 "plugins/ssrmatching/g_ssrmatching.mlg"
                            mk_lterm c None 
# 263 "plugins/ssrmatching/g_ssrmatching.ml"
))]);
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.val_tag (Genarg.topwit wit_cpattern));
                                 Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                         
# 92 "plugins/ssrmatching/g_ssrmatching.mlg"
                     glob_cpattern 
# 271 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                 Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                        
# 92 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                      subst_ssrterm 
# 277 "plugins/ssrmatching/g_ssrmatching.ml"
);
                                 Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                         
# 91 "plugins/ssrmatching/g_ssrmatching.mlg"
                      interp_ssrterm 
# 283 "plugins/ssrmatching/g_ssrmatching.ml"
);
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 93 "plugins/ssrmatching/g_ssrmatching.mlg"
                      pr_ssrterm 
# 289 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                          
# 94 "plugins/ssrmatching/g_ssrmatching.mlg"
                       pr_ssrterm 
# 294 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                          
# 90 "plugins/ssrmatching/g_ssrmatching.mlg"
                  pr_ssrterm 
# 299 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                 }
let _ = (wit_lcpattern, lcpattern)

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssrmatching", "g_ssrmatching.mlg:1")
  lcpattern
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.nterm ssrtermkind)))
                        ((Procq.Symbol.nterm lconstr)))
                       (fun c k loc -> 
# 100 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                     
    let pattern = mk_term k c None in
    if loc_of_cpattern pattern <> Some loc && k = InParens
    then mk_term Cpattern c None
    else pattern 
# 319 "plugins/ssrmatching/g_ssrmatching.ml"
)]))
  in ()

let (wit_ssrpatternarg, ssrpatternarg) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssrmatching" ~name:"ssrpatternarg" 
                                         {
                                         Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                                  (rpattern);
                                         Tacentries.arg_tag = Some
                                                              (Geninterp.val_tag (Genarg.topwit wit_rpattern));
                                         Tacentries.arg_intern = Tacentries.ArgInternWit (wit_rpattern);
                                         Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_rpattern);
                                         Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_rpattern);
                                         Tacentries.arg_printer = ((fun env sigma -> 
                                                                  
# 107 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                             pr_rpattern 
# 336 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                                  
# 107 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                             pr_rpattern 
# 341 "plugins/ssrmatching/g_ssrmatching.ml"
), (fun env sigma -> 
                                                                  
# 107 "plugins/ssrmatching/g_ssrmatching.mlg"
                                                             pr_rpattern 
# 346 "plugins/ssrmatching/g_ssrmatching.ml"
));
                                         }
let _ = (wit_ssrpatternarg, ssrpatternarg)

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ssrmatching" "ssrinstoftpat" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("ssrinstancesoftpat", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_cpattern), 
                            Tacentries.TyNil)), (fun arg ist -> 
# 112 "plugins/ssrmatching/g_ssrmatching.mlg"
                                              ssrinstancesof arg 
# 357 "plugins/ssrmatching/g_ssrmatching.ml"
)))]


# 115 "plugins/ssrmatching/g_ssrmatching.mlg"
 

(* We wipe out all the keywords generated by the grammar rules we defined. *)
(* The user is supposed to Require Import ssreflect or Require ssreflect   *)
(* and Import ssreflect.SsrSyntax to obtain these keywords and as a         *)
(* consequence the extended ssreflect grammar.                             *)
let () = Mltop.add_init_function "rocq-runtime.plugins.ssreflect" (fun () ->
      Procq.unfreeze_only_keywords (Option.get !frozen_lexer);
      frozen_lexer := None) ;;


# 373 "plugins/ssrmatching/g_ssrmatching.ml"

