// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const process = require('node:process');
const globalModules = require('global-modules');
const errors = require('./errors.cjs');
const resolveSilent = require('./resolveSilent.cjs');

/**
 * @param {string} basedir
 * @param {string} lookup
 * @param {string} [cwd]
 * @returns {string}
 */
function getModulePath(basedir, lookup, cwd = process.cwd()) {
	// 1. Try to resolve from the provided directory
	// 2. Try to resolve from `cwd` or `process.cwd()`
	// 3. Try to resolve from global `node_modules` directory
	let path = resolveSilent(basedir, lookup);

	if (!path) {
		path = resolveSilent(cwd, lookup);
	}

	if (!path) {
		path = resolveSilent(globalModules, lookup);
	}

	if (!path) {
		throw new errors.ConfigurationError(
			`Could not find "${lookup}". Do you need to install the package or use the "configBasedir" option?`,
		);
	}

	return path;
}

module.exports = getModulePath;
