export declare const YEAR_2000_IN_UTC: number;
/**
 * Parse timezone offset from ISO 8601 datetime.
 * Returns seconds, `0` for `Z`, or `undefined` when no offset is present.
 */
export declare const parseIsoOffsetSeconds: (value: string) => number | undefined;
/**
 * Convert Unix UTC seconds to device local-time seconds (2000 base).
 */
export declare const utcToDeviceLocal2000Seconds: (utcSeconds: number, offsetSeconds: number) => number;
/**
 * Convert device local-time seconds (2000 base) back to Unix UTC seconds.
 * The runtime timezone is used as the device-local timezone baseline.
 */
export declare const deviceLocal2000ToUTCSeconds: (deviceSeconds: number) => number;
/**
 * Parse ISO 8601 datetime (must include `Z` or `±HH:mm`) to Unix UTC seconds.
 * Returns `undefined` when format is invalid or parsed value is negative.
 */
export declare const parseIsoWithOffsetToUtcSeconds: (value: string) => number | undefined;
/**
 * Format Unix UTC seconds to ISO 8601 with the runtime local timezone offset.
 */
export declare const formatUtcSecondsToIsoWithOffset: (utcSeconds: number) => string;
export type ParsedRawZclCommand = {
    commandId: number;
    payload: Buffer;
};
export declare const parseRawZclCommand: (buffer: Buffer) => ParsedRawZclCommand | undefined;
//# sourceMappingURL=sonoff.d.ts.map