@echo off
NET SESSION >nul 2>&1
if %ERRORLEVEL% EQU 0 (
	echo Starting Driver Install
) else (
	echo Please run as an administrator
	pause
	exit
)

SET UNATTENDED=0
if "%~1"=="" goto NOPARAM
if "%~1"=="-d" (
	echo "WINDIR = %WINDIR%"
	echo "cwd = "%~dp0"
	set proc
	@echo on
)

if "%~1"=="-u" (
	echo Unattended mode
	SET UNATTENDED=1
)

:NOPARAM

SET DRIVER_FAILURE=0

echo "Framework Starting install: %DATE% %TIME%" >"%TEMP%\frameworkinstall.txt"
"%~dp0\framework_tool_v0.2.1.exe" --info > "%TEMP%\framework_system_report.txt"

SET NUM_STEPS=14

find "FRANMDCP" "%TEMP%\framework_system_report.txt" >nul || (
	echo "This Framework driver bundle is designed to run on AMD Ryzen 7040 mainboards only!"
	echo "Preinstalling Wifi Driver"
	"%WINDIR%\System32\pnputil.exe" -a "%~dp004_WiFi_3.4.0.1335\Wifi\mtkwl6ex.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
	echo "Please run the installer again after upgrading the system to AMD Ryzen 7040 Series"

	pause
	exit
)

echo (1  of %NUM_STEPS%) Installing AMD Chipset Driver
"%~dp001_AMD_Chipset_7.06.02.123\AMD_Chipset_Software_7.06.02.123.exe" -s
CALL :log_result %ERRORLEVEL% "Chipset"

echo (2  of %NUM_STEPS%) Installing AMD Graphics Driver
"%~dp002_AMD_Graphics_25.10.2\Setup.exe" -INSTALL
REM Change DalMinABMBcaklightLevel
reg add HKLM\SYSTEM\CurrentControlSet\Control\Class\{4d36e968-e325-11ce-bfc1-08002be10318}\0000 /v DalMinABMBacklightLevel /t REG_DWORD /d 0x0D0D /f
CALL :log_result %ERRORLEVEL% "Graphics"

echo (3  of %NUM_STEPS%) Installing Realtek Audio Driver
REM Delete previous speaker calibration values for this driver version.
REM please note that the Drv9622 matches the driver version and changes with each new version.
if %NUM_STEPS% equ 9 (
	FOR /L %%A IN (0,1,5) DO (
		echo "Deleting  HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9622_DevType_0295_SSf1110005"  >> "%TEMP%\frameworkinstall.txt" 2>&1
		reg delete HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9590_DevType_0295_SSf1110005 /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
		reg delete HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9618_DevType_0295_SSf1110005 /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
		reg delete HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9622_DevType_0295_SSf1110005 /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
		reg delete HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9679_DevType_0295_SSf1110005 /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
		reg delete HKLM\System\CurrentControlSet\Control\Class\{4d36e96c-e325-11ce-bfc1-08002be10318}\000%%A\Settings\Drv9859_DevType_0295_SSf1110005 /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
	)
	reg delete HKLM\SOFTWARE\Realtek\SpkProtection /v R0_L_MSB /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
	reg delete HKLM\SOFTWARE\Realtek\SpkProtection /v R0_L_LSB /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
	reg delete HKLM\SOFTWARE\Realtek\SpkProtection /v R0_R_MSB /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
	reg delete HKLM\SOFTWARE\Realtek\SpkProtection /v R0_R_LSB /f  >> "%TEMP%\frameworkinstall.txt" 2>&1
)
"%~dp003_Realtek_Audio_6.0.9859.1\setup.exe" -s
CALL :log_result %ERRORLEVEL% "Audio"
Dism /Online /Add-ProvisionedAppxPackage /PackagePath:"%~dp003_HSA_Realtek_Audio_1.53.374.0\30c1372fe42649e29752edac6870e54e.appxbundle"^
	/DependencyPackagePath:"%~dp003_HSA_Realtek_Audio_1.53.374.0\Microsoft.VCLibs.140.00_14.0.33519.0_x64__8wekyb3d8bbwe.appx"^
	/LicensePath:"%~dp003_HSA_Realtek_Audio_1.53.374.0\30c1372fe42649e29752edac6870e54e_License1.xml"^
	/Region:"all"  >> "%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "AudioHSA"



echo (4  of %NUM_STEPS%) Installing Wifi Driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp004_WiFi_3.4.0.1335\Wifi\mtkwl6ex.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "WIFI"

echo (5  of %NUM_STEPS%) Installing Bluetooth Driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp005_Bluetooth_1.1043.0.555\BT\mtkbtfilter.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "Bluetooth"

echo (6  of %NUM_STEPS%) Installing Fingerprint Driver and enabling Enhanced Sign-in Security
"%~dp006_Goodix Fingerprint_3.12804.1.270\setup.exe" /q
REM Enable ESS SecureBiometrics
reg add HKLM\SYSTEM\CurrentControlSet\Control\DeviceGuard\Scenarios\SecureBiometrics /v Enabled /t REG_DWORD /d 1 /f
CALL :log_result %ERRORLEVEL% "Fingerprint"

echo (7  of %NUM_STEPS%) Installing Realtek Camera Driver
"%~dp007_Camera_10.0.22000.20357\setup.exe" -s
CALL :log_result %ERRORLEVEL% "RealtekCamera"

echo (8 of %NUM_STEPS%) Installing Realtek MEP Driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp008_Realtek_MEP_Opt-in_10.0.22000.10003\MEP_Optin\RtExtFW.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "RealtekMEP"

echo (9 of %NUM_STEPS%) Installing AMD MEP Driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp009_AMD_MEP_ext_32.1.0.0\MEP_ext\AmdMepEnum.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "AMDMEP"

echo (10 of %NUM_STEPS%) Installing Microsoft MEP Driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp010_MEP_1.0.42.0\Extension\MicrosoftEffectPack.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
"%WINDIR%\System32\pnputil.exe" -a "%~dp010_MEP_1.0.42.0\Camera\mep_camera_component.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "MicrosoftMEP"

echo (11 of %NUM_STEPS%) Installing Framework EC driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp011_Framework_EC_0.0.0.6\framework_EC\crosecbus.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "FrameworkEC"

REM Below here are Framework provided
REM TODO: Once 2nd Gen uSD is ready we can add it

echo (12  of %NUM_STEPS%) Installing Realtek USB Ethernet driver (Ethernet Expansion Card)
"%~dp0Install_USB_Win11_11013_20_07272023_08042023.exe" -s
CALL :log_result %ERRORLEVEL% "RealtekNIC"

echo (13  of %NUM_STEPS%) Installing SD card driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp0\USB_Storage_Driver_v4_5_10_201_W11_24H2_to_W10_21H2\drivers\GeneStor.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "SDCard"

echo (14  of %NUM_STEPS%) Installing 2nd Gen uSD card driver
"%WINDIR%\System32\pnputil.exe" -a "%~dp0\GeneStor_4_5_10_202_W11_24H2_to_W10_22H2\drivers\bc3c97c8-edf7-49e3-8623-c84d8cf9737f\GeneStor.inf" /install >>"%TEMP%\frameworkinstall.txt" 2>&1
CALL :log_result %ERRORLEVEL% "2nd Gen uSDCard"

REM give some time for any background tasks to complete
echo "wait 30" >>"%TEMP%\frameworkinstall.txt" 2>&1
timeout 30 >nul

echo "installing hotkey" >>"%TEMP%\frameworkinstall.txt" 2>&1
REM Enable framework hotkey
if not exist "%programfiles(x86)%\Framework\" MKDIR "%programfiles(x86)%\Framework\" >nul 2>&1
XCOPY /b /y "%~dp0framework_startmenuicon.ico" "%programfiles(x86)%\Framework\" >nul 2>&1

echo "installing FW13 shortcut" >>"%TEMP%\frameworkinstall.txt" 2>&1
XCOPY /b /y "%~dp0\Framework_Shortcuts\Framework_13.url" "%programfiles(x86)%\Framework\Framework.url*" >nul 2>&1

reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AppKey\16" /v ShellExecute /t REG_SZ /d "%programfiles(x86)%\Framework\Framework.url" /f >nul 2>&1

REM Install Startmenu shortcuts
XCOPY /b /y "%~dp0\Framework_Icons\framework_startmenuicon_marketplace.ico" "%programfiles(x86)%\Framework\" >nul 2>&1
XCOPY /b /y "%~dp0\Framework_Shortcuts\Framework Marketplace.url" "C:\ProgramData\Microsoft\Windows\Start Menu\" >nul 2>&1
XCOPY /b /y "%~dp0\Framework_Icons\framework_startmenuicon_support.ico" "%programfiles(x86)%\Framework\" >nul 2>&1
XCOPY /b /y "%~dp0\Framework_Shortcuts\Support.url" "C:\ProgramData\Microsoft\Windows\Start Menu\" >nul 2>&1

REM Enable adaptive display brightness (based on ALS sensor)
REM 381b4222-f694-41f0-9685-ff5bb260df2e = Balanced (The only scheme supported on >24H2)
REM 7516b95f-f776-4464-8c53-06167f40cc99 = Display settings subgroup
REM fbd9aa66-9553-4097-ba44-ed6e9d65eab8 = Auto Brightness
powercfg /setdcvalueindex 381b4222-f694-41f0-9685-ff5bb260df2e 7516b95f-f776-4464-8c53-06167f40cc99 fbd9aa66-9553-4097-ba44-ed6e9d65eab8 1
powercfg /setacvalueindex 381b4222-f694-41f0-9685-ff5bb260df2e 7516b95f-f776-4464-8c53-06167f40cc99 fbd9aa66-9553-4097-ba44-ed6e9d65eab8 1

echo "do restart" >> "%TEMP%\frameworkinstall.txt" 2>&1
if %DRIVER_FAILURE% EQU 1 (
	echo "ERROR Installing some drivers, please try again"
)

echo Your computer will now restart to complete driver installation
if %UNATTENDED% EQU 0 (
	pause
	shutdown -r -t 10
)


exit /B %ERRORLEVEL%

:log_result
if %~1 EQU 0 (
	echo "%~1 %~2 Install OK" >>"%TEMP%\frameworkinstall.txt"
) else (
	echo "%~1 %~2 Error" >>"%TEMP%\frameworkinstall.txt"
)
EXIT /B 0
