import * as ImpLib from "@ot-builder/common-impl";
import { Algebra } from "@ot-builder/prelude";
import { GeneralVar } from "@ot-builder/variance";
import { DelayValueCollector } from "../common/value-collector";
export declare class ReadTimeIVD<A extends GeneralVar.Dim, M extends GeneralVar.Master<A>, X> {
    constructor(cr: GeneralVar.ValueFactory<A, M, X>);
    masterIDs: number[];
    deltas: number[][];
    valueCreator: GeneralVar.ValueFactory<A, M, X>;
}
export declare class CReadTimeIVS<A extends GeneralVar.Dim, M extends GeneralVar.Master<A>, X> {
    private readonly monoidX;
    constructor(monoidX: Algebra.Monoid<X>);
    knownMasters: M[];
    itemVariationData: ReadTimeIVD<A, M, X>[];
    tryGetIVD(outer: number): null | ReadTimeIVD<A, M, X>;
    getIVD(outer: number): ReadTimeIVD<A, M, X>;
    getMaster(id: number): M;
    buildValue(ivd: ReadTimeIVD<A, M, X>, deltas: number[]): X;
    queryValue(outer: number, inner: number): X;
}
export declare class WriteTimeIVD {
    readonly long: boolean;
    readonly arity: number;
    readonly outerIndex: number;
    readonly masterIDs: number[];
    private allocator;
    private mapping;
    constructor(long: boolean, arity: number, outerIndex: number, masterIDs: number[]);
    enter(deltas: number[]): number;
    entries(): IterableIterator<[number[], number]>;
    get size(): number;
}
export declare class WriteTimeIVDAllocator {
    private allocOuterID;
    private ivdList;
    next(fLong: boolean, arity: number, r: number[]): WriteTimeIVD;
    entries(): Generator<WriteTimeIVD, void, undefined>;
    isEmpty(): boolean;
}
export declare class WriteTimeIVDBlossom {
    private nodeAlloc;
    private maxInnerIndex;
    private readonly masterIDs;
    private readonly ivdListShort;
    private readonly ivdListLong;
    constructor(nodeAlloc: WriteTimeIVDAllocator, maxInnerIndex: number, masterIDs: number[]);
    getFreeIVD(fLong: boolean, arity: number): WriteTimeIVD;
}
export declare class WriteTimeIVDBlossomAllocator implements ImpLib.PathMapAllocator<WriteTimeIVDBlossom, [number[]]> {
    private nodeAlloc;
    private maxInnerIndex;
    constructor(nodeAlloc: WriteTimeIVDAllocator, maxInnerIndex: number);
    next(masterIDs: number[]): WriteTimeIVDBlossom;
}
export declare class WriteTimeIVCollector<A extends GeneralVar.Dim, M extends GeneralVar.Master<A>, X> extends DelayValueCollector<A, M, X, DelayDeltaValue<A, M, X>> {
    private pmBlossom;
    private acBlossom;
    constructor(op: GeneralVar.Ops<A, M, X>, masterSet: GeneralVar.MasterSet<A, M>, pmBlossom: ImpLib.PathMap<number, WriteTimeIVDBlossom>, acBlossom: WriteTimeIVDBlossomAllocator);
    protected createCollectedValue(origin: number, deltaMA: number[]): DelayDeltaValue<A, M, X>;
    getIVD(fLong: boolean, arity: number): WriteTimeIVD | null;
    forceGetIVD(fLong: boolean, arity: number, master: M): WriteTimeIVD;
}
export declare class DelayDeltaValue<A extends GeneralVar.Dim, M extends GeneralVar.Master<A>, X> {
    private col;
    origin: number;
    private deltaMA;
    constructor(col: WriteTimeIVCollector<A, M, X>, origin: number, deltaMA: number[]);
    resolve(): number[];
}
export declare class GeneralWriteTimeIVStore<A extends GeneralVar.Dim, M extends GeneralVar.Master<A>, X> {
    private readonly op;
    private readonly masterCollector;
    private maxInnerIndex;
    private pmBlossom;
    private acBlossom;
    private acIVD;
    constructor(op: GeneralVar.Ops<A, M, X>, masterCollector: GeneralVar.MasterSet<A, M>, maxInnerIndex: number);
    createCollector(): WriteTimeIVCollector<A, M, X>;
    private valueToInnerOuterIDImpl;
    private valueToInnerOuterIDForceImpl;
    valueToInnerOuterID(x: X): {
        outer: number;
        inner: number;
    } | null;
    valueToInnerOuterIDForce(x: X, fallbackMaster: M): {
        outer: number;
        inner: number;
    };
    multiValueToInnerOuterID(xs: X[]): {
        outer: number;
        inner: number;
    } | null;
    multiValueToInnerOuterIDForce(xs: X[], fallbackMaster: M): {
        outer: number;
        inner: number;
    };
    longValueToInnerOuterID(x: X): {
        outer: number;
        inner: number;
    } | null;
    longValueToInnerOuterIDForce(x: X, fallbackMaster: M): {
        outer: number;
        inner: number;
    };
    multiLongValueToInnerOuterID(xs: X[]): {
        outer: number;
        inner: number;
    } | null;
    multiLongValueToInnerOuterIDForce(xs: X[], fallbackMaster: M): {
        outer: number;
        inner: number;
    };
    isEmpty(): boolean;
    masters(): Iterable<[M, number]>;
    ivdList(): Generator<WriteTimeIVD, void, undefined>;
}
//# sourceMappingURL=general.d.ts.map