#ifndef CO2TABLES_INC
#define CO2TABLES_INC

/* The data has been calculated using the CoolProp Python package https://doi.org/10.1021/ie4033999.
*
* THIS AN AUTO-GENERATED FILE! DO NOT EDIT IT!
*
* Bell, Ian H. and Wronski, Jorrit and Quoilin, Sylvain and Lemort, Vincent
* Pure and Pseudo-pure Fluid Thermophysical Property Evaluation and
* the Open-Source Thermophysical Property Library CoolProp
* Industrial & Engineering Chemistry Research, 53(6), 2014
* DOI: 10.1021/ie4033999
*
* Temperature range: 280.000 K to 400.000 K, using 200 sampling points
* Pressure range: 0.100 MPa to 100.000 MPa, using 500 sampling points
* Reference temperature and pressure: 288.71 K and 0.101325 MPa
*
* Generated using opm_tables_coolprop.py in opm-utilities like this:
*
* >> python3 opm_tables_coolprop.py -t1 280.0 -t2 400.0 -nt 200 -tref 288.71 -p1 100000.0 -p2 100000000.0 -np 500 -pref 101325.0 -c co2
* 
*/
// Fill in the data for a struct like this (intended to work together with brine salinity 0.1)
//struct Opm::co2TabulatedDensityTraits {
//    typedef double Scalar;
//    static const char  *name;
//    static const int    numX = 200;
//    static const Scalar xMin;
//    static const Scalar xMax;
//    static const int    numY = 500;
//    static const Scalar yMin;
//    static const Scalar yMax;
//    static const Scalar vals[200][500];
//};

inline const double Opm::co2TabulatedDensityTraits::xMin = 2.800000000000000e+02;
inline const double Opm::co2TabulatedDensityTraits::xMax = 4.000000000000000e+02;
inline const double Opm::co2TabulatedDensityTraits::yMin = 1.000000000000000e+05;
inline const double Opm::co2TabulatedDensityTraits::yMax = 1.000000000000000e+08;
inline const char  *Opm::co2TabulatedDensityTraits::name = "density";

inline const Opm::co2TabulatedDensityTraits::Scalar Opm::co2TabulatedDensityTraits::vals[200][500] =
{
	{
		1.902062892500725e+00,		5.782410262868594e+00,		9.764912030359696e+00,		1.385695294926554e+01,		1.806683133577130e+01,
		2.240392329261169e+01,		2.687888689307449e+01,		3.150391890871504e+01,		3.629308164225097e+01,		4.126272482650261e+01,
		4.643203880285805e+01,		5.182379274641629e+01,		5.746533988944952e+01,		6.339001846585204e+01,		6.963915773041516e+01,
		7.626504375966206e+01,		8.333547606990224e+01,		9.094110643257447e+01,		9.920798267276646e+01,		1.083207219570809e+02,
		1.185701567481778e+02,		8.854494336942427e+02,		8.879785482969987e+02,		8.904263032272844e+02,		8.927992619000071e+02,
		8.951031470530842e+02,		8.973429850202531e+02,		8.995232195398899e+02,		9.016478026284951e+02,		9.037202679391137e+02,
		9.057437905710656e+02,		9.077212362760157e+02,		9.096552022763793e+02,		9.115480513840403e+02,		9.134019407193442e+02,
		9.152188460419598e+02,		9.170005824882962e+02,		9.187488223451336e+02,		9.204651103626833e+02,		9.221508770120313e+02,
		9.238074500154046e+02,		9.254360644173087e+02,		9.270378714166395e+02,		9.286139461416607e+02,		9.301652945189056e+02,
		9.316928593630680e+02,		9.331975257890027e+02,		9.346801260457365e+02,		9.361414438351861e+02,		9.375822181887389e+02,
		9.390031469533067e+02,		9.404048899343985e+02,		9.417880717366771e+02,		9.431532843369583e+02,		9.445010894198364e+02,
		9.458320205023206e+02,		9.471465848702697e+02,		9.484452653467483e+02,		9.497285219097611e+02,		9.509967931748389e+02,
		9.522504977560235e+02,		9.534900355172573e+02,		9.547157887247931e+02,		9.559281231100363e+02,		9.571273888512175e+02,
		9.583139214813311e+02,		9.594880427290287e+02,		9.606500612984141e+02,		9.618002735931036e+02,		9.629389643893246e+02,
		9.640664074624088e+02,		9.651828661705215e+02,		9.662885939992086e+02,		9.673838350698484e+02,		9.684688246149886e+02,
		9.695437894230688e+02,		9.706089482549978e+02,		9.716645122356808e+02,		9.727106852168248e+02,		9.737476641260834e+02,
		9.747756392875145e+02,		9.757947947266526e+02,		9.768053084570760e+02,		9.778073527504604e+02,		9.788010943912325e+02,
		9.797866949169132e+02,		9.807643108451024e+02,		9.817340938880144e+02,		9.826961911553752e+02,		9.836507453464571e+02,
		9.845978949319456e+02,		9.855377743262915e+02,		9.864705140511412e+02,		9.873962408904193e+02,		9.883150780375624e+02,
		9.892271452353949e+02,		9.901325589090852e+02,		9.910314322925950e+02,		9.919238755490176e+02,		9.928099958851444e+02,
		9.936898976606066e+02,		9.945636824919027e+02,		9.954314493515959e+02,		9.962932946629528e+02,		9.971493123902831e+02,
		9.979995941252112e+02,		9.988442291690950e+02,		9.996833046118221e+02,		1.000516905407143e+03,		1.001345114444759e+03,
		1.002168012619312e+03,		1.002985678896437e+03,		1.003798190376047e+03,		1.004605622352973e+03,		1.005408048375093e+03,
		1.006205540299100e+03,		1.006998168343976e+03,		1.007786001142349e+03,		1.008569105789782e+03,		1.009347547892115e+03,
		1.010121391612106e+03,		1.010890699708945e+03,		1.011655533586176e+03,		1.012415953328461e+03,		1.013172017741350e+03,
		1.013923784388731e+03,		1.014671309628877e+03,		1.015414648649170e+03,		1.016153855499545e+03,		1.016888983124723e+03,
		1.017620083395295e+03,		1.018347207137661e+03,		1.019070404162940e+03,		1.019789723294844e+03,		1.020505212397287e+03,
		1.021216918397774e+03,		1.021924887314904e+03,		1.022629164284722e+03,		1.023329793578508e+03,		1.024026818629245e+03,
		1.024720282052558e+03,		1.025410225667868e+03,		1.026096690518817e+03,		1.026779716893037e+03,		1.027459344341301e+03,
		1.028135611696014e+03,		1.028808557089149e+03,		1.029478217969602e+03,		1.030144631119986e+03,		1.030807832672926e+03,
		1.031467858126821e+03,		1.032124742361143e+03,		1.032778519651243e+03,		1.033429223682723e+03,		1.034076887565371e+03,
		1.034721543846669e+03,		1.035363224524899e+03,		1.036001961061873e+03,		1.036637784395274e+03,		1.037270724950637e+03,
		1.037900812652983e+03,		1.038528076938126e+03,		1.039152546763645e+03,		1.039774250619533e+03,		1.040393216538572e+03,
		1.041009472106391e+03,		1.041623044471247e+03,		1.042233960353548e+03,		1.042842246055088e+03,		1.043447927468053e+03,
		1.044051030083763e+03,		1.044651579001184e+03,		1.045249598935209e+03,		1.045845114224715e+03,		1.046438148840407e+03,
		1.047028726392453e+03,		1.047616870137919e+03,		1.048202602988004e+03,		1.048785947515088e+03,		1.049366925959607e+03,
		1.049945560236737e+03,		1.050521871944108e+03,		1.051095882363657e+03,		1.051667612474204e+03,		1.052237082953438e+03,
		1.052804314184777e+03,		1.053369326263095e+03,		1.053932139000314e+03,		1.054492771930872e+03,		1.055051244317035e+03,
		1.055607575154095e+03,		1.056161783175437e+03,		1.056713886857480e+03,		1.057263904424506e+03,		1.057811853853369e+03,
		1.058357752878097e+03,		1.058901618994372e+03,		1.059443469463929e+03,		1.059983321318824e+03,		1.060521191365626e+03,
		1.061057096189494e+03,		1.061591052158175e+03,		1.062123075425898e+03,		1.062653181937192e+03,		1.063181387430599e+03,
		1.063707707442325e+03,		1.064232157309793e+03,		1.064754752175121e+03,		1.065275506988525e+03,		1.065794436511645e+03,
		1.066311555320798e+03,		1.066826877810159e+03,		1.067340418194870e+03,		1.067852190514088e+03,		1.068362208633964e+03,
		1.068870486250555e+03,		1.069377036892677e+03,		1.069881873924694e+03,		1.070385010549256e+03,		1.070886459809967e+03,
		1.071386234594007e+03,		1.071884347634690e+03,		1.072380811513985e+03,		1.072875638664961e+03,		1.073368841374202e+03,
		1.073860431784163e+03,		1.074350421895480e+03,		1.074838823569231e+03,		1.075325648529152e+03,		1.075810908363811e+03,
		1.076294614528740e+03,		1.076776778348508e+03,		1.077257411018781e+03,		1.077736523608312e+03,		1.078214127060916e+03,
		1.078690232197388e+03,		1.079164849717392e+03,		1.079637990201314e+03,		1.080109664112077e+03,		1.080579881796919e+03,
		1.081048653489139e+03,		1.081515989309810e+03,		1.081981899269459e+03,		1.082446393269712e+03,		1.082909481104914e+03,
		1.083371172463713e+03,		1.083831476930614e+03,		1.084290403987510e+03,		1.084747963015179e+03,		1.085204163296045e+03,
		1.085659014010702e+03,		1.086112524246387e+03,		1.086564702993862e+03,		1.087015559149865e+03,		1.087465101518445e+03,
		1.087913338812286e+03,		1.088360279653994e+03,		1.088805932577371e+03,		1.089250306028659e+03,		1.089693408367767e+03,
		1.090135247869469e+03,		1.090575832724596e+03,		1.091015171041186e+03,		1.091453270845630e+03,		1.091890140083792e+03,
		1.092325786622110e+03,		1.092760218248677e+03,		1.093193442674306e+03,		1.093625467533573e+03,		1.094056300385845e+03,
		1.094485948716291e+03,		1.094914419936871e+03,		1.095341721387313e+03,		1.095767860336073e+03,		1.096192843981278e+03,
		1.096616679451650e+03,		1.097039373807421e+03,		1.097460934041225e+03,		1.097881367078985e+03,		1.098300679780776e+03,
		1.098718878941678e+03,		1.099135971292616e+03,		1.099551963501181e+03,		1.099966862172450e+03,		1.100380673849773e+03,
		1.100793405015565e+03,		1.101205062092081e+03,		1.101615651442165e+03,		1.102025179370013e+03,		1.102433652121898e+03,
		1.102841075886897e+03,		1.103247456797608e+03,		1.103652800930845e+03,		1.104057114308333e+03,		1.104460402897388e+03,
		1.104862672611580e+03,		1.105263929311404e+03,		1.105664178804915e+03,		1.106063426848371e+03,		1.106461679146868e+03,
		1.106858941354946e+03,		1.107255219077214e+03,		1.107650517868936e+03,		1.108044843236628e+03,		1.108438200638644e+03,
		1.108830595485738e+03,		1.109222033141642e+03,		1.109612518923612e+03,		1.110002058102976e+03,		1.110390655905683e+03,
		1.110778317512822e+03,		1.111165048061155e+03,		1.111550852643628e+03,		1.111935736309880e+03,		1.112319704066745e+03,
		1.112702760878745e+03,		1.113084911668574e+03,		1.113466161317582e+03,		1.113846514666260e+03,		1.114225976514639e+03,
		1.114604551622848e+03,		1.114982244711501e+03,		1.115359060462159e+03,		1.115735003517771e+03,		1.116110078483101e+03,
		1.116484289925162e+03,		1.116857642373634e+03,		1.117230140321274e+03,		1.117601788224333e+03,		1.117972590502957e+03,
		1.118342551541576e+03,		1.118711675689311e+03,		1.119079967260348e+03,		1.119447430534325e+03,		1.119814069756708e+03,
		1.120179889139160e+03,		1.120544892859906e+03,		1.120909085064098e+03,		1.121272469864164e+03,		1.121635051340169e+03,
		1.121996833540146e+03,		1.122357820480453e+03,		1.122718016146103e+03,		1.123077424491094e+03,		1.123436049438739e+03,
		1.123793894881992e+03,		1.124150964683763e+03,		1.124507262677239e+03,		1.124862792666185e+03,		1.125217558425260e+03,
		1.125571563700314e+03,		1.125924812208689e+03,		1.126277307639513e+03,		1.126629053653990e+03,		1.126980053885691e+03,
		1.127330311940830e+03,		1.127679831398551e+03,		1.128028615811198e+03,		1.128376668704593e+03,		1.128723993578300e+03,
		1.129070593905893e+03,		1.129416473135220e+03,		1.129761634688655e+03,		1.130106081963363e+03,		1.130449818331541e+03,
		1.130792847140679e+03,		1.131135171713798e+03,		1.131476795349692e+03,		1.131817721323175e+03,		1.132157952885306e+03,
		1.132497493263640e+03,		1.132836345662440e+03,		1.133174513262919e+03,		1.133511999223456e+03,		1.133848806679827e+03,
		1.134184938745414e+03,		1.134520398511434e+03,		1.134855189047142e+03,		1.135189313400052e+03,		1.135522774596138e+03,
		1.135855575640048e+03,		1.136187719515303e+03,		1.136519209184498e+03,		1.136850047589506e+03,		1.137180237651671e+03,
		1.137509782272003e+03,		1.137838684331371e+03,		1.138166946690690e+03,		1.138494572191114e+03,		1.138821563654215e+03,
		1.139147923882168e+03,		1.139473655657936e+03,		1.139798761745445e+03,		1.140123244889758e+03,		1.140447107817257e+03,
		1.140770353235808e+03,		1.141092983834935e+03,		1.141415002285991e+03,		1.141736411242321e+03,		1.142057213339426e+03,
		1.142377411195127e+03,		1.142697007409731e+03,		1.143016004566181e+03,		1.143334405230217e+03,		1.143652211950535e+03,
		1.143969427258935e+03,		1.144286053670477e+03,		1.144602093683628e+03,		1.144917549780414e+03,		1.145232424426562e+03,
		1.145546720071651e+03,		1.145860439149250e+03,		1.146173584077063e+03,		1.146486157257067e+03,		1.146798161075656e+03,
		1.147109597903770e+03,		1.147420470097038e+03,		1.147730779995908e+03,		1.148040529925779e+03,		1.148349722197137e+03,
		1.148658359105680e+03,		1.148966442932449e+03,		1.149273975943952e+03,		1.149580960392294e+03,		1.149887398515296e+03,
		1.150193292536621e+03,		1.150498644665896e+03,		1.150803457098830e+03,		1.151107732017332e+03,		1.151411471589636e+03,
		1.151714677970404e+03,		1.152017353300855e+03,		1.152319499708868e+03,		1.152621119309102e+03,		1.152922214203103e+03,
		1.153222786479416e+03,		1.153522838213693e+03,		1.153822371468805e+03,		1.154121388294939e+03,		1.154419890729715e+03,
		1.154717880798285e+03,		1.155015360513434e+03,		1.155312331875688e+03,		1.155608796873411e+03,		1.155904757482907e+03,
		1.156200215668518e+03,		1.156495173382723e+03,		1.156789632566237e+03,		1.157083595148103e+03,		1.157377063045788e+03,
		1.157670038165283e+03,		1.157962522401185e+03,		1.158254517636802e+03,		1.158546025744233e+03,		1.158837048584466e+03,
		1.159127588007466e+03,		1.159417645852256e+03,		1.159707223947019e+03,		1.159996324109169e+03,		1.160284948145451e+03,
		1.160573097852013e+03,		1.160860775014502e+03,		1.161147981408139e+03,		1.161434718797804e+03,		1.161720988938118e+03,
		1.162006793573525e+03,		1.162292134438368e+03,		1.162577013256974e+03,		1.162861431743728e+03,		1.163145391603149e+03,
		1.163428894529975e+03,		1.163711942209230e+03,		1.163994536316306e+03,		1.164276678517032e+03,		1.164558370467752e+03,
		1.164839613815399e+03,		1.165120410197563e+03,		1.165400761242568e+03,		1.165680668569536e+03,		1.165960133788466e+03,
		1.166239158500297e+03,		1.166517744296982e+03,		1.166795892761550e+03,		1.167073605468181e+03,		1.167350883982268e+03,
		1.167627729860486e+03,		1.167904144650857e+03,		1.168180129892811e+03,		1.168455687117262e+03,		1.168730817846658e+03,
		1.169005523595054e+03,		1.169279805868170e+03,		1.169553666163456e+03,		1.169827105970151e+03,		1.170100126769347e+03,
		1.170372730034045e+03,		1.170644917229220e+03,		1.170916689811875e+03,		1.171188049231104e+03,		1.171458996928149e+03
	},
	{
		1.897892450690181e+00,		5.769200213824422e+00,		9.741639350189502e+00,		1.382245242715783e+01,		1.801976858029280e+01,
		2.234276106138121e+01,		2.680184264628951e+01,		3.140891066715618e+01,		3.617765801993701e+01,		4.112397328285824e+01,
		4.626646334097099e+01,		5.162714781519112e+01,		5.723239994427995e+01,		6.311425028631720e+01,		6.931224083139013e+01,
		7.587614404967431e+01,		8.287009940375295e+01,		9.037919436838902e+01,		9.852053764551319e+01,		1.074632909563936e+02,
		1.174686483614180e+02,		8.804918496021590e+02,		8.831340561036232e+02,		8.856863793033740e+02,		8.881564416612814e+02,
		8.905508452626696e+02,		8.928753540998505e+02,		8.951350363951030e+02,		8.973343771975264e+02,		8.994773685215854e+02,
		9.015675822807905e+02,		9.036082298746749e+02,		9.056022113031617e+02,		9.075521559775739e+02,		9.094604568850294e+02,
		9.113292993854884e+02,		9.131606856391782e+02,		9.149564554498515e+02,		9.167183041475632e+02,		9.184477980100709e+02,
		9.201463876255126e+02,		9.218154195231655e+02,		9.234561463394971e+02,		9.250697357392775e+02,		9.266572782742784e+02,
		9.282197943265348e+02,		9.297582402719154e+02,		9.312735139588699e+02,		9.327664595996529e+02,		9.342378721471417e+02,
		9.356885012222817e+02,		9.371190546474342e+02,		9.385302016329222e+02,		9.399225756576435e+02,		9.412967770788657e+02,
		9.426533755018060e+02,		9.439929119354761e+02,		9.453159007579370e+02,		9.466228315111866e+02,		9.479141705434156e+02,
		9.491903625142185e+02,		9.504518317764910e+02,		9.516989836471527e+02,		9.529322055774736e+02,		9.541518682324927e+02,
		9.553583264880544e+02,		9.565519203530141e+02,		9.577329758233658e+02,		9.589018056743516e+02,		9.600587101959438e+02,
		9.612039778766059e+02,		9.623378860396874e+02,		9.634607014364095e+02,		9.645726807990173e+02,		9.656740713572916e+02,
		9.667651113225446e+02,		9.678460303352878e+02,		9.689170498939457e+02,		9.699783837481142e+02,		9.710302382715794e+02,
		9.720728128118820e+02,		9.731063000188991e+02,		9.741308861539779e+02,		9.751467513809790e+02,		9.761540700405275e+02,
		9.771530109086244e+02,		9.781437374407185e+02,		9.791264080021966e+02,		9.801011760862233e+02,		9.810681905197524e+02,
		9.820275956585045e+02,		9.829795315716150e+02,		9.839241342165941e+02,		9.848615356052550e+02,		9.857918639611240e+02,
		9.867152438689064e+02,		9.876317964164442e+02,		9.885416393296778e+02,		9.894448871009778e+02,		9.903416511112561e+02,
		9.912320397462429e+02,		9.921161585072342e+02,		9.929941101166443e+02,		9.938659946186556e+02,		9.947319094752371e+02,
		9.955919496577992e+02,		9.964462077347027e+02,		9.972947739548855e+02,		9.981377363277688e+02,		9.989751806996807e+02,
		9.998071908269734e+02,		1.000633848445972e+03,		1.001455233339989e+03,		1.002271423403479e+03,		1.003082494703537e+03,
		1.003888521539792e+03,		1.004689576497461e+03,		1.005485730506419e+03,		1.006277052890237e+03,		1.007063611416868e+03,
		1.007845472346640e+03,		1.008622700478362e+03,		1.009395359193662e+03,		1.010163510499586e+03,		1.010927215069586e+03,
		1.011686532282949e+03,		1.012441520262746e+03,		1.013192235912363e+03,		1.013938734950682e+03,		1.014681071946683e+03,
		1.015419300349500e+03,		1.016153472522290e+03,		1.016883639774881e+03,		1.017609852387208e+03,		1.018332159641539e+03,
		1.019050609848793e+03,		1.019765250374843e+03,		1.020476127665910e+03,		1.021183287273114e+03,		1.021886773876160e+03,
		1.022586631306249e+03,		1.023282902568205e+03,		1.023975629861881e+03,		1.024664854602868e+03,		1.025350617442486e+03,
		1.026032958287189e+03,		1.026711916317278e+03,		1.027387530005069e+03,		1.028059837132446e+03,		1.028728874807882e+03,
		1.029394679482919e+03,		1.030057286968137e+03,		1.030716732448612e+03,		1.031373050498936e+03,		1.032026275097740e+03,
		1.032676439641806e+03,		1.033323576959729e+03,		1.033967719325200e+03,		1.034608898469864e+03,		1.035247145595815e+03,
		1.035882491387727e+03,		1.036514966024624e+03,		1.037144599191311e+03,		1.037771420089481e+03,		1.038395457448491e+03,
		1.039016739535851e+03,		1.039635294167404e+03,		1.040251148717228e+03,		1.040864330127241e+03,		1.041474864916579e+03,
		1.042082779190680e+03,		1.042688098650133e+03,		1.043290848599289e+03,		1.043891053954633e+03,		1.044488739254281e+03,
		1.045083928660873e+03,		1.045676645976414e+03,		1.046266914645295e+03,		1.046854757762685e+03,		1.047440198081652e+03,
		1.048023258020117e+03,		1.048603959667610e+03,		1.049182324791860e+03,		1.049758374845221e+03,		1.050332130970930e+03,
		1.050903614009205e+03,		1.051472844503199e+03,		1.052039842704794e+03,		1.052604628580257e+03,		1.053167221815759e+03,
		1.053727641822752e+03,		1.054285907743217e+03,		1.054842038454792e+03,		1.055396052575760e+03,		1.055947968469932e+03,
		1.056497804251408e+03,		1.057045577789220e+03,		1.057591306711876e+03,		1.058135008411784e+03,		1.058676700049582e+03,
		1.059216398558364e+03,		1.059754120647810e+03,		1.060289882808211e+03,		1.060823701314418e+03,		1.061355592229690e+03,
		1.061885571409452e+03,		1.062413654504978e+03,		1.062939856966983e+03,		1.063464194049141e+03,		1.063986680811516e+03,
		1.064507332123925e+03,		1.065026162669224e+03,		1.065543186946521e+03,		1.066058419274320e+03,		1.066571873793595e+03,
		1.067083564470801e+03,		1.067593505100813e+03,		1.068101709309813e+03,		1.068608190558105e+03,		1.069112962142872e+03,
		1.069616037200886e+03,		1.070117428711143e+03,		1.070617149497456e+03,		1.071115212230987e+03,		1.071611629432735e+03,
		1.072106413475958e+03,		1.072599576588565e+03,		1.073091130855432e+03,		1.073581088220709e+03,		1.074069460490036e+03,
		1.074556259332751e+03,		1.075041496284028e+03,		1.075525182746996e+03,		1.076007329994789e+03,		1.076487949172574e+03,
		1.076967051299541e+03,		1.077444647270836e+03,		1.077920747859470e+03,		1.078395363719615e+03,		1.078868505383029e+03,
		1.079340183268576e+03,		1.079810407679071e+03,		1.080279188804180e+03,		1.080746536722122e+03,		1.081212461401330e+03,
		1.081676972702079e+03,		1.082140080378094e+03,		1.082601794078114e+03,		1.083062123347435e+03,		1.083521077629429e+03,
		1.083978666267016e+03,		1.084434898504133e+03,		1.084889783487159e+03,		1.085343330266317e+03,		1.085795547797055e+03,
		1.086246444941401e+03,		1.086696030469291e+03,		1.087144313059865e+03,		1.087591301302765e+03,		1.088037003699376e+03,
		1.088481428664077e+03,		1.088924584525442e+03,		1.089366479527442e+03,		1.089807121830611e+03,		1.090246519513197e+03,
		1.090684680572296e+03,		1.091121612924962e+03,		1.091557324409295e+03,		1.091991822785518e+03,		1.092425115737028e+03,
		1.092857210871437e+03,		1.093288115721586e+03,		1.093717837746543e+03,		1.094146384332598e+03,		1.094573762794221e+03,
		1.094999980375014e+03,		1.095425044248651e+03,		1.095848961519793e+03,		1.096271739224994e+03,		1.096693384333587e+03,
		1.097113903748567e+03,		1.097533304307439e+03,		1.097951592783073e+03,		1.098368775884534e+03,		1.098784860257895e+03,
		1.099199852487051e+03,		1.099613759094501e+03,		1.100026586542139e+03,		1.100438341232008e+03,		1.100849029507066e+03,
		1.101258657651917e+03,		1.101667231893554e+03,		1.102074758402067e+03,		1.102481243291357e+03,		1.102886692619828e+03,
		1.103291112391078e+03,		1.103694508554568e+03,		1.104096887006288e+03,		1.104498253589415e+03,		1.104898614094951e+03,
		1.105297974262358e+03,		1.105696339780186e+03,		1.106093716286682e+03,		1.106490109370398e+03,		1.106885524570787e+03,
		1.107279967378787e+03,		1.107673443237405e+03,		1.108065957542279e+03,		1.108457515642302e+03,		1.108848122839947e+03,
		1.109237784392134e+03,		1.109626505510564e+03,		1.110014291362287e+03,		1.110401147070230e+03,		1.110787077713710e+03,
		1.111172088328932e+03,		1.111556183909490e+03,		1.111939369406861e+03,		1.112321649730881e+03,		1.112703029750225e+03,
		1.113083514292879e+03,		1.113463108146593e+03,		1.113841816059346e+03,		1.114219642739792e+03,		1.114596592857701e+03,
		1.114972671044399e+03,		1.115347881893193e+03,		1.115722229959800e+03,		1.116095719762764e+03,		1.116468355783864e+03,
		1.116840142468529e+03,		1.117211084226230e+03,		1.117581185430878e+03,		1.117950450421218e+03,		1.118318883501207e+03,
		1.118686488940397e+03,		1.119053270974305e+03,		1.119419233804789e+03,		1.119784381600400e+03,		1.120148718496750e+03,
		1.120512248596865e+03,		1.120874975971527e+03,		1.121236904659624e+03,		1.121598038668489e+03,		1.121958381974234e+03,
		1.122317938522079e+03,		1.122676712226680e+03,		1.123034706972449e+03,		1.123391926613873e+03,		1.123748374975828e+03,
		1.124104055853882e+03,		1.124458973014609e+03,		1.124813130195882e+03,		1.125166531107172e+03,		1.125519179429844e+03,
		1.125871078817445e+03,		1.126222232895988e+03,		1.126572645264232e+03,		1.126922319493965e+03,		1.127271259130275e+03,
		1.127619467691823e+03,		1.127966948671108e+03,		1.128313705534733e+03,		1.128659741723665e+03,		1.129005060653492e+03,
		1.129349665714679e+03,		1.129693560272817e+03,		1.130036747668869e+03,		1.130379231219420e+03,		1.130721014216914e+03,
		1.131062099929892e+03,		1.131402491603232e+03,		1.131742192458377e+03,		1.132081205693568e+03,		1.132419534484067e+03,
		1.132757181982385e+03,		1.133094151318501e+03,		1.133430445600081e+03,		1.133766067912696e+03,		1.134101021320030e+03,
		1.134435308864097e+03,		1.134768933565441e+03,		1.135101898423354e+03,		1.135434206416063e+03,		1.135765860500946e+03,
		1.136096863614717e+03,		1.136427218673633e+03,		1.136756928573682e+03,		1.137085996190770e+03,		1.137414424380918e+03,
		1.137742215980447e+03,		1.138069373806154e+03,		1.138395900655506e+03,		1.138721799306813e+03,		1.139047072519407e+03,
		1.139371723033818e+03,		1.139695753571949e+03,		1.140019166837247e+03,		1.140341965514873e+03,		1.140664152271867e+03,
		1.140985729757320e+03,		1.141306700602531e+03,		1.141627067421173e+03,		1.141946832809454e+03,		1.142265999346271e+03,
		1.142584569593372e+03,		1.142902546095506e+03,		1.143219931380576e+03,		1.143536727959797e+03,		1.143852938327836e+03,
		1.144168564962965e+03,		1.144483610327210e+03,		1.144798076866487e+03,		1.145111967010752e+03,		1.145425283174141e+03,
		1.145738027755108e+03,		1.146050203136562e+03,		1.146361811686008e+03,		1.146672855755677e+03,		1.146983337682665e+03,
		1.147293259789059e+03,		1.147602624382072e+03,		1.147911433754172e+03,		1.148219690183208e+03,		1.148527395932536e+03,
		1.148834553251146e+03,		1.149141164373785e+03,		1.149447231521078e+03,		1.149752756899653e+03,		1.150057742702252e+03,
		1.150362191107860e+03,		1.150666104281815e+03,		1.150969484375928e+03,		1.151272333528590e+03,		1.151574653864897e+03,
		1.151876447496754e+03,		1.152177716522987e+03,		1.152478463029453e+03,		1.152778689089152e+03,		1.153078396762331e+03,
		1.153377588096589e+03,		1.153676265126986e+03,		1.153974429876147e+03,		1.154272084354360e+03,		1.154569230559683e+03,
		1.154865870478045e+03,		1.155162006083341e+03,		1.155457639337536e+03,		1.155752772190759e+03,		1.156047406581401e+03,
		1.156341544436216e+03,		1.156635187670404e+03,		1.156928338187716e+03,		1.157220997880540e+03,		1.157513168629997e+03,
		1.157804852306029e+03,		1.158096050767492e+03,		1.158386765862241e+03,		1.158676999427222e+03,		1.158966753288557e+03,
		1.159256029261633e+03,		1.159544829151184e+03,		1.159833154751376e+03,		1.160121007845897e+03,		1.160408390208030e+03,
		1.160695303600744e+03,		1.160981749776769e+03,		1.161267730478682e+03,		1.161553247438983e+03,		1.161838302380173e+03,
		1.162122897014837e+03,		1.162407033045716e+03,		1.162690712165790e+03,		1.162973936058343e+03,		1.163256706397052e+03,
		1.163539024846052e+03,		1.163820893060011e+03,		1.164102312684205e+03,		1.164383285354588e+03,		1.164663812697869e+03,
		1.164943896331574e+03,		1.165223537864123e+03,		1.165502738894896e+03,		1.165781501014305e+03,		1.166059825803859e+03,
		1.166337714836234e+03,		1.166615169675337e+03,		1.166892191876373e+03,		1.167168782985915e+03,		1.167444944541963e+03,
		1.167720678074010e+03,		1.167995985103108e+03,		1.168270867141928e+03,		1.168545325694826e+03,		1.168819362257902e+03,
		1.169092978319061e+03,		1.169366175358076e+03,		1.169638954846650e+03,		1.169911318248468e+03,		1.170183267019266e+03
	},
	{
		1.893740660589591e+00,		5.756054351978867e+00,		9.718489416740081e+00,		1.378814934397824e+01,		1.797299807150275e+01,
		2.228201114789827e+01,		2.672536277152835e+01,		3.131465970717924e+01,		3.606323730895858e+01,		4.098653910135512e+01,
		4.610261072941736e+01,		5.143275350612416e+01,		5.700240560408158e+01,		6.284235618760412e+01,		6.899046077919715e+01,
		7.549413718593043e+01,		8.241412675487962e+01,		8.983040873316732e+01,		9.785200487388134e+01,		1.066343716177292e+02,
		1.164131752626750e+02,		8.753985175530316e+02,		8.781643776161260e+02,		8.808305130334925e+02,		8.834058300373301e+02,
		8.858979867804792e+02,		8.883136258026932e+02,		8.906585535070869e+02,		8.929378807298783e+02,		8.951561342578565e+02,
		8.973173463228186e+02,		8.994251271734789e+02,		9.014827244839043e+02,		9.034930724074920e+02,		9.054588324028965e+02,
		9.073824274601004e+02,		9.092660709870383e+02,		9.111117913418533e+02,		9.129214527879909e+02,		9.146967734903025e+02,
		9.164393410478928e+02,		9.181506259640828e+02,		9.198319933791032e+02,		9.214847133327306e+02,		9.231099697727326e+02,
		9.247088684988520e+02,		9.262824441841151e+02,		9.278316666066056e+02,		9.293574461958005e+02,		9.308606389837864e+02,
		9.323420510376588e+02,		9.338024424380831e+02,		9.352425308596041e+02,		9.366629948004299e+02,		9.380644765027225e+02,
		9.394475845989462e+02,		9.408128965150646e+02,		9.421609606573362e+02,		9.434922984060959e+02,		9.448074059369034e+02,
		9.461067558870914e+02,		9.473907988833241e+02,		9.486599649442105e+02,		9.499146647701372e+02,		9.511552909312934e+02,
		9.523822189634750e+02,		9.535958083803221e+02,		9.547964036095981e+02,		9.559843348604097e+02,		9.571599189274499e+02,
		9.583234599377963e+02,		9.594752500451652e+02,		9.606155700769669e+02,		9.617446901333998e+02,		9.628628701531735e+02,
		9.639703604355051e+02,		9.650674021309489e+02,		9.661542277000905e+02,		9.672310613431894e+02,		9.682981194029157e+02,
		9.693556107422679e+02,		9.704037370994736e+02,		9.714426934215832e+02,		9.724726681782988e+02,		9.734938436574220e+02,
		9.745063962432698e+02,		9.755104966791841e+02,		9.765063103152675e+02,		9.774939973423470e+02,		9.784737130130608e+02,
		9.794456078509578e+02,		9.804098278483676e+02,		9.813665146537892e+02,		9.823158057494345e+02,		9.832578346196079e+02,
		9.841927309104284e+02,		9.851206205814651e+02,		9.860416260498013e+02,		9.869558663269254e+02,		9.878634571489386e+02,
		9.887645111004210e+02,		9.896591377323913e+02,		9.905474436746293e+02,		9.914295327427401e+02,		9.923055060402452e+02,
		9.931754620559434e+02,		9.940394967568803e+02,		9.948977036770710e+02,		9.957501740023115e+02,		9.965969966511926e+02,
		9.974382583525899e+02,		9.982740437207940e+02,		9.991044353227708e+02,		9.999295137511622e+02,		1.000749357686182e+03,
		1.001564043958685e+03,		1.002373647609913e+03,		1.003178241948795e+03,		1.003977898606916e+03,		1.004772687591260e+03,
		1.005562677334864e+03,		1.006347934745442e+03,		1.007128525252126e+03,		1.007904512850360e+03,		1.008675960145774e+03,
		1.009442928393190e+03,		1.010205477538809e+03,		1.010963666261049e+03,		1.011717552001710e+03,		1.012467191005588e+03,
		1.013212638353841e+03,		1.013953947997089e+03,		1.014691172787292e+03,		1.015424364508488e+03,		1.016153573906432e+03,
		1.016878850717217e+03,		1.017600243694837e+03,		1.018317800637869e+03,		1.019031568415146e+03,		1.019741592990635e+03,
		1.020447919447415e+03,		1.021150592010862e+03,		1.021849654071057e+03,		1.022545148204460e+03,		1.023237116194863e+03,
		1.023925599053641e+03,		1.024610637039365e+03,		1.025292269676771e+03,		1.025970535775131e+03,		1.026645473446034e+03,
		1.027317120120589e+03,		1.027985512566117e+03,		1.028650686902305e+03,		1.029312678616855e+03,		1.029971522580678e+03,
		1.030627253062576e+03,		1.031279903743546e+03,		1.031929507730577e+03,		1.032576097570104e+03,		1.033219705261009e+03,
		1.033860362267266e+03,		1.034498099530205e+03,		1.035132947480424e+03,		1.035764936049351e+03,		1.036394094680466e+03,
		1.037020452340228e+03,		1.037644037529773e+03,		1.038264878291052e+03,		1.038883002222709e+03,		1.039498436486132e+03,
		1.040111207815761e+03,		1.040721342528310e+03,		1.041328866531713e+03,		1.041933805333814e+03,		1.042536184050844e+03,
		1.043136027415665e+03,		1.043733359785779e+03,		1.044328205151141e+03,		1.044920587141758e+03,		1.045510529035083e+03,
		1.046098053763228e+03,		1.046683183919985e+03,		1.047265941767653e+03,		1.047846349243707e+03,		1.048424427967284e+03,
		1.049000199245522e+03,		1.049573684079708e+03,		1.050144903171300e+03,		1.050713876927796e+03,		1.051280625468431e+03,
		1.051845168629767e+03,		1.052407525971117e+03,		1.052967716779866e+03,		1.053525760076624e+03,		1.054081674620297e+03,
		1.054635478913003e+03,		1.055187191204888e+03,		1.055736829498814e+03,		1.056284411554953e+03,		1.056829954895253e+03,
		1.057373476807825e+03,		1.057914994351196e+03,		1.058454524358483e+03,		1.058992083441477e+03,		1.059527687994611e+03,
		1.060061354198858e+03,		1.060593098025530e+03,		1.061122935239984e+03,		1.061650881405270e+03,		1.062176951885666e+03,
		1.062701161850152e+03,		1.063223526275809e+03,		1.063744059951137e+03,		1.064262777479293e+03,		1.064779693281273e+03,
		1.065294821599015e+03,		1.065808176498438e+03,		1.066319771872412e+03,		1.066829621443674e+03,		1.067337738767665e+03,
		1.067844137235324e+03,		1.068348830075812e+03,		1.068851830359184e+03,		1.069353150998999e+03,		1.069852804754883e+03,
		1.070350804235031e+03,		1.070847161898670e+03,		1.071341890059894e+03,		1.071835000884564e+03,		1.072326506400400e+03,
		1.072816418494289e+03,		1.073304748915683e+03,		1.073791509278768e+03,		1.074276711064592e+03,		1.074760365623146e+03,
		1.075242484175401e+03,		1.075723077815320e+03,		1.076202157511818e+03,		1.076679734110679e+03,		1.077155818336443e+03,
		1.077630420794264e+03,		1.078103551971715e+03,		1.078575222240565e+03,		1.079045441858542e+03,		1.079514220971011e+03,
		1.079981569612685e+03,		1.080447497709248e+03,		1.080912015078993e+03,		1.081375131434380e+03,		1.081836856383615e+03,
		1.082297199432164e+03,		1.082756169984254e+03,		1.083213777344348e+03,		1.083670030718578e+03,		1.084124939216165e+03,
		1.084578511850822e+03,		1.085030757542101e+03,		1.085481685116747e+03,		1.085931303310005e+03,		1.086379620766925e+03,
		1.086826646043615e+03,		1.087272387608501e+03,		1.087716853843549e+03,		1.088160053045465e+03,		1.088601993426878e+03,
		1.089042683117502e+03,		1.089482130165273e+03,		1.089920342537479e+03,		1.090357328121845e+03,		1.090793094727636e+03,
		1.091227650086703e+03,		1.091661001854537e+03,		1.092093157611289e+03,		1.092524124862791e+03,		1.092953911041540e+03,
		1.093382523507677e+03,		1.093809969549941e+03,		1.094236256386624e+03,		1.094661391166481e+03,		1.095085380969664e+03,
		1.095508232808597e+03,		1.095929953628872e+03,		1.096350550310107e+03,		1.096770029666812e+03,		1.097188398449212e+03,
		1.097605663344081e+03,		1.098021830975560e+03,		1.098436907905939e+03,		1.098850900636460e+03,		1.099263815608080e+03,
		1.099675659202232e+03,		1.100086437741578e+03,		1.100496157490747e+03,		1.100904824657049e+03,		1.101312445391205e+03,
		1.101719025788030e+03,		1.102124571887143e+03,		1.102529089673633e+03,		1.102932585078916e+03,		1.103335063980709e+03,
		1.103736532204659e+03,		1.104136995524349e+03,		1.104536459662099e+03,		1.104934930289543e+03,		1.105332413028294e+03,
		1.105728913450499e+03,		1.106124437079461e+03,		1.106518989390200e+03,		1.106912575810038e+03,		1.107305201719164e+03,
		1.107696872451190e+03,		1.108087593293690e+03,		1.108477369488756e+03,		1.108866206233522e+03,		1.109254108680680e+03,
		1.109641081939018e+03,		1.110027131073904e+03,		1.110412261107806e+03,		1.110796477020774e+03,		1.111179783750941e+03,
		1.111562186194981e+03,		1.111943689208608e+03,		1.112324297607022e+03,		1.112704016165372e+03,		1.113082849619218e+03,
		1.113460802664971e+03,		1.113837879960328e+03,		1.114214086124714e+03,		1.114589425739703e+03,		1.114963903349443e+03,
		1.115337523461074e+03,		1.115710290545132e+03,		1.116082209035952e+03,		1.116453283332076e+03,		1.116823517796631e+03,
		1.117192916757731e+03,		1.117561484508852e+03,		1.117929225309204e+03,		1.118296143384108e+03,		1.118662242925365e+03,
		1.119027528091611e+03,		1.119392003008676e+03,		1.119755671769940e+03,		1.120118538436667e+03,		1.120480607038366e+03,
		1.120841881573105e+03,		1.121202366007870e+03,		1.121562064278869e+03,		1.121920980291877e+03,		1.122279117922539e+03,
		1.122636481016694e+03,		1.122993073390690e+03,		1.123348898831677e+03,		1.123703961097925e+03,		1.124058263919115e+03,
		1.124411810996643e+03,		1.124764606003894e+03,		1.125116652586549e+03,		1.125467954362855e+03,		1.125818514923914e+03,
		1.126168337833953e+03,		1.126517426630607e+03,		1.126865784825171e+03,		1.127213415902885e+03,		1.127560323323183e+03,
		1.127906510519960e+03,		1.128251980901824e+03,		1.128596737852351e+03,		1.128940784730332e+03,		1.129284124870025e+03,
		1.129626761581388e+03,		1.129968698150330e+03,		1.130309937838945e+03,		1.130650483885737e+03,		1.130990339505871e+03,
		1.131329507891378e+03,		1.131667992211400e+03,		1.132005795612404e+03,		1.132342921218402e+03,		1.132679372131173e+03,
		1.133015151430466e+03,		1.133350262174234e+03,		1.133684707398818e+03,		1.134018490119175e+03,		1.134351613329068e+03,
		1.134684080001275e+03,		1.135015893087794e+03,		1.135347055520019e+03,		1.135677570208966e+03,		1.136007440045441e+03,
		1.136336667900234e+03,		1.136665256624317e+03,		1.136993209049024e+03,		1.137320527986230e+03,		1.137647216228539e+03,
		1.137973276549462e+03,		1.138298711703591e+03,		1.138623524426776e+03,		1.138947717436293e+03,		1.139271293431034e+03,
		1.139594255091646e+03,		1.139916605080721e+03,		1.140238346042952e+03,		1.140559480605299e+03,		1.140880011377150e+03,
		1.141199940950478e+03,		1.141519271899998e+03,		1.141838006783328e+03,		1.142156148141140e+03,		1.142473698497312e+03,
		1.142790660359078e+03,		1.143107036217176e+03,		1.143422828545999e+03,		1.143738039803740e+03,		1.144052672432528e+03,
		1.144366728858580e+03,		1.144680211492341e+03,		1.144993122728613e+03,		1.145305464946703e+03,		1.145617240510556e+03,
		1.145928451768891e+03,		1.146239101055327e+03,		1.146549190688520e+03,		1.146858722972297e+03,		1.147167700195774e+03,
		1.147476124633497e+03,		1.147783998545553e+03,		1.148091324177707e+03,		1.148398103761513e+03,		1.148704339514452e+03,
		1.149010033640036e+03,		1.149315188327934e+03,		1.149619805754097e+03,		1.149923888080862e+03,		1.150227437457072e+03,
		1.150530456018196e+03,		1.150832945886432e+03,		1.151134909170829e+03,		1.151436347967388e+03,		1.151737264359178e+03,
		1.152037660416441e+03,		1.152337538196699e+03,		1.152636899744864e+03,		1.152935747093336e+03,		1.153234082262109e+03,
		1.153531907258879e+03,		1.153829224079142e+03,		1.154126034706288e+03,		1.154422341111713e+03,		1.154718145254903e+03,
		1.155013449083547e+03,		1.155308254533621e+03,		1.155602563529489e+03,		1.155896377983997e+03,		1.156189699798560e+03,
		1.156482530863271e+03,		1.156774873056968e+03,		1.157066728247353e+03,		1.157358098291055e+03,		1.157648985033734e+03,
		1.157939390310167e+03,		1.158229315944338e+03,		1.158518763749506e+03,		1.158807735528320e+03,		1.159096233072876e+03,
		1.159384258164816e+03,		1.159671812575403e+03,		1.159958898065613e+03,		1.160245516386201e+03,		1.160531669277795e+03,
		1.160817358470970e+03,		1.161102585686324e+03,		1.161387352634557e+03,		1.161671661016558e+03,		1.161955512523463e+03,
		1.162238908836745e+03,		1.162521851628288e+03,		1.162804342560449e+03,		1.163086383286146e+03,		1.163367975448926e+03,
		1.163649120683030e+03,		1.163929820613472e+03,		1.164210076856114e+03,		1.164489891017721e+03,		1.164769264696043e+03,
		1.165048199479874e+03,		1.165326696949135e+03,		1.165604758674922e+03,		1.165882386219585e+03,		1.166159581136796e+03,
		1.166436344971602e+03,		1.166712679260500e+03,		1.166988585531503e+03,		1.167264065304190e+03,		1.167539120089785e+03,
		1.167813751391210e+03,		1.168087960701588e+03,		1.168361749510600e+03,		1.168635119295017e+03,		1.168908071525173e+03
	},
	{
		1.889607393284370e+00,		5.742972169905432e+00,		9.695461134449802e+00,		1.375404172754495e+01,		1.792651656177438e+01,
		2.222166847474840e+01,		2.664943958593824e+01,		3.122115464617320e+01,		3.594980286726341e+01,		4.085039812993472e+01,
		4.594044601001390e+01,		5.124055914083387e+01,		5.677528298661169e+01,		6.257422739278070e+01,		6.867365506985858e+01,
		7.511877544530381e+01,		8.196717002462928e+01,		8.929411862497803e+01,		9.720130534679264e+01,		1.058319802699802e+02,
		1.153996695579288e+02,		1.262492868629950e+02,		8.730589619102758e+02,		8.758494755360808e+02,		8.785392998062405e+02,
		8.811373713837087e+02,		8.836513867031430e+02,		8.860880304265812e+02,		8.884531524120636e+02,		8.907519067276502e+02,
		8.929888622229852e+02,		8.951680914709217e+02,		8.972932430410009e+02,		8.993676007735536e+02,		9.013941328044891e+02,
		9.033755324281560e+02,		9.053142524008166e+02,		9.072125339279161e+02,		9.090724313091308e+02,		9.108958330107866e+02,
		9.126844797792164e+02,		9.144399802876699e+02,		9.161638247153536e+02,		9.178573965842533e+02,		9.195219831141056e+02,
		9.211587843274311e+02,		9.227689210713700e+02,		9.243534421182151e+02,		9.259133304677723e+02,		9.274495089590317e+02,
		9.289628452814368e+02,		9.304541564624811e+02,		9.319242128969660e+02,		9.333737419738924e+02,		9.348034313490123e+02,
		9.362139319044340e+02,		9.376058604311328e+02,		9.389798020653633e+02,		9.403363125060632e+02,		9.416759200367960e+02,
		9.429991273728893e+02,		9.443064133518839e+02,		9.455982344832343e+02,		9.468750263712952e+02,		9.481372050240551e+02,
		9.493851680585888e+02,		9.506192958130417e+02,		9.518399523738356e+02,		9.530474865258383e+02,		9.542422326324698e+02,
		9.554245114528507e+02,		9.565946308965167e+02,		9.577528867323542e+02,		9.588995632418232e+02,		9.600349338306668e+02,
		9.611592615989445e+02,		9.622727998733326e+02,		9.633757927046822e+02,		9.644684753335665e+02,		9.655510746262930e+02,
		9.666238094836415e+02,		9.676868912243784e+02,		9.687405239454151e+02,		9.697849048603352e+02,		9.708202246178373e+02,
		9.718466676015543e+02,		9.728644122125318e+02,		9.738736311355938e+02,		9.748744915907007e+02,		9.758671555703090e+02,
		9.768517800636740e+02,		9.778285172689829e+02,		9.787975147940754e+02,		9.797589158465266e+02,		9.807128594137522e+02,
		9.816594804337793e+02,		9.825989099572570e+02,		9.835312753012494e+02,		9.844567001953249e+02,		9.853753049203976e+02,
		9.862872064407471e+02,		9.871925185296470e+02,		9.880913518889414e+02,		9.889838142629538e+02,		9.898700105470318e+02,
		9.907500428910321e+02,		9.916240107980507e+02,		9.924920112196679e+02,		9.933541386421653e+02,		9.942104851776460e+02,
		9.950611406429579e+02,		9.959061926389742e+02,		9.967457266257204e+02,		9.975798259942547e+02,		9.984085721354966e+02,
		9.992320445061334e+02,		1.000050320691793e+03,		1.000863476467572e+03,		1.001671585856090e+03,		1.002474721183820e+03,
		1.003272953132208e+03,		1.004066350790998e+03,		1.004854981709829e+03,		1.005638911940057e+03,		1.006418206083945e+03,
		1.007192927337533e+03,		1.007963137532681e+03,		1.008728897177532e+03,		1.009490265495439e+03,		1.010247300462444e+03,
		1.011000058843359e+03,		1.011748596226532e+03,		1.012492967057331e+03,		1.013233224670438e+03,		1.013969421320957e+03,
		1.014701608214430e+03,		1.015429835535794e+03,		1.016154152477312e+03,		1.016874607265545e+03,		1.017591247187374e+03,
		1.018304118615155e+03,		1.019013267030998e+03,		1.019718737050230e+03,		1.020420572444082e+03,		1.021118816161609e+03,
		1.021813510350892e+03,		1.022504696379546e+03,		1.023192414854555e+03,		1.023876705641472e+03,		1.024557607882996e+03,
		1.025235160016964e+03,		1.025909399793771e+03,		1.026580364293236e+03,		1.027248089940957e+03,		1.027912612524139e+03,
		1.028573967206952e+03,		1.029232188545410e+03,		1.029887310501799e+03,		1.030539366458673e+03,		1.031188389233550e+03,
		1.031834411087921e+03,		1.032477463745862e+03,		1.033117578402788e+03,		1.033754785738354e+03,		1.034389115928150e+03,
		1.035020598655059e+03,		1.035649263120281e+03,		1.036275138054061e+03,		1.036898251726089e+03,		1.037518631955631e+03,
		1.038136306121359e+03,		1.038751301170925e+03,		1.039363643630248e+03,		1.039973359612571e+03,		1.040580474827253e+03,
		1.041185014588331e+03,		1.041787003822845e+03,		1.042386467078954e+03,		1.042983428533813e+03,		1.043577912001263e+03,
		1.044169940939307e+03,		1.044759538457393e+03,		1.045346727323506e+03,		1.045931529971081e+03,		1.046513968505733e+03,
		1.047094064711815e+03,		1.047671840058816e+03,		1.048247315707587e+03,		1.048820512516418e+03,		1.049391451046960e+03,
		1.049960151569997e+03,		1.050526634071085e+03,		1.051090918256036e+03,		1.051653023556283e+03,		1.052212969134108e+03,
		1.052770773887739e+03,		1.053326456456336e+03,		1.053880035224845e+03,		1.054431528328737e+03,		1.054980953658653e+03,
		1.055528328864912e+03,		1.056073671361932e+03,		1.056616998332542e+03,		1.057158326732196e+03,		1.057697673293083e+03,
		1.058235054528149e+03,		1.058770486735028e+03,		1.059303985999879e+03,		1.059835568201134e+03,		1.060365249013170e+03,
		1.060893043909890e+03,		1.061418968168231e+03,		1.061943036871589e+03,		1.062465264913168e+03,		1.062985666999260e+03,
		1.063504257652451e+03,		1.064021051216098e+03,		1.064536061852338e+03,		1.065049303552271e+03,		1.065560790134353e+03,
		1.066070535248346e+03,		1.066578552378136e+03,		1.067084854844486e+03,		1.067589455807729e+03,		1.068092368270408e+03,
		1.068593605079866e+03,		1.069093178930762e+03,		1.069591102367562e+03,		1.070087387786958e+03,		1.070582047440245e+03,
		1.071075093435656e+03,		1.071566537740633e+03,		1.072056392184064e+03,		1.072544668458482e+03,		1.073031378122196e+03,
		1.073516532601404e+03,		1.074000143192251e+03,		1.074482221062847e+03,		1.074962777255251e+03,		1.075441822687408e+03,
		1.075919368155058e+03,		1.076395424333595e+03,		1.076870001779900e+03,		1.077343110934143e+03,		1.077814762121531e+03,
		1.078284965554043e+03,		1.078753731332122e+03,		1.079221069446331e+03,		1.079686989778994e+03,		1.080151502105784e+03,
		1.080614616097299e+03,		1.081076341320601e+03,		1.081536687240726e+03,		1.081995663222167e+03,		1.082453278530333e+03,
		1.082909542332975e+03,		1.083364463701591e+03,		1.083818051612804e+03,		1.084270314949709e+03,		1.084721262503213e+03,
		1.085170902973324e+03,		1.085619244970442e+03,		1.086066297016616e+03,		1.086512067546774e+03,		1.086956564909942e+03,
		1.087399797370432e+03,		1.087841773109018e+03,		1.088282500224080e+03,		1.088721986732738e+03,		1.089160240571964e+03,
		1.089597269599671e+03,		1.090033081595787e+03,		1.090467684263309e+03,		1.090901085229337e+03,		1.091333292046094e+03,
		1.091764312191930e+03,		1.092194153072300e+03,		1.092622822020736e+03,		1.093050326299799e+03,		1.093476673102005e+03,
		1.093901869550759e+03,		1.094325922701249e+03,		1.094748839541337e+03,		1.095170626992434e+03,		1.095591291910364e+03,
		1.096010841086204e+03,		1.096429281247120e+03,		1.096846619057183e+03,		1.097262861118177e+03,		1.097678013971005e+03,
		1.098092084094127e+03,		1.098505077907686e+03,		1.098917001772107e+03,		1.099327861989375e+03,		1.099737664803744e+03,
		1.100146416402472e+03,		1.100554122916525e+03,		1.100960790421265e+03,		1.101366424937152e+03,		1.101771032430403e+03,
		1.102174618813668e+03,		1.102577189946677e+03,		1.102978751636892e+03,		1.103379309640132e+03,		1.103778869661203e+03,
		1.104177437354514e+03,		1.104575018324677e+03,		1.104971618127108e+03,		1.105367242268616e+03,		1.105761896207973e+03,
		1.106155585356493e+03,		1.106548315078588e+03,		1.106940090692320e+03,		1.107330917469949e+03,		1.107720800638466e+03,
		1.108109745380124e+03,		1.108497756832957e+03,		1.108884840091296e+03,		1.109271000206265e+03,		1.109656242186291e+03,
		1.110040570997589e+03,		1.110423991564643e+03,		1.110806508770688e+03,		1.111188127458174e+03,		1.111568852429237e+03,
		1.111948688446144e+03,		1.112327640231753e+03,		1.112705712469950e+03,		1.113082909806088e+03,		1.113459236847418e+03,
		1.113834698163514e+03,		1.114209298286689e+03,		1.114583041712412e+03,		1.114955932899711e+03,		1.115327976271575e+03,
		1.115699176215353e+03,		1.116069537083142e+03,		1.116439063192167e+03,		1.116807758825171e+03,		1.117175628230778e+03,
		1.117542675623871e+03,		1.117908905185951e+03,		1.118274321065496e+03,		1.118638927378317e+03,		1.119002728207912e+03,
		1.119365727605796e+03,		1.119727929591859e+03,		1.120089338154688e+03,		1.120449957251905e+03,		1.120809790810491e+03,
		1.121168842727109e+03,		1.121527116868417e+03,		1.121884617071393e+03,		1.122241347143632e+03,		1.122597310863658e+03,
		1.122952511981225e+03,		1.123306954217613e+03,		1.123660641265921e+03,		1.124013576791359e+03,		1.124365764431533e+03,
		1.124717207796726e+03,		1.125067910470176e+03,		1.125417876008356e+03,		1.125767107941240e+03,		1.126115609772571e+03,
		1.126463384980130e+03,		1.126810437015993e+03,		1.127156769306793e+03,		1.127502385253965e+03,		1.127847288234013e+03,
		1.128191481598744e+03,		1.128534968675519e+03,		1.128877752767496e+03,		1.129219837153866e+03,		1.129561225090089e+03,
		1.129901919808133e+03,		1.130241924516693e+03,		1.130581242401430e+03,		1.130919876625187e+03,		1.131257830328215e+03,
		1.131595106628391e+03,		1.131931708621433e+03,		1.132267639381115e+03,		1.132602901959480e+03,		1.132937499387041e+03,
		1.133271434672997e+03,		1.133604710805432e+03,		1.133937330751512e+03,		1.134269297457687e+03,		1.134600613849891e+03,
		1.134931282833732e+03,		1.135261307294679e+03,		1.135590690098259e+03,		1.135919434090243e+03,		1.136247542096826e+03,
		1.136575016924813e+03,		1.136901861361799e+03,		1.137228078176348e+03,		1.137553670118163e+03,		1.137878639918275e+03,
		1.138202990289198e+03,		1.138526723925109e+03,		1.138849843502015e+03,		1.139172351677916e+03,		1.139494251092972e+03,
		1.139815544369666e+03,		1.140136234112963e+03,		1.140456322910466e+03,		1.140775813332581e+03,		1.141094707932661e+03,
		1.141413009247171e+03,		1.141730719795829e+03,		1.142047842081762e+03,		1.142364378591654e+03,		1.142680331795888e+03,
		1.142995704148698e+03,		1.143310498088306e+03,		1.143624716037064e+03,		1.143938360401599e+03,		1.144251433572947e+03,
		1.144563937926690e+03,		1.144875875823094e+03,		1.145187249607240e+03,		1.145498061609158e+03,		1.145808314143959e+03,
		1.146118009511964e+03,		1.146427149998826e+03,		1.146735737875668e+03,		1.147043775399200e+03,		1.147351264811845e+03,
		1.147658208341861e+03,		1.147964608203465e+03,		1.148270466596951e+03,		1.148575785708807e+03,		1.148880567711834e+03,
		1.149184814765266e+03,		1.149488529014876e+03,		1.149791712593098e+03,		1.150094367619136e+03,		1.150396496199073e+03,
		1.150698100425985e+03,		1.150999182380049e+03,		1.151299744128651e+03,		1.151599787726487e+03,		1.151899315215680e+03,
		1.152198328625870e+03,		1.152496829974331e+03,		1.152794821266065e+03,		1.153092304493903e+03,		1.153389281638609e+03,
		1.153685754668979e+03,		1.153981725541933e+03,		1.154277196202621e+03,		1.154572168584510e+03,		1.154866644609487e+03,
		1.155160626187946e+03,		1.155454115218885e+03,		1.155747113590001e+03,		1.156039623177772e+03,		1.156331645847557e+03,
		1.156623183453680e+03,		1.156914237839519e+03,		1.157204810837595e+03,		1.157494904269659e+03,		1.157784519946773e+03,
		1.158073659669401e+03,		1.158362325227491e+03,		1.158650518400555e+03,		1.158938240957758e+03,		1.159225494657993e+03,
		1.159512281249965e+03,		1.159798602472270e+03,		1.160084460053477e+03,		1.160369855712199e+03,		1.160654791157182e+03,
		1.160939268087369e+03,		1.161223288191987e+03,		1.161506853150615e+03,		1.161789964633261e+03,		1.162072624300442e+03,
		1.162354833803242e+03,		1.162636594783404e+03,		1.162917908873383e+03,		1.163198777696429e+03,		1.163479202866656e+03,
		1.163759185989106e+03,		1.164038728659824e+03,		1.164317832465922e+03,		1.164596498985652e+03,		1.164874729786905e+03,
		1.165152526433583e+03,		1.165429890476128e+03,		1.165706823457999e+03,		1.165983326914122e+03,		1.166259402370953e+03,
		1.166535051346538e+03,		1.166810275350584e+03,		1.167085075884509e+03,		1.167359454441516e+03,		1.167633412506644e+03
	},
	{
		1.885492521097641e+00,		5.729953166034455e+00,		9.672553422404286e+00,		1.372012763561126e+01,		1.788032085879006e+01,
		2.216172806083818e+01,		2.657406556829120e+01,		3.112838436639128e+01,		3.583733848066695e+01,		4.071552690272929e+01,
		4.577993532357459e+01,		5.105051580817557e+01,		5.655096107794190e+01,		6.230975984995970e+01,		6.836166914913933e+01,
		7.474982486823113e+01,		8.152886587104629e+01,		8.876974000768212e+01,		9.656745518671934e+01,		1.050543464345740e+02,
		1.144246177998739e+02,		1.249848493140915e+02,		8.678057288178496e+02,		8.707327798280819e+02,		8.735476780420071e+02,
		8.762609217914830e+02,		8.788814818273902e+02,		8.814170951967660e+02,		8.838744901299672e+02,		8.862595607905840e+02,
		8.885775049260859e+02,		8.908329336231485e+02,		8.930299597851947e+02,		8.951722701685329e+02,		8.972631845645809e+02,
		8.993057048251317e+02,		9.013025557829172e+02,		9.032562196469746e+02,		9.051689651007996e+02,		9.070428720670508e+02,
		9.088798529022021e+02,		9.106816706302891e+02,		9.124499547068592e+02,		9.141862147054576e+02,		9.158918522606659e+02,
		9.175681715212877e+02,		9.192163883411557e+02,		9.208376383866550e+02,		9.224329843132424e+02,		9.240034221383054e+02,
		9.255498869176104e+02,		9.270732578160913e+02,		9.285743626500421e+02,		9.300539819665329e+02,		9.315128527162962e+02,
		9.329516715685239e+02,		9.343710979092839e+02,		9.357717565596586e+02,		9.371542402449454e+02,		9.385191118422068e+02,
		9.398669064299711e+02,		9.411981331609360e+02,		9.425132769760042e+02,		9.438128001757285e+02,		9.450971438633954e+02,
		9.463667292723196e+02,		9.476219589884746e+02,		9.488632180783713e+02,		9.500908751319517e+02,		9.513052832231217e+02,
		9.525067808069462e+02,		9.536956925450015e+02,		9.548723300748477e+02,		9.560369927248526e+02,		9.571899681795046e+02,
		9.583315330993577e+02,		9.594619536993205e+02,		9.605814862886338e+02,		9.616903777756326e+02,		9.627888661399975e+02,
		9.638771808750606e+02,		9.649555434024178e+02,		9.660241674609642e+02,		9.670832594722090e+02,		9.681330188836507e+02,
		9.691736384917806e+02,		9.702053047461626e+02,		9.712281980359365e+02,		9.722424929599638e+02,		9.732483585817382e+02,
		9.742459586700974e+02,		9.752354519266937e+02,		9.762169922010827e+02,		9.771907286942740e+02,		9.781568061514562e+02,
		9.791153650446111e+02,		9.800665417456502e+02,		9.810104686906644e+02,		9.819472745358432e+02,		9.828770843055612e+02,
		9.838000195331197e+02,		9.847161983945819e+02,		9.856257358360900e+02,		9.865287436960912e+02,		9.874253308171064e+02,
		9.883156031607897e+02,		9.891996639096880e+02,		9.900776135680094e+02,		9.909495500571034e+02,		9.918155688066116e+02,
		9.926757628415445e+02,		9.935302228655055e+02,		9.943790373402431e+02,		9.952222925617624e+02,		9.960600727336978e+02,
		9.968924600350318e+02,		9.977195346885493e+02,		9.985413750269881e+02,		9.993580575494028e+02,		1.000169656983271e+03,
		1.000976246340115e+03,		1.001777896969625e+03,		1.002574678611612e+03,		1.003366659445894e+03,		1.004153906140229e+03,
		1.004936483896362e+03,		1.005714456494310e+03,		1.006487886334930e+03,		1.007256834480882e+03,		1.008021360696038e+03,
		1.008781523483418e+03,		1.009537380121720e+03,		1.010288986700506e+03,		1.011036398154097e+03,		1.011779668294255e+03,
		1.012518849841667e+03,		1.013253994456330e+03,		1.013985152766845e+03,		1.014712374398692e+03,		1.015435708001516e+03,
		1.016155201275462e+03,		1.016870900996630e+03,		1.017582853041630e+03,		1.018291102411339e+03,		1.018995693253834e+03,
		1.019696668886581e+03,		1.020394071817881e+03,		1.021087943767613e+03,		1.021778325687300e+03,		1.022465257779530e+03,
		1.023148779516748e+03,		1.023828929659450e+03,		1.024505746273800e+03,		1.025179266750087e+03,		1.025849527814127e+03,
		1.026516565550440e+03,		1.027180415413300e+03,		1.027841112242840e+03,		1.028498690279639e+03,		1.029153183178877e+03,
		1.029804624024054e+03,		1.030453045340311e+03,		1.031098479107353e+03,		1.031740956771987e+03,		1.032380509260301e+03,
		1.033017166989478e+03,		1.033650959879285e+03,		1.034281917363217e+03,		1.034910068399336e+03,		1.035535441480788e+03,
		1.036158064646040e+03,		1.036777965488824e+03,		1.037395171167796e+03,		1.038009708415945e+03,		1.038621603549728e+03,
		1.039230882477965e+03,		1.039837570710490e+03,		1.040441693366560e+03,		1.041043275183063e+03,		1.041642340522472e+03,
		1.042238913380619e+03,		1.042833017394247e+03,		1.043424675848369e+03,		1.044013911683439e+03,		1.044600747502326e+03,
		1.045185205577122e+03,		1.045767307855767e+03,		1.046347075968506e+03,		1.046924531234187e+03,		1.047499694666395e+03,
		1.048072586979435e+03,		1.048643228594167e+03,		1.049211639643690e+03,		1.049777839978900e+03,		1.050341849173893e+03,
		1.050903686531250e+03,		1.051463371087189e+03,		1.052020921616598e+03,		1.052576356637932e+03,		1.053129694418015e+03,
		1.053680952976709e+03,		1.054230150091482e+03,		1.054777303301871e+03,		1.055322429913831e+03,		1.055865547003987e+03,
		1.056406671423799e+03,		1.056945819805022e+03,		1.057483008558383e+03,		1.058018253884948e+03,		1.058551571775178e+03,
		1.059082978013752e+03,		1.059612488183192e+03,		1.060140117667403e+03,		1.060665881655123e+03,		1.061189795143315e+03,
		1.061711872940475e+03,		1.062232129669862e+03,		1.062750579772671e+03,		1.063267237511124e+03,		1.063782116971503e+03,
		1.064295232067116e+03,		1.064806596541192e+03,		1.065316223969727e+03,		1.065824127764261e+03,		1.066330321174597e+03,
		1.066834817291467e+03,		1.067337629049137e+03,		1.067838769227963e+03,		1.068338250456885e+03,		1.068836085215889e+03,
		1.069332285838392e+03,		1.069826864513598e+03,		1.070319833288798e+03,		1.070811204071626e+03,		1.071300988632267e+03,
		1.071789198605627e+03,		1.072275845493445e+03,		1.072760940666381e+03,		1.073244495366054e+03,		1.073726520707033e+03,
		1.074207027678805e+03,		1.074686027147688e+03,		1.075163529858719e+03,		1.075639546437498e+03,		1.076114087391995e+03,
		1.076587163114338e+03,		1.077058783882540e+03,		1.077528959862218e+03,		1.077997701108265e+03,		1.078465017566494e+03,
		1.078930919075256e+03,		1.079395415367015e+03,		1.079858516069910e+03,		1.080320230709273e+03,		1.080780568709132e+03,
		1.081239539393672e+03,		1.081697151988682e+03,		1.082153415622969e+03,		1.082608339329748e+03,		1.083061932048003e+03,
		1.083514202623832e+03,		1.083965159811757e+03,		1.084414812276017e+03,		1.084863168591841e+03,		1.085310237246685e+03,
		1.085756026641467e+03,		1.086200545091758e+03,		1.086643800828971e+03,		1.087085802001518e+03,		1.087526556675950e+03,
		1.087966072838078e+03,		1.088404358394073e+03,		1.088841421171544e+03,		1.089277268920612e+03,		1.089711909314940e+03,
		1.090145349952773e+03,		1.090577598357936e+03,		1.091008661980834e+03,		1.091438548200832e+03,		1.091867264321871e+03,
		1.092294817581051e+03,		1.092721215144687e+03,		1.093146464110391e+03,		1.093570571507963e+03,		1.093993544300277e+03,
		1.094415389384149e+03,		1.094836113591187e+03,		1.095255723688630e+03,		1.095674226380177e+03,		1.096091628306795e+03,
		1.096507936047519e+03,		1.096923156120240e+03,		1.097337294982473e+03,		1.097750359032126e+03,		1.098162354608239e+03,
		1.098573287991729e+03,		1.098983165406109e+03,		1.099391993018206e+03,		1.099799776938862e+03,		1.100206523223625e+03,
		1.100612237873427e+03,		1.101016926835260e+03,		1.101420596002829e+03,		1.101823251217206e+03,		1.102224898267468e+03,
		1.102625542891323e+03,		1.103025190775734e+03,		1.103423847557531e+03,		1.103821518824004e+03,		1.104218210113502e+03,
		1.104613926916015e+03,		1.105008674673744e+03,		1.105402458781671e+03,		1.105795284588114e+03,		1.106187157395276e+03,
		1.106578082459785e+03,		1.106968064993227e+03,		1.107357110162670e+03,		1.107745223091182e+03,		1.108132408858341e+03,
		1.108518672500731e+03,		1.108904019012447e+03,		1.109288453345570e+03,		1.109671980410657e+03,		1.110054605077211e+03,
		1.110436332174144e+03,		1.110817166490240e+03,		1.111197112774613e+03,		1.111576175737139e+03,		1.111954360048914e+03,
		1.112331670342675e+03,		1.112708111213235e+03,		1.113083687217899e+03,		1.113458402876887e+03,		1.113832262673737e+03,
		1.114205271055715e+03,		1.114577432434207e+03,		1.114948751185123e+03,		1.115319231649270e+03,		1.115688878132748e+03,
		1.116057694907317e+03,		1.116425686210777e+03,		1.116792856247328e+03,		1.117159209187934e+03,		1.117524749170684e+03,
		1.117889480301134e+03,		1.118253406652666e+03,		1.118616532266823e+03,		1.118978861153647e+03,		1.119340397292016e+03,
		1.119701144629970e+03,		1.120061107085038e+03,		1.120420288544555e+03,		1.120778692865980e+03,		1.121136323877206e+03,
		1.121493185376870e+03,		1.121849281134657e+03,		1.122204614891594e+03,		1.122559190360355e+03,		1.122913011225541e+03,
		1.123266081143979e+03,		1.123618403745001e+03,		1.123969982630725e+03,		1.124320821376330e+03,		1.124670923530335e+03,
		1.125020292614864e+03,		1.125368932125912e+03,		1.125716845533614e+03,		1.126064036282496e+03,		1.126410507791742e+03,
		1.126756263455433e+03,		1.127101306642811e+03,		1.127445640698520e+03,		1.127789268942845e+03,		1.128132194671962e+03,
		1.128474421158166e+03,		1.128815951650115e+03,		1.129156789373054e+03,		1.129496937529048e+03,		1.129836399297209e+03,
		1.130175177833911e+03,		1.130513276273026e+03,		1.130850697726124e+03,		1.131187445282702e+03,		1.131523522010389e+03,
		1.131858930955160e+03,		1.132193675141540e+03,		1.132527757572810e+03,		1.132861181231211e+03,		1.133193949078142e+03,
		1.133526064054359e+03,		1.133857529080170e+03,		1.134188347055624e+03,		1.134518520860709e+03,		1.134848053355535e+03,
		1.135176947380519e+03,		1.135505205756574e+03,		1.135832831285286e+03,		1.136159826749095e+03,		1.136486194911476e+03,
		1.136811938517106e+03,		1.137137060292045e+03,		1.137461562943905e+03,		1.137785449162019e+03,		1.138108721617607e+03,
		1.138431382963944e+03,		1.138753435836521e+03,		1.139074882853207e+03,		1.139395726614414e+03,		1.139715969703244e+03,
		1.140035614685655e+03,		1.140354664110613e+03,		1.140673120510240e+03,		1.140990986399971e+03,		1.141308264278700e+03,
		1.141624956628926e+03,		1.141941065916902e+03,		1.142256594592779e+03,		1.142571545090743e+03,		1.142885919829166e+03,
		1.143199721210735e+03,		1.143512951622597e+03,		1.143825613436491e+03,		1.144137709008886e+03,		1.144449240681112e+03,
		1.144760210779492e+03,		1.145070621615475e+03,		1.145380475485760e+03,		1.145689774672429e+03,		1.145998521443068e+03,
		1.146306718050895e+03,		1.146614366734887e+03,		1.146921469719890e+03,		1.147228029216753e+03,		1.147534047422441e+03,
		1.147839526520153e+03,		1.148144468679440e+03,		1.148448876056322e+03,		1.148752750793399e+03,		1.149056095019966e+03,
		1.149358910852127e+03,		1.149661200392904e+03,		1.149962965732342e+03,		1.150264208947629e+03,		1.150564932103189e+03,
		1.150865137250800e+03,		1.151164826429692e+03,		1.151464001666653e+03,		1.151762664976136e+03,		1.152060818360353e+03,
		1.152358463809380e+03,		1.152655603301257e+03,		1.152952238802086e+03,		1.153248372266129e+03,		1.153544005635903e+03,
		1.153839140842278e+03,		1.154133779804569e+03,		1.154427924430632e+03,		1.154721576616955e+03,		1.155014738248752e+03,
		1.155307411200051e+03,		1.155599597333786e+03,		1.155891298501883e+03,		1.156182516545355e+03,		1.156473253294379e+03,
		1.156763510568391e+03,		1.157053290176169e+03,		1.157342593915912e+03,		1.157631423575335e+03,		1.157919780931740e+03,
		1.158207667752108e+03,		1.158495085793172e+03,		1.158782036801503e+03,		1.159068522513588e+03,		1.159354544655908e+03,
		1.159640104945017e+03,		1.159925205087619e+03,		1.160209846780646e+03,		1.160494031711331e+03,		1.160777761557285e+03,
		1.161061037986569e+03,		1.161343862657773e+03,		1.161626237218526e+03,		1.161908163311859e+03,		1.162189642566754e+03,
		1.162470676604620e+03,		1.162751267037753e+03,		1.163031415469401e+03,		1.163311123493831e+03,		1.163590392696400e+03,
		1.163869224653624e+03,		1.164147620933238e+03,		1.164425583094272e+03,		1.164703112687105e+03,		1.164980211253542e+03,
		1.165256880326867e+03,		1.165533121431917e+03,		1.165808936085135e+03,		1.166084325794643e+03,		1.166359292060295e+03
	},
	{
		1.881395917574640e+00,		5.716996844561269e+00,		9.649765214067944e+00,		1.368640515524126e+01,		1.783440782424657e+01,
		2.210218501888607e+01,		2.649923335432337e+01,		3.103633800652143e+01,		3.572582834784265e+01,		4.058190261352146e+01,
		4.562104586296761e+01,		5.086257628063331e+01,		5.632937158153271e+01,		6.204885395427711e+01,		6.805435588588867e+01,
		7.438706422330281e+01,		8.109887357123138e+01,		8.825673100184926e+01,		9.594955432123217e+01,		1.042998819738176e+02,
		1.134849598717575e+02,		1.237788243271728e+02,		8.623907435164551e+02,		8.654684304738931e+02,		8.684205506594298e+02,
		8.712595290948145e+02,		8.739958910193002e+02,		8.766386444558278e+02,		8.791955690116610e+02,		8.816734376149262e+02,
		8.840781893191225e+02,		8.864150657719337e+02,		8.886887202764636e+02,		8.909033058875822e+02,		8.930625472674822e+02,
		8.951697998151097e+02,		8.972280987187278e+02,		8.992401999527285e+02,		9.012086147776159e+02,		9.031356389574570e+02,
		9.050233776501192e+02,		9.068737667284370e+02,		9.086885911344466e+02,		9.104695007625319e+02,		9.122180242580405e+02,
		9.139355810608027e+02,		9.156234919568685e+02,		9.172829883581874e+02,		9.189152204925132e+02,		9.205212646557732e+02,
		9.221021296546427e+02,		9.236587625469680e+02,		9.251920537712762e+02,		9.267028417428149e+02,		9.281919169823287e+02,
		9.296600258342736e+02,		9.311078738231569e+02,		9.325361286901185e+02,		9.339454231461059e+02,		9.353363573732928e+02,
		9.367095013022334e+02,		9.380653966888407e+02,		9.394045590121948e+02,		9.407274792117191e+02,		9.420346252799834e+02,
		9.433264437255078e+02,		9.446033609192276e+02,		9.458657843306868e+02,		9.471141036759124e+02,		9.483486919711619e+02,
		9.495699065107735e+02,		9.507780897723892e+02,		9.519735702565121e+02,		9.531566632661255e+02,		9.543276716314988e+02,
		9.554868863848087e+02,		9.566345873887615e+02,		9.577710439229533e+02,		9.588965152314195e+02,		9.600112510344238e+02,
		9.611154920073116e+02,		9.622094702289852e+02,		9.632934096022768e+02,		9.643675262483946e+02,		9.654320288773138e+02,
		9.664871191359022e+02,		9.675329919353858e+02,		9.685698357596244e+02,		9.695978329555663e+02,		9.706171600070892e+02,
		9.716279877934139e+02,		9.726304818330987e+02,		9.736248025146048e+02,		9.746111053143230e+02,		9.755895410028630e+02,
		9.765602558403932e+02,		9.775233917617148e+02,		9.784790865517165e+02,		9.794274740118294e+02,		9.803686841189827e+02,
		9.813028431722195e+02,		9.822300739400189e+02,		9.831504957929974e+02,		9.840642248335865e+02,		9.849713740188330e+02,
		9.858720532773491e+02,		9.867663696207546e+02,		9.876544272499214e+02,		9.885363276563102e+02,		9.894121697186783e+02,
		9.902820497960571e+02,		9.911460618136317e+02,		9.920042973489019e+02,		9.928568457149497e+02,		9.937037940315851e+02,
		9.945452273030288e+02,		9.953812284875854e+02,		9.962118785652536e+02,		9.970372566024963e+02,		9.978574398143297e+02,
		9.986725036238400e+02,		9.994825217192894e+02,		1.000287566108898e+03,		1.001087707173434e+03,		1.001883013716721e+03,
		1.002673553014144e+03,		1.003459390859272e+03,		1.004240591608661e+03,		1.005017218224956e+03,		1.005789332318330e+03,
		1.006556994186378e+03,		1.007320262852500e+03,		1.008079196102872e+03,		1.008833850522041e+03,		1.009584281527232e+03,
		1.010330543401408e+03,		1.011072689325124e+03,		1.011810771407275e+03,		1.012544840714722e+03,		1.013274947300903e+03,
		1.014001140233429e+03,		1.014723467620739e+03,		1.015441976637820e+03,		1.016156713551074e+03,		1.016867723742319e+03,
		1.017575051732008e+03,		1.018278741202881e+03,		1.018978835017155e+03,		1.019675375243767e+03,		1.020368403174766e+03,
		1.021057959345862e+03,		1.021744083555437e+03,		1.022426814882937e+03,		1.023106191706690e+03,		1.023782251721154e+03,
		1.024455031953640e+03,		1.025124568780491e+03,		1.025790897942791e+03,		1.026454054561570e+03,		1.027114073152555e+03,
		1.027770987640479e+03,		1.028424831372945e+03,		1.029075637133899e+03,		1.029723437156681e+03,		1.030368263136708e+03,
		1.031010146243775e+03,		1.031649117134001e+03,		1.032285205961441e+03,		1.032918442389340e+03,		1.033548855601096e+03,
		1.034176474310881e+03,		1.034801326773995e+03,		1.035423440796901e+03,		1.036042843746996e+03,		1.036659562562115e+03,
		1.037273623759756e+03,		1.037885053446075e+03,		1.038493877324621e+03,		1.039100120704835e+03,		1.039703808510337e+03,
		1.040304965286972e+03,		1.040903615210650e+03,		1.041499782094985e+03,		1.042093489398726e+03,		1.042684760232996e+03,
		1.043273617368345e+03,		1.043860083241620e+03,		1.044444179962658e+03,		1.045025929320810e+03,		1.045605352791298e+03,
		1.046182471541415e+03,		1.046757306436561e+03,		1.047329878046141e+03,		1.047900206649304e+03,		1.048468312240551e+03,
		1.049034214535199e+03,		1.049597932976066e+03,		1.050159486733627e+03,		1.050718894718201e+03,		1.051276175580435e+03,
		1.051831347717200e+03,		1.052384429276308e+03,		1.052935438161132e+03,		1.053484392035099e+03,		1.054031308326091e+03,
		1.054576204230741e+03,		1.055119096718621e+03,		1.055660002536348e+03,		1.056198938211584e+03,		1.056735920056948e+03,
		1.057270964173841e+03,		1.057804086456184e+03,		1.058335302594071e+03,		1.058864628077340e+03,		1.059392078199067e+03,
		1.059917668058977e+03,		1.060441412566788e+03,		1.060963326445476e+03,		1.061483424234467e+03,		1.062001720292767e+03,
		1.062518228802014e+03,		1.063032963769479e+03,		1.063545939030983e+03,		1.064057168253771e+03,		1.064566664939312e+03,
		1.065074442426049e+03,		1.065580513892079e+03,		1.066084892357794e+03,		1.066587590688447e+03,		1.067088621596686e+03,
		1.067587997645015e+03,		1.068085731248221e+03,		1.068581834675743e+03,		1.069076320053990e+03,		1.069569199368624e+03,
		1.070060484466780e+03,		1.070550187059259e+03,		1.071038318722666e+03,		1.071524890901503e+03,		1.072009914910232e+03,
		1.072493401935286e+03,		1.072975363037048e+03,		1.073455809151790e+03,		1.073934751093564e+03,		1.074412199556077e+03,
		1.074888165114504e+03,		1.075362658227295e+03,		1.075835689237913e+03,		1.076307268376578e+03,		1.076777405761942e+03,
		1.077246111402753e+03,		1.077713395199483e+03,		1.078179266945929e+03,		1.078643736330768e+03,		1.079106812939105e+03,
		1.079568506253979e+03,		1.080028825657843e+03,		1.080487780434020e+03,		1.080945379768130e+03,		1.081401632749485e+03,
		1.081856548372477e+03,		1.082310135537916e+03,		1.082762403054365e+03,		1.083213359640833e+03,		1.083663013922780e+03,
		1.084111374440893e+03,		1.084558449647534e+03,		1.085004247909106e+03,		1.085448777507234e+03,		1.085892046639940e+03,
		1.086334063422795e+03,		1.086774835890038e+03,		1.087214371995698e+03,		1.087652679614677e+03,		1.088089766543822e+03,
		1.088525640502984e+03,		1.088960309136045e+03,		1.089393780011945e+03,		1.089826060625674e+03,		1.090257158399259e+03,
		1.090687080682733e+03,		1.091115834755082e+03,		1.091543427825181e+03,		1.091969867032713e+03,		1.092395159449075e+03,
		1.092819312078262e+03,		1.093242331857748e+03,		1.093664225659339e+03,		1.094085000290022e+03,		1.094504662492798e+03,
		1.094923218947497e+03,		1.095340676271588e+03,		1.095757041020968e+03,		1.096172319690738e+03,		1.096586518715979e+03,
		1.096999644472497e+03,		1.097411703277571e+03,		1.097822701390685e+03,		1.098232645014240e+03,		1.098641540294271e+03,
		1.099049393321138e+03,		1.099456210130212e+03,		1.099861996702555e+03,		1.100266758965577e+03,		1.100670502793696e+03,
		1.101073234008982e+03,		1.101474958381790e+03,		1.101875681631381e+03,		1.102275409426546e+03,		1.102674147386202e+03,
		1.103071901079994e+03,		1.103468676028881e+03,		1.103864477705715e+03,		1.104259311535810e+03,		1.104653182897503e+03,
		1.105046097122708e+03,		1.105438059497463e+03,		1.105829075262457e+03,		1.106219149613571e+03,		1.106608287702392e+03,
		1.106996494636725e+03,		1.107383775481103e+03,		1.107770135257280e+03,		1.108155578944731e+03,		1.108540111481122e+03,
		1.108923737762801e+03,		1.109306462645255e+03,		1.109688290943586e+03,		1.110069227432957e+03,		1.110449276849048e+03,
		1.110828443888495e+03,		1.111206733209333e+03,		1.111584149431420e+03,		1.111960697136871e+03,		1.112336380870466e+03,
		1.112711205140072e+03,		1.113085174417046e+03,		1.113458293136638e+03,		1.113830565698388e+03,		1.114201996466511e+03,
		1.114572589770292e+03,		1.114942349904454e+03,		1.115311281129542e+03,		1.115679387672291e+03,		1.116046673725982e+03,
		1.116413143450813e+03,		1.116778800974248e+03,		1.117143650391364e+03,		1.117507695765201e+03,		1.117870941127101e+03,
		1.118233390477039e+03,		1.118595047783965e+03,		1.118955916986117e+03,		1.119316001991356e+03,		1.119675306677474e+03,
		1.120033834892517e+03,		1.120391590455088e+03,		1.120748577154656e+03,		1.121104798751855e+03,		1.121460258978789e+03,
		1.121814961539315e+03,		1.122168910109340e+03,		1.122522108337108e+03,		1.122874559843479e+03,		1.123226268222209e+03,
		1.123577237040226e+03,		1.123927469837902e+03,		1.124276970129322e+03,		1.124625741402545e+03,		1.124973787119869e+03,
		1.125321110718089e+03,		1.125667715608752e+03,		1.126013605178407e+03,		1.126358782788852e+03,		1.126703251777388e+03,
		1.127047015457047e+03,		1.127390077116848e+03,		1.127732440022017e+03,		1.128074107414235e+03,		1.128415082511854e+03,
		1.128755368510140e+03,		1.129094968581483e+03,		1.129433885875631e+03,		1.129772123519900e+03,		1.130109684619399e+03,
		1.130446572257237e+03,		1.130782789494739e+03,		1.131118339371650e+03,		1.131453224906347e+03,		1.131787449096040e+03,
		1.132121014916972e+03,		1.132453925324620e+03,		1.132786183253889e+03,		1.133117791619312e+03,		1.133448753315234e+03,
		1.133779071216007e+03,		1.134108748176173e+03,		1.134437787030657e+03,		1.134766190594940e+03,		1.135093961665244e+03,
		1.135421103018716e+03,		1.135747617413596e+03,		1.136073507589391e+03,		1.136398776267062e+03,		1.136723426149172e+03,
		1.137047459920075e+03,		1.137370880246070e+03,		1.137693689775570e+03,		1.138015891139263e+03,		1.138337486950277e+03,
		1.138658479804331e+03,		1.138978872279902e+03,		1.139298666938371e+03,		1.139617866324184e+03,		1.139936472964999e+03,
		1.140254489371838e+03,		1.140571918039236e+03,		1.140888761445388e+03,		1.141205022052289e+03,		1.141520702305885e+03,
		1.141835804636212e+03,		1.142150331457533e+03,		1.142464285168482e+03,		1.142777668152196e+03,		1.143090482776456e+03,
		1.143402731393818e+03,		1.143714416341743e+03,		1.144025539942734e+03,		1.144336104504464e+03,		1.144646112319901e+03,
		1.144955565667438e+03,		1.145264466811019e+03,		1.145572818000262e+03,		1.145880621470581e+03,		1.146187879443308e+03,
		1.146494594125815e+03,		1.146800767711632e+03,		1.147106402380563e+03,		1.147411500298804e+03,		1.147716063619057e+03,
		1.148020094480648e+03,		1.148323595009629e+03,		1.148626567318905e+03,		1.148929013508332e+03,		1.149230935664828e+03,
		1.149532335862488e+03,		1.149833216162682e+03,		1.150133578614167e+03,		1.150433425253190e+03,		1.150732758103586e+03,
		1.151031579176890e+03,		1.151329890472433e+03,		1.151627693977440e+03,		1.151924991667134e+03,		1.152221785504833e+03,
		1.152518077442047e+03,		1.152813869418569e+03,		1.153109163362582e+03,		1.153403961190740e+03,		1.153698264808273e+03,
		1.153992076109069e+03,		1.154285396975773e+03,		1.154578229279872e+03,		1.154870574881794e+03,		1.155162435630979e+03,
		1.155453813365988e+03,		1.155744709914572e+03,		1.156035127093770e+03,		1.156325066709989e+03,		1.156614530559084e+03,
		1.156903520426452e+03,		1.157192038087107e+03,		1.157480085305761e+03,		1.157767663836911e+03,		1.158054775424912e+03,
		1.158341421802515e+03,		1.158627604697195e+03,		1.158913325821755e+03,		1.159198586880784e+03,		1.159483389569120e+03,
		1.159767735571930e+03,		1.160051626564781e+03,		1.160335064213712e+03,		1.160618050175315e+03,		1.160900586096798e+03,
		1.161182673616066e+03,		1.161464314361785e+03,		1.161745509953457e+03,		1.162026262001488e+03,		1.162306572107257e+03,
		1.162586441863187e+03,		1.162865872852806e+03,		1.163144866650826e+03,		1.163423424823197e+03,		1.163701548927182e+03,
		1.163979240511416e+03,		1.164256501115976e+03,		1.164533332272443e+03,		1.164809735503962e+03,		1.165085712325311e+03
	},
	{
		1.877317457467355e+00,		5.704102715356189e+00,		9.627095457021893e+00,		1.365287240220212e+01,		1.778877437259928e+01,
		2.204303455299665e+01,		2.642493573224496e+01,		3.094500495359648e+01,		3.561525706597698e+01,		4.044950309049736e+01,
		4.546374582869697e+01,		5.067669493569316e+01,		5.611044877731644e+01,		6.179141429050561e+01,		6.775157508941959e+01,
		7.403028407017045e+01,		8.067687311647285e+01,		8.775458777116073e+01,		9.534677684610359e+01,		1.035671558046278e+02,
		1.125780106339425e+02,		1.226255181849030e+02,		1.341175758092840e+02,		8.600426057729038e+02,		8.631460178783576e+02,
		8.661228618529312e+02,		8.689855779957403e+02,		8.717447227311296e+02,		8.744093439218315e+02,		8.769872651919626e+02,
		8.794853048975235e+02,		8.819094472365462e+02,		8.842649777020230e+02,		8.865565915599941e+02,		8.887884816393043e+02,
		8.909644100570570e+02,		8.930877673293339e+02,		8.951616214741219e+02,		8.971887590998823e+02,		8.991717200200442e+02,
		9.011128265965494e+02,		9.030142087606162e+02,		9.048778254577919e+02,		9.067054831324874e+02,		9.084988517234793e+02,
		9.102594785751547e+02,		9.119888005837694e+02,		9.136881548447656e+02,		9.153587880206927e+02,		9.170018646124458e+02,
		9.186184742863154e+02,		9.202096383851771e+02,		9.217763157317901e+02,		9.233194078159675e+02,		9.248397634434651e+02,
		9.263381829132040e+02,		9.278154217798833e+02,		9.292721942510434e+02,		9.307091762610438e+02,		9.321270082585561e+02,
		9.335262977395072e+02,		9.349076215532384e+02,		9.362715280061697e+02,		9.376185387841697e+02,		9.389491507133392e+02,
		9.402638373705014e+02,		9.415630505695294e+02,		9.428472217221636e+02,		9.441167630945615e+02,		9.453720689660549e+02,
		9.466135166996646e+02,		9.478414677324860e+02,		9.490562684930588e+02,		9.502582512522523e+02,		9.514477349133753e+02,
		9.526250257467693e+02,		9.537904180735500e+02,		9.549441949026790e+02,		9.560866285252795e+02,		9.572179810695535e+02,
		9.583385050194627e+02,		9.594484437000576e+02,		9.605480317319629e+02,		9.616374954574242e+02,		9.627170533400339e+02,
		9.637869163400841e+02,		9.648472882673603e+02,		9.658983661129695e+02,		9.669403403617315e+02,		9.679733952864864e+02,
		9.689977092255782e+02,		9.700134548446791e+02,		9.710207993840157e+02,		9.720199048919570e+02,		9.730109284459128e+02,
		9.739940223613256e+02,		9.749693343908135e+02,		9.759370079071772e+02,		9.768971820872438e+02,		9.778499920767299e+02,
		9.787955691511471e+02,		9.797340408678047e+02,		9.806655312102341e+02,		9.815901607255325e+02,		9.825080466550080e+02,
		9.834193030590391e+02,		9.843240409337396e+02,		9.852223683251741e+02,		9.861143904391967e+02,		9.870002097393066e+02,
		9.878799260476919e+02,		9.887536366379907e+02,		9.896214363245681e+02,		9.904834175478491e+02,		9.913396704558886e+02,
		9.921902829823853e+02,		9.930353409213285e+02,		9.938749279984644e+02,		9.947091259397166e+02,		9.955380145367506e+02,
		9.963616717098145e+02,		9.971801735679641e+02,		9.979935944668625e+02,		9.988020070642142e+02,		9.996054823729856e+02,
		1.000404089812510e+03,		1.001197897257570e+03,		1.001986971085570e+03,		1.002771376221865e+03,		1.003551176183370e+03,
		1.004326433120485e+03,		1.005097207857450e+03,		1.005863559931178e+03,		1.006625547628643e+03,		1.007383228022904e+03,
		1.008136657007789e+03,		1.008885889331340e+03,		1.009630978628031e+03,		1.010371977449862e+03,		1.011108937296327e+03,
		1.011841908644708e+03,		1.012570940973006e+03,		1.013296082793784e+03,		1.014017381675910e+03,		1.014734884270688e+03,
		1.015448636336141e+03,		1.016158682760478e+03,		1.016865067584771e+03,		1.017567834024884e+03,		1.018267024492692e+03,
		1.018962680616582e+03,		1.019654843261315e+03,		1.020343552547230e+03,		1.021028847868845e+03,		1.021710767912866e+03,
		1.022389350675619e+03,		1.023064633479950e+03,		1.023736652991585e+03,		1.024405445235000e+03,		1.025071045608791e+03,
		1.025733488900585e+03,		1.026392809301490e+03,		1.027049040420120e+03,		1.027702215296192e+03,		1.028352366413731e+03,
		1.028999525713879e+03,		1.029643724607314e+03,		1.030284993986345e+03,		1.030923364236614e+03,		1.031558865248495e+03,
		1.032191526428144e+03,		1.032821376708256e+03,		1.033448444558495e+03,		1.034072757995659e+03,		1.034694344593537e+03,
		1.035313231492507e+03,		1.035929445408863e+03,		1.036543012643898e+03,		1.037153959092720e+03,		1.037762310252851e+03,
		1.038368091232579e+03,		1.038971326759096e+03,		1.039572041186417e+03,		1.040170258503089e+03,		1.040766002339692e+03,
		1.041359295976159e+03,		1.041950162350070e+03,		1.042538624059239e+03,		1.043124703374560e+03,		1.043708422242791e+03,
		1.044289802293856e+03,		1.044868864847128e+03,		1.045445630917504e+03,		1.046020121221370e+03,		1.046592356182396e+03,
		1.047162355937192e+03,		1.047730140340829e+03,		1.048295728972220e+03,		1.048859141139383e+03,		1.049420395884550e+03,
		1.049979511989181e+03,		1.050536507978848e+03,		1.051091402127991e+03,		1.051644212464583e+03,		1.052194956774674e+03,
		1.052743652606819e+03,		1.053290317276421e+03,		1.053834967869960e+03,		1.054377621249143e+03,		1.054918294054917e+03,
		1.055457002711448e+03,		1.055993763429966e+03,		1.056528592212532e+03,		1.057061504855736e+03,		1.057592516954298e+03,
		1.058121643904587e+03,		1.058648900908077e+03,		1.059174302974702e+03,		1.059697864926171e+03,		1.060219601399178e+03,
		1.060739526848557e+03,		1.061257655550373e+03,		1.061774001604941e+03,		1.062288578939774e+03,		1.062801401312475e+03,
		1.063312482313577e+03,		1.063821835369300e+03,		1.064329473744270e+03,		1.064835410544170e+03,		1.065339658718341e+03,
		1.065842231062331e+03,		1.066343140220382e+03,		1.066842398687875e+03,		1.067340018813717e+03,		1.067836012802688e+03,
		1.068330392717739e+03,		1.068823170482231e+03,		1.069314357882148e+03,		1.069803966568251e+03,		1.070292008058195e+03,
		1.070778493738601e+03,		1.071263434867100e+03,		1.071746842574308e+03,		1.072228727865793e+03,		1.072709101623993e+03,
		1.073187974610078e+03,		1.073665357465811e+03,		1.074141260715345e+03,		1.074615694766994e+03,		1.075088669916439e+03,
		1.075560196342921e+03,		1.076030284118730e+03,		1.076498943205903e+03,		1.076966183459006e+03,		1.077432014626719e+03,
		1.077896446353378e+03,		1.078359488180507e+03,		1.078821149548312e+03,		1.079281439797130e+03,		1.079740368168899e+03,
		1.080197943808539e+03,		1.080654175765355e+03,		1.081109072994400e+03,		1.081562644357810e+03,		1.082014898626116e+03,
		1.082465844479530e+03,		1.082915490509217e+03,		1.083363845218546e+03,		1.083810917024297e+03,		1.084256714257867e+03,
		1.084701245166460e+03,		1.085144517914230e+03,		1.085586540583429e+03,		1.086027321175523e+03,		1.086466867612291e+03,
		1.086905187736911e+03,		1.087342289315010e+03,		1.087778180035718e+03,		1.088212867512694e+03,		1.088646359285126e+03,
		1.089078662818733e+03,		1.089509785506722e+03,		1.089939734670773e+03,		1.090368517561955e+03,		1.090796141361673e+03,
		1.091222613182561e+03,		1.091647940069395e+03,		1.092072128999954e+03,		1.092495186885911e+03,		1.092917120573666e+03,
		1.093337936845191e+03,		1.093757642418858e+03,		1.094176243950244e+03,		1.094593748032935e+03,		1.095010161199308e+03,
		1.095425489921308e+03,		1.095839740611203e+03,		1.096252919622332e+03,		1.096665033249850e+03,		1.097076087731443e+03,
		1.097486089248051e+03,		1.097895043924556e+03,		1.098302957830488e+03,		1.098709836980698e+03,		1.099115687336028e+03,
		1.099520514803970e+03,		1.099924325239322e+03,		1.100327124444812e+03,		1.100728918171746e+03,		1.101129712120614e+03,
		1.101529511941704e+03,		1.101928323235702e+03,		1.102326151554295e+03,		1.102723002400733e+03,		1.103118881230422e+03,
		1.103513793451475e+03,		1.103907744425284e+03,		1.104300739467055e+03,		1.104692783846358e+03,		1.105083882787649e+03,
		1.105474041470811e+03,		1.105863265031656e+03,		1.106251558562438e+03,		1.106638927112364e+03,		1.107025375688072e+03,
		1.107410909254131e+03,		1.107795532733526e+03,		1.108179251008108e+03,		1.108562068919087e+03,		1.108943991267482e+03,
		1.109325022814563e+03,		1.109705168282316e+03,		1.110084432353874e+03,		1.110462819673948e+03,		1.110840334849266e+03,
		1.111216982448985e+03,		1.111592767005106e+03,		1.111967693012899e+03,		1.112341764931287e+03,		1.112714987183263e+03,
		1.113087364156269e+03,		1.113458900202595e+03,		1.113829599639756e+03,		1.114199466750870e+03,		1.114568505785024e+03,
		1.114936720957660e+03,		1.115304116450913e+03,		1.115670696413981e+03,		1.116036464963480e+03,		1.116401426183785e+03,
		1.116765584127372e+03,		1.117128942815159e+03,		1.117491506236843e+03,		1.117853278351220e+03,		1.118214263086520e+03,
		1.118574464340719e+03,		1.118933885981864e+03,		1.119292531848376e+03,		1.119650405749358e+03,		1.120007511464908e+03,
		1.120363852746414e+03,		1.120719433316844e+03,		1.121074256871050e+03,		1.121428327076042e+03,		1.121781647571284e+03,
		1.122134221968977e+03,		1.122486053854318e+03,		1.122837146785796e+03,		1.123187504295448e+03,		1.123537129889130e+03,
		1.123886027046784e+03,		1.124234199222686e+03,		1.124581649845715e+03,		1.124928382319604e+03,		1.125274400023192e+03,
		1.125619706310654e+03,		1.125964304511769e+03,		1.126308197932151e+03,		1.126651389853480e+03,		1.126993883533749e+03,
		1.127335682207488e+03,		1.127676789085992e+03,		1.128017207357552e+03,		1.128356940187685e+03,		1.128695990719337e+03,
		1.129034362073116e+03,		1.129372057347500e+03,		1.129709079619051e+03,		1.130045431942637e+03,		1.130381117351615e+03,
		1.130716138858057e+03,		1.131050499452948e+03,		1.131384202106379e+03,		1.131717249767753e+03,		1.132049645365982e+03,
		1.132381391809663e+03,		1.132712491987296e+03,		1.133042948767448e+03,		1.133372764998951e+03,		1.133701943511089e+03,
		1.134030487113773e+03,		1.134358398597718e+03,		1.134685680734633e+03,		1.135012336277388e+03,		1.135338367960186e+03,
		1.135663778498741e+03,		1.135988570590441e+03,		1.136312746914523e+03,		1.136636310132230e+03,		1.136959262886983e+03,
		1.137281607804533e+03,		1.137603347493136e+03,		1.137924484543695e+03,		1.138245021529928e+03,		1.138564961008514e+03,
		1.138884305519250e+03,		1.139203057585207e+03,		1.139521219712871e+03,		1.139838794392296e+03,		1.140155784097246e+03,
		1.140472191285338e+03,		1.140788018398201e+03,		1.141103267861591e+03,		1.141417942085553e+03,		1.141732043464541e+03,
		1.142045574377575e+03,		1.142358537188358e+03,		1.142670934245416e+03,		1.142982767882235e+03,		1.143294040417379e+03,
		1.143604754154638e+03,		1.143914911383134e+03,		1.144224514377465e+03,		1.144533565397820e+03,		1.144842066690111e+03,
		1.145150020486082e+03,		1.145457429003444e+03,		1.145764294445985e+03,		1.146070619003698e+03,		1.146376404852886e+03,
		1.146681654156286e+03,		1.146986369063184e+03,		1.147290551709524e+03,		1.147594204218020e+03,		1.147897328698274e+03,
		1.148199927246878e+03,		1.148502001947526e+03,		1.148803554871121e+03,		1.149104588075884e+03,		1.149405103607453e+03,
		1.149705103498992e+03,		1.150004589771295e+03,		1.150303564432886e+03,		1.150602029480115e+03,		1.150899986897270e+03,
		1.151197438656661e+03,		1.151494386718733e+03,		1.151790833032150e+03,		1.152086779533898e+03,		1.152382228149379e+03,
		1.152677180792498e+03,		1.152971639365769e+03,		1.153265605760397e+03,		1.153559081856369e+03,		1.153852069522550e+03,
		1.154144570616770e+03,		1.154436586985903e+03,		1.154728120465974e+03,		1.155019172880689e+03,		1.155309746047737e+03,
		1.155599841769473e+03,		1.155889461839331e+03,		1.156178608040308e+03,		1.156467282145043e+03,		1.156755485915908e+03,
		1.157043221105081e+03,		1.157330489454628e+03,		1.157617292696576e+03,		1.157903632553003e+03,		1.158189510736109e+03,
		1.158474928948290e+03,		1.158759888882219e+03,		1.159044392220916e+03,		1.159328440637833e+03,		1.159612035796911e+03,
		1.159895179352668e+03,		1.160177872950270e+03,		1.160460118225588e+03,		1.160741916805286e+03,		1.161023270306889e+03,
		1.161304180338836e+03,		1.161584648500573e+03,		1.161864676382604e+03,		1.162144265566564e+03,		1.162423417625286e+03,
		1.162702134122874e+03,		1.162980416614750e+03,		1.163258266647741e+03,		1.163535685760129e+03,		1.163812675481721e+03
	},
	{
		1.873257016719425e+00,		5.691270293876322e+00,		9.604543112707994e+00,		1.361952752037267e+01,		1.774341746984367e+01,
		2.198427195631506e+01,		2.635116563841359e+01,		3.085437483522747e+01,		3.550560961705363e+01,		4.031830677221720e+01,
		4.530800438684525e+01,		5.049282768183924e+01,		5.589412938998608e+01,		6.153734939444909e+01,		6.745319306647130e+01,
		7.367928590949252e+01,		8.026256350961349e+01,		8.726284091395495e+01,		9.475836277861305e+01,		1.028548729888271e+02,
		1.117013983305052e+02,		1.215200886906527e+02,		1.326695167959125e+02,		8.544392486642073e+02,		8.577103846041250e+02,
		8.608391278627749e+02,		8.638403043925490e+02,		8.667263754415619e+02,		8.695079319435234e+02,		8.721940634314083e+02,
		8.747926384199787e+02,		8.773105209541146e+02,		8.797537402478214e+02,		8.821276252676973e+02,		8.844369127245346e+02,
		8.866858346206526e+02,		8.888781898876838e+02,		8.910174035065687e+02,		8.931065756792281e+02,		8.951485230200998e+02,
		8.971458132935433e+02,		8.991007948847106e+02,		9.010156219537606e+02,		9.028922760113477e+02,		9.047325845225586e+02,
		9.065382370215982e+02,		9.083107991317288e+02,		9.100517248131205e+02,		9.117623671041146e+02,		9.134439875758228e+02,
		9.150977646830114e+02,		9.167248011643536e+02,		9.183261306206585e+02,		9.199027233796942e+02,		9.214554917396692e+02,
		9.229852946697250e+02,		9.244929420344439e+02,		9.259791983997837e+02,		9.274447864699180e+02,		9.288903901976290e+02,
		9.303166576053029e+02,		9.317242033486112e+02,		9.331136110518479e+02,		9.344854354346284e+02,		9.358402042621420e+02,
		9.371784201247501e+02,		9.385005620725925e+02,		9.398070871165031e+02,		9.410984316087400e+02,		9.423750125150465e+02,
		9.436372285882868e+02,		9.448854614527816e+02,		9.461200766074610e+02,		9.473414243551282e+02,		9.485498406643611e+02,
		9.497456479698974e+02,		9.509291559167524e+02,		9.521006620528542e+02,		9.532604524744137e+02,		9.544088024279474e+02,
		9.555459768724120e+02,		9.566722310046367e+02,		9.577878107509389e+02,		9.588929532275091e+02,		9.599878871719818e+02,
		9.610728333483205e+02,		9.621480049270397e+02,		9.632136078425276e+02,		9.642698411291617e+02,		9.653168972377099e+02,
		9.663549623334075e+02,		9.673842165769991e+02,		9.684048343909805e+02,		9.694169847061589e+02,		9.704208312033909e+02,
		9.714165325341171e+02,		9.724042425327317e+02,		9.733841104169759e+02,		9.743562809777665e+02,		9.753208947591776e+02,
		9.762780882291514e+02,		9.772279939420641e+02,		9.781707406907501e+02,		9.791064536541086e+02,		9.800352545386536e+02,
		9.809572617056253e+02,		9.818725903002377e+02,		9.827813523707953e+02,		9.836836569829147e+02,		9.845796103284133e+02,
		9.854693158291732e+02,		9.863528742362377e+02,		9.872303837244223e+02,		9.881019399826745e+02,		9.889676363004235e+02,
		9.898275636501224e+02,		9.906818107661958e+02,		9.915304642205759e+02,		9.923736084949985e+02,		9.932113260502506e+02,
		9.940436973924972e+02,		9.948708011368473e+02,		9.956927140683024e+02,		9.965095112002115e+02,		9.973212658303597e+02,
		9.981280495947983e+02,		9.989299325195378e+02,		9.997269830701989e+02,		1.000519268199716e+03,		1.001306853394198e+03,
		1.002089802717019e+03,		1.002868178851220e+03,		1.003642043140330e+03,		1.004411455627617e+03,		1.005176475095343e+03,
		1.005937159096013e+03,		1.006693563994563e+03,		1.007445744997780e+03,		1.008193756187913e+03,		1.008937650554101e+03,
		1.009677480022674e+03,		1.010413295486402e+03,		1.011145146832709e+03,		1.011873082970917e+03,		1.012597151858548e+03,
		1.013317400526730e+03,		1.014033875104736e+03,		1.014746620843709e+03,		1.015455682139581e+03,		1.016161102555243e+03,
		1.016862924841970e+03,		1.017561190960169e+03,		1.018255942099428e+03,		1.018947218697941e+03,		1.019635060461291e+03,
		1.020319506380652e+03,		1.021000594750415e+03,		1.021678363185245e+03,		1.022352848636634e+03,		1.023024087408914e+03,
		1.023692115174802e+03,		1.024356966990455e+03,		1.025018677310077e+03,		1.025677280000083e+03,		1.026332808352839e+03,
		1.026985295099995e+03,		1.027634772425429e+03,		1.028281271977797e+03,		1.028924824882739e+03,		1.029565461754708e+03,
		1.030203212708479e+03,		1.030838107370316e+03,		1.031470174888824e+03,		1.032099443945502e+03,		1.032725942764989e+03,
		1.033349699125028e+03,		1.033970740366160e+03,		1.034589093402322e+03,		1.035204784725669e+03,		1.035817840421548e+03,
		1.036428286173384e+03,		1.037036147272019e+03,		1.037641448623918e+03,		1.038244214759170e+03,		1.038844469839271e+03,
		1.039442237664703e+03,		1.040037541682316e+03,		1.040630404992520e+03,		1.041220850356286e+03,		1.041808900201972e+03,
		1.042394576631974e+03,		1.042977901429203e+03,		1.043558896063407e+03,		1.044137581697328e+03,		1.044713979192702e+03,
		1.045288109116122e+03,		1.045859991744741e+03,		1.046429647071849e+03,		1.046997094812303e+03,		1.047562354407828e+03,
		1.048125445032195e+03,		1.048686385596265e+03,		1.049245194752920e+03,		1.049801890901875e+03,		1.050356492194369e+03,
		1.050909016537760e+03,		1.051459481599995e+03,		1.052007904813988e+03,		1.052554303381895e+03,		1.053098694279284e+03,
		1.053641094259212e+03,		1.054181519856216e+03,		1.054719987390199e+03,		1.055256512970243e+03,		1.055791112498326e+03,
		1.056323801672958e+03,		1.056854595992738e+03,		1.057383510759832e+03,		1.057910561083372e+03,		1.058435761882778e+03,
		1.058959127891015e+03,		1.059480673657778e+03,		1.060000413552591e+03,		1.060518361767867e+03,		1.061034532321883e+03,
		1.061548939061694e+03,		1.062061595665991e+03,		1.062572515647893e+03,		1.063081712357685e+03,		1.063589198985489e+03,
		1.064094988563897e+03,		1.064599093970522e+03,		1.065101527930533e+03,		1.065602303019097e+03,		1.066101431663806e+03,
		1.066598926148356e+03,		1.067094798609910e+03,		1.067589061048360e+03,		1.068081725324141e+03,		1.068572803161450e+03,
		1.069062306150388e+03,		1.069550245749047e+03,		1.070036633285561e+03,		1.070521479960113e+03,		1.071004796846913e+03,
		1.071486594896123e+03,		1.071966884935753e+03,		1.072445677673522e+03,		1.072922983698676e+03,		1.073398813483776e+03,
		1.073873177386449e+03,		1.074346085651111e+03,		1.074817548410652e+03,		1.075287575688087e+03,		1.075756177398183e+03,
		1.076223363349055e+03,		1.076689143243722e+03,		1.077153526681648e+03,		1.077616523160242e+03,		1.078078142076344e+03,
		1.078538392727666e+03,		1.078997284314224e+03,		1.079454825939735e+03,		1.079911026612984e+03,		1.080365895249185e+03,
		1.080819440671289e+03,		1.081271671611297e+03,		1.081722596711532e+03,		1.082172224525889e+03,		1.082620563521077e+03,
		1.083067622077818e+03,		1.083513408492046e+03,		1.083957930976067e+03,		1.084401197659710e+03,		1.084843216591456e+03,
		1.085283995739544e+03,		1.085723542993060e+03,		1.086161866163009e+03,		1.086598972983364e+03,		1.087034871112103e+03,
		1.087469568132224e+03,		1.087903071552743e+03,		1.088335388809677e+03,		1.088766527267013e+03,		1.089196494217650e+03,
		1.089625296884340e+03,		1.090052942420603e+03,		1.090479437911628e+03,		1.090904790375166e+03,		1.091329006762397e+03,
		1.091752093958794e+03,		1.092174058784967e+03,		1.092594907997492e+03,		1.093014648289729e+03,		1.093433286292631e+03,
		1.093850828575528e+03,		1.094267281646910e+03,		1.094682651955198e+03,		1.095096945889486e+03,		1.095510169780293e+03,
		1.095922329900293e+03,		1.096333432465027e+03,		1.096743483633615e+03,		1.097152489509454e+03,		1.097560456140901e+03,
		1.097967389521946e+03,		1.098373295592879e+03,		1.098778180240946e+03,		1.099182049300987e+03,		1.099584908556075e+03,
		1.099986763738139e+03,		1.100387620528578e+03,		1.100787484558866e+03,		1.101186361411149e+03,		1.101584256618835e+03,
		1.101981175667166e+03,		1.102377123993794e+03,		1.102772106989337e+03,		1.103166129997939e+03,		1.103559198317802e+03,
		1.103951317201737e+03,		1.104342491857683e+03,		1.104732727449230e+03,		1.105122029096134e+03,		1.105510401874818e+03,
		1.105897850818878e+03,		1.106284380919565e+03,		1.106669997126275e+03,		1.107054704347022e+03,		1.107438507448912e+03,
		1.107821411258602e+03,		1.108203420562760e+03,		1.108584540108512e+03,		1.108964774603886e+03,		1.109344128718254e+03,
		1.109722607082756e+03,		1.110100214290728e+03,		1.110476954898125e+03,		1.110852833423928e+03,		1.111227854350555e+03,
		1.111602022124262e+03,		1.111975341155535e+03,		1.112347815819491e+03,		1.112719450456252e+03,		1.113090249371332e+03,
		1.113460216836005e+03,		1.113829357087687e+03,		1.114197674330283e+03,		1.114565172734564e+03,		1.114931856438507e+03,
		1.115297729547657e+03,		1.115662796135464e+03,		1.116027060243625e+03,		1.116390525882423e+03,		1.116753197031056e+03,
		1.117115077637965e+03,		1.117476171621155e+03,		1.117836482868515e+03,		1.118196015238133e+03,		1.118554772558602e+03,
		1.118912758629331e+03,		1.119269977220844e+03,		1.119626432075077e+03,		1.119982126905676e+03,		1.120337065398284e+03,
		1.120691251210827e+03,		1.121044687973801e+03,		1.121397379290545e+03,		1.121749328737522e+03,		1.122100539864589e+03,
		1.122451016195263e+03,		1.122800761226991e+03,		1.123149778431408e+03,		1.123498071254598e+03,		1.123845643117344e+03,
		1.124192497415388e+03,		1.124538637519672e+03,		1.124884066776590e+03,		1.125228788508224e+03,		1.125572806012590e+03,
		1.125916122563871e+03,		1.126258741412648e+03,		1.126600665786139e+03,		1.126941898888416e+03,		1.127282443900641e+03,
		1.127622303981278e+03,		1.127961482266322e+03,		1.128299981869508e+03,		1.128637805882529e+03,		1.128974957375248e+03,
		1.129311439395908e+03,		1.129647254971332e+03,		1.129982407107133e+03,		1.130316898787918e+03,		1.130650732977480e+03,
		1.130983912618999e+03,		1.131316440635233e+03,		1.131648319928717e+03,		1.131979553381944e+03,		1.132310143857560e+03,
		1.132640094198546e+03,		1.132969407228399e+03,		1.133298085751317e+03,		1.133626132552376e+03,		1.133953550397708e+03,
		1.134280342034671e+03,		1.134606510192031e+03,		1.134932057580120e+03,		1.135256986891019e+03,		1.135581300798711e+03,
		1.135905001959256e+03,		1.136228093010949e+03,		1.136550576574482e+03,		1.136872455253103e+03,		1.137193731632774e+03,
		1.137514408282326e+03,		1.137834487753613e+03,		1.138153972581664e+03,		1.138472865284835e+03,		1.138791168364953e+03,
		1.139108884307470e+03,		1.139426015581599e+03,		1.139742564640468e+03,		1.140058533921255e+03,		1.140373925845332e+03,
		1.140688742818399e+03,		1.141002987230628e+03,		1.141316661456798e+03,		1.141629767856421e+03,		1.141942308773885e+03,
		1.142254286538582e+03,		1.142565703465035e+03,		1.142876561853031e+03,		1.143186863987747e+03,		1.143496612139871e+03,
		1.143805808565734e+03,		1.144114455507428e+03,		1.144422555192931e+03,		1.144730109836220e+03,		1.145037121637403e+03,
		1.145343592782824e+03,		1.145649525445189e+03,		1.145954921783673e+03,		1.146259783944042e+03,		1.146564114058761e+03,
		1.146867914247105e+03,		1.147171186615277e+03,		1.147473933256504e+03,		1.147776156251161e+03,		1.148077857666863e+03,
		1.148379039558582e+03,		1.148679703968747e+03,		1.148979852927348e+03,		1.149279488452038e+03,		1.149578612548236e+03,
		1.149877227209228e+03,		1.150175334416264e+03,		1.150472936138658e+03,		1.150770034333887e+03,		1.151066630947684e+03,
		1.151362727912561e+03,		1.151658327154265e+03,		1.151953430582229e+03,		1.152248040096161e+03,		1.152542157584493e+03,
		1.152835784924475e+03,		1.153128923982261e+03,		1.153421576612998e+03,		1.153713744660917e+03,		1.154005429959417e+03,
		1.154296634331153e+03,		1.154587359588118e+03,		1.154877607531732e+03,		1.155167379952924e+03,		1.155456678632212e+03,
		1.155745505339789e+03,		1.156033861835602e+03,		1.156321749869432e+03,		1.156609171180972e+03,		1.156896127499912e+03,
		1.157182620546010e+03,		1.157468652029172e+03,		1.157754223649529e+03,		1.158039337097510e+03,		1.158323994053922e+03,
		1.158608196190020e+03,		1.158891945167581e+03,		1.159175242638976e+03,		1.159458090247247e+03,		1.159740489626171e+03,
		1.160022442400338e+03,		1.160303950185215e+03,		1.160585014587218e+03,		1.160865637203781e+03,		1.161145819623424e+03,
		1.161425563425819e+03,		1.161704870181858e+03,		1.161983741453718e+03,		1.162262178794927e+03,		1.162540183750430e+03
	},
	{
		1.869214472451258e+00,		5.678499101079117e+00,		9.582107156178811e+00,		1.358636868116748e+01,		1.769833413233283e+01,
		2.192589260875794e+01,		2.627791615316342e+01,		3.076443751214416e+01,		3.539687135473338e+01,		4.018829268473221e+01,
		4.515379162922527e+01,		5.031093188884423e+01,		5.568035246576159e+01,		6.128657153145890e+01,		6.715908221382492e+01,
		7.333388141014969e+01,		7.985566123877381e+01,		8.678105228542780e+01,		9.418361096144832e+01,		1.021618573011724e+02,
		1.108530155432133e+02,		1.204583756502813e+02,		1.312952737609965e+02,		8.486395316754276e+02,		8.520977630369827e+02,
		8.553947733738854e+02,		8.585483983551293e+02,		8.615734683056596e+02,		8.644824696570229e+02,		8.672860300942158e+02,
		8.699932818161169e+02,		8.726121384451263e+02,		8.751495094506756e+02,		8.776114685081037e+02,		8.800033873362152e+02,
		8.823300432824680e+02,		8.845957066796390e+02,		8.868042124290080e+02,		8.889590191507592e+02,		8.910632584364405e+02,
		8.931197761526120e+02,		8.951311672986699e+02,		8.970998056164050e+02,		8.990278688694119e+02,		9.009173605483446e+02,
		9.027701285960308e+02,		9.045878816365999e+02,		9.063722031023545e+02,		9.081245635807646e+02,		9.098463316473960e+02,
		9.115387834048751e+02,		9.132031109113060e+02,		9.148404296516482e+02,		9.164517851811623e+02,		9.180381590499527e+02,
		9.196004741011550e+02,		9.211395992215373e+02,		9.226563536119231e+02,		9.241515106351817e+02,		9.256258012916647e+02,
		9.270799173649725e+02,		9.285145142768359e+02,		9.299302136760818e+02,		9.313276058065269e+02,		9.327072516583706e+02,
		9.340696849386377e+02,		9.354154138745496e+02,		9.367449228674028e+02,		9.380586740117685e+02,		9.393571084931168e+02,
		9.406406478755193e+02,		9.419096952897670e+02,		9.431646365310968e+02,		9.444058410748098e+02,		9.456336630170729e+02,
		9.468484419475590e+02,		9.480505037598047e+02,		9.492401614046303e+02,		9.504177155914076e+02,		9.515834554415071e+02,
		9.527376590978405e+02,		9.538805942940161e+02,		9.550125188863507e+02,		9.561336813515917e+02,		9.572443212530799e+02,
		9.583446696776776e+02,		9.594349496456963e+02,		9.605153764958478e+02,		9.615861582470043e+02,		9.626474959397893e+02,
		9.636995839522801e+02,		9.647426103079933e+02,		9.657767569566169e+02,		9.668022000432985e+02,		9.678191101621037e+02,
		9.688276525954760e+02,		9.698279875406643e+02,		9.708202703244726e+02,		9.718046516042481e+02,		9.727812775612907e+02,
		9.737502900857422e+02,		9.747118269439916e+02,		9.756660219461336e+02,		9.766130051009039e+02,		9.775529027636567e+02,
		9.784858377770577e+02,		9.794119296049194e+02,		9.803312944595808e+02,		9.812440454232197e+02,		9.821502925634201e+02,
		9.830501430433493e+02,		9.839437012268320e+02,		9.848310687786102e+02,		9.857123447600520e+02,		9.865876257205709e+02,
		9.874570057849693e+02,		9.883205767369373e+02,		9.891784280989052e+02,		9.900306472084494e+02,		9.908773192914200e+02,
		9.917185275319741e+02,		9.925543531396505e+02,		9.933848754136686e+02,		9.942101718045573e+02,		9.950303179732723e+02,
		9.958453878479072e+02,		9.966554536781332e+02,		9.974605860874616e+02,		9.982608541248438e+02,		9.990563253078988e+02,
		9.998470656761374e+02,		1.000633139831317e+03,		1.001414610981301e+03,		1.002191540981314e+03,		1.002963990373639e+03,
		1.003732018425847e+03,		1.004495683167600e+03,		1.005255041426127e+03,		1.006010148860379e+03,		1.006761059993984e+03,
		1.007507828246996e+03,		1.008250505966536e+03,		1.008989144456339e+03,		1.009723794005276e+03,		1.010454503914881e+03,
		1.011181322525934e+03,		1.011904297244135e+03,		1.012623474564901e+03,		1.013338900097331e+03,		1.014050618587378e+03,
		1.014758673940234e+03,		1.015463109241995e+03,		1.016163966780604e+03,		1.016861288066126e+03,		1.017555113850350e+03,
		1.018245484145791e+03,		1.018932438244059e+03,		1.019616014733666e+03,		1.020296251517267e+03,		1.020973185828369e+03,
		1.021646854247516e+03,		1.022317292717977e+03,		1.022984536560967e+03,		1.023648620490392e+03,		1.024309578627148e+03,
		1.024967444513012e+03,		1.025622251124102e+03,		1.026274030883937e+03,		1.026922815676126e+03,		1.027568636858128e+03,
		1.028211525267920e+03,		1.028851511242949e+03,		1.029488624626849e+03,		1.030122894781471e+03,		1.030754350597534e+03,
		1.031383020504975e+03,		1.032008932483010e+03,		1.032632114069916e+03,		1.033252592372550e+03,		1.033870394075592e+03,
		1.034485545450551e+03,		1.035098072364519e+03,		1.035708000288686e+03,		1.036315354306650e+03,		1.036920159122465e+03,
		1.037522439068518e+03,		1.038122218113164e+03,		1.038719519868194e+03,		1.039314367596083e+03,		1.039906784217052e+03,
		1.040496792315972e+03,		1.041084414149072e+03,		1.041669671650464e+03,		1.042252586438541e+03,		1.042833179822177e+03,
		1.043411472806795e+03,		1.043987486100268e+03,		1.044561240118694e+03,		1.045132754992003e+03,		1.045702050569451e+03,
		1.046269146424968e+03,		1.046834061862373e+03,		1.047396815920477e+03,		1.047957427378047e+03,		1.048515914758669e+03,
		1.049072296335480e+03,		1.049626590135798e+03,		1.050178813945641e+03,		1.050728985314139e+03,		1.051277121557846e+03,
		1.051823239764950e+03,		1.052367356799386e+03,		1.052909489304855e+03,		1.053449653708763e+03,		1.053987866226042e+03,
		1.054524142862918e+03,		1.055058499420573e+03,		1.055590951498732e+03,		1.056121514499174e+03,		1.056650203629155e+03,
		1.057177033904766e+03,		1.057702020154212e+03,		1.058225177022312e+03,		1.058746518968849e+03,		1.059266060278365e+03,
		1.059783815058948e+03,		1.060299797246168e+03,		1.060814020605962e+03,		1.061326498737446e+03,		1.061837245075677e+03,
		1.062346272894352e+03,		1.062853595308454e+03,		1.063359225276839e+03,		1.063863175604771e+03,		1.064365458946411e+03,
		1.064866087807242e+03,		1.065365074546453e+03,		1.065862431379280e+03,		1.066358170379285e+03,		1.066852303480598e+03,
		1.067344842480117e+03,		1.067835799039656e+03,		1.068325184688056e+03,		1.068813010822553e+03,		1.069299288713640e+03,
		1.069784029502737e+03,		1.070267244207058e+03,		1.070748943721329e+03,		1.071229138817447e+03,		1.071707840149683e+03,
		1.072185058254206e+03,		1.072660803551426e+03,		1.073135086347728e+03,		1.073607916837175e+03,		1.074079305103171e+03,
		1.074549261120102e+03,		1.075017794754940e+03,		1.075484915768822e+03,		1.075950633818588e+03,		1.076414958458310e+03,
		1.076877899140775e+03,		1.077339465218950e+03,		1.077799665947416e+03,		1.078258510483778e+03,		1.078716007890053e+03,
		1.079172167134020e+03,		1.079626997090565e+03,		1.080080506542981e+03,		1.080532704184265e+03,		1.080983598618374e+03,
		1.081433198361471e+03,		1.081881511843145e+03,		1.082328547407602e+03,		1.082774313314856e+03,		1.083218817741869e+03,
		1.083662068783702e+03,		1.084104074454623e+03,		1.084544842689208e+03,		1.084984381343415e+03,		1.085422698195653e+03,
		1.085859800947813e+03,		1.086295697226299e+03,		1.086730394583036e+03,		1.087163900496453e+03,		1.087596222372463e+03,
		1.088027367545416e+03,		1.088457343279040e+03,		1.088886156767367e+03,		1.089313815135642e+03,		1.089740325441219e+03,
		1.090165694674438e+03,		1.090589929759496e+03,		1.091013037555291e+03,		1.091435024856265e+03,		1.091855898393227e+03,
		1.092275664834160e+03,		1.092694330785023e+03,		1.093111902790532e+03,		1.093528387334936e+03,		1.093943790842771e+03,
		1.094358119679611e+03,		1.094771380152807e+03,		1.095183578512205e+03,		1.095594720950859e+03,		1.096004813605740e+03,
		1.096413862558416e+03,		1.096821873835743e+03,		1.097228853410521e+03,		1.097634807202165e+03,		1.098039741077349e+03,
		1.098443660850640e+03,		1.098846572285138e+03,		1.099248481093081e+03,		1.099649392936468e+03,		1.100049313427650e+03,
		1.100448248129930e+03,		1.100846202558135e+03,		1.101243182179202e+03,		1.101639192412732e+03,		1.102034238631554e+03,
		1.102428326162271e+03,		1.102821460285800e+03,		1.103213646237903e+03,		1.103604889209717e+03,		1.103995194348267e+03,
		1.104384566756968e+03,		1.104773011496144e+03,		1.105160533583504e+03,		1.105547137994643e+03,		1.105932829663515e+03,
		1.106317613482906e+03,		1.106701494304906e+03,		1.107084476941361e+03,		1.107466566164335e+03,		1.107847766706549e+03,
		1.108228083261828e+03,		1.108607520485525e+03,		1.108986082994963e+03,		1.109363775369846e+03,		1.109740602152679e+03,
		1.110116567849178e+03,		1.110491676928676e+03,		1.110865933824519e+03,		1.111239342934460e+03,		1.111611908621050e+03,
		1.111983635212015e+03,		1.112354527000639e+03,		1.112724588246132e+03,		1.113093823174001e+03,		1.113462235976407e+03,
		1.113829830812527e+03,		1.114196611808901e+03,		1.114562583059787e+03,		1.114927748627495e+03,		1.115292112542733e+03,
		1.115655678804935e+03,		1.116018451382593e+03,		1.116380434213584e+03,		1.116741631205485e+03,		1.117102046235893e+03,
		1.117461683152738e+03,		1.117820545774586e+03,		1.118178637890950e+03,		1.118535963262585e+03,		1.118892525621785e+03,
		1.119248328672676e+03,		1.119603376091504e+03,		1.119957671526921e+03,		1.120311218600263e+03,		1.120664020905829e+03,
		1.121016082011158e+03,		1.121367405457291e+03,		1.121717994759050e+03,		1.122067853405288e+03,		1.122416984859161e+03,
		1.122765392558375e+03,		1.123113079915448e+03,		1.123460050317956e+03,		1.123806307128778e+03,		1.124151853686347e+03,
		1.124496693304882e+03,		1.124840829274636e+03,		1.125184264862124e+03,		1.125527003310359e+03,		1.125869047839075e+03,
		1.126210401644965e+03,		1.126551067901892e+03,		1.126891049761122e+03,		1.127230350351530e+03,		1.127568972779826e+03,
		1.127906920130763e+03,		1.128244195467347e+03,		1.128580801831049e+03,		1.128916742242002e+03,		1.129252019699215e+03,
		1.129586637180764e+03,		1.129920597643996e+03,		1.130253904025721e+03,		1.130586559242407e+03,		1.130918566190371e+03,
		1.131249927745965e+03,		1.131580646765771e+03,		1.131910726086772e+03,		1.132240168526547e+03,		1.132568976883441e+03,
		1.132897153936751e+03,		1.133224702446897e+03,		1.133551625155595e+03,		1.133877924786033e+03,		1.134203604043038e+03,
		1.134528665613242e+03,		1.134853112165252e+03,		1.135176946349813e+03,		1.135500170799966e+03,		1.135822788131214e+03,
		1.136144800941676e+03,		1.136466211812244e+03,		1.136787023306743e+03,		1.137107237972074e+03,		1.137426858338375e+03,
		1.137745886919169e+03,		1.138064326211504e+03,		1.138382178696109e+03,		1.138699446837531e+03,		1.139016133084286e+03,
		1.139332239868992e+03,		1.139647769608515e+03,		1.139962724704103e+03,		1.140277107541525e+03,		1.140590920491207e+03,
		1.140904165908363e+03,		1.141216846133129e+03,		1.141528963490696e+03,		1.141840520291431e+03,		1.142151518831018e+03,
		1.142461961390571e+03,		1.142771850236771e+03,		1.143081187621980e+03,		1.143389975784369e+03,		1.143698216948039e+03,
		1.144005913323139e+03,		1.144313067105985e+03,		1.144619680479179e+03,		1.144925755611722e+03,		1.145231294659131e+03,
		1.145536299763551e+03,		1.145840773053869e+03,		1.146144716645828e+03,		1.146448132642125e+03,		1.146751023132538e+03,
		1.147053390194016e+03,		1.147355235890798e+03,		1.147656562274514e+03,		1.147957371382745e+03,		1.148257665245360e+03,
		1.148557445875175e+03,		1.148856715274413e+03,		1.149155475433201e+03,		1.149453728329665e+03,		1.149751475930032e+03,
		1.150048720188722e+03,		1.150345463048451e+03,		1.150641706440315e+03,		1.150937452283897e+03,		1.151232702487350e+03,
		1.151527458947495e+03,		1.151821723549908e+03,		1.152115498169013e+03,		1.152408784668171e+03,		1.152701584899768e+03,
		1.152993900705301e+03,		1.153285733915469e+03,		1.153577086350253e+03,		1.153867959819007e+03,		1.154158356120534e+03,
		1.154448277043181e+03,		1.154737724364908e+03,		1.155026699853381e+03,		1.155315205266045e+03,		1.155603242350207e+03,
		1.155890812843117e+03,		1.156177918472044e+03,		1.156464560954352e+03,		1.156750741997583e+03,		1.157036463299524e+03,
		1.157321726548292e+03,		1.157606533422402e+03,		1.157890885590842e+03,		1.158174784713150e+03,		1.158458232439483e+03,
		1.158741230410687e+03,		1.159023780258373e+03,		1.159305883604985e+03,		1.159587542063868e+03,		1.159868757239341e+03,
		1.160149530726761e+03,		1.160429864112594e+03,		1.160709758974481e+03,		1.160989216881304e+03,		1.161268239393253e+03
	},
	{
		1.865189702945400e+00,		5.665788663337628e+00,		9.559786575853360e+00,		1.355339408297606e+01,		1.765352142562950e+01,
		2.186789197481804e+01,		2.620518049678314e+01,		3.067518307102813e+01,		3.528902799179815e+01,		4.005944041978191e+01,
		4.500107853560099e+01,		5.013096632205241e+01,		5.546905925697415e+01,		6.103899649058535e+01,		6.686912064310246e+01,
		7.299389170524209e+01,		7.945589890540799e+01,		8.630881218872757e+01,		9.362187292518415e+01,		1.014870365875405e+02,
		1.100309796810200e+02,		1.194367728273881e+02,		1.299869328288080e+02,		1.421615536436297e+02,		8.462895546209110e+02,
		8.497740982395392e+02,		8.530964632533650e+02,		8.562744632797239e+02,		8.593229383263404e+02,		8.622544026778813e+02,
		8.650795218329274e+02,		8.678074707432459e+02,		8.704462076431424e+02,		8.730026865945550e+02,		8.754830247212695e+02,
		8.778926353987810e+02,		8.802363354946268e+02,		8.825184325722257e+02,		8.847427964427351e+02,		8.869129183587071e+02,
		8.890319603520854e+02,		8.911027966522715e+02,		8.931280486713699e+02,		8.951101147385069e+02,		8.970511955103343e+02,
		8.989533157997605e+02,		9.008183434190456e+02,		9.026480055198517e+02,		9.044439028234991e+02,		9.062075220638403e+02,
		9.079402469086328e+02,		9.096433675799728e+02,		9.113180893575145e+02,		9.129655401184760e+02,		9.145867770439766e+02,
		9.161827926012187e+02,		9.177545198944367e+02,		9.193028374638699e+02,		9.208285736004567e+02,		9.223325102356861e+02,
		9.238153864502682e+02,		9.252779016592921e+02,		9.267207184940621e+02,		9.281444654252115e+02,		9.295497391511460e+02,
		9.309371067774163e+02,		9.323071078088703e+02,		9.336602559737968e+02,		9.349970408969372e+02,		9.363179296364046e+02,
		9.376233680976574e+02,		9.389137823363506e+02,		9.401895797604653e+02,		9.414511502410469e+02,		9.426988671398680e+02,
		9.439330882614518e+02,		9.451541567360953e+02,		9.463624018399183e+02,		9.475581397572967e+02,		9.487416742905240e+02,
		9.499132975210878e+02,		9.510732904265087e+02,		9.522219234563348e+02,		9.533594570704998e+02,		9.544861422430455e+02,
		9.556022209348375e+02,		9.567079265322434e+02,		9.578034842666437e+02,		9.588891116011475e+02,		9.599650185973281e+02,
		9.610314082595448e+02,		9.620884768590818e+02,		9.631364142394866e+02,		9.641754041049587e+02,		9.652056242902266e+02,
		9.662272470181077e+02,		9.672404391445571e+02,		9.682453623825041e+02,		9.692421735219656e+02,		9.702310246344617e+02,
		9.712120632674154e+02,		9.721854326284182e+02,		9.731512717600218e+02,		9.741097157056240e+02,		9.750608956669982e+02,
		9.760049391539869e+02,		9.769419701268123e+02,		9.778721091314442e+02,		9.787954734284448e+02,		9.797121771156541e+02,
		9.806223312450894e+02,		9.815260439343577e+02,		9.824234204729285e+02,		9.833145634235223e+02,		9.841995727188994e+02,
		9.850785457542999e+02,		9.859515774757667e+02,		9.868187604645774e+02,		9.876801850179828e+02,		9.885359392264610e+02,
		9.893861090476481e+02,		9.902307783771464e+02,		9.910700291175917e+02,		9.919039412391882e+02,		9.927325928480876e+02,
		9.935560602424363e+02,		9.943744179705667e+02,		9.951877388860182e+02,		9.959960942003755e+02,		9.967995535340107e+02,
		9.975981849648342e+02,		9.983920550751625e+02,		9.991812289967628e+02,		9.999657704541916e+02,		1.000745741806481e+03,
		1.001521204087265e+03,		1.002292217043401e+03,		1.003058839172176e+03,		1.003821127757132e+03,		1.004579138902598e+03,
		1.005332927566979e+03,		1.006082547594836e+03,		1.006828051747847e+03,		1.007569491734651e+03,		1.008306918239676e+03,
		1.009040380950941e+03,		1.009769928586910e+03,		1.010495608922431e+03,		1.011217468813787e+03,		1.011935554222902e+03,
		1.012649910240745e+03,		1.013360581109943e+03,		1.014067610246667e+03,		1.014771040261781e+03,		1.015470912981319e+03,
		1.016167269466288e+03,		1.016860150031850e+03,		1.017549594265880e+03,		1.018235641046945e+03,		1.018918328561715e+03,
		1.019597694323017e+03,		1.020273775181892e+03,		1.020946607349358e+03,		1.021616226408106e+03,		1.022282667328252e+03,
		1.022945964481785e+03,		1.023606151656573e+03,		1.024263262069963e+03,		1.024917328381972e+03,		1.025568382708100e+03,
		1.026216456631743e+03,		1.026861581216289e+03,		1.027503787016826e+03,		1.028143104092658e+03,		1.028779562012728e+03,
		1.029413189877665e+03,		1.030044016318929e+03,		1.030672069514619e+03,		1.031297377198226e+03,		1.031919966668215e+03,
		1.032539864797384e+03,		1.033157098041937e+03,		1.033771692450322e+03,		1.034383673671831e+03,		1.034993066964977e+03,
		1.035599897205621e+03,		1.036204188894922e+03,		1.036805966167046e+03,		1.037405252796694e+03,		1.038002072206410e+03,
		1.038596447473743e+03,		1.039188401338162e+03,		1.039777956207855e+03,		1.040365134166325e+03,		1.040949956978813e+03,
		1.041532446098575e+03,		1.042112622672996e+03,		1.042690507549555e+03,		1.043266121281633e+03,		1.043839484134191e+03,
		1.044410616089298e+03,		1.044979536851524e+03,		1.045546265853220e+03,		1.046110822259642e+03,		1.046673224973978e+03,
		1.047233492642243e+03,		1.047791643658050e+03,		1.048347696167291e+03,		1.048901668072688e+03,		1.049453577038241e+03,
		1.050003440494964e+03,		1.050551275640027e+03,		1.051097099448036e+03,		1.051640928670632e+03,		1.052182779841500e+03,
		1.052722669280244e+03,		1.053260613096175e+03,		1.053796627192003e+03,		1.054330727267465e+03,		1.054862928822851e+03,
		1.055393247162470e+03,		1.055921697398032e+03,		1.056448294451956e+03,		1.056973053060603e+03,		1.057495987777446e+03,
		1.058017112976165e+03,		1.058536442853682e+03,		1.059053991433121e+03,		1.059569772566718e+03,		1.060083799938656e+03,
		1.060596087067852e+03,		1.061106647310676e+03,		1.061615493863619e+03,		1.062122639765902e+03,		1.062628097902037e+03,
		1.063131881003121e+03,		1.063634001654181e+03,		1.064134472289124e+03,		1.064633305198140e+03,		1.065130512528724e+03,
		1.065626106287936e+03,		1.066120098345432e+03,		1.066612500432303e+03,		1.067103324148278e+03,		1.067592580960372e+03,
		1.068080282205796e+03,		1.068566439093966e+03,		1.069051062708461e+03,		1.069534164008955e+03,		1.070015753833101e+03,
		1.070495842898378e+03,		1.070974441803917e+03,		1.071451561032272e+03,		1.071927210951173e+03,		1.072401401815238e+03,
		1.072874143767652e+03,		1.073345446841822e+03,		1.073815320962990e+03,		1.074283775949824e+03,		1.074750821515977e+03,
		1.075216467271615e+03,		1.075680722724920e+03,		1.076143597283567e+03,		1.076605100256162e+03,		1.077065240853673e+03,
		1.077524028190818e+03,		1.077981471287435e+03,		1.078437579069830e+03,		1.078892360372095e+03,		1.079345823937405e+03,
		1.079797978419293e+03,		1.080248832382900e+03,		1.080698394306203e+03,		1.081146672581227e+03,		1.081593675515224e+03,
		1.082039411331845e+03,		1.082483888172283e+03,		1.082927114096395e+03,		1.083369097083812e+03,		1.083809845035024e+03,
		1.084249365772446e+03,		1.084687667041474e+03,		1.085124756511509e+03,		1.085560641776976e+03,		1.085995330358320e+03,
		1.086428829702991e+03,		1.086861147186396e+03,		1.087292290112858e+03,		1.087722265716546e+03,		1.088151081162387e+03,
		1.088578743546973e+03,		1.089005259899443e+03,		1.089430637182354e+03,		1.089854882292546e+03,		1.090278002061977e+03,
		1.090700003258560e+03,		1.091120892586973e+03,		1.091540676689466e+03,		1.091959362146651e+03,		1.092376955478280e+03,
		1.092793463144010e+03,		1.093208891544155e+03,		1.093623247020425e+03,		1.094036535856662e+03,		1.094448764279554e+03,
		1.094859938459338e+03,		1.095270064510502e+03,		1.095679148492465e+03,		1.096087196410255e+03,		1.096494214215168e+03,
		1.096900207805424e+03,		1.097305183026813e+03,		1.097709145673321e+03,		1.098112101487760e+03,		1.098514056162380e+03,
		1.098915015339475e+03,		1.099314984611977e+03,		1.099713969524042e+03,		1.100111975571631e+03,		1.100509008203078e+03,
		1.100905072819650e+03,		1.101300174776098e+03,		1.101694319381203e+03,		1.102087511898314e+03,		1.102479757545873e+03,
		1.102871061497933e+03,		1.103261428884679e+03,		1.103650864792925e+03,		1.104039374266616e+03,		1.104426962307320e+03,
		1.104813633874706e+03,		1.105199393887026e+03,		1.105584247221581e+03,		1.105968198715188e+03,		1.106351253164634e+03,
		1.106733415327123e+03,		1.107114689920722e+03,		1.107495081624803e+03,		1.107874595080465e+03,		1.108253234890966e+03,
		1.108631005622136e+03,		1.109007911802795e+03,		1.109383957925160e+03,		1.109759148445242e+03,		1.110133487783247e+03,
		1.110506980323964e+03,		1.110879630417151e+03,		1.111251442377916e+03,		1.111622420487088e+03,		1.111992568991591e+03,
		1.112361892104803e+03,		1.112730394006923e+03,		1.113098078845321e+03,		1.113464950734885e+03,		1.113831013758374e+03,
		1.114196271966750e+03,		1.114560729379521e+03,		1.114924389985068e+03,		1.115287257740975e+03,		1.115649336574347e+03,
		1.116010630382136e+03,		1.116371143031448e+03,		1.116730878359856e+03,		1.117089840175706e+03,		1.117448032258420e+03,
		1.117805458358791e+03,		1.118162122199282e+03,		1.118518027474310e+03,		1.118873177850538e+03,		1.119227576967154e+03,
		1.119581228436155e+03,		1.119934135842617e+03,		1.120286302744970e+03,		1.120637732675268e+03,		1.120988429139451e+03,
		1.121338395617610e+03,		1.121687635564241e+03,		1.122036152408506e+03,		1.122383949554481e+03,		1.122731030381405e+03,
		1.123077398243930e+03,		1.123423056472357e+03,		1.123768008372880e+03,		1.124112257227821e+03,		1.124455806295866e+03,
		1.124798658812295e+03,		1.125140817989205e+03,		1.125482287015742e+03,		1.125823069058321e+03,		1.126163167260846e+03,
		1.126502584744924e+03,		1.126841324610083e+03,		1.127179389933983e+03,		1.127516783772623e+03,		1.127853509160551e+03,
		1.128189569111066e+03,		1.128524966616419e+03,		1.128859704648015e+03,		1.129193786156606e+03,		1.129527214072492e+03,
		1.129859991305704e+03,		1.130192120746201e+03,		1.130523605264060e+03,		1.130854447709650e+03,		1.131184650913825e+03,
		1.131514217688107e+03,		1.131843150824854e+03,		1.132171453097447e+03,		1.132499127260462e+03,		1.132826176049841e+03,
		1.133152602183065e+03,		1.133478408359318e+03,		1.133803597259664e+03,		1.134128171547201e+03,		1.134452133867230e+03,
		1.134775486847417e+03,		1.135098233097948e+03,		1.135420375211687e+03,		1.135741915764339e+03,		1.136062857314593e+03,
		1.136383202404284e+03,		1.136702953558536e+03,		1.137022113285917e+03,		1.137340684078581e+03,		1.137658668412416e+03,
		1.137976068747188e+03,		1.138292887526683e+03,		1.138609127178848e+03,		1.138924790115927e+03,		1.139239878734601e+03,
		1.139554395416130e+03,		1.139868342526475e+03,		1.140181722416438e+03,		1.140494537421798e+03,		1.140806789863432e+03,
		1.141118482047451e+03,		1.141429616265322e+03,		1.141740194793997e+03,		1.142050219896037e+03,		1.142359693819737e+03,
		1.142668618799242e+03,		1.142976997054676e+03,		1.143284830792253e+03,		1.143592122204402e+03,		1.143898873469876e+03,
		1.144205086752311e+03,		1.144510764206666e+03,		1.144815907969732e+03,		1.145120520166721e+03,		1.145424602909739e+03,
		1.145728158297895e+03,		1.146031188417411e+03,		1.146333695341726e+03,		1.146635681131603e+03,		1.146937147835237e+03,
		1.147238097488354e+03,		1.147538532114319e+03,		1.147838453724231e+03,		1.148137864317031e+03,		1.148436765879597e+03,
		1.148735160386845e+03,		1.149033049801823e+03,		1.149330436075810e+03,		1.149627321148413e+03,		1.149923706947659e+03,
		1.150219595390090e+03,		1.150514988380853e+03,		1.150809887813798e+03,		1.151104295571561e+03,		1.151398213525658e+03,
		1.151691643536576e+03,		1.151984587453854e+03,		1.152277047116180e+03,		1.152569024351467e+03,		1.152860520976948e+03,
		1.153151538799251e+03,		1.153442079614490e+03,		1.153732145208346e+03,		1.154021737356149e+03,		1.154310857822958e+03,
		1.154599508363640e+03,		1.154887690722955e+03,		1.155175406635629e+03,		1.155462657826439e+03,		1.155749446010283e+03,
		1.156035772892259e+03,		1.156321640167743e+03,		1.156607049522461e+03,		1.156892002632568e+03,		1.157176501164714e+03,
		1.157460546776128e+03,		1.157744141114675e+03,		1.158027285818943e+03,		1.158309982518304e+03,		1.158592232832987e+03,
		1.158874038374146e+03,		1.159155400743936e+03,		1.159436321535568e+03,		1.159716802333389e+03,		1.159996844712940e+03
	},
	{
		1.861182587632124e+00,		5.653138512357425e+00,		9.537580373278415e+00,		1.352060195061663e+01,		1.760897646339151e+01,
		2.181026560143934e+01,		2.613295202563651e+01,		3.058660181762432e+01,		3.518206558812991e+01,		3.993173011400986e+01,
		4.484983693784736e+01,		4.995289108037930e+01,		5.526019311386803e+01,		6.079454339302842e+01,		6.658319183467117e+01,
		7.265914674946951e+01,		7.906302398787160e+01,		8.584573688345586e+01,		9.307254755430108e+01,		1.008294303815774e+02,
		1.092336008152766e+02,		1.184521295279604e+02,		1.287378739838790e+02,		1.405079595838884e+02,		8.402637624312325e+02,
		8.439587559501348e+02,		8.474690062278034e+02,		8.508161374398959e+02,		8.540179477062973e+02,		8.570892897901056e+02,
		8.600427068486431e+02,		8.628889020108487e+02,		8.656370921095468e+02,		8.682952787445886e+02,		8.708704591420889e+02,
		8.733687923817963e+02,		8.757957320102366e+02,		8.781561329777643e+02,		8.804543387135948e+02,		8.826942526580073e+02,
		8.848793974988732e+02,		8.870129646046090e+02,		8.890978555461473e+02,		8.911367172053407e+02,		8.931319716330499e+02,
		8.950858415825119e+02,		8.970003724566577e+02,		8.988774512639358e+02,		9.007188230642589e+02,		9.025261052979789e+02,
		9.043008003202743e+02,		9.060443064070516e+02,		9.077579274531763e+02,		9.094428815472040e+02,		9.111003085770030e+02,
		9.127312769962828e+02,		9.143367898618935e+02,		9.159177902363788e+02,		9.174751660299952e+02,		9.190097543620810e+02,
		9.205223454862177e+02,		9.220136863391746e+02,		9.234844837537485e+02,		9.249354073738001e+02,		9.263670923044150e+02,
		9.277801415258770e+02,		9.291751280965520e+02,		9.305525971667021e+02,		9.319130678226120e+02,		9.332570347780814e+02,
		9.345849699283744e+02,		9.358973237799891e+02,		9.371945267681049e+02,		9.384769904722433e+02,		9.397451087395616e+02,
		9.409992587241584e+02,		9.422398018499101e+02,		9.434670847035659e+02,		9.446814398641452e+02,		9.458831866740828e+02,
		9.470726319570177e+02,		9.482500706866432e+02,		9.494157866117428e+02,		9.505700528349095e+02,		9.517131323622526e+02,
		9.528452786097855e+02,		9.539667358812658e+02,		9.550777398154310e+02,		9.561785178055966e+02,		9.572692893940789e+02,
		9.583502666409971e+02,		9.594216544733880e+02,		9.604836510156955e+02,		9.615364478937527e+02,		9.625802305290151e+02,
		9.636151784125535e+02,		9.646414653643980e+02,		9.656592597785777e+02,		9.666687248547952e+02,		9.676700188176121e+02,
		9.686632951239498e+02,		9.696487026596731e+02,		9.706263859259234e+02,		9.715964852158589e+02,		9.725591367823990e+02,
		9.735144729975063e+02,		9.744626225035388e+02,		9.754037103571422e+02,		9.763378581661096e+02,		9.772651842196518e+02,
		9.781858036124254e+02,		9.790998283627188e+02,		9.800073675250856e+02,		9.809085272977634e+02,		9.818034111251809e+02,
		9.826921197957814e+02,		9.835747515364992e+02,		9.844514020984165e+02,		9.853221648469878e+02,		9.861871308406775e+02,
		9.870463889097250e+02,		9.879000257308686e+02,		9.887481258989037e+02,		9.895907719952223e+02,		9.904280446534966e+02,
		9.912600226226463e+02,		9.920867828272242e+02,		9.929084004253534e+02,		9.937249488643247e+02,		9.945364999339881e+02,
		9.953431238180151e+02,		9.961448891431700e+02,		9.969418630266420e+02,		9.977341111215754e+02,		9.985216976608439e+02,
		9.993046854991611e+02,		1.000083136153626e+03,		1.000857109842737e+03,		1.001626665523965e+03,		1.002391860929959e+03,
		1.003152752603423e+03,		1.003909395930726e+03,		1.004661845174328e+03,		1.005410153504029e+03,		1.006154373027132e+03,
		1.006894554817540e+03,		1.007630748943847e+03,		1.008363004496454e+03,		1.009091369613761e+03,		1.009815891507470e+03,
		1.010536616487021e+03,		1.011253589983230e+03,		1.011966856572307e+03,		1.012676459993697e+03,		1.013382443177269e+03,
		1.014084848260396e+03,		1.014783716608805e+03,		1.015479088835915e+03,		1.016171004821598e+03,		1.016859503730323e+03,
		1.017544624028731e+03,		1.018226403502678e+03,		1.018904879273725e+03,		1.019580087815139e+03,		1.020252064968502e+03,
		1.020920845953240e+03,		1.021586465392213e+03,		1.022248957314846e+03,		1.022908355176364e+03,		1.023564691870001e+03,
		1.024217999739928e+03,		1.024868310593806e+03,		1.025515655714954e+03,		1.026160065874201e+03,		1.026801571341362e+03,
		1.027440201896412e+03,		1.028075986840335e+03,		1.028708955005664e+03,		1.029339134766735e+03,		1.029966554049647e+03,
		1.030591240341955e+03,		1.031213220702090e+03,		1.031832521768528e+03,		1.032449169768705e+03,		1.033063190527691e+03,
		1.033674609476642e+03,		1.034283451661008e+03,		1.034889741748548e+03,		1.035493504037105e+03,		1.036094762462203e+03,
		1.036693540604431e+03,		1.037289861696640e+03,		1.037883748630955e+03,		1.038475223965610e+03,		1.039064309931598e+03,
		1.039651028439170e+03,		1.040235401084153e+03,		1.040817449154117e+03,		1.041397193635665e+03,		1.041974655215653e+03,
		1.042549854293343e+03,		1.043122810981993e+03,		1.043693545115228e+03,		1.044262076252365e+03,		1.044828423683579e+03,
		1.045392606434983e+03,		1.045954643273551e+03,		1.046514552711947e+03,		1.047072353013229e+03,		1.047628062195450e+03,
		1.048181698036142e+03,		1.048733278076705e+03,		1.049282819626687e+03,		1.049830339767975e+03,		1.050375855358876e+03,
		1.050919383038115e+03,		1.051460939228744e+03,		1.052000540141954e+03,		1.052538201780808e+03,		1.053073939943887e+03,
		1.053607770228861e+03,		1.054139708035970e+03,		1.054669768571437e+03,		1.055197966850807e+03,		1.055724317702205e+03,
		1.056248835769533e+03,		1.056771535515592e+03,		1.057292431225128e+03,		1.057811537007838e+03,		1.058328866801290e+03,
		1.058844434373784e+03,		1.059358253327161e+03,		1.059870337099546e+03,		1.060380698968035e+03,		1.060889352051329e+03,
		1.061396309311063e+03,		1.061901583560561e+03,		1.062405187454847e+03,		1.062907133505526e+03,		1.063407434076930e+03,
		1.063906101389684e+03,		1.064403147522982e+03,		1.064898584416822e+03,		1.065392423874190e+03,		1.065884677563207e+03,
		1.066375357019222e+03,		1.066864473646878e+03,		1.067352038722127e+03,		1.067838063394210e+03,		1.068322558687598e+03,
		1.068805535503892e+03,		1.069287004623693e+03,		1.069766976708426e+03,		1.070245462302143e+03,		1.070722471833274e+03,
		1.071198015616362e+03,		1.071672103853754e+03,		1.072144746637261e+03,		1.072615953949792e+03,		1.073085735666958e+03,
		1.073554101558634e+03,		1.074021061290507e+03,		1.074486624425588e+03,		1.074950800425698e+03,		1.075413598652921e+03,
		1.075875028371043e+03,		1.076335098746948e+03,		1.076793818852010e+03,		1.077251197663434e+03,		1.077707244065600e+03,
		1.078161966851358e+03,		1.078615374723319e+03,		1.079067476295112e+03,		1.079518280092625e+03,		1.079967794555220e+03,
		1.080416028036925e+03,		1.080862988807613e+03,		1.081308685054154e+03,		1.081753124881547e+03,		1.082196316314036e+03,
		1.082638267296202e+03,		1.083078985694045e+03,		1.083518479296032e+03,		1.083956755814146e+03,		1.084393822884901e+03,
		1.084829688070351e+03,		1.085264358859074e+03,		1.085697842667147e+03,		1.086130146839097e+03,		1.086561278648841e+03,
		1.086991245300611e+03,		1.087420053929859e+03,		1.087847711604151e+03,		1.088274225324047e+03,		1.088699602023962e+03,
		1.089123848573019e+03,		1.089546971775881e+03,		1.089968978373574e+03,		1.090389875044302e+03,		1.090809668404234e+03,
		1.091228365008294e+03,		1.091645971350928e+03,		1.092062493866865e+03,		1.092477938931861e+03,		1.092892312863435e+03,
		1.093305621921592e+03,		1.093717872309534e+03,		1.094129070174362e+03,		1.094539221607763e+03,		1.094948332646690e+03,
		1.095356409274029e+03,		1.095763457419265e+03,		1.096169482959113e+03,		1.096574491718173e+03,		1.096978489469549e+03,
		1.097381481935472e+03,		1.097783474787900e+03,		1.098184473649131e+03,		1.098584484092386e+03,		1.098983511642388e+03,
		1.099381561775945e+03,		1.099778639922507e+03,		1.100174751464722e+03,		1.100569901738987e+03,		1.100964096035988e+03,
		1.101357339601230e+03,		1.101749637635560e+03,		1.102140995295690e+03,		1.102531417694692e+03,		1.102920909902515e+03,
		1.103309476946469e+03,		1.103697123811716e+03,		1.104083855441748e+03,		1.104469676738859e+03,		1.104854592564613e+03,
		1.105238607740307e+03,		1.105621727047415e+03,		1.106003955228042e+03,		1.106385296985359e+03,		1.106765756984042e+03,
		1.107145339850696e+03,		1.107524050174278e+03,		1.107901892506513e+03,		1.108278871362302e+03,		1.108654991220130e+03,
		1.109030256522462e+03,		1.109404671676136e+03,		1.109778241052755e+03,		1.110150968989061e+03,		1.110522859787321e+03,
		1.110893917715693e+03,		1.111264147008596e+03,		1.111633551867072e+03,		1.112002136459140e+03,		1.112369904920152e+03,
		1.112736861353136e+03,		1.113103009829146e+03,		1.113468354387591e+03,		1.113832899036576e+03,		1.114196647753226e+03,
		1.114559604484015e+03,		1.114921773145084e+03,		1.115283157622560e+03,		1.115643761772861e+03,		1.116003589423015e+03,
		1.116362644370955e+03,		1.116720930385820e+03,		1.117078451208257e+03,		1.117435210550708e+03,		1.117791212097697e+03,
		1.118146459506121e+03,		1.118500956405526e+03,		1.118854706398386e+03,		1.119207713060374e+03,		1.119559979940641e+03,
		1.119911510562070e+03,		1.120262308421552e+03,		1.120612376990238e+03,		1.120961719713797e+03,		1.121310340012675e+03,
		1.121658241282339e+03,		1.122005426893527e+03,		1.122351900192492e+03,		1.122697664501244e+03,		1.123042723117788e+03,
		1.123387079316355e+03,		1.123730736347643e+03,		1.124073697439037e+03,		1.124415965794841e+03,		1.124757544596502e+03,
		1.125098437002829e+03,		1.125438646150211e+03,		1.125778175152834e+03,		1.126117027102896e+03,		1.126455205070813e+03,
		1.126792712105429e+03,		1.127129551234223e+03,		1.127465725463512e+03,		1.127801237778647e+03,		1.128136091144215e+03,
		1.128470288504237e+03,		1.128803832782356e+03,		1.129136726882028e+03,		1.129468973686720e+03,		1.129800576060086e+03,
		1.130131536846154e+03,		1.130461858869514e+03,		1.130791544935491e+03,		1.131120597830326e+03,		1.131449020321354e+03,
		1.131776815157174e+03,		1.132103985067823e+03,		1.132430532764945e+03,		1.132756460941959e+03,		1.133081772274229e+03,
		1.133406469419219e+03,		1.133730555016663e+03,		1.134054031688725e+03,		1.134376902040152e+03,		1.134699168658436e+03,
		1.135020834113967e+03,		1.135341900960186e+03,		1.135662371733736e+03,		1.135982248954612e+03,		1.136301535126310e+03,
		1.136620232735973e+03,		1.136938344254535e+03,		1.137255872136863e+03,		1.137572818821903e+03,		1.137889186732814e+03,
		1.138204978277112e+03,		1.138520195846801e+03,		1.138834841818514e+03,		1.139148918553643e+03,		1.139462428398473e+03,
		1.139775373684312e+03,		1.140087756727622e+03,		1.140399579830147e+03,		1.140710845277523e+03,		1.141021555345530e+03,
		1.141331712290925e+03,		1.141641318357826e+03,		1.141950375776255e+03,		1.142258886762256e+03,		1.142566853518010e+03,
		1.142874278231956e+03,		1.143181163078907e+03,		1.143487510220163e+03,		1.143793321803626e+03,		1.144098599963912e+03,
		1.144403346822463e+03,		1.144707564487657e+03,		1.145011255054916e+03,		1.145314420606815e+03,		1.145617063213185e+03,
		1.145919184931228e+03,		1.146220787805609e+03,		1.146521873868567e+03,		1.146822445140019e+03,		1.147122503627653e+03,
		1.147422051327037e+03,		1.147721090221712e+03,		1.148019622283294e+03,		1.148317649471567e+03,		1.148615173734584e+03,
		1.148912197008759e+03,		1.149208721218961e+03,		1.149504748278609e+03,		1.149800280089764e+03,		1.150095318543216e+03,
		1.150389865518582e+03,		1.150683922884388e+03,		1.150977492498164e+03,		1.151270576206527e+03,		1.151563175845268e+03,
		1.151855293239442e+03,		1.152146930203449e+03,		1.152438088541118e+03,		1.152728770045795e+03,		1.153018976500420e+03,
		1.153308709677610e+03,		1.153597971339745e+03,		1.153886763239040e+03,		1.154175087117631e+03,		1.154462944707649e+03,
		1.154750337731301e+03,		1.155037267900945e+03,		1.155323736919167e+03,		1.155609746478857e+03,		1.155895298263282e+03,
		1.156180393946159e+03,		1.156465035191737e+03,		1.156749223654857e+03,		1.157032960981031e+03,		1.157316248806515e+03,
		1.157599088758373e+03,		1.157881482454554e+03,		1.158163431503954e+03,		1.158444937506490e+03,		1.158726002053167e+03
	},
	{
		1.857193007075242e+00,		5.640548185095146e+00,		9.515487562895251e+00,		1.348799053480384e+01,		1.756469640628922e+01,
		2.175300911595997e+01,		2.606122422841889e+01,		3.049868427011764e+01,		3.507597053919662e+01,		3.980514242914002e+01,
		4.470003948592863e+01,		4.977666753777330e+01,		5.505369938307392e+01,		6.055313451368598e+01,		6.630118431792472e+01,
		7.232948473142866e+01,		7.867679772435827e+01,		8.539146636843762e+01,		9.253507643069247e+01,		1.001881393645276e+02,
		1.084593552441067e+02,		1.175016737838170e+02,		1.275424911158525e+02,		1.389471304387702e+02,		8.339940591760925e+02,
		8.379270925976057e+02,		8.416479573915815e+02,		8.451832257612743e+02,		8.485544657388348e+02,		8.517794633263600e+02,
		8.548730848245658e+02,		8.578479015885055e+02,		8.607146529136292e+02,		8.634825956562513e+02,		8.661597727645512e+02,
		8.687532225893601e+02,		8.712691441833775e+02,		8.737130293802888e+02,		8.760897694518110e+02,		8.784037420572391e+02,
		8.806588827580676e+02,		8.828587442994524e+02,		8.850065461188997e+02,		8.871052159727579e+02,		8.891574251561402e+02,
		8.911656184766350e+02,		8.931320399023297e+02,		8.950587546201053e+02,		8.969476680970699e+02,		8.988005426259373e+02,
		9.006190117468151e+02,		9.024045928678065e+02,		9.041586983505999e+02,		9.058826452821570e+02,		9.075776641170784e+02,
		9.092449063453249e+02,		9.108854513172848e+02,		9.125003123286185e+02,		9.140904420759088e+02,		9.156567375424561e+02,
		9.172000443966824e+02,		9.187211609568293e+02,		9.202208417734495e+02,		9.216998008735635e+02,		9.231587147044960e+02,
		9.245982248105440e+02,		9.260189402713567e+02,		9.274214399273061e+02,		9.288062744140717e+02,		9.301739680258956e+02,
		9.315250204247945e+02,		9.328599082108531e+02,		9.341790863671613e+02,		9.354829895912677e+02,		9.367720335238514e+02,
		9.380466158840895e+02,		9.393071175201584e+02,		9.405539033824713e+02,		9.417873234264711e+02,		9.430077134522477e+02,
		9.442153958799723e+02,		9.454106804809485e+02,		9.465938650505263e+02,		9.477652360395784e+02,		9.489250691434822e+02,
		9.500736298526236e+02,		9.512111739680593e+02,		9.523379480809458e+02,		9.534541900305459e+02,		9.545601293225461e+02,
		9.556559875303099e+02,		9.567419786686067e+02,		9.578183095456933e+02,		9.588851800947234e+02,		9.599427836859406e+02,
		9.609913074210170e+02,		9.620309324107297e+02,		9.630618340371323e+02,		9.640841822012558e+02,		9.650981415572912e+02,
		9.661038717341413e+02,		9.671015275451814e+02,		9.680912591869380e+02,		9.690732124274512e+02,		9.700475287848985e+02,
		9.710143456971389e+02,		9.719737966827025e+02,		9.729260114937617e+02,		9.738711162615366e+02,		9.748092336346305e+02,
		9.757404829106578e+02,		9.766649801627619e+02,		9.775828383549951e+02,		9.784941674615627e+02,		9.793990745720963e+02,
		9.802976639959774e+02,		9.811900373611988e+02,		9.820762937087771e+02,		9.829565295829658e+02,		9.838308391174712e+02,
		9.846993141179117e+02,		9.855620441406943e+02,		9.864191165685197e+02,		9.872706166826789e+02,		9.881166277322712e+02,
		9.889572310005838e+02,		9.897925058686881e+02,		9.906225298764338e+02,		9.914473787809903e+02,		9.922671266129913e+02,
		9.930818457304633e+02,		9.938916068706177e+02,		9.946964791995957e+02,		9.954965303602958e+02,		9.962918265183342e+02,
		9.970824324062741e+02,		9.978684113661460e+02,		9.986498253903891e+02,		9.994267351612540e+02,		1.000199200088752e+03,
		1.000967278347199e+03,		1.001731026910451e+03,		1.002490501585825e+03,		1.003245757046848e+03,		1.003996846864811e+03,
		1.004743823540728e+03,		1.005486738529304e+03,		1.006225642274689e+03,		1.006960584233322e+03,		1.007691612901416e+03,
		1.008418775840520e+03,		1.009142119702173e+03,		1.009861690251781e+03,		1.010577532391665e+03,		1.011289690183351e+03,
		1.011998206869148e+03,		1.012703124893012e+03,		1.013404485920726e+03,		1.014102330859448e+03,		1.014796699876624e+03,
		1.015487632418314e+03,		1.016175167226933e+03,		1.016859342358425e+03,		1.017540195198950e+03,		1.018217762480998e+03,
		1.018892080299040e+03,		1.019563184124725e+03,		1.020231108821567e+03,		1.020895888659231e+03,		1.021557557327375e+03,
		1.022216147949103e+03,		1.022871693093983e+03,		1.023524224790722e+03,		1.024173774539462e+03,		1.024820373323714e+03,
		1.025464051621951e+03,		1.026104839418871e+03,		1.026742766216355e+03,		1.027377861044096e+03,		1.028010152469938e+03,
		1.028639668609935e+03,		1.029266437138112e+03,		1.029890485295994e+03,		1.030511839901827e+03,		1.031130527359593e+03,
		1.031746573667743e+03,		1.032360004427735e+03,		1.032970844853623e+03,		1.033579119775357e+03,		1.034184853653231e+03,
		1.034788070581463e+03,		1.035388794296587e+03,		1.035987048184729e+03,		1.036582855288662e+03,		1.037176238314707e+03,
		1.037767219639448e+03,		1.038355821316273e+03,		1.038942065081756e+03,		1.039525972361879e+03,		1.040107564278094e+03,
		1.040686861653234e+03,		1.041263885017295e+03,		1.041838654613046e+03,		1.042411190401531e+03,		1.042981512067426e+03,
		1.043549639024253e+03,		1.044115590419500e+03,		1.044679385139588e+03,		1.045241041814736e+03,		1.045800578823708e+03,
		1.046358014298451e+03,		1.046913366128612e+03,		1.047466651965973e+03,		1.048017889228754e+03,		1.048567095105853e+03,
		1.049114286560941e+03,		1.049659480336510e+03,		1.050202692957822e+03,		1.050743940736703e+03,		1.051283239775365e+03,
		1.051820605970054e+03,		1.052356055014657e+03,		1.052889602404201e+03,		1.053421263438303e+03,		1.053951053224533e+03,
		1.054478986681703e+03,		1.055005078543075e+03,		1.055529343359520e+03,		1.056051795502598e+03,		1.056572449167567e+03,
		1.057091318376335e+03,		1.057608416980342e+03,		1.058123758663401e+03,		1.058637356944447e+03,		1.059149225180265e+03,
		1.059659376568118e+03,		1.060167824148368e+03,		1.060674580807007e+03,		1.061179659278151e+03,		1.061683072146480e+03,
		1.062184831849628e+03,		1.062684950680529e+03,		1.063183440789711e+03,		1.063680314187533e+03,		1.064175582746408e+03,
		1.064669258202945e+03,		1.065161352160080e+03,		1.065651876089137e+03,		1.066140841331878e+03,		1.066628259102479e+03,
		1.067114140489499e+03,		1.067598496457794e+03,		1.068081337850393e+03,		1.068562675390345e+03,		1.069042519682525e+03,
		1.069520881215416e+03,		1.069997770362836e+03,		1.070473197385657e+03,		1.070947172433472e+03,		1.071419705546242e+03,
		1.071890806655907e+03,		1.072360485587973e+03,		1.072828752063060e+03,		1.073295615698422e+03,		1.073761086009458e+03,
		1.074225172411167e+03,		1.074687884219601e+03,		1.075149230653266e+03,		1.075609220834524e+03,		1.076067863790962e+03,
		1.076525168456714e+03,		1.076981143673800e+03,		1.077435798193394e+03,		1.077889140677121e+03,		1.078341179698281e+03,
		1.078791923743090e+03,		1.079241381211873e+03,		1.079689560420255e+03,		1.080136469600315e+03,		1.080582116901737e+03,
		1.081026510392927e+03,		1.081469658062112e+03,		1.081911567818433e+03,		1.082352247493001e+03,		1.082791704839947e+03,
		1.083229947537458e+03,		1.083666983188776e+03,		1.084102819323208e+03,		1.084537463397087e+03,		1.084970922794747e+03,
		1.085403204829462e+03,		1.085834316744375e+03,		1.086264265713425e+03,		1.086693058842224e+03,		1.087120703168957e+03,
		1.087547205665253e+03,		1.087972573237033e+03,		1.088396812725352e+03,		1.088819930907241e+03,		1.089241934496497e+03,
		1.089662830144507e+03,		1.090082624441026e+03,		1.090501323914958e+03,		1.090918935035112e+03,		1.091335464210966e+03,
		1.091750917793393e+03,		1.092165302075402e+03,		1.092578623292839e+03,		1.092990887625111e+03,		1.093402101195866e+03,
		1.093812270073679e+03,		1.094221400272738e+03,		1.094629497753480e+03,		1.095036568423271e+03,		1.095442618137032e+03,
		1.095847652697875e+03,		1.096251677857725e+03,		1.096654699317942e+03,		1.097056722729909e+03,		1.097457753695641e+03,
		1.097857797768360e+03,		1.098256860453081e+03,		1.098654947207177e+03,		1.099052063440942e+03,		1.099448214518129e+03,
		1.099843405756515e+03,		1.100237642428420e+03,		1.100630929761239e+03,		1.101023272937962e+03,		1.101414677097695e+03,
		1.101805147336144e+03,		1.102194688706133e+03,		1.102583306218083e+03,		1.102971004840501e+03,		1.103357789500447e+03,
		1.103743665084014e+03,		1.104128636436782e+03,		1.104512708364286e+03,		1.104895885632444e+03,		1.105278172968025e+03,
		1.105659575059063e+03,		1.106040096555312e+03,		1.106419742068642e+03,		1.106798516173484e+03,		1.107176423407224e+03,
		1.107553468270622e+03,		1.107929655228206e+03,		1.108304988708668e+03,		1.108679473105266e+03,		1.109053112776187e+03,
		1.109425912044949e+03,		1.109797875200758e+03,		1.110169006498892e+03,		1.110539310161053e+03,		1.110908790375735e+03,
		1.111277451298570e+03,		1.111645297052687e+03,		1.112012331729052e+03,		1.112378559386809e+03,		1.112743984053613e+03,
		1.113108609725970e+03,		1.113472440369550e+03,		1.113835479919524e+03,		1.114197732280872e+03,		1.114559201328706e+03,
		1.114919890908569e+03,		1.115279804836747e+03,		1.115638946900577e+03,		1.115997320858734e+03,		1.116354930441530e+03,
		1.116711779351202e+03,		1.117067871262206e+03,		1.117423209821490e+03,		1.117777798648782e+03,		1.118131641336851e+03,
		1.118484741451804e+03,		1.118837102533327e+03,		1.119188728094971e+03,		1.119539621624398e+03,		1.119889786583656e+03,
		1.120239226409421e+03,		1.120587944513252e+03,		1.120935944281844e+03,		1.121283229077272e+03,		1.121629802237225e+03,
		1.121975667075270e+03,		1.122320826881051e+03,		1.122665284920558e+03,		1.123009044436343e+03,		1.123352108647742e+03,
		1.123694480751110e+03,		1.124036163920041e+03,		1.124377161305589e+03,		1.124717476036477e+03,		1.125057111219322e+03,
		1.125396069938842e+03,		1.125734355258065e+03,		1.126071970218533e+03,		1.126408917840514e+03,		1.126745201123195e+03,
		1.127080823044889e+03,		1.127415786563227e+03,		1.127750094615352e+03,		1.128083750118117e+03,		1.128416755968268e+03,
		1.128749115042637e+03,		1.129080830198325e+03,		1.129411904272885e+03,		1.129742340084505e+03,		1.130072140432187e+03,
		1.130401308095923e+03,		1.130729845836870e+03,		1.131057756397525e+03,		1.131385042501888e+03,		1.131711706855643e+03,
		1.132037752146317e+03,		1.132363181043449e+03,		1.132687996198745e+03,		1.133012200246252e+03,		1.133335795802509e+03,
		1.133658785466706e+03,		1.133981171820838e+03,		1.134302957429864e+03,		1.134624144841856e+03,		1.134944736588154e+03,
		1.135264735183504e+03,		1.135584143126217e+03,		1.135902962898310e+03,		1.136221196965650e+03,		1.136538847778093e+03,
		1.136855917768107e+03,		1.137172409357078e+03,		1.137488324946076e+03,		1.137803666922327e+03,		1.138118437657724e+03,
		1.138432639508989e+03,		1.138746274817776e+03,		1.139059345910823e+03,		1.139371855100071e+03,		1.139683804682791e+03,
		1.139995196941714e+03,		1.140306034145152e+03,		1.140616318547124e+03,		1.140926052387481e+03,		1.141235237892012e+03,
		1.141543877272588e+03,		1.141851972727252e+03,		1.142159526440361e+03,		1.142466540582686e+03,		1.142773017311533e+03,
		1.143078958770848e+03,		1.143384367091345e+03,		1.143689244390595e+03,		1.143993592773160e+03,		1.144297414330678e+03,
		1.144600711141986e+03,		1.144903485273220e+03,		1.145205738777926e+03,		1.145507473697148e+03,		1.145808692059554e+03,
		1.146109395881520e+03,		1.146409587167238e+03,		1.146709267908809e+03,		1.147008440086359e+03,		1.147307105668114e+03,
		1.147605266610508e+03,		1.147902924858285e+03,		1.148200082344580e+03,		1.148496740991022e+03,		1.148792902707825e+03,
		1.149088569393876e+03,		1.149383742936831e+03,		1.149678425213203e+03,		1.149972618088450e+03,		1.150266323417061e+03,
		1.150559543042654e+03,		1.150852278798047e+03,		1.151144532505352e+03,		1.151436305976064e+03,		1.151727601011136e+03,
		1.152018419401064e+03,		1.152308762925975e+03,		1.152598633355702e+03,		1.152888032449863e+03,		1.153176961957952e+03,
		1.153465423619404e+03,		1.153753419163684e+03,		1.154040950310354e+03,		1.154328018769166e+03,		1.154614626240114e+03,
		1.154900774413535e+03,		1.155186464970161e+03,		1.155471699581213e+03,		1.155756479908458e+03,		1.156040807604285e+03,
		1.156324684311784e+03,		1.156608111664806e+03,		1.156891091288047e+03,		1.157173624797102e+03,		1.157455713798543e+03
	},
	{
		1.853220842958145e+00,		5.628017223678614e+00,		9.493507171811631e+00,		1.345555811163026e+01,		1.752067846095391e+01,
		2.169611822412009e+01,		2.598999072254399e+01,		3.041142115276242e+01,		3.497072956501917e+01,		3.967965853306032e+01,
		4.455165961558372e+01,		4.960225828790562e+01,		5.484952531225679e+01,		6.031469511471644e+01,		6.602299137550844e+01,
		7.200475153515714e+01,		7.829699410130594e+01,		8.494566240243677e+01,		9.200893975149096e+01,		9.956233634083871e+01,
		1.077068635758460e+02,		1.165829515661168e+02,		1.263959861438314e+02,		1.374681702349885e+02,		1.503605917923431e+02,
		8.316532548566133e+02,		8.356120367253783e+02,		8.393579605259681e+02,		8.429174763570852e+02,		8.463120995866212e+02,
		8.495596043199757e+02,		8.526748688875109e+02,		8.556704904677814e+02,		8.585572417727273e+02,		8.613444168343294e+02,
		8.640400971579111e+02,		8.666513595665565e+02,		8.691844406112012e+02,		8.716448681337436e+02,		8.740375676352743e+02,
		8.763669491053490e+02,		8.786369784985178e+02,		8.808512370471991e+02,		8.830129708364683e+02,		8.851251325185507e+02,
		8.871904166319306e+02,		8.892112896787589e+02,		8.911900158766128e+02,		8.931286793178813e+02,		8.950292031279502e+02,
		8.968933661020493e+02,		8.987228172127560e+02,		9.005190883104644e+02,		9.022836052829946e+02,		9.040176978968899e+02,
		9.057226084993852e+02,		9.073994997487048e+02,		9.090494614885364e+02,		9.106735168874255e+02,		9.122726279334688e+02,
		9.138477003651678e+02,		9.153995881071835e+02,		9.169290972701033e+02,		9.184369897651758e+02,		9.199239865781331e+02,
		9.213907707403387e+02,		9.228379900306220e+02,		9.242662594368506e+02,		9.256761634027025e+02,		9.270682578819990e+02,
		9.284430722202302e+02,		9.298011108806252e+02,		9.311428550300806e+02,		9.324687639985532e+02,		9.337792766239236e+02,
		9.350748124931150e+02,		9.363557730902253e+02,		9.376225428536432e+02,		9.388754901646794e+02,		9.401149682564413e+02,
		9.413413160616201e+02,		9.425548590001044e+02,		9.437559097125749e+02,		9.449447687422308e+02,		9.461217251727238e+02,
		9.472870572264497e+02,		9.484410328154066e+02,		9.495839100650051e+02,		9.507159378007099e+02,		9.518373560049038e+02,
		9.529483962455091e+02,		9.540492820784584e+02,		9.551402294259358e+02,		9.562214469321283e+02,		9.572931362980909e+02,
		9.583554925972066e+02,		9.594087045725837e+02,		9.604529549176291e+02,		9.614884205409437e+02,		9.625152728166019e+02,
		9.635336778207561e+02,		9.645437965554921e+02,		9.655457851607522e+02,		9.665397951150790e+02,		9.675259734258915e+02,
		9.685044628099782e+02,		9.694754018659602e+02,		9.704389252328009e+02,		9.713951637498569e+02,		9.723442446004644e+02,
		9.732862914524335e+02,		9.742214245910242e+02,		9.751497610455816e+02,		9.760714147101597e+02,		9.769864964585075e+02,
		9.778951142537111e+02,		9.787973732528131e+02,		9.796933759066645e+02,		9.805832220552887e+02,		9.814670090189842e+02,
		9.823448316854195e+02,		9.832167825928999e+02,		9.840829520100368e+02,		9.849434280119954e+02,		9.857982965534981e+02,
		9.866476415387474e+02,		9.874915448884403e+02,		9.883300866039887e+02,		9.891633448291275e+02,		9.899913959090028e+02,
		9.908143144468839e+02,		9.916321733586053e+02,		9.924450439248637e+02,		9.932529958414412e+02,		9.940560972674901e+02,
		9.948544148719468e+02,		9.956480138781604e+02,		9.964369581080535e+02,		9.972213100191694e+02,		9.980011307502328e+02,
		9.987764801559400e+02,		9.995474168446624e+02,		1.000313998214008e+03,		1.001076280485080e+03,		1.001834318735520e+03,
		1.002588166931362e+03,		1.003337877957768e+03,		1.004083503649681e+03,		1.004825094815474e+03,		1.005562701274521e+03,
		1.006296371873953e+03,		1.007026154519397e+03,		1.007752096198896e+03,		1.008474243006979e+03,		1.009192640167928e+03,
		1.009907332058285e+03,		1.010618362228611e+03,		1.011325773424542e+03,		1.012029607607162e+03,		1.012729905972714e+03,
		1.013426708971702e+03,		1.014120056327363e+03,		1.014809987053578e+03,		1.015496539472208e+03,		1.016179751229902e+03,
		1.016859659314386e+03,		1.017536300070249e+03,		1.018209709214248e+03,		1.018879921850154e+03,		1.019546972483157e+03,
		1.020210895033821e+03,		1.020871722851658e+03,		1.021529488728270e+03,		1.022184224910128e+03,		1.022835963110963e+03,
		1.023484734523820e+03,		1.024130569832737e+03,		1.024773499225764e+03,		1.025413552400097e+03,		1.026050758580888e+03,
		1.026685146526705e+03,		1.027316744540832e+03,		1.027945580481118e+03,		1.028571681769572e+03,		1.029195075401682e+03,
		1.029815787955497e+03,		1.030433845600445e+03,		1.031049274105927e+03,		1.031662098849674e+03,		1.032272344825896e+03,
		1.032880036653190e+03,		1.033485198582274e+03,		1.034087854503487e+03,		1.034688027954118e+03,		1.035285742125533e+03,
		1.035881019870127e+03,		1.036473883708090e+03,		1.037064355834009e+03,		1.037652458123305e+03,		1.038238212138496e+03,
		1.038821639135317e+03,		1.039402760068685e+03,		1.039981595598510e+03,		1.040558166095372e+03,		1.041132491646058e+03,
		1.041704592058953e+03,		1.042274486869322e+03,		1.042842195344442e+03,		1.043407736488632e+03,		1.043971129048259e+03,
		1.044532391516120e+03,		1.045091542136672e+03,		1.045648598910253e+03,		1.046203579597611e+03,		1.046756501724268e+03,
		1.047307382584765e+03,		1.047856239246820e+03,		1.048403088555388e+03,		1.048947947136631e+03,		1.049490831401792e+03,
		1.050031757550990e+03,		1.050570741576925e+03,		1.051107799268502e+03,		1.051642946214373e+03,		1.052176197806404e+03,
		1.052707569243062e+03,		1.053237075532735e+03,		1.053764731496962e+03,		1.054290551773624e+03,		1.054814550820034e+03,
		1.055336742915981e+03,		1.055857142166701e+03,		1.056375762505787e+03,		1.056892617698037e+03,		1.057407721342243e+03,
		1.057921086873920e+03,		1.058432727567978e+03,		1.058942656541340e+03,		1.059450886755508e+03,		1.059957431019066e+03,
		1.060462301990150e+03,		1.060965512178844e+03,		1.061467073949549e+03,		1.061966999523294e+03,		1.062465300979999e+03,
		1.062961990260695e+03,		1.063457079169702e+03,		1.063950579376762e+03,		1.064442502419126e+03,		1.064932859703608e+03,
		1.065421662508589e+03,		1.065908921985992e+03,		1.066394649163211e+03,		1.066878854945001e+03,		1.067361550115342e+03,
		1.067842745339261e+03,		1.068322451164612e+03,		1.068800678023837e+03,		1.069277436235681e+03,		1.069752736006879e+03,
		1.070226587433814e+03,		1.070699000504141e+03,		1.071169985098379e+03,		1.071639550991480e+03,		1.072107707854357e+03,
		1.072574465255399e+03,		1.073039832661949e+03,		1.073503819441749e+03,		1.073966434864377e+03,		1.074427688102641e+03,
		1.074887588233953e+03,		1.075346144241682e+03,		1.075803365016481e+03,		1.076259259357583e+03,		1.076713835974086e+03,
		1.077167103486207e+03,		1.077619070426516e+03,		1.078069745241149e+03,		1.078519136290999e+03,		1.078967251852886e+03,
		1.079414100120707e+03,		1.079859689206564e+03,		1.080304027141883e+03,		1.080747121878492e+03,		1.081188981289706e+03,
		1.081629613171374e+03,		1.082069025242917e+03,		1.082507225148349e+03,		1.082944220457279e+03,		1.083380018665889e+03,
		1.083814627197914e+03,		1.084248053405582e+03,		1.084680304570558e+03,		1.085111387904865e+03,		1.085541310551783e+03,
		1.085970079586746e+03,		1.086397702018218e+03,		1.086824184788548e+03,		1.087249534774823e+03,		1.087673758789704e+03,
		1.088096863582242e+03,		1.088518855838685e+03,		1.088939742183277e+03,		1.089359529179031e+03,		1.089778223328510e+03,
		1.090195831074570e+03,		1.090612358801116e+03,		1.091027812833831e+03,		1.091442199440894e+03,		1.091855524833697e+03,
		1.092267795167538e+03,		1.092679016542311e+03,		1.093089195003185e+03,		1.093498336541272e+03,		1.093906447094279e+03,
		1.094313532547155e+03,		1.094719598732735e+03,		1.095124651432360e+03,		1.095528696376494e+03,		1.095931739245337e+03,
		1.096333785669419e+03,		1.096734841230193e+03,		1.097134911460614e+03,		1.097534001845714e+03,		1.097932117823161e+03,
		1.098329264783819e+03,		1.098725448072291e+03,		1.099120672987463e+03,		1.099514944783028e+03,		1.099908268668017e+03,
		1.100300649807310e+03,		1.100692093322143e+03,		1.101082604290611e+03,		1.101472187748162e+03,		1.101860848688081e+03,
		1.102248592061971e+03,		1.102635422780223e+03,		1.103021345712484e+03,		1.103406365688116e+03,		1.103790487496643e+03,
		1.104173715888207e+03,		1.104556055573999e+03,		1.104937511226693e+03,		1.105318087480879e+03,		1.105697788933480e+03,
		1.106076620144165e+03,		1.106454585635767e+03,		1.106831689894676e+03,		1.107207937371249e+03,		1.107583332480191e+03,
		1.107957879600953e+03,		1.108331583078107e+03,		1.108704447221722e+03,		1.109076476307746e+03,		1.109447674578359e+03,
		1.109818046242344e+03,		1.110187595475440e+03,		1.110556326420693e+03,		1.110924243188810e+03,		1.111291349858489e+03,
		1.111657650476770e+03,		1.112023149059361e+03,		1.112387849590967e+03,		1.112751756025618e+03,		1.113114872286988e+03,
		1.113477202268708e+03,		1.113838749834684e+03,		1.114199518819400e+03,		1.114559513028221e+03,		1.114918736237698e+03,
		1.115277192195860e+03,		1.115634884622506e+03,		1.115991817209496e+03,		1.116347993621032e+03,		1.116703417493944e+03,
		1.117058092437959e+03,		1.117412022035985e+03,		1.117765209844373e+03,		1.118117659393188e+03,		1.118469374186472e+03,
		1.118820357702501e+03,		1.119170613394048e+03,		1.119520144688630e+03,		1.119868954988762e+03,		1.120217047672205e+03,
		1.120564426092205e+03,		1.120911093577741e+03,		1.121257053433760e+03,		1.121602308941410e+03,		1.121946863358275e+03,
		1.122290719918604e+03,		1.122633881833538e+03,		1.122976352291331e+03,		1.123318134457575e+03,		1.123659231475416e+03,
		1.123999646465770e+03,		1.124339382527535e+03,		1.124678442737807e+03,		1.125016830152076e+03,		1.125354547804446e+03,
		1.125691598707830e+03,		1.126027985854148e+03,		1.126363712214532e+03,		1.126698780739519e+03,		1.127033194359241e+03,
		1.127366955983621e+03,		1.127700068502561e+03,		1.128032534786126e+03,		1.128364357684732e+03,		1.128695540029324e+03,
		1.129026084631560e+03,		1.129355994283988e+03,		1.129685271760222e+03,		1.130013919815115e+03,		1.130341941184931e+03,
		1.130669338587516e+03,		1.130996114722466e+03,		1.131322272271292e+03,		1.131647813897584e+03,		1.131972742247175e+03,
		1.132297059948298e+03,		1.132620769611750e+03,		1.132943873829519e+03,		1.133266375181113e+03,		1.133588276224339e+03,
		1.133909579501786e+03,		1.134230287539370e+03,		1.134550402846482e+03,		1.134869927916130e+03,		1.135188865225095e+03,
		1.135507217234063e+03,		1.135824986387773e+03,		1.136142175115154e+03,		1.136458785829464e+03,		1.136774820928427e+03,
		1.137090282794373e+03,		1.137405173794362e+03,		1.137719496280326e+03,		1.138033252589195e+03,		1.138346445043027e+03,
		1.138659075949139e+03,		1.138971147600229e+03,		1.139282662274504e+03,		1.139593622235809e+03,		1.139904029733739e+03,
		1.140213887003767e+03,		1.140523196267368e+03,		1.140831959732127e+03,		1.141140179591865e+03,		1.141447858026753e+03,
		1.141754997203427e+03,		1.142061599275099e+03,		1.142367666381676e+03,		1.142673200649864e+03,		1.142978204193284e+03,
		1.143282679112576e+03,		1.143586627495512e+03,		1.143890051417100e+03,		1.144192952939689e+03,		1.144495334113075e+03,
		1.144797196974604e+03,		1.145098543549275e+03,		1.145399375849840e+03,		1.145699695876904e+03,		1.145999505619027e+03,
		1.146298807052819e+03,		1.146597602143040e+03,		1.146895892842692e+03,		1.147193681093121e+03,		1.147490968824104e+03,
		1.147787757953945e+03,		1.148084050389571e+03,		1.148379848026618e+03,		1.148675152749525e+03,		1.148969966431618e+03,
		1.149264290935210e+03,		1.149558128111676e+03,		1.149851479801547e+03,		1.150144347834595e+03,		1.150436734029916e+03,
		1.150728640196020e+03,		1.151020068130904e+03,		1.151311019622146e+03,		1.151601496446981e+03,		1.151891500372380e+03,
		1.152181033155136e+03,		1.152470096541938e+03,		1.152758692269453e+03,		1.153046822064404e+03,		1.153334487643644e+03,
		1.153621690714235e+03,		1.153908432973522e+03,		1.154194716109209e+03,		1.154480541799433e+03,		1.154765911712838e+03,
		1.155050827508644e+03,		1.155335290836725e+03,		1.155619303337675e+03,		1.155902866642882e+03,		1.156185982374595e+03
	},
	{
		1.849265978070046e+00,		5.615545175328474e+00,		9.471638239578892e+00,		1.342330298206083e+01,		1.747691987895594e+01,
		2.163958870813222e+01,		2.591924525065522e+01,		3.032480338975244e+01,		3.486632969959464e+01,		3.955526008176260e+01,
		4.440467151761475e+01,		4.942962709187314e+01,		5.464761996048282e+01,		6.007915329013715e+01,		6.574851076932174e+01,
		7.168480024594038e+01,		7.792339893526417e+01,		8.450800673209322e+01,		9.149365273625469e+01,		9.895125846917882e+01,
		1.069748724140906e+02,		1.156937780889745e+02,		1.252942144287706e+02,		1.360621212449390e+02,		1.484790875199400e+02,
		8.251059571790292e+02,		8.293359036734323e+02,		8.333194674024954e+02,		8.370895400490340e+02,		8.406724528228236e+02,
		8.440896675756870e+02,		8.473589436611300e+02,		8.504951676908368e+02,		8.535109586255352e+02,		8.564171185799581e+02,
		8.592229749402554e+02,		8.619366442167004e+02,		8.645652384497959e+02,		8.671150287333085e+02,		8.695915762423277e+02,
		8.719998383050430e+02,		8.743442550744113e+02,		8.766288209521250e+02,		8.788571439076436e+02,		8.810324950985341e+02,
		8.831578506539013e+02,		8.852359270755721e+02,		8.872692114038348e+02,		8.892599870593396e+02,		8.912103560915414e+02,
		8.931222584229575e+02,		8.949974885680803e+02,		8.968377102183264e+02,		8.986444690166131e+02,		9.004192037796663e+02,
		9.021632564070742e+02,		9.038778806413493e+02,		9.055642498482190e+02,		9.072234639431631e+02,		9.088565555758614e+02,
		9.104644956669234e+02,		9.120481983774454e+02,		9.136085255804161e+02,		9.151462908933100e+02,		9.166622633230733e+02,
		9.181571705678127e+02,		9.196317020136569e+02,		9.210865114602976e+02,		9.225222196044593e+02,		9.239394163068857e+02,
		9.253386626653536e+02,		9.267204929135058e+02,		9.280854161629006e+02,		9.294339180049652e+02,		9.307664619802257e+02,
		9.320834909409994e+02,		9.333854283013708e+02,		9.346726791957778e+02,		9.359456315504930e+02,		9.372046570769197e+02,
		9.384501121898446e+02,		9.396823388681652e+02,		9.409016654448370e+02,		9.421084073499078e+02,		9.433028677998967e+02,
		9.444853384413952e+02,		9.456560999520453e+02,		9.468154226023288e+02,		9.479635667811567e+02,		9.491007834881193e+02,
		9.502273147948878e+02,		9.513433942780993e+02,		9.524492474258296e+02,		9.535450920195943e+02,		9.546311384936445e+02,
		9.557075902731664e+02,		9.567746440928703e+02,		9.578324902973478e+02,		9.588813131244302e+02,		9.599212909727175e+02,
		9.609525966543239e+02,		9.619753976349963e+02,		9.629898562562540e+02,		9.639961299545923e+02,		9.649943714611185e+02,
		9.659847289944130e+02,		9.669673464427924e+02,		9.679423635372805e+02,		9.689099160158405e+02,		9.698701357794348e+02,
		9.708231510403645e+02,		9.717690864633764e+02,		9.727080632999392e+02,		9.736401995161081e+02,		9.745656099143250e+02,
		9.754844062495191e+02,		9.763966973398170e+02,		9.773025891721632e+02,		9.782021850031472e+02,		9.790955854552775e+02,
		9.799828886089689e+02,		9.808641900904581e+02,		9.817395831558854e+02,		9.826091587717109e+02,		9.834730056916935e+02,
		9.843312105305891e+02,		9.851838578347359e+02,		9.860310301496918e+02,		9.868728080850774e+02,		9.877092703767437e+02,
		9.885404939476803e+02,		9.893665539608853e+02,		9.901875238801849e+02,		9.910034755194581e+02,		9.918144790941590e+02,
		9.926206032700425e+02,		9.934219152100100e+02,		9.942184806191585e+02,		9.950103637881214e+02,		9.957976276356966e+02,
		9.965803337443803e+02,		9.973585424082474e+02,		9.981323126609645e+02,		9.989017023162808e+02,		9.996667680016844e+02,
		1.000427565191732e+03,		1.001184148240211e+03,		1.001936570411130e+03,		1.002684883908667e+03,		1.003429139906025e+03,
		1.004169388573331e+03,		1.004905679104558e+03,		1.005638059743525e+03,		1.006366577809040e+03,		1.007091279719176e+03,
		1.007812211014750e+03,		1.008529416382023e+03,		1.009242939674661e+03,		1.009952823934964e+03,		1.010659111414425e+03,
		1.011361843593616e+03,		1.012061061201445e+03,		1.012756804233803e+03,		1.013449111971618e+03,		1.014138022998346e+03,
		1.014823575216922e+03,		1.015505805867382e+03,		1.016184751538554e+03,		1.016860448189236e+03,		1.017532931159668e+03,
		1.018202235186859e+03,		1.018868394418681e+03,		1.019531442427538e+03,		1.020191412223638e+03,		1.020848336267864e+03,
		1.021502246484296e+03,		1.022153174272338e+03,		1.022801150518523e+03,		1.023446205607973e+03,		1.024088369435524e+03,
		1.024727671416556e+03,		1.025364140497501e+03,		1.025997805166074e+03,		1.026628693461208e+03,		1.027256832982725e+03,
		1.027882250900735e+03,		1.028504973964790e+03,		1.029125028512775e+03,		1.029742440479575e+03,		1.030357235405506e+03,
		1.030969438444513e+03,		1.031579074372165e+03,		1.032186167593435e+03,		1.032790742150268e+03,		1.033392821728973e+03,
		1.033992429667400e+03,		1.034589588961951e+03,		1.035184322274406e+03,		1.035776651938568e+03,		1.036366599966756e+03,
		1.036954188056121e+03,		1.037539437595481e+03,		1.038122369668924e+03,		1.038703005064970e+03,		1.039281364280258e+03,
		1.039857467525603e+03,		1.040431334731427e+03,		1.041002985553086e+03,		1.041572439376040e+03,		1.042139715320923e+03,
		1.042704832248475e+03,		1.043267808764374e+03,		1.043828663223932e+03,		1.044387413736704e+03,		1.044944078170978e+03,
		1.045498674158159e+03,		1.046051219097053e+03,		1.046601730158062e+03,		1.047150224287272e+03,		1.047696718210448e+03,
		1.048241228436949e+03,		1.048783771263546e+03,		1.049324362778150e+03,		1.049863018863476e+03,		1.050399755200605e+03,
		1.050934587272477e+03,		1.051467530367308e+03,		1.051998599581929e+03,		1.052527809825050e+03,		1.053055175820467e+03,
		1.053580712110174e+03,		1.054104433057441e+03,		1.054626352849798e+03,		1.055146485501967e+03,		1.055664844858738e+03,
		1.056181444597774e+03,		1.056696298232359e+03,		1.057209419114095e+03,		1.057720820435540e+03,		1.058230515232782e+03,
		1.058738516387978e+03,		1.059244836631826e+03,		1.059749488545992e+03,		1.060252484565488e+03,		1.060753836981000e+03,
		1.061253557941177e+03,		1.061751659454854e+03,		1.062248153393260e+03,		1.062743051492152e+03,		1.063236365353931e+03,
		1.063728106449701e+03,		1.064218286121295e+03,		1.064706915583258e+03,		1.065194005924792e+03,		1.065679568111667e+03,
		1.066163612988089e+03,		1.066646151278534e+03,		1.067127193589553e+03,		1.067606750411533e+03,		1.068084832120429e+03,
		1.068561448979470e+03,		1.069036611140818e+03,		1.069510328647206e+03,		1.069982611433550e+03,		1.070453469328517e+03,
		1.070922912056074e+03,		1.071390949237007e+03,		1.071857590390412e+03,		1.072322844935155e+03,		1.072786722191309e+03,
		1.073249231381565e+03,		1.073710381632618e+03,		1.074170181976521e+03,		1.074628641352027e+03,		1.075085768605896e+03,
		1.075541572494184e+03,		1.075996061683509e+03,		1.076449244752293e+03,		1.076901130191981e+03,		1.077351726408246e+03,
		1.077801041722162e+03,		1.078249084371363e+03,		1.078695862511184e+03,		1.079141384215775e+03,		1.079585657479202e+03,
		1.080028690216531e+03,		1.080470490264880e+03,		1.080911065384473e+03,		1.081350423259660e+03,		1.081788571499926e+03,
		1.082225517640886e+03,		1.082661269145255e+03,		1.083095833403810e+03,		1.083529217736334e+03,		1.083961429392536e+03,
		1.084392475552974e+03,		1.084822363329940e+03,		1.085251099768352e+03,		1.085678691846611e+03,		1.086105146477464e+03,
		1.086530470508840e+03,		1.086954670724675e+03,		1.087377753845725e+03,		1.087799726530365e+03,		1.088220595375378e+03,
		1.088640366916727e+03,		1.089059047630316e+03,		1.089476643932747e+03,		1.089893162182043e+03,		1.090308608678391e+03,
		1.090722989664847e+03,		1.091136311328039e+03,		1.091548579798869e+03,		1.091959801153184e+03,		1.092369981412452e+03,
		1.092779126544426e+03,		1.093187242463789e+03,		1.093594335032800e+03,		1.094000410061922e+03,		1.094405473310445e+03,
		1.094809530487096e+03,		1.095212587250645e+03,		1.095614649210495e+03,		1.096015721927271e+03,		1.096415810913390e+03,
		1.096814921633636e+03,		1.097213059505711e+03,		1.097610229900793e+03,		1.098006438144072e+03,		1.098401689515289e+03,
		1.098795989249260e+03,		1.099189342536397e+03,		1.099581754523217e+03,		1.099973230312848e+03,		1.100363774965524e+03,
		1.100753393499075e+03,		1.101142090889409e+03,		1.101529872070987e+03,		1.101916741937294e+03,		1.102302705341297e+03,
		1.102687767095904e+03,		1.103071931974406e+03,		1.103455204710932e+03,		1.103837590000871e+03,		1.104219092501310e+03,
		1.104599716831460e+03,		1.104979467573066e+03,		1.105358349270824e+03,		1.105736366432791e+03,		1.106113523530777e+03,
		1.106489825000750e+03,		1.106865275243217e+03,		1.107239878623614e+03,		1.107613639472686e+03,		1.107986562086856e+03,
		1.108358650728598e+03,		1.108729909626797e+03,		1.109100342977116e+03,		1.109469954942339e+03,		1.109838749652728e+03,
		1.110206731206368e+03,		1.110573903669501e+03,		1.110940271076868e+03,		1.111305837432034e+03,		1.111670606707722e+03,
		1.112034582846128e+03,		1.112397769759243e+03,		1.112760171329166e+03,		1.113121791408415e+03,		1.113482633820229e+03,
		1.113842702358872e+03,		1.114202000789935e+03,		1.114560532850620e+03,		1.114918302250039e+03,		1.115275312669498e+03,
		1.115631567762775e+03,		1.115987071156406e+03,		1.116341826449956e+03,		1.116695837216291e+03,		1.117049107001850e+03,
		1.117401639326906e+03,		1.117753437685828e+03,		1.118104505547343e+03,		1.118454846354786e+03,		1.118804463526357e+03,
		1.119153360455366e+03,		1.119501540510480e+03,		1.119849007035968e+03,		1.120195763351933e+03,		1.120541812754556e+03,
		1.120887158516330e+03,		1.121231803886285e+03,		1.121575752090221e+03,		1.121919006330927e+03,		1.122261569788412e+03,
		1.122603445620118e+03,		1.122944636961141e+03,		1.123285146924442e+03,		1.123624978601058e+03,		1.123964135060318e+03,
		1.124302619350041e+03,		1.124640434496748e+03,		1.124977583505858e+03,		1.125314069361889e+03,		1.125649895028654e+03,
		1.125985063449460e+03,		1.126319577547296e+03,		1.126653440225022e+03,		1.126986654365563e+03,		1.127319222832085e+03,
		1.127651148468190e+03,		1.127982434098086e+03,		1.128313082526773e+03,		1.128643096540219e+03,		1.128972478904020e+03,
		1.129301232369703e+03,		1.129629359665585e+03,		1.129956863503230e+03,		1.130283746576026e+03,		1.130610011559347e+03,
		1.130935661110717e+03,		1.131260697869972e+03,		1.131585124459417e+03,		1.131908943483988e+03,		1.132232157531404e+03,
		1.132554769172323e+03,		1.132876780960494e+03,		1.133198195432907e+03,		1.133519015109942e+03,		1.133839242495518e+03,
		1.134158880077237e+03,		1.134477930326528e+03,		1.134796395698790e+03,		1.135114278633531e+03,		1.135431581554512e+03,
		1.135748306869879e+03,		1.136064456972302e+03,		1.136380034239109e+03,		1.136695041032422e+03,		1.137009479699283e+03,
		1.137323352571791e+03,		1.137636661967224e+03,		1.137949410188173e+03,		1.138261599522663e+03,		1.138573232244281e+03,
		1.138884310612299e+03,		1.139194836871791e+03,		1.139504813253765e+03,		1.139814241975269e+03,		1.140123125239518e+03,
		1.140431465236010e+03,		1.140739264140638e+03,		1.141046524115808e+03,		1.141353247310548e+03,		1.141659435860627e+03,
		1.141965091888657e+03,		1.142270217504212e+03,		1.142574814803927e+03,		1.142878885871615e+03,		1.143182432778363e+03,
		1.143485457582647e+03,		1.143787962330428e+03,		1.144089949055262e+03,		1.144391419778395e+03,		1.144692376508868e+03,
		1.144992821243616e+03,		1.145292755967568e+03,		1.145592182653743e+03,		1.145891103263344e+03,		1.146189519745861e+03,
		1.146487434039158e+03,		1.146784848069573e+03,		1.147081763752007e+03,		1.147378182990019e+03,		1.147674107675911e+03,
		1.147969539690826e+03,		1.148264480904830e+03,		1.148558933177007e+03,		1.148852898355539e+03,		1.149146378277800e+03,
		1.149439374770434e+03,		1.149731889649448e+03,		1.150023924720288e+03,		1.150315481777926e+03,		1.150606562606943e+03,
		1.150897168981608e+03,		1.151187302665962e+03,		1.151476965413893e+03,		1.151766158969219e+03,		1.152054885065766e+03,
		1.152343145427441e+03,		1.152630941768319e+03,		1.152918275792703e+03,		1.153205149195217e+03,		1.153491563660865e+03,
		1.153777520865117e+03,		1.154063022473975e+03,		1.154348070144048e+03,		1.154632665522619e+03,		1.154916810247726e+03
	},
	{
		1.845328296292442e+00,		5.603131592281366e+00,		9.449879817974002e+00,		1.339122347144022e+01,		1.743341795581159e+01,
		2.158341642481154e+01,		2.584898167725634e+01,		3.023882209932092e+01,		3.476275828075335e+01,		3.943192920209199e+01,
		4.425905010868240e+01,		4.925873882871567e+01,		5.444793411389259e+01,		5.984643982057498e+01,		6.547764448636134e+01,
		7.136949069598852e+01,		7.755580903781235e+01,		8.407819950098111e+01,		9.098876245313248e+01,		9.835420054012855e+01,
		1.062622389405728e+02,		1.148321983647867e+02,		1.242335665621363e+02,		1.347215105881912e+02,		1.467132949674429e+02,
		1.609849478946090e+02,		8.227889880789299e+02,		8.270429581008339e+02,		8.310502202183573e+02,		8.348434377822232e+02,
		8.384488204245112e+02,		8.418877715240810e+02,		8.451780298944054e+02,		8.483344845352159e+02,		8.513697705476335e+02,
		8.542947142200012e+02,		8.571186715336855e+02,		8.598497897186405e+02,		8.624952121975460e+02,		8.650612411853718e+02,
		8.675534681449494e+02,		8.699768795168164e+02,		8.723359432009169e+02,		8.746346798906892e+02,		8.768767223677730e+02,
		8.790653651403682e+02,		8.812036062713606e+02,		8.832941828403152e+02,		8.853396011789848e+02,		8.873421627871339e+02,
		8.893039866558397e+02,		8.912270285865497e+02,		8.931130979781991e+02,		8.949638724839738e+02,		8.967809108464262e+02,
		8.985656641855460e+02,		9.003194859580384e+02,		9.020436407733731e+02,		9.037393122220418e+02,		9.054076098472264e+02,
		9.070495753710114e+02,		9.086661882697182e+02,		9.102583707791496e+02,		9.118269923989094e+02,		9.133728739554377e+02,
		9.148967912750827e+02,		9.163994785117311e+02,		9.178816311676632e+02,		9.193439088412334e+02,		9.207869377308353e+02,
		9.222113129219069e+02,		9.236176004741169e+02,		9.250063393408072e+02,		9.263780431236011e+02,		9.277332016877293e+02,
		9.290722826481498e+02,		9.303957327398655e+02,		9.317039790790088e+02,		9.329974303373618e+02,		9.342764778173810e+02,
		9.355414964570875e+02,		9.367928457588256e+02,		9.380308706524829e+02,		9.392559022981551e+02,		9.404682588333686e+02,
		9.416682460694027e+02,		9.428561581408948e+02,		9.440322781124521e+02,		9.451968785456874e+02,		9.463502220297585e+02,
		9.474925616782463e+02,		9.486241415948992e+02,		9.497451973106000e+02,		9.508559561936809e+02,		9.519566378355281e+02,
		9.530474544132677e+02,		9.541286110311555e+02,		9.552003060438573e+02,		9.562627313540063e+02,		9.573160727056553e+02,
		9.583605099499173e+02,		9.593962173011258e+02,		9.604233635780355e+02,		9.614421124320455e+02,		9.624526225632283e+02,
		9.634550479249725e+02,		9.644495379179685e+02,		9.654362375741728e+02,		9.664152877314065e+02,		9.673868251991446e+02,
		9.683509829160188e+02,		9.693078900995677e+02,		9.702576723886493e+02,		9.712004519789822e+02,		9.721363477521918e+02,
		9.730654753987567e+02,		9.739879475351845e+02,		9.749038738157442e+02,		9.758133610390745e+02,		9.767165132499387e+02,
		9.776134318363775e+02,		9.785042156225603e+02,		9.793889609574913e+02,		9.802677618010011e+02,		9.811407098009995e+02,
		9.820078943763508e+02,		9.828694027881224e+02,		9.837253202115274e+02,		9.845757298041812e+02,		9.854207127715339e+02,
		9.862603484296060e+02,		9.870947142651822e+02,		9.879238859935664e+02,		9.887479376140333e+02,		9.895669414630828e+02,
		9.903809682655938e+02,		9.911900871839923e+02,		9.919943658655110e+02,		9.927938704876441e+02,		9.935886658018686e+02,
		9.943788151757236e+02,		9.951643806333090e+02,		9.959454228942855e+02,		9.967220014114413e+02,		9.974941744068797e+02,
		9.982619989069063e+02,		9.990255307756563e+02,		9.997848247475163e+02,		1.000539934458419e+03,		1.001290912476012e+03,
		1.002037810328797e+03,		1.002780678534253e+03,		1.003519566625988e+03,		1.004254523179976e+03,		1.004985595839898e+03,
		1.005712831341632e+03,		1.006436275536934e+03,		1.007155973417869e+03,		1.007871969133541e+03,		1.008584306018808e+03,
		1.009293026610576e+03,		1.009998172668881e+03,		1.010699785196306e+03,		1.011397904456781e+03,		1.012092569993799e+03,
		1.012783820648052e+03,		1.013471694574525e+03,		1.014156229259062e+03,		1.014837461534423e+03,		1.015515427595847e+03,
		1.016190163016157e+03,		1.016861702760397e+03,		1.017530081200038e+03,		1.018195332126769e+03,		1.018857488765867e+03,
		1.019516583789186e+03,		1.020172649327766e+03,		1.020825716984079e+03,		1.021475817843913e+03,		1.022122982487938e+03,
		1.022767241002911e+03,		1.023408622992601e+03,		1.024047157588381e+03,		1.024682873459536e+03,		1.025315798823289e+03,
		1.025945961454534e+03,		1.026573388695326e+03,		1.027198107464091e+03,		1.027820144264606e+03,		1.028439525194717e+03,
		1.029056275956084e+03,		1.029670421858017e+03,		1.030281987831566e+03,		1.030890998433676e+03,		1.031497477855655e+03,
		1.032101449930635e+03,		1.032702938140809e+03,		1.033301965624488e+03,		1.033898555182982e+03,		1.034492729287308e+03,
		1.035084510084723e+03,		1.035673919405094e+03,		1.036260978767110e+03,		1.036845709384347e+03,		1.037428132171165e+03,
		1.038008267748479e+03,		1.038586136449371e+03,		1.039161758324593e+03,		1.039735153147900e+03,		1.040306340421290e+03,
		1.040875339380088e+03,		1.041442168997937e+03,		1.042006847991646e+03,		1.042569394825942e+03,		1.043129827718106e+03,
		1.043688164642488e+03,		1.044244423334940e+03,		1.044798621297117e+03,		1.045350775800720e+03,		1.045900903891599e+03,
		1.046449022393792e+03,		1.046995147913459e+03,		1.047539296842732e+03,		1.048081485363478e+03,		1.048621729450976e+03,
		1.049160044877517e+03,		1.049696447215920e+03,		1.050230951842974e+03,		1.050763573942799e+03,		1.051294328510141e+03,
		1.051823230353594e+03,		1.052350294098748e+03,		1.052875534191272e+03,		1.053398964899932e+03,		1.053920600319549e+03,
		1.054440454373878e+03,		1.054958540818453e+03,		1.055474873243343e+03,		1.055989465075875e+03,		1.056502329583282e+03,
		1.057013479875312e+03,		1.057522928906769e+03,		1.058030689480011e+03,		1.058536774247394e+03,		1.059041195713666e+03,
		1.059543966238316e+03,		1.060045098037866e+03,		1.060544603188130e+03,		1.061042493626421e+03,		1.061538781153713e+03,
		1.062033477436759e+03,		1.062526594010176e+03,		1.063018142278480e+03,		1.063508133518085e+03,		1.063996578879260e+03,
		1.064483489388055e+03,		1.064968875948182e+03,		1.065452749342862e+03,		1.065935120236642e+03,		1.066415999177169e+03,
		1.066895396596938e+03,		1.067373322814999e+03,		1.067849788038641e+03,		1.068324802365032e+03,		1.068798375782848e+03,
		1.069270518173846e+03,		1.069741239314431e+03,		1.070210548877182e+03,		1.070678456432350e+03,		1.071144971449332e+03,
		1.071610103298122e+03,		1.072073861250723e+03,		1.072536254482544e+03,		1.072997292073775e+03,		1.073456983010722e+03,
		1.073915336187130e+03,		1.074372360405486e+03,		1.074828064378285e+03,		1.075282456729286e+03,		1.075735545994739e+03,
		1.076187340624595e+03,		1.076637848983686e+03,		1.077087079352900e+03,		1.077535039930323e+03,		1.077981738832361e+03,
		1.078427184094849e+03,		1.078871383674145e+03,		1.079314345448187e+03,		1.079756077217553e+03,		1.080196586706486e+03,
		1.080635881563921e+03,		1.081073969364469e+03,		1.081510857609409e+03,		1.081946553727648e+03,		1.082381065076675e+03,
		1.082814398943485e+03,		1.083246562545509e+03,		1.083677563031506e+03,		1.084107407482455e+03,		1.084536102912431e+03,
		1.084963656269460e+03,		1.085390074436365e+03,		1.085815364231600e+03,		1.086239532410061e+03,		1.086662585663902e+03,
		1.087084530623315e+03,		1.087505373857320e+03,		1.087925121874521e+03,		1.088343781123871e+03,		1.088761357995407e+03,
		1.089177858820985e+03,		1.089593289875001e+03,		1.090007657375093e+03,		1.090420967482844e+03,		1.090833226304467e+03,
		1.091244439891478e+03,		1.091654614241366e+03,		1.092063755298246e+03,		1.092471868953501e+03,		1.092878961046421e+03,
		1.093285037364829e+03,		1.093690103645692e+03,		1.094094165575734e+03,		1.094497228792027e+03,		1.094899298882588e+03,
		1.095300381386948e+03,		1.095700481796732e+03,		1.096099605556215e+03,		1.096497758062883e+03,		1.096894944667971e+03,
		1.097291170677008e+03,		1.097686441350342e+03,		1.098080761903666e+03,		1.098474137508528e+03,		1.098866573292841e+03,
		1.099258074341385e+03,		1.099648645696293e+03,		1.100038292357542e+03,		1.100427019283431e+03,		1.100814831391048e+03,
		1.101201733556738e+03,		1.101587730616560e+03,		1.101972827366743e+03,		1.102357028564124e+03,		1.102740338926589e+03,
		1.103122763133512e+03,		1.103504305826172e+03,		1.103884971608179e+03,		1.104264765045890e+03,		1.104643690668816e+03,
		1.105021752970023e+03,		1.105398956406531e+03,		1.105775305399713e+03,		1.106150804335671e+03,		1.106525457565625e+03,
		1.106899269406286e+03,		1.107272244140227e+03,		1.107644386016253e+03,		1.108015699249759e+03,		1.108386188023084e+03,
		1.108755856485869e+03,		1.109124708755396e+03,		1.109492748916937e+03,		1.109859981024089e+03,		1.110226409099104e+03,
		1.110592037133224e+03,		1.110956869086996e+03,		1.111320908890603e+03,		1.111684160444171e+03,		1.112046627618085e+03,
		1.112408314253296e+03,		1.112769224161623e+03,		1.113129361126053e+03,		1.113488728901037e+03,		1.113847331212783e+03,
		1.114205171759541e+03,		1.114562254211892e+03,		1.114918582213023e+03,		1.115274159379011e+03,		1.115628989299086e+03,
		1.115983075535913e+03,		1.116336421625854e+03,		1.116689031079224e+03,		1.117040907380564e+03,		1.117392053988887e+03,
		1.117742474337937e+03,		1.118092171836438e+03,		1.118441149868338e+03,		1.118789411793058e+03,		1.119136960945732e+03,
		1.119483800637439e+03,		1.119829934155446e+03,		1.120175364763438e+03,		1.120520095701742e+03,		1.120864130187559e+03,
		1.121207471415187e+03,		1.121550122556243e+03,		1.121892086759876e+03,		1.122233367152985e+03,		1.122573966840438e+03,
		1.122913888905273e+03,		1.123253136408911e+03,		1.123591712391362e+03,		1.123929619871426e+03,		1.124266861846893e+03,
		1.124603441294743e+03,		1.124939361169848e+03,		1.125274624411214e+03,		1.125609233932978e+03,		1.125943192630810e+03,
		1.126276503380525e+03,		1.126609169038268e+03,		1.126941192440693e+03,		1.127272576405150e+03,		1.127603323729853e+03,
		1.127933437194065e+03,		1.128262919558269e+03,		1.128591773564337e+03,		1.128920001935704e+03,		1.129247607377533e+03,
		1.129574592576883e+03,		1.129900960202872e+03,		1.130226712906841e+03,		1.130551853322510e+03,		1.130876384066142e+03,
		1.131200307736697e+03,		1.131523626915984e+03,		1.131846344168823e+03,		1.132168462043187e+03,		1.132489983070356e+03,
		1.132810909765066e+03,		1.133131244625655e+03,		1.133450990134204e+03,		1.133770148756686e+03,		1.134088722943105e+03,
		1.134406715127633e+03,		1.134724127728756e+03,		1.135040963149401e+03,		1.135357223777081e+03,		1.135672911984023e+03,
		1.135988030127302e+03,		1.136302580548974e+03,		1.136616565576200e+03,		1.136929987521382e+03,		1.137242848682286e+03,
		1.137555151342163e+03,		1.137866897769881e+03,		1.138178090220043e+03,		1.138488730933111e+03,		1.138798822135520e+03,
		1.139108366039807e+03,		1.139417364844720e+03,		1.139725820735336e+03,		1.140033735883180e+03,		1.140341112446334e+03,
		1.140647952569554e+03,		1.140954258384377e+03,		1.141260032009233e+03,		1.141565275549558e+03,		1.141869991097894e+03,
		1.142174180734003e+03,		1.142477846524968e+03,		1.142780990525303e+03,		1.143083614777048e+03,		1.143385721309881e+03,
		1.143687312141212e+03,		1.143988389276289e+03,		1.144288954708290e+03,		1.144589010418431e+03,		1.144888558376054e+03,
		1.145187600538727e+03,		1.145486138852343e+03,		1.145784175251209e+03,		1.146081711658140e+03,		1.146378749984553e+03,
		1.146675292130557e+03,		1.146971339985049e+03,		1.147266895425794e+03,		1.147561960319521e+03,		1.147856536522007e+03,
		1.148150625878169e+03,		1.148444230222143e+03,		1.148737351377374e+03,		1.149029991156699e+03,		1.149322151362431e+03,
		1.149613833786441e+03,		1.149905040210242e+03,		1.150195772405065e+03,		1.150486032131945e+03,		1.150775821141796e+03,
		1.151065141175493e+03,		1.151353993963950e+03,		1.151642381228192e+03,		1.151930304679438e+03,		1.152217766019173e+03,
		1.152504766939221e+03,		1.152791309121828e+03,		1.153077394239723e+03,		1.153363023956200e+03,		1.153648199925187e+03
	},
	{
		1.841407682585783e+00,		5.590776031714516e+00,		9.428230970786398e+00,		1.335931792901230e+01,		1.739017003001763e+01,
		2.152759730376388e+01,		2.577919398545640e+01,		3.015346858805935e+01,		3.466000294042746e+01,		3.930964847526212e+01,
		4.411477100351887e+01,		4.908955944856464e+01,		5.425042020629950e+01,		5.961648803736708e+01,		6.521029850266780e+01,
		7.105868904610135e+01,		7.719403145447332e+01,		8.365595781751412e+01,		9.049384500537856e+01,		9.777050913191950e+01,
		1.055679178501127e+02,		1.139964549327122e+02,		1.232108765086656e+02,		1.334400258506470e+02,		1.450483998221916e+02,
		1.586853636468189e+02,		8.159338387574687e+02,		8.204986265356284e+02,		8.247753200749162e+02,		8.288050872412913e+02,
		8.326203574815240e+02,		8.362472107256531e+02,		8.397069831153392e+02,		8.430173844006235e+02,		8.461932980676560e+02,
		8.492473682131319e+02,		8.521904389259793e+02,		8.550318891402171e+02,		8.577798918284859e+02,		8.604416174123954e+02,
		8.630233953681144e+02,		8.655308440441305e+02,		8.679689759904859e+02,		8.703422841987272e+02,		8.726548133009624e+02,
		8.749102188011010e+02,		8.771118166973894e+02,		8.792626253260855e+02,		8.813654008591268e+02,		8.834226675877386e+02,
		8.854367438948768e+02,		8.874097646332530e+02,		8.893437005080842e+02,		8.912403749236794e+02,		8.931014786945289e+02,
		8.949285829376759e+02,		8.967231504126736e+02,		8.984865455302755e+02,		9.002200432148187e+02,		9.019248367758460e+02,
		9.036020449201602e+02,		9.052527180156472e+02,		9.068778437015204e+02,		9.084783519259570e+02,		9.100551194804790e+02,
		9.116089740908074e+02,		9.131406981157179e+02,		9.146510318985740e+02,		9.161406768119209e+02,		9.176102980205130e+02,
		9.190605270109230e+02,		9.204919638912854e+02,		9.219051794991034e+02,		9.233007173321819e+02,		9.246790953165972e+02,
		9.260408074411633e+02,		9.273863252491243e+02,		9.287160992225018e+02,		9.300305600561638e+02,		9.313301198359976e+02,
		9.326151731292680e+02,		9.338860979949694e+02,		9.351432569211876e+02,		9.363869976957536e+02,		9.376176542158858e+02,
		9.388355472419140e+02,		9.400409850996997e+02,		9.412342643359416e+02,		9.424156703301347e+02,		9.435854778666096e+02,
		9.447439516697780e+02,		9.458913469054107e+02,		9.470279096518549e+02,		9.481538773365199e+02,		9.492694791555491e+02,
		9.503749364595195e+02,		9.514704631201424e+02,		9.525562658747165e+02,		9.536325446506379e+02,		9.546994928713051e+02,
		9.557572977447501e+02,		9.568061405361088e+02,		9.578461968250792e+02,		9.588776367492950e+02,		9.599006252345919e+02,
		9.609153222129844e+02,		9.619218828291484e+02,		9.629204576361425e+02,		9.639111927810268e+02,		9.648942301810324e+02,
		9.658697076908242e+02,		9.668377592614289e+02,		9.677985150913057e+02,		9.687521017700466e+02,		9.696986424151123e+02,
		9.706382568020359e+02,		9.715710614884480e+02,		9.724971699337501e+02,		9.734166926069112e+02,		9.743297371005234e+02,
		9.752364082295717e+02,		9.761368081303374e+02,		9.770310363540636e+02,		9.779191899564559e+02,		9.788013635832800e+02,
		9.796776495522394e+02,		9.805481379313352e+02,		9.814129166138848e+02,		9.822720713903846e+02,		9.831256860173600e+02,
		9.839738422833595e+02,		9.848166200722458e+02,		9.856540974239073e+02,		9.864863505925163e+02,		9.873134541024602e+02,
		9.881354808020546e+02,		9.889525019151364e+02,		9.897645870906570e+02,		9.905718044503486e+02,		9.913742206345653e+02,
		9.921719008463829e+02,		9.929649088940251e+02,		9.937533072317262e+02,		9.945371569990407e+02,		9.953165180587401e+02,
		9.960914490333014e+02,		9.968620073400831e+02,		9.976282492252302e+02,		9.983902297980796e+02,		9.991480030568136e+02,
		9.999016219267558e+02,		1.000651138285008e+03,		1.001396602989891e+03,		1.002138065908332e+03,		1.002875575942311e+03,
		1.003609181054423e+03,		1.004338928292568e+03,		1.005064863813832e+03,		1.005787032907564e+03,		1.006505480017705e+03,
		1.007220248764381e+03,		1.007931381964803e+03,		1.008638921653484e+03,		1.009342909101824e+03,		1.010043384837059e+03,
		1.010740388660623e+03,		1.011433959665933e+03,		1.012124136255619e+03,		1.012810956158218e+03,		1.013494456444368e+03,
		1.014174673542496e+03,		1.014851643254036e+03,		1.015525400768193e+03,		1.016195980676257e+03,		1.016863416985499e+03,
		1.017527743132653e+03,		1.018188991997009e+03,		1.018847195913106e+03,		1.019502386684397e+03,		1.020154595590616e+03,
		1.020803853405647e+03,		1.021450190405052e+03,		1.022093636377934e+03,		1.022734220637627e+03,		1.023371972032076e+03,
		1.024006918953942e+03,		1.024639089350424e+03,		1.025268510732807e+03,		1.025895210185756e+03,		1.026519214376355e+03,
		1.027140549562913e+03,		1.027759241603512e+03,		1.028375315964356e+03,		1.028988797727877e+03,		1.029599711600636e+03,
		1.030208081921026e+03,		1.030813932666755e+03,		1.031417287462158e+03,		1.032018169585299e+03,		1.032616601974921e+03,
		1.033212607237180e+03,		1.033806207652241e+03,		1.034397425180700e+03,		1.034986281469840e+03,		1.035572797859728e+03,
		1.036156995389185e+03,		1.036738894801568e+03,		1.037318516550454e+03,		1.037895880805160e+03,		1.038471007456133e+03,
		1.039043916120214e+03,		1.039614626145782e+03,		1.040183156617748e+03,		1.040749526362477e+03,		1.041313753952551e+03,
		1.041875857711444e+03,		1.042435855718072e+03,		1.042993765811261e+03,		1.043549605594085e+03,		1.044103392438117e+03,
		1.044655143487587e+03,		1.045204875663443e+03,		1.045752605667305e+03,		1.046298349985356e+03,		1.046842124892124e+03,
		1.047383946454191e+03,		1.047923830533812e+03,		1.048461792792467e+03,		1.048997848694316e+03,		1.049532013509594e+03,
		1.050064302317925e+03,		1.050594730011568e+03,		1.051123311298589e+03,		1.051650060705960e+03,		1.052174992582613e+03,
		1.052698121102400e+03,		1.053219460267008e+03,		1.053739023908816e+03,		1.054256825693677e+03,		1.054772879123649e+03,
		1.055287197539679e+03,		1.055799794124213e+03,		1.056310681903766e+03,		1.056819873751436e+03,		1.057327382389361e+03,
		1.057833220391133e+03,		1.058337400184164e+03,		1.058839934051992e+03,		1.059340834136560e+03,		1.059840112440430e+03,
		1.060337780828969e+03,		1.060833851032478e+03,		1.061328334648292e+03,		1.061821243142829e+03,		1.062312587853600e+03,
		1.062802379991188e+03,		1.063290630641173e+03,		1.063777350766046e+03,		1.064262551207046e+03,		1.064746242686010e+03,
		1.065228435807146e+03,		1.065709141058794e+03,		1.066188368815156e+03,		1.066666129337975e+03,		1.067142432778201e+03,
		1.067617289177620e+03,		1.068090708470445e+03,		1.068562700484893e+03,		1.069033274944711e+03,		1.069502441470703e+03,
		1.069970209582200e+03,		1.070436588698519e+03,		1.070901588140397e+03,		1.071365217131391e+03,		1.071827484799251e+03,
		1.072288400177286e+03,		1.072747972205683e+03,		1.073206209732813e+03,		1.073663121516521e+03,		1.074118716225375e+03,
		1.074573002439913e+03,		1.075025988653854e+03,		1.075477683275293e+03,		1.075928094627872e+03,		1.076377230951939e+03,
		1.076825100405677e+03,		1.077271711066220e+03,		1.077717070930745e+03,		1.078161187917550e+03,		1.078604069867112e+03,
		1.079045724543125e+03,		1.079486159633524e+03,		1.079925382751486e+03,		1.080363401436422e+03,		1.080800223154948e+03,
		1.081235855301836e+03,		1.081670305200961e+03,		1.082103580106215e+03,		1.082535687202423e+03,		1.082966633606237e+03,
		1.083396426367007e+03,		1.083825072467655e+03,		1.084252578825520e+03,		1.084678952293195e+03,		1.085104199659353e+03,
		1.085528327649554e+03,		1.085951342927046e+03,		1.086373252093543e+03,		1.086794061690003e+03,		1.087213778197384e+03,
		1.087632408037393e+03,		1.088049957573220e+03,		1.088466433110264e+03,		1.088881840896845e+03,		1.089296187124907e+03,
		1.089709477930704e+03,		1.090121719395485e+03,		1.090532917546165e+03,		1.090943078355978e+03,		1.091352207745130e+03,
		1.091760311581437e+03,		1.092167395680956e+03,		1.092573465808604e+03,		1.092978527678767e+03,		1.093382586955904e+03,
		1.093785649255135e+03,		1.094187720142831e+03,		1.094588805137180e+03,		1.094988909708760e+03,		1.095388039281095e+03,
		1.095786199231200e+03,		1.096183394890130e+03,		1.096579631543505e+03,		1.096974914432041e+03,		1.097369248752068e+03,
		1.097762639656033e+03,		1.098155092253014e+03,		1.098546611609205e+03,		1.098937202748410e+03,		1.099326870652525e+03,
		1.099715620262007e+03,		1.100103456476347e+03,		1.100490384154530e+03,		1.100876408115487e+03,		1.101261533138543e+03,
		1.101645763963861e+03,		1.102029105292876e+03,		1.102411561788725e+03,		1.102793138076667e+03,		1.103173838744506e+03,
		1.103553668342998e+03,		1.103932631386257e+03,		1.104310732352157e+03,		1.104687975682726e+03,		1.105064365784534e+03,
		1.105439907029079e+03,		1.105814603753165e+03,		1.106188460259273e+03,		1.106561480815931e+03,		1.106933669658081e+03,
		1.107305030987430e+03,		1.107675568972807e+03,		1.108045287750518e+03,		1.108414191424677e+03,		1.108782284067560e+03,
		1.109149569719930e+03,		1.109516052391369e+03,		1.109881736060607e+03,		1.110246624675846e+03,		1.110610722155069e+03,
		1.110974032386362e+03,		1.111336559228220e+03,		1.111698306509852e+03,		1.112059278031483e+03,		1.112419477564648e+03,
		1.112778908852495e+03,		1.113137575610064e+03,		1.113495481524576e+03,		1.113852630255722e+03,		1.114209025435932e+03,
		1.114564670670656e+03,		1.114919569538635e+03,		1.115273725592167e+03,		1.115627142357375e+03,		1.115979823334465e+03,
		1.116331771997985e+03,		1.116682991797083e+03,		1.117033486155755e+03,		1.117383258473094e+03,		1.117732312123538e+03,
		1.118080650457109e+03,		1.118428276799656e+03,		1.118775194453086e+03,		1.119121406695604e+03,		1.119466916781937e+03,
		1.119811727943570e+03,		1.120155843388962e+03,		1.120499266303774e+03,		1.120841999849628e+03,		1.121184047170238e+03,
		1.121525411382629e+03,		1.121866095583433e+03,		1.122206102847551e+03,		1.122545436228364e+03,		1.122884098757936e+03,
		1.123222093447212e+03,		1.123559423286221e+03,		1.123896091244274e+03,		1.124232100270154e+03,		1.124567453292309e+03,
		1.124902153219050e+03,		1.125236202938724e+03,		1.125569605319913e+03,		1.125902363211610e+03,		1.126234479443402e+03,
		1.126565956825650e+03,		1.126896798149663e+03,		1.127227006187878e+03,		1.127556583694028e+03,		1.127885533403314e+03,
		1.128213858032575e+03,		1.128541560280456e+03,		1.128868642827568e+03,		1.129195108336659e+03,		1.129520959452768e+03,
		1.129846198803389e+03,		1.130170828998625e+03,		1.130494852631347e+03,		1.130818272277348e+03,		1.131141090495492e+03,
		1.131463309827868e+03,		1.131784932799938e+03,		1.132105961920685e+03,		1.132426399682755e+03,		1.132746248562605e+03,
		1.133065511020645e+03,		1.133384189501376e+03,		1.133702286433532e+03,		1.134019804230218e+03,		1.134336745289043e+03,
		1.134653111992258e+03,		1.134968906706885e+03,		1.135284131784856e+03,		1.135598789563136e+03,		1.135912882363856e+03,
		1.136226412494439e+03,		1.136539382247725e+03,		1.136851793902100e+03,		1.137163649721614e+03,		1.137474951956107e+03,
		1.137785702841328e+03,		1.138095904599056e+03,		1.138405559437213e+03,		1.138714669549991e+03,		1.139023237117956e+03,
		1.139331264308172e+03,		1.139638753274307e+03,		1.139945706156753e+03,		1.140252125082726e+03,		1.140558012166388e+03,
		1.140863369508944e+03,		1.141168199198759e+03,		1.141472503311457e+03,		1.141776283910031e+03,		1.142079543044944e+03,
		1.142382282754235e+03,		1.142684505063618e+03,		1.142986211986584e+03,		1.143287405524499e+03,		1.143588087666710e+03,
		1.143888260390631e+03,		1.144187925661850e+03,		1.144487085434221e+03,		1.144785741649955e+03,		1.145083896239723e+03,
		1.145381551122738e+03,		1.145678708206857e+03,		1.145975369388664e+03,		1.146271536553567e+03,		1.146567211575878e+03,
		1.146862396318914e+03,		1.147157092635071e+03,		1.147451302365919e+03,		1.147745027342288e+03,		1.148038269384347e+03,
		1.148331030301692e+03,		1.148623311893429e+03,		1.148915115948256e+03,		1.149206444244542e+03,		1.149497298550411e+03,
		1.149787680623821e+03,		1.150077592212644e+03,		1.150367035054740e+03,		1.150656010878038e+03,		1.150944521400615e+03,
		1.151232568330768e+03,		1.151520153367090e+03,		1.151807278198545e+03,		1.152093944504544e+03,		1.152380153955016e+03
	},
	{
		1.837504022976342e+00,		5.578478055671784e+00,		9.406690773609522e+00,		1.332758472745169e+01,		1.734717348211257e+01,
		2.147212734562914e+01,		2.570987627382393e+01,		3.006873434544567e+01,		3.455805159531139e+01,		3.918840092109432e+01,
		4.397181048847501e+01,		4.892205592825409e+01,		5.405503224436624e+01,		5.938923369528514e+01,		6.494638256382144e+01,
		7.075226739988270e+01,		7.683788276972238e+01,		8.324101446262391e+01,		9.000850302912296e+01,		9.719957750703134e+01,
		1.048909502101837e+02,		1.131849612154307e+02,		1.222233492053519e+02,		1.322122772164027e+02,		1.434724383562303e+02,
		1.565543046232249e+02,		8.087237143969281e+02,		8.136500994938792e+02,		8.182358450677041e+02,		8.225338339789308e+02,
		8.265848114982973e+02,		8.304209604715235e+02,		8.340682181137737e+02,		8.375478411173074e+02,		8.408774991550611e+02,
		8.440720604619202e+02,		8.471441696068091e+02,		8.501046810543901e+02,		8.529629902345930e+02,		8.557272902472778e+02,
		8.584047736231767e+02,		8.610017928334441e+02,		8.635239893812462e+02,		8.659763986546013e+02,		8.683635358600069e+02,
		8.706894670315602e+02,		8.729578681520819e+02,		8.751720747202188e+02,		8.773351235759343e+02,		8.794497884069971e+02,
		8.815186100509936e+02,		8.835439225070037e+02,		8.855278753549192e+02,		8.874724531783512e+02,		8.893794924598415e+02,
		8.912506963373131e+02,		8.930876475415723e+02,		8.948918197799527e+02,		8.966645877868258e+02,		8.984072362257426e+02,
		9.001209675986153e+02,		9.018069092931079e+02,		9.034661198795524e+02,		9.050995947522050e+02,		9.067082711957614e+02,
		9.082930329479382e+02,		9.098547143115751e+02,		9.113941038817264e+02,		9.129119479161153e+02,		9.144089533989608e+02,
		9.158857908286340e+02,		9.173430967548262e+02,		9.187814761049749e+02,		9.202015042997347e+02,		9.216037292006114e+02,
		9.229886728936461e+02,		9.243568333294638e+02,		9.257086858329222e+02,		9.270446844947455e+02,		9.283652634560968e+02,
		9.296708380959675e+02,		9.309618061301304e+02,		9.322385486295085e+02,		9.335014309650372e+02,		9.347508036853338e+02,
		9.359870033328950e+02,		9.372103532039553e+02,		9.384211640566614e+02,		9.396197347734054e+02,		9.408063529724807e+02,
		9.419812955917994e+02,		9.431448294245332e+02,		9.442972116255096e+02,		9.454386901850472e+02,		9.465695043735336e+02,
		9.476898851588905e+02,		9.488000555989355e+02,		9.499002312104053e+02,		9.509906203163516e+02,		9.520714243733858e+02,
		9.531428382802003e+02,		9.542050506686453e+02,		9.552582441785348e+02,		9.563025957172819e+02,		9.573382767053573e+02,
		9.583654533085240e+02,		9.593842866576639e+02,		9.603949330570266e+02,		9.613975441816116e+02,		9.623922672643806e+02,
		9.633792452738999e+02,		9.643586170847087e+02,		9.653305176320238e+02,		9.662950780713890e+02,		9.672524259192699e+02,
		9.682026851919394e+02,		9.691459765367938e+02,		9.700824173574338e+02,		9.710121219328967e+02,		9.719352015313375e+02,
		9.728517645184947e+02,		9.737619164612101e+02,		9.746657602262873e+02,		9.755633960749404e+02,		9.764549217530531e+02,
		9.773404325774977e+02,		9.782200215187027e+02,		9.790937792796637e+02,		9.799617943716058e+02,		9.808241531864320e+02,
		9.816809400661575e+02,		9.825322373694589e+02,		9.833781255354829e+02,		9.842186831450676e+02,		9.850539869794859e+02,
		9.858841120768352e+02,		9.867091317861909e+02,		9.875291178196287e+02,		9.883441403022135e+02,		9.891542678215983e+02,
		9.899595674690177e+02,		9.907601048906421e+02,		9.915559443262397e+02,		9.923471486512946e+02,		9.931337794166568e+02,
		9.939158968867390e+02,		9.946935600763045e+02,		9.954668267859422e+02,		9.962357536362421e+02,		9.970003961007687e+02,
		9.977608085378611e+02,		9.985170442213081e+02,		9.992691553699666e+02,		1.000017193176345e+03,		1.000761207834207e+03,
		1.001501248565237e+03,		1.002237363644800e+03,		1.002969600426831e+03,		1.003698005367904e+03,		1.004422624050499e+03,
		1.005143501205499e+03,		1.005860680733959e+03,		1.006574205728165e+03,		1.007284118492019e+03,		1.007990460560762e+03,
		1.008693272720083e+03,		1.009392595024609e+03,		1.010088466817452e+03,		1.010780926741959e+03,		1.011470012765942e+03,
		1.012155762193825e+03,		1.012838211683004e+03,		1.013517397259480e+03,		1.014193354332667e+03,		1.014866117709822e+03,
		1.015535721610043e+03,		1.016202199677860e+03,		1.016865584997937e+03,		1.017525910102377e+03,		1.018183206990756e+03,
		1.018837507137489e+03,		1.019488841504676e+03,		1.020137240553486e+03,		1.020782734255245e+03,		1.021425352102198e+03,
		1.022065123117969e+03,		1.022702075867752e+03,		1.023336238468191e+03,		1.023967638597011e+03,		1.024596303502383e+03,
		1.025222260012026e+03,		1.025845534542074e+03,		1.026466153105707e+03,		1.027084141321538e+03,		1.027699524421798e+03,
		1.028312327260289e+03,		1.028922574320141e+03,		1.029530289721357e+03,		1.030135497228173e+03,		1.030738220256224e+03,
		1.031338481879522e+03,		1.031936304837266e+03,		1.032531711540479e+03,		1.033124724078462e+03,		1.033715364225114e+03,
		1.034303653445065e+03,		1.034889612899696e+03,		1.035473263452944e+03,		1.036054625677062e+03,		1.036633719858142e+03,
		1.037210566001576e+03,		1.037785183837332e+03,		1.038357592825150e+03,		1.038927812159577e+03,		1.039495860774905e+03,
		1.040061757349984e+03,		1.040625520312925e+03,		1.041187167845687e+03,		1.041746717888568e+03,		1.042304188144582e+03,
		1.042859596083744e+03,		1.043412958947246e+03,		1.043964293751550e+03,		1.044513617292379e+03,		1.045060946148626e+03,
		1.045606296686169e+03,		1.046149685061598e+03,		1.046691127225871e+03,		1.047230638927880e+03,		1.047768235717938e+03,
		1.048303932951194e+03,		1.048837745790973e+03,		1.049369689212042e+03,		1.049899778003802e+03,		1.050428026773420e+03,
		1.050954449948888e+03,		1.051479061782014e+03,		1.052001876351359e+03,		1.052522907565106e+03,		1.053042169163864e+03,
		1.053559674723424e+03,		1.054075437657452e+03,		1.054589471220123e+03,		1.055101788508709e+03,		1.055612402466104e+03,
		1.056121325883307e+03,		1.056628571401848e+03,		1.057134151516165e+03,		1.057638078575937e+03,		1.058140364788367e+03,
		1.058641022220422e+03,		1.059140062801024e+03,		1.059637498323201e+03,		1.060133340446196e+03,		1.060627600697529e+03,
		1.061120290475032e+03,		1.061611421048825e+03,		1.062101003563267e+03,		1.062589049038872e+03,		1.063075568374171e+03,
		1.063560572347564e+03,		1.064044071619107e+03,		1.064526076732290e+03,		1.065006598115771e+03,		1.065485646085071e+03,
		1.065963230844254e+03,		1.066439362487556e+03,		1.066914051001000e+03,		1.067387306263971e+03,		1.067859138050766e+03,
		1.068329556032114e+03,		1.068798569776670e+03,		1.069266188752480e+03,		1.069732422328418e+03,		1.070197279775602e+03,
		1.070660770268780e+03,		1.071122902887689e+03,		1.071583686618400e+03,		1.072043130354624e+03,		1.072501242899009e+03,
		1.072958032964404e+03,		1.073413509175108e+03,		1.073867680068090e+03,		1.074320554094191e+03,		1.074772139619312e+03,
		1.075222444925564e+03,		1.075671478212417e+03,		1.076119247597821e+03,		1.076565761119299e+03,		1.077011026735040e+03,
		1.077455052324958e+03,		1.077897845691741e+03,		1.078339414561873e+03,		1.078779766586658e+03,		1.079218909343201e+03,
		1.079656850335394e+03,		1.080093596994870e+03,		1.080529156681959e+03,		1.080963536686607e+03,		1.081396744229297e+03,
		1.081828786461945e+03,		1.082259670468786e+03,		1.082689403267242e+03,		1.083117991808782e+03,		1.083545442979760e+03,
		1.083971763602246e+03,		1.084396960434839e+03,		1.084821040173470e+03,		1.085244009452193e+03,		1.085665874843960e+03,
		1.086086642861381e+03,		1.086506319957486e+03,		1.086924912526456e+03,		1.087342426904357e+03,		1.087758869369854e+03,
		1.088174246144920e+03,		1.088588563395529e+03,		1.089001827232341e+03,		1.089414043711376e+03,		1.089825218834676e+03,
		1.090235358550959e+03,		1.090644468756265e+03,		1.091052555294581e+03,		1.091459623958475e+03,		1.091865680489702e+03,
		1.092270730579814e+03,		1.092674779870754e+03,		1.093077833955444e+03,		1.093479898378358e+03,		1.093880978636098e+03,
		1.094281080177955e+03,		1.094680208406454e+03,		1.095078368677908e+03,		1.095475566302948e+03,		1.095871806547052e+03,
		1.096267094631072e+03,		1.096661435731740e+03,		1.097054834982178e+03,		1.097447297472392e+03,		1.097838828249773e+03,
		1.098229432319567e+03,		1.098619114645366e+03,		1.099007880149568e+03,		1.099395733713847e+03,		1.099782680179609e+03,
		1.100168724348440e+03,		1.100553870982550e+03,		1.100938124805218e+03,		1.101321490501213e+03,		1.101703972717230e+03,
		1.102085576062302e+03,		1.102466305108218e+03,		1.102846164389930e+03,		1.103225158405955e+03,		1.103603291618775e+03,
		1.103980568455224e+03,		1.104356993306877e+03,		1.104732570530430e+03,		1.105107304448076e+03,		1.105481199347875e+03,
		1.105854259484119e+03,		1.106226489077696e+03,		1.106597892316439e+03,		1.106968473355484e+03,		1.107338236317610e+03,
		1.107707185293588e+03,		1.108075324342509e+03,		1.108442657492123e+03,		1.108809188739165e+03,		1.109174922049680e+03,
		1.109539861359339e+03,		1.109904010573758e+03,		1.110267373568808e+03,		1.110629954190920e+03,		1.110991756257393e+03,
		1.111352783556688e+03,		1.111713039848724e+03,		1.112072528865173e+03,		1.112431254309745e+03,		1.112789219858470e+03,
		1.113146429159984e+03,		1.113502885835800e+03,		1.113858593480583e+03,		1.114213555662422e+03,		1.114567775923094e+03,
		1.114921257778327e+03,		1.115274004718060e+03,		1.115626020206699e+03,		1.115977307683373e+03,		1.116327870560678e+03,
		1.116677712231012e+03,		1.117026836057564e+03,		1.117375245380807e+03,		1.117722943517161e+03,		1.118069933759218e+03,
		1.118416219375974e+03,		1.118761803613060e+03,		1.119106689692971e+03,		1.119450880815286e+03,		1.119794380156889e+03,
		1.120137190872188e+03,		1.120479316093328e+03,		1.120820758930412e+03,		1.121161522471697e+03,		1.121501609783815e+03,
		1.121841023911974e+03,		1.122179767880155e+03,		1.122517844691321e+03,		1.122855257327610e+03,		1.123192008750530e+03,
		1.123528101901158e+03,		1.123863539700322e+03,		1.124198325048799e+03,		1.124532460827493e+03,		1.124865949897627e+03,
		1.125198795100919e+03,		1.125530999259768e+03,		1.125862565177423e+03,		1.126193495638169e+03,		1.126523793407495e+03,
		1.126853461232267e+03,		1.127182501840896e+03,		1.127510917943512e+03,		1.127838712232122e+03,		1.128165887380777e+03,
		1.128492446045738e+03,		1.128818390865632e+03,		1.129143724461610e+03,		1.129468449437508e+03,		1.129792568379997e+03,
		1.130116083858739e+03,		1.130438998426539e+03,		1.130761314619492e+03,		1.131083034957134e+03,		1.131404161942586e+03,
		1.131724698062699e+03,		1.132044645788202e+03,		1.132364007573835e+03,		1.132682785858496e+03,		1.133000983065375e+03,
		1.133318601602096e+03,		1.133635643860848e+03,		1.133952112218518e+03,		1.134268009036828e+03,		1.134583336662465e+03,
		1.134898097427206e+03,		1.135212293648052e+03,		1.135525927627351e+03,		1.135839001652925e+03,		1.136151517998195e+03,
		1.136463478922300e+03,		1.136774886670225e+03,		1.137085743472912e+03,		1.137396051547386e+03,		1.137705813096872e+03,
		1.138015030310907e+03,		1.138323705365459e+03,		1.138631840423041e+03,		1.138939437632818e+03,		1.139246499130724e+03,
		1.139553027039577e+03,		1.139859023469172e+03,		1.140164490516404e+03,		1.140469430265373e+03,		1.140773844787481e+03,
		1.141077736141543e+03,		1.141381106373891e+03,		1.141683957518476e+03,		1.141986291596966e+03,		1.142288110618849e+03,
		1.142589416581534e+03,		1.142890211470446e+03,		1.143190497259124e+03,		1.143490275909320e+03,		1.143789549371091e+03,
		1.144088319582893e+03,		1.144386588471678e+03,		1.144684357952985e+03,		1.144981629931028e+03,		1.145278406298790e+03,
		1.145574688938114e+03,		1.145870479719789e+03,		1.146165780503635e+03,		1.146460593138601e+03,		1.146754919462835e+03,
		1.147048761303785e+03,		1.147342120478270e+03,		1.147634998792576e+03,		1.147927398042528e+03,		1.148219320013578e+03,
		1.148510766480883e+03,		1.148801739209389e+03,		1.149092239953909e+03,		1.149382270459197e+03,		1.149671832460034e+03,
		1.149960927681297e+03,		1.150249557838044e+03,		1.150537724635581e+03,		1.150825429769547e+03,		1.151112674925974e+03
	},
	{
		1.833617204543279e+00,		5.566237230991091e+00,		9.385258313636895e+00,		1.329602226240679e+01,		1.730442573376380e+01,
		2.141700262037805e+01,		2.564102275334636e+01,		2.998461103857220e+01,		3.445689243789433e+01,		3.906816998294282e+01,
		4.383014549632434e+01,		4.875619622923769e+01,		5.386172573704152e+01,		5.916461485322330e+01,		6.468580998058599e+01,
		7.045010344745010e+01,		7.648718847117854e+01,		8.283311672080451e+01,		8.953236346107984e+01,		9.664084113727502e+01,
		1.042304539071572e+02,		1.123962793402533e+02,		1.212685027675300e+02,		1.310336192889261e+02,		1.419755810607531e+02,
		1.545661717366056e+02,		1.697049415325939e+02,		8.064521939325743e+02,		8.113965559758803e+02,		8.160015400024525e+02,
		8.203192808919229e+02,		8.243900824726992e+02,		8.282458621097984e+02,		8.319123970125015e+02,		8.354108491735124e+02,
		8.387588349689457e+02,		8.419711960109614e+02,		8.450605675861602e+02,		8.480378061676528e+02,		8.509123164929431e+02,
		8.536923055985507e+02,		8.563849827771651e+02,		8.589967188612214e+02,		8.615331744794402e+02,		8.639994043422905e+02,
		8.663999427932512e+02,		8.687388745643542e+02,		8.710198937338166e+02,		8.732463531952361e+02,		8.754213064207064e+02,
		8.775475429483454e+02,		8.796276186817845e+02,		8.816638819077403e+02,		8.836584957399821e+02,		8.856134575689832e+02,
		8.875306159885513e+02,		8.894116855857875e+02,		8.912582599129912e+02,		8.930718229056706e+02,		8.948537589667914e+02,
		8.966053619016242e+02,		8.983278428583041e+02,		9.000223374051376e+02,		9.016899118576890e+02,		9.033315689414344e+02,
		9.049482528902672e+02,		9.065408540277192e+02,		9.081102129065628e+02,		9.096571240489313e+02,		9.111823393449014e+02,
		9.126865711279788e+02,		9.141704949820223e+02,		9.156347522969501e+02,		9.170799526033737e+02,		9.185066757084421e+02,
		9.199154736530641e+02,		9.213068725082695e+02,		9.226813740264830e+02,		9.240394571616492e+02,		9.253815794706444e+02,
		9.267081784070122e+02,		9.280196725168828e+02,		9.293164625459237e+02,		9.305989324651670e+02,		9.318674504247697e+02,
		9.331223696321973e+02,		9.343640291822819e+02,		9.355927548183707e+02,		9.368088596469180e+02,		9.380126448032595e+02,
		9.392044000734089e+02,		9.403844044753349e+02,		9.415529268028807e+02,		9.427102261352094e+02,		9.438565523143675e+02,
		9.449921463933757e+02,		9.461172410570059e+02,		9.472320610172533e+02,		9.483368233853092e+02,		9.494317380217186e+02,
		9.505170078662585e+02,		9.515928292489253e+02,		9.526593921833415e+02,		9.537168806437725e+02,		9.547654728268373e+02,
		9.558053414006245e+02,		9.568366537333037e+02,		9.578595721218321e+02,		9.588742539977161e+02,		9.598808521269298e+02,
		9.608795147986471e+02,		9.618703860052847e+02,		9.628536056078517e+02,		9.638293095069629e+02,		9.647976297870015e+02,
		9.657586948669357e+02,		9.667126296383950e+02,		9.676595555980502e+02,		9.685995909737114e+02,		9.695328508445184e+02,
		9.704594472555485e+02,		9.713794893271498e+02,		9.722930833593052e+02,		9.732003329312845e+02,		9.741013389968512e+02,
		9.749961999752522e+02,		9.758850118382284e+02,		9.767678681932390e+02,		9.776448603631090e+02,		9.785160774622863e+02,
		9.793816064698627e+02,		9.802415323014170e+02,		9.810959378698840e+02,		9.819449041579909e+02,		9.827885102751518e+02,
		9.836268335177615e+02,		9.844599494260434e+02,		9.852879318386357e+02,		9.861108529450256e+02,		9.869287833359452e+02,
		9.877417920518122e+02,		9.885499466293152e+02,		9.893533131462243e+02,		9.901519562645065e+02,		9.909459392718378e+02,
		9.917353241215633e+02,		9.925201714711833e+02,		9.933005407194483e+02,		9.940764900420888e+02,		9.948480764262748e+02,
		9.956153557038317e+02,		9.963783825832949e+02,		9.971372106808194e+02,		9.978918925500196e+02,		9.986424797107788e+02,
		9.993890226770499e+02,		1.000131570985230e+03,		1.000870173215010e+03,		1.001604877021205e+03,		1.002335729153965e+03,
		1.003062775483141e+03,		1.003786061020955e+03,		1.004505629943933e+03,		1.005221525614128e+03,		1.005933790599652e+03,
		1.006642466694560e+03,		1.007347594939784e+03,		1.008049215635712e+03,		1.008747368368558e+03,		1.009442092022740e+03,
		1.010133424799033e+03,		1.010821404230997e+03,		1.011506067200916e+03,		1.012187449955242e+03,		1.012865588119593e+03,
		1.013540516713282e+03,		1.014212270163421e+03,		1.014880882318623e+03,		1.015546386462276e+03,		1.016208815325454e+03,
		1.016868201099440e+03,		1.017524575447894e+03,		1.018177969518670e+03,		1.018828413955303e+03,		1.019475938908162e+03,
		1.020120574045301e+03,		1.020762348562996e+03,		1.021401291196002e+03,		1.022037430227512e+03,		1.022670793498861e+03,
		1.023301408418949e+03,		1.023929301973420e+03,		1.024554500733587e+03,		1.025177030865125e+03,		1.025796918136523e+03,
		1.026414187927326e+03,		1.027028865236144e+03,		1.027640974688467e+03,		1.028250540544262e+03,		1.028857586705391e+03,
		1.029462136722817e+03,		1.030064213803656e+03,		1.030663840817989e+03,		1.031261040305600e+03,		1.031855834482447e+03,
		1.032448245247027e+03,		1.033038294186570e+03,		1.033626002583067e+03,		1.034211391419170e+03,		1.034794481383933e+03,
		1.035375292878416e+03,		1.035953846021158e+03,		1.036530160653520e+03,		1.037104256344886e+03,		1.037676152397749e+03,
		1.038245867852689e+03,		1.038813421493204e+03,		1.039378831850457e+03,		1.039942117207896e+03,		1.040503295605766e+03,
		1.041062384845526e+03,		1.041619402494159e+03,		1.042174365888379e+03,		1.042727292138751e+03,		1.043278198133711e+03,
		1.043827100543501e+03,		1.044374015824005e+03,		1.044918960220515e+03,		1.045461949771399e+03,		1.046003000311696e+03,
		1.046542127476629e+03,		1.047079346705040e+03,		1.047614673242756e+03,		1.048148122145871e+03,		1.048679708283970e+03,
		1.049209446343271e+03,		1.049737350829714e+03,		1.050263436071967e+03,		1.050787716224384e+03,		1.051310205269890e+03,
		1.051830917022815e+03,		1.052349865131654e+03,		1.052867063081788e+03,		1.053382524198133e+03,		1.053896261647744e+03,
		1.054408288442356e+03,		1.054918617440892e+03,		1.055427261351889e+03,		1.055934232735908e+03,		1.056439544007874e+03,
		1.056943207439372e+03,		1.057445235160905e+03,		1.057945639164105e+03,		1.058444431303886e+03,		1.058941623300576e+03,
		1.059437226741995e+03,		1.059931253085490e+03,		1.060423713659938e+03,		1.060914619667705e+03,		1.061403982186569e+03,
		1.061891812171608e+03,		1.062378120457044e+03,		1.062862917758063e+03,		1.063346214672589e+03,		1.063828021683034e+03,
		1.064308349158011e+03,		1.064787207354012e+03,		1.065264606417058e+03,		1.065740556384320e+03,		1.066215067185704e+03,
		1.066688148645414e+03,		1.067159810483477e+03,		1.067630062317254e+03,		1.068098913662904e+03,		1.068566373936841e+03,
		1.069032452457151e+03,		1.069497158444991e+03,		1.069960501025957e+03,		1.070422489231432e+03,		1.070883131999912e+03,
		1.071342438178297e+03,		1.071800416523175e+03,		1.072257075702069e+03,		1.072712424294672e+03,		1.073166470794056e+03,
		1.073619223607862e+03,		1.074070691059467e+03,		1.074520881389127e+03,		1.074969802755117e+03,		1.075417463234825e+03,
		1.075863870825854e+03,		1.076309033447086e+03,		1.076752958939735e+03,		1.077195655068388e+03,		1.077637129522016e+03,
		1.078077389914976e+03,		1.078516443787997e+03,		1.078954298609146e+03,		1.079390961774778e+03,		1.079826440610475e+03,
		1.080260742371960e+03,		1.080693874246008e+03,		1.081125843351331e+03,		1.081556656739458e+03,		1.081986321395593e+03,
		1.082414844239463e+03,		1.082842232126154e+03,		1.083268491846926e+03,		1.083693630130023e+03,		1.084117653641470e+03,
		1.084540568985846e+03,		1.084962382707065e+03,		1.085383101289119e+03,		1.085802731156835e+03,		1.086221278676600e+03,
		1.086638750157087e+03,		1.087055151849962e+03,		1.087470489950589e+03,		1.087884770598709e+03,		1.088297999879128e+03,
		1.088710183822377e+03,		1.089121328405372e+03,		1.089531439552063e+03,		1.089940523134065e+03,		1.090348584971292e+03,
		1.090755630832571e+03,		1.091161666436253e+03,		1.091566697450809e+03,		1.091970729495424e+03,		1.092373768140576e+03,
		1.092775818908612e+03,		1.093176887274307e+03,		1.093576978665426e+03,		1.093976098463269e+03,		1.094374252003208e+03,
		1.094771444575225e+03,		1.095167681424429e+03,		1.095562967751578e+03,		1.095957308713584e+03,		1.096350709424018e+03,
		1.096743174953601e+03,		1.097134710330691e+03,		1.097525320541767e+03,		1.097915010531896e+03,		1.098303785205206e+03,
		1.098691649425340e+03,		1.099078608015915e+03,		1.099464665760961e+03,		1.099849827405372e+03,		1.100234097655328e+03,
		1.100617481178736e+03,		1.100999982605640e+03,		1.101381606528648e+03,		1.101762357503336e+03,		1.102142240048654e+03,
		1.102521258647327e+03,		1.102899417746246e+03,		1.103276721756862e+03,		1.103653175055560e+03,		1.104028781984048e+03,
		1.104403546849715e+03,		1.104777473926016e+03,		1.105150567452820e+03,		1.105522831636776e+03,		1.105894270651663e+03,
		1.106264888638739e+03,		1.106634689707082e+03,		1.107003677933933e+03,		1.107371857365027e+03,		1.107739232014926e+03,
		1.108105805867342e+03,		1.108471582875460e+03,		1.108836566962253e+03,		1.109200762020795e+03,		1.109564171914575e+03,
		1.109926800477796e+03,		1.110288651515677e+03,		1.110649728804750e+03,		1.111010036093155e+03,		1.111369577100928e+03,
		1.111728355518758e+03,		1.112086375014472e+03,		1.112443639223866e+03,		1.112800151757381e+03,		1.113155916198743e+03,
		1.113510936105233e+03,		1.113865215007952e+03,		1.114218756412083e+03,		1.114571563797147e+03,		1.114923640617258e+03,
		1.115274990301374e+03,		1.115625616253547e+03,		1.115975521853165e+03,		1.116324710455198e+03,		1.116673185390433e+03,
		1.117020949965712e+03,		1.117368007464167e+03,		1.117714361145448e+03,		1.118060014245951e+03,		1.118404969979039e+03,
		1.118749231535276e+03,		1.119092802082628e+03,		1.119435684766697e+03,		1.119777882710925e+03,		1.120119399016809e+03,
		1.120460236764104e+03,		1.120800399011043e+03,		1.121139888794524e+03,		1.121478709130322e+03,		1.121816863013288e+03,
		1.122154353417539e+03,		1.122491183296660e+03,		1.122827355583889e+03,		1.123162873192313e+03,		1.123497739015052e+03,
		1.123831955925445e+03,		1.124165526777232e+03,		1.124498454404737e+03,		1.124830741623049e+03,		1.125162391228189e+03,
		1.125493405997299e+03,		1.125823788688803e+03,		1.126153542042584e+03,		1.126482668780149e+03,		1.126811171604800e+03,
		1.127139053201797e+03,		1.127466316238515e+03,		1.127792963364621e+03,		1.128118997212212e+03,		1.128444420395993e+03,
		1.128769235513417e+03,		1.129093445144851e+03,		1.129417051853718e+03,		1.129740058186655e+03,		1.130062466673659e+03,
		1.130384279828231e+03,		1.130705500147531e+03,		1.131026130112510e+03,		1.131346172188060e+03,		1.131665628823155e+03,
		1.131984502450986e+03,		1.132302795489100e+03,		1.132620510339540e+03,		1.132937649388971e+03,		1.133254215008824e+03,
		1.133570209555420e+03,		1.133885635370103e+03,		1.134200494779368e+03,		1.134514790094988e+03,		1.134828523614145e+03,
		1.135141697619545e+03,		1.135454314379552e+03,		1.135766376148302e+03,		1.136077885165828e+03,		1.136388843658179e+03,
		1.136699253837534e+03,		1.137009117902329e+03,		1.137318438037358e+03,		1.137627216413901e+03,		1.137935455189831e+03,
		1.138243156509724e+03,		1.138550322504974e+03,		1.138856955293903e+03,		1.139163056981862e+03,		1.139468629661352e+03,
		1.139773675412117e+03,		1.140078196301254e+03,		1.140382194383322e+03,		1.140685671700435e+03,		1.140988630282375e+03,
		1.141291072146682e+03,		1.141592999298763e+03,		1.141894413731984e+03,		1.142195317427775e+03,		1.142495712355716e+03,
		1.142795600473645e+03,		1.143094983727745e+03,		1.143393864052638e+03,		1.143692243371484e+03,		1.143990123596064e+03,
		1.144287506626879e+03,		1.144584394353235e+03,		1.144880788653336e+03,		1.145176691394368e+03,		1.145472104432589e+03,
		1.145767029613418e+03,		1.146061468771516e+03,		1.146355423730872e+03,		1.146648896304888e+03,		1.146941888296462e+03,
		1.147234401498072e+03,		1.147526437691853e+03,		1.147817998649682e+03,		1.148109086133255e+03,		1.148399701894167e+03,
		1.148689847673995e+03,		1.148979525204366e+03,		1.149268736207041e+03,		1.149557482393990e+03,		1.149845765467466e+03
	},
	{
		1.829747115405912e+00,		5.554053129233216e+00,		9.363932689462631e+00,		1.326462895205399e+01,		1.726192424687951e+01,
		2.136221926566034e+01,		2.557262774448998e+01,		2.990109050706446e+01,		3.435651392784748e+01,		3.894893951326986e+01,
		4.368975358225205e+01,		4.859194925766757e+01,		5.367045762896384e+01,		5.894257176224833e+01,		6.442849743844025e+01,
		7.015208013592256e+01,		7.614178236691014e+01,		8.243202532036723e+01,		8.906507554125589e+01,		9.609377376475169e+01,
		1.035856154097525e+02,		1.116291015367504e+02,		1.203441218279049e+02,		1.299000151286781e+02,		1.405496340474144e+02,
		1.527011476670729e+02,		1.670964928844908e+02,		7.988475496230508e+02,		8.042138907071989e+02,		8.091741515876356e+02,
		8.137965257218951e+02,		8.181323741007986e+02,		8.222215326106215e+02,		8.260956290668653e+02,		8.297802597610562e+02,
		8.332964741471874e+02,		8.366618201937747e+02,		8.398911001111572e+02,		8.429969290834252e+02,		8.459901564057878e+02,
		8.488801882967933e+02,		8.516752390355222e+02,		8.543825289277089e+02,		8.570084422094825e+02,		8.595586543424149e+02,
		8.620382356274879e+02,		8.644517362890922e+02,		8.668032569032879e+02,		8.690965071359916e+02,		8.713348550586747e+02,
		8.735213688211347e+02,		8.756588520716001e+02,		8.777498742277647e+02,		8.797967964798808e+02,		8.818017942347300e+02,
		8.837668765747851e+02,		8.856939032008027e+02,		8.875845992420809e+02,		8.894405682513116e+02,		8.912633036470796e+02,
		8.930541988243605e+02,		8.948145561114964e+02,		8.965455947395286e+02,		8.982484579416388e+02,		8.999242193028343e+02,
		9.015738884481200e+02,		9.031984161603399e+02,		9.047986989808978e+02,		9.063755833694654e+02,		9.079298694646982e+02,
		9.094623144940131e+02,		9.109736358710231e+02,		9.124645140145948e+02,		9.139355949192769e+02,		9.153874925032167e+02,
		9.168207907564396e+02,		9.182360457097102e+02,		9.196337872418048e+02,		9.210145207409911e+02,		9.223787286347098e+02,
		9.237268718019061e+02,		9.250593908690553e+02,		9.263767074216743e+02,		9.276792251142112e+02,		9.289673307038204e+02,
		9.302413950087268e+02,		9.315017737985659e+02,		9.327488086224585e+02,		9.339828275800260e+02,		9.352041460400301e+02,
		9.364130673109073e+02,		9.376098832670273e+02,		9.387948749341613e+02,		9.399683130373779e+02,		9.411304585141930e+02,
		9.422815629956551e+02,		9.434218692577296e+02,		9.445516116452002e+02,		9.456710164700556e+02,		9.467803023876633e+02,
		9.478796807450224e+02,		9.489693559188992e+02,		9.500495256257952e+02,		9.511203812183343e+02,		9.521821079643826e+02,
		9.532348853107618e+02,		9.542788871325852e+02,		9.553142819691394e+02,		9.563412332471917e+02,		9.573598994925316e+02,
		9.583704345304803e+02,		9.593729876760614e+02,		9.603677039144848e+02,		9.613547240725078e+02,		9.623341849812666e+02,
		9.633062196310429e+02,		9.642709573184919e+02,		9.652285237867301e+02,		9.661790413587290e+02,		9.671226290643832e+02,
		9.680594027616163e+02,		9.689894752518609e+02,		9.699129563902178e+02,		9.708299531924473e+02,		9.717405699294075e+02,
		9.726449082306975e+02,		9.735430671718281e+02,		9.744351433629018e+02,		9.753212310324876e+02,		9.762014221078832e+02,
		9.770758062919559e+02,		9.779444711367458e+02,		9.788075021139750e+02,		9.796649826826490e+02,		9.805169943538704e+02,
		9.813636167530112e+02,		9.822049276793781e+02,		9.830410031634874e+02,		9.838719175220637e+02,		9.846977434108779e+02,
		9.855185518755231e+02,		9.863344124002133e+02,		9.871453929547245e+02,		9.879515600395374e+02,		9.887529787298625e+02,
		9.895497127155381e+02,		9.903418243437803e+02,		9.911293746565005e+02,		9.919124234279922e+02,		9.926910292009411e+02,
		9.934652493211363e+02,		9.942351399709389e+02,		9.950007562015669e+02,		9.957621519642430e+02,		9.965193801402593e+02,
		9.972724925715478e+02,		9.980215400831895e+02,		9.987665725179708e+02,		9.995076387579650e+02,		1.000244786750851e+03,
		1.000978063534347e+03,		1.001707515259827e+03,		1.002433187215161e+03,		1.003155123846811e+03,		1.003873368781204e+03,
		1.004587964845427e+03,		1.005298954087246e+03,		1.006006377794505e+03,		1.006710276513895e+03,		1.007410690069156e+03,
		1.008107657578687e+03,		1.008801217472636e+03,		1.009491407509450e+03,		1.010178264791922e+03,		1.010861825782759e+03,
		1.011542126319672e+03,		1.012219201630022e+03,		1.012893086345022e+03,		1.013563814513536e+03,		1.014231419615447e+03,
		1.014895934574664e+03,		1.015557391771734e+03,		1.016215823056091e+03,		1.016871259757966e+03,		1.017523732699949e+03,
		1.018173272208226e+03,		1.018819908123503e+03,		1.019463669811617e+03,		1.020104586173871e+03,		1.020742685657059e+03,
		1.021377996263238e+03,		1.022010545559221e+03,		1.022640360685815e+03,		1.023267468366813e+03,		1.023891894917748e+03,
		1.024513666254403e+03,		1.025132807901118e+03,		1.025749344998815e+03,		1.026363302312935e+03,		1.026974704241042e+03,
		1.027583574820298e+03,		1.028189937734728e+03,		1.028793816322306e+03,		1.029395233581852e+03,		1.029994212179761e+03,
		1.030590774456560e+03,		1.031184942433299e+03,		1.031776737817793e+03,		1.032366182010691e+03,		1.032953296111416e+03,
		1.033538100923944e+03,		1.034120616962450e+03,		1.034700864456817e+03,		1.035278863358006e+03,		1.035854633343308e+03,
		1.036428193821457e+03,		1.036999563937638e+03,		1.037568762578356e+03,		1.038135808376215e+03,		1.038700719714565e+03,
		1.039263514732050e+03,		1.039824211327051e+03,		1.040382827162025e+03,		1.040939379667741e+03,		1.041493886047430e+03,
		1.042046363280830e+03,		1.042596828128139e+03,		1.043145297133897e+03,		1.043691786630755e+03,		1.044236312743182e+03,
		1.044778891391076e+03,		1.045319538293306e+03,		1.045858268971167e+03,		1.046395098751763e+03,		1.046930042771325e+03,
		1.047463115978439e+03,		1.047994333137223e+03,		1.048523708830425e+03,		1.049051257462459e+03,		1.049576993262374e+03,
		1.050100930286766e+03,		1.050623082422618e+03,		1.051143463390095e+03,		1.051662086745268e+03,		1.052178965882788e+03,
		1.052694114038503e+03,		1.053207544292025e+03,		1.053719269569232e+03,		1.054229302644741e+03,		1.054737656144307e+03,
		1.055244342547190e+03,		1.055749374188468e+03,		1.056252763261302e+03,		1.056754521819161e+03,		1.057254661778004e+03,
		1.057753194918406e+03,		1.058250132887657e+03,		1.058745487201816e+03,		1.059239269247716e+03,		1.059731490284950e+03,
		1.060222161447788e+03,		1.060711293747089e+03,		1.061198898072158e+03,		1.061684985192569e+03,		1.062169565759959e+03,
		1.062652650309782e+03,		1.063134249263038e+03,		1.063614372927957e+03,		1.064093031501667e+03,		1.064570235071814e+03,
		1.065045993618167e+03,		1.065520317014186e+03,		1.065993215028560e+03,		1.066464697326720e+03,		1.066934773472321e+03,
		1.067403452928704e+03,		1.067870745060323e+03,		1.068336659134148e+03,		1.068801204321049e+03,		1.069264389697151e+03,
		1.069726224245160e+03,		1.070186716855674e+03,		1.070645876328465e+03,		1.071103711373739e+03,		1.071560230613380e+03,
		1.072015442582162e+03,		1.072469355728948e+03,		1.072921978417863e+03,		1.073373318929450e+03,		1.073823385461808e+03,
		1.074272186131700e+03,		1.074719728975658e+03,		1.075166021951055e+03,		1.075611072937166e+03,		1.076054889736208e+03,
		1.076497480074367e+03,		1.076938851602801e+03,		1.077379011898633e+03,		1.077817968465919e+03,		1.078255728736612e+03,
		1.078692300071499e+03,		1.079127689761126e+03,		1.079561905026709e+03,		1.079994953021029e+03,		1.080426840829318e+03,
		1.080857575470115e+03,		1.081287163896128e+03,		1.081715612995069e+03,		1.082142929590476e+03,		1.082569120442530e+03,
		1.082994192248851e+03,		1.083418151645285e+03,		1.083841005206675e+03,		1.084262759447626e+03,		1.084683420823253e+03,
		1.085102995729917e+03,		1.085521490505951e+03,		1.085938911432379e+03,		1.086355264733613e+03,		1.086770556578147e+03,
		1.087184793079245e+03,		1.087597980295604e+03,		1.088010124232020e+03,		1.088421230840036e+03,		1.088831306018586e+03,
		1.089240355614620e+03,		1.089648385423736e+03,		1.090055401190783e+03,		1.090461408610463e+03,		1.090866413327938e+03,
		1.091270420939397e+03,		1.091673436992644e+03,		1.092075466987664e+03,		1.092476516377179e+03,		1.092876590567201e+03,
		1.093275694917575e+03,		1.093673834742513e+03,		1.094071015311122e+03,		1.094467241847922e+03,		1.094862519533360e+03,
		1.095256853504310e+03,		1.095650248854577e+03,		1.096042710635377e+03,		1.096434243855834e+03,		1.096824853483438e+03,
		1.097214544444529e+03,		1.097603321624753e+03,		1.097991189869521e+03,		1.098378153984451e+03,		1.098764218735820e+03,
		1.099149388850998e+03,		1.099533669018873e+03,		1.099917063890286e+03,		1.100299578078439e+03,		1.100681216159316e+03,
		1.101061982672087e+03,		1.101441882119509e+03,		1.101820918968322e+03,		1.102199097649643e+03,		1.102576422559344e+03,
		1.102952898058440e+03,		1.103328528473459e+03,		1.103703318096813e+03,		1.104077271187161e+03,		1.104450391969773e+03,
		1.104822684636880e+03,		1.105194153348028e+03,		1.105564802230419e+03,		1.105934635379257e+03,		1.106303656858079e+03,
		1.106671870699094e+03,		1.107039280903502e+03,		1.107405891440371e+03,		1.107771706252850e+03,		1.108136729249502e+03,
		1.108500964310696e+03,		1.108864415287371e+03,		1.109227086001338e+03,		1.109588980245576e+03,		1.109950101784531e+03,
		1.110310454354401e+03,		1.110670041663428e+03,		1.111028867392181e+03,		1.111386935193832e+03,		1.111744248694436e+03,
		1.112100811493205e+03,		1.112456627162771e+03,		1.112811699249459e+03,		1.113166031273545e+03,		1.113519626729515e+03,
		1.113872489086325e+03,		1.114224621787649e+03,		1.114576028252134e+03,		1.114926711873636e+03,		1.115276676021481e+03,
		1.115625924040683e+03,		1.115974459252204e+03,		1.116322284953171e+03,		1.116669404417117e+03,		1.117015820894204e+03,
		1.117361537611458e+03,		1.117706557772979e+03,		1.118050884560173e+03,		1.118394521131965e+03,		1.118737470625013e+03,
		1.119079736153922e+03,		1.119421320811457e+03,		1.119762227668742e+03,		1.120102459775477e+03,		1.120442020160128e+03,
		1.120780911830137e+03,		1.121119137772114e+03,		1.121456700952034e+03,		1.121793604315432e+03,		1.122129850787589e+03,
		1.122465443273726e+03,		1.122800384659186e+03,		1.123134677809619e+03,		1.123468325571170e+03,		1.123801330770649e+03,
		1.124133696215713e+03,		1.124465424695045e+03,		1.124796518978523e+03,		1.125126981817396e+03,		1.125456815944446e+03,
		1.125786024074166e+03,		1.126114608902917e+03,		1.126442573109099e+03,		1.126769919353307e+03,		1.127096650278493e+03,
		1.127422768510128e+03,		1.127748276656355e+03,		1.128073177308141e+03,		1.128397473039438e+03,		1.128721166407328e+03,
		1.129044259952173e+03,		1.129366756197768e+03,		1.129688657651480e+03,		1.130009966804400e+03,		1.130330686131479e+03,
		1.130650818091675e+03,		1.130970365128090e+03,		1.131289329668111e+03,		1.131607714123543e+03,		1.131925520890748e+03,
		1.132242752350776e+03,		1.132559410869499e+03,		1.132875498797742e+03,		1.133191018471413e+03,		1.133505972211628e+03,
		1.133820362324843e+03,		1.134134191102973e+03,		1.134447460823522e+03,		1.134760173749702e+03,		1.135072332130555e+03,
		1.135383938201075e+03,		1.135694994182323e+03,		1.136005502281548e+03,		1.136315464692302e+03,		1.136624883594555e+03,
		1.136933761154809e+03,		1.137242099526208e+03,		1.137549900848655e+03,		1.137857167248917e+03,		1.138163900840738e+03,
		1.138470103724942e+03,		1.138775777989544e+03,		1.139080925709858e+03,		1.139385548948592e+03,		1.139689649755963e+03,
		1.139993230169789e+03,		1.140296292215601e+03,		1.140598837906732e+03,		1.140900869244427e+03,		1.141202388217934e+03,
		1.141503396804602e+03,		1.141803896969982e+03,		1.142103890667916e+03,		1.142403379840637e+03,		1.142702366418859e+03,
		1.143000852321870e+03,		1.143298839457622e+03,		1.143596329722826e+03,		1.143893325003038e+03,		1.144189827172748e+03,
		1.144485838095468e+03,		1.144781359623821e+03,		1.145076393599623e+03,		1.145370941853974e+03,		1.145665006207337e+03,
		1.145958588469623e+03,		1.146251690440277e+03,		1.146544313908355e+03,		1.146836460652608e+03,		1.147128132441562e+03,
		1.147419331033599e+03,		1.147710058177030e+03,		1.148000315610179e+03,		1.148290105061459e+03,		1.148579428249446e+03
	},
	{
		1.825893644711166e+00,		5.541925326611890e+00,		9.342713010886222e+00,		1.323340323666283e+01,		1.721966652274484e+01,
		2.130777348520235e+01,		2.550468567435647e+01,		2.981816475818258e+01,		3.425690478374855e+01,		3.883069375983652e+01,
		4.355061290096142e+01,		4.842928482650083e+01,		5.348118623756361e+01,		5.872304676046470e+01,		6.417436481986066e+01,
		6.985808536426246e+01,		7.580150605051554e+01,		8.203751347064309e+01,		8.860630902098350e+01,		9.555788392189733e+01,
		1.029556826330652e+02,		1.108822344258528e+02,		1.194482194765487e+02,		1.288079308052279e+02,		1.391876819116044e+02,
		1.509435112544905e+02,		1.646966468300422e+02,		7.907613452920201e+02,		7.966328739248260e+02,		8.020097824749091e+02,
		8.069837233663553e+02,		8.116215304880742e+02,		8.159737558480122e+02,		8.200797348053183e+02,		8.239707773894478e+02,
		8.276722751289835e+02,		8.312051449867959e+02,		8.345868498588542e+02,		8.378321386105029e+02,		8.409535946167194e+02,
		8.439620501233857e+02,		8.468669044669026e+02,		8.496763720492395e+02,		8.523976780990171e+02,		8.550372150219589e+02,
		8.576006685947472e+02,		8.600931207899673e+02,		8.625191342999668e+02,		8.648828225639533e+02,		8.671879082169681e+02,
		8.694377722045739e+02,		8.716354953137642e+02,		8.737838934962878e+02,		8.758855480757209e+02,		8.779428317106133e+02,
		8.799579308161211e+02,		8.819328650136081e+02,		8.838695040729384e+02,		8.857695827303605e+02,		8.876347136906003e+02,
		8.894663990880775e+02,		8.912660406100350e+02,		8.930349484754753e+02,		8.947743494148841e+02,		8.964853937979974e+02,
		8.981691619929901e+02,		8.998266700787506e+02,		9.014588749746945e+02,		9.030666790628841e+02,		9.046509343615130e+02,
		9.062124463014229e+02,		9.077519771505132e+02,		9.092702491250041e+02,		9.107679472216328e+02,		9.122457218004478e+02,
		9.137041909443898e+02,		9.151439426203791e+02,		9.165655366531556e+02,		9.179695065490317e+02,		9.193563611627603e+02,
		9.207265862367337e+02,		9.220806458194936e+02,		9.234189835755236e+02,		9.247420239962563e+02,		9.260501735211633e+02,
		9.273438215768967e+02,		9.286233415416325e+02,		9.298890916410281e+02,		9.311414157815857e+02,		9.323806443266358e+02,
		9.336070948196735e+02,		9.348210726592813e+02,		9.360228717295320e+02,		9.372127749893598e+02,		9.383910550260606e+02,
		9.395579745658559e+02,		9.407137869659308e+02,		9.418587366644986e+02,		9.429930596086085e+02,		9.441169836553310e+02,
		9.452307289491303e+02,		9.463345082771285e+02,		9.474285274037985e+02,		9.485129853865176e+02,		9.495880748733005e+02,
		9.506539823839057e+02,		9.517108885754346e+02,		9.527589684934449e+02,		9.537983918095273e+02,		9.548293230462224e+02,
		9.558519217900767e+02,		9.568663428935974e+02,		9.578727366668097e+02,		9.588712490590094e+02,		9.598620218313760e+02,
		9.608451927223512e+02,		9.618208955991305e+02,		9.627892606115574e+02,		9.637504143299802e+02,		9.647044798803367e+02,
		9.656515770721621e+02,		9.665918225205743e+02,		9.675253297626155e+02,		9.684522093682227e+02,		9.693725690461717e+02,
		9.702865137452166e+02,		9.711941457507352e+02,		9.720955647770903e+02,		9.729908680559417e+02,		9.738801504207275e+02,
		9.747635043875155e+02,		9.756410202323975e+02,		9.765127860656253e+02,		9.773788879028726e+02,		9.782394097325871e+02,
		9.790944335822051e+02,		9.799440395802403e+02,		9.807883060165029e+02,		9.816273093997831e+02,		9.824611245132586e+02,
		9.832898244677070e+02,		9.841134807526480e+02,		9.849321632855064e+02,		9.857459404588807e+02,		9.865548791860161e+02,
		9.873590449462891e+02,		9.881585018212833e+02,		9.889533125434716e+02,		9.897435385303430e+02,		9.905292399231768e+02,
		9.913104756232964e+02,		9.920873033270361e+02,		9.928597795594521e+02,		9.936279597068376e+02,		9.943918980480991e+02,
		9.951516477850282e+02,		9.959072610715398e+02,		9.966587890418845e+02,		9.974062818379116e+02,		9.981497886354159e+02,
		9.988893576695716e+02,		9.996250362595443e+02,		1.000356870832272e+03,		1.001084906945468e+03,		1.001809189309871e+03,
		1.002529761810771e+03,		1.003246667528847e+03,		1.003959948760332e+03,		1.004669647036540e+03,		1.005375803142778e+03,
		1.006078457136662e+03,		1.006777648365861e+03,		1.007473415485302e+03,		1.008165796473836e+03,		1.008854828650395e+03,
		1.009540548689667e+03,		1.010222992637305e+03,		1.010902195924647e+03,		1.011578193383047e+03,		1.012251019257744e+03,
		1.012920707221343e+03,		1.013587290386894e+03,		1.014250801320602e+03,		1.014911272054158e+03,		1.015568734096730e+03,
		1.016223218446603e+03,		1.016874755602495e+03,		1.017523375574552e+03,		1.018169107895044e+03,		1.018811981628748e+03,
		1.019452025383064e+03,		1.020089267317840e+03,		1.020723735154948e+03,		1.021355456187523e+03,		1.021984457289118e+03,
		1.022610764922434e+03,		1.023234405147923e+03,		1.023855403632132e+03,		1.024473785655827e+03,		1.025089576121915e+03,
		1.025702799563145e+03,		1.026313480149624e+03,		1.026921641696131e+03,		1.027527307669243e+03,		1.028130501194290e+03,
		1.028731245062118e+03,		1.029329561735696e+03,		1.029925473356551e+03,		1.030519001751038e+03,		1.031110168436471e+03,
		1.031698994627085e+03,		1.032285501239862e+03,		1.032869708900211e+03,		1.033451637947510e+03,		1.034031308440519e+03,
		1.034608740162665e+03,		1.035183952627181e+03,		1.035756965082153e+03,		1.036327796515428e+03,		1.036896465659409e+03,
		1.037462990995739e+03,		1.038027390759887e+03,		1.038589682945608e+03,		1.039149885309314e+03,		1.039708015374342e+03,
		1.040264090435124e+03,		1.040818127561262e+03,		1.041370143601513e+03,		1.041920155187680e+03,		1.042468178738421e+03,
		1.043014230462973e+03,		1.043558326364784e+03,		1.044100482245084e+03,		1.044640713706359e+03,		1.045179036155755e+03,
		1.045715464808417e+03,		1.046250014690741e+03,		1.046782700643568e+03,		1.047313537325304e+03,		1.047842539214972e+03,
		1.048369720615203e+03,		1.048895095655168e+03,		1.049418678293432e+03,		1.049940482320769e+03,		1.050460521362900e+03,
		1.050978808883192e+03,		1.051495358185283e+03,		1.052010182415667e+03,		1.052523294566220e+03,		1.053034707476672e+03,
		1.053544433837040e+03,		1.054052486189996e+03,		1.054558876933199e+03,		1.055063618321578e+03,		1.055566722469566e+03,
		1.056068201353295e+03,		1.056568066812740e+03,		1.057066330553828e+03,		1.057563004150503e+03,		1.058058099046753e+03,
		1.058551626558590e+03,		1.059043597875999e+03,		1.059534024064849e+03,		1.060022916068766e+03,		1.060510284710968e+03,
		1.060996140696067e+03,		1.061480494611837e+03,		1.061963356930949e+03,		1.062444738012675e+03,		1.062924648104553e+03,
		1.063403097344027e+03,		1.063880095760060e+03,		1.064355653274706e+03,		1.064829779704667e+03,		1.065302484762803e+03,
		1.065773778059638e+03,		1.066243669104818e+03,		1.066712167308549e+03,		1.067179281983019e+03,		1.067645022343777e+03,
		1.068109397511100e+03,		1.068572416511333e+03,		1.069034088278201e+03,		1.069494421654103e+03,		1.069953425391378e+03,
		1.070411108153555e+03,		1.070867478516574e+03,		1.071322544969993e+03,		1.071776315918169e+03,		1.072228799681413e+03,
		1.072680004497146e+03,		1.073129938521010e+03,		1.073578609827972e+03,		1.074026026413411e+03,		1.074472196194185e+03,
		1.074917127009675e+03,		1.075360826622813e+03,		1.075803302721102e+03,		1.076244562917605e+03,		1.076684614751927e+03,
		1.077123465691177e+03,		1.077561123130913e+03,		1.077997594396077e+03,		1.078432886741904e+03,		1.078867007354833e+03,
		1.079299963353381e+03,		1.079731761789024e+03,		1.080162409647050e+03,		1.080591913847401e+03,		1.081020281245508e+03,
		1.081447518633103e+03,		1.081873632739025e+03,		1.082298630230009e+03,		1.082722517711463e+03,		1.083145301728239e+03,
		1.083566988765382e+03,		1.083987585248872e+03,		1.084407097546354e+03,		1.084825531967861e+03,		1.085242894766516e+03,
		1.085659192139230e+03,		1.086074430227390e+03,		1.086488615117533e+03,		1.086901752842010e+03,		1.087313849379639e+03,
		1.087724910656354e+03,		1.088134942545837e+03,		1.088543950870142e+03,		1.088951941400314e+03,		1.089358919856992e+03,
		1.089764891911008e+03,		1.090169863183974e+03,		1.090573839248866e+03,		1.090976825630588e+03,		1.091378827806538e+03,
		1.091779851207164e+03,		1.092179901216507e+03,		1.092578983172738e+03,		1.092977102368692e+03,		1.093374264052389e+03,
		1.093770473427543e+03,		1.094165735654078e+03,		1.094560055848624e+03,		1.094953439085005e+03,		1.095345890394733e+03,
		1.095737414767483e+03,		1.096128017151559e+03,		1.096517702454370e+03,		1.096906475542880e+03,		1.097294341244062e+03,
		1.097681304345345e+03,		1.098067369595052e+03,		1.098452541702835e+03,		1.098836825340097e+03,		1.099220225140419e+03,
		1.099602745699972e+03,		1.099984391577927e+03,		1.100365167296859e+03,		1.100745077343145e+03,		1.101124126167359e+03,
		1.101502318184651e+03,		1.101879657775143e+03,		1.102256149284291e+03,		1.102631797021816e+03,		1.103006605267971e+03,
		1.103380578264893e+03,		1.103753720223075e+03,		1.104126035320157e+03,		1.104497527701277e+03,		1.104868201479415e+03,
		1.105238060735727e+03,		1.105607109519881e+03,		1.105975351850388e+03,		1.106342791714923e+03,		1.106709433070648e+03,
		1.107075279844528e+03,		1.107440335933643e+03,		1.107804605205496e+03,		1.108168091498319e+03,		1.108530798621370e+03,
		1.108892730355232e+03,		1.109253890452102e+03,		1.109614282636086e+03,		1.109973910603477e+03,		1.110332778023039e+03,
		1.110690888536289e+03,		1.111048245757763e+03,		1.111404853275294e+03,		1.111760714650275e+03,		1.112115833417924e+03,
		1.112470213087546e+03,		1.112823857142789e+03,		1.113176769041897e+03,		1.113528952217963e+03,		1.113880410079177e+03,
		1.114231146009069e+03,		1.114581163366749e+03,		1.114930465487150e+03,		1.115279055681262e+03,		1.115626937236363e+03,
		1.115974113416252e+03,		1.116320587461473e+03,		1.116666362589542e+03,		1.117011441995167e+03,		1.117355828850466e+03,
		1.117699526305188e+03,		1.118042537486921e+03,		1.118384865501306e+03,		1.118726513432245e+03,		1.119067484342107e+03,
		1.119407781271933e+03,		1.119747407241633e+03,		1.120086365250190e+03,		1.120424658275853e+03,		1.120762289276331e+03,
		1.121099261188988e+03,		1.121435576931030e+03,		1.121771239399691e+03,		1.122106251472420e+03,		1.122440616007064e+03,
		1.122774335842050e+03,		1.123107413796559e+03,		1.123439852670708e+03,		1.123771655245721e+03,		1.124102824284103e+03,
		1.124433362529811e+03,		1.124763272708423e+03,		1.125092557527300e+03,		1.125421219675756e+03,		1.125749261825220e+03,
		1.126076686629399e+03,		1.126403496724427e+03,		1.126729694729035e+03,		1.127055283244702e+03,		1.127380264855804e+03,
		1.127704642129776e+03,		1.128028417617252e+03,		1.128351593852220e+03,		1.128674173352168e+03,		1.128996158618228e+03,
		1.129317552135321e+03,		1.129638356372301e+03,		1.129958573782091e+03,		1.130278206801824e+03,		1.130597257852985e+03,
		1.130915729341538e+03,		1.131233623658071e+03,		1.131550943177921e+03,		1.131867690261308e+03,		1.132183867253467e+03,
		1.132499476484776e+03,		1.132814520270879e+03,		1.133129000912821e+03,		1.133442920697164e+03,		1.133756281896114e+03,
		1.134069086767643e+03,		1.134381337555611e+03,		1.134693036489881e+03,		1.135004185786440e+03,		1.135314787647518e+03,
		1.135624844261700e+03,		1.135934357804040e+03,		1.136243330436177e+03,		1.136551764306447e+03,		1.136859661549991e+03,
		1.137167024288865e+03,		1.137473854632151e+03,		1.137780154676064e+03,		1.138085926504055e+03,		1.138391172186920e+03,
		1.138695893782901e+03,		1.139000093337791e+03,		1.139303772885034e+03,		1.139606934445828e+03,		1.139909580029224e+03,
		1.140211711632224e+03,		1.140513331239879e+03,		1.140814440825384e+03,		1.141115042350181e+03,		1.141415137764044e+03,
		1.141714729005177e+03,		1.142013818000311e+03,		1.142312406664789e+03,		1.142610496902661e+03,		1.142908090606773e+03,
		1.143205189658857e+03,		1.143501795929619e+03,		1.143797911278825e+03,		1.144093537555388e+03,		1.144388676597456e+03,
		1.144683330232494e+03,		1.144977500277369e+03,		1.145271188538434e+03,		1.145564396811607e+03,		1.145857126882459e+03,
		1.146149380526286e+03,		1.146441159508198e+03,		1.146732465583190e+03,		1.147023300496227e+03,		1.147313665982315e+03
	},
	{
		1.822056682621224e+00,		5.529853403925243e+00,		9.321598398721562e+00,		1.320234357817156e+01,		1.717765010118131e+01,
		2.125366154725232e+01,		2.543719107393242e+01,		2.973582596209737e+01,		3.415805397512806e+01,		3.871341735247825e+01,
		4.341270218483559e+01,		4.826817361951024e+01,		5.329387119361709e+01,		5.850598417419572e+01,		6.392333503832731e+01,
		6.956801170030565e+01,		7.546620840926833e+01,		8.164936598547985e+01,		8.815575255096755e+01,		9.503271184659623e+01,
		1.023399587277308e+02,		1.101545856663071e+02,		1.185790059278043e+02,		1.277542524329522e+02,		1.378838255891020e+02,
		1.492805396189025e+02,		1.624711399301769e+02,		1.784811232815712e+02,		7.885823274661345e+02,		7.944558906630484e+02,
		7.998407088137160e+02,		8.048259986933277e+02,		8.094771937925329e+02,		8.138439952620504e+02,		8.179652008094831e+02,
		8.218717713004261e+02,		8.255888674229129e+02,		8.291372520730793e+02,		8.325342852052622e+02,		8.357946474870871e+02,
		8.389308780795543e+02,		8.419537817638284e+02,		8.448727422014766e+02,		8.476959664544606e+02,		8.504306783078249e+02,
		8.530832728760744e+02,		8.556594415448210e+02,		8.581642738873954e+02,		8.606023415231424e+02,		8.629777676618645e+02,
		8.652942851981327e+02,		8.675552855672055e+02,		8.697638600877452e+02,		8.719228351493609e+02,		8.740348023229535e+02,
		8.761021442562560e+02,		8.781270570512481e+02,		8.801115696801884e+02,		8.820575609156984e+02,		8.839667741368737e+02,
		8.858408303319196e+02,		8.876812395629270e+02,		8.894894110937460e+02,		8.912666623793860e+02,		8.930142270602739e+02,
		8.947332620944338e+02,		8.964248541373394e+02,		8.980900252634930e+02,		8.997297381102320e+02,		9.013449005129720e+02,
		9.029363696915167e+02,		9.045049560390561e+02,		9.060514265599526e+02,		9.075765079886679e+02,		9.090808896378777e+02,
		9.105652259891760e+02,		9.120301390633593e+02,		9.134762205893207e+02,		9.149040339923868e+02,		9.163141162199845e+02,
		9.177069794204660e+02,		9.190831124891603e+02,		9.204429824941593e+02,		9.217870359929688e+02,		9.231157002499804e+02,
		9.244293843636760e+02,		9.257284803115193e+02,		9.270133639197165e+02,		9.282843957653812e+02,		9.295419220114546e+02,
		9.307862751913211e+02,		9.320177749341395e+02,		9.332367286443442e+02,		9.344434321367897e+02,		9.356381702253851e+02,
		9.368212172868541e+02,		9.379928377718654e+02,		9.391532866968299e+02,		9.403028101004161e+02,		9.414416454731186e+02,
		9.425700221610266e+02,		9.436881617456443e+02,		9.447962784014711e+02,		9.458945792328803e+02,		9.469832645917696e+02,
		9.480625283772423e+02,		9.491325583185732e+02,		9.501935362425559e+02,		9.512456383278462e+02,		9.522890353393227e+02,
		9.533238928605434e+02,		9.543503715047832e+02,		9.553686271191233e+02,		9.563788109773076e+02,		9.573810699627638e+02,
		9.583755467423978e+02,		9.593623799317149e+02,		9.603417042518007e+02,		9.613136506786158e+02,		9.622783465850954e+02,
		9.632359158764311e+02,		9.641864791189530e+02,		9.651301536629646e+02,		9.660670537599751e+02,		9.669972906741450e+02,
		9.679209727893304e+02,		9.688382057107159e+02,		9.697490923621704e+02,		9.706537330792424e+02,		9.715522256980953e+02,
		9.724446656405689e+02,		9.733311459955821e+02,		9.742117575970776e+02,		9.750865890986598e+02,		9.759557270451164e+02,
		9.768192559425262e+02,		9.776772583186598e+02,		9.785298147931387e+02,		9.793770041336850e+02,		9.802189033151760e+02,
		9.810555875754377e+02,		9.818871304688296e+02,		9.827136039177311e+02,		9.835350782620581e+02,		9.843516223068543e+02,
		9.851633033680863e+02,		9.859701873166964e+02,		9.867723386210151e+02,		9.875698203876140e+02,		9.883626944005963e+02,
		9.891510211595123e+02,		9.899348599158714e+02,		9.907142687083350e+02,		9.914893043966694e+02,		9.922600226944771e+02,
		9.930264782007881e+02,		9.937887244305435e+02,		9.945468138440228e+02,		9.953007978752634e+02,		9.960507269595010e+02,
		9.967966505596910e+02,		9.975386171921293e+02,		9.982766744512161e+02,		9.990108690334127e+02,		9.997412467603874e+02,
		1.000467852601424e+03,		1.001190730695094e+03,		1.001909924370231e+03,		1.002625476166233e+03,		1.003337427852723e+03,
		1.004045820448587e+03,		1.004750694240412e+03,		1.005452088800352e+03,		1.006150043003450e+03,		1.006844595044402e+03,
		1.007535782453847e+03,		1.008223642114128e+03,		1.008908210274599e+03,		1.009589522566465e+03,		1.010267614017188e+03,
		1.010942519064456e+03,		1.011614271569752e+03,		1.012282904831527e+03,		1.012948451597984e+03,		1.013610944079495e+03,
		1.014270413960674e+03,		1.014926892412087e+03,		1.015580410101672e+03,		1.016230997205718e+03,		1.016878683419758e+03,
		1.017523497968938e+03,		1.018165469618214e+03,		1.018804626682252e+03,		1.019440997035042e+03,		1.020074608119266e+03,
		1.020705486955410e+03,		1.021333660150628e+03,		1.021959153907372e+03,		1.022581994031799e+03,		1.023202205941945e+03,
		1.023819814675693e+03,		1.024434844898535e+03,		1.025047320911130e+03,		1.025657266656663e+03,		1.026264705728024e+03,
		1.026869661374798e+03,		1.027472156510087e+03,		1.028072213717140e+03,		1.028669855255849e+03,		1.029265103069045e+03,
		1.029857978788674e+03,		1.030448503741799e+03,		1.031036698956456e+03,		1.031622585167377e+03,		1.032206182821570e+03,
		1.032787512083759e+03,		1.033366592841701e+03,		1.033943444711372e+03,		1.034518087042030e+03,		1.035090538921162e+03,
		1.035660819179306e+03,		1.036228946394775e+03,		1.036794938898254e+03,		1.037358814777302e+03,		1.037920591880747e+03,
		1.038480287822980e+03,		1.039037919988153e+03,		1.039593505534276e+03,		1.040147061397231e+03,		1.040698604294683e+03,
		1.041248150729921e+03,		1.041795716995592e+03,		1.042341319177374e+03,		1.042884973157550e+03,		1.043426694618513e+03,
		1.043966499046198e+03,		1.044504401733428e+03,		1.045040417783195e+03,		1.045574562111870e+03,		1.046106849452346e+03,
		1.046637294357105e+03,		1.047165911201232e+03,		1.047692714185357e+03,		1.048217717338538e+03,		1.048740934521083e+03,
		1.049262379427314e+03,		1.049782065588271e+03,		1.050300006374364e+03,		1.050816214997971e+03,		1.051330704515975e+03,
		1.051843487832256e+03,		1.052354577700137e+03,		1.052863986724765e+03,		1.053371727365462e+03,		1.053877811938018e+03,
		1.054382252616937e+03,		1.054885061437649e+03,		1.055386250298666e+03,		1.055885830963703e+03,		1.056383815063759e+03,
		1.056880214099146e+03,		1.057375039441495e+03,		1.057868302335709e+03,		1.058360013901884e+03,		1.058850185137198e+03,
		1.059338826917752e+03,		1.059825950000388e+03,		1.060311565024464e+03,		1.060795682513605e+03,		1.061278312877403e+03,
		1.061759466413111e+03,		1.062239153307282e+03,		1.062717383637389e+03,		1.063194167373415e+03,		1.063669514379411e+03,
		1.064143434415023e+03,		1.064615937137000e+03,		1.065087032100662e+03,		1.065556728761354e+03,		1.066025036475862e+03,
		1.066491964503815e+03,		1.066957522009051e+03,		1.067421718060968e+03,		1.067884561635843e+03,		1.068346061618133e+03,
		1.068806226801750e+03,		1.069265065891320e+03,		1.069722587503406e+03,		1.070178800167724e+03,		1.070633712328331e+03,
		1.071087332344797e+03,		1.071539668493344e+03,		1.071990728967987e+03,		1.072440521881633e+03,		1.072889055267177e+03,
		1.073336337078573e+03,		1.073782375191886e+03,		1.074227177406330e+03,		1.074670751445285e+03,		1.075113104957297e+03,
		1.075554245517066e+03,		1.075994180626411e+03,		1.076432917715228e+03,		1.076870464142415e+03,		1.077306827196805e+03,
		1.077742014098064e+03,		1.078176031997589e+03,		1.078608887979375e+03,		1.079040589060886e+03,		1.079471142193899e+03,
		1.079900554265339e+03,		1.080328832098103e+03,		1.080755982451864e+03,		1.081182012023868e+03,		1.081606927449715e+03,
		1.082030735304135e+03,		1.082453442101737e+03,		1.082875054297763e+03,		1.083295578288815e+03,		1.083715020413584e+03,
		1.084133386953559e+03,		1.084550684133728e+03,		1.084966918123264e+03,		1.085382095036211e+03,		1.085796220932146e+03,
		1.086209301816840e+03,		1.086621343642907e+03,		1.087032352310442e+03,		1.087442333667645e+03,		1.087851293511452e+03,
		1.088259237588126e+03,		1.088666171593879e+03,		1.089072101175446e+03,		1.089477031930677e+03,		1.089880969409111e+03,
		1.090283919112537e+03,		1.090685886495552e+03,		1.091086876966116e+03,		1.091486895886084e+03,		1.091885948571749e+03,
		1.092284040294355e+03,		1.092681176280626e+03,		1.093077361713268e+03,		1.093472601731477e+03,		1.093866901431431e+03,
		1.094260265866778e+03,		1.094652700049122e+03,		1.095044208948489e+03,		1.095434797493803e+03,		1.095824470573344e+03,
		1.096213233035198e+03,		1.096601089687710e+03,		1.096988045299926e+03,		1.097374104602026e+03,		1.097759272284312e+03,
		1.098143553003496e+03,		1.098526951374168e+03,		1.098909471975282e+03,		1.099291119349014e+03,		1.099671898001163e+03,
		1.100051812401544e+03,		1.100430866984381e+03,		1.100809066148692e+03,		1.101186414258660e+03,		1.101562915644015e+03,
		1.101938574600400e+03,		1.102313395389733e+03,		1.102687382240566e+03,		1.103060539348444e+03,		1.103432870876247e+03,
		1.103804380954540e+03,		1.104175073681907e+03,		1.104544953125295e+03,		1.104914023320337e+03,		1.105282288271682e+03,
		1.105649751953318e+03,		1.106016418308890e+03,		1.106382291252012e+03,		1.106747374666576e+03,		1.107111672407063e+03,
		1.107475188298839e+03,		1.107837926138456e+03,		1.108199889693947e+03,		1.108561082705113e+03,		1.108921508883808e+03,
		1.109281171914231e+03,		1.109640075453195e+03,		1.109998223130409e+03,		1.110355618548743e+03,		1.110712265284510e+03,
		1.111068166887715e+03,		1.111423326882330e+03,		1.111777748766544e+03,		1.112131436013025e+03,		1.112484392069167e+03,
		1.112836620357342e+03,		1.113188124275144e+03,		1.113538907195636e+03,		1.113888972467586e+03,		1.114238323415702e+03,
		1.114586963340873e+03,		1.114934895520393e+03,		1.115282123208194e+03,		1.115628649635071e+03,		1.115974478008902e+03,
		1.116319611514871e+03,		1.116664053315684e+03,		1.117007806551782e+03,		1.117350874341559e+03,		1.117693259781566e+03,
		1.118034965946719e+03,		1.118375995890505e+03,		1.118716352645187e+03,		1.119056039221994e+03,		1.119395058611332e+03,
		1.119733413782968e+03,		1.120071107686227e+03,		1.120408143250184e+03,		1.120744523383850e+03,		1.121080250976356e+03,
		1.121415328897144e+03,		1.121749759996140e+03,		1.122083547103942e+03,		1.122416693031989e+03,		1.122749200572743e+03,
		1.123081072499860e+03,		1.123412311568360e+03,		1.123742920514802e+03,		1.124072902057443e+03,		1.124402258896409e+03,
		1.124730993713862e+03,		1.125059109174152e+03,		1.125386607923986e+03,		1.125713492592581e+03,		1.126039765791825e+03,
		1.126365430116426e+03,		1.126690488144069e+03,		1.127014942435565e+03,		1.127338795535002e+03,		1.127662049969893e+03,
		1.127984708251319e+03,		1.128306772874080e+03,		1.128628246316827e+03,		1.128949131042218e+03,		1.129269429497044e+03,
		1.129589144112375e+03,		1.129908277303696e+03,		1.130226831471038e+03,		1.130544808999118e+03,		1.130862212257468e+03,
		1.131179043600561e+03,		1.131495305367953e+03,		1.131810999884397e+03,		1.132126129459978e+03,		1.132440696390236e+03,
		1.132754702956292e+03,		1.133068151424964e+03,		1.133381044048899e+03,		1.133693383066682e+03,		1.134005170702961e+03,
		1.134316409168563e+03,		1.134627100660613e+03,		1.134937247362640e+03,		1.135246851444702e+03,		1.135555915063491e+03,
		1.135864440362447e+03,		1.136172429471868e+03,		1.136479884509018e+03,		1.136786807578237e+03,		1.137093200771046e+03,
		1.137399066166252e+03,		1.137704405830056e+03,		1.138009221816150e+03,		1.138313516165828e+03,		1.138617290908078e+03,
		1.138920548059693e+03,		1.139223289625358e+03,		1.139525517597758e+03,		1.139827233957670e+03,		1.140128440674064e+03,
		1.140429139704191e+03,		1.140729332993684e+03,		1.141029022476647e+03,		1.141328210075753e+03,		1.141626897702326e+03,
		1.141925087256442e+03,		1.142222780627010e+03,		1.142519979691867e+03,		1.142816686317861e+03,		1.143112902360943e+03,
		1.143408629666248e+03,		1.143703870068182e+03,		1.143998625390510e+03,		1.144292897446431e+03,		1.144586688038673e+03,
		1.144879998959561e+03,		1.145172831991110e+03,		1.145465188905098e+03,		1.145757071463149e+03,		1.146048481416809e+03
	},
	{
		1.818236120301353e+00,		5.517836946488468e+00,		9.300587984610040e+00,		1.317144845977314e+01,		1.713587255972874e+01,
		2.119987978307173e+01,		2.537013857542781e+01,		2.965406644733354e+01,		3.405995071482219e+01,		3.859709529043496e+01,
		4.327600072309627e+01,		4.810858715708397e+01,		5.310847338502385e+01,		5.829133022502371e+01,		6.367533388312237e+01,
		6.928175611803789e+01,		7.513574517115848e+01,		8.126737848374570e+01,		8.771311222766420e+01,		9.451782673870174e+01,
		1.017377966511190e+02,		1.094451525379441e+02,		1.177348625073261e+02,		1.267362200578823e+02,		1.366329858447049e+02,
		1.477017641908699e+02,		1.603939969221888e+02,		1.755437683135673e+02,		7.799670645591543e+02,		7.864449557962373e+02,
		7.923174072523076e+02,		7.977073696533860e+02,		8.027015938699880e+02,		8.073640651461150e+02,		8.117435873972551e+02,
		8.158783805105569e+02,		8.197990226776742e+02,		8.235304161335307e+02,		8.270931470012428e+02,		8.305044535745658e+02,
		8.337789328203129e+02,		8.369290667748634e+02,		8.399656219400403e+02,		8.428979571916776e+02,		8.457342645302807e+02,
		8.484817597176044e+02,		8.511468349443614e+02,		8.537351823553370e+02,		8.562518949291675e+02,		8.587015495686543e+02,
		8.610882760750762e+02,		8.634158148176833e+02,		8.656875652725439e+02,		8.679066271286055e+02,		8.700758353005851e+02,
		8.721977899045746e+02,		8.742748820624361e+02,		8.763093162058689e+02,		8.783031294439309e+02,		8.802582084601747e+02,
		8.821763042911947e+02,		8.840590453200352e+02,		8.859079487279067e+02,		8.877244306241390e+02,		8.895098150343123e+02,
		8.912653418988810e+02,		8.929921742112557e+02,		8.946914044049786e+02,		8.963640600835796e+02,		8.980111091754405e+02,
		8.996334645724363e+02,		9.012319883329870e+02,		9.028074954766057e+02,		9.043607574307089e+02,		9.058925051627645e+02,
		9.074034320326188e+02,		9.088941963946827e+02,		9.103654239760461e+02,		9.118177100534748e+02,		9.132516214494919e+02,
		9.146676983654404e+02,		9.160664560673608e+02,		9.174483864387261e+02,		9.188139594136096e+02,		9.201636242964413e+02,
		9.214978109888350e+02,		9.228169311202107e+02,		9.241213790982996e+02,		9.254115330838251e+02,		9.266877558962182e+02,
		9.279503958562016e+02,		9.291997875704925e+02,		9.304362526633764e+02,		9.316601004594243e+02,		9.328716286212638e+02,
		9.340711237459276e+02,		9.352588619230092e+02,		9.364351092575172e+02,		9.376001223601256e+02,		9.387541488072208e+02,
		9.398974275729687e+02,		9.410301894368104e+02,		9.421526573615865e+02,		9.432650468581536e+02,		9.443675663215536e+02,
		9.454604173511922e+02,		9.465437950523971e+02,		9.476178883211297e+02,		9.486828801130289e+02,		9.497389476977937e+02,
		9.507862628998447e+02,		9.518249923261970e+02,		9.528552975823134e+02,		9.538773354767497e+02,		9.548912582151660e+02,
		9.558972135846044e+02,		9.568953451283447e+02,		9.578857923121097e+02,		9.588686906820412e+02,		9.598441720149735e+02,
		9.608123644614433e+02,		9.617733926818474e+02,		9.627273779761649e+02,		9.636744384075886e+02,		9.646146889204142e+02,
		9.655482414525140e+02,		9.664752050444781e+02,		9.673956859361077e+02,		9.683097876722776e+02,		9.692176111918299e+02,
		9.701192549181515e+02,		9.710148148448026e+02,		9.719043846174549e+02,		9.727880556123488e+02,		9.736659170114293e+02,
		9.745380558743417e+02,		9.754045572074400e+02,		9.762655040299578e+02,		9.771209774374878e+02,		9.779710566628908e+02,
		9.788158191347377e+02,		9.796553405335857e+02,		9.804896948457236e+02,		9.813189544151427e+02,		9.821431899933286e+02,
		9.829624707871747e+02,		9.837768645050714e+02,		9.845864374012646e+02,		9.853912543185277e+02,		9.861913787292812e+02,
		9.869868727751642e+02,		9.877777973051826e+02,		9.885642119124605e+02,		9.893461749696697e+02,		9.901237436631960e+02,
		9.908969740260929e+02,		9.916659209698805e+02,		9.924306383152165e+02,		9.931911788215353e+02,		9.939475942156313e+02,
		9.946999352192962e+02,		9.954482515760035e+02,		9.961925920766960e+02,		9.969330045847208e+02,		9.976695360599265e+02,
		9.984022325819709e+02,		9.991311393728745e+02,		9.998563008188254e+02,		1.000577760491298e+03,		1.001295561167483e+03,
		1.002009744850076e+03,		1.002720352786435e+03,		1.003427425487144e+03,		1.004131002743993e+03,		1.004831123647399e+03,
		1.005527826603305e+03,		1.006221149349542e+03,		1.006911128971719e+03,		1.007597801918611e+03,		1.008281204017101e+03,
		1.008961370486678e+03,		1.009638335953495e+03,		1.010312134464053e+03,		1.010982799498339e+03,		1.011650363982876e+03,
		1.012314860303093e+03,		1.012976320315507e+03,		1.013634775359511e+03,		1.014290256268836e+03,		1.014942793382694e+03,
		1.015592416556609e+03,		1.016239155172934e+03,		1.016883038151103e+03,		1.017524093957572e+03,		1.018162350615518e+03,
		1.018797835714248e+03,		1.019430576418377e+03,		1.020060599476746e+03,		1.020687931231107e+03,		1.021312597624578e+03,
		1.021934624209876e+03,		1.022554036157331e+03,		1.023170858262695e+03,		1.023785114954749e+03,		1.024396830302707e+03,
		1.025006028023443e+03,		1.025612731488526e+03,		1.026216963731066e+03,		1.026818747452419e+03,		1.027418105028690e+03,
		1.028015058517092e+03,		1.028609629662144e+03,		1.029201839901718e+03,		1.029791710372933e+03,		1.030379261917908e+03,
		1.030964515089381e+03,		1.031547490156177e+03,		1.032128207108564e+03,		1.032706685663469e+03,		1.033282945269566e+03,
		1.033857005112264e+03,		1.034428884118553e+03,		1.034998600961751e+03,		1.035566174066143e+03,		1.036131621611496e+03,
		1.036694961537493e+03,		1.037256211548045e+03,		1.037815389115515e+03,		1.038372511484848e+03,		1.038927595677600e+03,
		1.039480658495877e+03,		1.040031716526196e+03,		1.040580786143250e+03,		1.041127883513591e+03,		1.041673024599239e+03,
		1.042216225161196e+03,		1.042757500762907e+03,		1.043296866773620e+03,		1.043834338371693e+03,		1.044369930547820e+03,
		1.044903658108191e+03,		1.045435535677581e+03,		1.045965577702383e+03,		1.046493798453560e+03,		1.047020212029553e+03,
		1.047544832359120e+03,		1.048067673204108e+03,		1.048588748162183e+03,		1.049108070669497e+03,		1.049625654003288e+03,
		1.050141511284450e+03,		1.050655655480035e+03,		1.051168099405699e+03,		1.051678855728122e+03,		1.052187936967351e+03,
		1.052695355499114e+03,		1.053201123557088e+03,		1.053705253235111e+03,		1.054207756489357e+03,		1.054708645140470e+03,
		1.055207930875653e+03,		1.055705625250717e+03,		1.056201739692087e+03,		1.056696285498778e+03,		1.057189273844321e+03,
		1.057680715778662e+03,		1.058170622230020e+03,		1.058659004006709e+03,		1.059145871798927e+03,		1.059631236180514e+03,
		1.060115107610671e+03,		1.060597496435646e+03,		1.061078412890404e+03,		1.061557867100238e+03,		1.062035869082383e+03,
		1.062512428747570e+03,		1.062987555901573e+03,		1.063461260246717e+03,		1.063933551383359e+03,		1.064404438811350e+03,
		1.064873931931460e+03,		1.065342040046785e+03,		1.065808772364122e+03,		1.066274137995330e+03,		1.066738145958654e+03,
		1.067200805180036e+03,		1.067662124494393e+03,		1.068122112646887e+03,		1.068580778294153e+03,		1.069038130005526e+03,
		1.069494176264231e+03,		1.069948925468557e+03,		1.070402385933021e+03,		1.070854565889492e+03,		1.071305473488314e+03,
		1.071755116799400e+03,		1.072203503813309e+03,		1.072650642442307e+03,		1.073096540521409e+03,		1.073541205809403e+03,
		1.073984645989856e+03,		1.074426868672103e+03,		1.074867881392226e+03,		1.075307691614005e+03,		1.075746306729863e+03,
		1.076183734061793e+03,		1.076619980862266e+03,		1.077055054315130e+03,		1.077488961536489e+03,		1.077921709575571e+03,
		1.078353305415583e+03,		1.078783755974547e+03,		1.079213068106128e+03,		1.079641248600443e+03,		1.080068304184867e+03,
		1.080494241524815e+03,		1.080919067224519e+03,		1.081342787827784e+03,		1.081765409818750e+03,		1.082186939622616e+03,
		1.082607383606379e+03,		1.083026748079541e+03,		1.083445039294820e+03,		1.083862263448838e+03,		1.084278426682806e+03,
		1.084693535083197e+03,		1.085107594682405e+03,		1.085520611459402e+03,		1.085932591340370e+03,		1.086343540199349e+03,
		1.086753463858842e+03,		1.087162368090440e+03,		1.087570258615420e+03,		1.087977141105345e+03,		1.088383021182643e+03,
		1.088787904421192e+03,		1.089191796346879e+03,		1.089594702438173e+03,		1.089996628126665e+03,		1.090397578797616e+03,
		1.090797559790497e+03,		1.091196576399511e+03,		1.091594633874116e+03,		1.091991737419539e+03,		1.092387892197278e+03,
		1.092783103324192e+03,		1.093177375878735e+03,		1.093570714892664e+03,		1.093963125357479e+03,		1.094354612223375e+03,
		1.094745180399697e+03,		1.095134834755406e+03,		1.095523580119528e+03,		1.095911421281593e+03,		1.096298362992075e+03,
		1.096684409962829e+03,		1.097069566867508e+03,		1.097453838341988e+03,		1.097837228984783e+03,		1.098219743357448e+03,
		1.098601385984984e+03,		1.098982161356238e+03,		1.099362073924291e+03,		1.099741128106842e+03,		1.100119328286597e+03,
		1.100496678811636e+03,		1.100873183995787e+03,		1.101248848118994e+03,		1.101623675427673e+03,		1.101997670135075e+03,
		1.102370836421626e+03,		1.102743178435283e+03,		1.103114700291873e+03,		1.103485406075428e+03,		1.103855299838521e+03,
		1.104224385602590e+03,		1.104592667358269e+03,		1.104960149065700e+03,		1.105326834654851e+03,		1.105692728025832e+03,
		1.106057833049197e+03,		1.106422153566247e+03,		1.106785693389335e+03,		1.107148456302157e+03,		1.107510446060042e+03,
		1.107871666390248e+03,		1.108232120992236e+03,		1.108591813537958e+03,		1.108950747672134e+03,		1.109308927012519e+03,
		1.109666355150181e+03,		1.110023035649762e+03,		1.110378972049745e+03,		1.110734167862713e+03,		1.111088626575601e+03,
		1.111442351649959e+03,		1.111795346522196e+03,		1.112147614603825e+03,		1.112499159281713e+03,		1.112849983918321e+03,
		1.113200091851938e+03,		1.113549486396920e+03,		1.113898170843921e+03,		1.114246148460124e+03,		1.114593422489466e+03,
		1.114939996152862e+03,		1.115285872648427e+03,		1.115631055151694e+03,		1.115975546815830e+03,		1.116319350771849e+03,
		1.116662470128823e+03,		1.117004907974091e+03,		1.117346667373464e+03,		1.117687751371426e+03,		1.118028162991340e+03,
		1.118367905235639e+03,		1.118706981086030e+03,		1.119045393503681e+03,		1.119383145429419e+03,		1.119720239783913e+03,
		1.120056679467865e+03,		1.120392467362191e+03,		1.120727606328209e+03,		1.121062099207817e+03,		1.121395948823667e+03,
		1.121729157979349e+03,		1.122061729459560e+03,		1.122393666030277e+03,		1.122724970438931e+03,		1.123055645414569e+03,
		1.123385693668027e+03,		1.123715117892091e+03,		1.124043920761656e+03,		1.124372104933897e+03,		1.124699673048418e+03,
		1.125026627727415e+03,		1.125352971575826e+03,		1.125678707181492e+03,		1.126003837115302e+03,		1.126328363931350e+03,
		1.126652290167074e+03,		1.126975618343414e+03,		1.127298350964948e+03,		1.127620490520042e+03,		1.127942039480987e+03,
		1.128263000304145e+03,		1.128583375430082e+03,		1.128903167283709e+03,		1.129222378274418e+03,		1.129541010796217e+03,
		1.129859067227856e+03,		1.130176549932969e+03,		1.130493461260197e+03,		1.130809803543320e+03,		1.131125579101379e+03,
		1.131440790238812e+03,		1.131755439245565e+03,		1.132069528397227e+03,		1.132383059955147e+03,		1.132696036166554e+03,
		1.133008459264676e+03,		1.133320331468859e+03,		1.133631654984687e+03,		1.133942432004090e+03,		1.134252664705465e+03,
		1.134562355253786e+03,		1.134871505800717e+03,		1.135180118484720e+03,		1.135488195431170e+03,		1.135795738752456e+03,
		1.136102750548098e+03,		1.136409232904840e+03,		1.136715187896768e+03,		1.137020617585410e+03,		1.137325524019829e+03,
		1.137629909236743e+03,		1.137933775260608e+03,		1.138237124103732e+03,		1.138539957766361e+03,		1.138842278236787e+03,
		1.139144087491442e+03,		1.139445387494988e+03,		1.139746180200419e+03,		1.140046467549151e+03,		1.140346251471115e+03,
		1.140645533884852e+03,		1.140944316697598e+03,		1.141242601805382e+03,		1.141540391093104e+03,		1.141837686434639e+03,
		1.142134489692907e+03,		1.142430802719971e+03,		1.142726627357119e+03,		1.143021965434952e+03,		1.143316818773460e+03,
		1.143611189182114e+03,		1.143905078459943e+03,		1.144198488395616e+03,		1.144491420767525e+03,		1.144783877343863e+03
	},
	{
		1.814431849907915e+00,		5.505875544067768e+00,		9.279680910837619e+00,		1.314071638551096e+01,		1.709433151284910e+01,
		2.114642458547092e+01,		2.530352290970039e+01,		2.957287869637312e+01,		3.396258445161810e+01,		3.848171293020817e+01,
		4.314048834190447e+01,		4.795049776370792e+01,		5.292495490359838e+01,		5.807903294227249e+01,		6.343028987407845e+01,
		6.899921975337807e+01,		7.480997848713524e+01,		8.089135665871972e+01,		8.727811027935449e+01,		9.401282431277359e+01,
		1.011485944030748e+02,		1.087530121276780e+02,		1.169143198896582e+02,		1.257513743681585e+02,		1.354307532404277e+02,
		1.461984497318506e+02,		1.584449632732399e+02,		1.728604506041620e+02,		1.909057961385654e+02,		7.778875458061952e+02,
		7.843499497325822e+02,		7.902180538354596e+02,		7.956103261171505e+02,		8.006110144476239e+02,		8.052826042011334e+02,
		8.096729532927530e+02,		8.138196619924566e+02,		8.177528911457853e+02,		8.214972560654127e+02,		8.250731427477843e+02,
		8.284976486075303e+02,		8.317852710149045e+02,		8.349484216582870e+02,		8.379978176916143e+02,		8.409427838841116e+02,
		8.437914892831976e+02,		8.465511349050952e+02,		8.492281042599139e+02,		8.518280852987964e+02,		8.543561701228707e+02,
		8.568169371984181e+02,		8.592145196731486e+02,		8.615526625501086e+02,		8.638347708462530e+02,		8.660639504166732e+02,
		8.682430427470983e+02,		8.703746547644910e+02,		8.724611845202068e+02,		8.745048433926585e+02,		8.765076753912269e+02,
		8.784715739932102e+02,		8.803982968906760e+02,		8.822894789530332e+02,		8.841466436604302e+02,		8.859712132212213e+02,
		8.877645175537641e+02,		8.895278022786937e+02,		8.912622358598663e+02,		8.929689159914332e+02,		8.946488753315539e+02,
		8.963030866598601e+02,		8.979324675275939e+02,		8.995378844596368e+02,		9.011201567596363e+02,		9.026800599627409e+02,
		9.042183289746711e+02,		9.057356609309394e+02,		9.072327178058849e+02,		9.087101287974683e+02,		9.101684925126933e+02,
		9.116083789647399e+02,		9.130303314186514e+02,		9.144348680795508e+02,		9.158224836519199e+02,		9.171936507772555e+02,
		9.185488213620062e+02,		9.198884278058246e+02,		9.212128841389861e+02,		9.225225870770179e+02,		9.238179169996947e+02,
		9.250992388608737e+02,		9.263669030349963e+02,		9.276212461055050e+02,		9.288625915999094e+02,		9.300912506758216e+02,
		9.313075227638089e+02,		9.325116961611716e+02,		9.337040485997572e+02,		9.348848477677262e+02,		9.360543518032188e+02,
		9.372128097568747e+02,		9.383604620262693e+02,		9.394975407643038e+02,		9.406242702633973e+02,		9.417408673172287e+02,
		9.428475415615897e+02,		9.439444957957197e+02,		9.450319262856223e+02,		9.461100230503899e+02,		9.471789701328003e+02,
		9.482389458551644e+02,		9.492901230614034e+02,		9.503326693462478e+02,		9.513667472723647e+02,		9.523925145761801e+02,
		9.534101243631154e+02,		9.544197252928560e+02,		9.554214617569280e+02,		9.564154740405555e+02,		9.574018984884998e+02,
		9.583808676521684e+02,		9.593525104344100e+02,		9.603169522265016e+02,		9.612743150386710e+02,		9.622247176244783e+02,
		9.631682755994465e+02,		9.641051015542263e+02,		9.650353051626175e+02,		9.659589932847266e+02,		9.668762700655050e+02,
		9.677872370289535e+02,		9.686919931681743e+02,		9.695906350315355e+02,		9.704832568050106e+02,		9.713699503915709e+02,
		9.722508054860893e+02,		9.731259096482745e+02,		9.739953483719756e+02,		9.748592051517711e+02,		9.757175615468424e+02,
		9.765704972422600e+02,		9.774180901078294e+02,		9.782604162545849e+02,		9.790975500890740e+02,		9.799295643655098e+02,
		9.807565302359129e+02,		9.815785172983267e+02,		9.823955936431973e+02,		9.832078258979956e+02,		9.840152792701774e+02,
		9.848180175885410e+02,		9.856161033430560e+02,		9.864095977232506e+02,		9.871985606551868e+02,		9.879830508371166e+02,
		9.887631257738612e+02,		9.895388418099669e+02,		9.903102541617064e+02,		9.910774169479395e+02,		9.918403832199353e+02,
		9.925992049901427e+02,		9.933539332599845e+02,		9.941046180467230e+02,		9.948513084093993e+02,		9.955940524739265e+02,
		9.963328974573367e+02,		9.970678896912353e+02,		9.977990746444884e+02,		9.985264969451712e+02,		9.992502004018105e+02,
		9.999702280239482e+02,		1.000686622042047e+03,		1.001399423926770e+03,		1.002108674407656e+03,		1.002814413491214e+03,
		1.003516680478451e+03,		1.004215513981872e+03,		1.004910951941989e+03,		1.005603031643135e+03,		1.006291789729216e+03,
		1.006977262218556e+03,		1.007659484518535e+03,		1.008338491439732e+03,		1.009014317209668e+03,		1.009686995486137e+03,
		1.010356559370158e+03,		1.011023041418548e+03,		1.011686473656136e+03,		1.012346887587634e+03,		1.013004314209166e+03,
		1.013658784019478e+03,		1.014310327030830e+03,		1.014958972779591e+03,		1.015604750336535e+03,		1.016247688316859e+03,
		1.016887814889930e+03,		1.017525157788760e+03,		1.018159744319229e+03,		1.018791601369066e+03,		1.019420755416583e+03,
		1.020047232539183e+03,		1.020671058421637e+03,		1.021292258364156e+03,		1.021910857290238e+03,		1.022526879754326e+03,
		1.023140349949257e+03,		1.023751291713529e+03,		1.024359728538376e+03,		1.024965683574673e+03,		1.025569179639649e+03,
		1.026170239223458e+03,		1.026768884495564e+03,		1.027365137310979e+03,		1.027959019216342e+03,		1.028550551455850e+03,
		1.029139754977050e+03,		1.029726650436482e+03,		1.030311258205193e+03,		1.030893598374109e+03,		1.031473690759294e+03,
		1.032051554907067e+03,		1.032627210099010e+03,		1.033200675356857e+03,		1.033771969447256e+03,		1.034341110886442e+03,
		1.034908117944781e+03,		1.035473008651225e+03,		1.036035800797648e+03,		1.036596511943107e+03,		1.037155159417977e+03,
		1.037711760328020e+03,		1.038266331558342e+03,		1.038818889777275e+03,		1.039369451440165e+03,		1.039918032793077e+03,
		1.040464649876420e+03,		1.041009318528497e+03,		1.041552054388965e+03,		1.042092872902231e+03,		1.042631789320771e+03,
		1.043168818708377e+03,		1.043703975943332e+03,		1.044237275721524e+03,		1.044768732559486e+03,		1.045298360797379e+03,
		1.045826174601903e+03,		1.046352187969160e+03,		1.046876414727443e+03,		1.047398868539978e+03,		1.047919562907606e+03,
		1.048438511171403e+03,		1.048955726515261e+03,		1.049471221968401e+03,		1.049985010407845e+03,		1.050497104560832e+03,
		1.051007517007192e+03,		1.051516260181666e+03,		1.052023346376182e+03,		1.052528787742085e+03,		1.053032596292327e+03,
		1.053534783903609e+03,		1.054035362318483e+03,		1.054534343147409e+03,		1.055031737870781e+03,		1.055527557840908e+03,
		1.056021814283950e+03,		1.056514518301832e+03,		1.057005680874111e+03,		1.057495312859806e+03,		1.057983424999200e+03,
		1.058470027915607e+03,		1.058955132117100e+03,		1.059438747998211e+03,		1.059920885841600e+03,		1.060401555819688e+03,
		1.060880767996269e+03,		1.061358532328080e+03,		1.061834858666356e+03,		1.062309756758339e+03,		1.062783236248778e+03,
		1.063255306681395e+03,		1.063725977500312e+03,		1.064195258051474e+03,		1.064663157584032e+03,		1.065129685251701e+03,
		1.065594850114106e+03,		1.066058661138087e+03,		1.066521127198997e+03,		1.066982257081964e+03,		1.067442059483141e+03,
		1.067900543010929e+03,		1.068357716187177e+03,		1.068813587448369e+03,		1.069268165146780e+03,		1.069721457551620e+03,
		1.070173472850156e+03,		1.070624219148813e+03,		1.071073704474260e+03,		1.071521936774475e+03,		1.071968923919789e+03,
		1.072414673703923e+03,		1.072859193844989e+03,		1.073302491986501e+03,		1.073744575698340e+03,		1.074185452477725e+03,
		1.074625129750157e+03,		1.075063614870349e+03,		1.075500915123144e+03,		1.075937037724416e+03,		1.076371989821955e+03,
		1.076805778496340e+03,		1.077238410761795e+03,		1.077669893567035e+03,		1.078100233796092e+03,		1.078529438269141e+03,
		1.078957513743292e+03,		1.079384466913391e+03,		1.079810304412792e+03,		1.080235032814128e+03,		1.080658658630062e+03,
		1.081081188314031e+03,		1.081502628260975e+03,		1.081922984808059e+03,		1.082342264235378e+03,		1.082760472766657e+03,
		1.083177616569934e+03,		1.083593701758241e+03,		1.084008734390263e+03,		1.084422720470998e+03,		1.084835665952401e+03,
		1.085247576734019e+03,		1.085658458663617e+03,		1.086068317537793e+03,		1.086477159102588e+03,		1.086884989054084e+03,
		1.087291813037518e+03,		1.087697636653858e+03,		1.088102465451216e+03,		1.088506304931632e+03,		1.088909160550048e+03,
		1.089311037714851e+03,		1.089711941788410e+03,		1.090111878087609e+03,		1.090510851884371e+03,		1.090908868406172e+03,
		1.091305932836549e+03,		1.091702050315600e+03,		1.092097225940480e+03,		1.092491464765885e+03,		1.092884771804529e+03,
		1.093277152027625e+03,		1.093668610365342e+03,		1.094059151707268e+03,		1.094448780902863e+03,		1.094837502761904e+03,
		1.095225322054927e+03,		1.095612243513659e+03,		1.095998271831445e+03,		1.096383411663676e+03,		1.096767667628195e+03,
		1.097151044305715e+03,		1.097533546240224e+03,		1.097915177939375e+03,		1.098295943874892e+03,		1.098675848482950e+03,
		1.099054896164558e+03,		1.099433091285941e+03,		1.099810438178910e+03,		1.100186941141227e+03,		1.100562604436974e+03,
		1.100937432296904e+03,		1.101311428918795e+03,		1.101684598467806e+03,		1.102056945076807e+03,		1.102428472846731e+03,
		1.102799185846898e+03,		1.103169088115353e+03,		1.103538183659185e+03,		1.103906476454856e+03,		1.104273970448511e+03,
		1.104640669556293e+03,		1.105006577664655e+03,		1.105371698630660e+03,		1.105736036282288e+03,		1.106099594418728e+03,
		1.106462376810671e+03,		1.106824387200604e+03,		1.107185629303093e+03,		1.107546106805063e+03,		1.107905823366079e+03,
		1.108264782618626e+03,		1.108622988168366e+03,		1.108980443594423e+03,		1.109337152449635e+03,		1.109693118260822e+03,
		1.110048344529042e+03,		1.110402834729845e+03,		1.110756592313526e+03,		1.111109620705375e+03,		1.111461923305916e+03,
		1.111813503491157e+03,		1.112164364612825e+03,		1.112514509998605e+03,		1.112863942952368e+03,		1.113212666754411e+03,
		1.113560684661675e+03,		1.113907999907976e+03,		1.114254615704227e+03,		1.114600535238655e+03,		1.114945761677019e+03,
		1.115290298162825e+03,		1.115634147817540e+03,		1.115977313740793e+03,		1.116319799010592e+03,		1.116661606683522e+03,
		1.117002739794949e+03,		1.117343201359217e+03,		1.117682994369848e+03,		1.118022121799735e+03,		1.118360586601335e+03,
		1.118698391706859e+03,		1.119035540028460e+03,		1.119372034458417e+03,		1.119707877869322e+03,		1.120043073114260e+03,
		1.120377623026985e+03,		1.120711530422101e+03,		1.121044798095237e+03,		1.121377428823220e+03,		1.121709425364242e+03,
		1.122040790458035e+03,		1.122371526826036e+03,		1.122701637171551e+03,		1.123031124179919e+03,		1.123359990518676e+03,
		1.123688238837711e+03,		1.124015871769427e+03,		1.124342891928895e+03,		1.124669301914009e+03,		1.124995104305640e+03,
		1.125320301667786e+03,		1.125644896547719e+03,		1.125968891476138e+03,		1.126292288967308e+03,		1.126615091519211e+03,
		1.126937301613685e+03,		1.127258921716563e+03,		1.127579954277821e+03,		1.127900401731705e+03,		1.128220266496876e+03,
		1.128539550976542e+03,		1.128858257558589e+03,		1.129176388615721e+03,		1.129493946505578e+03,		1.129810933570880e+03,
		1.130127352139543e+03,		1.130443204524811e+03,		1.130758493025381e+03,		1.131073219925524e+03,		1.131387387495213e+03,
		1.131700997990234e+03,		1.132014053652317e+03,		1.132326556709252e+03,		1.132638509374997e+03,		1.132949913849806e+03,
		1.133260772320338e+03,		1.133571086959772e+03,		1.133880859927918e+03,		1.134190093371329e+03,		1.134498789423412e+03,
		1.134806950204535e+03,		1.135114577822137e+03,		1.135421674370834e+03,		1.135728241932521e+03,		1.136034282576484e+03,
		1.136339798359495e+03,		1.136644791325921e+03,		1.136949263507820e+03,		1.137253216925045e+03,		1.137556653585340e+03,
		1.137859575484443e+03,		1.138161984606177e+03,		1.138463882922550e+03,		1.138765272393850e+03,		1.139066154968738e+03,
		1.139366532584341e+03,		1.139666407166349e+03,		1.139965780629095e+03,		1.140264654875661e+03,		1.140563031797955e+03,
		1.140860913276804e+03,		1.141158301182043e+03,		1.141455197372601e+03,		1.141751603696587e+03,		1.142047521991373e+03,
		1.142342954082132e+03,		1.142637901788276e+03,		1.142932366913756e+03,		1.143226351253840e+03,		1.143519856593475e+03
	},
	{
		1.810643764576557e+00,		5.493968790815501e+00,		9.258876330155827e+00,		1.311014587988448e+01,		1.705302461115146e+01,
		2.109329240738771e+01,		2.523733890376246e+01,		2.949225534141238e+01,		3.386594486317862e+01,		3.836725597391892e+01,
		4.300614538535311e+01,		4.779387853703158e+01,		5.274327899468225e+01,		5.786904208054990e+01,		6.318813412551087e+01,
		6.872030767690217e+01,		7.448877654526680e+01,		8.052111560924914e+01,		8.685048387582870e+01,		9.351732460878098e+01,
		1.005717908291488e+02,		1.080773128506029e+02,		1.161160397634841e+02,		1.247975132975810e+02,		1.342732717383022e+02,
		1.447632192824001e+02,		1.566078830978594e+02,		1.703865006312703e+02,		1.872441335500630e+02,		7.686605404100733e+02,
		7.758545384979218e+02,		7.822978055184810e+02,		7.881582880483303e+02,		7.935500034724159e+02,		7.985546571510309e+02,
		8.032331820793933e+02,		8.076324409482587e+02,		8.117893722993909e+02,		8.157336847099140e+02,		8.194896778892511e+02,
		8.230775141696628e+02,		8.265141307065987e+02,		8.298139092388866e+02,		8.329891777539099e+02,		8.360505928807614e+02,
		8.390074358644522e+02,		8.418678448180793e+02,		8.446389992126312e+02,		8.473272680526258e+02,		8.499383300806771e+02,
		8.524772721834552e+02,		8.549486706208589e+02,		8.573566585988706e+02,		8.597049828718251e+02,		8.619970514629076e+02,
		8.642359741586826e+02,		8.664245970332761e+02,		8.685655320679564e+02,		8.706611826696707e+02,		8.727137657631040e+02,
		8.747253309980833e+02,		8.766977775167088e+02,		8.786328686474590e+02,		8.805322448239725e+02,		8.823974349915112e+02,
		8.842298667002411e+02,		8.860308750704149e+02,		8.878017107765567e+02,		8.895435471779678e+02,		8.912574867036803e+02,
		8.929445665841729e+02,		8.946057640090387e+02,		8.962420007787766e+02,		8.978541475094665e+02,		8.994430274424961e+02,
		9.010094198984258e+02,		9.025540634240375e+02,		9.040776586544482e+02,		9.055808709275062e+02,		9.070643326736816e+02,
		9.085286456046944e+02,		9.099743827209866e+02,		9.114020901559220e+02,		9.128122888724437e+02,		9.142054762262686e+02,
		9.155821274080993e+02,		9.169426967759762e+02,		9.182876190877298e+02,		9.196173106424253e+02,		9.209321703410466e+02,
		9.222325806631872e+02,		9.235189085877086e+02,		9.247915064386797e+02,		9.260507126779368e+02,		9.272968526433389e+02,
		9.285302392378185e+02,		9.297511735732074e+02,		9.309599455723300e+02,		9.321568345325924e+02,		9.333421096540577e+02,
		9.345160305346253e+02,		9.356788476347868e+02,		9.368308027141759e+02,		9.379721292419894e+02,		9.391030527831034e+02,
		9.402237913616439e+02,		9.413345558035647e+02,		9.424355500596745e+02,		9.435269715104617e+02,		9.446090112559743e+02,
		9.456818543813370e+02,		9.467456802222828e+02,		9.478006626036831e+02,		9.488469700710668e+02,		9.498847661089412e+02,
		9.509142093477501e+02,		9.519354537601869e+02,		9.529486488475161e+02,		9.539539398165138e+02,		9.549514677475823e+02,
		9.559413697545959e+02,		9.569237791369194e+02,		9.578988255241173e+02,		9.588666350137186e+02,		9.598273303024736e+02,
		9.607810308114689e+02,		9.617278528049940e+02,		9.626679095061345e+02,		9.636013112026752e+02,		9.645281653527429e+02,
		9.654485766834421e+02,		9.663626472855855e+02,		9.672704767042945e+02,		9.681721620256485e+02,		9.690677979596259e+02,
		9.699574769195056e+02,		9.708412890979195e+02,		9.717193225397197e+02,		9.725916632118226e+02,		9.734583950701968e+02,
		9.743196001241015e+02,		9.751753584977463e+02,		9.760257484894754e+02,		9.768708466286055e+02,		9.777107277300219e+02,
		9.785454649466471e+02,		9.793751298198780e+02,		9.801997923280878e+02,		9.810195209332783e+02,		9.818343826259717e+02,
		9.826444429684213e+02,		9.834497661362211e+02,		9.842504149583648e+02,		9.850464509558642e+02,		9.858379343789459e+02,
		9.866249242429167e+02,		9.874074783627484e+02,		9.881856533864351e+02,		9.889595048271730e+02,		9.897290870944215e+02,
		9.904944535238880e+02,		9.912556564064754e+02,		9.920127470162474e+02,		9.927657756374390e+02,		9.935147915905666e+02,
		9.942598432576578e+02,		9.950009781066490e+02,		9.957382427149751e+02,		9.964716827923952e+02,		9.972013432030718e+02,
		9.979272679869321e+02,		9.986495003803647e+02,		9.993680828362868e+02,		1.000083057043315e+03,		1.000794463944908e+03,
		1.001502343757323e+03,		1.002206735987306e+03,		1.002907679449196e+03,		1.003605212281489e+03,		1.004299371962917e+03,
		1.004990195328027e+03,		1.005677718582298e+03,		1.006361977316814e+03,		1.007043006522499e+03,		1.007720840603932e+03,
		1.008395513392759e+03,		1.009067058160723e+03,		1.009735507632308e+03,		1.010400893997031e+03,		1.011063248921373e+03,
		1.011722603560383e+03,		1.012378988568953e+03,		1.013032434112772e+03,		1.013682969878981e+03,		1.014330625086534e+03,
		1.014975428496272e+03,		1.015617408420726e+03,		1.016256592733648e+03,		1.016893008879293e+03,		1.017526683881442e+03,
		1.018157644352197e+03,		1.018785916500526e+03,		1.019411526140609e+03,		1.020034498699933e+03,		1.020654859227200e+03,
		1.021272632400026e+03,		1.021887842532430e+03,		1.022500513582147e+03,		1.023110669157743e+03,		1.023718332525554e+03,
		1.024323526616453e+03,		1.024926274032442e+03,		1.025526597053080e+03,		1.026124517641761e+03,		1.026720057451824e+03,
		1.027313237832520e+03,		1.027904079834836e+03,		1.028492604217170e+03,		1.029078831450876e+03,		1.029662781725674e+03,
		1.030244474954928e+03,		1.030823930780798e+03,		1.031401168579281e+03,		1.031976207465117e+03,		1.032549066296590e+03,
		1.033119763680222e+03,		1.033688317975339e+03,		1.034254747298559e+03,		1.034819069528151e+03,		1.035381302308314e+03,
		1.035941463053345e+03,		1.036499568951722e+03,		1.037055636970090e+03,		1.037609683857163e+03,		1.038161726147531e+03,
		1.038711780165390e+03,		1.039259862028189e+03,		1.039805987650190e+03,		1.040350172745957e+03,		1.040892432833772e+03,
		1.041432783238966e+03,		1.041971239097187e+03,		1.042507815357595e+03,		1.043042526785990e+03,		1.043575387967874e+03,
		1.044106413311446e+03,		1.044635617050531e+03,		1.045163013247459e+03,		1.045688615795869e+03,		1.046212438423472e+03,
		1.046734494694735e+03,		1.047254798013532e+03,		1.047773361625725e+03,		1.048290198621699e+03,		1.048805321938848e+03,
		1.049318744364000e+03,		1.049830478535809e+03,		1.050340536947083e+03,		1.050848931947074e+03,		1.051355675743727e+03,
		1.051860780405873e+03,		1.052364257865386e+03,		1.052866119919297e+03,		1.053366378231866e+03,		1.053865044336612e+03,
		1.054362129638309e+03,		1.054857645414936e+03,		1.055351602819594e+03,		1.055844012882387e+03,		1.056334886512267e+03,
		1.056824234498837e+03,		1.057312067514132e+03,		1.057798396114357e+03,		1.058283230741596e+03,		1.058766581725490e+03,
		1.059248459284879e+03,		1.059728873529420e+03,		1.060207834461173e+03,		1.060685351976153e+03,		1.061161435865860e+03,
		1.061636095818780e+03,		1.062109341421855e+03,		1.062581182161930e+03,		1.063051627427172e+03,		1.063520686508464e+03,
		1.063988368600777e+03,		1.064454682804510e+03,		1.064919638126818e+03,		1.065383243482901e+03,		1.065845507697286e+03,
		1.066306439505077e+03,		1.066766047553185e+03,		1.067224340401538e+03,		1.067681326524266e+03,		1.068137014310875e+03,
		1.068591412067389e+03,		1.069044528017482e+03,		1.069496370303580e+03,		1.069946946987958e+03,		1.070396266053807e+03,
		1.070844335406289e+03,		1.071291162873570e+03,		1.071736756207840e+03,		1.072181123086314e+03,		1.072624271112214e+03,
		1.073066207815739e+03,		1.073506940655017e+03,		1.073946477017040e+03,		1.074384824218584e+03,		1.074821989507117e+03,
		1.075257980061687e+03,		1.075692802993803e+03,		1.076126465348294e+03,		1.076558974104155e+03,		1.076990336175388e+03,
		1.077420558411816e+03,		1.077849647599899e+03,		1.078277610463522e+03,		1.078704453664783e+03,		1.079130183804759e+03,
		1.079554807424267e+03,		1.079978331004610e+03,		1.080400760968312e+03,		1.080822103679838e+03,		1.081242365446308e+03,
		1.081661552518198e+03,		1.082079671088634e+03,		1.082496727299770e+03,		1.082912727234727e+03,		1.083327676924203e+03,
		1.083741582345591e+03,		1.084154449423627e+03,		1.084566284031015e+03,		1.084977091989049e+03,		1.085386879068221e+03,
		1.085795650988821e+03,		1.086203413421536e+03,		1.086610171988022e+03,		1.087015932261491e+03,		1.087420699767268e+03,
		1.087824479983352e+03,		1.088227278340965e+03,		1.088629100225097e+03,		1.089029950975031e+03,		1.089429835884879e+03,
		1.089828760204094e+03,		1.090226729137980e+03,		1.090623747848198e+03,		1.091019821453262e+03,		1.091414955029028e+03,
		1.091809153609170e+03,		1.092202422185666e+03,		1.092594765709254e+03,		1.092986189089905e+03,		1.093376697197269e+03,
		1.093766294861127e+03,		1.094154986871836e+03,		1.094542777980761e+03,		1.094929672900708e+03,		1.095315676306345e+03,
		1.095700792834622e+03,		1.096085027085185e+03,		1.096468383620779e+03,		1.096850866967651e+03,		1.097232481615947e+03,
		1.097613232020098e+03,		1.097993122599211e+03,		1.098372157737442e+03,		1.098750341784372e+03,		1.099127679055383e+03,
		1.099504173832013e+03,		1.099879830362319e+03,		1.100254652861235e+03,		1.100628645510917e+03,		1.101001812461089e+03,
		1.101374157829390e+03,		1.101745685701698e+03,		1.102116400132475e+03,		1.102486305145084e+03,		1.102855404732117e+03,
		1.103223702855714e+03,		1.103591203447872e+03,		1.103957910410766e+03,		1.104323827617044e+03,		1.104688958910136e+03,
		1.105053308104553e+03,		1.105416878986178e+03,		1.105779675312557e+03,		1.106141700813193e+03,		1.106502959189819e+03,
		1.106863454116687e+03,		1.107223189240838e+03,		1.107582168182379e+03,		1.107940394534751e+03,		1.108297871864992e+03,
		1.108654603714005e+03,		1.109010593596815e+03,		1.109365845002821e+03,		1.109720361396056e+03,		1.110074146215432e+03,
		1.110427202874987e+03,		1.110779534764131e+03,		1.111131145247882e+03,		1.111482037667111e+03,		1.111832215338767e+03,
		1.112181681556117e+03,		1.112530439588970e+03,		1.112878492683908e+03,		1.113225844064503e+03,		1.113572496931541e+03,
		1.113918454463241e+03,		1.114263719815471e+03,		1.114608296121957e+03,		1.114952186494495e+03,		1.115295394023160e+03,
		1.115637921776512e+03,		1.115979772801792e+03,		1.116320950125133e+03,		1.116661456751749e+03,		1.117001295666135e+03,
		1.117340469832259e+03,		1.117678982193754e+03,		1.118016835674104e+03,		1.118354033176839e+03,		1.118690577585704e+03,
		1.119026471764857e+03,		1.119361718559042e+03,		1.119696320793765e+03,		1.120030281275474e+03,		1.120363602791734e+03,
		1.120696288111392e+03,		1.121028339984754e+03,		1.121359761143753e+03,		1.121690554302107e+03,		1.122020722155494e+03,
		1.122350267381707e+03,		1.122679192640815e+03,		1.123007500575329e+03,		1.123335193810348e+03,		1.123662274953721e+03,
		1.123988746596201e+03,		1.124314611311591e+03,		1.124639871656899e+03,		1.124964530172487e+03,		1.125288589382211e+03,
		1.125612051793574e+03,		1.125934919897864e+03,		1.126257196170299e+03,		1.126578883070164e+03,		1.126899983040954e+03,
		1.127220498510506e+03,		1.127540431891140e+03,		1.127859785579789e+03,		1.128178561958133e+03,		1.128496763392731e+03,
		1.128814392235153e+03,		1.129131450822103e+03,		1.129447941475549e+03,		1.129763866502850e+03,		1.130079228196880e+03,
		1.130394028836148e+03,		1.130708270684921e+03,		1.131021955993349e+03,		1.131335086997577e+03,		1.131647665919865e+03,
		1.131959694968710e+03,		1.132271176338955e+03,		1.132582112211903e+03,		1.132892504755435e+03,		1.133202356124117e+03,
		1.133511668459315e+03,		1.133820443889298e+03,		1.134128684529353e+03,		1.134436392481887e+03,		1.134743569834879e+03,
		1.135050218668799e+03,		1.135356341046194e+03,		1.135661939019011e+03,		1.135967014626840e+03,		1.136271569897013e+03,
		1.136575606844703e+03,		1.136879127473021e+03,		1.137182133773120e+03,		1.137484627724285e+03,		1.137786611294031e+03,
		1.138088086438199e+03,		1.138389055101047e+03,		1.138689519215344e+03,		1.138989480702463e+03,		1.139288941472472e+03,
		1.139587903424219e+03,		1.139886368445427e+03,		1.140184338412781e+03,		1.140481815192013e+03,		1.140778800637989e+03,
		1.141075296594797e+03,		1.141371304895829e+03,		1.141666827363865e+03,		1.141961865811159e+03,		1.142256422039516e+03
	},
	{
		1.806871758410579e+00,		5.482116285206528e+00,		9.238173405606526e+00,		1.307973548746408e+01,		1.701194954063753e+01,
		2.104047976050723e+01,		2.517158147836714e+01,		2.941218916026585e+01,		3.377002184923359e+01,		3.825371045814212e+01,
		4.287295269730356e+01,		4.763870331842553e+01,		5.256341000939788e+01,		5.766130904199987e+01,		6.294880021863720e+01,
		6.844492868209741e+01,		7.417201321389106e+01,		8.015647922641188e+01,		8.642998404775446e+01,		9.303097002826229e+01,
		1.000068619106802e+02,		1.074172670901154e+02,		1.153387992846521e+02,		1.238726563562400e+02,		1.331571471100235e+02,
		1.433897777275131e+02,		1.548696271126429e+02,		1.680887059844505e+02,		1.839664206673586e+02,		2.046630306049247e+02,
		7.667172402518721e+02,		7.738683154133695e+02,		7.802888073880681e+02,		7.861384022385738e+02,		7.915266959520000e+02,
		7.965328132147361e+02,		8.012160837659638e+02,		8.056223271062266e+02,		8.097877788127219e+02,		8.137416608584496e+02,
		8.175079290547253e+02,		8.211064987845358e+02,		8.245541277226627e+02,		8.278650660317521e+02,		8.310515447096665e+02,
		8.341241487059552e+02,		8.370921063316439e+02,		8.399635167804230e+02,		8.427455311649520e+02,		8.454444981436333e+02,
		8.480660822131057e+02,		8.506153606860717e+02,		8.530969038229686e+02,		8.555148415792379e+02,		8.578729195552592e+02,
		8.601745462305490e+02,		8.624228330608457e+02,		8.646206287119800e+02,		8.667705484389603e+02,		8.688749994223756e+02,
		8.709362027134185e+02,		8.729562123309769e+02,		8.749369319384772e+02,		8.768801294677427e+02,		8.787874499867149e+02,
		8.806604270604338e+02,		8.825004928139078e+02,		8.843089868722736e+02,		8.860871643264170e+02,		8.878362028497974e+02,
		8.895572090749447e+02,		8.912512243149976e+02,		8.929192297212305e+02,		8.945621509312015e+02,		8.961808622689142e+02,
		8.977761905625000e+02,		8.993489185938037e+02,		9.008997882483269e+02,		9.024295033810058e+02,		9.039387324332034e+02,
		9.054281108258764e+02,		9.068982431516554e+02,		9.083497051858434e+02,		9.097830457359597e+02,		9.111987883375369e+02,
		9.125974328263027e+02,		9.139794567811156e+02,		9.153453168605221e+02,		9.166954500387392e+02,		9.180302747505682e+02,
		9.193501919532349e+02,		9.206555861123380e+02,		9.219468261183679e+02,		9.232242661396069e+02,		9.244882464166958e+02,
		9.257390940035970e+02,		9.269771234592861e+02,		9.282026374940722e+02,		9.294159275740793e+02,		9.306172744871448e+02,
		9.318069488730449e+02,		9.329852117227114e+02,		9.341523148389333e+02,		9.353085012824455e+02,		9.364540057797800e+02,
		9.375890551121029e+02,		9.387138684804668e+02,		9.398286578499702e+02,		9.409336282743301e+02,		9.420289782021730e+02,
		9.431148997662857e+02,		9.441915790569550e+02,		9.452591963804493e+02,		9.463179265036032e+02,		9.473679388854073e+02,
		9.484093978964246e+02,		9.494424630267949e+02,		9.504672890835510e+02,		9.514840263778943e+02,		9.524928209030481e+02,
		9.534938145032504e+02,		9.544871450344268e+02,		9.554729465158738e+02,		9.564513492804613e+02,		9.574224801057551e+02,
		9.583864623510891e+02,		9.593434160820096e+02,		9.602934581902169e+02,		9.612367025080052e+02,		9.621732599174881e+02,
		9.631032384549200e+02,		9.640267434103505e+02,		9.649438774228876e+02,		9.658547405717741e+02,		9.667594304635319e+02,
		9.676580423153507e+02,		9.685506690349273e+02,		9.694374012969361e+02,		9.703183276163063e+02,		9.711935344184501e+02,
		9.720631061066215e+02,		9.729271251265119e+02,		9.737856720282591e+02,		9.746388255259574e+02,		9.754866625548094e+02,
		9.763292583260397e+02,		9.771666863796454e+02,		9.779990186351249e+02,		9.788263254402455e+02,		9.796486756179628e+02,
		9.804661365115638e+02,		9.812787740281218e+02,		9.820866526803345e+02,		9.828898356268215e+02,		9.836883847109465e+02,
		9.844823604982316e+02,		9.852718223124278e+02,		9.860568282702875e+02,		9.868374353151160e+02,		9.876136992491313e+02,
		9.883856747647031e+02,		9.891534154745046e+02,		9.899169739406228e+02,		9.906764017026866e+02,		9.914317493050260e+02,
		9.921830663229332e+02,		9.929304013880325e+02,		9.936738022129031e+02,		9.944133156144499e+02,		9.951489875374045e+02,
		9.958808630761503e+02,		9.966089864963084e+02,		9.973334012555415e+02,		9.980541500236895e+02,		9.987712747022747e+02,
		9.994848164433971e+02,		1.000194815668027e+03,		1.000901312083755e+03,		1.001604344701969e+03,		1.002303951854530e+03,
		1.003000171209928e+03,		1.003693039788959e+03,		1.004382593979922e+03,		1.005068869553381e+03,		1.005751901676469e+03,
		1.006431724926788e+03,		1.007108373305904e+03,		1.007781880252434e+03,		1.008452278654775e+03,		1.009119600863457e+03,
		1.009783878703147e+03,		1.010445143484316e+03,		1.011103426014574e+03,		1.011758756609690e+03,		1.012411165104304e+03,
		1.013060680862353e+03,		1.013707332787189e+03,		1.014351149331448e+03,		1.014992158506631e+03,		1.015630387892433e+03,
		1.016265864645827e+03,		1.016898615509897e+03,		1.017528666822443e+03,		1.018156044524357e+03,		1.018780774167782e+03,
		1.019402880924051e+03,		1.020022389591431e+03,		1.020639324602661e+03,		1.021253710032298e+03,		1.021865569603873e+03,
		1.022474926696871e+03,		1.023081804353534e+03,		1.023686225285490e+03,		1.024288211880222e+03,		1.024887786207368e+03,
		1.025484970024876e+03,		1.026079784785002e+03,		1.026672251640162e+03,		1.027262391448645e+03,		1.027850224780184e+03,
		1.028435771921393e+03,		1.029019052881085e+03,		1.029600087395443e+03,		1.030178894933089e+03,		1.030755494700022e+03,
		1.031329905644445e+03,		1.031902146461478e+03,		1.032472235597759e+03,		1.033040191255948e+03,		1.033606031399116e+03,
		1.034169773755044e+03,		1.034731435820417e+03,		1.035291034864925e+03,		1.035848587935275e+03,		1.036404111859114e+03,
		1.036957623248852e+03,		1.037509138505420e+03,		1.038058673821929e+03,		1.038606245187256e+03,		1.039151868389552e+03,
		1.039695559019667e+03,		1.040237332474512e+03,		1.040777203960336e+03,		1.041315188495946e+03,		1.041851300915842e+03,
		1.042385555873305e+03,		1.042917967843398e+03,		1.043448551125929e+03,		1.043977319848322e+03,		1.044504287968457e+03,
		1.045029469277431e+03,		1.045552877402270e+03,		1.046074525808590e+03,		1.046594427803186e+03,		1.047112596536590e+03,
		1.047629045005561e+03,		1.048143786055536e+03,		1.048656832383016e+03,		1.049168196537928e+03,		1.049677890925911e+03,
		1.050185927810585e+03,		1.050692319315750e+03,		1.051197077427564e+03,		1.051700213996659e+03,		1.052201740740229e+03,
		1.052701669244067e+03,		1.053200010964579e+03,		1.053696777230733e+03,		1.054191979246000e+03,		1.054685628090235e+03,
		1.055177734721531e+03,		1.055668309978042e+03,		1.056157364579763e+03,		1.056644909130282e+03,		1.057130954118497e+03,
		1.057615509920303e+03,		1.058098586800245e+03,		1.058580194913139e+03,		1.059060344305672e+03,		1.059539044917959e+03,
		1.060016306585087e+03,		1.060492139038610e+03,		1.060966551908045e+03,		1.061439554722309e+03,		1.061911156911162e+03,
		1.062381367806596e+03,		1.062850196644221e+03,		1.063317652564607e+03,		1.063783744614622e+03,		1.064248481748731e+03,
		1.064711872830277e+03,		1.065173926632744e+03,		1.065634651840990e+03,		1.066094057052466e+03,		1.066552150778406e+03,
		1.067008941445004e+03,		1.067464437394568e+03,		1.067918646886651e+03,		1.068371578099167e+03,		1.068823239129488e+03,
		1.069273637995516e+03,		1.069722782636747e+03,		1.070170680915307e+03,		1.070617340616978e+03,		1.071062769452204e+03,
		1.071506975057080e+03,		1.071949964994323e+03,		1.072391746754232e+03,		1.072832327755628e+03,		1.073271715346777e+03,
		1.073709916806304e+03,		1.074146939344087e+03,		1.074582790102136e+03,		1.075017476155464e+03,		1.075451004512936e+03,
		1.075883382118110e+03,		1.076314615848640e+03,		1.076744712522891e+03,		1.077173678891851e+03,		1.077601521645969e+03,
		1.078028247414390e+03,		1.078453862765707e+03,		1.078878374208717e+03,		1.079301788193158e+03,		1.079724111110433e+03,
		1.080145349294334e+03,		1.080565509021732e+03,		1.080984596513286e+03,		1.081402617934116e+03,		1.081819579394475e+03,
		1.082235486950419e+03,		1.082650346604452e+03,		1.083064164306168e+03,		1.083476945952886e+03,		1.083888697390274e+03,
		1.084299424412960e+03,		1.084709132765133e+03,		1.085117828141145e+03,		1.085525516186092e+03,		1.085932202496396e+03,
		1.086337892620367e+03,		1.086742592058770e+03,		1.087146306265379e+03,		1.087549040647508e+03,		1.087950800566566e+03,
		1.088351591338570e+03,		1.088751418234674e+03,		1.089150286481682e+03,		1.089548201262546e+03,		1.089945167716874e+03,
		1.090341190941418e+03,		1.090736275990554e+03,		1.091130427876766e+03,		1.091523651571113e+03,		1.091915952003693e+03,
		1.092307334064100e+03,		1.092697802601877e+03,		1.093087362426959e+03,		1.093476018310111e+03,		1.093863774983358e+03,
		1.094250637140419e+03,		1.094636609437118e+03,		1.095021696491803e+03,		1.095405902885755e+03,		1.095789233163589e+03,
		1.096171691833653e+03,		1.096553283368420e+03,		1.096934012204873e+03,		1.097313882744888e+03,		1.097692899355612e+03,
		1.098071066369829e+03,		1.098448388086332e+03,		1.098824868770280e+03,		1.099200512653556e+03,		1.099575323935119e+03,
		1.099949306781351e+03,		1.100322465326397e+03,		1.100694803672506e+03,		1.101066325890363e+03,		1.101437036019415e+03,
		1.101806938068203e+03,		1.102176036014672e+03,		1.102544333806496e+03,		1.102911835361388e+03,		1.103278544567402e+03,
		1.103644465283246e+03,		1.104009601338574e+03,		1.104373956534288e+03,		1.104737534642827e+03,		1.105100339408457e+03,
		1.105462374547554e+03,		1.105823643748890e+03,		1.106184150673901e+03,		1.106543898956974e+03,		1.106902892205707e+03,
		1.107261134001182e+03,		1.107618627898227e+03,		1.107975377425674e+03,		1.108331386086625e+03,		1.108686657358692e+03,
		1.109041194694264e+03,		1.109395001520739e+03,		1.109748081240784e+03,		1.110100437232564e+03,		1.110452072849987e+03,
		1.110802991422938e+03,		1.111153196257516e+03,		1.111502690636257e+03,		1.111851477818364e+03,		1.112199561039937e+03,
		1.112546943514184e+03,		1.112893628431650e+03,		1.113239618960429e+03,		1.113584918246376e+03,		1.113929529413324e+03,
		1.114273455563285e+03,		1.114616699776662e+03,		1.114959265112453e+03,		1.115301154608447e+03,		1.115642371281428e+03,
		1.115982918127371e+03,		1.116322798121631e+03,		1.116662014219145e+03,		1.117000569354610e+03,		1.117338466442680e+03,
		1.117675708378146e+03,		1.118012298036119e+03,		1.118348238272216e+03,		1.118683531922734e+03,		1.119018181804827e+03,
		1.119352190716684e+03,		1.119685561437699e+03,		1.120018296728643e+03,		1.120350399331831e+03,		1.120681871971293e+03,
		1.121012717352934e+03,		1.121342938164701e+03,		1.121672537076742e+03,		1.122001516741565e+03,		1.122329879794200e+03,
		1.122657628852349e+03,		1.122984766516541e+03,		1.123311295370293e+03,		1.123637217980245e+03,		1.123962536896323e+03,
		1.124287254651882e+03,		1.124611373763845e+03,		1.124934896732860e+03,		1.125257826043429e+03,		1.125580164164060e+03,
		1.125901913547398e+03,		1.126223076630369e+03,		1.126543655834311e+03,		1.126863653565114e+03,		1.127183072211732e+03,
		1.127501914152980e+03,		1.127820181747357e+03,		1.128137877340271e+03,		1.128455003262331e+03,		1.128771561829474e+03,
		1.129087555343091e+03,		1.129402986090148e+03,		1.129717856343311e+03,		1.130032168361065e+03,		1.130345924387835e+03,
		1.130659126654102e+03,		1.130971777376524e+03,		1.131283878758049e+03,		1.131595432988030e+03,		1.131906442242339e+03,
		1.132216908683480e+03,		1.132526834460698e+03,		1.132836221710089e+03,		1.133145072554715e+03,		1.133453389104701e+03,
		1.133761173457350e+03,		1.134068427697242e+03,		1.134375153896347e+03,		1.134681354114120e+03,		1.134987030397605e+03,
		1.135292184781540e+03,		1.135596819288451e+03,		1.135900935928759e+03,		1.136204536700869e+03,		1.136507623591273e+03,
		1.136810198574645e+03,		1.137112263613937e+03,		1.137413820660469e+03,		1.137714871654023e+03,		1.138015418522943e+03,
		1.138315463184217e+03,		1.138615007543568e+03,		1.138914053495552e+03,		1.139212602923636e+03,		1.139510657700293e+03,
		1.139808219687084e+03,		1.140105290734747e+03,		1.140401872683284e+03,		1.140697967362036e+03,		1.140993576589779e+03
	},
	{
		1.803115726469472e+00,		5.470317629975724e+00,		9.217571310350412e+00,		1.304948377251519e+01,		1.697110402196703e+01,
		2.098798321392192e+01,		2.510624564567089e+01,		2.933267307241169e+01,		3.367480552502603e+01,		3.814106274319422e+01,
		4.274089160402145e+01,		4.748494666494489e+01,		5.238531335937881e+01,		5.745578680294201e+01,		6.271222408185023e+01,
		6.817299508787536e+01,		7.385956771114643e+01,		7.979727963016452e+01,		8.601637470362964e+01,		9.255342356818878e+01,
		9.945331747435922e+01,		1.067721447813656e+02,		1.145814778143975e+02,		1.229750150643269e+02,		1.320793739538490e+02,
		1.420727038708515e+02,		1.532193575136601e+02,		1.659415769000711e+02,		1.809918907995987e+02,		1.999832644846485e+02,
		7.567758559086237e+02,		7.648243907064866e+02,		7.719288934817483e+02,		7.783230414318361e+02,		7.841585327854445e+02,
		7.895405731828113e+02,		7.945456729356068e+02,		7.992315114201394e+02,		8.036428197256653e+02,		8.078150911501493e+02,
		8.117770280621256e+02,		8.155522150078486e+02,		8.191602977788529e+02,		8.226178358053697e+02,		8.259389320532101e+02,
		8.291357074577315e+02,		8.322186642940102e+02,		8.351969686388364e+02,		8.380786728548051e+02,		8.408708929352518e+02,
		8.435799513747278e+02,		8.462114934148623e+02,		8.487705824403629e+02,		8.512617789294499e+02,		8.536892062683207e+02,
		8.560566059989021e+02,		8.583673844919439e+02,		8.606246526132173e+02,		8.628312596082519e+02,		8.649898222199276e+02,
		8.671027498061045e+02,		8.691722661189647e+02,		8.712004282647792e+02,		8.731891432755148e+02,		8.751401826474512e+02,
		8.770551951413663e+02,		8.789357180912696e+02,		8.807831874218530e+02,		8.825989465589071e+02,		8.843842543670220e+02,
		8.861402922466266e+02,		8.878681704936600e+02,		8.895689340128713e+02,		8.912435674625855e+02,		8.928929998979942e+02,
		8.945181089708591e+02,		8.961197247358774e+02,		8.976986331073020e+02,		8.992555790070282e+02,		9.007912692242131e+02,
		9.023063750418252e+02,		9.038015346267553e+02,		9.052773552247894e+02,		9.067344151739159e+02,		9.081732657545807e+02,
		9.095944328925766e+02,		9.109984187285845e+02,		9.123857030666884e+02,		9.137567447130542e+02,		9.151119827146034e+02,
		9.164518375066240e+02,		9.177767119772493e+02,		9.190869924559817e+02,		9.203830496340228e+02,		9.216652394158099e+02,
		9.229339037207058e+02,		9.241893712236009e+02,		9.254319580494471e+02,		9.266619684217408e+02,		9.278796952691126e+02,
		9.290854207932471e+02,		9.302794170010557e+02,		9.314619462038318e+02,		9.326332614857851e+02,		9.337936071442180e+02,
		9.349432191034094e+02,		9.360823253040495e+02,		9.372111460699791e+02,		9.383298944537979e+02,		9.394387765628015e+02,
		9.405379918665959e+02,		9.416277334875925e+02,		9.427081884755652e+02,		9.437795380672720e+02,		9.448419579321516e+02,
		9.458956184049557e+02,		9.469406847061805e+02,		9.479773171510333e+02,		9.490056713476740e+02,		9.500258983853689e+02,
		9.510381450131925e+02,		9.520425538098310e+02,		9.530392633450234e+02,		9.540284083331392e+02,		9.550101197793432e+02,
		9.559845251177672e+02,		9.569517483483276e+02,		9.579119101565568e+02,		9.588651280387126e+02,		9.598115164155961e+02,
		9.607511867423284e+02,		9.616842476132006e+02,		9.626108048618324e+02,		9.635309616569167e+02,		9.644448185937736e+02,
		9.653524737819312e+02,		9.662540229289466e+02,		9.671495594206617e+02,		9.680391743980675e+02,		9.689229568309562e+02,
		9.698009935885258e+02,		9.706733695070816e+02,		9.715401674549779e+02,		9.724014683949435e+02,		9.732573514439113e+02,
		9.741078939304691e+02,		9.749531714500595e+02,		9.757932579180157e+02,		9.766282256205557e+02,		9.774581452638052e+02,
		9.782830860209718e+02,		9.791031155777256e+02,		9.799183001758829e+02,		9.807287046554724e+02,		9.815343924952433e+02,
		9.823354258516971e+02,		9.831318655967044e+02,		9.839237713537602e+02,		9.847112015329532e+02,		9.854942133646864e+02,
		9.862728629322230e+02,		9.870472052030796e+02,		9.878172940594758e+02,		9.885831823270777e+02,		9.893449218040806e+02,
		9.901025632879670e+02,		9.908561566020406e+02,		9.916057506209409e+02,		9.923513932953139e+02,		9.930931316756573e+02,
		9.938310119354053e+02,		9.945650793932400e+02,		9.952953785347108e+02,		9.960219530331376e+02,		9.967448457698606e+02,
		9.974640988538530e+02,		9.981797536407072e+02,		9.988918507510443e+02,		9.996004300883380e+02,		1.000305530856206e+03,
		1.001007191575160e+03,		1.001705450098856e+03,		1.002400343629854e+03,		1.003091908734897e+03,		1.003780181359752e+03,
		1.004465196843594e+03,		1.005146989932978e+03,		1.005825594795408e+03,		1.006501045032493e+03,		1.007173373692748e+03,
		1.007842613284010e+03,		1.008508795785509e+03,		1.009171952659596e+03,		1.009832114863141e+03,		1.010489312858609e+03,
		1.011143576624839e+03,		1.011794935667507e+03,		1.012443419029325e+03,		1.013089055299939e+03,		1.013731872625572e+03,
		1.014371898718406e+03,		1.015009160865708e+03,		1.015643685938715e+03,		1.016275500401284e+03,		1.016904630318311e+03,
		1.017531101363936e+03,		1.018154938829527e+03,		1.018776167631460e+03,		1.019394812318698e+03,		1.020010897080179e+03,
		1.020624445752014e+03,		1.021235481824496e+03,		1.021844028448945e+03,		1.022450108444369e+03,		1.023053744303969e+03,
		1.023654958201476e+03,		1.024253771997332e+03,		1.024850207244728e+03,		1.025444285195480e+03,		1.026036026805777e+03,
		1.026625452741779e+03,		1.027212583385086e+03,		1.027797438838078e+03,		1.028380038929127e+03,		1.028960403217672e+03,
		1.029538550999207e+03,		1.030114501310111e+03,		1.030688272932405e+03,		1.031259884398367e+03,		1.031829353995059e+03,
		1.032396699768748e+03,		1.032961939529218e+03,		1.033525090853990e+03,		1.034086171092447e+03,		1.034645197369869e+03,
		1.035202186591363e+03,		1.035757155445724e+03,		1.036310120409207e+03,		1.036861097749194e+03,		1.037410103527821e+03,
		1.037957153605479e+03,		1.038502263644280e+03,		1.039045449111419e+03,		1.039586725282481e+03,		1.040126107244669e+03,
		1.040663609899965e+03,		1.041199247968221e+03,		1.041733035990191e+03,		1.042264988330491e+03,		1.042795119180508e+03,
		1.043323442561234e+03,		1.043849972326055e+03,		1.044374722163471e+03,		1.044897705599768e+03,		1.045418936001630e+03,
		1.045938426578706e+03,		1.046456190386108e+03,		1.046972240326879e+03,		1.047486589154397e+03,		1.047999249474735e+03,
		1.048510233748975e+03,		1.049019554295478e+03,		1.049527223292099e+03,		1.050033252778373e+03,		1.050537654657647e+03,
		1.051040440699174e+03,		1.051541622540164e+03,		1.052041211687804e+03,		1.052539219521226e+03,		1.053035657293445e+03,
		1.053530536133260e+03,		1.054023867047117e+03,		1.054515660920935e+03,		1.055005928521902e+03,		1.055494680500228e+03,
		1.055981927390884e+03,		1.056467679615282e+03,		1.056951947482947e+03,		1.057434741193148e+03,		1.057916070836493e+03,
		1.058395946396510e+03,		1.058874377751185e+03,		1.059351374674480e+03,		1.059826946837819e+03,		1.060301103811551e+03,
		1.060773855066379e+03,		1.061245209974779e+03,		1.061715177812373e+03,		1.062183767759294e+03,		1.062650988901521e+03,
		1.063116850232185e+03,		1.063581360652861e+03,		1.064044528974836e+03,		1.064506363920345e+03,		1.064966874123801e+03,
		1.065426068132987e+03,		1.065883954410244e+03,		1.066340541333623e+03,		1.066795837198031e+03,		1.067249850216344e+03,
		1.067702588520517e+03,		1.068154060162656e+03,		1.068604273116088e+03,		1.069053235276408e+03,		1.069500954462503e+03,
		1.069947438417566e+03,		1.070392694808669e+03,		1.070836731233549e+03,		1.071279555212660e+03,		1.071721174196195e+03,
		1.072161595563465e+03,		1.072600826623810e+03,		1.073038874617501e+03,		1.073475746716621e+03,		1.073911450025945e+03,
		1.074345991583788e+03,		1.074779378362851e+03,		1.075211617271053e+03,		1.075642715152345e+03,		1.076072678787515e+03,
		1.076501514894976e+03,		1.076929230131545e+03,		1.077355831093214e+03,		1.077781324315894e+03,		1.078205716276166e+03,
		1.078629013392006e+03,		1.079051222023508e+03,		1.079472348473585e+03,		1.079892398988675e+03,		1.080311379759421e+03,
		1.080729296921351e+03,		1.081146156555535e+03,		1.081561964689252e+03,		1.081976727296625e+03,		1.082390450299263e+03,
		1.082803139566882e+03,		1.083214800917927e+03,		1.083625440120173e+03,		1.084035062891326e+03,		1.084443674899613e+03,
		1.084851281764362e+03,		1.085257889056572e+03,		1.085663502299478e+03,		1.086068126969105e+03,		1.086471768494816e+03,
		1.086874432259849e+03,		1.087276123601850e+03,		1.087676847813397e+03,		1.088076610142511e+03,		1.088475415793169e+03,
		1.088873269925805e+03,		1.089270177657798e+03,		1.089666144063967e+03,		1.090061174177042e+03,		1.090455272988146e+03,
		1.090848445447250e+03,		1.091240696463645e+03,		1.091632030906387e+03,		1.092022453604742e+03,		1.092411969348635e+03,
		1.092800582889077e+03,		1.093188298938595e+03,		1.093575122171656e+03,		1.093961057225080e+03,		1.094346108698455e+03,
		1.094730281154539e+03,		1.095113579119660e+03,		1.095496007084111e+03,		1.095877569502534e+03,		1.096258270794314e+03,
		1.096638115343942e+03,		1.097017107501403e+03,		1.097395251582532e+03,		1.097772551869384e+03,		1.098149012610590e+03,
		1.098524638021710e+03,		1.098899432285581e+03,		1.099273399552663e+03,		1.099646543941376e+03,		1.100018869538439e+03,
		1.100390380399194e+03,		1.100761080547936e+03,		1.101130973978236e+03,		1.101500064653258e+03,		1.101868356506067e+03,
		1.102235853439950e+03,		1.102602559328707e+03,		1.102968478016966e+03,		1.103333613320469e+03,		1.103697969026375e+03,
		1.104061548893544e+03,		1.104424356652825e+03,		1.104786396007341e+03,		1.105147670632761e+03,		1.105508184177586e+03,
		1.105867940263410e+03,		1.106226942485197e+03,		1.106585194411542e+03,		1.106942699584931e+03,		1.107299461522005e+03,
		1.107655483713810e+03,		1.108010769626052e+03,		1.108365322699347e+03,		1.108719146349463e+03,		1.109072243967565e+03,
		1.109424618920456e+03,		1.109776274550811e+03,		1.110127214177416e+03,		1.110477441095391e+03,		1.110826958576426e+03,
		1.111175769869004e+03,		1.111523878198622e+03,		1.111871286768013e+03,		1.112217998757361e+03,		1.112564017324521e+03,
		1.112909345605224e+03,		1.113253986713294e+03,		1.113597943740849e+03,		1.113941219758510e+03,		1.114283817815600e+03,
		1.114625740940346e+03,		1.114966992140077e+03,		1.115307574401416e+03,		1.115647490690477e+03,		1.115986743953051e+03,
		1.116325337114800e+03,		1.116663273081437e+03,		1.117000554738912e+03,		1.117337184953600e+03,		1.117673166572471e+03,
		1.118008502423273e+03,		1.118343195314707e+03,		1.118677248036599e+03,		1.119010663360075e+03,		1.119343444036130e+03,
		1.119675592802397e+03,		1.120007112373072e+03,		1.120338005446149e+03,		1.120668274701750e+03,		1.120997922802285e+03,
		1.121326952392606e+03,		1.121655366100168e+03,		1.121983166535183e+03,		1.122310356290773e+03,		1.122636937943117e+03,
		1.122962914051609e+03,		1.123288287159000e+03,		1.123613059791543e+03,		1.123937234459146e+03,		1.124260813655506e+03,
		1.124583799858254e+03,		1.124906195529098e+03,		1.125228003113955e+03,		1.125549225043096e+03,		1.125869863731272e+03,
		1.126189921577857e+03,		1.126509400966977e+03,		1.126828304267636e+03,		1.127146633833855e+03,		1.127464392004792e+03,
		1.127781581104875e+03,		1.128098203443922e+03,		1.128414261317271e+03,		1.128729757005897e+03,		1.129044692776538e+03,
		1.129359070881812e+03,		1.129672893560339e+03,		1.129986163036855e+03,		1.130298881522331e+03,		1.130611051214089e+03,
		1.130922674295913e+03,		1.131233752938164e+03,		1.131544289297889e+03,		1.131854285518935e+03,		1.132163743732057e+03,
		1.132472666055023e+03,		1.132781054592727e+03,		1.133088911437289e+03,		1.133396238669249e+03,		1.133703038352734e+03,
		1.134009312544133e+03,		1.134315063285409e+03,		1.134620292606292e+03,		1.134925002524382e+03,		1.135229195045220e+03,
		1.135532872162501e+03,		1.135836035857917e+03,		1.136138688101483e+03,		1.136440830851517e+03,		1.136742466054753e+03,
		1.137043595646432e+03,		1.137344221550399e+03,		1.137644345679193e+03,		1.137943969934130e+03,		1.138243096205401e+03,
		1.138541726372152e+03,		1.138839862302580e+03,		1.139137505854012e+03,		1.139434658872991e+03,		1.139731323195366e+03
	},
	{
		1.799375564757625e+00,		5.458572432056656e+00,		9.197069227499139e+00,		1.301938931863135e+01,		1.693048580974243e+01,
		2.093579939283014e+01,		2.504132650696998e+01,		2.925370013517251e+01,		3.358028621500220e+01,		3.802929950285242e+01,
		4.260994389757079e+01,		4.733258382261886e+01,		5.220895547382313e+01,		5.725242984460363e+01,		6.247834387826583e+01,
		6.790442255419326e+01,		7.355132429854561e+01,		7.944335665109764e+01,		8.560943173377501e+01,		9.208436722875052e+01,
		9.891069826470653e+01,		1.061412677941867e+02,		1.138430455444084e+02,		1.221029682558145e+02,		1.310372768801599e+02,
		1.408072912532769e+02,		1.516480081855885e+02,		1.639250503441421e+02,		1.782641323433128e+02,		1.959124978233216e+02,
		7.457848138557841e+02,		7.550187042139078e+02,		7.629816383855687e+02,		7.700360574699288e+02,		7.764004116253248e+02,
		7.822186711408768e+02,		7.875916879434975e+02,		7.925933312369591e+02,		7.972795884508919e+02,		8.016940610320537e+02,
		8.058714634997212e+02,		8.098399475971022e+02,		8.136227006433605e+02,		8.172390772013205e+02,		8.207054204074769e+02,
		8.240356709297193e+02,		8.272418269518082e+02,		8.303342973537758e+02,		8.333221768763387e+02,		8.362134632925120e+02,
		8.390152308177933e+02,		8.417337700582893e+02,		8.443747020330499e+02,		8.469430718926598e+02,		8.494434265708873e+02,
		8.518798795932114e+02,		8.542561655473129e+02,		8.565756861416578e+02,		8.588415493866692e+02,		8.610566031047915e+02,
		8.632234637364148e+02,		8.653445412197692e+02,		8.674220605755270e+02,		8.694580807148652e+02,		8.714545108778952e+02,
		8.734131250817018e+02,		8.753355748348739e+02,		8.772234003812146e+02,		8.790780406681612e+02,		8.809008422117444e+02,
		8.826930670026021e+02,		8.844558995757567e+02,		8.861904533486991e+02,		8.878977763212820e+02,		8.895788561987539e+02,
		8.912346250344592e+02,		8.928659634166828e+02,		8.944737042703778e+02,		8.960586363098051e+02,		8.976215071809517e+02,
		8.991630263268088e+02,		9.006838676044977e+02,		9.021846716797576e+02,		9.036660482212860e+02,		9.051285779147780e+02,
		9.065728143142583e+02,		9.079992855476307e+02,		9.094084958841628e+02,		9.108009271891266e+02,		9.121770402618847e+02,
		9.135372760770369e+02,		9.148820569340260e+02,		9.162117875236281e+02,		9.175268559185304e+02,		9.188276344943870e+02,
		9.201144807871832e+02,		9.213877382921445e+02,		9.226477372089553e+02,		9.238947951375551e+02,		9.251292177284568e+02,
		9.263512992910929e+02,		9.275613233634518e+02,		9.287595632459229e+02,		9.299462825020348e+02,		9.311217354285483e+02,
		9.322861674971226e+02,		9.334398157701919e+02,		9.345829092894451e+02,		9.357156694475733e+02,		9.368383103325746e+02,
		9.379510390556012e+02,		9.390540560595371e+02,		9.401475554114963e+02,		9.412317250771024e+02,		9.423067471821074e+02,
		9.433727982588264e+02,		9.444300494797403e+02,		9.454786668788277e+02,		9.465188115614310e+02,		9.475506399033218e+02,
		9.485743037396825e+02,		9.495899505445715e+02,		9.505977236014774e+02,		9.515977621654698e+02,		9.525902016174613e+02,
		9.535751736110301e+02,		9.545528062110687e+02,		9.555232240318564e+02,		9.564865483564290e+02,		9.574428972629855e+02,
		9.583923857390413e+02,		9.593351257917161e+02,		9.602712265530762e+02,		9.612007943807686e+02,		9.621239329542138e+02,
		9.630407433665998e+02,		9.639513242128800e+02,		9.648557716739990e+02,		9.657541795975319e+02,		9.666466395749187e+02,
		9.675332410154833e+02,		9.684140712173735e+02,		9.692892154355931e+02,		9.701587569472680e+02,		9.710227771142750e+02,
		9.718813554433654e+02,		9.727345696439000e+02,		9.735824956833266e+02,		9.744252078404713e+02,		9.752627787567927e+02,
		9.760952794856504e+02,		9.769227795397110e+02,		9.777453469365557e+02,		9.785630482425869e+02,		9.793759486153039e+02,
		9.801841118440151e+02,		9.809876003890665e+02,		9.817864754198373e+02,		9.825807968503943e+02,		9.833706233758578e+02,
		9.841560125054569e+02,		9.849370205954438e+02,		9.857137028806587e+02,		9.864861135050061e+02,		9.872543055508651e+02,
		9.880183310675086e+02,		9.887782410985619e+02,		9.895340857085226e+02,		9.902859140084099e+02,		9.910337741805550e+02,
		9.917777135025789e+02,		9.925177783705791e+02,		9.932540143215759e+02,		9.939864660552259e+02,		9.947151774548363e+02,
		9.954401916077278e+02,		9.961615508249312e+02,		9.968792966602911e+02,		9.975934699289481e+02,		9.983041107252774e+02,
		9.990112584402498e+02,		9.997149517782768e+02,		1.000415228773547e+03,		1.001112126805856e+03,		1.001805682615979e+03,
		1.002495932320574e+03,		1.003182911426650e+03,		1.003866654845606e+03,		1.004547196906869e+03,		1.005224571371123e+03,
		1.005898811443171e+03,		1.006569949784415e+03,		1.007238018524993e+03,		1.007903049275565e+03,		1.008565073138769e+03,
		1.009224120720356e+03,		1.009880222140019e+03,		1.010533407041923e+03,		1.011183704604938e+03,		1.011831143552604e+03,
		1.012475752162814e+03,		1.013117558277254e+03,		1.013756589310560e+03,		1.014392872259265e+03,		1.015026433710485e+03,
		1.015657299850386e+03,		1.016285496472423e+03,		1.016911048985373e+03,		1.017533982421154e+03,		1.018154321442440e+03,
		1.018772090350090e+03,		1.019387313090377e+03,		1.020000013262043e+03,		1.020610214123169e+03,		1.021217938597877e+03,
		1.021823209282867e+03,		1.022426048453783e+03,		1.023026478071431e+03,		1.023624519787844e+03,		1.024220194952189e+03,
		1.024813524616544e+03,		1.025404529541529e+03,		1.025993230201797e+03,		1.026579646791407e+03,		1.027163799229051e+03,
		1.027745707163176e+03,		1.028325389976976e+03,		1.028902866793260e+03,		1.029478156479226e+03,		1.030051277651106e+03,
		1.030622248678711e+03,		1.031191087689877e+03,		1.031757812574795e+03,		1.032322440990263e+03,		1.032884990363821e+03,
		1.033445477897805e+03,		1.034003920573316e+03,		1.034560335154076e+03,		1.035114738190228e+03,		1.035667146022040e+03,
		1.036217574783515e+03,		1.036766040405943e+03,		1.037312558621368e+03,		1.037857144965965e+03,		1.038399814783376e+03,
		1.038940583227940e+03,		1.039479465267881e+03,		1.040016475688415e+03,		1.040551629094782e+03,		1.041084939915246e+03,
		1.041616422403994e+03,		1.042146090644001e+03,		1.042673958549826e+03,		1.043200039870345e+03,		1.043724348191444e+03,
		1.044246896938635e+03,		1.044767699379640e+03,		1.045286768626900e+03,		1.045804117640064e+03,		1.046319759228388e+03,
		1.046833706053125e+03,		1.047345970629839e+03,		1.047856565330689e+03,		1.048365502386659e+03,		1.048872793889752e+03,
		1.049378451795128e+03,		1.049882487923218e+03,		1.050384913961783e+03,		1.050885741467935e+03,		1.051384981870125e+03,
		1.051882646470088e+03,		1.052378746444754e+03,		1.052873292848116e+03,		1.053366296613070e+03,		1.053857768553218e+03,
		1.054347719364631e+03,		1.054836159627595e+03,		1.055323099808300e+03,		1.055808550260521e+03,		1.056292521227257e+03,
		1.056775022842332e+03,		1.057256065131988e+03,		1.057735658016425e+03,		1.058213811311334e+03,		1.058690534729380e+03,
		1.059165837881684e+03,		1.059639730279252e+03,		1.060112221334402e+03,		1.060583320362142e+03,		1.061053036581547e+03,
		1.061521379117097e+03,		1.061988356999990e+03,		1.062453979169442e+03,		1.062918254473957e+03,		1.063381191672573e+03,
		1.063842799436098e+03,		1.064303086346915e+03,		1.064762060905872e+03,		1.065219731524691e+03,		1.065676106533093e+03,
		1.066131194178395e+03,		1.066585002626611e+03,		1.067037539963540e+03,		1.067488814195837e+03,		1.067938833252067e+03,
		1.068387604983729e+03,		1.068835137166282e+03,		1.069281437500139e+03,		1.069726513611653e+03,		1.070170373054076e+03,
		1.070613023308519e+03,		1.071054471784883e+03,		1.071494725822773e+03,		1.071933792692413e+03,		1.072371679595524e+03,
		1.072808393666212e+03,		1.073243941971816e+03,		1.073678331513766e+03,		1.074111569228410e+03,		1.074543661987839e+03,
		1.074974616600688e+03,		1.075404439812939e+03,		1.075833138308697e+03,		1.076260718710957e+03,		1.076687187582371e+03,
		1.077112551425986e+03,		1.077536816685978e+03,		1.077959989748378e+03,		1.078382076941782e+03,		1.078803084538049e+03,
		1.079223018752996e+03,		1.079641885747069e+03,		1.080059691626019e+03,		1.080476442441557e+03,		1.080892144192001e+03,
		1.081306802822917e+03,		1.081720424227748e+03,		1.082133014248430e+03,		1.082544578676004e+03,		1.082955123251221e+03,
		1.083364653665126e+03,		1.083773175559648e+03,		1.084180694528169e+03,		1.084587216116095e+03,		1.084992745821412e+03,
		1.085397289095232e+03,		1.085800851342341e+03,		1.086203437921726e+03,		1.086605054147104e+03,		1.087005705287443e+03,
		1.087405396567466e+03,		1.087804133168158e+03,		1.088201920227264e+03,		1.088598762839774e+03,		1.088994666058407e+03,
		1.089389634894088e+03,		1.089783674316410e+03,		1.090176789254104e+03,		1.090568984595488e+03,		1.090960265188917e+03,
		1.091350635843231e+03,		1.091740101328179e+03,		1.092128666374866e+03,		1.092516335676162e+03,		1.092903113887127e+03,
		1.093289005625428e+03,		1.093674015471735e+03,		1.094058147970132e+03,		1.094441407628509e+03,		1.094823798918950e+03,
		1.095205326278126e+03,		1.095585994107664e+03,		1.095965806774530e+03,		1.096344768611395e+03,		1.096722883917001e+03,
		1.097100156956522e+03,		1.097476591961914e+03,		1.097852193132270e+03,		1.098226964634165e+03,		1.098600910601996e+03,
		1.098974035138316e+03,		1.099346342314173e+03,		1.099717836169428e+03,		1.100088520713087e+03,		1.100458399923616e+03,
		1.100827477749253e+03,		1.101195758108330e+03,		1.101563244889564e+03,		1.101929941952372e+03,		1.102295853127168e+03,
		1.102660982215650e+03,		1.103025332991102e+03,		1.103388909198675e+03,		1.103751714555675e+03,		1.104113752751836e+03,
		1.104475027449606e+03,		1.104835542284415e+03,		1.105195300864943e+03,		1.105554306773393e+03,		1.105912563565746e+03,
		1.106270074772028e+03,		1.106626843896559e+03,		1.106982874418215e+03,		1.107338169790670e+03,		1.107692733442647e+03,
		1.108046568778160e+03,		1.108399679176762e+03,		1.108752067993770e+03,		1.109103738560510e+03,		1.109454694184550e+03,
		1.109804938149920e+03,		1.110154473717348e+03,		1.110503304124478e+03,		1.110851432586094e+03,		1.111198862292735e+03,
		1.111545596417556e+03,		1.111891638106192e+03,		1.112236990484147e+03,		1.112581656655126e+03,		1.112925639701247e+03,
		1.113268942683241e+03,		1.113611568640656e+03,		1.113953520592048e+03,		1.114294801535187e+03,		1.114635414447243e+03,
		1.114975362284979e+03,		1.115314647984945e+03,		1.115653274463660e+03,		1.115991244617796e+03,		1.116328561324366e+03,
		1.116665227440899e+03,		1.117001245805623e+03,		1.117336619237638e+03,		1.117671350537090e+03,		1.118005442485350e+03,
		1.118338897845174e+03,		1.118671719360879e+03,		1.119003909758509e+03,		1.119335471745993e+03,		1.119666408013319e+03,
		1.119996721232683e+03,		1.120326414058655e+03,		1.120655489128338e+03,		1.120983949061516e+03,		1.121311796460813e+03,
		1.121639033911848e+03,		1.121965663983377e+03,		1.122291689227445e+03,		1.122617112179541e+03,		1.122941935358728e+03,
		1.123266161267801e+03,		1.123589792393422e+03,		1.123912831206261e+03,		1.124235280162726e+03,		1.124557141697862e+03,
		1.124878418238096e+03,		1.125199112191338e+03,		1.125519225950232e+03,		1.125838761892289e+03,		1.126157722379880e+03,
		1.126476109761011e+03,		1.126793926368121e+03,		1.127111174519504e+03,		1.127427856518782e+03,		1.127743974655157e+03,
		1.128059531203538e+03,		1.128374528424654e+03,		1.128688968565178e+03,		1.129002853857848e+03,		1.129316186521577e+03,
		1.129628968761574e+03,		1.129941202769457e+03,		1.130252890723365e+03,		1.130564034788071e+03,		1.130874637115093e+03,
		1.131184699842807e+03,		1.131494225096546e+03,		1.131803214988719e+03,		1.132111671618909e+03,		1.132419597073983e+03,
		1.132726993428194e+03,		1.133033862743284e+03,		1.133340207068586e+03,		1.133646028441127e+03,		1.133951328885725e+03,
		1.134256110415090e+03,		1.134560375029921e+03,		1.134864124719003e+03,		1.135167361459303e+03,		1.135470087216065e+03,
		1.135772303942902e+03,		1.136074013581895e+03,		1.136375218063676e+03,		1.136675919307528e+03,		1.136976119221469e+03,
		1.137275819702345e+03,		1.137575022635917e+03,		1.137873729896947e+03,		1.138171943349289e+03,		1.138469664845969e+03
	},
	{
		1.795651170213205e+00,		5.446880302521354e+00,		9.176666349950997e+00,		1.298945072837590e+01,		1.689009269181241e+01,
		2.088392497727225e+01,		2.497681925050782e+01,		2.917526354002643e+01,		3.348645444673468e+01,		3.791840771448545e+01,
		4.248009181992691e+01,		4.718159070099247e+01,		5.203430375872892e+01,		5.705119408767165e+01,		6.224709990001793e+01,
		6.763912990974346e+01,		7.324717199649945e+01,		7.909455735297473e+01,		8.520894219214941e+01,		9.162350057460397e+01,
		9.837857333173488e+01,		1.055240049969994e+02,		1.131225536902993e+02,		1.212550413042086e+02,		1.300284626324948e+02,
		1.395894243855196e+02,		1.501479075212814e+02,		1.620230060048542e+02,		1.757419042741175e+02,		1.922949560759315e+02,
		2.140241544961148e+02,		7.442333615222127e+02,		7.533134081121100e+02,		7.611883651928615e+02,		7.681893855399751e+02,
		7.745206574900466e+02,		7.803186761985346e+02,		7.856799849651565e+02,		7.906757940358256e+02,		7.953603642050020e+02,
		7.997761310288411e+02,		8.039569972954228e+02,		8.079305356271865e+02,		8.117195119589334e+02,		8.153429692933619e+02,
		8.188170173770085e+02,		8.221554201792820e+02,		8.253700409531842e+02,		8.284711848536630e+02,		8.314678664772332e+02,
		8.343680214561383e+02,		8.371786757377477e+02,		8.399060824296778e+02,		8.425558334611883e+02,		8.451329515088282e+02,
		8.476419662512216e+02,		8.500869781006767e+02,		8.524717118224622e+02,		8.547995619282012e+02,		8.570736313297355e+02,
		8.592967644247577e+02,		8.614715755706430e+02,		8.636004736924554e+02,		8.656856836510523e+02,		8.677292648722853e+02,
		8.697331276520318e+02,		8.716990474794184e+02,		8.736286776626437e+02,		8.755235604980369e+02,		8.773851371705317e+02,
		8.792147565747925e+02,		8.810136831767815e+02,		8.827831040510165e+02,		8.845241351918911e+02,		8.862378271883288e+02,
		8.879251703377669e+02,		8.895870992651494e+02,		8.912244971036492e+02,		8.928381992864256e+02,		8.944289969922462e+02,
		8.959976402848248e+02,		8.975448409679594e+02,		8.990712752070190e+02,		9.005775859174523e+02,		9.020643849587216e+02,
		9.035322551477061e+02,		9.049817521099169e+02,		9.064134059840017e+02,		9.078277229934080e+02,		9.092251868974655e+02,
		9.106062603328985e+02,		9.119713860556031e+02,		9.133209880915192e+02,		9.146554728044871e+02,		9.159752298882360e+02,
		9.172806332889052e+02,		9.185720420638986e+02,		9.198498011822918e+02,		9.211142422715450e+02,		9.223656843147867e+02,
		9.236044343025965e+02,		9.248307878428147e+02,		9.260450297315721e+02,		9.272474344885305e+02,		9.284382668589745e+02,
		9.296177822852092e+02,		9.307862273505133e+02,		9.319438401914871e+02,		9.330908508966899e+02,		9.342274818712074e+02,
		9.353539481858865e+02,		9.364704579055842e+02,		9.375772123989926e+02,		9.386744066312680e+02,		9.397622294404663e+02,
		9.408408637998673e+02,		9.419104870643940e+02,		9.429712712059023e+02,		9.440233830351119e+02,		9.450669844122680e+02,
		9.461022324469845e+02,		9.471292796879414e+02,		9.481482743030676e+02,		9.491593602507671e+02,		9.501626774427294e+02,
		9.511583618988136e+02,		9.521465458944712e+02,		9.531273581011397e+02,		9.541009237189570e+02,		9.550673646086806e+02,
		9.560267994063843e+02,		9.569793436443325e+02,		9.579251098604745e+02,		9.588642077042372e+02,		9.597967440375967e+02,
		9.607228230316991e+02,		9.616425462592567e+02,		9.625560127829307e+02,		9.634633192399425e+02,		9.643645599230586e+02,
		9.652598268581942e+02,		9.661492098787447e+02,		9.670327966968619e+02,		9.679106729717904e+02,		9.687829223754325e+02,
		9.696496266552638e+02,		9.705108656947357e+02,		9.713667175712819e+02,		9.722172586120372e+02,		9.730625634473985e+02,
		9.739027050625010e+02,		9.747377548467235e+02,		9.755677826416060e+02,		9.763928567854716e+02,		9.772130441594129e+02,
		9.780284102284646e+02,		9.788390190828495e+02,		9.796449334773921e+02,		9.804462148695060e+02,		9.812429234558085e+02,
		9.820351182074271e+02,		9.828228569040684e+02,		9.836061961668672e+02,		9.843851914901039e+02,		9.851598972718220e+02,
		9.859303668433901e+02,		9.866966524980484e+02,		9.874588055185014e+02,		9.882168762035701e+02,		9.889709138939644e+02,
		9.897209669971904e+02,		9.904670830116449e+02,		9.912093085499197e+02,		9.919476893613518e+02,		9.926822703538398e+02,
		9.934130956149726e+02,		9.941402084324754e+02,		9.948636513140170e+02,		9.955834660063923e+02,		9.962996935141150e+02,
		9.970123741174172e+02,		9.977215473897176e+02,		9.984272522145400e+02,		9.991295268019295e+02,		9.998284087043611e+02,
		1.000523934832186e+03,		1.001216141468612e+03,		1.001905064284238e+03,		1.002590738351164e+03,		1.003273198156696e+03,
		1.003952477616641e+03,		1.004628610088227e+03,		1.005301628382654e+03,		1.005971564777282e+03,		1.006638451027475e+03,
		1.007302318378119e+03,		1.007963197574812e+03,		1.008621118874737e+03,		1.009276112057256e+03,		1.009928206434182e+03,
		1.010577430859801e+03,		1.011223813740603e+03,		1.011867383044757e+03,		1.012508166311333e+03,		1.013146190659273e+03,
		1.013781482796132e+03,		1.014414069026581e+03,		1.015043975260691e+03,		1.015671227022005e+03,		1.016295849455388e+03,
		1.016917867334692e+03,		1.017537305070209e+03,		1.018154186715945e+03,		1.018768535976705e+03,		1.019380376215002e+03,
		1.019989730457781e+03,		1.020596621402998e+03,		1.021201071426019e+03,		1.021803102585859e+03,		1.022402736631283e+03,
		1.022999995006745e+03,		1.023594898858184e+03,		1.024187469038692e+03,		1.024777726114028e+03,		1.025365690368015e+03,
		1.025951381807800e+03,		1.026534820168992e+03,		1.027116024920686e+03,		1.027695015270353e+03,		1.028271810168634e+03,
		1.028846428314009e+03,		1.029418888157373e+03,		1.029989207906488e+03,		1.030557405530349e+03,		1.031123498763446e+03,
		1.031687505109927e+03,		1.032249441847672e+03,		1.032809326032267e+03,		1.033367174500904e+03,		1.033923003876180e+03,
		1.034476830569822e+03,		1.035028670786321e+03,		1.035578540526501e+03,		1.036126455590990e+03,		1.036672431583639e+03,
		1.037216483914845e+03,		1.037758627804820e+03,		1.038298878286779e+03,		1.038837250210072e+03,		1.039373758243230e+03,
		1.039908416876969e+03,		1.040441240427120e+03,		1.040972243037495e+03,		1.041501438682699e+03,		1.042028841170885e+03,
		1.042554464146445e+03,		1.043078321092653e+03,		1.043600425334251e+03,		1.044120790039984e+03,		1.044639428225079e+03,
		1.045156352753680e+03,		1.045671576341232e+03,		1.046185111556817e+03,		1.046696970825439e+03,		1.047207166430276e+03,
		1.047715710514876e+03,		1.048222615085313e+03,		1.048727892012302e+03,		1.049231553033273e+03,		1.049733609754405e+03,
		1.050234073652621e+03,		1.050732956077537e+03,		1.051230268253390e+03,		1.051726021280911e+03,		1.052220226139178e+03,
		1.052712893687420e+03,		1.053204034666798e+03,		1.053693659702152e+03,		1.054181779303701e+03,		1.054668403868733e+03,
		1.055153543683248e+03,		1.055637208923575e+03,		1.056119409657962e+03,		1.056600155848133e+03,		1.057079457350819e+03,
		1.057557323919261e+03,		1.058033765203350e+03,		1.058508790756542e+03,		1.058982410028872e+03,		1.059454632374106e+03,
		1.059925467049635e+03,		1.060394923217825e+03,		1.060863009947336e+03,		1.061329736214426e+03,		1.061795110904229e+03,
		1.062259142812009e+03,		1.062721840644393e+03,		1.063183213020585e+03,		1.063643268473558e+03,		1.064102015451221e+03,
		1.064559462317573e+03,		1.065015617353832e+03,		1.065470488759548e+03,		1.065924084653694e+03,		1.066376413075740e+03,
		1.066827481986714e+03,		1.067277299270235e+03,		1.067725872733533e+03,		1.068173210108459e+03,		1.068619319052468e+03,
		1.069064207149589e+03,		1.069507881911384e+03,		1.069950350777886e+03,		1.070391621118518e+03,		1.070831700233008e+03,
		1.071270595352280e+03,		1.071708313639335e+03,		1.072144862190113e+03,		1.072580248034346e+03,		1.073014478136400e+03,
		1.073447559396091e+03,		1.073879498649502e+03,		1.074310302669780e+03,		1.074739978167922e+03,		1.075168531793544e+03,
		1.075595970135649e+03,		1.076022299723370e+03,		1.076447527026711e+03,		1.076871658457273e+03,		1.077294700368963e+03,
		1.077716659058707e+03,		1.078137540767137e+03,		1.078557351679270e+03,		1.078976097925187e+03,		1.079393785580692e+03,
		1.079810420667957e+03,		1.080226009156176e+03,		1.080640556962182e+03,		1.081054069951084e+03,		1.081466553936867e+03,
		1.081878014683004e+03,		1.082288457903048e+03,		1.082697889261219e+03,		1.083106314372977e+03,		1.083513738805597e+03,
		1.083920168078725e+03,		1.084325607664932e+03,		1.084730062990255e+03,		1.085133539434738e+03,		1.085536042332955e+03,
		1.085937576974535e+03,		1.086338148604670e+03,		1.086737762424628e+03,		1.087136423592241e+03,		1.087534137222410e+03,
		1.087930908387573e+03,		1.088326742118197e+03,		1.088721643403240e+03,		1.089115617190615e+03,		1.089508668387654e+03,
		1.089900801861548e+03,		1.090292022439805e+03,		1.090682334910675e+03,		1.091071744023593e+03,		1.091460254489596e+03,
		1.091847870981751e+03,		1.092234598135566e+03,		1.092620440549400e+03,		1.093005402784862e+03,		1.093389489367214e+03,
		1.093772704785762e+03,		1.094155053494240e+03,		1.094536539911195e+03,		1.094917168420361e+03,		1.095296943371034e+03,
		1.095675869078429e+03,		1.096053949824056e+03,		1.096431189856064e+03,		1.096807593389599e+03,		1.097183164607148e+03,
		1.097557907658885e+03,		1.097931826663007e+03,		1.098304925706067e+03,		1.098677208843302e+03,		1.099048680098963e+03,
		1.099419343466630e+03,		1.099789202909531e+03,		1.100158262360854e+03,		1.100526525724054e+03,		1.100893996873159e+03,
		1.101260679653070e+03,		1.101626577879855e+03,		1.101991695341046e+03,		1.102356035795921e+03,		1.102719602975798e+03,
		1.103082400582927e+03,		1.103444432296526e+03,		1.103805701764053e+03,		1.104166212607750e+03,		1.104525968423265e+03,
		1.104884972779919e+03,		1.105243229220965e+03,		1.105600741263847e+03,		1.105957512400454e+03,		1.106313546097367e+03,
		1.106668845796115e+03,		1.107023414913415e+03,		1.107377256841415e+03,		1.107730374947933e+03,		1.108082772576692e+03,
		1.108434453047557e+03,		1.108785419656760e+03,		1.109135675677132e+03,		1.109485224358329e+03,		1.109834068927044e+03,
		1.110182212587242e+03,		1.110529658520361e+03,		1.110876409885540e+03,		1.111222469819820e+03,		1.111567841438358e+03,
		1.111912527834633e+03,		1.112256532080651e+03,		1.112599857227144e+03,		1.112942506303769e+03,		1.113284482319310e+03,
		1.113625788261868e+03,		1.113966427099054e+03,		1.114306401778179e+03,		1.114645715226445e+03,		1.114984370352737e+03,
		1.115322370040390e+03,		1.115659717160483e+03,		1.115996414561367e+03,		1.116332465072262e+03,		1.116667871503429e+03,
		1.117002636646339e+03,		1.117336763273796e+03,		1.117670254140097e+03,		1.118003111981189e+03,		1.118335339514832e+03,
		1.118666939440770e+03,		1.118997914440885e+03,		1.119328267179361e+03,		1.119658000302840e+03,		1.119987116440581e+03,
		1.120315618204612e+03,		1.120643508189882e+03,		1.120970788974413e+03,		1.121297463119452e+03,		1.121623533169614e+03,
		1.121949001653030e+03,		1.122273871081493e+03,		1.122598143950599e+03,		1.122921822739888e+03,		1.123244909912983e+03,
		1.123567407917733e+03,		1.123889319186342e+03,		1.124210646135511e+03,		1.124531391166567e+03,		1.124851556665598e+03,
		1.125171145003582e+03,		1.125490158536518e+03,		1.125808599605552e+03,		1.126126470537105e+03,		1.126443773642998e+03,
		1.126760511220577e+03,		1.127076685552831e+03,		1.127392298908520e+03,		1.127707353542290e+03,		1.128021851694793e+03,
		1.128335795592803e+03,		1.128649187449339e+03,		1.128962029463769e+03,		1.129274323821932e+03,		1.129586072696248e+03,
		1.129897278245828e+03,		1.130207942616588e+03,		1.130518067941353e+03,		1.130827656339970e+03,		1.131136709919410e+03,
		1.131445230773877e+03,		1.131753220984912e+03,		1.132060682621496e+03,		1.132367617740151e+03,		1.132674028385045e+03,
		1.132979916588089e+03,		1.133285284369037e+03,		1.133590133735587e+03,		1.133894466683476e+03,		1.134198285196573e+03,
		1.134501591246982e+03,		1.134804386795130e+03,		1.135106673789863e+03,		1.135408454168539e+03,		1.135709729857116e+03,
		1.136010502770250e+03,		1.136310774811376e+03,		1.136610547872800e+03,		1.136909823835792e+03,		1.137208604570666e+03
	},
	{
		1.791942440697194e+00,		5.435240856521215e+00,		9.156361880230037e+00,		1.295966662293221e+01,		1.684992248859361e+01,
		2.083235670090283e+01,		2.491271914935071e+01,		2.909735660904319e+01,		3.339330094506869e+01,		3.780837464957600e+01,
		4.235131804777143e+01,		4.703194384885055e+01,		5.186132655817936e+01,		5.685203683041318e+01,		6.201843446881687e+01,
		6.737703899076602e+01,		7.294700431990903e+01,		7.875073559221579e+01,		8.481470354790659e+01,		9.117053943191867e+01,
		9.785653769333973e+01,		1.049197679034758e+02,		1.124191259969382e+02,		1.204298885340685e+02,		1.290507807520122e+02,
		1.384154811883029e+02,		1.487124985925699e+02,		1.602222674498177e+02,		1.733939878217660e+02,		1.890306862061634e+02,
		2.088581250484799e+02,		7.321211446324420e+02,		7.427307859857139e+02,		7.516589193861558e+02,		7.594437267310253e+02,
		7.663882759781344e+02,		7.726833728466546e+02,		7.784582875953753e+02,		7.838053104907409e+02,		7.887929852124018e+02,
		7.934738191162656e+02,		7.978890513617088e+02,		8.020717441627904e+02,		8.060488654800300e+02,		8.098427378440165e+02,
		8.134720739204108e+02,		8.169527341216557e+02,		8.202982921672130e+02,		8.235204648451885e+02,		8.266294437304864e+02,
		8.296341548273462e+02,		8.325424643603327e+02,		8.353613437289945e+02,		8.380970030905274e+02,		8.407550005469845e+02,
		8.433403321539843e+02,		8.458575067033529e+02,		8.483106082927678e+02,		8.507033490426211e+02,		8.530391137674636e+02,
		8.553209980568120e+02,		8.575518409070584e+02,		8.597342528234859e+02,		8.618706401347802e+02,		8.639632261186644e+02,
		8.660140694381470e+02,		8.680250802866107e+02,		8.699980345815628e+02,		8.719345864845121e+02,		8.738362794804614e+02,
		8.757045562128949e+02,		8.775407672395785e+02,		8.793461788492342e+02,		8.811219800581754e+02,		8.828692888916613e+02,
		8.845891580246015e+02,		8.862825798817032e+02,		8.879504912340124e+02,		8.895937773659039e+02,		8.912132758549242e+02,
		8.928097800078654e+02,		8.943840419901362e+02,		8.959367756808850e+02,		8.974686592824031e+02,		8.989803377088639e+02,
		9.004724247765815e+02,		9.019455052153177e+02,		9.034001365180260e+02,		9.048368506444488e+02,		9.062561555922424e+02,
		9.076585368479111e+02,		9.090444587284417e+02,		9.104143656234668e+02,		9.117686831466650e+02,		9.131078192043273e+02,
		9.144321649881815e+02,		9.157420958988203e+02,		9.170379724055490e+02,		9.183201408478350e+02,		9.195889341830912e+02,
		9.208446726850780e+02,		9.220876645967870e+02,		9.233182067413692e+02,		9.245365850942986e+02,		9.257430753197040e+02,
		9.269379432735682e+02,		9.281214454761974e+02,		9.292938295562251e+02,		9.304553346693069e+02,		9.316061918865012e+02,
		9.327466245718214e+02,		9.338768487260035e+02,		9.349970733170653e+02,		9.361075005910313e+02,		9.372083263654425e+02,
		9.382997403067950e+02,		9.393819261929621e+02,		9.404550621614245e+02,		9.415193209450563e+02,		9.425748700941284e+02,
		9.436218721883064e+02,		9.446604850370062e+02,		9.456908618697570e+02,		9.467131515170115e+02,		9.477274985819965e+02,
		9.487340436040943e+02,		9.497329232143081e+02,		9.507242702832310e+02,		9.517082140619626e+02,		9.526848803153231e+02,
		9.536543914543067e+02,		9.546168666511530e+02,		9.555724219607598e+02,		9.565211704305882e+02,		9.574632222068639e+02,
		9.583986846360654e+02,		9.593276623619281e+02,		9.602502574182120e+02,		9.611665693174530e+02,		9.620766951359134e+02,
		9.629807295949124e+02,		9.638787651387388e+02,		9.647708920093049e+02,		9.656571983177146e+02,		9.665377701128966e+02,
		9.674126914474396e+02,		9.682820444413171e+02,		9.691459093403129e+02,		9.700043645777779e+02,		9.708574868281437e+02,
		9.717053510613614e+02,		9.725480305946007e+02,		9.733855971419715e+02,		9.742181208623612e+02,		9.750456704054582e+02,
		9.758683129560608e+02,		9.766861142767374e+02,		9.774991387489162e+02,		9.783074494124767e+02,		9.791111080038988e+02,
		9.799101749930487e+02,		9.807047096186429e+02,		9.814947699224628e+02,		9.822804127823601e+02,		9.830616939441196e+02,
		9.838386680522027e+02,		9.846113886794541e+02,		9.853799083557777e+02,		9.861442785958487e+02,		9.869045499258932e+02,
		9.876607719095765e+02,		9.884129931730182e+02,		9.891612614290096e+02,		9.899056235004152e+02,		9.906461253428273e+02,
		9.913828120664900e+02,		9.921157279575137e+02,		9.928449164984258e+02,		9.935704203880648e+02,		9.942922815608529e+02,
		9.950105412054681e+02,		9.957252397829424e+02,		9.964364170441952e+02,		9.971441120470384e+02,		9.978483631726651e+02,
		9.985492081416386e+02,		9.992466840294051e+02,		9.999408272813423e+02,		1.000631673727366e+03,		1.001319258596107e+03,
		1.002003616528674e+03,		1.002684781592015e+03,		1.003362787291898e+03,		1.004037666585519e+03,		1.004709451893746e+03,
		1.005378175113022e+03,		1.006043867626936e+03,		1.006706560317462e+03,		1.007366283575887e+03,		1.008023067313450e+03,
		1.008676940971672e+03,		1.009327933532413e+03,		1.009976073527657e+03,		1.010621389049027e+03,		1.011263907757052e+03,
		1.011903656890183e+03,		1.012540663273572e+03,		1.013174953327611e+03,		1.013806553076267e+03,		1.014435488155177e+03,
		1.015061783819548e+03,		1.015685464951849e+03,		1.016306556069308e+03,		1.016925081331207e+03,		1.017541064546016e+03,
		1.018154529178319e+03,		1.018765498355589e+03,		1.019373994874779e+03,		1.019980041208757e+03,		1.020583659512582e+03,
		1.021184871629627e+03,		1.021783699097543e+03,		1.022380163154093e+03,		1.022974284742834e+03,		1.023566084518668e+03,
		1.024155582853258e+03,		1.024742799840314e+03,		1.025327755300758e+03,		1.025910468787765e+03,		1.026490959591688e+03,
		1.027069246744859e+03,		1.027645349026296e+03,		1.028219284966287e+03,		1.028791072850873e+03,		1.029360730726228e+03,
		1.029928276402943e+03,		1.030493727460214e+03,		1.031057101249924e+03,		1.031618414900649e+03,		1.032177685321565e+03,
		1.032734929206270e+03,		1.033290163036527e+03,		1.033843403085918e+03,		1.034394665423416e+03,		1.034943965916897e+03,
		1.035491320236544e+03,		1.036036743858218e+03,		1.036580252066716e+03,		1.037121859958990e+03,		1.037661582447287e+03,
		1.038199434262207e+03,		1.038735429955736e+03,		1.039269583904163e+03,		1.039801910310989e+03,		1.040332423209731e+03,
		1.040861136466700e+03,		1.041388063783701e+03,		1.041913218700691e+03,		1.042436614598376e+03,		1.042958264700756e+03,
		1.043478182077615e+03,		1.043996379646976e+03,		1.044512870177485e+03,		1.045027666290763e+03,		1.045540780463706e+03,
		1.046052225030740e+03,		1.046562012186029e+03,		1.047070153985643e+03,		1.047576662349687e+03,		1.048081549064375e+03,
		1.048584825784084e+03,		1.049086504033345e+03,		1.049586595208819e+03,		1.050085110581218e+03,		1.050582061297195e+03,
		1.051077458379824e+03,		1.051571312736079e+03,		1.052063635149887e+03,		1.052554436289873e+03,		1.053043726709535e+03,
		1.053531516848930e+03,		1.054017817036328e+03,		1.054502637489841e+03,		1.054985988319014e+03,		1.055467879526395e+03,
		1.055948321009068e+03,		1.056427322560168e+03,		1.056904893870356e+03,		1.057381044529281e+03,		1.057855784027004e+03,
		1.058329121755408e+03,		1.058801067009567e+03,		1.059271628989110e+03,		1.059740816799547e+03,		1.060208639453572e+03,
		1.060675105872352e+03,		1.061140224886790e+03,		1.061604005238755e+03,		1.062066455582311e+03,		1.062527584484905e+03,
		1.062987400428548e+03,		1.063445911810969e+03,		1.063903126946750e+03,		1.064359054068449e+03,		1.064813701327688e+03,
		1.065267076796240e+03,		1.065719188467087e+03,		1.066170044255464e+03,		1.066619651999880e+03,		1.067068019463137e+03,
		1.067515154333312e+03,		1.067961064224737e+03,		1.068405756678957e+03,		1.068849239165674e+03,		1.069291519083675e+03,
		1.069732603761744e+03,		1.070172500459566e+03,		1.070611216368596e+03,		1.071048758612945e+03,		1.071485134250227e+03,
		1.071920350272399e+03,		1.072354413606593e+03,		1.072787331115929e+03,		1.073219109600315e+03,		1.073649755797243e+03,
		1.074079276382555e+03,		1.074507677971219e+03,		1.074934967118072e+03,		1.075361150318568e+03,		1.075786234009500e+03,
		1.076210224569727e+03,		1.076633128320870e+03,		1.077054951528020e+03,		1.077475700400412e+03,		1.077895381092106e+03,
		1.078313999702652e+03,		1.078731562277739e+03,		1.079148074809847e+03,		1.079563543238872e+03,		1.079977973452763e+03,
		1.080391371288125e+03,		1.080803742530835e+03,		1.081215092916636e+03,		1.081625428131727e+03,		1.082034753813337e+03,
		1.082443075550305e+03,		1.082850398883638e+03,		1.083256729307064e+03,		1.083662072267581e+03,		1.084066433165998e+03,
		1.084469817357458e+03,		1.084872230151968e+03,		1.085273676814913e+03,		1.085674162567561e+03,		1.086073692587565e+03,
		1.086472272009457e+03,		1.086869905925136e+03,		1.087266599384344e+03,		1.087662357395140e+03,		1.088057184924368e+03,
		1.088451086898112e+03,		1.088844068202155e+03,		1.089236133682418e+03,		1.089627288145408e+03,		1.090017536358647e+03,
		1.090406883051101e+03,		1.090795332913604e+03,		1.091182890599272e+03,		1.091569560723917e+03,		1.091955347866448e+03,
		1.092340256569271e+03,		1.092724291338688e+03,		1.093107456645278e+03,		1.093489756924287e+03,		1.093871196575999e+03,
		1.094251779964695e+03,		1.094631511424958e+03,		1.095010395252703e+03,		1.095388435712070e+03,		1.095765637034056e+03,
		1.096142003416868e+03,		1.096517539026256e+03,		1.096892247995866e+03,		1.097266134427564e+03,		1.097639202391772e+03,
		1.098011455927795e+03,		1.098382899044140e+03,		1.098753535718837e+03,		1.099123369899748e+03,		1.099492405504883e+03,
		1.099860646422699e+03,		1.100228096512406e+03,		1.100594759604265e+03,		1.100960639499878e+03,		1.101325739972480e+03,
		1.101690064767230e+03,		1.102053617601485e+03,		1.102416402165087e+03,		1.102778422120635e+03,		1.103139681103756e+03,
		1.103500182723378e+03,		1.103859930561991e+03,		1.104218928175911e+03,		1.104577179095540e+03,		1.104934686825620e+03,
		1.105291454845482e+03,		1.105647486610213e+03,		1.106002785546606e+03,		1.106357355061244e+03,		1.106711198534039e+03,
		1.107064319320786e+03,		1.107416720753581e+03,		1.107768406140592e+03,		1.108119378766650e+03,		1.108469641893272e+03,
		1.108819198758930e+03,		1.109168052579264e+03,		1.109516206547303e+03,		1.109863663833682e+03,		1.110210427586852e+03,
		1.110556500933289e+03,		1.110901886977707e+03,		1.111246588803253e+03,		1.111590609471720e+03,		1.111933952023739e+03,
		1.112276619478984e+03,		1.112618614836362e+03,		1.112959941074207e+03,		1.113300601150474e+03,		1.113640598002922e+03,
		1.113979934549305e+03,		1.114318613687558e+03,		1.114656638295974e+03,		1.114994011233383e+03,		1.115330735339338e+03,
		1.115666813434284e+03,		1.116002248319734e+03,		1.116337042778439e+03,		1.116671199574562e+03,		1.117004721453842e+03,
		1.117337611143762e+03,		1.117669871353713e+03,		1.118001504775155e+03,		1.118332514081779e+03,		1.118662901929663e+03,
		1.118992670957436e+03,		1.119321823786422e+03,		1.119650363020804e+03,		1.119978291247768e+03,		1.120305611037655e+03,
		1.120632324944114e+03,		1.120958435504242e+03,		1.121283945238732e+03,		1.121608856652018e+03,		1.121933172232412e+03,
		1.122256894452250e+03,		1.122580025768026e+03,		1.122902568620533e+03,		1.123224525434995e+03,		1.123545898621206e+03,
		1.123866690573655e+03,		1.124186903671668e+03,		1.124506540279527e+03,		1.124825602746608e+03,		1.125144093407501e+03,
		1.125462014582138e+03,		1.125779368575920e+03,		1.126096157679838e+03,		1.126412384170593e+03,		1.126728050310719e+03,
		1.127043158348700e+03,		1.127357710519093e+03,		1.127671709042638e+03,		1.127985156126375e+03,		1.128298053963764e+03,
		1.128610404734790e+03,		1.128922210606079e+03,		1.129233473731011e+03,		1.129544196249822e+03,		1.129854380289721e+03,
		1.130164027964990e+03,		1.130473141377097e+03,		1.130781722614793e+03,		1.131089773754226e+03,		1.131397296859032e+03,
		1.131704293980446e+03,		1.132010767157400e+03,		1.132316718416623e+03,		1.132622149772739e+03,		1.132927063228363e+03,
		1.133231460774201e+03,		1.133535344389145e+03,		1.133838716038650e+03,		1.134141577681612e+03,		1.134443931260408e+03,
		1.134745778707608e+03,		1.135047121944433e+03,		1.135347962880843e+03,		1.135648303415630e+03,		1.135948145436498e+03
	},
	{
		1.788249274982599e+00,		5.423653713228977e+00,		9.136155030328601e+00,		1.293003564176210e+01,		1.680997305240991e+01,
		2.078109134979805e+01,		2.484902155932980e+01,		2.901997279144060e+01,		3.330081662648207e+01,		3.769918786461735e+01,
		4.222360567793559e+01,		4.688362043105990e+01,		5.168999311755623e+01,		5.665491669013448e+01,		6.179229184232923e+01,
		6.711807449012788e+01,		7.265071903213507e+01,		7.841175161090840e+01,		8.442652299958939e+01,		9.072521470592145e+01,
		9.734421023797795e+01,		1.043280068201201e+02,		1.117319513474106e+02,		1.196262782405845e+02,		1.281022909905808e+02,
		1.372822551460491e+02,		1.473361275291776e+02,		1.585119070128213e+02,		1.711960922143644e+02,		1.860510345628153e+02,
		2.043971621543697e+02,		2.297621605929702e+02,		7.309352734451089e+02,		7.412760070004703e+02,		7.500539419440944e+02,
		7.577466909094976e+02,		7.646319743873411e+02,		7.708880251274160e+02,		7.766371395611003e+02,		7.819674223161001e+02,
		7.869447539711381e+02,		7.916198701767039e+02,		7.960327894307957e+02,		8.002157090494966e+02,		8.041949700609679e+02,
		8.079924319612928e+02,		8.116264600690728e+02,		8.151126508162529e+02,		8.184643751031501e+02,		8.216931924562570e+02,
		8.248091715783220e+02,		8.278211418657635e+02,		8.307368931965234e+02,		8.335633363990964e+02,		8.363066334332771e+02,
		8.389723039808689e+02,		8.415653134576738e+02,		8.440901462239302e+02,		8.465508669416585e+02,		8.489511723195957e+02,
		8.512944350185943e+02,		8.535837411208431e+02,		8.558219222684049e+02,		8.580115833682841e+02,		8.601551265841256e+02,
		8.622547722018769e+02,		8.643125768501100e+02,		8.663304494709156e+02,		8.683101653713832e+02,		8.702533786206517e+02,
		8.721616330365996e+02,		8.740363719374413e+02,		8.758789468312206e+02,		8.776906251770629e+02,		8.794725973359872e+02,
		8.812259828113646e+02,		8.829518358650131e+02,		8.846511505828404e+02,		8.863248654539822e+02,		8.879738675187275e+02,
		8.895989961333809e+02,		8.912010463939703e+02,		8.927807722554271e+02,		8.943388893783886e+02,		8.958760777317815e+02,
		8.973929839760686e+02,		8.988902236490708e+02,		9.003683831737756e+02,		9.018280217053652e+02,		9.032696728326553e+02,
		9.046938461477018e+02,		9.061010286956017e+02,		9.074916863154087e+02,		9.088662648818472e+02,		9.102251914565611e+02,
		9.115688753567343e+02,		9.128977091481291e+02,		9.142120695688968e+02,		9.155123183899059e+02,		9.167988032167762e+02,
		9.180718582383283e+02,		9.193318049256839e+02,		9.205789526859251e+02,		9.218135994738128e+02,		9.230360323647610e+02,
		9.242465280920027e+02,		9.254453535506267e+02,		9.266327662708862e+02,		9.278090148630480e+02,		9.289743394357961e+02,
		9.301289719911912e+02,		9.312731367910490e+02,		9.324070507140447e+02,		9.335309235804509e+02,		9.346449584650119e+02,
		9.357493519912083e+02,		9.368442946094095e+02,		9.379299708599990e+02,		9.390065596222729e+02,		9.400742343509531e+02,
		9.411331632987329e+02,		9.421835097289646e+02,		9.432254321166075e+02,		9.442590843391588e+02,		9.452846158580484e+02,
		9.463021718910105e+02,		9.473118935760141e+02,		9.483139181272254e+02,		9.493083789834673e+02,		9.502954059496176e+02,
		9.512751253303501e+02,		9.522476600627218e+02,		9.532131298321440e+02,		9.541716511938910e+02,		9.551233376834741e+02,
		9.560682999232345e+02,		9.570066457241963e+02,		9.579384801834259e+02,		9.588639057771452e+02,		9.597830224498136e+02,
		9.606959276994015e+02,		9.616027166598919e+02,		9.625034821758734e+02,		9.633983148831641e+02,		9.642873032766768e+02,
		9.651705337803670e+02,		9.660480908133350e+02,		9.669200568532546e+02,		9.677865124972773e+02,		9.686475365205185e+02,
		9.695032059322479e+02,		9.703535960298889e+02,		9.711987804509347e+02,		9.720388312228743e+02,		9.728738188112173e+02,
		9.737038121657176e+02,		9.745288787648479e+02,		9.753490846586526e+02,		9.761644945099972e+02,		9.769751716343304e+02,
		9.777811780379878e+02,		9.785825744551369e+02,		9.793794203833844e+02,		9.801717741181401e+02,		9.809596927857585e+02,
		9.817432323755357e+02,		9.825224477705898e+02,		9.832973927776845e+02,		9.840681201560366e+02,		9.848346816451386e+02,
		9.855971279916627e+02,		9.863555089754475e+02,		9.871098734346371e+02,		9.878602692899865e+02,		9.886067435683757e+02,
		9.893493424255588e+02,		9.900881111681813e+02,		9.908230942750899e+02,		9.915543354179715e+02,		9.922818774813339e+02,
		9.930057625818624e+02,		9.937260320871767e+02,		9.944427266340011e+02,		9.951558861457818e+02,		9.958655498497668e+02,
		9.965717562935613e+02,		9.972745433611941e+02,		9.979739482886907e+02,		9.986700076791991e+02,		9.993627575176491e+02,
		1.000052233185003e+03,		1.000738469472071e+03,		1.001421500592935e+03,		1.002101360197990e+03,		1.002778081386602e+03,
		1.003451696719412e+03,		1.004122238230291e+03,		1.004789737437957e+03,		1.005454225357271e+03,		1.006115732510215e+03,
		1.006774288936568e+03,		1.007429924204293e+03,		1.008082667419635e+03,		1.008732547236947e+03,		1.009379591868256e+03,
		1.010023829092562e+03,		1.010665286264895e+03,		1.011303990325144e+03,		1.011939967806626e+03,		1.012573244844454e+03,
		1.013203847183680e+03,		1.013831800187221e+03,		1.014457128843593e+03,		1.015079857774430e+03,		1.015700011241834e+03,
		1.016317613155512e+03,		1.016932687079756e+03,		1.017545256240239e+03,		1.018155343530638e+03,		1.018762971519098e+03,
		1.019368162454536e+03,		1.019970938272785e+03,		1.020571320602604e+03,		1.021169330771515e+03,		1.021764989811527e+03,
		1.022358318464704e+03,		1.022949337188608e+03,		1.023538066161610e+03,		1.024124525288079e+03,		1.024708734203443e+03,
		1.025290712279133e+03,		1.025870478627419e+03,		1.026448052106123e+03,		1.027023451323230e+03,		1.027596694641394e+03,
		1.028167800182336e+03,		1.028736785831147e+03,		1.029303669240491e+03,		1.029868467834713e+03,		1.030431198813856e+03,
		1.030991879157595e+03,		1.031550525629065e+03,		1.032107154778628e+03,		1.032661782947543e+03,		1.033214426271553e+03,
		1.033765100684411e+03,		1.034313821921307e+03,		1.034860605522241e+03,		1.035405466835310e+03,		1.035948421019933e+03,
		1.036489483050004e+03,		1.037028667716977e+03,		1.037565989632890e+03,		1.038101463233322e+03,		1.038635102780288e+03,
		1.039166922365081e+03,		1.039696935911042e+03,		1.040225157176288e+03,		1.040751599756369e+03,		1.041276277086886e+03,
		1.041799202446042e+03,		1.042320388957153e+03,		1.042839849591096e+03,		1.043357597168723e+03,		1.043873644361823e+03,
		1.044388003701151e+03,		1.044900687569861e+03,		1.045411708211803e+03,		1.045921077732126e+03,		1.046428808099413e+03,
		1.046934911147777e+03,		1.047439398578912e+03,		1.047942281964100e+03,		1.048443572746193e+03,		1.048943282241544e+03,
		1.049441421641905e+03,		1.049938002016293e+03,		1.050433034312817e+03,		1.050926529360470e+03,		1.051418497870890e+03,
		1.051908950440084e+03,		1.052397897550125e+03,		1.052885349570817e+03,		1.053371316761321e+03,		1.053855809271765e+03,
		1.054338837144809e+03,		1.054820410317197e+03,		1.055300538621270e+03,		1.055779231786453e+03,		1.056256499440718e+03,
		1.056732351112019e+03,		1.057206796229709e+03,		1.057679844125912e+03,		1.058151504036895e+03,		1.058621785104396e+03,
		1.059090696376941e+03,		1.059558246811132e+03,		1.060024445272915e+03,		1.060489300538824e+03,		1.060952821297205e+03,
		1.061415016149414e+03,		1.061875893611008e+03,		1.062335462112895e+03,		1.062793730002481e+03,		1.063250705544794e+03,
		1.063706396923581e+03,		1.064160812242395e+03,		1.064613959525661e+03,		1.065065846719725e+03,		1.065516481693877e+03,
		1.065965872241378e+03,		1.066414026080442e+03,		1.066860950855224e+03,		1.067306654136781e+03,		1.067751143424021e+03,
		1.068194426144634e+03,		1.068636509656010e+03,		1.069077401246137e+03,		1.069517108134500e+03,		1.069955637472937e+03,
		1.070392996346513e+03,		1.070829191774357e+03,		1.071264230710496e+03,		1.071698120044674e+03,		1.072130866603159e+03,
		1.072562477149529e+03,		1.072992958385460e+03,		1.073422316951493e+03,		1.073850559427782e+03,		1.074277692334847e+03,
		1.074703722134305e+03,		1.075128655229584e+03,		1.075552497966644e+03,		1.075975256634666e+03,		1.076396937466748e+03,
		1.076817546640576e+03,		1.077237090279097e+03,		1.077655574451174e+03,		1.078073005172230e+03,		1.078489388404893e+03,
		1.078904730059615e+03,		1.079319035995299e+03,		1.079732312019901e+03,		1.080144563891036e+03,		1.080555797316562e+03,
		1.080966017955172e+03,		1.081375231416956e+03,		1.081783443263980e+03,		1.082190659010829e+03,		1.082596884125167e+03,
		1.083002124028272e+03,		1.083406384095569e+03,		1.083809669657158e+03,		1.084211985998329e+03,		1.084613338360076e+03,
		1.085013731938106e+03,		1.085413171889583e+03,		1.085811663323760e+03,		1.086209211309398e+03,		1.086605820873403e+03,
		1.087001497001291e+03,		1.087396244637653e+03,		1.087790068686606e+03,		1.088182974012245e+03,		1.088574965439083e+03,
		1.088966047752490e+03,		1.089356225699118e+03,		1.089745503987333e+03,		1.090133887287623e+03,		1.090521380233020e+03,
		1.090907987419502e+03,		1.091293713406392e+03,		1.091678562716761e+03,		1.092062539837811e+03,		1.092445649221264e+03,
		1.092827895283739e+03,		1.093209282407130e+03,		1.093589814938975e+03,		1.093969497192817e+03,		1.094348333448569e+03,
		1.094726327952861e+03,		1.095103484919404e+03,		1.095479808529318e+03,		1.095855302932116e+03,		1.096229972243015e+03,
		1.096603820548942e+03,		1.096976851903777e+03,		1.097349070330660e+03,		1.097720479822221e+03,		1.098091084340809e+03,
		1.098460887818797e+03,		1.098829894158888e+03,		1.099198107234420e+03,		1.099565530889662e+03,		1.099932168940111e+03,
		1.100298025172782e+03,		1.100663103346497e+03,		1.101027407192169e+03,		1.101390940413081e+03,		1.101753706685165e+03,
		1.102115709657273e+03,		1.102476952951448e+03,		1.102837440163190e+03,		1.103197174861721e+03,		1.103556160590242e+03,
		1.103914400866191e+03,		1.104271899181497e+03,		1.104628659002830e+03,		1.104984683771847e+03,		1.105339976905437e+03,
		1.105694541795963e+03,		1.106048381811499e+03,		1.106401500296063e+03,		1.106753900569855e+03,		1.107105585929484e+03,
		1.107456559648189e+03,		1.107806824976072e+03,		1.108156385140317e+03,		1.108505243345403e+03,		1.108853402773324e+03,
		1.109200866583806e+03,		1.109547637914512e+03,		1.109893719881250e+03,		1.110239115578187e+03,		1.110583828078040e+03,
		1.110927860432289e+03,		1.111271215671368e+03,		1.111613896804864e+03,		1.111955906821709e+03,		1.112297248690375e+03,
		1.112637925359060e+03,		1.112977939755880e+03,		1.113317294789045e+03,		1.113655993347054e+03,		1.113994038298864e+03,
		1.114331432494079e+03,		1.114668178763118e+03,		1.115004279917394e+03,		1.115339738749488e+03,		1.115674558033315e+03,
		1.116008740524297e+03,		1.116342288959528e+03,		1.116675206057934e+03,		1.117007494520449e+03,		1.117339157030160e+03,
		1.117670196252479e+03,		1.118000614835293e+03,		1.118330415409124e+03,		1.118659600587281e+03,		1.118988172966011e+03,
		1.119316135124653e+03,		1.119643489625785e+03,		1.119970239013694e+03,		1.120296385821118e+03,		1.120621932559658e+03,
		1.120946881726303e+03,		1.121271235802004e+03,		1.121594997251808e+03,		1.121918168524998e+03,		1.122240752055230e+03,
		1.122562750260670e+03,		1.122884165544121e+03,		1.123205000293159e+03,		1.123525256880265e+03,		1.123844937662951e+03,
		1.124164044983889e+03,		1.124482581171035e+03,		1.124800548537759e+03,		1.125117949382963e+03,		1.125434785991205e+03,
		1.125751060632824e+03,		1.126066775564055e+03,		1.126381933027146e+03,		1.126696535250481e+03,		1.127010584448693e+03,
		1.127324082822775e+03,		1.127637032560201e+03,		1.127949435835031e+03,		1.128261294808029e+03,		1.128572611626766e+03,
		1.128883388425732e+03,		1.129193627326448e+03,		1.129503330437564e+03,		1.129812499854971e+03,		1.130121137661902e+03,
		1.130429245929038e+03,		1.130736826714608e+03,		1.131043882064490e+03,		1.131350414012314e+03,		1.131656424579558e+03,
		1.131961915775647e+03,		1.132266889598051e+03,		1.132571348032381e+03,		1.132875293052482e+03,		1.133178726620533e+03,
		1.133481650687130e+03,		1.133784067191390e+03,		1.134085978061033e+03,		1.134387385212477e+03,		1.134688290550929e+03
	},
	{
		1.784571572743806e+00,		5.412118495781765e+00,		9.116045021553186e+00,		1.290055644227242e+01,		1.677024226684908e+01,
		2.073012576129703e+01,		2.478572191704676e+01,		2.894310566025642e+01,		3.320899259365013e+01,		3.759083519236666e+01,
		4.209693821345898e+01,		4.673659820646836e+01,		5.152027354856756e+01,		5.645979354776355e+01,		6.156861812597388e+01,
		6.686216381588854e+01,		7.235821791581887e+01,		7.807747166029787e+01,		8.404421684570141e+01,		9.028727130563936e+01,
		9.684123183820034e+01,		1.037482074262072e+02,		1.110602773054847e+02,		1.188430798597685e+02,		1.271812361085004e+02,
		1.361868925071730e+02,		1.460138807795527e+02,		1.568827483213367e+02,		1.691288912336081e+02,		1.833064718745307e+02,
		2.004548142523705e+02,		2.230133846452682e+02,		7.174224651513282e+02,		7.297821336662117e+02,		7.398675947498091e+02,
		7.484969868850703e+02,		7.560960758556552e+02,		7.629196006548026e+02,		7.691339747469457e+02,		7.748547749473482e+02,
		7.801660000519095e+02,		7.851308824282726e+02,		7.897983765957646e+02,		7.942072626544912e+02,		7.983888534690230e+02,
		8.023688443529456e+02,		8.061686147034139e+02,		8.098061673816137e+02,		8.132968216269197e+02,		8.166537340281977e+02,
		8.198882968745982e+02,		8.230104473358106e+02,		8.260289106658925e+02,		8.289513938397582e+02,		8.317847413796183e+02,
		8.345350620312220e+02,		8.372078326537136e+02,		8.398079841352870e+02,		8.423399729808534e+02,		8.448078413798884e+02,
		8.472152679336331e+02,		8.495656107508155e+02,		8.518619442636060e+02,		8.541070908449194e+02,		8.563036480823249e+02,
		8.584540124301851e+02,		8.605603997894278e+02,		8.626248634969129e+02,		8.646493101058613e+02,		8.666355132782726e+02,
		8.685851260562405e+02,		8.704996917357598e+02,		8.723806535311775e+02,		8.742293631893758e+02,		8.760470886886430e+02,
		8.778350211373578e+02,		8.795942809708456e+02,		8.813259235309620e+02,		8.830309441011692e+02,		8.847102824600248e+02,
		8.863648270076607e+02,		8.879954185124086e+02,		8.896028535204978e+02,		8.911878874609838e+02,		8.927512374832704e+02,
		8.942935850506309e+02,		8.958155783162088e+02,		8.973178343028540e+02,		8.988009409060179e+02,		9.002654587367232e+02,
		9.017119228198005e+02,		9.031408441608460e+02,		9.045527111939704e+02,		9.059479911211029e+02,		9.073271311525004e+02,
		9.086905596571089e+02,		9.100386872305846e+02,		9.113719076879535e+02,		9.126905989872454e+02,		9.139951240898175e+02,
		9.152858317625053e+02,		9.165630573263045e+02,		9.178271233558082e+02,		9.190783403332666e+02,		9.203170072607631e+02,
		9.215434122337067e+02,		9.227578329785587e+02,		9.239605373574298e+02,		9.251517838420061e+02,		9.263318219590087e+02,
		9.275008927092288e+02,		9.286592289620118e+02,		9.298070558278625e+02,		9.309445910047597e+02,		9.320720451152315e+02,
		9.331896220138167e+02,		9.342975190831806e+02,		9.353959275128757e+02,		9.364850325630582e+02,		9.375650138141034e+02,
		9.386360454029441e+02,		9.396982962476332e+02,		9.407519302591121e+02,		9.417971065433969e+02,		9.428339795928835e+02,
		9.438626994682185e+02,		9.448834119711632e+02,		9.458962588089788e+02,		9.469013777508400e+02,		9.478989027767300e+02,
		9.488889642182348e+02,		9.498716888980050e+02,		9.508472002517414e+02,		9.518156184559347e+02,		9.527770605438445e+02,
		9.537316405174575e+02,		9.546794694558862e+02,		9.556206556114262e+02,		9.565553045168986e+02,		9.574835190722814e+02,
		9.584053996359062e+02,		9.593210441100051e+02,		9.602305480226429e+02,		9.611340046061950e+02,		9.620315048725490e+02,
		9.629231376852090e+02,		9.638089898284430e+02,		9.646891460736082e+02,		9.655636892428224e+02,		9.664327002700896e+02,
		9.672962582599941e+02,		9.681544405441030e+02,		9.690073227351681e+02,		9.698549787792327e+02,		9.706974810057454e+02,
		9.715349001757692e+02,		9.723673055283746e+02,		9.731947648252965e+02,		9.740173443939318e+02,		9.748351091687695e+02,
		9.756481227312888e+02,		9.764564473484238e+02,		9.772601440096417e+02,		9.780592724627022e+02,		9.788538912481451e+02,
		9.796440577325708e+02,		9.804298281407579e+02,		9.812112575866673e+02,		9.819884001033929e+02,		9.827613086720677e+02,
		9.835300352498178e+02,		9.842946307967572e+02,		9.850551453020881e+02,		9.858116278093407e+02,		9.865641264407807e+02,
		9.873126884210072e+02,		9.880573600998063e+02,		9.887981869742546e+02,		9.895352137101142e+02,		9.902684841625585e+02,
		9.909980413962346e+02,		9.917239277046999e+02,		9.924461846292523e+02,		9.931648529771858e+02,		9.938799728394710e+02,
		9.945915836079046e+02,		9.952997239917474e+02,		9.960044320338400e+02,		9.967057451262546e+02,		9.974037000254740e+02,
		9.980983328671233e+02,		9.987896791802677e+02,		9.994777739012961e+02,		1.000162651387394e+03,		1.000844345429647e+03,
		1.001522889265745e+03,		1.002198315592344e+03,		1.002870656577068e+03,		1.003539943870174e+03,		1.004206208615900e+03,
		1.004869481463487e+03,		1.005529792577902e+03,		1.006187171650265e+03,		1.006841647907995e+03,		1.007493250124676e+03,
		1.008142006629663e+03,		1.008787945317420e+03,		1.009431093656620e+03,		1.010071478699005e+03,		1.010709127087995e+03,
		1.011344065067096e+03,		1.011976318488068e+03,		1.012605912818900e+03,		1.013232873151558e+03,		1.013857224209553e+03,
		1.014478990355312e+03,		1.015098195597353e+03,		1.015714863597290e+03,		1.016329017676659e+03,		1.016940680823572e+03,
		1.017549875699207e+03,		1.018156624644137e+03,		1.018760949684511e+03,		1.019362872538070e+03,		1.019962414620030e+03,
		1.020559597048820e+03,		1.021154440651674e+03,		1.021746965970104e+03,		1.022337193265224e+03,		1.022925142522971e+03,
		1.023510833459180e+03,		1.024094285524560e+03,		1.024675517909536e+03,		1.025254549548997e+03,		1.025831399126920e+03,
		1.026406085080895e+03,		1.026978625606541e+03,		1.027549038661837e+03,		1.028117341971329e+03,		1.028683553030268e+03,
		1.029247689108639e+03,		1.029809767255111e+03,		1.030369804300885e+03,		1.030927816863476e+03,		1.031483821350398e+03,
		1.032037833962768e+03,		1.032589870698845e+03,		1.033139947357479e+03,		1.033688079541487e+03,		1.034234282660965e+03,
		1.034778571936521e+03,		1.035320962402445e+03,		1.035861468909805e+03,		1.036400106128134e+03,		1.036936888553973e+03,
		1.037471830505145e+03,		1.038004946129565e+03,		1.038536249406477e+03,		1.039065754149198e+03,		1.039593474007778e+03,
		1.040119422471638e+03,		1.040643612872133e+03,		1.041166058385058e+03,		1.041686772033133e+03,		1.042205766688404e+03,
		1.042723055074616e+03,		1.043238649769537e+03,		1.043752563207224e+03,		1.044264807680265e+03,		1.044775395341955e+03,
		1.045284338208444e+03,		1.045791648160842e+03,		1.046297336947269e+03,		1.046801416184892e+03,		1.047303897361892e+03,
		1.047804791839418e+03,		1.048304110853491e+03,		1.048801865516873e+03,		1.049298066820910e+03,		1.049792725637324e+03,
		1.050285852719985e+03,		1.050777458706644e+03,		1.051267554120637e+03,		1.051756149372552e+03,		1.052243254761870e+03,
		1.052728880478577e+03,		1.053213036604740e+03,		1.053695733116058e+03,		1.054176979883388e+03,		1.054656786674238e+03,
		1.055135163154236e+03,		1.055612118888572e+03,		1.056087663343413e+03,		1.056561805887296e+03,		1.057034555792492e+03,
		1.057505922236346e+03,		1.057975914302603e+03,		1.058444540982697e+03,		1.058911811177021e+03,		1.059377733696186e+03,
		1.059842317262239e+03,		1.060305570509882e+03,		1.060767501987648e+03,		1.061228120159072e+03,		1.061687433403839e+03,
		1.062145450018907e+03,		1.062602178219615e+03,		1.063057626140774e+03,		1.063511801837735e+03,		1.063964713287444e+03,
		1.064416368389471e+03,		1.064866774967040e+03,		1.065315940768012e+03,		1.065763873465885e+03,		1.066210580660751e+03,
		1.066656069880255e+03,		1.067100348580526e+03,		1.067543424147102e+03,		1.067985303895834e+03,		1.068425995073777e+03,
		1.068865504860067e+03,		1.069303840366785e+03,		1.069741008639804e+03,		1.070177016659628e+03,		1.070611871342207e+03,
		1.071045579539754e+03,		1.071478148041537e+03,		1.071909583574663e+03,		1.072339892804845e+03,		1.072769082337172e+03,
		1.073197158716846e+03,		1.073624128429921e+03,		1.074049997904029e+03,		1.074474773509091e+03,		1.074898461558019e+03,
		1.075321068307409e+03,		1.075742599956980e+03,		1.076163062655481e+03,		1.076582462493026e+03,		1.077000805507655e+03,
		1.077418097684391e+03,		1.077834344955868e+03,		1.078249553202958e+03,		1.078663728255377e+03,		1.079076875892292e+03,
		1.079489001842910e+03,		1.079900111787069e+03,		1.080310211355812e+03,		1.080719306131951e+03,		1.081127401650632e+03,
		1.081534503399883e+03,		1.081940616821159e+03,		1.082345747309874e+03,		1.082749900215935e+03,		1.083153080844254e+03,
		1.083555294455266e+03,		1.083956546265430e+03,		1.084356841447732e+03,		1.084756185132171e+03,		1.085154582406243e+03,
		1.085552038316018e+03,		1.085948557863706e+03,		1.086344146013668e+03,		1.086738807687282e+03,		1.087132547767875e+03,
		1.087525371096309e+03,		1.087917282476014e+03,		1.088308286671082e+03,		1.088698388407161e+03,		1.089087592371872e+03,
		1.089475903215229e+03,		1.089863325550040e+03,		1.090249863952317e+03,		1.090635522961667e+03,		1.091020307081689e+03,
		1.091404220780359e+03,		1.091787268490408e+03,		1.092169454609705e+03,		1.092550783501621e+03,		1.092931259495401e+03,
		1.093310886886520e+03,		1.093689669937045e+03,		1.094067612875982e+03,		1.094444719899625e+03,		1.094820995171899e+03,
		1.095196442824697e+03,		1.095571066958214e+03,		1.095944871641273e+03,		1.096317860911656e+03,		1.096690038776418e+03,
		1.097061409212207e+03,		1.097431976165576e+03,		1.097801743553291e+03,		1.098170715262633e+03,		1.098538895151701e+03,
		1.098906287049708e+03,		1.099272894757272e+03,		1.099638722046705e+03,		1.100003772662301e+03,		1.100368050320616e+03,
		1.100731558710741e+03,		1.101094301494589e+03,		1.101456282307151e+03,		1.101817504756773e+03,		1.102177972425420e+03,
		1.102537688868930e+03,		1.102896657617282e+03,		1.103254882174841e+03,		1.103612366020617e+03,		1.103969112608506e+03,
		1.104325125367539e+03,		1.104680407702126e+03,		1.105034962992292e+03,		1.105388794593915e+03,		1.105741905838953e+03,
		1.106094300035690e+03,		1.106445980468943e+03,		1.106796950398534e+03,		1.107147213066437e+03,		1.107496771686813e+03,
		1.107845629452878e+03,		1.108193789535496e+03,		1.108541255083378e+03,		1.108888029223299e+03,		1.109234115060304e+03,
		1.109579515677911e+03,		1.109924234138312e+03,		1.110268273482573e+03,		1.110611636730834e+03,		1.110954326882500e+03,
		1.111296346916434e+03,		1.111637699791148e+03,		1.111978388444993e+03,		1.112318415796340e+03,		1.112657784743768e+03,
		1.112996498166244e+03,		1.113334558923302e+03,		1.113671969855220e+03,		1.114008733783196e+03,		1.114344853509522e+03,
		1.114680331817756e+03,		1.115015171472886e+03,		1.115349375221504e+03,		1.115682945791970e+03,		1.116015885894572e+03,
		1.116348198221689e+03,		1.116679885447957e+03,		1.117010950230419e+03,		1.117341395208685e+03,		1.117671223005087e+03,
		1.118000436224831e+03,		1.118329037456147e+03,		1.118657029270443e+03,		1.118984414222448e+03,		1.119311194850361e+03,
		1.119637373675992e+03,		1.119962953204911e+03,		1.120287935926583e+03,		1.120612324314513e+03,		1.120936120826382e+03,
		1.121259327904183e+03,		1.121581947974358e+03,		1.121903983447931e+03,		1.122225436720642e+03,		1.122546310173074e+03,
		1.122866606170788e+03,		1.123186327064447e+03,		1.123505475189943e+03,		1.123824052868525e+03,		1.124142062406923e+03,
		1.124459506097466e+03,		1.124776386218211e+03,		1.125092705033055e+03,		1.125408464791861e+03,		1.125723667730570e+03,
		1.126038316071322e+03,		1.126352412022569e+03,		1.126665957779186e+03,		1.126978955522591e+03,		1.127291407420850e+03,
		1.127603315628790e+03,		1.127914682288108e+03,		1.128225509527480e+03,		1.128535799462666e+03,		1.128845554196616e+03,
		1.129154775819580e+03,		1.129463466409202e+03,		1.129771628030631e+03,		1.130079262736621e+03,		1.130386372567629e+03,
		1.130692959551913e+03,		1.130999025705637e+03,		1.131304573032965e+03,		1.131609603526155e+03,		1.131914119165657e+03,
		1.132218121920208e+03,		1.132521613746927e+03,		1.132824596591403e+03,		1.133127072387791e+03,		1.133429043058899e+03
	},
	{
		1.780909234546105e+00,		5.400634831225156e+00,		9.096031084373521e+00,		1.287122769948934e+01,		1.673072804613598e+01,
		2.067945682287590e+01,		2.472281573794088e+01,		2.886674890913166e+01,		3.311782013020641e+01,		3.748330473343884e+01,
		4.197129955023369e+01,		4.659085550680474e+01,		5.135213879598429e+01,		5.626662849535944e+01,		6.134736118976068e+01,
		6.660923695864157e+01,		7.206940655917802e+01,		7.774776765203170e+01,		8.366760990612279e+01,		8.985646716424841e+01,
		9.634726364978080e+01,		1.031798877283657e+02,		1.104034044516671e+02,		1.180792529239572e+02,		1.262860190081046e+02,
		1.351268411201689e+02,		1.447414581040912e+02,		1.553270016945367e+02,		1.671767219779393e+02,		1.807599116211999e+02,
		1.969130834761804e+02,		2.174191120026520e+02,		2.478452451427772e+02,		7.167609765217212e+02,		7.286619845492585e+02,
		7.385038639358812e+02,		7.469864249786403e+02,		7.544905862520325e+02,		7.612501750544460e+02,		7.674204940489925e+02,
		7.731106591068319e+02,		7.784006553700023e+02,		7.833510932303660e+02,		7.880091455140897e+02,		7.924123427973030e+02,
		7.965910988060074e+02,		8.005704479558245e+02,		8.043712751534993e+02,		8.080112077004458e+02,		8.115052759361002e+02,
		8.148664118000399e+02,		8.181058312485056e+02,		8.212333319387294e+02,		8.242575279877851e+02,		8.271860373135556e+02,
		8.300256327315758e+02,		8.327823650109893e+02,		8.354616639826769e+02,		8.380684222920099e+02,		8.406070652881002e+02,
		8.430816097559755e+02,		8.454957135774049e+02,		8.478527179751773e+02,		8.501556836438101e+02,		8.524074218097514e+02,
		8.546105210602498e+02,		8.567673706209703e+02,		8.588801806371655e+02,		8.609509999138514e+02,		8.629817314909880e+02,
		8.649741463658017e+02,		8.669298956227716e+02,		8.688505211896451e+02,		8.707374654035233e+02,		8.725920795426712e+02,
		8.744156314555851e+02,		8.762093124048303e+02,		8.779742432097953e+02,		8.797114797889972e+02,		8.814220181593364e+02,
		8.831067989602919e+02,		8.847667115556345e+02,		8.864025977593722e+02,		8.880152552267433e+02,		8.896054405458791e+02,
		8.911738720615054e+02,		8.927212324581548e+02,		8.942481711272044e+02,		8.957553063391850e+02,		8.972432272403433e+02,
		8.987124956903297e+02,		9.001636479560269e+02,		9.015971962748523e+02,		9.030136302994988e+02,		9.044134184347666e+02,
		9.057970090760834e+02,		9.071648317582589e+02,		9.085172982222573e+02,		9.098548034068762e+02,		9.111777263716654e+02,
		9.124864311567296e+02,		9.137812675845519e+02,		9.150625720084763e+02,		9.163306680120967e+02,		9.175858670633532e+02,
		9.188284691268516e+02,		9.200587632375591e+02,		9.212770280388030e+02,		9.224835322871915e+02,		9.236785353269003e+02,
		9.248622875355284e+02,		9.260350307435428e+02,		9.271969986292261e+02,		9.283484170917169e+02,		9.294895045977796e+02,
		9.306204725194106e+02,		9.317415254417070e+02,		9.328528614594951e+02,		9.339546724565544e+02,		9.350471443698120e+02,
		9.361304574394263e+02,		9.372047864456147e+02,		9.382703009335755e+02,		9.393271654258406e+02,		9.403755396248047e+02,
		9.414155786044911e+02,		9.424474329928355e+02,		9.434712491449610e+02,		9.444871693079699e+02,		9.454953317777353e+02,
		9.464958710472162e+02,		9.474889179534816e+02,		9.484745998035302e+02,		9.494530405144039e+02,		9.504243607263528e+02,
		9.513886779296341e+02,		9.523461065710004e+02,		9.532967581624798e+02,		9.542407413838607e+02,		9.551781621806684e+02,
		9.561091238578715e+02,		9.570337271695352e+02,		9.579520704046454e+02,		9.588642494692911e+02,		9.597703579653904e+02,
		9.606704872661352e+02,		9.615647265883216e+02,		9.624531630617212e+02,		9.633358817956315e+02,		9.642129659427526e+02,
		9.650844967605109e+02,		9.659505536699631e+02,		9.668112143123775e+02,		9.676665546036295e+02,		9.685166487864786e+02,
		9.693615694808643e+02,		9.702013877322764e+02,		9.710361730583130e+02,		9.718659934934910e+02,		9.726909156324083e+02,
		9.735110046713042e+02,		9.743263244481099e+02,		9.751369374810516e+02,		9.759429050058628e+02,		9.767442870116690e+02,
		9.775411422756079e+02,		9.783335283962235e+02,		9.791215018257117e+02,		9.799051179010340e+02,		9.806844308739754e+02,
		9.814594939401693e+02,		9.822303592671417e+02,		9.829970780214206e+02,		9.837597003947271e+02,		9.845182756293154e+02,
		9.852728520424616e+02,		9.860234770501709e+02,		9.867701971901010e+02,		9.875130581437547e+02,		9.882521047579652e+02,
		9.889873810656924e+02,		9.897189303061627e+02,		9.904467949443879e+02,		9.911710166900654e+02,		9.918916365158979e+02,
		9.926086946753535e+02,		9.933222307198815e+02,		9.940322835156011e+02,		9.947388912594984e+02,		9.954420914951299e+02,
		9.961419211278655e+02,		9.968384164396739e+02,		9.975316131034813e+02,		9.982215461971055e+02,		9.989082502167926e+02,
		9.995917590903572e+02,		1.000272106189949e+03,		1.000949324344458e+03,		1.001623445851568e+03,		1.002294502489471e+03,
		1.002962525528250e+03,		1.003627545740954e+03,		1.004289593414363e+03,		1.004948698359459e+03,		1.005604889921603e+03,
		1.006258196990455e+03,		1.006908648009604e+03,		1.007556270985961e+03,		1.008201093498879e+03,		1.008843142709060e+03,
		1.009482445367195e+03,		1.010119027822406e+03,		1.010752916030450e+03,		1.011384135561719e+03,		1.012012711609031e+03,
		1.012638668995222e+03,		1.013262032180544e+03,		1.013882825269880e+03,		1.014501072019767e+03,		1.015116795845255e+03,
		1.015730019826589e+03,		1.016340766715721e+03,		1.016949058942676e+03,		1.017554918621739e+03,		1.018158367557520e+03,
		1.018759427250840e+03,		1.019358118904505e+03,		1.019954463428918e+03,		1.020548481447572e+03,		1.021140193302402e+03,
		1.021729619059019e+03,		1.022316778511817e+03,		1.022901691188956e+03,		1.023484376357240e+03,		1.024064853026869e+03,
		1.024643139956093e+03,		1.025219255655751e+03,		1.025793218393711e+03,		1.026365046199208e+03,		1.026934756867078e+03,
		1.027502367961912e+03,		1.028067896822100e+03,		1.028631360562550e+03,		1.029192776083706e+03,		1.029752160067341e+03,
		1.030309528985798e+03,		1.030864899104167e+03,		1.031418286483837e+03,		1.031969706985960e+03,		1.032519176274842e+03,
		1.033066709821273e+03,		1.033612322905764e+03,		1.034156030621736e+03,		1.034697847878631e+03,		1.035237789404963e+03,
		1.035775869751288e+03,		1.036312103293150e+03,		1.036846504233912e+03,		1.037379086607586e+03,		1.037909864281554e+03,
		1.038438850959272e+03,		1.038966060182890e+03,		1.039491505335842e+03,		1.040015199645367e+03,		1.040537156184981e+03,
		1.041057387876913e+03,		1.041575907494481e+03,		1.042092727664413e+03,		1.042607860869143e+03,		1.043121319449044e+03,
		1.043633115604626e+03,		1.044143261398687e+03,		1.044651768758425e+03,		1.045158649477507e+03,		1.045663915218097e+03,
		1.046167577512849e+03,		1.046669647766858e+03,		1.047170137259580e+03,		1.047669057146700e+03,		1.048166418461988e+03,
		1.048662232119098e+03,		1.049156508913350e+03,		1.049649259523463e+03,		1.050140494513275e+03,		1.050630224333411e+03,
		1.051118459322933e+03,		1.051605209710956e+03,		1.052090485618234e+03,		1.052574297058721e+03,		1.053056653941093e+03,
		1.053537566070258e+03,		1.054017043148823e+03,		1.054495094778547e+03,		1.054971730461760e+03,		1.055446959602764e+03,
		1.055920791509198e+03,		1.056393235393393e+03,		1.056864300373689e+03,		1.057333995475742e+03,		1.057802329633796e+03,
		1.058269311691944e+03,		1.058734950405357e+03,		1.059199254441500e+03,		1.059662232381320e+03,		1.060123892720423e+03,
		1.060584243870217e+03,		1.061043294159048e+03,		1.061501051833314e+03,		1.061957525058554e+03,		1.062412721920525e+03,
		1.062866650426260e+03,		1.063319318505104e+03,		1.063770734009739e+03,		1.064220904717187e+03,		1.064669838329797e+03,
		1.065117542476222e+03,		1.065564024711078e+03,		1.066009292521368e+03,		1.066453353318638e+03,		1.066896214446157e+03,
		1.067337883178119e+03,		1.067778366720522e+03,		1.068217672212037e+03,		1.068655806724858e+03,		1.069092777265540e+03,
		1.069528590775832e+03,		1.069963254133480e+03,		1.070396774153033e+03,		1.070829157586627e+03,		1.071260411124760e+03,
		1.071690541397055e+03,		1.072119554973013e+03,		1.072547458362745e+03,		1.072974258017706e+03,		1.073399960331407e+03,
		1.073824571640126e+03,		1.074248098223590e+03,		1.074670546306499e+03,		1.075091922055160e+03,		1.075512231585908e+03,
		1.075931480958509e+03,		1.076349676179927e+03,		1.076766823204626e+03,		1.077182927935101e+03,		1.077597996222491e+03,
		1.078012033867181e+03,		1.078425046619403e+03,		1.078837040179818e+03,		1.079248020200099e+03,		1.079657992283498e+03,
		1.080066961985410e+03,		1.080474934813928e+03,		1.080881916230379e+03,		1.081287911649877e+03,		1.081692926441837e+03,
		1.082096965930509e+03,		1.082500035395484e+03,		1.082902140072209e+03,		1.083303285152478e+03,		1.083703475784931e+03,
		1.084102717075538e+03,		1.084501014088078e+03,		1.084898371844608e+03,		1.085294795325934e+03,		1.085690289472063e+03,
		1.086084859182662e+03,		1.086478509317500e+03,		1.086871244696885e+03,		1.087263070102107e+03,		1.087653990275853e+03,
		1.088044009922643e+03,		1.088433133709230e+03,		1.088821366265025e+03,		1.089208712182491e+03,		1.089595176017548e+03,
		1.089980762289963e+03,		1.090365475483742e+03,		1.090749320047508e+03,		1.091132300394882e+03,		1.091514420904856e+03,
		1.091895685922159e+03,		1.092276099757621e+03,		1.092655666688530e+03,		1.093034390957368e+03,		1.093412276778446e+03,
		1.093789328329079e+03,		1.094165549755871e+03,		1.094540945173608e+03,		1.094915518665580e+03,		1.095289274283914e+03,
		1.095662216049891e+03,		1.096034347954269e+03,		1.096405673957589e+03,		1.096776197990492e+03,		1.097145923954020e+03,
		1.097514855719920e+03,		1.097882997130936e+03,		1.098250352001112e+03,		1.098616924116075e+03,		1.098982717233323e+03,
		1.099347735082509e+03,		1.099711981365719e+03,		1.100075459757748e+03,		1.100438173906371e+03,		1.100800127432614e+03,
		1.101161323931018e+03,		1.101521766969901e+03,		1.101881460091615e+03,		1.102240406812805e+03,		1.102598610624660e+03,
		1.102956074993161e+03,		1.103312803359328e+03,		1.103668799139463e+03,		1.104024065725391e+03,		1.104378606484695e+03,
		1.104732424760951e+03,		1.105085523873965e+03,		1.105437907119990e+03,		1.105789577771963e+03,		1.106140539079723e+03,
		1.106490794270230e+03,		1.106840346547788e+03,		1.107189199094253e+03,		1.107537355069252e+03,		1.107884817610391e+03,
		1.108231589833461e+03,		1.108577674832644e+03,		1.108923075680716e+03,		1.109267795429247e+03,		1.109611837108799e+03,
		1.109955203729121e+03,		1.110297898279343e+03,		1.110639923728166e+03,		1.110981283024053e+03,		1.111321979095412e+03,
		1.111662014850782e+03,		1.112001393179018e+03,		1.112340116949467e+03,		1.112678189012147e+03,		1.113015612197924e+03,
		1.113352389318689e+03,		1.113688523167522e+03,		1.114024016518870e+03,		1.114358872128710e+03,		1.114693092734717e+03,
		1.115026681056430e+03,		1.115359639795412e+03,		1.115691971635410e+03,		1.116023679242517e+03,		1.116354765265326e+03,
		1.116685232335087e+03,		1.117015083065859e+03,		1.117344320054664e+03,		1.117672945881634e+03,		1.118000963110163e+03,
		1.118328374287051e+03,		1.118655181942651e+03,		1.118981388591011e+03,		1.119306996730016e+03,		1.119632008841532e+03,
		1.119956427391538e+03,		1.120280254830271e+03,		1.120603493592356e+03,		1.120926146096945e+03,		1.121248214747845e+03,
		1.121569701933654e+03,		1.121890610027889e+03,		1.122210941389113e+03,		1.122530698361068e+03,		1.122849883272793e+03,
		1.123168498438755e+03,		1.123486546158969e+03,		1.123804028719123e+03,		1.124120948390693e+03,		1.124437307431068e+03,
		1.124753108083667e+03,		1.125068352578052e+03,		1.125383043130048e+03,		1.125697181941856e+03,		1.126010771202165e+03,
		1.126323813086267e+03,		1.126636309756162e+03,		1.126948263360677e+03,		1.127259676035563e+03,		1.127570549903616e+03,
		1.127880887074766e+03,		1.128190689646201e+03,		1.128499959702456e+03,		1.128808699315527e+03,		1.129116910544964e+03,
		1.129424595437978e+03,		1.129731756029540e+03,		1.130038394342476e+03,		1.130344512387572e+03,		1.130650112163661e+03,
		1.130955195657731e+03,		1.131259764845007e+03,		1.131563821689058e+03,		1.131867368141878e+03,		1.132170406143987e+03
	},
	{
		1.777262161835364e+00,		5.389202350458308e+00,		9.076112458274833e+00,		1.284204810574039e+01,		1.669142833452212e+01,
		2.062908147105391e+01,		2.466029861441572e+01,		2.879089634920061e+01,		3.302729069569174e+01,		3.737658484822558e+01,
		4.184667396420485e+01,		4.644637121652583e+01,		5.118556060598725e+01,		5.607538378636511e+01,		6.112847058983048e+01,
		6.635922636698402e+01,		7.178419415653104e+01,		7.742251683471639e+01,		8.329653498946975e+01,		8.943257234488966e+01,
		9.586198557468951e+01,		1.026225953409956e+02,		1.097606813971129e+02,		1.173338375086256e+02,		1.254151833882453e+02,
		1.340998083748387e+02,		1.435150721493887e+02,		1.538379913918786e+02,		1.653266912478510e+02,		1.783827608373081e+02,
		1.936917889562376e+02,		2.126085601954079e+02,		2.386608591335446e+02,		7.014601851381713e+02,		7.160905871097777e+02,
		7.275743302624481e+02,		7.371829591050519e+02,		7.455205353470307e+02,		7.529288473030163e+02,		7.596226429193231e+02,
		7.657467854504939e+02,		7.714041933166578e+02,		7.766709420058702e+02,		7.816050570695971e+02,		7.862519376870688e+02,
		7.906478602818464e+02,		7.948223296117243e+02,		7.987997076257377e+02,		8.026003730643104e+02,		8.062415666034091e+02,
		8.097380195525578e+02,		8.131024300520240e+02,		8.163458295603207e+02,		8.194778689615172e+02,		8.225070447992299e+02,
		8.254408802334367e+02,		8.282860713192113e+02,		8.310486063675999e+02,		8.337338642012356e+02,		8.363466956803591e+02,
		8.388914918455262e+02,		8.413722412601549e+02,		8.437925785673114e+02,		8.461558258459910e+02,		8.484650280251736e+02,
		8.507229833623608e+02,		8.529322697979867e+02,		8.550952678443050e+02,		8.572141805467120e+02,		8.592910509597257e+02,
		8.613277775034562e+02,		8.633261275018901e+02,		8.652877491670297e+02,		8.672141822186912e+02,		8.691068673505627e+02,
		8.709671546705405e+02,		8.727963112550465e+02,		8.745955279258988e+02,		8.763659253444511e+02,		8.781085595043455e+02,
		8.798244266931422e+02,		8.815144679836130e+02,		8.831795733075027e+02,		8.848205851576806e+02,		8.864383019588812e+02,
		8.880334811421241e+02,		8.896068419537174e+02,		8.911590680259602e+02,		8.926908097335396e+02,		8.942026863567514e+02,
		8.956952880703794e+02,		8.971691777748347e+02,		8.986248927844385e+02,		9.000629463860405e+02,		9.014838292798115e+02,
		9.028880109127524e+02,		9.042759407144318e+02,		9.056480492434462e+02,		9.070047492522623e+02,		9.083464366773462e+02,
		9.096734915608056e+02,		9.109862789091854e+02,		9.122851494944808e+02,		9.135704406020328e+02,		9.148424767294450e+02,
		9.161015702403878e+02,		9.173480219767118e+02,		9.185821218320559e+02,		9.198041492898303e+02,		9.210143739282003e+02,
		9.222130558945023e+02,		9.234004463512525e+02,		9.245767878958362e+02,		9.257423149567992e+02,		9.268972541614105e+02,
		9.280418246945784e+02,		9.291762386246072e+02,		9.303007012176530e+02,		9.314154112334005e+02,		9.325205612046549e+02,
		9.336163377018838e+02,		9.347029215835763e+02,		9.357804882338895e+02,		9.368492077869521e+02,		9.379092453406217e+02,
		9.389607611588152e+02,		9.400039108637361e+02,		9.410388456185152e+02,		9.420657123008189e+02,		9.430846536679763e+02,
		9.440958085153057e+02,		9.450993118206900e+02,		9.460952948950172e+02,		9.470838855123855e+02,		9.480652080410761e+02,
		9.490393835670825e+02,		9.500065300119956e+02,		9.509667622455546e+02,		9.519201921931683e+02,		9.528669289386617e+02,
		9.538070788225066e+02,		9.547407455357770e+02,		9.556680302100542e+02,		9.565890315034713e+02,		9.575038456831373e+02,
		9.584125667040782e+02,		9.593152862848955e+02,		9.602120939803111e+02,		9.611030772507359e+02,		9.619883215290204e+02,
		9.628679102845247e+02,		9.637419250846162e+02,		9.646104456537660e+02,		9.654735499302957e+02,		9.663313141209422e+02,
		9.671838127533051e+02,		9.680311187262918e+02,		9.688733033586481e+02,		9.697104364356603e+02,		9.705425862541177e+02,
		9.713698196656080e+02,		9.721922021182145e+02,		9.730097976967016e+02,		9.738226691612469e+02,		9.746308779847700e+02,
		9.754344843889457e+02,		9.762335473789353e+02,		9.770281247769004e+02,		9.778182732543494e+02,		9.786040483633649e+02,
		9.793855045667642e+02,		9.801626952672217e+02,		9.809356728354111e+02,		9.817044886372129e+02,		9.824691930599938e+02,
		9.832298355380348e+02,		9.839864645771127e+02,		9.847391277782845e+02,		9.854878718608944e+02,		9.862327426848518e+02,
		9.869737852721840e+02,		9.877110438279101e+02,		9.884445617602614e+02,		9.891743817002606e+02,		9.899005455206956e+02,
		9.906230943545082e+02,		9.913420686126119e+02,		9.920575080011764e+02,		9.927694515383807e+02,		9.934779375706615e+02,
		9.941830037884804e+02,		9.948846872416218e+02,		9.955830243540339e+02,		9.962780509382383e+02,		9.969698022093219e+02,
		9.976583127985168e+02,		9.983436167663961e+02,		9.990257476156854e+02,		9.997047383037153e+02,		1.000380621254521e+03,
		1.001053428370596e+03,		1.001723191044330e+03,		1.002389940169112e+03,		1.003053706150148e+03,		1.003714518914960e+03,
		1.004372407923615e+03,		1.005027402178673e+03,		1.005679530234858e+03,		1.006328820208484e+03,		1.006975299786619e+03,
		1.007618996236009e+03,		1.008259936411773e+03,		1.008898146765859e+03,		1.009533653355290e+03,		1.010166481850194e+03,
		1.010796657541619e+03,		1.011424205349164e+03,		1.012049149828398e+03,		1.012671515178102e+03,		1.013291325247332e+03,
		1.013908603542289e+03,		1.014523373233035e+03,		1.015135657160034e+03,		1.015745477840530e+03,		1.016352857474777e+03,
		1.016957817952107e+03,		1.017560380856859e+03,		1.018160567474160e+03,		1.018758398795569e+03,		1.019353895524584e+03,
		1.019947078080780e+03,		1.020537966610219e+03,		1.021126580982528e+03,		1.021712940801498e+03,		1.022297065408518e+03,
		1.022878973887342e+03,		1.023458685068768e+03,		1.024036217535190e+03,		1.024611589625061e+03,		1.025184819437241e+03,
		1.025755924835255e+03,		1.026324923451458e+03,		1.026891832691099e+03,		1.027456669736296e+03,		1.028019451549930e+03,
		1.028580194879446e+03,		1.029138916260568e+03,		1.029695632020942e+03,		1.030250358283696e+03,		1.030803110970917e+03,
		1.031353905807059e+03,		1.031902758322282e+03,		1.032449683855708e+03,		1.032994697558619e+03,		1.033537814397577e+03,
		1.034079049157491e+03,		1.034618416444609e+03,		1.035155930689450e+03,		1.035691606149676e+03,		1.036225456912909e+03,
		1.036757496899482e+03,		1.037287739865138e+03,		1.037816199403674e+03,		1.038342888949531e+03,		1.038867821780330e+03,
		1.039391011019357e+03,		1.039912469638005e+03,		1.040432210458150e+03,		1.040950246154506e+03,		1.041466589256904e+03,
		1.041981252152554e+03,		1.042494247088236e+03,		1.043005586172472e+03,		1.043515281377641e+03,		1.044023344542052e+03,
		1.044529787371994e+03,		1.045034621443721e+03,		1.045537858205423e+03,		1.046039508979144e+03,		1.046539584962668e+03,
		1.047038097231374e+03,		1.047535056740045e+03,		1.048030474324658e+03,		1.048524360704126e+03,		1.049016726482019e+03,
		1.049507582148244e+03,		1.049996938080701e+03,		1.050484804546901e+03,		1.050971191705569e+03,		1.051456109608197e+03,
		1.051939568200584e+03,		1.052421577324346e+03,		1.052902146718389e+03,		1.053381286020375e+03,		1.053859004768137e+03,
		1.054335312401088e+03,		1.054810218260280e+03,		1.055283731595399e+03,		1.055755861556986e+03,		1.056226617204324e+03,
		1.056696007504919e+03,		1.057164041335766e+03,		1.057630727484579e+03,		1.058096074651018e+03,		1.058560091447883e+03,
		1.059022786402286e+03,		1.059484167956811e+03,		1.059944244470651e+03,		1.060403024220722e+03,		1.060860515402761e+03,
		1.061316726132408e+03,		1.061771664446267e+03,		1.062225338302946e+03,		1.062677755584086e+03,		1.063128924095370e+03,
		1.063578851567710e+03,		1.064027545657246e+03,		1.064475013948252e+03,		1.064921263952149e+03,		1.065366303109382e+03,
		1.065810138790156e+03,		1.066252778295330e+03,		1.066694228857300e+03,		1.067134497640872e+03,		1.067573591744112e+03,
		1.068011518199196e+03,		1.068448283973233e+03,		1.068883895969083e+03,		1.069318361026159e+03,		1.069751685921218e+03,
		1.070183877369137e+03,		1.070614942023678e+03,		1.071044886478248e+03,		1.071473717266631e+03,		1.071901440863722e+03,
		1.072328063686251e+03,		1.072753592093483e+03,		1.073178032387920e+03,		1.073601390815985e+03,		1.074023673568699e+03,
		1.074444886782346e+03,		1.074865036539128e+03,		1.075284128867811e+03,		1.075702169744362e+03,		1.076119165092572e+03,
		1.076535120784674e+03,		1.076950042641955e+03,		1.077363936435348e+03,		1.077776807886026e+03,		1.078188662665980e+03,
		1.078599506398593e+03,		1.079009344659207e+03,		1.079418182974056e+03,		1.079826026827047e+03,		1.080232881651284e+03,
		1.080638752835406e+03,		1.081043645722708e+03,		1.081447565611653e+03,		1.081850517756390e+03,		1.082252507367243e+03,
		1.082653539611219e+03,		1.083053619612487e+03,		1.083452752452861e+03,		1.083850943172275e+03,		1.084248196769249e+03,
		1.084644518201350e+03,		1.085039912385646e+03,		1.085434384199152e+03,		1.085827938479275e+03,		1.086220580024248e+03,
		1.086612313593558e+03,		1.087003143908369e+03,		1.087393075651943e+03,		1.087782113470051e+03,		1.088170261971373e+03,
		1.088557525727907e+03,		1.088943909275360e+03,		1.089329417113537e+03,		1.089714053706730e+03,		1.090097823484090e+03,
		1.090480730840009e+03,		1.090862780134482e+03,		1.091243975693476e+03,		1.091624321809291e+03,		1.092003822740907e+03,
		1.092382482714341e+03,		1.092760305922989e+03,		1.093137296527966e+03,		1.093513458658444e+03,		1.093888796411986e+03,
		1.094263313854865e+03,		1.094637015022397e+03,		1.095009903919253e+03,		1.095381984519779e+03,		1.095753260768299e+03,
		1.096123736579433e+03,		1.096493415838387e+03,		1.096862302401263e+03,		1.097230400095345e+03,		1.097597712719398e+03,
		1.097964244043948e+03,		1.098329997811573e+03,		1.098694977737177e+03,		1.099059187508273e+03,		1.099422630785248e+03,
		1.099785311201642e+03,		1.100147232364406e+03,		1.100508397854172e+03,		1.100868811225508e+03,		1.101228476007178e+03,
		1.101587395702391e+03,		1.101945573789055e+03,		1.102303013720024e+03,		1.102659718923339e+03,		1.103015692802473e+03,
		1.103370938736564e+03,		1.103725460080658e+03,		1.104079260165933e+03,		1.104432342299933e+03,		1.104784709766795e+03,
		1.105136365827472e+03,		1.105487313719952e+03,		1.105837556659482e+03,		1.106187097838777e+03,		1.106535940428242e+03,
		1.106884087576174e+03,		1.107231542408977e+03,		1.107578308031364e+03,		1.107924387526562e+03,		1.108269783956513e+03,
		1.108614500362073e+03,		1.108958539763206e+03,		1.109301905159181e+03,		1.109644599528763e+03,		1.109986625830402e+03,
		1.110327987002418e+03,		1.110668685963190e+03,		1.111008725611338e+03,		1.111348108825902e+03,		1.111686838466524e+03,
		1.112024917373619e+03,		1.112362348368556e+03,		1.112699134253827e+03,		1.113035277813221e+03,		1.113370781811985e+03,
		1.113705648997003e+03,		1.114039882096949e+03,		1.114373483822458e+03,		1.114706456866283e+03,		1.115038803903457e+03,
		1.115370527591450e+03,		1.115701630570323e+03,		1.116032115462883e+03,		1.116361984874838e+03,		1.116691241394945e+03,
		1.117019887595157e+03,		1.117347926030777e+03,		1.117675359240597e+03,		1.118002189747046e+03,		1.118328420056331e+03,
		1.118654052658577e+03,		1.118979090027970e+03,		1.119303534622892e+03,		1.119627388886058e+03,		1.119950655244650e+03,
		1.120273336110453e+03,		1.120595433879985e+03,		1.120916950934628e+03,		1.121237889640757e+03,		1.121558252349866e+03,
		1.121878041398702e+03,		1.122197259109380e+03,		1.122515907789511e+03,		1.122833989732328e+03,		1.123151507216801e+03,
		1.123468462507759e+03,		1.123784857856013e+03,		1.124100695498464e+03,		1.124415977658229e+03,		1.124730706544750e+03,
		1.125044884353907e+03,		1.125358513268134e+03,		1.125671595456530e+03,		1.125984133074966e+03,		1.126296128266195e+03,
		1.126607583159961e+03,		1.126918499873108e+03,		1.127228880509679e+03,		1.127538727161026e+03,		1.127848041905914e+03,
		1.128156826810616e+03,		1.128465083929025e+03,		1.128772815302745e+03,		1.129080022961197e+03,		1.129386708921712e+03,
		1.129692875189633e+03,		1.129998523758406e+03,		1.130303656609681e+03,		1.130608275713402e+03,		1.130912383027902e+03
	},
	{
		1.773630256927854e+00,		5.377820688180040e+00,		9.056288391613235e+00,		1.281301637034398e+01,		1.665234110569089e+01,
		2.057899669033034e+01,		2.459816621402296e+01,		2.871554190608397e+01,		3.293739592068341e+01,		3.727066414912507e+01,
		4.172304609910095e+01,		4.630312475356132e+01,		5.102051149603268e+01,		5.588602278843408e+01,		6.091189749438055e+01,
		6.611206683052123e+01,		7.150249332192199e+01,		7.710160149359781e+01,		8.293083240204724e+01,		8.901536822306528e+01,
		9.538509486911477e+01,		1.020759050510672e+02,		1.091315003791127e+02,		1.166059459321558e+02,		1.245673972800674e+02,
		1.331037263452102e+02,		1.423313681059030e+02,		1.524099479032560e+02,		1.635680433734345e+02,		1.761524484123075e+02,
		1.907335911469128e+02,		2.083716273141641e+02,		2.315011741923606e+02,		6.822335385795431e+02,		7.015644093519854e+02,
		7.154180937563247e+02,		7.265181700123334e+02,		7.359029298641522e+02,		7.440975493061347e+02,		7.514094356681279e+02,
		7.580358974099613e+02,		7.641119983999689e+02,		7.697347275077510e+02,		7.749763653565337e+02,		7.798923999457355e+02,
		7.845264730027105e+02,		7.889136084164543e+02,		7.930823968517507e+02,		7.970565197787457e+02,		8.008558407851165e+02,
		8.044972049207354e+02,		8.079950358958552e+02,		8.113617901305458e+02,		8.146083073676037e+02,		8.177440852054995e+02,
		8.207774967615302e+02,		8.237159652050198e+02,		8.265661051475033e+02,		8.293338382572387e+02,		8.320244886068192e+02,
		8.346428619243854e+02,		8.371933119418244e+02,		8.396797963111394e+02,		8.421059240198506e+02,		8.444749958309216e+02,
		8.467900389466179e+02,		8.490538368878886e+02,		8.512689553495479e+02,		8.534377646825016e+02,		8.555624595180516e+02,
		8.576450759686306e+02,		8.596875067466569e+02,		8.616915145156665e+02,		8.636587437052669e+02,		8.655907310042195e+02,
		8.674889147055665e+02,		8.693546430523210e+02,		8.711891817101576e+02,		8.729937204751019e+02,		8.747693793088933e+02,
		8.765172137817550e+02,		8.782382199914229e+02,		8.799333390180906e+02,		8.816034609670894e+02,		8.832494286444822e+02,
		8.848720409050321e+02,		8.864720557071306e+02,		8.880501929050737e+02,		8.896071368054235e+02,		8.911435385110777e+02,
		8.926600180739504e+02,		8.941571664747647e+02,		8.956355474464302e+02,		8.970956991556528e+02,		8.985381357558570e+02,
		8.999633488230875e+02,		9.013718086853621e+02,		9.027639656548548e+02,		9.041402511713370e+02,		9.055010788644632e+02,
		9.068468455417516e+02,		9.081779321072412e+02,		9.094947044237849e+02,		9.107975141052650e+02,		9.120866992668825e+02,
		9.133625852256506e+02,		9.146254851505701e+02,		9.158757006750448e+02,		9.171135224700970e+02,		9.183392307820543e+02,
		9.195530959373351e+02,		9.207553788167450e+02,		9.219463313014414e+02,		9.231261966937587e+02,		9.242952101075555e+02,
		9.254535988486056e+02,		9.266015827601175e+02,		9.277393745558782e+02,		9.288671801333405e+02,		9.299851988693804e+02,
		9.310936239007216e+02,		9.321926423877226e+02,		9.332824357658054e+02,		9.343631799827784e+02,		9.354350457240168e+02,
		9.364981986260484e+02,		9.375527994792754e+02,		9.385990044215242e+02,		9.396369651165439e+02,		9.406668289349059e+02,
		9.416887391144147e+02,		9.427028349188479e+02,		9.437092517878134e+02,		9.447081214795162e+02,		9.456995722068270e+02,
		9.466837287670112e+02,		9.476607126655084e+02,		9.486306422340622e+02,		9.495936327435064e+02,		9.505497965115236e+02,
		9.514992430056154e+02,		9.524420789415631e+02,		9.533784083775918e+02,		9.543083328044937e+02,		9.552319512318809e+02,
		9.561493602707999e+02,		9.570606542128826e+02,		9.579659251061878e+02,		9.588652628279336e+02,		9.597587551542488e+02,
		9.606464878270953e+02,		9.615285446185090e+02,		9.624050073922710e+02,		9.632759561631563e+02,		9.641414691538413e+02,
		9.650016228496252e+02,		9.658564920510162e+02,		9.667061499243296e+02,		9.675506680503510e+02,		9.683901164711808e+02,
		9.692245637353268e+02,		9.700540769411183e+02,		9.708787217785435e+02,		9.716985625695470e+02,		9.725136623068739e+02,
		9.733240826915261e+02,		9.741298841688744e+02,		9.749311259635040e+02,		9.757278661128290e+02,		9.765201614995436e+02,
		9.773080678829436e+02,		9.780916399291871e+02,		9.788709312405070e+02,		9.796459943834470e+02,		9.804168809161496e+02,
		9.811836414147315e+02,		9.819463254987828e+02,		9.827049818560391e+02,		9.834596582662381e+02,		9.842104016242072e+02,
		9.849572579622085e+02,		9.857002724715701e+02,		9.864394895236312e+02,		9.871749526900238e+02,		9.879067047623180e+02,
		9.886347877710699e+02,		9.893592430042615e+02,		9.900801110251892e+02,		9.907974316897975e+02,		9.915112441634973e+02,
		9.922215869374680e+02,		9.929284978444809e+02,		9.936320140742432e+02,		9.943321721883029e+02,		9.950290081344974e+02,
		9.957225572610015e+02,		9.964128543299499e+02,		9.970999335306860e+02,		9.977838284926106e+02,		9.984645722976848e+02,
		9.991421974925721e+02,		9.998167361004299e+02,		1.000488219632391e+03,		1.001156679098709e+03,		1.001822145019607e+03,
		1.002484647435824e+03,		1.003144215918874e+03,		1.003800879581031e+03,		1.004454667085040e+03,		1.005105606653569e+03,
		1.005753726078410e+03,		1.006399052729442e+03,		1.007041613563343e+03,		1.007681435132092e+03,		1.008318543591239e+03,
		1.008952964707958e+03,		1.009584723868905e+03,		1.010213846086482e+03,		1.010840356012041e+03,		1.011464277934151e+03,
		1.012085635791967e+03,		1.012704453180478e+03,		1.013320753357240e+03,		1.013934559248953e+03,		1.014545893457856e+03,
		1.015154778267978e+03,		1.015761235651236e+03,		1.016365287273380e+03,		1.016966954499798e+03,		1.017566258401183e+03,
		1.018163219759057e+03,		1.018757859071176e+03,		1.019350196556794e+03,		1.019940252161817e+03,		1.020528045563822e+03,
		1.021113596176968e+03,		1.021696923156796e+03,		1.022278045404910e+03,		1.022856981573550e+03,		1.023433750070077e+03,
		1.024008369061331e+03,		1.024580856477914e+03,		1.025151230018358e+03,		1.025719507153214e+03,		1.026285705129045e+03,
		1.026849840972323e+03,		1.027411931493250e+03,		1.027971993289494e+03,		1.028530042749839e+03,		1.029086096057752e+03,
		1.029640169194892e+03,		1.030192277944513e+03,		1.030742437894825e+03,		1.031290664442261e+03,		1.031836972794682e+03,
		1.032381377974523e+03,		1.032923894821851e+03,		1.033464537997389e+03,		1.034003321985444e+03,		1.034540261096801e+03,
		1.035075369471544e+03,		1.035608661081820e+03,		1.036140149734545e+03,		1.036669849074069e+03,		1.037197772584761e+03,
		1.037723933593564e+03,		1.038248345272492e+03,		1.038771020641069e+03,		1.039291972568734e+03,		1.039811213777181e+03,
		1.040328756842671e+03,		1.040844614198281e+03,		1.041358798136122e+03,		1.041871320809506e+03,		1.042382194235076e+03,
		1.042891430294888e+03,		1.043399040739684e+03,		1.043905037185623e+03,		1.044409431124838e+03,		1.044912233921093e+03,
		1.045413456813412e+03,		1.045913110917948e+03,		1.046411207229795e+03,		1.046907756624781e+03,		1.047402769861223e+03,
		1.047896257581646e+03,		1.048388230314475e+03,		1.048878698475699e+03,		1.049367672370490e+03,		1.049855162194809e+03,
		1.050341178036977e+03,		1.050825729879208e+03,		1.051308827599133e+03,		1.051790480971277e+03,		1.052270699668527e+03,
		1.052749493263554e+03,		1.053226871230234e+03,		1.053702842945023e+03,		1.054177417688314e+03,		1.054650604645778e+03,
		1.055122412909671e+03,		1.055592851480121e+03,		1.056061929266394e+03,		1.056529655088143e+03,		1.056996037676622e+03,
		1.057461085675893e+03,		1.057924807644004e+03,		1.058387212054150e+03,		1.058848307295812e+03,		1.059308101675878e+03,
		1.059766603419752e+03,		1.060223820672425e+03,		1.060679761499551e+03,		1.061134433888490e+03,		1.061587845749336e+03,
		1.062040004915938e+03,		1.062490919146886e+03,		1.062940596126494e+03,		1.063389043465771e+03,		1.063836268703355e+03,
		1.064282279306458e+03,		1.064727082671775e+03,		1.065170686126391e+03,		1.065613096926877e+03,		1.066054322266985e+03,
		1.066494369268730e+03,		1.066933244989478e+03,		1.067370956421281e+03,		1.067807510491694e+03,		1.068242914064585e+03,
		1.068677173940922e+03,		1.069110296859560e+03,		1.069542289498007e+03,		1.069973158473176e+03,		1.070402910342138e+03,
		1.070831551602848e+03,		1.071259088694870e+03,		1.071685528000089e+03,		1.072110875843405e+03,		1.072535138493429e+03,
		1.072958322163158e+03,		1.073380433010641e+03,		1.073801477139642e+03,		1.074221460600282e+03,		1.074640389389684e+03,
		1.075058269452596e+03,		1.075475106682013e+03,		1.075890906919789e+03,		1.076305675957230e+03,		1.076719419535696e+03,
		1.077132143347179e+03,		1.077543853034877e+03,		1.077954554193761e+03,		1.078364252371138e+03,		1.078772953067189e+03,
		1.079180661735525e+03,		1.079587383783709e+03,		1.079993124573791e+03,		1.080397889422817e+03,		1.080801683603353e+03,
		1.081204512343977e+03,		1.081606380829779e+03,		1.082007294202856e+03,		1.082407257562787e+03,		1.082806275967112e+03,
		1.083204354431805e+03,		1.083601497931725e+03,		1.083997711401085e+03,		1.084392999733894e+03,		1.084787367784401e+03,
		1.085180820367535e+03,		1.085573362259333e+03,		1.085964998197366e+03,		1.086355732881158e+03,		1.086745570972600e+03,
		1.087134517096359e+03,		1.087522575840275e+03,		1.087909751755764e+03,		1.088296049358207e+03,		1.088681473127334e+03,
		1.089066027507608e+03,		1.089449716908596e+03,		1.089832545705347e+03,		1.090214518238750e+03,		1.090595638815898e+03,
		1.090975911710446e+03,		1.091355341162958e+03,		1.091733931381257e+03,		1.092111686540766e+03,		1.092488610784842e+03,
		1.092864708225117e+03,		1.093239982941817e+03,		1.093614438984094e+03,		1.093988080370343e+03,		1.094360911088517e+03,
		1.094732935096441e+03,		1.095104156322120e+03,		1.095474578664038e+03,		1.095844205991468e+03,		1.096213042144756e+03,
		1.096581090935623e+03,		1.096948356147449e+03,		1.097314841535557e+03,		1.097680550827499e+03,		1.098045487723331e+03,
		1.098409655895884e+03,		1.098773058991042e+03,		1.099135700628001e+03,		1.099497584399543e+03,		1.099858713872287e+03,
		1.100219092586951e+03,		1.100578724058610e+03,		1.100937611776940e+03,		1.101295759206469e+03,		1.101653169786825e+03,
		1.102009846932973e+03,		1.102365794035459e+03,		1.102721014460641e+03,		1.103075511550928e+03,		1.103429288625003e+03,
		1.103782348978058e+03,		1.104134695882015e+03,		1.104486332585750e+03,		1.104837262315309e+03,		1.105187488274127e+03,
		1.105537013643247e+03,		1.105885841581522e+03,		1.106233975225829e+03,		1.106581417691282e+03,		1.106928172071423e+03,
		1.107274241438435e+03,		1.107619628843335e+03,		1.107964337316177e+03,		1.108308369866238e+03,		1.108651729482219e+03,
		1.108994419132433e+03,		1.109336441764988e+03,		1.109677800307978e+03,		1.110018497669668e+03,		1.110358536738670e+03,
		1.110697920384126e+03,		1.111036651455885e+03,		1.111374732784677e+03,		1.111712167182289e+03,		1.112048957441735e+03,
		1.112385106337421e+03,		1.112720616625323e+03,		1.113055491043142e+03,		1.113389732310470e+03,		1.113723343128960e+03,
		1.114056326182474e+03,		1.114388684137250e+03,		1.114720419642055e+03,		1.115051535328338e+03,		1.115382033810387e+03,
		1.115711917685480e+03,		1.116041189534028e+03,		1.116369851919732e+03,		1.116697907389724e+03,		1.117025358474713e+03,
		1.117352207689127e+03,		1.117678457531257e+03,		1.118004110483394e+03,		1.118329169011969e+03,		1.118653635567691e+03,
		1.118977512585680e+03,		1.119300802485601e+03,		1.119623507671801e+03,		1.119945630533434e+03,		1.120267173444595e+03,
		1.120588138764446e+03,		1.120908528837341e+03,		1.121228345992959e+03,		1.121547592546421e+03,		1.121866270798416e+03,
		1.122184383035318e+03,		1.122501931529316e+03,		1.122818918538522e+03,		1.123135346307097e+03,		1.123451217065363e+03,
		1.123766533029918e+03,		1.124081296403754e+03,		1.124395509376367e+03,		1.124709174123869e+03,		1.125022292809098e+03,
		1.125334867581728e+03,		1.125646900578379e+03,		1.125958393922720e+03,		1.126269349725579e+03,		1.126579770085046e+03,
		1.126889657086578e+03,		1.127199012803099e+03,		1.127507839295105e+03,		1.127816138610762e+03,		1.128123912786010e+03,
		1.128431163844655e+03,		1.128737893798473e+03,		1.129044104647302e+03,		1.129349798379140e+03,		1.129654976970240e+03
	},
	{
		1.770013423000225e+00,		5.366489482835954e+00,		9.036558141474096e+00,		1.278413121930609e+01,		1.661346436217817e+01,
		2.052919951215118e+01,		2.453641427770176e+01,		2.864067961698100e+01,		3.284812760209737e+01,		3.716553149306851e+01,
		4.160040095466815e+01,		4.616109605090907e+01,		5.085696472615059e+01,		5.569850993867377e+01,		6.069759461368506e+01,
		6.586769536986534e+01,		7.122421991482176e+01,		7.678490867139350e+01,		8.257034949452269e+01,		8.860464673779697e+01,
		9.491630488023398e+01,		1.015394166319393e+02,		1.085152933576501e+02,		1.158947555140050e+02,		1.237414389576001e+02,
		1.321367226845548e+02,		1.411873587524895e+02,		1.510378472744131e+02,		1.618917016081417e+02,		1.740508060048751e+02,
		1.879958711055381e+02,		2.045758926949540e+02,		2.255654277630532e+02,		2.561871763568704e+02,		6.839335124310107e+02,
		7.015663241040402e+02,		7.147476416707727e+02,		7.254921920465921e+02,		7.346617949917885e+02,		7.427156885849862e+02,
		7.499309068585256e+02,		7.564888000361750e+02,		7.625152449162279e+02,		7.681015720740487e+02,		7.733163914967434e+02,
		7.782127100740311e+02,		7.828324357932271e+02,		7.872093474787933e+02,		7.913711210581508e+02,		7.953407529312776e+02,
		7.991375851673774e+02,		8.027780602023391e+02,		8.062762871465723e+02,		8.096444739953920e+02,		8.128932625160669e+02,
		8.160319912631151e+02,		8.190689046808594e+02,		8.220113211904563e+02,		8.248657696627035e+02,		8.276381012479027e+02,
		8.303335817787796e+02,		8.329569687067082e+02,		8.355125756216291e+02,		8.380043267095681e+02,		8.404358029976080e+02,
		8.428102818447060e+02,		8.451307708491682e+02,		8.474000370851052e+02,		8.496206324537525e+02,		8.517949157386585e+02,
		8.539250718796783e+02,		8.560131288785575e+02,		8.580609726800168e+02,		8.600703603149168e+02,		8.620429315454026e+02,
		8.639802192139329e+02,		8.658836584667409e+02,		8.677545949965298e+02,		8.695942924277256e+02,		8.714039389498257e+02,
		8.731846532893569e+02,		8.749374900985268e+02,		8.766634448279332e+02,		8.783634581418189e+02,		8.800384199267005e+02,
		8.816891729376841e+02,		8.833165161212501e+02,		8.849212076484949e+02,		8.865039676886942e+02,		8.880654809495414e+02,
		8.896063990072767e+02,		8.911273424473368e+02,		8.926289028327654e+02,		8.941116445229023e+02,		8.955761063400973e+02,
		8.970228031212637e+02,		8.984522271464479e+02,		8.998648494631771e+02,		9.012611211143321e+02,		9.026414742778792e+02,
		9.040063233259597e+02,		9.053560658101286e+02,		9.066910833788279e+02,		9.080117426326652e+02,		9.093183959224648e+02,
		9.106113820946895e+02,		9.118910271883007e+02,		9.131576450868629e+02,		9.144115381292891e+02,		9.156529976823442e+02,
		9.168823046777668e+02,		9.180997301166038e+02,		9.193055355431306e+02,		9.204999734914755e+02,		9.216832879005220e+02,
		9.228557145181553e+02,		9.240174812645063e+02,		9.251688085877933e+02,		9.263099097949362e+02,		9.274409913647146e+02,
		9.285622532437352e+02,		9.296738891263476e+02,		9.307760867195497e+02,		9.318690279948829e+02,		9.329528894216792e+02,
		9.340278421994904e+02,		9.350940524668011e+02,		9.361516815053002e+02,		9.372008859325827e+02,		9.382418178852630e+02,
		9.392746251930597e+02,		9.402994515443975e+02,		9.413164366440120e+02,		9.423257163630225e+02,		9.433274228818976e+02,
		9.443216848267371e+02,		9.453086273992054e+02,		9.462883725005122e+02,		9.472610388497437e+02,		9.482267420968504e+02,
		9.491855949305981e+02,		9.501377071817317e+02,		9.510831859216237e+02,		9.520221355566267e+02,		9.529546579183714e+02,
		9.538808523502071e+02,		9.548008157899847e+02,		9.557146428493745e+02,		9.566224258898829e+02,		9.575242550957407e+02,
		9.584202185438157e+02,		9.593104022706900e+02,		9.601948903370513e+02,		9.610737648895100e+02,		9.619471062199935e+02,
		9.628149928227972e+02,		9.636775014494300e+02,		9.645347071613468e+02,		9.653866833806690e+02,		9.662335019389723e+02,
		9.670752331242591e+02,		9.679119457261596e+02,		9.687437070794799e+02,		9.695705831061304e+02,		9.703926383555493e+02,
		9.712099360436468e+02,		9.720225380903662e+02,		9.728305051558974e+02,		9.736338966756183e+02,		9.744327708938083e+02,
		9.752271848961910e+02,		9.760171946413466e+02,		9.768028549910566e+02,		9.775842197396082e+02,		9.783613416421098e+02,
		9.791342724418610e+02,		9.799030628968023e+02,		9.806677628051027e+02,		9.814284210298906e+02,		9.821850855231950e+02,
		9.829378033490981e+02,		9.836866207061502e+02,		9.844315829490708e+02,		9.851727346097476e+02,		9.859101194175992e+02,
		9.866437803192684e+02,		9.873737594977329e+02,		9.881000983908056e+02,		9.888228377090802e+02,		9.895420174533159e+02,
		9.902576769313165e+02,		9.909698547742804e+02,		9.916785889526718e+02,		9.923839167916254e+02,		9.930858749858860e+02,
		9.937844996143170e+02,		9.944798261539844e+02,		9.951718894938317e+02,		9.958607239479638e+02,		9.965463632685513e+02,
		9.972288406583622e+02,		9.979081887829482e+02,		9.985844397824818e+02,		9.992576252832652e+02,		9.999277764089245e+02,
		1.000594923790140e+03,		1.001259097580033e+03,		1.001920327456899e+03,		1.002578642639539e+03,		1.003234071895593e+03,
		1.003886643551027e+03,		1.004536385499370e+03,		1.005183325210697e+03,		1.005827489740387e+03,		1.006468905737639e+03,
		1.007107599452636e+03,		1.007743596749402e+03,		1.008376923106171e+03,		1.009007603628333e+03,		1.009635663054527e+03,
		1.010261125763919e+03,		1.010884015783325e+03,		1.011504356794133e+03,		1.012122172139061e+03,		1.012737484828747e+03,
		1.013350317548181e+03,		1.013960692662970e+03,		1.014568632225454e+03,		1.015174157980683e+03,		1.015777291372230e+03,
		1.016378053547889e+03,		1.016976465365213e+03,		1.017572547396939e+03,		1.018166319936272e+03,		1.018757803002054e+03,
		1.019347016343805e+03,		1.019933979446653e+03,		1.020518711536146e+03,		1.021101231582951e+03,		1.021681558307447e+03,
		1.022259710184222e+03,		1.022835705446452e+03,		1.023409562090193e+03,		1.023981297878570e+03,		1.024550930345876e+03,
		1.025118476801582e+03,		1.025683954334248e+03,		1.026247379815358e+03,		1.026808769903071e+03,		1.027368141045879e+03,
		1.027925509486195e+03,		1.028480891263865e+03,		1.029034302219595e+03,		1.029585757998314e+03,		1.030135274052459e+03,
		1.030682865645192e+03,		1.031228547854531e+03,		1.031772335572152e+03,		1.032314243513480e+03,		1.032854286215383e+03,
		1.033392478040564e+03,		1.033928833180389e+03,		1.034463365657668e+03,		1.034996089329364e+03,		1.035527017889265e+03,
		1.036056164870585e+03,		1.036583543648520e+03,		1.037109167442760e+03,		1.037633049319933e+03,		1.038155202196020e+03,
		1.038675638838703e+03,		1.039194371869686e+03,		1.039711413766951e+03,		1.040226776866986e+03,		1.040740473366959e+03,
		1.041252515326858e+03,		1.041762914671577e+03,		1.042271683192976e+03,		1.042778832551893e+03,		1.043284374280120e+03,
		1.043788319782339e+03,		1.044290680338025e+03,		1.044791467103311e+03,		1.045290691112817e+03,		1.045788363281443e+03,
		1.046284494406138e+03,		1.046779095167623e+03,		1.047272176132089e+03,		1.047763747752866e+03,		1.048253820372055e+03,
		1.048742404222135e+03,		1.049229509427538e+03,		1.049715146006195e+03,		1.050199323871060e+03,		1.050682052829919e+03,
		1.051163342593157e+03,		1.051643202766289e+03,		1.052121642856990e+03,		1.052598672275153e+03,		1.053074300334250e+03,
		1.053548536252671e+03,		1.054021389155042e+03,		1.054492868073518e+03,		1.054962981949051e+03,		1.055431739632643e+03,
		1.055899149886564e+03,		1.056365221385570e+03,		1.056829962718075e+03,		1.057293382387325e+03,		1.057755488812539e+03,
		1.058216290330034e+03,		1.058675795194333e+03,		1.059134011579252e+03,		1.059590947578967e+03,		1.060046611209070e+03,
		1.060501010407599e+03,		1.060954153036055e+03,		1.061406046880406e+03,		1.061856699652064e+03,		1.062306118988859e+03,
		1.062754312455982e+03,		1.063201287546930e+03,		1.063647051684422e+03,		1.064091612221300e+03,		1.064534976441432e+03,
		1.064977151560575e+03,		1.065418144727249e+03,		1.065857963023575e+03,		1.066296613466122e+03,		1.066734103006720e+03,
		1.067170438533271e+03,		1.067605626870550e+03,		1.068039674780980e+03,		1.068472588965410e+03,		1.068904376063872e+03,
		1.069335042656330e+03,		1.069764595263414e+03,		1.070193040347146e+03,		1.070620384311650e+03,		1.071046633503860e+03,
		1.071471794214206e+03,		1.071895872677298e+03,		1.072318875072598e+03,		1.072740807525076e+03,		1.073161676105866e+03,
		1.073581486832901e+03,		1.074000245671549e+03,		1.074417958535231e+03,		1.074834631286037e+03,		1.075250269735323e+03,
		1.075664879644314e+03,		1.076078466724682e+03,		1.076491036639127e+03,		1.076902595001944e+03,		1.077313147379582e+03,
		1.077722699291197e+03,		1.078131256209196e+03,		1.078538823559775e+03,		1.078945406723441e+03,		1.079351011035538e+03,
		1.079755641786760e+03,		1.080159304223653e+03,		1.080562003549117e+03,		1.080963744922896e+03,		1.081364533462061e+03,
		1.081764374241490e+03,		1.082163272294339e+03,		1.082561232612502e+03,		1.082958260147075e+03,		1.083354359808799e+03,
		1.083749536468516e+03,		1.084143794957595e+03,		1.084537140068376e+03,		1.084929576554588e+03,		1.085321109131776e+03,
		1.085711742477714e+03,		1.086101481232811e+03,		1.086490330000521e+03,		1.086878293347733e+03,		1.087265375805174e+03,
		1.087651581867786e+03,		1.088036915995116e+03,		1.088421382611691e+03,		1.088804986107386e+03,		1.089187730837798e+03,
		1.089569621124602e+03,		1.089950661255909e+03,		1.090330855486625e+03,		1.090710208038790e+03,		1.091088723101927e+03,
		1.091466404833379e+03,		1.091843257358642e+03,		1.092219284771699e+03,		1.092594491135340e+03,		1.092968880481488e+03,
		1.093342456811513e+03,		1.093715224096548e+03,		1.094087186277795e+03,		1.094458347266832e+03,		1.094828710945914e+03,
		1.095198281168271e+03,		1.095567061758397e+03,		1.095935056512345e+03,		1.096302269198012e+03,		1.096668703555419e+03,
		1.097034363296992e+03,		1.097399252107834e+03,		1.097763373646005e+03,		1.098126731542779e+03,		1.098489329402920e+03,
		1.098851170804932e+03,		1.099212259301331e+03,		1.099572598418891e+03,		1.099932191658896e+03,		1.100291042497395e+03,
		1.100649154385444e+03,		1.101006530749348e+03,		1.101363174990903e+03,		1.101719090487632e+03,		1.102074280593022e+03,
		1.102428748636750e+03,		1.102782497924915e+03,		1.103135531740263e+03,		1.103487853342410e+03,		1.103839465968064e+03,
		1.104190372831237e+03,		1.104540577123469e+03,		1.104890082014030e+03,		1.105238890650139e+03,		1.105587006157168e+03,
		1.105934431638843e+03,		1.106281170177455e+03,		1.106627224834052e+03,		1.106972598648643e+03,		1.107317294640389e+03,
		1.107661315807797e+03,		1.108004665128915e+03,		1.108347345561516e+03,		1.108689360043284e+03,		1.109030711492005e+03,
		1.109371402805742e+03,		1.109711436863017e+03,		1.110050816522993e+03,		1.110389544625643e+03,		1.110727623991931e+03,
		1.111065057423980e+03,		1.111401847705241e+03,		1.111737997600667e+03,		1.112073509856871e+03,		1.112408387202298e+03,
		1.112742632347381e+03,		1.113076247984707e+03,		1.113409236789171e+03,		1.113741601418138e+03,		1.114073344511594e+03,
		1.114404468692302e+03,		1.114734976565952e+03,		1.115064870721313e+03,		1.115394153730381e+03,		1.115722828148525e+03,
		1.116050896514635e+03,		1.116378361351258e+03,		1.116705225164752e+03,		1.117031490445414e+03,		1.117357159667630e+03,
		1.117682235290003e+03,		1.118006719755496e+03,		1.118330615491563e+03,		1.118653924910282e+03,		1.118976650408489e+03,
		1.119298794367904e+03,		1.119620359155263e+03,		1.119941347122447e+03,		1.120261760606602e+03,		1.120581601930269e+03,
		1.120900873401505e+03,		1.121219577314006e+03,		1.121537715947228e+03,		1.121855291566504e+03,		1.122172306423164e+03,
		1.122488762754653e+03,		1.122804662784644e+03,		1.123120008723157e+03,		1.123434802766664e+03,		1.123749047098213e+03,
		1.124062743887528e+03,		1.124375895291121e+03,		1.124688503452410e+03,		1.125000570501812e+03,		1.125312098556861e+03,
		1.125623089722307e+03,		1.125933546090223e+03,		1.126243469740106e+03,		1.126552862738983e+03,		1.126861727141506e+03,
		1.127170064990060e+03,		1.127477878314852e+03,		1.127785169134018e+03,		1.128091939453717e+03,		1.128398191268223e+03
	},
	{
		1.766411564079631e+00,		5.355208376566467e+00,		9.016920973533432e+00,		1.275539139502410e+01,		1.657479613480780e+01,
		2.047968701390489e+01,		2.447503861807139e+01,		2.856630362785680e+01,		3.275947769865615e+01,		3.706117597433030e+01,
		4.147872387538435e+01,		4.602026553903725e+01,		5.069489427159549e+01,		5.551281070115899e+01,		6.048551613394175e+01,
		6.562605113313064e+01,		7.094929287697397e+01,		7.647232990850355e+01,		8.221494024286831e+01,		8.820020970465913e+01,
		9.445534389755882e+01,		1.010127528759227e+02,		1.079115285453756e+02,		1.151995022314641e+02,		1.229361848187303e+02,
		1.311970961559823e+02,		1.400803714383174e+02,		1.497172850810011e+02,		1.602899281783895e+02,		1.720629673174721e+02,
		1.854459775430695e+02,		2.011317322279235e+02,		2.204650056162025e+02,		2.467982378234133e+02,		6.602646022064980e+02,
		6.851788027775567e+02,		7.014935424180612e+02,		7.140816896357647e+02,		7.244949219025717e+02,		7.334575949852563e+02,
		7.413731974680054e+02,		7.484918187907365e+02,		7.549801986549761e+02,		7.609556134866219e+02,		7.665040086352625e+02,
		7.716904555084391e+02,		7.765655443411247e+02,		7.811694798449910e+02,		7.855348086063680e+02,		7.896882953533581e+02,
		7.936522500515009e+02,		7.974454893882773e+02,		8.010840481466756e+02,		8.045817153570561e+02,		8.079504450867913e+02,
		8.112006758164522e+02,		8.143415820544275e+02,		8.173812749291943e+02,		8.203269638413359e+02,		8.231850880180359e+02,
		8.259614245366284e+02,		8.286611777567914e+02,		8.312890539201537e+02,		8.338493238175520e+02,		8.363458757550420e+02,
		8.387822606108759e+02,		8.411617303582228e+02,		8.434872711793009e+02,		8.457616320658755e+02,		8.479873496325466e+02,
		8.501667697352223e+02,		8.523020663807607e+02,		8.543952583288939e+02,		8.564482237193248e+02,		8.584627130016671e+02,
		8.604403604010654e+02,		8.623826941155772e+02,		8.642911454111982e+02,		8.661670567554677e+02,		8.680116891098698e+02,
		8.698262284839167e+02,		8.716117918393578e+02,		8.733694324207463e+02,		8.751001445774427e+02,		8.768048681398438e+02,
		8.784844923844594e+02,		8.801398596535587e+02,		8.817717686488133e+02,		8.833809774407451e+02,		8.849682062216793e+02,
		8.865341398281090e+02,		8.880794300553310e+02,		8.896046977846148e+02,		8.911105349409081e+02,		8.925975062970555e+02,
		8.940661511389612e+02,		8.955169848032510e+02,		8.969505001019156e+02,		8.983671686415336e+02,		8.997674420421073e+02,
		9.011517530770320e+02,		9.025205167259534e+02,		9.038741311571526e+02,		9.052129786421510e+02,		9.065374264084724e+02,
		9.078478274355580e+02,		9.091445211982991e+02,		9.104278343623100e+02,		9.116980814346496e+02,		9.129555653733861e+02,
		9.142005781591007e+02,		9.154334013311574e+02,		9.166543064913193e+02,		9.178635557770664e+02,		9.190614023068224e+02,
		9.202480905990119e+02,		9.214238569668325e+02,		9.225889298904091e+02,		9.237435303690537e+02,		9.248878722474852e+02,
		9.260221625372155e+02,		9.271466017064558e+02,		9.282613839616547e+02,		9.293666975124074e+02,		9.304627248223361e+02,
		9.315496428468209e+02,		9.326276232584307e+02,		9.336968326607735e+02,		9.347574327915165e+02,		9.358095807151972e+02,
		9.368534290064595e+02,		9.378891259242806e+02,		9.389168155777121e+02,		9.399366380836248e+02,		9.409487297169394e+02,
		9.419532230537459e+02,		9.429502471077319e+02,		9.439399274602814e+02,		9.449223863846148e+02,		9.458977429642680e+02,
		9.468661132062522e+02,		9.478276101491500e+02,		9.487823439664456e+02,		9.497304220653172e+02,		9.506719491811522e+02,
		9.516070274679913e+02,		9.525357565851181e+02,		9.534582337799933e+02,		9.543745539677087e+02,		9.552848098071543e+02,
		9.561890917740418e+02,		9.570874882309540e+02,		9.579800854945521e+02,		9.588669679001067e+02,		9.597482178634393e+02,
		9.606239159404355e+02,		9.614941408842262e+02,		9.623589697001548e+02,		9.632184776986188e+02,		9.640727385459069e+02,
		9.649218243131077e+02,		9.657658055231766e+02,		9.666047511962531e+02,		9.674387288933050e+02,		9.682678047581711e+02,
		9.690920435580653e+02,		9.699115087226318e+02,		9.707262623815891e+02,		9.715363654010457e+02,		9.723418774185188e+02,
		9.731428568767419e+02,		9.739393610562906e+02,		9.747314461070757e+02,		9.755191670787676e+02,		9.763025779501829e+02,
		9.770817316576706e+02,		9.778566801225586e+02,		9.786274742776778e+02,		9.793941640930124e+02,		9.801567986005123e+02,
		9.809154259180850e+02,		9.816700932728264e+02,		9.824208470234926e+02,		9.831677326822621e+02,		9.839107949358028e+02,
		9.846500776656746e+02,		9.853856239681061e+02,		9.861174761731386e+02,		9.868456758631912e+02,		9.875702638910542e+02,
		9.882912803973343e+02,		9.890087648273696e+02,		9.897227559476387e+02,		9.904332918616809e+02,		9.911404100255361e+02,
		9.918441472627416e+02,		9.925445397788782e+02,		9.932416231756991e+02,		9.939354324648471e+02,		9.946260020811778e+02,
		9.953133658945376e+02,		9.959975572272479e+02,		9.966786088585421e+02,		9.973565530419500e+02,		9.980314215153738e+02,
		9.987032455123122e+02,		9.993720557727802e+02,		1.000037882553918e+03,		1.000700755640327e+03,		1.001360704354116e+03,
		1.002017757564675e+03,		1.002671943698194e+03,		1.003323290746924e+03,		1.003971826278197e+03,		1.004617577443200e+03,
		1.005260570985535e+03,		1.005900833249536e+03,		1.006538390188390e+03,		1.007173267372034e+03,		1.007805489994863e+03,
		1.008435082883228e+03,		1.009062070502761e+03,		1.009686476965493e+03,		1.010308326036823e+03,		1.010927641142282e+03,
		1.011544445374159e+03,		1.012158761497939e+03,		1.012770611958598e+03,		1.013380018886743e+03,		1.013987004104599e+03,
		1.014591589131849e+03,		1.015193795191345e+03,		1.015793643214675e+03,		1.016391153847590e+03,		1.016986347455326e+03,
		1.017579244128762e+03,		1.018169863685124e+03,		1.018758225680239e+03,		1.019344349407827e+03,		1.019928253905834e+03,
		1.020509957961035e+03,		1.021089480113541e+03,		1.021666838661197e+03,		1.022242051663883e+03,		1.022815136947713e+03,
		1.023386112109157e+03,		1.023954994519054e+03,		1.024521801326540e+03,		1.025086549462898e+03,		1.025649255645316e+03,
		1.026209936380565e+03,		1.026768607968594e+03,		1.027325286506057e+03,		1.027879987889753e+03,		1.028432727819995e+03,
		1.028983521803915e+03,		1.029532385158685e+03,		1.030079333014685e+03,		1.030624380318591e+03,		1.031167541836405e+03,
		1.031708832156426e+03,		1.032248265692147e+03,		1.032785856685104e+03,		1.033321619207659e+03,		1.033855567165729e+03,
		1.034387714301462e+03,		1.034918074194153e+03,		1.035446660269054e+03,		1.035973485791215e+03,		1.036498563873338e+03,
		1.037021907476922e+03,		1.037543529414640e+03,		1.038063442352647e+03,		1.038581658812863e+03,		1.039098191175199e+03,
		1.039613051679737e+03,		1.040126252428882e+03,		1.040637805389458e+03,		1.041147722394769e+03,		1.041656015146622e+03,
		1.042162695217308e+03,		1.042667774051548e+03,		1.043171262968399e+03,		1.043673173163127e+03,		1.044173515709045e+03,
		1.044672301559312e+03,		1.045169541548700e+03,		1.045665246395337e+03,		1.046159426702402e+03,		1.046652092959799e+03,
		1.047143255545804e+03,		1.047632924728664e+03,		1.048121110668193e+03,		1.048607823417312e+03,		1.049093072923583e+03,
		1.049576869030701e+03,		1.050059221479966e+03,		1.050540139911729e+03,		1.051019633866803e+03,		1.051497712787868e+03,
		1.051974386020830e+03,		1.052449662816166e+03,		1.052923552330253e+03,		1.053396063626654e+03,		1.053867205677401e+03,
		1.054336987364245e+03,		1.054805417479889e+03,		1.055272504729197e+03,		1.055738257730381e+03,		1.056202685016173e+03,
		1.056665795034973e+03,		1.057127596151979e+03,		1.057588096650295e+03,		1.058047304732027e+03,		1.058505228519349e+03,
		1.058961876055567e+03,		1.059417255306149e+03,		1.059871374159753e+03,		1.060324240429223e+03,		1.060775861852580e+03,
		1.061226246093993e+03,		1.061675400744733e+03,		1.062123333324109e+03,		1.062570051280401e+03,		1.063015561991758e+03,
		1.063459872767100e+03,		1.063902990846993e+03,		1.064344923404519e+03,		1.064785677546126e+03,		1.065225260312463e+03,
		1.065663678679210e+03,		1.066100939557890e+03,		1.066537049796663e+03,		1.066972016181117e+03,		1.067405845435040e+03,
		1.067838544221184e+03,		1.068270119142014e+03,		1.068700576740445e+03,		1.069129923500574e+03,		1.069558165848390e+03,
		1.069985310152482e+03,		1.070411362724733e+03,		1.070836329821008e+03,		1.071260217641815e+03,		1.071683032332980e+03,
		1.072104779986295e+03,		1.072525466640161e+03,		1.072945098280222e+03,		1.073363680839988e+03,		1.073781220201452e+03,
		1.074197722195692e+03,		1.074613192603471e+03,		1.075027637155821e+03,		1.075441061534626e+03,		1.075853471373188e+03,
		1.076264872256793e+03,		1.076675269723264e+03,		1.077084669263504e+03,		1.077493076322038e+03,		1.077900496297540e+03,
		1.078306934543358e+03,		1.078712396368025e+03,		1.079116887035773e+03,		1.079520411767027e+03,		1.079922975738901e+03,
		1.080324584085684e+03,		1.080725241899321e+03,		1.081124954229880e+03,		1.081523726086025e+03,		1.081921562435470e+03,
		1.082318468205435e+03,		1.082714448283091e+03,		1.083109507515999e+03,		1.083503650712550e+03,		1.083896882642386e+03,
		1.084289208036824e+03,		1.084680631589280e+03,		1.085071157955668e+03,		1.085460791754814e+03,		1.085849537568852e+03,
		1.086237399943620e+03,		1.086624383389046e+03,		1.087010492379535e+03,		1.087395731354346e+03,		1.087780104717965e+03,
		1.088163616840472e+03,		1.088546272057910e+03,		1.088928074672636e+03,		1.089309028953681e+03,		1.089689139137096e+03,
		1.090068409426296e+03,		1.090446843992404e+03,		1.090824446974581e+03,		1.091201222480363e+03,		1.091577174585982e+03,
		1.091952307336691e+03,		1.092326624747085e+03,		1.092700130801411e+03,		1.093072829453884e+03,		1.093444724628980e+03,
		1.093815820221758e+03,		1.094186120098141e+03,		1.094555628095219e+03,		1.094924348021538e+03,		1.095292283657388e+03,
		1.095659438755083e+03,		1.096025817039248e+03,		1.096391422207086e+03,		1.096756257928658e+03,		1.097120327847148e+03,
		1.097483635579135e+03,		1.097846184714847e+03,		1.098207978818428e+03,		1.098569021428191e+03,		1.098929316056870e+03,
		1.099288866191874e+03,		1.099647675295529e+03,		1.100005746805325e+03,		1.100363084134156e+03,		1.100719690670557e+03,
		1.101075569778941e+03,		1.101430724799829e+03,		1.101785159050079e+03,		1.102138875823117e+03,		1.102491878389155e+03,
		1.102844169995414e+03,		1.103195753866346e+03,		1.103546633203844e+03,		1.103896811187460e+03,		1.104246290974612e+03,
		1.104595075700795e+03,		1.104943168479788e+03,		1.105290572403852e+03,		1.105637290543934e+03,		1.105983325949867e+03,
		1.106328681650564e+03,		1.106673360654214e+03,		1.107017365948470e+03,		1.107360700500642e+03,		1.107703367257883e+03,
		1.108045369147373e+03,		1.108386709076502e+03,		1.108727389933056e+03,		1.109067414585386e+03,		1.109406785882592e+03,
		1.109745506654697e+03,		1.110083579712814e+03,		1.110421007849326e+03,		1.110757793838046e+03,		1.111093940434389e+03,
		1.111429450375533e+03,		1.111764326380586e+03,		1.112098571150748e+03,		1.112432187369461e+03,		1.112765177702581e+03,
		1.113097544798521e+03,		1.113429291288413e+03,		1.113760419786257e+03,		1.114090932889071e+03,		1.114420833177046e+03,
		1.114750123213685e+03,		1.115078805545952e+03,		1.115406882704420e+03,		1.115734357203410e+03,		1.116061231541128e+03,
		1.116387508199814e+03,		1.116713189645872e+03,		1.117038278330009e+03,		1.117362776687373e+03,		1.117686687137680e+03,
		1.118010012085352e+03,		1.118332753919643e+03,		1.118654915014774e+03,		1.118976497730053e+03,		1.119297504410009e+03,
		1.119617937384514e+03,		1.119937798968903e+03,		1.120257091464105e+03,		1.120575817156756e+03,		1.120893978319323e+03,
		1.121211577210222e+03,		1.121528616073935e+03,		1.121845097141127e+03,		1.122161022628757e+03,		1.122476394740198e+03,
		1.122791215665346e+03,		1.123105487580731e+03,		1.123419212649627e+03,		1.123732393022163e+03,		1.124045030835431e+03,
		1.124357128213588e+03,		1.124668687267968e+03,		1.124979710097183e+03,		1.125290198787227e+03,		1.125600155411580e+03,
		1.125909582031307e+03,		1.126218480695161e+03,		1.126526853439678e+03,		1.126834702289281e+03,		1.127142029256375e+03
	},
	{
		1.762824585033991e+00,		5.343977015155824e+00,		8.997376161922162e+00,		1.272679565599759e+01,		1.653633448214153e+01,
		2.043045631794611e+01,		2.441403511777572e+01,		2.849240819072164e+01,		3.267143832651598e+01,		3.695758691760945e+01,
		4.135800053963049e+01,		4.588061412905180e+01,		5.053427479677512e+01,		5.532889152657988e+01,		6.027561765469829e+01,
		6.538707529847049e+01,		7.067763407953868e+01,		7.616376100099821e+01,		8.186446486048727e+01,		8.780186818459731e+01,
		9.400195410648499e+01,		1.004955578195686e+02,		1.073197073138771e+02,		1.145194751429532e+02,		1.221505989111150e+02,
		1.302832959296601e+02,		1.390080044317141e+02,		1.484443763487202e+02,		1.587560675244609e+02,		1.701765962945215e+02,
		1.830582767993633e+02,		1.979752917083312e+02,		2.159772307089661e+02,		2.393909420768773e+02,		2.761193575772481e+02,
		6.644607376585069e+02,		6.861231983771355e+02,		7.013639997975456e+02,		7.134216398624104e+02,		7.235248326885755e+02,
		7.322884331654919e+02,		7.400683687105731e+02,		7.470907513573342e+02,		7.535089428612852e+02,		7.594321812232340e+02,
		7.649412996153665e+02,		7.700979690321321e+02,		7.749504342425668e+02,		7.795372330530113e+02,		7.838896974547968e+02,
		7.880336883172436e+02,		7.919908308043861e+02,		7.957794147078877e+02,		7.994150639668652e+02,		8.029112435191324e+02,
		8.062796491564731e+02,		8.095305116906501e+02,		8.126728373257916e+02,		8.157145998309146e+02,		8.186628958018288e+02,
		8.215240713140684e+02,		8.243038261368710e+02,		8.270073001909406e+02,		8.296391457948592e+02,		8.322035884547606e+02,
		8.347044783364919e+02,		8.371453341039078e+02,		8.395293804589593e+02,		8.418595804515463e+02,		8.441386634196086e+02,
		8.463691492575126e+02,		8.485533695828985e+02,		8.506934862703772e+02,		8.527915077393128e+02,		8.548493033164700e+02,
		8.568686159485964e+02,		8.588510734728901e+02,		8.607981986623853e+02,		8.627114181839862e+02,		8.645920706174263e+02,
		8.664414136497512e+02,		8.682606305465015e+02,		8.700508359795406e+02,		8.718130813048082e+02,		8.735483593229852e+02,
		8.752576086104590e+02,		8.769417174504190e+02,		8.786015274129780e+02,		8.802378366206390e+02,		8.818514027318803e+02,
		8.834429456716296e+02,		8.850131501340589e+02,		8.865626678801832e+02,		8.880921198501720e+02,		8.896020981080799e+02,
		8.910931676347335e+02,		8.925658679828339e+02,		8.940207148068000e+02,		8.954582012786108e+02,		8.968787993996943e+02,
		8.982829612179258e+02,		8.996711199578601e+02,		9.010436910715556e+02,		9.024010732165709e+02,		9.037436491671638e+02,
		9.050717866640796e+02,		9.063858392078494e+02,		9.076861468000570e+02,		9.089730366366214e+02,		9.102468237567898e+02,
		9.115078116512036e+02,		9.127562928320991e+02,		9.139925493684402e+02,		9.152168533897494e+02,		9.164294675535326e+02,
		9.176306454979616e+02,		9.188206322543845e+02,		9.199996646432264e+02,		9.211679716456924e+02,		9.223257747544619e+02,
		9.234732883047880e+02,		9.246107197873046e+02,		9.257382701437451e+02,		9.268561340466898e+02,		9.279645001643606e+02,
		9.290635514114293e+02,		9.301534651867065e+02,		9.312344135985386e+02,		9.323065636786743e+02,		9.333700775852891e+02,
		9.344251127958491e+02,		9.354718222903892e+02,		9.365103547258077e+02,		9.375408546016849e+02,		9.385634624181063e+02,
		9.395783148259949e+02,		9.405855447703173e+02,		9.415852816266290e+02,		9.425776513312766e+02,		9.435627765056441e+02,
		9.445407765747567e+02,		9.455117678805584e+02,		9.464758637901153e+02,		9.474331747990738e+02,		9.483838086305790e+02,
		9.493278703299001e+02,		9.502654623549990e+02,		9.511966846632417e+02,		9.521216347944494e+02,		9.530404079504735e+02,
		9.539530970714752e+02,		9.548597929090702e+02,		9.557605840964873e+02,		9.566555572158929e+02,		9.575447968630303e+02,
		9.584283857092661e+02,		9.593064045612235e+02,		9.601789324180567e+02,		9.610460465265248e+02,		9.619078224339360e+02,
		9.627643340390840e+02,		9.636156536412556e+02,		9.644618519873849e+02,		9.653029983174783e+02,		9.661391604083383e+02,
		9.669704046156947e+02,		9.677967959148087e+02,		9.686183979395975e+02,		9.694352730203757e+02,		9.702474822202382e+02,
		9.710550853701728e+02,		9.718581411029364e+02,		9.726567068857582e+02,		9.734508390519090e+02,		9.742405928311964e+02,
		9.750260223794205e+02,		9.758071808068335e+02,		9.765841202056461e+02,		9.773568916766252e+02,		9.781255453548033e+02,
		9.788901304343507e+02,		9.796506951926369e+02,		9.804072870135120e+02,		9.811599524098423e+02,		9.819087370442273e+02,
		9.826536857547777e+02,		9.833948425681355e+02,		9.841322507246131e+02,		9.848659526959605e+02,		9.855959902039731e+02,
		9.863224042385375e+02,		9.870452350751247e+02,		9.877645222917486e+02,		9.884803047854241e+02,		9.891926207881277e+02,
		9.899015078822868e+02,		9.906070030158094e+02,		9.913091425166823e+02,		9.920079621071284e+02,		9.927034969173731e+02,
		9.933957814989996e+02,		9.940848498379310e+02,		9.947707353670414e+02,		9.954534709784099e+02,		9.961330890352389e+02,
		9.968096213834215e+02,		9.974830993628069e+02,		9.981535538181499e+02,		9.988210151097563e+02,		9.994855131238400e+02,
		1.000147077282604e+03,		1.000805736554045e+03,		1.001461519461498e+03,		1.002114454094163e+03,		1.002764568110636e+03,
		1.003411888757078e+03,		1.004056442868572e+03,		1.004698256879641e+03,		1.005337356832370e+03,		1.005973768384338e+03,
		1.006607516816333e+03,		1.007238627039879e+03,		1.007867123604567e+03,		1.008493030705215e+03,		1.009116372188830e+03,
		1.009737171561419e+03,		1.010355451994614e+03,		1.010971236332144e+03,		1.011584547096150e+03,		1.012195406493334e+03,
		1.012803836420975e+03,		1.013409858472787e+03,		1.014013493944649e+03,		1.014614763840181e+03,		1.015213688876205e+03,
		1.015810289488069e+03,		1.016404585834845e+03,		1.016996597804409e+03,		1.017586345016780e+03,		1.018173846834716e+03,
		1.018759122360672e+03,		1.019342190446145e+03,		1.019923069695113e+03,		1.020501778468448e+03,		1.021078334888236e+03,
		1.021652756841991e+03,		1.022225061986786e+03,		1.022795267753284e+03,		1.023363391349685e+03,		1.023929449765578e+03,
		1.024493459775719e+03,		1.025055437943718e+03,		1.025615400625651e+03,		1.026173363973590e+03,		1.026729343939058e+03,
		1.027283356276417e+03,		1.027835416546169e+03,		1.028385540118202e+03,		1.028933742174957e+03,		1.029480037714534e+03,
		1.030024441553730e+03,		1.030566968331014e+03,		1.031107632509444e+03,		1.031646448379519e+03,		1.032183430061969e+03,
		1.032718591510502e+03,		1.033251946514478e+03,		1.033783508701541e+03,		1.034313291540190e+03,		1.034841308342302e+03,
		1.035367572265608e+03,		1.035892096316109e+03,		1.036414893350452e+03,		1.036935976078261e+03,		1.037455357064413e+03,
		1.037973048731283e+03,		1.038489063360925e+03,		1.039003413097234e+03,		1.039516109948046e+03,		1.040027165787210e+03,
		1.040536592356615e+03,		1.041044401268182e+03,		1.041550604005810e+03,		1.042055211927294e+03,		1.042558236266206e+03,
		1.043059688133729e+03,		1.043559578520475e+03,		1.044057918298252e+03,		1.044554718221811e+03,		1.045049988930550e+03,
		1.045543740950197e+03,		1.046035984694454e+03,		1.046526730466609e+03,		1.047015988461132e+03,		1.047503768765230e+03,
		1.047990081360371e+03,		1.048474936123797e+03,		1.048958342829990e+03,		1.049440311152128e+03,		1.049920850663502e+03,
		1.050399970838921e+03,		1.050877681056081e+03,		1.051353990596910e+03,		1.051828908648905e+03,		1.052302444306422e+03,
		1.052774606571965e+03,		1.053245404357434e+03,		1.053714846485369e+03,		1.054182941690161e+03,		1.054649698619244e+03,
		1.055115125834268e+03,		1.055579231812254e+03,		1.056042024946731e+03,		1.056503513548839e+03,		1.056963705848432e+03,
		1.057422609995162e+03,		1.057880234059521e+03,		1.058336586033895e+03,		1.058791673833588e+03,		1.059245505297821e+03,
		1.059698088190729e+03,		1.060149430202333e+03,		1.060599538949501e+03,		1.061048421976883e+03,		1.061496086757850e+03,
		1.061942540695393e+03,		1.062387791123032e+03,		1.062831845305691e+03,		1.063274710440571e+03,		1.063716393658003e+03,
		1.064156902022290e+03,		1.064596242532536e+03,		1.065034422125033e+03,		1.065471447667814e+03,		1.065907325970746e+03,
		1.066342063780151e+03,		1.066775667781101e+03,		1.067208144598164e+03,		1.067639500796155e+03,		1.068069742880859e+03,
		1.068498877299747e+03,		1.068926910442694e+03,		1.069353848642665e+03,		1.069779698176405e+03,		1.070204465265116e+03,
		1.070628156075119e+03,		1.071050776718515e+03,		1.071472333253821e+03,		1.071892831686615e+03,		1.072312277970157e+03,
		1.072730678006009e+03,		1.073148037644635e+03,		1.073564362686013e+03,		1.073979658880211e+03,		1.074393931927975e+03,
		1.074807187481304e+03,		1.075219431144006e+03,		1.075630668472261e+03,		1.076040904975167e+03,		1.076450146115278e+03,
		1.076858397309136e+03,		1.077265663927798e+03,		1.077671951297352e+03,		1.078077264699424e+03,		1.078481609371683e+03,
		1.078884990508333e+03,		1.079287413260604e+03,		1.079688882737233e+03,		1.080089404004933e+03,		1.080488982088869e+03,
		1.080887621973111e+03,		1.081285328601094e+03,		1.081682106876063e+03,		1.082077961661516e+03,		1.082472897781640e+03,
		1.082866920021741e+03,		1.083260033128667e+03,		1.083652241811226e+03,		1.084043550740600e+03,		1.084433964550749e+03,
		1.084823487838815e+03,		1.085212125165515e+03,		1.085599881055532e+03,		1.085986759997903e+03,		1.086372766446392e+03,
		1.086757904819874e+03,		1.087142179502694e+03,		1.087525594845044e+03,		1.087908155163310e+03,		1.088289864740437e+03,
		1.088670727826276e+03,		1.089050748637927e+03,		1.089429931360084e+03,		1.089808280145372e+03,		1.090185799114677e+03,
		1.090562492357473e+03,		1.090938363932148e+03,		1.091313417866327e+03,		1.091687658157177e+03,		1.092061088771729e+03,
		1.092433713647180e+03,		1.092805536691195e+03,		1.093176561782211e+03,		1.093546792769730e+03,		1.093916233474610e+03,
		1.094284887689354e+03,		1.094652759178395e+03,		1.095019851678375e+03,		1.095386168898428e+03,		1.095751714520443e+03,
		1.096116492199346e+03,		1.096480505563360e+03,		1.096843758214271e+03,		1.097206253727687e+03,		1.097567995653297e+03,
		1.097928987515123e+03,		1.098289232811772e+03,		1.098648735016687e+03,		1.099007497578383e+03,		1.099365523920698e+03,
		1.099722817443024e+03,		1.100079381520549e+03,		1.100435219504489e+03,		1.100790334722312e+03,		1.101144730477975e+03,
		1.101498410052139e+03,		1.101851376702399e+03,		1.102203633663498e+03,		1.102555184147544e+03,		1.102906031344228e+03,
		1.103256178421033e+03,		1.103605628523439e+03,		1.103954384775134e+03,		1.104302450278221e+03,		1.104649828113412e+03,
		1.104996521340234e+03,		1.105342532997218e+03,		1.105687866102104e+03,		1.106032523652024e+03,		1.106376508623699e+03,
		1.106719823973622e+03,		1.107062472638245e+03,		1.107404457534163e+03,		1.107745781558299e+03,		1.108086447588074e+03,
		1.108426458481595e+03,		1.108765817077823e+03,		1.109104526196748e+03,		1.109442588639563e+03,		1.109780007188830e+03,
		1.110116784608647e+03,		1.110452923644816e+03,		1.110788427025009e+03,		1.111123297458919e+03,		1.111457537638435e+03,
		1.111791150237789e+03,		1.112124137913715e+03,		1.112456503305606e+03,		1.112788249035666e+03,		1.113119377709060e+03,
		1.113449891914064e+03,		1.113779794222214e+03,		1.114109087188449e+03,		1.114437773351263e+03,		1.114765855232840e+03,
		1.115093335339197e+03,		1.115420216160328e+03,		1.115746500170340e+03,		1.116072189827591e+03,		1.116397287574821e+03,
		1.116721795839293e+03,		1.117045717032919e+03,		1.117369053552395e+03,		1.117691807779331e+03,		1.118013982080376e+03,
		1.118335578807348e+03,		1.118656600297357e+03,		1.118977048872933e+03,		1.119296926842143e+03,		1.119616236498720e+03,
		1.119934980122177e+03,		1.120253159977928e+03,		1.120570778317406e+03,		1.120887837378183e+03,		1.121204339384079e+03,
		1.121520286545278e+03,		1.121835681058445e+03,		1.122150525106833e+03,		1.122464820860396e+03,		1.122778570475896e+03,
		1.123091776097017e+03,		1.123404439854463e+03,		1.123716563866072e+03,		1.124028150236918e+03,		1.124339201059415e+03,
		1.124649718413419e+03,		1.124959704366332e+03,		1.125269160973201e+03,		1.125578090275074e+03,		1.125886494306100e+03
	},
	{
		1.759252391562407e+00,		5.332795047982029e+00,		8.977922989093200e+00,		1.269834277654574e+01,		1.649807748994304e+01,
		2.038150459064660e+01,		2.435339972787724e+01,		2.841898766099833e+01,		3.258400175504641e+01,		3.685475387137018e+01,
		4.123821694929720e+01,		4.574212319658983e+01,		5.037508163038599e+01,		5.514671981389744e+01,		6.006785612962725e+01,
		6.515071098223714e+01,		7.040916817976101e+01,		7.585910177493466e+01,		8.151878943875916e+01,		8.740944190313763e+01,
		9.355589063322552e+01,		9.998749513923794e+01,		1.067393614278162e+02,		1.138540114681321e+02,		1.213837238392427e+02,
		1.293939039638841e+02,		1.379680906952945e+02,		1.472156751895047e+02,		1.572843491636525e+02,		1.683813316355612e+02,
		1.808122344671521e+02,		1.950592726628458e+02,		2.119609607959551e+02,		2.332181081789379e+02,		2.634584333553446e+02,
		6.337392091352052e+02,		6.674385121737239e+02,		6.868523985898854e+02,		7.011898852287202e+02,		7.127682529799114e+02,
		7.225804240240629e+02,		7.311525059742112e+02,		7.387995633898347e+02,		7.457263220562336e+02,		7.520738967127311e+02,
		7.579440242087844e+02,		7.634126966180706e+02,		7.685383269861800e+02,		7.733668912544994e+02,		7.779353017088040e+02,
		7.822736975946061e+02,		7.864070466757803e+02,		7.903562936724617e+02,		7.941392021377843e+02,		7.977709837060515e+02,
		8.012647765862861e+02,		8.046320150635039e+02,		8.078827187885441e+02,		8.110257221265966e+02,		8.140688580317404e+02,
		8.170191069915097e+02,		8.198827188102904e+02,		8.226653130414940e+02,		8.253719624660885e+02,		8.280072629837687e+02,
		8.305753925209216e+02,		8.330801609891236e+02,		8.355250529008415e+02,		8.379132639076113e+02,		8.402477322969050e+02,
		8.425311662579417e+02,		8.447660675936753e+02,		8.469547524255104e+02,		8.490993693408692e+02,		8.512019153577829e+02,
		8.532642500165992e+02,		8.552881078587498e+02,		8.572751095109119e+02,		8.592267715588944e+02,		8.611445153675209e+02,
		8.630296749796333e+02,		8.648835042078811e+02,		8.667071830169144e+02,		8.685018232799558e+02,		8.702684739822745e+02,
		8.720081259344518e+02,		8.737217160500642e+02,		8.754101312354039e+02,		8.770742119328696e+02,		8.787147553545265e+02,
		8.803325184378615e+02,		8.819282205520199e+02,		8.835025459794256e+02,		8.850561461948591e+02,		8.865896419614943e+02,
		8.881036252617324e+02,		8.895986610771679e+02,		8.910752890330866e+02,		8.925340249186215e+02,		8.939753620941598e+02,
		8.953997727958074e+02,		8.968077093458560e+02,		8.981996052772679e+02,		8.995758763794337e+02,		9.009369216717156e+02,
		9.022831243107157e+02,		9.036148524366088e+02,		9.049324599645723e+02,		9.062362873182529e+02,		9.075266621290727e+02,
		9.088038998769738e+02,		9.100683044983944e+02,		9.113201689548705e+02,		9.125597757667670e+02,		9.137873975146808e+02,
		9.150032973108670e+02,		9.162077292427789e+02,		9.174009387907196e+02,		9.185831632213840e+02,		9.197546319589535e+02,
		9.209155669352585e+02,		9.220661829204359e+02,		9.232066878353394e+02,		9.243372830469402e+02,		9.254581636477980e+02,
		9.265695187206279e+02,		9.276715315889206e+02,		9.287643800544896e+02,		9.298482366227438e+02,		9.309232687164611e+02,
		9.319896388787629e+02,		9.330475049659168e+02,		9.340970203306091e+02,		9.351383339961955e+02,		9.361715908226661e+02,
		9.371969316642721e+02,		9.382144935200461e+02,		9.392244096770203e+02,		9.402268098468121e+02,		9.412218202958958e+02,
		9.422095639699129e+02,		9.431901606123477e+02,		9.441637268778740e+02,		9.451303764406537e+02,		9.460902200978719e+02,
		9.470433658687319e+02,		9.479899190891813e+02,		9.489299825025679e+02,		9.498636563464396e+02,		9.507910384356812e+02,
		9.517122242421972e+02,		9.526273069712688e+02,		9.535363776347986e+02,		9.544395251215537e+02,		9.553368362645942e+02,
		9.562283959059890e+02,		9.571142869589645e+02,		9.579945904676165e+02,		9.588693856642798e+02,		9.597387500246842e+02,
		9.606027593209924e+02,		9.614614876728109e+02,		9.623150075962831e+02,		9.631633900513330e+02,		9.640067044871599e+02,
		9.648450188860478e+02,		9.656783998042491e+02,		9.665069124183283e+02,		9.673306205552102e+02,		9.681495867366204e+02,
		9.689638722137225e+02,		9.697735370022959e+02,		9.705786399166830e+02,		9.713792386025633e+02,		9.721753895685875e+02,
		9.729671482169330e+02,		9.737545688728338e+02,		9.745377048130869e+02,		9.753166082936377e+02,		9.760913305762174e+02,
		9.768619219541241e+02,		9.776284317771449e+02,		9.783909084756758e+02,		9.791493995840518e+02,		9.799039517631409e+02,
		9.806546108222037e+02,		9.814014217400749e+02,		9.821444286856671e+02,		9.828836750378370e+02,		9.836192034046394e+02,
		9.843510556419853e+02,		9.850792728724950e+02,		9.858038954995220e+02,		9.865249632303110e+02,		9.872425150875360e+02,
		9.879565894269026e+02,		9.886672239526491e+02,		9.893744557326131e+02,		9.900783212128507e+02,		9.907788562318307e+02,
		9.914760960353129e+02,		9.921700752843306e+02,		9.928608280790230e+02,		9.935483879604575e+02,		9.942327879283324e+02,
		9.949140604518302e+02,		9.955922374812274e+02,		9.962673504591800e+02,		9.969394303317005e+02,		9.976085075588328e+02,
		9.982746121268148e+02,		9.989377735521687e+02,		9.995980208993911e+02,		1.000255382785882e+03,		1.000909887392298e+03,
		1.001561562471628e+03,		1.002210435358023e+03,		1.002856532975398e+03,		1.003499881845809e+03,		1.004140508097609e+03,
		1.004778437473404e+03,		1.005413695337798e+03,		1.006046306684947e+03,		1.006676296145911e+03,		1.007303687995837e+03,
		1.007928506160947e+03,		1.008550774225362e+03,		1.009170515437758e+03,		1.009787752717843e+03,		1.010402508662701e+03,
		1.011014805552955e+03,		1.011624665358799e+03,		1.012232109745879e+03,		1.012837160081028e+03,		1.013439837437872e+03,
		1.014040162602300e+03,		1.014638156077799e+03,		1.015233838090677e+03,		1.015827228595151e+03,		1.016418347278322e+03,
		1.017007213565032e+03,		1.017593846622622e+03,		1.018178265365555e+03,		1.018760488459963e+03,		1.019340534328068e+03,
		1.019918421152519e+03,		1.020494166880619e+03,		1.021067789228468e+03,		1.021639305685003e+03,		1.022208733515964e+03,
		1.022776089767753e+03,		1.023341391271226e+03,		1.023904654645391e+03,		1.024465896301030e+03,		1.025025132444243e+03,
		1.025582379079913e+03,		1.026137652015103e+03,		1.026690966862368e+03,		1.027242339043014e+03,		1.027791783790271e+03,
		1.028339316152410e+03,		1.028884950995795e+03,		1.029428703007861e+03,		1.029970586700047e+03,		1.030510616410646e+03,
		1.031048806307620e+03,		1.031585170391343e+03,		1.032119722497289e+03,		1.032652476298671e+03,		1.033183445309019e+03,
		1.033712642884719e+03,		1.034240082227482e+03,		1.034765776386782e+03,		1.035289738262237e+03,		1.035811980606248e+03,
		1.036332516025084e+03,		1.036851356982898e+03,		1.037368515802775e+03,		1.037884004669164e+03,		1.038397835629995e+03,
		1.038910020598759e+03,		1.039420571356539e+03,		1.039929499554006e+03,		1.040436816713380e+03,		1.040942534230343e+03,
		1.041446663375933e+03,		1.041949215298385e+03,		1.042450201024951e+03,		1.042949631463679e+03,		1.043447517405154e+03,
		1.043943869524222e+03,		1.044438698381667e+03,		1.044932014425868e+03,		1.045423827994416e+03,		1.045914149315708e+03,
		1.046402988510512e+03,		1.046890355593504e+03,		1.047376260474768e+03,		1.047860712961284e+03,		1.048343722758379e+03,
		1.048825299471155e+03,		1.049305452605892e+03,		1.049784191571426e+03,		1.050261525680500e+03,		1.050737464151101e+03,
		1.051212016107756e+03,		1.051685190582826e+03,		1.052156996517761e+03,		1.052627442764343e+03,		1.053096538085901e+03,
		1.053564291158512e+03,		1.054030710572178e+03,		1.054495804831979e+03,		1.054959582359213e+03,		1.055422051492514e+03,
		1.055883220488952e+03,		1.056343097525110e+03,		1.056801690698152e+03,		1.057259008026864e+03,		1.057715057452680e+03,
		1.058169846840698e+03,		1.058623383980670e+03,		1.059075676587981e+03,		1.059526732304608e+03,		1.059976558700068e+03,
		1.060425163272351e+03,		1.060872553448828e+03,		1.061318736587157e+03,		1.061763719976170e+03,		1.062207510836740e+03,
		1.062650116322641e+03,		1.063091543521395e+03,		1.063531799455098e+03,		1.063970891081241e+03,		1.064408825293513e+03,
		1.064845608922593e+03,		1.065281248736932e+03,		1.065715751443518e+03,		1.066149123688629e+03,		1.066581372058585e+03,
		1.067012503080470e+03,		1.067442523222861e+03,		1.067871438896536e+03,		1.068299256455169e+03,		1.068725982196024e+03,
		1.069151622360627e+03,		1.069576183135440e+03,		1.069999670652514e+03,		1.070422090990137e+03,		1.070843450173473e+03,
		1.071263754175191e+03,		1.071683008916082e+03,		1.072101220265670e+03,		1.072518394042813e+03,		1.072934536016290e+03,
		1.073349651905394e+03,		1.073763747380496e+03,		1.074176828063619e+03,		1.074588899528989e+03,		1.074999967303590e+03,
		1.075410036867704e+03,		1.075819113655445e+03,		1.076227203055283e+03,		1.076634310410566e+03,		1.077040441020030e+03,
		1.077445600138300e+03,		1.077849792976392e+03,		1.078253024702197e+03,		1.078655300440970e+03,		1.079056625275797e+03,
		1.079457004248075e+03,		1.079856442357965e+03,		1.080254944564854e+03,		1.080652515787801e+03,		1.081049160905986e+03,
		1.081444884759139e+03,		1.081839692147978e+03,		1.082233587834633e+03,		1.082626576543064e+03,		1.083018662959475e+03,
		1.083409851732722e+03,		1.083800147474717e+03,		1.084189554760822e+03,		1.084578078130246e+03,		1.084965722086425e+03,
		1.085352491097407e+03,		1.085738389596226e+03,		1.086123421981277e+03,		1.086507592616676e+03,		1.086890905832626e+03,
		1.087273365925771e+03,		1.087654977159547e+03,		1.088035743764533e+03,		1.088415669938787e+03,		1.088794759848190e+03,
		1.089173017626777e+03,		1.089550447377064e+03,		1.089927053170377e+03,		1.090302839047167e+03,		1.090677809017337e+03,
		1.091051967060538e+03,		1.091425317126494e+03,		1.091797863135294e+03,		1.092169608977701e+03,		1.092540558515443e+03,
		1.092910715581508e+03,		1.093280083980433e+03,		1.093648667488590e+03,		1.094016469854467e+03,		1.094383494798946e+03,
		1.094749746015579e+03,		1.095115227170857e+03,		1.095479941904481e+03,		1.095843893829626e+03,		1.096207086533198e+03,
		1.096569523576100e+03,		1.096931208493477e+03,		1.097292144794978e+03,		1.097652335964996e+03,		1.098011785462920e+03,
		1.098370496723371e+03,		1.098728473156448e+03,		1.099085718147962e+03,		1.099442235059668e+03,		1.099798027229497e+03,
		1.100153097971789e+03,		1.100507450577506e+03,		1.100861088314472e+03,		1.101214014427578e+03,		1.101566232139006e+03,
		1.101917744648443e+03,		1.102268555133294e+03,		1.102618666748888e+03,		1.102968082628692e+03,		1.103316805884508e+03,
		1.103664839606680e+03,		1.104012186864293e+03,		1.104358850705372e+03,		1.104704834157072e+03,		1.105050140225877e+03,
		1.105394771897791e+03,		1.105738732138519e+03,		1.106082023893660e+03,		1.106424650088892e+03,		1.106766613630148e+03,
		1.107107917403803e+03,		1.107448564276843e+03,		1.107788557097053e+03,		1.108127898693180e+03,		1.108466591875109e+03,
		1.108804639434033e+03,		1.109142044142623e+03,		1.109478808755188e+03,		1.109814936007847e+03,		1.110150428618685e+03,
		1.110485289287917e+03,		1.110819520698044e+03,		1.111153125514013e+03,		1.111486106383371e+03,		1.111818465936418e+03,
		1.112150206786359e+03,		1.112481331529452e+03,		1.112811842745161e+03,		1.113141742996300e+03,		1.113471034829177e+03,
		1.113799720773741e+03,		1.114127803343719e+03,		1.114455285036762e+03,		1.114782168334580e+03,		1.115108455703081e+03,
		1.115434149592506e+03,		1.115759252437565e+03,		1.116083766657569e+03,		1.116407694656560e+03,		1.116731038823444e+03,
		1.117053801532118e+03,		1.117375985141596e+03,		1.117697591996142e+03,		1.118018624425382e+03,		1.118339084744439e+03,
		1.118658975254050e+03,		1.118978298240689e+03,		1.119297055976679e+03,		1.119615250720324e+03,		1.119932884716011e+03,
		1.120249960194336e+03,		1.120566479372216e+03,		1.120882444452998e+03,		1.121197857626576e+03,		1.121512721069503e+03,
		1.121827036945094e+03,		1.122140807403542e+03,		1.122454034582020e+03,		1.122766720604792e+03,		1.123078867583315e+03,
		1.123390477616344e+03,		1.123701552790038e+03,		1.124012095178055e+03,		1.124322106841664e+03,		1.124631589829833e+03
	},
	{
		1.755694890185707e+00,		5.321662127967666e+00,		8.958560745691310e+00,		1.267003154653134e+01,		1.646002327065546e+01,
		2.033282904147225e+01,		2.429312846629943e+01,		2.834603649497458e+01,		3.249716040275634e+01,		3.675266660143049e+01,
		4.111935941980638e+01,		4.560477456640231e+01,		5.021729074169052e+01,		5.496626387388822e+01,		5.986218981043844e+01,
		6.491690315237879e+01,		7.014382248645872e+01,		7.555825587569191e+01,		8.117778561352765e+01,		8.702275871519939e+01,
		9.311692067163328e+01,		9.948824669753463e+01,		1.061700505656820e+02,		1.132024922331776e+02,		1.206346728374127e+02,
		1.285276199287863e+02,		1.369586676046219e+02,		1.460281096182378e+02,		1.558697341166096e+02,		1.666683779484225e+02,
		1.786911196162416e+02,		1.923475520744804e+02,		2.083203872803012e+02,		2.279003801071991e+02,		2.541235052625304e+02,
		2.991094982887510e+02,		6.426034141332193e+02,		6.697042112619382e+02,		6.874191279316805e+02,		7.009798549936562e+02,
		7.121219203169144e+02,		7.216602753660694e+02,		7.300481235009221e+02,		7.375652250744760e+02,		7.443971978559952e+02,
		7.506739488793697e+02,		7.564902260765472e+02,		7.619174475503634e+02,		7.670109134288659e+02,		7.718144116121887e+02,
		7.763632743643526e+02,		7.806864736250569e+02,		7.848080977962204e+02,		7.887484179464600e+02,		7.925246740196482e+02,
		7.961516654771895e+02,		7.996422024555194e+02,		8.030074555382903e+02,		8.062572305789931e+02,		8.094001872633115e+02,
		8.124440148428681e+02,		8.153955748595332e+02,		8.182610181183086e+02,		8.210458813649150e+02,		8.237551678057213e+02,
		8.263934146479944e+02,		8.289647501253997e+02,		8.314729419388823e+02,		8.339214386358494e+02,		8.363134051539946e+02,
		8.386517534777458e+02,		8.409391692298368e+02,		8.431781348162104e+02,		8.453709496591978e+02,		8.475197479510562e+02,
		8.496265142873200e+02,		8.516930974793920e+02,		8.537212227971924e+02,		8.557125028529591e+02,		8.576684473045581e+02,
		8.595904715297868e+02,		8.614799044007278e+02,		8.633379952686009e+02,		8.651659202539477e+02,		8.669647879238686e+02,
		8.687356444269622e+02,		8.704794781472104e+02,		8.721972239302956e+02,		8.738897669283740e+02,		8.755579461046700e+02,
		8.772025574329998e+02,		8.788243568238878e+02,		8.804240628048206e+02,		8.820023589791575e+02,		8.835598962852695e+02,
		8.850972950751433e+02,		8.866151470295348e+02,		8.881140169248595e+02,		8.895944442654411e+02,		8.910569447932425e+02,
		8.925020118870049e+02,		8.939301178540863e+02,		8.953417151410596e+02,		8.967372374462568e+02,		8.981171007614777e+02,
		8.994817043405137e+02,		9.008314316019791e+02,		9.021666509717058e+02,		9.034877166695159e+02,		9.047949694447211e+02,
		9.060887372643140e+02,		9.073693359574736e+02,		9.086370698187482e+02,		9.098922321786796e+02,		9.111351059294665e+02,
		9.123659640295881e+02,		9.135850699725826e+02,		9.147926782294602e+02,		9.159890346653206e+02,		9.171743769320000e+02,
		9.183489348383843e+02,		9.195129306998806e+02,		9.206665796684539e+02,		9.218100900445290e+02,		9.229436635719228e+02,
		9.240674957169149e+02,		9.251817759324668e+02,		9.262866879085633e+02,		9.273824098094832e+02,		9.284691144988743e+02,
		9.295469697533497e+02,		9.306161384653017e+02,		9.316767788355944e+02,		9.327290445567386e+02,		9.337730849870916e+02,
		9.348090453166309e+02,		9.358370667247733e+02,		9.368572865307043e+02,		9.378698383366259e+02,		9.388748521643500e+02,
		9.398724545855796e+02,		9.408627688462374e+02,		9.418459149851745e+02,		9.428220099475494e+02,		9.437911676931703e+02,
		9.447534993000721e+02,		9.457091130635741e+02,		9.466581145898318e+02,		9.476006068918537e+02,		9.485366904676473e+02,
		9.494664633898766e+02,		9.503900213837725e+02,		9.513074579035747e+02,		9.522188642058292e+02,		9.531243294197192e+02,
		9.540239406145571e+02,		9.549177828645670e+02,		9.558059393111158e+02,		9.566884912224900e+02,		9.575655180513354e+02,
		9.584370974898872e+02,		9.593033055230726e+02,		9.601642164796009e+02,		9.610199030811127e+02,		9.618704364895027e+02,
		9.627158863524756e+02,		9.635563208485033e+02,		9.643918067240830e+02,		9.652224093434776e+02,		9.660481927204710e+02,
		9.668692195588110e+02,		9.676855512886851e+02,		9.684972481019134e+02,		9.693043689862262e+02,		9.701069717566520e+02,
		9.709051130900606e+02,		9.716988485529196e+02,		9.724882326322863e+02,		9.732733187640831e+02,		9.740541593607094e+02,
		9.748308058377286e+02,		9.756033086421900e+02,		9.763717172697034e+02,		9.771360802984873e+02,		9.778964454070833e+02,
		9.786528593982423e+02,		9.794053682208311e+02,		9.801540169910492e+02,		9.808988500129923e+02,		9.816399107985510e+02,
		9.823772420867108e+02,		9.831108858622464e+02,		9.838408833738550e+02,		9.845672751517238e+02,		9.852901010245788e+02,
		9.860094001362169e+02,		9.867252109615456e+02,		9.874375713221453e+02,		9.881465184013788e+02,		9.888520887590528e+02,
		9.895543183456557e+02,		9.902532425161857e+02,		9.909488960435771e+02,		9.916413131317495e+02,		9.923305274282786e+02,
		9.930165720367218e+02,		9.936994795285860e+02,		9.943792819549644e+02,		9.950560108578634e+02,		9.957296972811989e+02,
		9.964003717815053e+02,		9.970680644383513e+02,		9.977328048644656e+02,		9.983946222155981e+02,		9.990535452001184e+02,
		9.997096020883554e+02,		1.000362820721689e+03,		1.001013228521406e+03,		1.001660852497324e+03,		1.002305719256191e+03,
		1.002947855009866e+03,		1.003587285583295e+03,		1.004224036422271e+03,		1.004858132601014e+03,		1.005489598829547e+03,
		1.006118459460886e+03,		1.006744738498063e+03,		1.007368459600957e+03,		1.007989646092965e+03,		1.008608320967517e+03,
		1.009224506894414e+03,		1.009838226226022e+03,		1.010449501003320e+03,		1.011058352961791e+03,		1.011664803537177e+03,
		1.012268873871106e+03,		1.012870584818154e+03,		1.013469956945009e+03,		1.014067010544778e+03,		1.014661765636179e+03,
		1.015254241969977e+03,		1.015844459033860e+03,		1.016432436057194e+03,		1.017018192015682e+03,		1.017601745635905e+03,
		1.018183115399769e+03,		1.018762319548841e+03,		1.019339376088606e+03,		1.019914302792607e+03,		1.020487117206505e+03,
		1.021057836652050e+03,		1.021626478230963e+03,		1.022193058828725e+03,		1.022757595118297e+03,		1.023320103563746e+03,
		1.023880600423806e+03,		1.024439101755346e+03,		1.024995623416782e+03,		1.025550181071400e+03,		1.026102790190616e+03,
		1.026653466057171e+03,		1.027202223768252e+03,		1.027749078238550e+03,		1.028294044203251e+03,		1.028837136220973e+03,
		1.029378368676638e+03,		1.029917755784275e+03,		1.030455311589790e+03,		1.030991049973651e+03,		1.031524984653539e+03,
		1.032057129186937e+03,		1.032587496973668e+03,		1.033116101258382e+03,		1.033642955132995e+03,		1.034168071539077e+03,
		1.034691463270196e+03,		1.035213142974212e+03,		1.035733123155528e+03,		1.036251416177299e+03,		1.036768034263594e+03,
		1.037282989501520e+03,		1.037796293843299e+03,		1.038307959108317e+03,		1.038817996985116e+03,		1.039326419033368e+03,
		1.039833236685793e+03,		1.040338461250056e+03,		1.040842103910621e+03,		1.041344175730561e+03,		1.041844687653360e+03,
		1.042343650504655e+03,		1.042841074993959e+03,		1.043336971716350e+03,		1.043831351154125e+03,		1.044324223678435e+03,
		1.044815599550873e+03,		1.045305488925050e+03,		1.045793901848133e+03,		1.046280848262353e+03,		1.046766338006496e+03,
		1.047250380817358e+03,		1.047732986331182e+03,		1.048214164085059e+03,		1.048693923518312e+03,		1.049172273973861e+03,
		1.049649224699546e+03,		1.050124784849445e+03,		1.050598963485162e+03,		1.051071769577089e+03,		1.051543212005651e+03,
		1.052013299562531e+03,		1.052482040951867e+03,		1.052949444791436e+03,		1.053415519613814e+03,		1.053880273867514e+03,
		1.054343715918116e+03,		1.054805854049356e+03,		1.055266696464225e+03,		1.055726251286024e+03,		1.056184526559418e+03,
		1.056641530251467e+03,		1.057097270252634e+03,		1.057551754377791e+03,		1.058004990367192e+03,		1.058456985887441e+03,
		1.058907748532442e+03,		1.059357285824329e+03,		1.059805605214387e+03,		1.060252714083956e+03,		1.060698619745316e+03,
		1.061143329442566e+03,		1.061586850352482e+03,		1.062029189585365e+03,		1.062470354185876e+03,		1.062910351133851e+03,
		1.063349187345117e+03,		1.063786869672277e+03,		1.064223404905498e+03,		1.064658799773281e+03,		1.065093060943218e+03,
		1.065526195022735e+03,		1.065958208559834e+03,		1.066389108043808e+03,		1.066818899905960e+03,		1.067247590520300e+03,
		1.067675186204240e+03,		1.068101693219267e+03,		1.068527117771619e+03,		1.068951466012947e+03,		1.069374744040954e+03,
		1.069796957900045e+03,		1.070218113581954e+03,		1.070638217026363e+03,		1.071057274121518e+03,		1.071475290704829e+03,
		1.071892272563463e+03,		1.072308225434930e+03,		1.072723155007661e+03,		1.073137066921573e+03,		1.073549966768631e+03,
		1.073961860093397e+03,		1.074372752393579e+03,		1.074782649120557e+03,		1.075191555679923e+03,		1.075599477431990e+03,
		1.076006419692313e+03,		1.076412387732189e+03,		1.076817386779162e+03,		1.077221422017504e+03,		1.077624498588711e+03,
		1.078026621591971e+03,		1.078427796084642e+03,		1.078828027082709e+03,		1.079227319561247e+03,		1.079625678454872e+03,
		1.080023108658181e+03,		1.080419615026198e+03,		1.080815202374800e+03,		1.081209875481150e+03,		1.081603639084111e+03,
		1.081996497884667e+03,		1.082388456546329e+03,		1.082779519695542e+03,		1.083169691922080e+03,		1.083558977779440e+03,
		1.083947381785229e+03,		1.084334908421553e+03,		1.084721562135381e+03,		1.085107347338929e+03,		1.085492268410024e+03,
		1.085876329692464e+03,		1.086259535496377e+03,		1.086641890098575e+03,		1.087023397742899e+03,		1.087404062640567e+03,
		1.087783888970510e+03,		1.088162880879707e+03,		1.088541042483513e+03,		1.088918377865993e+03,		1.089294891080232e+03,
		1.089670586148663e+03,		1.090045467063373e+03,		1.090419537786418e+03,		1.090792802250124e+03,		1.091165264357389e+03,
		1.091536927981985e+03,		1.091907796968847e+03,		1.092277875134364e+03,		1.092647166266667e+03,		1.093015674125912e+03,
		1.093383402444556e+03,		1.093750354927636e+03,		1.094116535253040e+03,		1.094481947071776e+03,		1.094846594008236e+03,
		1.095210479660463e+03,		1.095573607600403e+03,		1.095935981374166e+03,		1.096297604502276e+03,		1.096658480479922e+03,
		1.097018612777201e+03,		1.097378004839368e+03,		1.097736660087069e+03,		1.098094581916584e+03,		1.098451773700058e+03,
		1.098808238785732e+03,		1.099163980498179e+03,		1.099519002138521e+03,		1.099873306984656e+03,		1.100226898291483e+03,
		1.100579779291112e+03,		1.100931953193088e+03,		1.101283423184594e+03,		1.101634192430674e+03,		1.101984264074429e+03,
		1.102333641237227e+03,		1.102682327018911e+03,		1.103030324497990e+03,		1.103377636731846e+03,		1.103724266756923e+03,
		1.104070217588926e+03,		1.104415492223010e+03,		1.104760093633968e+03,		1.105104024776421e+03,		1.105447288584999e+03,
		1.105789887974530e+03,		1.106131825840210e+03,		1.106473105057794e+03,		1.106813728483763e+03,		1.107153698955502e+03,
		1.107493019291473e+03,		1.107831692291385e+03,		1.108169720736359e+03,		1.108507107389103e+03,		1.108843854994066e+03,
		1.109179966277612e+03,		1.109515443948172e+03,		1.109850290696407e+03,		1.110184509195366e+03,		1.110518102100640e+03,
		1.110851072050519e+03,		1.111183421666140e+03,		1.111515153551641e+03,		1.111846270294308e+03,		1.112176774464723e+03,
		1.112506668616910e+03,		1.112835955288479e+03,		1.113164637000768e+03,		1.113492716258982e+03,		1.113820195552336e+03,
		1.114147077354193e+03,		1.114473364122196e+03,		1.114799058298405e+03,		1.115124162309434e+03,		1.115448678566578e+03,
		1.115772609465945e+03,		1.116095957388585e+03,		1.116418724700621e+03,		1.116740913753371e+03,		1.117062526883476e+03,
		1.117383566413020e+03,		1.117704034649657e+03,		1.118023933886731e+03,		1.118343266403393e+03,		1.118662034464722e+03,
		1.118980240321842e+03,		1.119297886212040e+03,		1.119614974358876e+03,		1.119931506972299e+03,		1.120247486248762e+03,
		1.120562914371332e+03,		1.120877793509797e+03,		1.121192125820778e+03,		1.121505913447839e+03,		1.121819158521588e+03,
		1.122131863159788e+03,		1.122444029467456e+03,		1.122755659536975e+03,		1.123066755448187e+03,		1.123377319268502e+03
	},
	{
		1.752151988237136e+00,		5.310577911531638e+00,		8.939288730425670e+00,		1.264186077109118e+01,		1.642216996289235e+01,
		2.028442692208579e+01,		2.423321741631537e+01,		2.827354924733726e+01,		3.241090683336061e+01,		3.665131508478773e+01,
		4.100141457052797e+01,		4.546855049759164e+01,		5.006087871787350e+01,		5.478749289446878e+01,		5.965857819373127e+01,
		6.468559854672037e+01,		6.988152683368450e+01,		7.526113057113506e+01,		8.084133025530102e+01,		8.664165411124881e+01,
		9.268482268355916e+01,		9.899751122373867e+01,		1.056113600919141e+02,		1.125643384043023e+02,		1.199026228318984e+02,
		1.276832482401528e+02,		1.359779514651038e+02,		1.448789281978224e+02,		1.545077937118747e+02,		1.650301989355621e+02,
		1.766811015006197e+02,		1.898118513896941e+02,		2.049871480251432e+02,		2.232151339663172e+02,		2.466289773522210e+02,
		2.815623784278931e+02,		5.995746902620677e+02,		6.482350821694024e+02,		6.714955469655434e+02,		6.878583293815262e+02,
		7.007403328776467e+02,		7.114828395359749e+02,		7.207630789643010e+02,		7.289737215298887e+02,		7.363638888820739e+02,
		7.431021035877383e+02,		7.493080203576479e+02,		7.550698848487157e+02,		7.604548025390295e+02,		7.655151065647718e+02,
		7.702924804870013e+02,		7.748207252809258e+02,		7.791276739997602e+02,		7.832365519799915e+02,		7.871669655746122e+02,
		7.909356355083379e+02,		7.945569506470105e+02,		7.980433928929674e+02,		8.014058679122280e+02,		8.046539659190532e+02,
		8.077961697364555e+02,		8.108400225729993e+02,		8.137922646390982e+02,		8.166589453859203e+02,		8.194455164739576e+02,
		8.221569093616470e+02,		8.247976005095437e+02,		8.273716665298923e+02,		8.298828311105328e+02,		8.323345051614731e+02,
		8.347298213403218e+02,		8.370716638866572e+02,		8.393626945188281e+02,		8.416053750076329e+02,		8.438019869312933e+02,
		8.459546490279404e+02,		8.480653324913236e+02,		8.501358744979166e+02,		8.521679902084783e+02,		8.541632834446593e+02,
		8.561232562179104e+02,		8.580493172531737e+02,		8.599427896343658e+02,		8.618049176783685e+02,		8.636368731296183e+02,
		8.654397607547282e+02,		8.672146234058695e+02,		8.689624466125778e+02,		8.706841627539454e+02,		8.723806548565382e+02,
		8.740527600588030e+02,		8.757012727701118e+02,		8.773269475730168e+02,		8.789305018711483e+02,		8.805126183235101e+02,
		8.820739470840933e+02,		8.836151078611646e+02,		8.851366918158918e+02,		8.866392633135902e+02,		8.881233615477669e+02,
		8.895895020306247e+02,		8.910381779870124e+02,		8.924698616400366e+02,		8.938850054063585e+02,		8.952840430072564e+02,
		8.966673905024719e+02,		8.980354472532039e+02,		8.993885968199986e+02,		9.007272078007724e+02,		9.020516346136683e+02,
		9.033622182290933e+02,		9.046592868548070e+02,		9.059431565776724e+02,		9.072141319653000e+02,		9.084725066305563e+02,
		9.097185637616906e+02,		9.109525766205113e+02,		9.121748090109573e+02,		9.133855157201236e+02,		9.145849429336612e+02,
		9.157733286273392e+02,		9.169509029363859e+02,		9.181178885041049e+02,		9.192745008111672e+02,		9.204209484856120e+02,
		9.215574336025770e+02,		9.226841519537265e+02,		9.238012933180418e+02,		9.249090417096263e+02,		9.260075756146467e+02,
		9.270970682161143e+02,		9.281776876071979e+02,		9.292495969938258e+02,		9.303129548871779e+02,		9.313679152866790e+02,
		9.324146278540709e+02,		9.334532380790590e+02,		9.344838874370237e+02,		9.355067135397068e+02,		9.365218502763132e+02,
		9.375294279540113e+02,		9.385295734245335e+02,		9.395224102100171e+02,		9.405080586215037e+02,		9.414866358723549e+02,
		9.424582561864559e+02,		9.434230309017515e+02,		9.443810685708283e+02,		9.453324750518698e+02,		9.462773536036791e+02,
		9.472158049702945e+02,		9.481479274647087e+02,		9.490738170486403e+02,		9.499935674090195e+02,		9.509072700313269e+02,
		9.518150142699758e+02,		9.527168874158374e+02,		9.536129747610871e+02,		9.545033596614797e+02,		9.553881235961740e+02,
		9.562673462252354e+02,		9.571411054449082e+02,		9.580094774407829e+02,		9.588725367389302e+02,		9.597303562551148e+02,
		9.605830073421644e+02,		9.614305598355796e+02,		9.622730820974743e+02,		9.631106410588940e+02,		9.639433022606147e+02,
		9.647711298924623e+02,		9.655941868312366e+02,		9.664125346772880e+02,		9.672262337898002e+02,		9.680353433208593e+02,
		9.688399212483181e+02,		9.696400244075522e+02,		9.704357085221109e+02,		9.712270282347805e+02,		9.720140371307886e+02,
		9.727967877731797e+02,		9.735753317246752e+02,		9.743497195747047e+02,		9.751200009644289e+02,		9.758862246109477e+02,
		9.766484383307268e+02,		9.774066890622705e+02,		9.781610228880802e+02,		9.789114850559074e+02,		9.796581199993565e+02,
		9.804009713578170e+02,		9.811400819958110e+02,		9.818754940217179e+02,		9.826072488059457e+02,		9.833353869985322e+02,
		9.840599485462349e+02,		9.847809727090869e+02,		9.854984980764810e+02,		9.862125625827567e+02,		9.869232035223472e+02,
		9.876304575644663e+02,		9.883343607673862e+02,		9.890349485922853e+02,		9.897322559167103e+02,		9.904263170476561e+02,
		9.911171657342586e+02,		9.918048351801531e+02,		9.924893580554633e+02,		9.931707665084764e+02,		9.938490921769835e+02,
		9.945243661993056e+02,		9.951966192250338e+02,		9.958658814254583e+02,		9.965321825037258e+02,		9.971955517047247e+02,
		9.978560178247004e+02,		9.985136092206233e+02,		9.991683538193013e+02,		9.998202791262528e+02,		1.000469412234358e+03,
		1.001115779832275e+03,		1.001759408212644e+03,		1.002400323280076e+03,		1.003038550558943e+03,		1.003674115200968e+03,
		1.004307041992624e+03,		1.004937355362342e+03,		1.005565079387547e+03,		1.006190237801514e+03,		1.006812854000055e+03,
		1.007432951048043e+03,		1.008050551685773e+03,		1.008665678335176e+03,		1.009278353105869e+03,		1.009888597801078e+03,
		1.010496433923399e+03,		1.011101882680437e+03,		1.011704964990302e+03,		1.012305701486982e+03,		1.012904112525588e+03,
		1.013500218187468e+03,		1.014094038285217e+03,		1.014685592367561e+03,		1.015274899724128e+03,		1.015861979390120e+03,
		1.016446850150862e+03,		1.017029530546270e+03,		1.017610038875190e+03,		1.018188393199670e+03,		1.018764611349110e+03,
		1.019338710924342e+03,		1.019910709301597e+03,		1.020480623636410e+03,		1.021048470867414e+03,		1.021614267720071e+03,
		1.022178030710313e+03,		1.022739776148102e+03,		1.023299520140923e+03,		1.023857278597191e+03,		1.024413067229591e+03,
		1.024966901558352e+03,		1.025518796914439e+03,		1.026068768442690e+03,		1.026616831104883e+03,		1.027162999682738e+03,
		1.027707288780855e+03,		1.028249712829595e+03,		1.028790286087907e+03,		1.029329022646080e+03,		1.029865936428457e+03,
		1.030401041196085e+03,		1.030934350549311e+03,		1.031465877930330e+03,		1.031995636625680e+03,		1.032523639768684e+03,
		1.033049900341849e+03,		1.033574431179216e+03,		1.034097244968658e+03,		1.034618354254144e+03,		1.035137771437947e+03,
		1.035655508782818e+03,		1.036171578414112e+03,		1.036685992321877e+03,		1.037198762362902e+03,		1.037709900262722e+03,
		1.038219417617590e+03,		1.038727325896413e+03,		1.039233636442638e+03,		1.039738360476123e+03,		1.040241509094958e+03,
		1.040743093277254e+03,		1.041243123882907e+03,		1.041741611655316e+03,		1.042238567223083e+03,		1.042734001101673e+03,
		1.043227923695045e+03,		1.043720345297257e+03,		1.044211276094038e+03,		1.044700726164330e+03,		1.045188705481813e+03,
		1.045675223916384e+03,		1.046160291235627e+03,		1.046643917106250e+03,		1.047126111095494e+03,		1.047606882672521e+03,
		1.048086241209773e+03,		1.048564195984319e+03,		1.049040756179156e+03,		1.049515930884515e+03,		1.049989729099121e+03,
		1.050462159731446e+03,		1.050933231600932e+03,		1.051402953439196e+03,		1.051871333891217e+03,		1.052338381516497e+03,
		1.052804104790209e+03,		1.053268512104321e+03,		1.053731611768699e+03,		1.054193412012200e+03,		1.054653920983735e+03,
		1.055113146753329e+03,		1.055571097313146e+03,		1.056027780578514e+03,		1.056483204388917e+03,		1.056937376508989e+03,
		1.057390304629472e+03,		1.057841996368173e+03,		1.058292459270900e+03,		1.058741700812380e+03,		1.059189728397171e+03,
		1.059636549360550e+03,		1.060082170969388e+03,		1.060526600423018e+03,		1.060969844854086e+03,		1.061411911329380e+03,
		1.061852806850658e+03,		1.062292538355457e+03,		1.062731112717891e+03,		1.063168536749436e+03,		1.063604817199688e+03,
		1.064039960757166e+03,		1.064473974050005e+03,		1.064906863646727e+03,		1.065338636056960e+03,		1.065769297732152e+03,
		1.066198855066270e+03,		1.066627314396503e+03,		1.067054682003934e+03,		1.067480964114216e+03,		1.067906166898237e+03,
		1.068330296472766e+03,		1.068753358901099e+03,		1.069175360193690e+03,		1.069596306308774e+03,		1.070016203152981e+03,
		1.070435056581940e+03,		1.070852872400878e+03,		1.071269656365200e+03,		1.071685414181073e+03,		1.072100151505995e+03,
		1.072513873949355e+03,		1.072926587072986e+03,		1.073338296391713e+03,		1.073749007373888e+03,		1.074158725441918e+03,
		1.074567455972791e+03,		1.074975204298592e+03,		1.075381975706999e+03,		1.075787775441799e+03,		1.076192608703368e+03,
		1.076596480649163e+03,		1.076999396394199e+03,		1.077401361011523e+03,		1.077802379532678e+03,		1.078202456948162e+03,
		1.078601598207881e+03,		1.078999808221598e+03,		1.079397091859368e+03,		1.079793453951978e+03,		1.080188899291370e+03,
		1.080583432631066e+03,		1.080977058686584e+03,		1.081369782135849e+03,		1.081761607619598e+03,		1.082152539741780e+03,
		1.082542583069948e+03,		1.082931742135650e+03,		1.083320021434815e+03,		1.083707425428126e+03,		1.084093958541397e+03,
		1.084479625165943e+03,		1.084864429658936e+03,		1.085248376343775e+03,		1.085631469510431e+03,		1.086013713415799e+03,
		1.086395112284044e+03,		1.086775670306941e+03,		1.087155391644206e+03,		1.087534280423836e+03,		1.087912340742428e+03,
		1.088289576665505e+03,		1.088665992227836e+03,		1.089041591433747e+03,		1.089416378257433e+03,		1.089790356643268e+03,
		1.090163530506099e+03,		1.090535903731554e+03,		1.090907480176329e+03,		1.091278263668487e+03,		1.091648258007734e+03,
		1.092017466965716e+03,		1.092385894286290e+03,		1.092753543685803e+03,		1.093120418853365e+03,		1.093486523451121e+03,
		1.093851861114514e+03,		1.094216435452550e+03,		1.094580250048057e+03,		1.094943308457942e+03,		1.095305614213444e+03,
		1.095667170820385e+03,		1.096027981759415e+03,		1.096388050486260e+03,		1.096747380431961e+03,		1.097105975003110e+03,
		1.097463837582088e+03,		1.097820971527299e+03,		1.098177380173395e+03,		1.098533066831508e+03,		1.098888034789470e+03,
		1.099242287312036e+03,		1.099595827641105e+03,		1.099948658995930e+03,		1.100300784573340e+03,		1.100652207547947e+03,
		1.101002931072350e+03,		1.101352958277348e+03,		1.101702292272143e+03,		1.102050936144537e+03,		1.102398892961133e+03,
		1.102746165767535e+03,		1.103092757588536e+03,		1.103438671428313e+03,		1.103783910270621e+03,		1.104128477078974e+03,
		1.104472374796830e+03,		1.104815606347783e+03,		1.105158174635735e+03,		1.105500082545080e+03,		1.105841332940877e+03,
		1.106181928669031e+03,		1.106521872556460e+03,		1.106861167411269e+03,		1.107199816022919e+03,		1.107537821162397e+03,
		1.107875185582372e+03,		1.108211912017368e+03,		1.108548003183922e+03,		1.108883461780745e+03,		1.109218290488877e+03,
		1.109552491971846e+03,		1.109886068875820e+03,		1.110219023829765e+03,		1.110551359445590e+03,		1.110883078318299e+03,
		1.111214183026138e+03,		1.111544676130743e+03,		1.111874560177284e+03,		1.112203837694605e+03,		1.112532511195370e+03,
		1.112860583176198e+03,		1.113188056117805e+03,		1.113514932485140e+03,		1.113841214727519e+03,		1.114166905278759e+03,
		1.114492006557314e+03,		1.114816520966399e+03,		1.115140450894128e+03,		1.115463798713635e+03,		1.115786566783204e+03,
		1.116108757446395e+03,		1.116430373032168e+03,		1.116751415855003e+03,		1.117071888215025e+03,		1.117391792398124e+03,
		1.117711130676070e+03,		1.118029905306637e+03,		1.118348118533712e+03,		1.118665772587419e+03,		1.118982869684224e+03,
		1.119299412027054e+03,		1.119615401805410e+03,		1.119930841195468e+03,		1.120245732360200e+03,		1.120560077449476e+03,
		1.120873878600169e+03,		1.121187137936268e+03,		1.121499857568979e+03,		1.121812039596825e+03,		1.122123686105758e+03
	},
	{
		1.748623593853173e+00,		5.299542058541745e+00,		8.920106249945032e+00,		1.261382927037262e+01,		1.638451573094127e+01,
		2.023629552547383e+01,		2.417366272508118e+01,		2.820152056878511e+01,		3.232523375198112e+01,		3.655068950367094e+01,
		4.088436931557382e+01,		4.533343366947025e+01,		4.990582274241986e+01,		5.461037690769595e+01,		5.945698197060378e+01,
		6.445674559579959e+01,		6.962221346197120e+01,		7.496763656752806e+01,		8.050930518115888e+01,		8.626597076099279e+01,
		9.225938566537900e+01,		9.851500311355757e+01,		1.050628990501326e+02,		1.119390074446393e+02,		1.191868083463275e+02,
		1.268596868550615e+02,		1.350243159335536e+02,		1.437656560008996e+02,		1.531946128251430e+02,		1.634602832027716e+02,
		1.747706028530596e+02,		1.874295759764824e+02,		2.019105716536155e+02,		2.190192204743906e+02,		2.403269467832398e+02,
		2.697391521208954e+02,		3.255551792699735e+02,		6.180303020350135e+02,		6.523271058304051e+02,		6.729450729613549e+02,
		6.881945849772264e+02,		7.004762951032812e+02,		7.108511242912379e+02,		7.198876570193790e+02,		7.279278665078905e+02,
		7.351941860964141e+02,		7.418398272332489e+02,		7.479750699572299e+02,		7.536821181893616e+02,		7.590240186874950e+02,
		7.640502829197692e+02,		7.688005755693474e+02,		7.733072174554924e+02,		7.775969335435626e+02,		7.816921045471360e+02,
		7.856116828699858e+02,		7.893718759580132e+02,		7.929866649514611e+02,		7.964682044326067e+02,		7.998271348243040e+02,
		8.030728296030629e+02,		8.062135931660212e+02,		8.092568208517039e+02,		8.122091295852689e+02,		8.150764654711679e+02,
		8.178641931109929e+02,		8.205771702978624e+02,		8.232198109073512e+02,		8.257961381842357e+02,		8.283098301553323e+02,
		8.307642585461930e+02,		8.331625222897082e+02,		8.355074765297408e+02,		8.378017578235191e+02,		8.400478061380506e+02,
		8.422478841217162e+02,		8.444040940504646e+02,		8.465183927806190e+02,		8.485926049857636e+02,		8.506284349099948e+02,
		8.526274768389940e+02,		8.545912244413155e+02,		8.565210791441731e+02,		8.584183576437320e+02,		8.602842986650393e+02,
		8.621200690570016e+02,		8.639267693042167e+02,		8.657054385115258e+02,		8.674570589347289e+02,		8.691825600953139e+02,
		8.708828225290408e+02,		8.725586812063787e+02,		8.742109286584418e+02,		8.758403178385163e+02,		8.774475647456206e+02,
		8.790333508355775e+02,		8.805983252304168e+02,		8.821431067653411e+02,		8.836682858657909e+02,		8.851744262850119e+02,
		8.866620667095990e+02,		8.881317222455791e+02,		8.895838857955728e+02,		8.910190293364627e+02,		8.924376051061039e+02,
		8.938400467067207e+02,		8.952267701319361e+02,		8.965981747236871e+02,		8.979546440646975e+02,		8.992965468116510e+02,
		9.006242374737341e+02,		9.019380571408071e+02,		9.032383341650485e+02,		9.045253847996039e+02,		9.057995137974768e+02,
		9.070610149735681e+02,		9.083101717325736e+02,		9.095472575652037e+02,		9.107725365149669e+02,		9.119862636176061e+02,
		9.131886853150863e+02,		9.143800398458802e+02,		9.155605576131736e+02,		9.167304615324641e+02,		9.178899673599402e+02,
		9.190392840028879e+02,		9.201786138133033e+02,		9.213081528658007e+02,		9.224280912207975e+02,		9.235386131739177e+02,
		9.246398974924807e+02,		9.257321176398423e+02,		9.268154419883692e+02,		9.278900340217075e+02,		9.289560525269951e+02,
		9.300136517776181e+02,		9.310629817070518e+02,		9.321041880743298e+02,		9.331374126215981e+02,		9.341627932242169e+02,
		9.351804640338346e+02,		9.361905556148189e+02,		9.371931950744182e+02,		9.381885061869988e+02,		9.391766095126708e+02,
		9.401576225106261e+02,		9.411316596474438e+02,		9.420988325006512e+02,		9.430592498577798e+02,		9.440130178111525e+02,
		9.449602398486236e+02,		9.459010169404755e+02,		9.468354476226693e+02,		9.477636280766349e+02,		9.486856522057631e+02,
		9.496016117087819e+02,		9.505115961501433e+02,		9.514156930275943e+02,		9.523139878370426e+02,		9.532065641348619e+02,
		9.540935035977591e+02,		9.549748860789341e+02,		9.558507896687905e+02,		9.567212907401730e+02,		9.575864640047671e+02,
		9.584463825610659e+02,		9.593011179417813e+02,		9.601507401594962e+02,		9.609953177506417e+02,		9.618349178178639e+02,
		9.626696060708556e+02,		9.634994468657303e+02,		9.643245032429774e+02,		9.651448369640838e+02,		9.659605085468631e+02,
		9.667715772995577e+02,		9.675781013537521e+02,		9.683801376961669e+02,		9.691777421993489e+02,		9.699709696513466e+02,
		9.707598737843647e+02,		9.715445073024721e+02,		9.723249219083946e+02,		9.731011683294163e+02,		9.738732963424375e+02,
		9.746413547982273e+02,		9.754053916448763e+02,		9.761654539505139e+02,		9.769215879252999e+02,		9.776738389427139e+02,
		9.784222515601851e+02,		9.791668695390701e+02,		9.799077358640260e+02,		9.806448927617706e+02,		9.813783817192806e+02,
		9.821082435014373e+02,		9.828345181681292e+02,		9.835572450908547e+02,		9.842764629688271e+02,		9.849922098445963e+02,
		9.857045231192161e+02,		9.864134395669720e+02,		9.871189953496738e+02,		9.878212260305414e+02,		9.885201665876863e+02,
		9.892158514272184e+02,		9.899083143959712e+02,		9.905975887938752e+02,		9.912837073859812e+02,		9.919667024141556e+02,
		9.926466056084359e+02,		9.933234481981020e+02,		9.939972609224124e+02,		9.946680740410765e+02,		9.953359173444228e+02,
		9.960008201633115e+02,		9.966628113787689e+02,		9.973219194313691e+02,		9.979781723303805e+02,		9.986315976626465e+02,
		9.992822226012657e+02,		9.999300739140177e+02,		1.000575177971591e+03,		1.001217560755593e+03,		1.001857247866353e+03,
		1.002494264530534e+03,		1.003128635608539e+03,		1.003760385601753e+03,		1.004389538659582e+03,		1.005016118586329e+03,
		1.005640148847898e+03,		1.006261652578333e+03,		1.006880652586194e+03,		1.007497171360787e+03,		1.008111231078229e+03,
		1.008722853607381e+03,		1.009332060515631e+03,		1.009938873074539e+03,		1.010543312265354e+03,		1.011145398784394e+03,
		1.011745153048305e+03,		1.012342595199193e+03,		1.012937745109644e+03,		1.013530622389074e+03,		1.014121246382625e+03,
		1.014709636184775e+03,		1.015295810637889e+03,		1.015879788338210e+03,		1.016461587640219e+03,		1.017041226660911e+03,
		1.017618723283957e+03,		1.018194095163793e+03,		1.018767359729606e+03,		1.019338534189235e+03,		1.019907635532991e+03,
		1.020474680537382e+03,		1.021039685768777e+03,		1.021602667586967e+03,		1.022163642148670e+03,		1.022722625410948e+03,
		1.023279633134556e+03,		1.023834680887222e+03,		1.024387784046850e+03,		1.024938957804668e+03,		1.025488217168298e+03,
		1.026035576964763e+03,		1.026581051843450e+03,		1.027124656278982e+03,		1.027666404574052e+03,		1.028206310862198e+03,
		1.028744389110513e+03,		1.029280653122300e+03,		1.029815116539684e+03,		1.030347792846163e+03,		1.030878695369105e+03,
		1.031407837282208e+03,		1.031935231607895e+03,		1.032460891219675e+03,		1.032984828844450e+03,		1.033507057064779e+03,
		1.034027588321099e+03,		1.034546434913899e+03,		1.035063609005859e+03,		1.035579122623937e+03,		1.036092987661429e+03,
		1.036605215879978e+03,		1.037115818911548e+03,		1.037624808260372e+03,		1.038132195304839e+03,		1.038637991299371e+03,
		1.039142207376249e+03,		1.039644854547411e+03,		1.040145943706211e+03,		1.040645485629159e+03,		1.041143490977607e+03,
		1.041639970299427e+03,		1.042134934030642e+03,		1.042628392497036e+03,		1.043120355915726e+03,		1.043610834396723e+03,
		1.044099837944440e+03,		1.044587376459196e+03,		1.045073459738678e+03,		1.045558097479385e+03,		1.046041299278042e+03,
		1.046523074632990e+03,		1.047003432945556e+03,		1.047482383521391e+03,		1.047959935571790e+03,		1.048436098214991e+03,
		1.048910880477440e+03,		1.049384291295055e+03,		1.049856339514442e+03,		1.050327033894114e+03,		1.050796383105674e+03,
		1.051264395734982e+03,		1.051731080283309e+03,		1.052196445168458e+03,		1.052660498725878e+03,		1.053123249209755e+03,
		1.053584704794079e+03,		1.054044873573710e+03,		1.054503763565402e+03,		1.054961382708833e+03,		1.055417738867604e+03,
		1.055872839830225e+03,		1.056326693311090e+03,		1.056779306951426e+03,		1.057230688320236e+03,		1.057680844915224e+03,
		1.058129784163697e+03,		1.058577513423471e+03,		1.059024039983739e+03,		1.059469371065947e+03,		1.059913513824639e+03,
		1.060356475348299e+03,		1.060798262660178e+03,		1.061238882719101e+03,		1.061678342420274e+03,		1.062116648596064e+03,
		1.062553808016779e+03,		1.062989827391425e+03,		1.063424713368466e+03,		1.063858472536555e+03,		1.064291111425262e+03,
		1.064722636505800e+03,		1.065153054191719e+03,		1.065582370839607e+03,		1.066010592749777e+03,		1.066437726166130e+03,
		1.066863777280098e+03,		1.067288752226293e+03,		1.067712657086553e+03,		1.068135497889706e+03,		1.068557280612198e+03,
		1.068978011178705e+03,		1.069397695462745e+03,		1.069816339287270e+03,		1.070233948425257e+03,		1.070650528600290e+03,
		1.071066085487128e+03,		1.071480624712270e+03,		1.071894151854511e+03,		1.072306672445486e+03,		1.072718191970212e+03,
		1.073128715867619e+03,		1.073538249531073e+03,		1.073946798308890e+03,		1.074354367504847e+03,		1.074760962378686e+03,
		1.075166588146604e+03,		1.075571249981741e+03,		1.075974953014664e+03,		1.076377702333837e+03,		1.076779502986087e+03,
		1.077180359977074e+03,		1.077580278271730e+03,		1.077979262794721e+03,		1.078377318430879e+03,		1.078774450025644e+03,
		1.079170662385486e+03,		1.079565960278339e+03,		1.079960348434008e+03,		1.080353831544589e+03,		1.080746414264871e+03,
		1.081138101212738e+03,		1.081528896969567e+03,		1.081918806080614e+03,		1.082307833055401e+03,		1.082695982368096e+03,
		1.083083258457888e+03,		1.083469665729355e+03,		1.083855208552829e+03,		1.084239891264756e+03,		1.084623718168054e+03,
		1.085006693532459e+03,		1.085388821594873e+03,		1.085770106559703e+03,		1.086150552599203e+03,		1.086530163853801e+03,
		1.086908944432429e+03,		1.087286898412847e+03,		1.087664029841962e+03,		1.088040342736143e+03,		1.088415841081537e+03,
		1.088790528834367e+03,		1.089164409921246e+03,		1.089537488239465e+03,		1.089909767657303e+03,		1.090281252014305e+03,
		1.090651945121579e+03,		1.091021850762079e+03,		1.091390972690882e+03,		1.091759314635471e+03,		1.092126880296006e+03,
		1.092493673345593e+03,		1.092859697430559e+03,		1.093224956170703e+03,		1.093589453159568e+03,		1.093953191964694e+03,
		1.094316176127870e+03,		1.094678409165391e+03,		1.095039894568299e+03,		1.095400635802611e+03,		1.095760636309651e+03,
		1.096119899506144e+03,		1.096478428784555e+03,		1.096836227513294e+03,		1.097193299036947e+03,		1.097549646676503e+03,
		1.097905273729579e+03,		1.098260183470643e+03,		1.098614379151236e+03,		1.098967864000181e+03,		1.099320641223804e+03,
		1.099672714006146e+03,		1.100024085509167e+03,		1.100374758872958e+03,		1.100724737215944e+03,		1.101074023635083e+03,
		1.101422621206068e+03,		1.101770532983528e+03,		1.102117762001212e+03,		1.102464311272195e+03,		1.102810183789058e+03,
		1.103155382524082e+03,		1.103499910429430e+03,		1.103843770437335e+03,		1.104186965460279e+03,		1.104529498391174e+03,
		1.104871372103536e+03,		1.105212589451668e+03,		1.105553153270828e+03,		1.105893066377396e+03,		1.106232331569056e+03,
		1.106570951624957e+03,		1.106908929305873e+03,		1.107246267354378e+03,		1.107582968495000e+03,		1.107919035434387e+03,
		1.108254470861460e+03,		1.108589277447573e+03,		1.108923457846708e+03,		1.109257014695464e+03,		1.109589950613459e+03,
		1.109922268203311e+03,		1.110253970050824e+03,		1.110585058725144e+03,		1.110915536778895e+03,		1.111245406748329e+03,
		1.111574671153463e+03,		1.111903332498222e+03,		1.112231393270579e+03,		1.112558855942688e+03,		1.112885722971021e+03,
		1.113211996796507e+03,		1.113537679844659e+03,		1.113862774525708e+03,		1.114187283234732e+03,		1.114511208351787e+03,
		1.114834552242032e+03,		1.115157317255853e+03,		1.115479505728992e+03,		1.115801119982670e+03,		1.116122162323701e+03,
		1.116442635044627e+03,		1.116762540423821e+03,		1.117081880725618e+03,		1.117400658200424e+03,		1.117718875084838e+03,
		1.118036533601759e+03,		1.118353635960507e+03,		1.118670184356927e+03,		1.118986180973508e+03,		1.119301627979485e+03,
		1.119616527530957e+03,		1.119930881770982e+03,		1.120244692829696e+03,		1.120557962824409e+03,		1.120870693859714e+03
	},
	{
		1.745109615964491e+00,		5.288554232268131e+00,		8.901012618715500e+00,		1.258593587927617e+01,		1.634705876427999e+01,
		2.018843218509789e+01,		2.411446060221262e+01,		2.812994520371721e+01,		3.224013400147737e+01,		3.645078023980996e+01,
		4.076821085495074e+01,		4.519940716801042e+01,		4.975210057445894e+01,		5.443488675834766e+01,		5.925736297884945e+01,
		6.423029434995723e+01,		6.936581690661957e+01,		7.467768783721365e+01,		8.018159688655545e+01,		8.589555809121785e+01,
		9.184040847417687e+01,		9.804045133537370e+01,		1.045242983514296e+02,		1.113259902395512e+02,		1.184865161290579e+02,
		1.260559175469026e+02,		1.340962736408098e+02,		1.426860579827255e+02,		1.519267118127374e+02,		1.619529627951072e+02,
		1.729498261813679e+02,		1.851823595121857e+02,		1.990519519472596e+02,		2.152145563282416e+02,		2.348691060166886e+02,
		2.606487415334004e+02,		3.009813766048302e+02,		5.536220493061280e+02,		6.276384598184467e+02,		6.554924819206389e+02,
		6.741353154692118e+02,		6.884460569099242e+02,		7.001917526667272e+02,		7.102268691410409e+02,		7.190329670251762e+02,
		7.269092548682754e+02,		7.340548450682778e+02,		7.406092225243490e+02,		7.466740978013357e+02,		7.523260671756049e+02,
		7.576243637542957e+02,		7.626158207279595e+02,		7.673381700807375e+02,		7.718223052359233e+02,		7.760938756938236e+02,
		7.801744377170450e+02,		7.840823020755381e+02,		7.878331702116993e+02,		7.914406195479428e+02,		7.949164792223180e+02,
		7.982711248992368e+02,		8.015137129010433e+02,		8.046523682090718e+02,		8.076943369491386e+02,		8.106461112152141e+02,
		8.135135321170958e+02,		8.163018755158272e+02,		8.190159238695239e+02,		8.216600268410098e+02,		8.242381527407417e+02,
		8.267539324412003e+02,		8.292106970643409e+02,		8.316115104859268e+02,		8.339591974997109e+02,		8.362563683270196e+02,
		8.385054400329101e+02,		8.407086553109062e+02,		8.428680990190068e+02,		8.449857127855765e+02,		8.470633079517639e+02,
		8.491025770746654e+02,		8.511051041806699e+02,		8.530723739296457e+02,		8.550057798269114e+02,		8.569066316000174e+02,
		8.587761618408632e+02,		8.606155319996797e+02,		8.624258378057087e+02,		8.642081141794215e+02,		8.659633396927024e+02,
		8.676924406261825e+02,		8.693962946667559e+02,		8.710757342830238e+02,		8.727315498118420e+02,		8.743644922851996e+02,
		8.759752760232919e+02,		8.775645810166219e+02,		8.791330551174757e+02,		8.806813160587689e+02,		8.822099533163870e+02,
		8.837195298293515e+02,		8.852105835906626e+02,		8.866836291203148e+02,		8.881391588308290e+02,		8.895776442945590e+02,
		8.909995374211539e+02,		8.924052715527226e+02,		8.937952624834833e+02,		8.951699094100981e+02,		8.965295958182488e+02,
		8.978746903105340e+02,		8.992055473802928e+02,		9.005225081355226e+02,		9.018259009767253e+02,		9.031160422321533e+02,
		9.043932367536289e+02,		9.056577784758275e+02,		9.069099509417061e+02,		9.081500277965025e+02,		9.093782732525106e+02,
		9.105949425267253e+02,		9.118002822532134e+02,		9.129945308719393e+02,		9.141779189956634e+02,		9.153506697563681e+02,
		9.165129991325699e+02,		9.176651162587774e+02,		9.188072237182507e+02,		9.199395178201363e+02,		9.210621888619611e+02,
		9.221754213784183e+02,		9.232793943772946e+02,		9.243742815633165e+02,		9.254602515506760e+02,		9.265374680649027e+02,
		9.276060901347101e+02,		9.286662722744459e+02,		9.297181646576369e+02,		9.307619132822146e+02,		9.317976601278427e+02,
		9.328255433058180e+02,		9.338456972019745e+02,		9.348582526129574e+02,		9.358633368762537e+02,		9.368610739943081e+02,
		9.378515847530555e+02,		9.388349868351612e+02,		9.398113949282581e+02,		9.407809208284457e+02,		9.417436735392914e+02,
		9.426997593665774e+02,		9.436492820090021e+02,		9.445923426450564e+02,		9.455290400162481e+02,		9.464594705068824e+02,
		9.473837282205492e+02,		9.483019050534848e+02,		9.492140907649776e+02,		9.501203730449280e+02,		9.510208375787355e+02,
		9.519155681096119e+02,		9.528046464984626e+02,		9.536881527814396e+02,		9.545661652252732e+02,		9.554387603804938e+02,
		9.563060131326370e+02,		9.571679967515154e+02,		9.580247829386628e+02,		9.588764418730120e+02,		9.597230422548932e+02,
		9.605646513484437e+02,		9.614013350224658e+02,		9.622331577898232e+02,		9.630601828454382e+02,		9.638824721029420e+02,
		9.647000862300372e+02,		9.655130846826264e+02,		9.663215257377680e+02,		9.671254665254919e+02,		9.679249630595319e+02,
		9.687200702670287e+02,		9.695108420172128e+02,		9.702973311491570e+02,		9.710795894985879e+02,		9.718576679238270e+02,
		9.726316163308794e+02,		9.734014836977109e+02,		9.741673180977443e+02,		9.749291667225970e+02,		9.756870759041035e+02,
		9.764410911356428e+02,		9.771912570927863e+02,		9.779376176533189e+02,		9.786802159166252e+02,		9.794190942224894e+02,
		9.801542941693198e+02,		9.808858566318150e+02,		9.816138217781062e+02,		9.823382290863753e+02,		9.830591173609901e+02,
		9.837765247481523e+02,		9.844904887510941e+02,		9.852010462448233e+02,		9.859082334904467e+02,		9.866120861490762e+02,
		9.873126392953382e+02,		9.880099274305021e+02,		9.887039844952243e+02,		9.893948438819534e+02,		9.900825384469662e+02,
		9.907671005220890e+02,		9.914485619260807e+02,		9.921269539757092e+02,		9.928023074965262e+02,		9.934746528333479e+02,
		9.941440198604488e+02,		9.948104379914896e+02,		9.954739361891724e+02,		9.961345429746490e+02,		9.967922864366692e+02,
		9.974471942404969e+02,		9.980992936365953e+02,		9.987486114690790e+02,		9.993951741839551e+02,		1.000039007837148e+03,
		1.000680138102323e+03,		1.001318590278512e+03,		1.001954389297540e+03,		1.002587559731273e+03,		1.003218125798682e+03,
		1.003846111372731e+03,		1.004471539987090e+03,		1.005094434842701e+03,		1.005714818814157e+03,		1.006332714455949e+03,
		1.006948144008547e+03,		1.007561129404344e+03,		1.008171692273453e+03,		1.008779853949367e+03,		1.009385635474482e+03,
		1.009989057605499e+03,		1.010590140818689e+03,		1.011188905315035e+03,		1.011785371025268e+03,		1.012379557614773e+03,
		1.012971484488382e+03,		1.013561170795070e+03,		1.014148635432530e+03,		1.014733897051657e+03,		1.015316974060914e+03,
		1.015897884630622e+03,		1.016476646697136e+03,		1.017053277966933e+03,		1.017627795920620e+03,		1.018200217816835e+03,
		1.018770560696080e+03,		1.019338841384462e+03,		1.019905076497350e+03,		1.020469282442964e+03,		1.021031475425871e+03,
		1.021591671450427e+03,		1.022149886324119e+03,		1.022706135660865e+03,		1.023260434884222e+03,		1.023812799230534e+03,
		1.024363243752024e+03,		1.024911783319800e+03,		1.025458432626823e+03,		1.026003206190793e+03,		1.026546118356990e+03,
		1.027087183301051e+03,		1.027626415031689e+03,		1.028163827393359e+03,		1.028699434068872e+03,		1.029233248581953e+03,
		1.029765284299752e+03,		1.030295554435296e+03,		1.030824072049905e+03,		1.031350850055551e+03,		1.031875901217172e+03,
		1.032399238154948e+03,		1.032920873346516e+03,		1.033440819129164e+03,		1.033959087701963e+03,		1.034475691127872e+03,
		1.034990641335788e+03,		1.035503950122577e+03,		1.036015629155045e+03,		1.036525689971886e+03,		1.037034143985587e+03,
		1.037541002484302e+03,		1.038046276633680e+03,		1.038549977478675e+03,		1.039052115945312e+03,		1.039552702842416e+03,
		1.040051748863322e+03,		1.040549264587548e+03,		1.041045260482428e+03,		1.041539746904733e+03,		1.042032734102246e+03,
		1.042524232215320e+03,		1.043014251278403e+03,		1.043502801221533e+03,		1.043989891871817e+03,		1.044475532954864e+03,
		1.044959734096219e+03,		1.045442504822746e+03,		1.045923854564004e+03,		1.046403792653592e+03,		1.046882328330471e+03,
		1.047359470740263e+03,		1.047835228936528e+03,		1.048309611882019e+03,		1.048782628449918e+03,		1.049254287425042e+03,
		1.049724597505042e+03,		1.050193567301565e+03,		1.050661205341416e+03,		1.051127520067678e+03,		1.051592519840836e+03,
		1.052056212939863e+03,		1.052518607563298e+03,		1.052979711830308e+03,		1.053439533781720e+03,		1.053898081381050e+03,
		1.054355362515510e+03,		1.054811384996992e+03,		1.055266156563046e+03,		1.055719684877837e+03,		1.056171977533085e+03,
		1.056623042048995e+03,		1.057072885875163e+03,		1.057521516391481e+03,		1.057968940909011e+03,		1.058415166670861e+03,
		1.058860200853036e+03,		1.059304050565278e+03,		1.059746722851899e+03,		1.060188224692589e+03,		1.060628563003224e+03,
		1.061067744636650e+03,		1.061505776383466e+03,		1.061942664972783e+03,		1.062378417072984e+03,		1.062813039292456e+03,
		1.063246538180330e+03,		1.063678920227194e+03,		1.064110191865801e+03,		1.064540359471771e+03,		1.064969429364270e+03,
		1.065397407806690e+03,		1.065824301007317e+03,		1.066250115119984e+03,		1.066674856244715e+03,		1.067098530428366e+03,
		1.067521143665248e+03,		1.067942701897749e+03,		1.068363211016932e+03,		1.068782676863151e+03,		1.069201105226624e+03,
		1.069618501848027e+03,		1.070034872419062e+03,		1.070450222583023e+03,		1.070864557935353e+03,		1.071277884024191e+03,
		1.071690206350916e+03,		1.072101530370677e+03,		1.072511861492918e+03,		1.072921205081899e+03,		1.073329566457202e+03,
		1.073736950894237e+03,		1.074143363624739e+03,		1.074548809837250e+03,		1.074953294677612e+03,		1.075356823249431e+03,
		1.075759400614553e+03,		1.076161031793523e+03,		1.076561721766042e+03,		1.076961475471414e+03,		1.077360297808990e+03,
		1.077758193638606e+03,		1.078155167781013e+03,		1.078551225018300e+03,		1.078946370094316e+03,		1.079340607715082e+03,
		1.079733942549198e+03,		1.080126379228247e+03,		1.080517922347189e+03,		1.080908576464756e+03,		1.081298346103834e+03,
		1.081687235751846e+03,		1.082075249861129e+03,		1.082462392849303e+03,		1.082848669099636e+03,		1.083234082961406e+03,
		1.083618638750260e+03,		1.084002340748561e+03,		1.084385193205734e+03,		1.084767200338616e+03,		1.085148366331785e+03,
		1.085528695337897e+03,		1.085908191478019e+03,		1.086286858841943e+03,		1.086664701488521e+03,		1.087041723445969e+03,
		1.087417928712184e+03,		1.087793321255054e+03,		1.088167905012761e+03,		1.088541683894081e+03,		1.088914661778680e+03,
		1.089286842517408e+03,		1.089658229932589e+03,		1.090028827818304e+03,		1.090398639940675e+03,		1.090767670038142e+03,
		1.091135921821740e+03,		1.091503398975368e+03,		1.091870105156057e+03,		1.092236043994237e+03,		1.092601219093997e+03,
		1.092965634033340e+03,		1.093329292364447e+03,		1.093692197613919e+03,		1.094054353283028e+03,		1.094415762847971e+03,
		1.094776429760100e+03,		1.095136357446169e+03,		1.095495549308572e+03,		1.095854008725572e+03,		1.096211739051537e+03,
		1.096568743617163e+03,		1.096925025729707e+03,		1.097280588673199e+03,		1.097635435708676e+03,		1.097989570074387e+03,
		1.098342994986014e+03,		1.098695713636885e+03,		1.099047729198182e+03,		1.099399044819148e+03,		1.099749663627293e+03,
		1.100099588728596e+03,		1.100448823207708e+03,		1.100797370128144e+03,		1.101145232532484e+03,		1.101492413442563e+03,
		1.101838915859664e+03,		1.102184742764704e+03,		1.102529897118424e+03,		1.102874381861572e+03,		1.103218199915085e+03,
		1.103561354180268e+03,		1.103903847538975e+03,		1.104245682853782e+03,		1.104586862968166e+03,		1.104927390706670e+03,
		1.105267268875077e+03,		1.105606500260583e+03,		1.105945087631954e+03,		1.106283033739697e+03,		1.106620341316218e+03,
		1.106957013075991e+03,		1.107293051715704e+03,		1.107628459914430e+03,		1.107963240333773e+03,		1.108297395618025e+03,
		1.108630928394320e+03,		1.108963841272778e+03,		1.109296136846663e+03,		1.109627817692520e+03,		1.109958886370329e+03,
		1.110289345423645e+03,		1.110619197379737e+03,		1.110948444749737e+03,		1.111277090028771e+03,		1.111605135696100e+03,
		1.111932584215260e+03,		1.112259438034188e+03,		1.112585699585365e+03,		1.112911371285938e+03,		1.113236455537859e+03,
		1.113560954728010e+03,		1.113884871228330e+03,		1.114208207395944e+03,		1.114530965573284e+03,		1.114853148088216e+03,
		1.115174757254162e+03,		1.115495795370218e+03,		1.115816264721279e+03,		1.116136167578151e+03,		1.116455506197673e+03,
		1.116774282822832e+03,		1.117092499682878e+03,		1.117410158993432e+03,		1.117727262956611e+03,		1.118043813761125e+03,
		1.118359813582397e+03,		1.118675264582668e+03,		1.118990168911102e+03,		1.119304528703901e+03,		1.119618346084402e+03
	},
	{
		1.741609964287036e+00,		5.277614099337552e+00,		8.882007158900745e+00,		1.255817944720392e+01,		1.630979727710459e+01,
		2.014083427406828e+01,		2.405560731840339e+01,		2.805881798799427e+01,		3.215560055890080e+01,		3.635157786891185e+01,
		4.065292666605595e+01,		4.506645447285479e+01,		4.959969052902400e+01,		5.426099407399331e+01,		5.905968415758216e+01,
		6.400619641040190e+01,		6.911227389253015e+01,		7.439120145716291e+01,		7.985809629538295e+01,		8.553027189473086e+01,
		9.142769920781124e+01,		9.757359843175303e+01,		1.039952091352072e+02,		1.107248083436227e+02,		1.178010804013462e+02,
		1.252709974292202e+02,		1.331924604566052e+02,		1.416381083030533e+02,		1.507009829253821e+02,		1.605032706948003e+02,
		1.712103998431748e+02,		1.830550518029208e+02,		1.963809910879294e+02,		2.117307051638317e+02,		2.300442091470476e+02,
		2.532036529108132e+02,		2.860949932692825e+02,		3.539993165091785e+02,		5.911245642309501e+02,		6.341537324072497e+02,
		6.580310965528599e+02,		6.751218155370325e+02,		6.886267150366555e+02,		6.998900510813822e+02,		7.096101843729488e+02,
		7.181980986336007e+02,		7.259167080327079e+02,		7.329446891295300e+02,		7.394092092896461e+02,		7.454041471096206e+02,
		7.510008987728737e+02,		7.562551188523894e+02,		7.612111025889614e+02,		7.659047352462491e+02,		7.703655365430143e+02,
		7.746181144437816e+02,		7.786832222868785e+02,		7.825785427894634e+02,		7.863192797964733e+02,		7.899186120060441e+02,
		7.933880458367951e+02,		7.967376934057817e+02,		7.999764940841815e+02,		8.031123929750839e+02,		8.061524860980747e+02,
		8.091031395525993e+02,		8.119700881320645e+02,		8.147585175537771e+02,		8.174731335091724e+02,		8.201182200242438e+02,
		8.226976890828878e+02,		8.252151230580214e+02,		8.276738111823993e+02,		8.300767810492408e+02,		8.324268259439318e+02,
		8.347265286597345e+02,		8.369782823328798e+02,		8.391843087386302e+02,		8.413466744146253e+02,		8.434673049169919e+02,
		8.455479974652094e+02,		8.475904321913158e+02,		8.495961821757891e+02,		8.515667224249978e+02,		8.535034379223488e+02,
		8.554076308661882e+02,		8.572805271916941e+02,		8.591232824605308e+02,		8.609369871907882e+02,		8.627226716900874e+02,
		8.644813104466896e+02,		8.662138261263485e+02,		8.679210932168069e+02,		8.696039413566608e+02,		8.712631583809231e+02,
		8.728994931117745e+02,		8.745136579197435e+02,		8.761063310776193e+02,		8.776781589269467e+02,		8.792297578747556e+02,
		8.807617162362446e+02,		8.822745959374785e+02,		8.837689340906849e+02,		8.852452444534282e+02,		8.867040187817710e+02,
		8.881457280865624e+02,		8.895708238010371e+02,		8.909797388671485e+02,		8.923728887473280e+02,		8.937506723677380e+02,
		8.951134729984847e+02,		8.964616590758305e+02,		8.977955849708756e+02,		8.991155917088867e+02,		9.004220076429887e+02,
		9.017151490856885e+02,		9.029953209013230e+02,		9.042628170623340e+02,		9.055179211719525e+02,		9.067609069557352e+02,
		9.079920387241286e+02,		9.092115718081029e+02,		9.104197529697053e+02,		9.116168207892626e+02,		9.128030060307933e+02,
		9.139785319870986e+02,		9.151436148058702e+02,		9.162984637980610e+02,		9.174432817296504e+02,		9.185782650978948e+02,
		9.197036043930159e+02,		9.208194843462614e+02,		9.219260841651665e+02,		9.230235777568206e+02,		9.241121339398484e+02,
		9.251919166457986e+02,		9.262630851105683e+02,		9.273257940564383e+02,		9.283801938652912e+02,		9.294264307434987e+02,
		9.304646468789728e+02,		9.314949805908177e+02,		9.325175664719904e+02,		9.335325355253801e+02,		9.345400152936552e+02,
		9.355401299832139e+02,		9.365330005825703e+02,		9.375187449754737e+02,		9.384974780490264e+02,		9.394693117970878e+02,
		9.404343554191835e+02,		9.413927154151803e+02,		9.423444956759274e+02,		9.432897975700627e+02,		9.442287200272057e+02,
		9.451613596176866e+02,		9.460878106290044e+02,		9.470081651391654e+02,		9.479225130870609e+02,		9.488309423400183e+02,
		9.497335387586719e+02,		9.506303862592745e+02,		9.515215668735694e+02,		9.524071608063480e+02,		9.532872464907863e+02,
		9.541619006416697e+02,		9.550311983066075e+02,		9.558952129153182e+02,		9.567540163270822e+02,		9.576076788764381e+02,
		9.584562694172002e+02,		9.592998553648785e+02,		9.601385027375607e+02,		9.609722761953271e+02,		9.618012390782743e+02,
		9.626254534431783e+02,		9.634449800988826e+02,		9.642598786404573e+02,		9.650702074821692e+02,		9.658760238893260e+02,
		9.666773840090347e+02,		9.674743428999242e+02,		9.682669545608618e+02,		9.690552719587217e+02,		9.698393470552280e+02,
		9.706192308329171e+02,		9.713949733202548e+02,		9.721666236159396e+02,		9.729342299124202e+02,		9.736978395186612e+02,
		9.744574988821930e+02,		9.752132536104530e+02,		9.759651484914774e+02,		9.767132275139271e+02,		9.774575338865114e+02,
		9.781981100568070e+02,		9.789349977295061e+02,		9.796682378841076e+02,		9.803978707920825e+02,		9.811239360335150e+02,
		9.818464725132595e+02,		9.825655184766157e+02,		9.832811115245366e+02,		9.839932886284093e+02,		9.847020861443903e+02,
		9.854075398273362e+02,		9.861096848443353e+02,		9.868085557878525e+02,		9.875041866885001e+02,		9.881966110274554e+02,
		9.888858617485241e+02,		9.895719712698761e+02,		9.902549714954472e+02,		9.909348938260406e+02,		9.916117691701123e+02,
		9.922856279542726e+02,		9.929565001335034e+02,		9.936244152010931e+02,		9.942894021983234e+02,		9.949514897238768e+02,
		9.956107059430165e+02,		9.962670785965134e+02,		9.969206350093471e+02,		9.975714020991732e+02,		9.982194063845834e+02,
		9.988646739931420e+02,		9.995072306692265e+02,		1.000147101781668e+03,		1.000784312331192e+03,		1.001418886957679e+03,
		1.002050849947247e+03,		1.002680225239146e+03,		1.003307036432496e+03,		1.003931306792850e+03,		1.004553059258604e+03,
		1.005172316447242e+03,		1.005789100661438e+03,		1.006403433895012e+03,		1.007015337838734e+03,		1.007624833886000e+03,
		1.008231943138370e+03,		1.008836686410970e+03,		1.009439084237781e+03,		1.010039156876789e+03,		1.010636924315025e+03,
		1.011232406273488e+03,		1.011825622211948e+03,		1.012416591333652e+03,		1.013005332589910e+03,		1.013591864684580e+03,
		1.014176206078463e+03,		1.014758374993582e+03,		1.015338389417379e+03,		1.015916267106815e+03,		1.016492025592372e+03,
		1.017065682181984e+03,		1.017637253964860e+03,		1.018206757815245e+03,		1.018774210396080e+03,		1.019339628162604e+03,
		1.019903027365855e+03,		1.020464424056115e+03,		1.021023834086276e+03,		1.021581273115128e+03,		1.022136756610588e+03,
		1.022690299852855e+03,		1.023241917937497e+03,		1.023791625778484e+03,		1.024339438111141e+03,		1.024885369495064e+03,
		1.025429434316948e+03,		1.025971646793381e+03,		1.026512020973569e+03,		1.027050570742007e+03,		1.027587309821102e+03,
		1.028122251773730e+03,		1.028655410005761e+03,		1.029186797768515e+03,		1.029716428161184e+03,		1.030244314133194e+03,
		1.030770468486530e+03,		1.031294903878010e+03,		1.031817632821518e+03,		1.032338667690190e+03,		1.032858020718560e+03,
		1.033375704004666e+03,		1.033891729512111e+03,		1.034406109072091e+03,		1.034918854385378e+03,		1.035429977024269e+03,
		1.035939488434500e+03,		1.036447399937115e+03,		1.036953722730316e+03,		1.037458467891262e+03,		1.037961646377842e+03,
		1.038463269030420e+03,		1.038963346573534e+03,		1.039461889617584e+03,		1.039958908660466e+03,		1.040454414089195e+03,
		1.040948416181488e+03,		1.041440925107326e+03,		1.041931950930477e+03,		1.042421503610006e+03,		1.042909593001742e+03,
		1.043396228859736e+03,		1.043881420837677e+03,		1.044365178490294e+03,		1.044847511274731e+03,		1.045328428551891e+03,
		1.045807939587768e+03,		1.046286053554750e+03,		1.046762779532891e+03,		1.047238126511182e+03,		1.047712103388776e+03,
		1.048184718976210e+03,		1.048655981996598e+03,		1.049125901086806e+03,		1.049594484798605e+03,		1.050061741599803e+03,
		1.050527679875372e+03,		1.050992307928530e+03,		1.051455633981831e+03,		1.051917666178218e+03,		1.052378412582075e+03,
		1.052837881180243e+03,		1.053296079883035e+03,		1.053753016525228e+03,		1.054208698867036e+03,		1.054663134595074e+03,
		1.055116331323300e+03,		1.055568296593945e+03,		1.056019037878428e+03,		1.056468562578255e+03,		1.056916878025901e+03,
		1.057363991485690e+03,		1.057809910154641e+03,		1.058254641163318e+03,		1.058698191576660e+03,		1.059140568394797e+03,
		1.059581778553853e+03,		1.060021828926740e+03,		1.060460726323935e+03,		1.060898477494248e+03,		1.061335089125580e+03,
		1.061770567845661e+03,		1.062204920222789e+03,		1.062638152766545e+03,		1.063070271928504e+03,		1.063501284102938e+03,
		1.063931195627498e+03,		1.064360012783900e+03,		1.064787741798584e+03,		1.065214388843379e+03,		1.065639960036144e+03,
		1.066064461441415e+03,		1.066487899071025e+03,		1.066910278884726e+03,		1.067331606790803e+03,		1.067751888646667e+03,
		1.068171130259457e+03,		1.068589337386614e+03,		1.069006515736464e+03,		1.069422670968779e+03,		1.069837808695337e+03,
		1.070251934480473e+03,		1.070665053841621e+03,		1.071077172249847e+03,		1.071488295130378e+03,		1.071898427863121e+03,
		1.072307575783170e+03,		1.072715744181319e+03,		1.073122938304552e+03,		1.073529163356537e+03,		1.073934424498108e+03,
		1.074338726847742e+03,		1.074742075482029e+03,		1.075144475436135e+03,		1.075545931704260e+03,		1.075946449240084e+03,
		1.076346032957220e+03,		1.076744687729644e+03,		1.077142418392129e+03,		1.077539229740674e+03,		1.077935126532920e+03,
		1.078330113488570e+03,		1.078724195289793e+03,		1.079117376581627e+03,		1.079509661972384e+03,		1.079901056034033e+03,
		1.080291563302593e+03,		1.080681188278515e+03,		1.081069935427055e+03,		1.081457809178652e+03,		1.081844813929286e+03,
		1.082230954040849e+03,		1.082616233841500e+03,		1.083000657626012e+03,		1.083384229656126e+03,		1.083766954160892e+03,
		1.084148835337008e+03,		1.084529877349154e+03,		1.084910084330323e+03,		1.085289460382146e+03,		1.085668009575211e+03,
		1.086045735949388e+03,		1.086422643514134e+03,		1.086798736248804e+03,		1.087174018102961e+03,		1.087548492996672e+03,
		1.087922164820809e+03,		1.088295037437339e+03,		1.088667114679618e+03,		1.089038400352677e+03,		1.089408898233500e+03,
		1.089778612071309e+03,		1.090147545587837e+03,		1.090515702477602e+03,		1.090883086408169e+03,		1.091249701020427e+03,
		1.091615549928842e+03,		1.091980636721718e+03,		1.092344964961457e+03,		1.092708538184805e+03,		1.093071359903106e+03,
		1.093433433602548e+03,		1.093794762744403e+03,		1.094155350765274e+03,		1.094515201077325e+03,		1.094874317068520e+03,
		1.095232702102857e+03,		1.095590359520590e+03,		1.095947292638459e+03,		1.096303504749920e+03,		1.096658999125350e+03,
		1.097013779012285e+03,		1.097367847635617e+03,		1.097721208197820e+03,		1.098073863879157e+03,		1.098425817837882e+03,
		1.098777073210456e+03,		1.099127633111741e+03,		1.099477500635209e+03,		1.099826678853130e+03,		1.100175170816777e+03,
		1.100522979556620e+03,		1.100870108082510e+03,		1.101216559383874e+03,		1.101562336429901e+03,		1.101907442169730e+03,
		1.102251879532623e+03,		1.102595651428159e+03,		1.102938760746403e+03,		1.103281210358087e+03,		1.103623003114784e+03,
		1.103964141849078e+03,		1.104304629374740e+03,		1.104644468486889e+03,		1.104983661962169e+03,		1.105322212558903e+03,
		1.105660123017266e+03,		1.105997396059438e+03,		1.106334034389771e+03,		1.106670040694939e+03,		1.107005417644102e+03,
		1.107340167889051e+03,		1.107674294064371e+03,		1.108007798787582e+03,		1.108340684659295e+03,		1.108672954263355e+03,
		1.109004610166993e+03,		1.109335654920960e+03,		1.109666091059680e+03,		1.109995921101386e+03,		1.110325147548262e+03,
		1.110653772886576e+03,		1.110981799586824e+03,		1.111309230103860e+03,		1.111636066877030e+03,		1.111962312330307e+03,
		1.112287968872421e+03,		1.112613038896983e+03,		1.112937524782621e+03,		1.113261428893104e+03,		1.113584753577464e+03,
		1.113907501170124e+03,		1.114229673991017e+03,		1.114551274345712e+03,		1.114872304525530e+03,		1.115192766807666e+03,
		1.115512663455301e+03,		1.115831996717727e+03,		1.116150768830455e+03,		1.116468982015331e+03,		1.116786638480650e+03,
		1.117103740421266e+03,		1.117420290018703e+03,		1.117736289441264e+03,		1.118051740844142e+03,		1.118366646369519e+03
	},
	{
		1.738124549313245e+00,		5.266721329688465e+00,		8.863089200244710e+00,		1.253055883781372e+01,		1.627272950786946e+01,
		2.009349920434034e+01,		2.399709920408358e+01,		2.798813384676984e+01,		3.207162653206822e+01,		3.625307315533588e+01,
		4.053850449549942e+01,		4.493455944486042e+01,		4.944857145817815e+01,		5.408867123647008e+01,		5.886390950414369e+01,
		6.378440486399165e+01,		6.886152323512381e+01,		7.410809745757979e+01,		7.953869852681451e+01,		8.516997396767695e+01,
		9.102107463373908e+01,		9.711419960635499e+01,		1.034753012830502e+02,		1.101350115094354e+02,		1.171298786414144e+02,
		1.245040515390208e+02,		1.323116219493870e+02,		1.406199644633478e+02,		1.495146380649060e+02,		1.591068275648547e+02,
		1.695451089829181e+02,		1.810349958654476e+02,		1.938734875351213e+02,		2.085152172392143e+02,		2.257135096295419e+02,
		2.468713476991932e+02,		2.751553830266014e+02,		3.211373555867615e+02,		5.067244479737138e+02,		6.061164167415773e+02,
		6.390190553783478e+02,		6.601151218712373e+02,		6.759441750721426e+02,		6.887476595264839e+02,		6.995740580351984e+02,
		7.090012112098948e+02,		7.173822647717769e+02,		7.249491643089794e+02,		7.318626322091716e+02,		7.382387719794089e+02,
		7.441643045377017e+02,		7.497058071803855e+02,		7.549155802794113e+02,		7.598355174646478e+02,		7.644997422721889e+02,
		7.689364547258417e+02,		7.731692560258064e+02,		7.772181191189294e+02,		7.811001132566374e+02,		7.848299540279501e+02,
		7.884204272396466e+02,		7.918827200544642e+02,		7.952266828963338e+02,		7.984610389448197e+02,		8.015935534423220e+02,
		8.046311718219168e+02,		8.075801333807772e+02,		8.104460655801337e+02,		8.132340628537576e+02,		8.159487529216102e+02,
		8.185943529443891e+02,		8.211747173560185e+02,		8.236933788310771e+02,		8.261535835520991e+02,		8.285583217148566e+02,
		8.309103540326047e+02,		8.332122348604798e+02,		8.354663324503767e+02,		8.376748467579520e+02,		8.398398251521135e+02,
		8.419631763195550e+02,		8.440466826099248e+02,		8.460920110287001e+02,		8.481007230531418e+02,		8.500742834205012e+02,
		8.520140680158378e+02,		8.539213709686221e+02,		8.557974110520643e+02,		8.576433374661905e+02,		8.594602350748970e+02,
		8.612491291579697e+02,		8.630109897311736e+02,		8.647467354808759e+02,		8.664572373538512e+02,		8.681433218380126e+02,
		8.698057739655407e+02,		8.714453400661540e+02,		8.730627302951548e+02,		8.746586209579727e+02,		8.762336566506140e+02,
		8.777884522332573e+02,		8.793235946523463e+02,		8.808396446249631e+02,		8.823371381977746e+02,		8.838165881916078e+02,
		8.852784855415719e+02,		8.867233005416687e+02,		8.881514840019338e+02,		8.895634683254035e+02,		8.909596685114531e+02,
		8.923404830914914e+02,		8.937062950023876e+02,		8.950574724025582e+02,		8.963943694351540e+02,		8.977173269424125e+02,
		8.990266731348926e+02,		9.003227242189449e+02,		9.016057849855208e+02,		9.028761493631471e+02,		9.041341009376321e+02,
		9.053799134409126e+02,		9.066138512111701e+02,		9.078361696262582e+02,		9.090471155122598e+02,		9.102469275288678e+02,
		9.114358365331663e+02,		9.126140659232109e+02,		9.137818319628085e+02,		9.149393440886405e+02,		9.160868052009293e+02,
		9.172244119386680e+02,		9.183523549404016e+02,		9.194708190914408e+02,		9.205799837583862e+02,		9.216800230116944e+02,
		9.227711058370464e+02,		9.238533963361629e+02,		9.249270539177231e+02,		9.259922334789319e+02,		9.270490855783152e+02,
		9.280977566002362e+02,		9.291383889115825e+02,		9.301711210111197e+02,		9.311960876718638e+02,		9.322134200769067e+02,
		9.332232459490281e+02,		9.342256896744409e+02,		9.352208724209933e+02,		9.362089122511103e+02,		9.371899242297691e+02,
		9.381640205277616e+02,		9.391313105204866e+02,		9.400919008825146e+02,		9.410458956781273e+02,		9.419933964480493e+02,
		9.429345022925609e+02,		9.438693099511509e+02,		9.447979138789390e+02,		9.457204063199416e+02,		9.466368773774182e+02,
		9.475474150813809e+02,		9.484521054534378e+02,		9.493510325690725e+02,		9.502442786175008e+02,		9.511319239592059e+02,
		9.520140471812649e+02,		9.528907251505628e+02,		9.537620330650014e+02,		9.546280445027794e+02,		9.554888314698476e+02,
		9.563444644456044e+02,		9.571950124269163e+02,		9.580405429705456e+02,		9.588811222340398e+02,		9.597168150151606e+02,
		9.605476847899023e+02,		9.613737937491873e+02,		9.621952028342557e+02,		9.630119717708370e+02,		9.638241591021433e+02,
		9.646318222207234e+02,		9.654350173992399e+02,		9.662337998202064e+02,		9.670282236047269e+02,		9.678183418402764e+02,
		9.686042066075672e+02,		9.693858690065279e+02,		9.701633791814425e+02,		9.709367863452679e+02,		9.717061388031741e+02,
		9.724714839753299e+02,		9.732328684189735e+02,		9.739903378497722e+02,		9.747439371625302e+02,		9.754937104512444e+02,
		9.762397010285363e+02,		9.769819514444998e+02,		9.777205035049636e+02,		9.784553982892079e+02,		9.791866761671394e+02,
		9.799143768159614e+02,		9.806385392363464e+02,		9.813592017681290e+02,		9.820764021055353e+02,		9.827901773119808e+02,
		9.835005638344238e+02,		9.842075975173175e+02,		9.849113136161554e+02,		9.856117468106351e+02,		9.863089312174537e+02,
		9.870029004027294e+02,		9.876936873940972e+02,		9.883813246924494e+02,		9.890658442833610e+02,		9.897472776482066e+02,
		9.904256557749595e+02,		9.911010091687159e+02,		9.917733678619168e+02,		9.924427614243150e+02,		9.931092189726558e+02,
		9.937727691801213e+02,		9.944334402855109e+02,		9.950912601021895e+02,		9.957462560268008e+02,		9.963984550477504e+02,
		9.970478837534754e+02,		9.976945683405020e+02,		9.983385346212965e+02,		9.989798080319148e+02,		9.996184136394626e+02,
		1.000254376149369e+03,		1.000887719912472e+03,		1.001518468931942e+03,		1.002146646870016e+03,		1.002772277054587e+03,
		1.003395382485608e+03,		1.004015985841370e+03,		1.004634109484600e+03,		1.005249775468434e+03,		1.005863005542234e+03,
		1.006473821157267e+03,		1.007082243472265e+03,		1.007688293358830e+03,		1.008291991406736e+03,		1.008893357929086e+03,
		1.009492412967369e+03,		1.010089176296384e+03,		1.010683667429064e+03,		1.011275905621177e+03,		1.011865909875934e+03,
		1.012453698948481e+03,		1.013039291350296e+03,		1.013622705353483e+03,		1.014203958994979e+03,		1.014783070080656e+03,
		1.015360056189343e+03,		1.015934934676748e+03,		1.016507722679309e+03,		1.017078437117946e+03,		1.017647094701741e+03,
		1.018213711931542e+03,		1.018778305103470e+03,		1.019340890312380e+03,		1.019901483455224e+03,		1.020460100234353e+03,
		1.021016756160750e+03,		1.021571466557196e+03,		1.022124246561359e+03,		1.022675111128834e+03,		1.023224075036113e+03,
		1.023771152883490e+03,		1.024316359097910e+03,		1.024859707935764e+03,		1.025401213485617e+03,		1.025940889670894e+03,
		1.026478750252499e+03,		1.027014808831387e+03,		1.027549078851087e+03,		1.028081573600170e+03,		1.028612306214673e+03,
		1.029141289680466e+03,		1.029668536835588e+03,		1.030194060372519e+03,		1.030717872840425e+03,		1.031239986647342e+03,
		1.031760414062335e+03,		1.032279167217604e+03,		1.032796258110551e+03,		1.033311698605813e+03,		1.033825500437252e+03,
		1.034337675209905e+03,		1.034848234401902e+03,		1.035357189366348e+03,		1.035864551333167e+03,		1.036370331410911e+03,
		1.036874540588537e+03,		1.037377189737154e+03,		1.037878289611732e+03,		1.038377850852785e+03,		1.038875883988018e+03,
		1.039372399433947e+03,		1.039867407497492e+03,		1.040360918377540e+03,		1.040852942166470e+03,		1.041343488851670e+03,
		1.041832568317007e+03,		1.042320190344286e+03,		1.042806364614675e+03,		1.043291100710107e+03,		1.043774408114654e+03,
		1.044256296215888e+03,		1.044736774306200e+03,		1.045215851584116e+03,		1.045693537155575e+03,		1.046169840035190e+03,
		1.046644769147494e+03,		1.047118333328152e+03,		1.047590541325160e+03,		1.048061401800024e+03,		1.048530923328919e+03,
		1.048999114403822e+03,		1.049465983433635e+03,		1.049931538745281e+03,		1.050395788584790e+03,		1.050858741118358e+03,
		1.051320404433400e+03,		1.051780786539567e+03,		1.052239895369769e+03,		1.052697738781164e+03,		1.053154324556137e+03,
		1.053609660403264e+03,		1.054063753958260e+03,		1.054516612784909e+03,		1.054968244375982e+03,		1.055418656154135e+03,
		1.055867855472805e+03,		1.056315849617074e+03,		1.056762645804534e+03,		1.057208251186132e+03,		1.057652672847001e+03,
		1.058095917807282e+03,		1.058537993022924e+03,		1.058978905386486e+03,		1.059418661727914e+03,		1.059857268815312e+03,
		1.060294733355696e+03,		1.060731061995742e+03,		1.061166261322523e+03,		1.061600337864226e+03,		1.062033298090868e+03,
		1.062465148414994e+03,		1.062895895192373e+03,		1.063325544722669e+03,		1.063754103250118e+03,		1.064181576964185e+03,
		1.064607972000213e+03,		1.065033294440062e+03,		1.065457550312743e+03,		1.065880745595035e+03,		1.066302886212099e+03,
		1.066723978038080e+03,		1.067144026896700e+03,		1.067563038561845e+03,		1.067981018758139e+03,		1.068397973161517e+03,
		1.068813907399777e+03,		1.069228827053140e+03,		1.069642737654789e+03,		1.070055644691404e+03,		1.070467553603696e+03,
		1.070878469786920e+03,		1.071288398591394e+03,		1.071697345323003e+03,		1.072105315243698e+03,		1.072512313571987e+03,
		1.072918345483419e+03,		1.073323416111066e+03,		1.073727530545988e+03,		1.074130693837703e+03,		1.074532910994642e+03,
		1.074934186984604e+03,		1.075334526735196e+03,		1.075733935134276e+03,		1.076132417030390e+03,		1.076529977233191e+03,
		1.076926620513867e+03,		1.077322351605552e+03,		1.077717175203742e+03,		1.078111095966693e+03,		1.078504118515824e+03,
		1.078896247436111e+03,		1.079287487276473e+03,		1.079677842550155e+03,		1.080067317735107e+03,		1.080455917274358e+03,
		1.080843645576384e+03,		1.081230507015467e+03,		1.081616505932058e+03,		1.082001646633127e+03,		1.082385933392516e+03,
		1.082769370451279e+03,		1.083151962018024e+03,		1.083533712269248e+03,		1.083914625349667e+03,		1.084294705372547e+03,
		1.084673956420016e+03,		1.085052382543397e+03,		1.085429987763509e+03,		1.085806776070983e+03,		1.086182751426573e+03,
		1.086557917761445e+03,		1.086932278977487e+03,		1.087305838947603e+03,		1.087678601515996e+03,		1.088050570498461e+03,
		1.088421749682667e+03,		1.088792142828440e+03,		1.089161753668035e+03,		1.089530585906411e+03,		1.089898643221500e+03,
		1.090265929264475e+03,		1.090632447660011e+03,		1.090998202006545e+03,		1.091363195876535e+03,		1.091727432816707e+03,
		1.092090916348315e+03,		1.092453649967378e+03,		1.092815637144930e+03,		1.093176881327261e+03,		1.093537385936153e+03,
		1.093897154369116e+03,		1.094256189999623e+03,		1.094614496177335e+03,		1.094972076228331e+03,		1.095328933455333e+03,
		1.095685071137924e+03,		1.096040492532771e+03,		1.096395200873839e+03,		1.096749199372602e+03,		1.097102491218262e+03,
		1.097455079577948e+03,		1.097806967596929e+03,		1.098158158398817e+03,		1.098508655085763e+03,		1.098858460738663e+03,
		1.099207578417351e+03,		1.099556011160795e+03,		1.099903761987285e+03,		1.100250833894630e+03,		1.100597229860338e+03,
		1.100942952841808e+03,		1.101288005776509e+03,		1.101632391582165e+03,		1.101976113156930e+03,		1.102319173379568e+03,
		1.102661575109627e+03,		1.103003321187614e+03,		1.103344414435164e+03,		1.103684857655208e+03,		1.104024653632147e+03,
		1.104363805132008e+03,		1.104702314902616e+03,		1.105040185673750e+03,		1.105377420157305e+03,		1.105714021047452e+03,
		1.106049991020791e+03,		1.106385332736509e+03,		1.106720048836529e+03,		1.107054141945664e+03,		1.107387614671767e+03,
		1.107720469605878e+03,		1.108052709322371e+03,		1.108384336379096e+03,		1.108715353317524e+03,		1.109045762662891e+03,
		1.109375566924333e+03,		1.109704768595031e+03,		1.110033370152340e+03,		1.110361374057931e+03,		1.110688782757923e+03,
		1.111015598683013e+03,		1.111341824248613e+03,		1.111667461854974e+03,		1.111992513887318e+03,		1.112316982715962e+03,
		1.112640870696447e+03,		1.112964180169661e+03,		1.113286913461961e+03,		1.113609072885296e+03,		1.113930660737326e+03,
		1.114251679301543e+03,		1.114572130847388e+03,		1.114892017630369e+03,		1.115211341892172e+03,		1.115530105860781e+03,
		1.115848311750588e+03,		1.116165961762505e+03,		1.116483058084075e+03,		1.116799602889582e+03,		1.117115598340161e+03
	},
	{
		1.734653282303376e+00,		5.255875596526891e+00,		8.844258079956644e+00,		1.250307292877881e+01,		1.623585371883841e+01,
		2.004642442593204e+01,		2.393893264811674e+01,		2.791788779238878e+01,		3.198820515624900e+01,		3.615525704695776e+01,
		4.042493235123731e+01,		4.480370631414979e+01,		4.929872273296156e+01,		5.391789135468571e+01,		5.867000403315538e+01,
		6.356487422149210e+01,		6.861350574692894e+01,		7.382829867981233e+01,		7.922330267758454e+01,		8.481453177277933e+01,
		9.062035966203210e+01,		9.666202188755541e+01,		1.029642620686627e+02,		1.095561754639152e+02,		1.164723278328637e+02,
		1.237542663231027e+02,		1.314526016803563e+02,		1.396299453718163e+02,		1.483651655177655e+02,		1.577597507564056e+02,
		1.679476878211957e+02,		1.791114996160556e+02,		1.915097760238364e+02,		2.055278912529818e+02,		2.217805335870527e+02,
		2.413473852815290e+02,		2.664288237610133e+02,		3.028602042016365e+02,		3.796409220333756e+02,		5.640338307041775e+02,
		6.155755556707147e+02,		6.428434857398905e+02,		6.618539712897141e+02,		6.766318965896537e+02,		6.888179398096522e+02,
		6.992462815770891e+02,		7.084001245917782e+02,		7.165847891762223e+02,		7.240056687265466e+02,		7.308076727851221e+02,
		7.370969567797666e+02,		7.429536993450665e+02,		7.484400142288462e+02,		7.536050605971363e+02,		7.584884620919893e+02,
		7.631226638766883e+02,		7.675346000806572e+02,		7.717469003441165e+02,		7.757787804483000e+02,		7.796467115336751e+02,
		7.833649310291288e+02,		7.869458383842034e+02,		7.904003056024752e+02,		7.937379238313788e+02,		7.969672013130426e+02,
		8.000957238792329e+02,		8.031302862731226e+02,		8.060770005095962e+02,		8.089413859866656e+02,		8.117284449620113e+02,
		8.144427261940507e+02,		8.170883789362980e+02,		8.196691990114168e+02,		8.221886683379255e+02,		8.246499890098651e+02,
		8.270561128176099e+02,		8.294097669317662e+02,		8.317134763406486e+02,		8.339695835273729e+02,		8.361802657887987e+02,
		8.383475505310890e+02,		8.404733288219181e+02,		8.425593674346721e+02,		8.446073195833837e+02,		8.466187345169413e+02,
		8.485950661160932e+02,		8.505376806159559e+02,		8.524478635593231e+02,		8.543268260714310e+02,		8.561757105345562e+02,
		8.579955957303401e+02,		8.597875015089238e+02,		8.615523930363743e+02,		8.632911846654578e+02,		8.650047434692685e+02,
		8.666938924724046e+02,		8.683594136103419e+02,		8.700020504440015e+02,		8.716225106534740e+02,		8.732214683321306e+02,
		8.747995661000261e+02,		8.763574170534025e+02,		8.778956065653289e+02,		8.794146939509312e+02,		8.809152140092349e+02,
		8.823976784524320e+02,		8.838625772323107e+02,		8.853103797725684e+02,		8.867415361149492e+02,		8.881564779862890e+02,
		8.895556197929593e+02,		8.909393595485395e+02,		8.923080797400311e+02,		8.936621481374243e+02,		8.950019185510164e+02,
		8.963277315404549e+02,		8.976399150791738e+02,		8.989387851775278e+02,		9.002246464676792e+02,		9.014977927530055e+02,
		9.027585075245959e+02,		9.040070644471642e+02,		9.052437278165146e+02,		9.064687529905681e+02,		9.076823867957281e+02,
		9.088848679102754e+02,		9.100764272263353e+02,		9.112572881918308e+02,		9.124276671337509e+02,		9.135877735639192e+02,
		9.147378104684276e+02,		9.158779745817282e+02,		9.170084566463875e+02,		9.181294416593762e+02,		9.192411091057237e+02,
		9.203436331803167e+02,		9.214371829985520e+02,		9.225219227965174e+02,		9.235980121213030e+02,		9.246656060120533e+02,
		9.257248551722593e+02,		9.267759061338243e+02,		9.278189014133654e+02,		9.288539796611765e+02,		9.298812758032741e+02,
		9.309009211769181e+02,		9.319130436599354e+02,		9.329177677942228e+02,		9.339152149037084e+02,		9.349055032070935e+02,
		9.358887479256329e+02,		9.368650613862242e+02,		9.378345531200504e+02,		9.387973299569967e+02,		9.397534961160686e+02,
		9.407031532920072e+02,		9.416464007382914e+02,		9.425833353467184e+02,		9.435140517237156e+02,		9.444386422635561e+02,
		9.453571972186253e+02,		9.462698047668770e+02,		9.471765510766235e+02,		9.480775203687678e+02,		9.489727949766271e+02,
		9.498624554034259e+02,		9.507465803775922e+02,		9.516252469059544e+02,		9.524985303249186e+02,		9.533665043497405e+02,
		9.542292411219543e+02,		9.550868112550701e+02,		9.559392838785759e+02,		9.567867266803627e+02,		9.576292059476089e+02,
		9.584667866062083e+02,		9.592995322587929e+02,		9.601275052214198e+02,		9.609507665589775e+02,		9.617693761193517e+02,
		9.625833925664297e+02,		9.633928734119622e+02,		9.641978750463496e+02,		9.649984527683829e+02,		9.657946608140032e+02,
		9.665865523840858e+02,		9.673741796713213e+02,		9.681575938862021e+02,		9.689368452821853e+02,		9.697119831800128e+02,
		9.704830559912709e+02,		9.712501112411909e+02,		9.720131955907265e+02,		9.727723548579406e+02,		9.735276340387200e+02,
		9.742790773268432e+02,		9.750267281334401e+02,		9.757706291058413e+02,		9.765108221458684e+02,		9.772473484275521e+02,
		9.779802484143385e+02,		9.787095618757656e+02,		9.794353279036536e+02,		9.801575849278081e+02,		9.808763707312798e+02,
		9.815917224651607e+02,		9.823036766629615e+02,		9.830122692545840e+02,		9.837175355798691e+02,		9.844195104017876e+02,
		9.851182279192418e+02,		9.858137217795087e+02,		9.865060250903474e+02,		9.871951704317530e+02,		9.878811898674021e+02,
		9.885641149557738e+02,		9.892439767609771e+02,		9.899208058632731e+02,		9.905946323693283e+02,		9.912654859221755e+02,
		9.919333957109282e+02,		9.925983904802225e+02,		9.932604985394198e+02,		9.939197477715669e+02,		9.945761656421147e+02,
		9.952297792074254e+02,		9.958806151230489e+02,		9.965286996517908e+02,		9.971740586715778e+02,		9.978167176831195e+02,
		9.984567018173799e+02,		9.990940358428646e+02,		9.997287441727154e+02,		1.000360850871643e+03,		1.000990379662678e+03,
		1.001617353933768e+03,		1.002241796744192e+03,		1.002863730830850e+03,		1.003483178614374e+03,		1.004100162205104e+03,
		1.004714703408921e+03,		1.005326823732940e+03,		1.005936544391070e+03,		1.006543886309433e+03,		1.007148870131676e+03,
		1.007751516224141e+03,		1.008351844680925e+03,		1.008949875328817e+03,		1.009545627732126e+03,		1.010139121197401e+03,
		1.010730374778034e+03,		1.011319407278775e+03,		1.011906237260121e+03,		1.012490883042639e+03,		1.013073362711161e+03,
		1.013653694118904e+03,		1.014231894891500e+03,		1.014807982430925e+03,		1.015381973919352e+03,		1.015953886322921e+03,
		1.016523736395420e+03,		1.017091540681890e+03,		1.017657315522155e+03,		1.018221077054278e+03,		1.018782841217931e+03,
		1.019342623757711e+03,		1.019900440226373e+03,		1.020456305988005e+03,		1.021010236221126e+03,		1.021562245921729e+03,
		1.022112349906254e+03,		1.022660562814509e+03,		1.023206899112519e+03,		1.023751373095323e+03,		1.024293998889718e+03,
		1.024834790456941e+03,		1.025373761595300e+03,		1.025910925942747e+03,		1.026446296979411e+03,		1.026979888030070e+03,
		1.027511712266577e+03,		1.028041782710238e+03,		1.028570112234148e+03,		1.029096713565471e+03,		1.029621599287687e+03,
		1.030144781842789e+03,		1.030666273533435e+03,		1.031186086525067e+03,		1.031704232847982e+03,		1.032220724399365e+03,
		1.032735572945288e+03,		1.033248790122663e+03,		1.033760387441168e+03,		1.034270376285124e+03,		1.034778767915354e+03,
		1.035285573470987e+03,		1.035790803971248e+03,		1.036294470317202e+03,		1.036796583293471e+03,		1.037297153569916e+03,
		1.037796191703297e+03,		1.038293708138888e+03,		1.038789713212079e+03,		1.039284217149936e+03,		1.039777230072742e+03,
		1.040268761995502e+03,		1.040758822829432e+03,		1.041247422383411e+03,		1.041734570365411e+03,		1.042220276383905e+03,
		1.042704549949245e+03,		1.043187400475021e+03,		1.043668837279393e+03,		1.044148869586397e+03,		1.044627506527237e+03,
		1.045104757141548e+03,		1.045580630378634e+03,		1.046055135098698e+03,		1.046528280074037e+03,		1.047000073990223e+03,
		1.047470525447264e+03,		1.047939642960744e+03,		1.048407434962948e+03,		1.048873909803958e+03,		1.049339075752742e+03,
		1.049802940998220e+03,		1.050265513650312e+03,		1.050726801740966e+03,		1.051186813225178e+03,		1.051645555981986e+03,
		1.052103037815448e+03,		1.052559266455616e+03,		1.053014249559477e+03,		1.053467994711890e+03,		1.053920509426509e+03,
		1.054371801146681e+03,		1.054821877246337e+03,		1.055270745030875e+03,		1.055718411738009e+03,		1.056164884538629e+03,
		1.056610170537627e+03,		1.057054276774724e+03,		1.057497210225275e+03,		1.057938977801065e+03,		1.058379586351097e+03,
		1.058819042662358e+03,		1.059257353460579e+03,		1.059694525410986e+03,		1.060130565119030e+03,		1.060565479131120e+03,
		1.060999273935329e+03,		1.061431955962101e+03,		1.061863531584943e+03,		1.062294007121105e+03,		1.062723388832251e+03,
		1.063151682925124e+03,		1.063578895552191e+03,		1.064005032812292e+03,		1.064430100751264e+03,		1.064854105362570e+03,
		1.065277052587912e+03,		1.065698948317830e+03,		1.066119798392302e+03,		1.066539608601330e+03,		1.066958384685517e+03,
		1.067376132336638e+03,		1.067792857198200e+03,		1.068208564865996e+03,		1.068623260888650e+03,		1.069036950768154e+03,
		1.069449639960400e+03,		1.069861333875696e+03,		1.070272037879290e+03,		1.070681757291869e+03,		1.071090497390063e+03,
		1.071498263406936e+03,		1.071905060532474e+03,		1.072310893914064e+03,		1.072715768656965e+03,		1.073119689824777e+03,
		1.073522662439892e+03,		1.073924691483962e+03,		1.074325781898330e+03,		1.074725938584480e+03,		1.075125166404468e+03,
		1.075523470181353e+03,		1.075920854699617e+03,		1.076317324705583e+03,		1.076712884907825e+03,		1.077107539977576e+03,
		1.077501294549127e+03,		1.077894153220220e+03,		1.078286120552440e+03,		1.078677201071598e+03,		1.079067399268108e+03,
		1.079456719597366e+03,		1.079845166480113e+03,		1.080232744302804e+03,		1.080619457417964e+03,		1.081005310144543e+03,
		1.081390306768270e+03,		1.081774451541990e+03,		1.082157748686011e+03,		1.082540202388441e+03,		1.082921816805516e+03,
		1.083302596061927e+03,		1.083682544251149e+03,		1.084061665435754e+03,		1.084439963647731e+03,		1.084817442888791e+03,
		1.085194107130683e+03,		1.085569960315486e+03,		1.085945006355917e+03,		1.086319249135623e+03,		1.086692692509474e+03,
		1.087065340303848e+03,		1.087437196316917e+03,		1.087808264318931e+03,		1.088178548052490e+03,		1.088548051232821e+03,
		1.088916777548048e+03,		1.089284730659456e+03,		1.089651914201760e+03,		1.090018331783362e+03,		1.090383986986608e+03,
		1.090748883368042e+03,		1.091113024458661e+03,		1.091476413764157e+03,		1.091839054765166e+03,		1.092200950917505e+03,
		1.092562105652418e+03,		1.092922522376807e+03,		1.093282204473464e+03,		1.093641155301307e+03,		1.093999378195602e+03,
		1.094356876468190e+03,		1.094713653407711e+03,		1.095069712279819e+03,		1.095425056327402e+03,		1.095779688770798e+03,
		1.096133612808000e+03,		1.096486831614874e+03,		1.096839348345359e+03,		1.097191166131675e+03,		1.097542288084522e+03,
		1.097892717293283e+03,		1.098242456826219e+03,		1.098591509730663e+03,		1.098939879033216e+03,		1.099287567739934e+03,
		1.099634578836520e+03,		1.099980915288504e+03,		1.100326580041435e+03,		1.100671576021056e+03,		1.101015906133486e+03,
		1.101359573265399e+03,		1.101702580284198e+03,		1.102044930038189e+03,		1.102386625356756e+03,		1.102727669050522e+03,
		1.103068063911525e+03,		1.103407812713383e+03,		1.103746918211454e+03,		1.104085383143003e+03,		1.104423210227357e+03,
		1.104760402166069e+03,		1.105096961643071e+03,		1.105432891324831e+03,		1.105768193860508e+03,		1.106102871882097e+03,
		1.106436928004587e+03,		1.106770364826105e+03,		1.107103184928065e+03,		1.107435390875310e+03,		1.107766985216258e+03,
		1.108097970483044e+03,		1.108428349191657e+03,		1.108758123842087e+03,		1.109087296918451e+03,		1.109415870889138e+03,
		1.109743848206942e+03,		1.110071231309190e+03,		1.110398022617878e+03,		1.110724224539800e+03,		1.111049839466679e+03,
		1.111374869775289e+03,		1.111699317827587e+03,		1.112023185970833e+03,		1.112346476537715e+03,		1.112669191846474e+03,
		1.112991334201021e+03,		1.113312905891056e+03,		1.113633909192191e+03,		1.113954346366060e+03,		1.114274219660444e+03,
		1.114593531309375e+03,		1.114912283533258e+03,		1.115230478538981e+03,		1.115548118520021e+03,		1.115865205656562e+03
	},
	{
		1.731196075276978e+00,		5.245076576283076e+00,		8.825513142598476e+00,		1.247572061155283e+01,		1.619916819564686e+01,
		1.999960742616247e+01,		2.388110409653442e+01,		2.784807492235052e+01,		3.190532979096184e+01,		3.605812067021567e+01,
		4.031219849500266e+01,		4.467387966864374e+01,		4.915012422611634e+01,		5.374862823867384e+01,		5.847793373758660e+01,
		6.334756035909065e+01,		6.836816414944947e+01,		7.355173064288864e+01,		7.891181161848705e+01,		8.446381812629465e+01,
		9.022538685851647e+01,		9.621684336111934e+01,		1.024617949290708e+02,		1.089878999028305e+02,		1.158278811168659e+02,
		1.230208838974801e+02,		1.306143310388432e+02,		1.386665126353026e+02,		1.472502938598738e+02,		1.564585804816818e+02,
		1.664126571007589e+02,		1.772754420073628e+02,		1.892736417960882e+02,		2.027371777199463e+02,		2.181752550166257e+02,
		2.364399440643530e+02,		2.591364587768460e+02,		2.899276460224069e+02,		3.408441858954083e+02,		4.835799812732936e+02,
		5.847418345311986e+02,		6.223902857948124e+02,		6.459478520489030e+02,		6.633222247023114e+02,		6.772077114545357e+02,
		6.888450810820011e+02,		6.989089450893017e+02,		7.078071285733560e+02,		7.158050920112997e+02,		7.230853616825514e+02,
		7.297788867286616e+02,		7.359828676933662e+02,		7.417715016496270e+02,		7.472027690062291e+02,		7.523228890796153e+02,
		7.571693418922563e+02,		7.617729754270075e+02,		7.661595110687966e+02,		7.703506421821065e+02,		7.743648510254694e+02,
		7.782180265369277e+02,		7.819239386697151e+02,		7.854946076233888e+02,		7.889405948730334e+02,		7.922712351915926e+02,
		7.954948235727537e+02,		7.986187672737218e+02,		8.016497105851179e+02,		8.045936380592203e+02,		8.074559605627639e+02,
		8.102415875153058e+02,		8.129549879255260e+02,		8.156002422745804e+02,		8.181810868673442e+02,		8.207009519440555e+02,
		8.231629945907156e+02,		8.255701272884158e+02,		8.279250427858497e+02,		8.302302358559205e+02,		8.324880223988665e+02,
		8.347005562753571e+02,		8.368698441891707e+02,		8.389977588872323e+02,		8.410860509023814e+02,		8.431363590294699e+02,
		8.451502196966173e+02,		8.471290753696178e+02,		8.490742821076108e+02,		8.509871163714861e+02,		8.528687811724892e+02,
		8.547204116367253e+02,		8.565430800511836e+02,		8.583378004484472e+02,		8.601055327799884e+02,		8.618471867216983e+02,
		8.635636251499717e+02,		8.652556673220852e+02,		8.669240917906108e+02,		8.685696390781317e+02,		8.701930141356129e+02,
		8.717948886050752e+02,		8.733759029049991e+02,		8.749366681548889e+02,		8.764777679536340e+02,		8.779997600248364e+02,
		8.795031777408249e+02,		8.809885315359661e+02,		8.824563102187640e+02,		8.839069821913259e+02,		8.853409965839161e+02,
		8.867587843116097e+02,		8.881607590593572e+02,		8.895473182012031e+02,		8.909188436588689e+02,		8.922757027044314e+02,
		8.936182487114031e+02,		8.949468218581459e+02,		8.962617497871927e+02,		8.975633482237590e+02,		8.988519215564291e+02,
		9.001277633827558e+02,		9.013911570222957e+02,		9.026423759993795e+02,		9.038816844977241e+02,		9.051093377888493e+02,
		9.063255826360731e+02,		9.075306576757596e+02,		9.087247937773149e+02,		9.099082143833460e+02,		9.110811358312953e+02,
		9.122437676577223e+02,		9.133963128863619e+02,		9.145389683009876e+02,		9.156719247040197e+02,		9.167953671617786e+02,
		9.179094752371896e+02,		9.190144232107145e+02,		9.201103802902111e+02,		9.211975108103826e+02,		9.222759744224335e+02,
		9.233459262745026e+02,		9.244075171834088e+02,		9.254608937982055e+02,		9.265061987560127e+02,		9.275435708305509e+02,
		9.285731450738156e+02,		9.295950529512106e+02,		9.306094224705762e+02,		9.316163783053721e+02,		9.326160419123768e+02,
		9.336085316441782e+02,		9.345939628567202e+02,		9.355724480121947e+02,		9.365440967774838e+02,		9.375090161184108e+02,
		9.384673103899950e+02,		9.394190814229303e+02,		9.403644286064483e+02,		9.413034489677880e+02,		9.422362372483933e+02,
		9.431628859770307e+02,		9.440834855399769e+02,		9.449981242483856e+02,		9.459068884030011e+02,		9.468098623563444e+02,
		9.477071285724548e+02,		9.485987676843472e+02,		9.494848585492593e+02,		9.503654783018006e+02,		9.512407024050972e+02,
		9.521106047000317e+02,		9.529752574526460e+02,		9.538347313998046e+02,		9.546890957931870e+02,		9.555384184416897e+02,
		9.563827657522941e+02,		9.572222027694827e+02,		9.580567932132531e+02,		9.588865995157951e+02,		9.597116828568903e+02,
		9.605321031980793e+02,		9.613479193156562e+02,		9.621591888325351e+02,		9.629659682490316e+02,		9.637683129726162e+02,
		9.645662773466584e+02,		9.653599146782335e+02,		9.661492772649983e+02,		9.669344164211910e+02,		9.677153825027891e+02,
		9.684922249318475e+02,		9.692649922200649e+02,		9.700337319915883e+02,		9.707984910051035e+02,		9.715593151752296e+02,
		9.723162495932468e+02,		9.730693385471704e+02,		9.738186255412259e+02,		9.745641533147066e+02,		9.753059638602738e+02,
		9.760440984416922e+02,		9.767785976110443e+02,		9.775095012254143e+02,		9.782368484630995e+02,		9.789606778393235e+02,
		9.796810272215004e+02,		9.803979338440519e+02,		9.811114343227972e+02,		9.818215646689288e+02,		9.825283603025827e+02,
		9.832318560660393e+02,		9.839320862365317e+02,		9.846290845387105e+02,		9.853228841567548e+02,		9.860135177461431e+02,
		9.867010174451098e+02,		9.873854148857816e+02,		9.880667412050097e+02,		9.887450270549125e+02,		9.894203026131294e+02,
		9.900925975928099e+02,		9.907619412523231e+02,		9.914283624047229e+02,		9.920918894269545e+02,		9.927525502688302e+02,
		9.934103724617598e+02,		9.940653831272648e+02,		9.947176089852694e+02,		9.953670763621777e+02,		9.960138111987497e+02,
		9.966578390577782e+02,		9.972991851315635e+02,		9.979378742492121e+02,		9.985739308837490e+02,		9.992073791590527e+02,
		9.998382428566193e+02,		1.000466545422166e+03,		1.001092309972064e+03,		1.001715559299627e+03,		1.002336315881238e+03,
		1.002954601882330e+03,		1.003570439163237e+03,		1.004183849284885e+03,		1.004794853514369e+03,		1.005403472830376e+03,
		1.006009727928509e+03,		1.006613639226464e+03,		1.007215226869097e+03,		1.007814510733370e+03,		1.008411510433193e+03,
		1.009006245324143e+03,		1.009598734508080e+03,		1.010188996837664e+03,		1.010777050920767e+03,		1.011362915124784e+03,
		1.011946607580846e+03,		1.012528146187952e+03,		1.013107548616988e+03,		1.013684832314688e+03,		1.014260014507475e+03,
		1.014833112205243e+03,		1.015404142205050e+03,		1.015973121094724e+03,		1.016540065256400e+03,		1.017104990869982e+03,
		1.017667913916527e+03,		1.018228850181559e+03,		1.018787815258309e+03,		1.019344824550899e+03,		1.019899893277444e+03,
		1.020453036473105e+03,		1.021004268993062e+03,		1.021553605515442e+03,		1.022101060544176e+03,		1.022646648411805e+03,
		1.023190383282220e+03,		1.023732279153355e+03,		1.024272349859823e+03,		1.024810609075498e+03,		1.025347070316045e+03,
		1.025881746941402e+03,		1.026414652158209e+03,		1.026945799022198e+03,		1.027475200440521e+03,		1.028002869174045e+03,
		1.028528817839604e+03,		1.029053058912188e+03,		1.029575604727120e+03,		1.030096467482160e+03,		1.030615659239589e+03,
		1.031133191928254e+03,		1.031649077345553e+03,		1.032163327159410e+03,		1.032675952910192e+03,		1.033186966012602e+03,
		1.033696377757529e+03,		1.034204199313869e+03,		1.034710441730309e+03,		1.035215115937080e+03,		1.035718232747675e+03,
		1.036219802860537e+03,		1.036719836860723e+03,		1.037218345221519e+03,		1.037715338306049e+03,		1.038210826368838e+03,
		1.038704819557355e+03,		1.039197327913526e+03,		1.039688361375215e+03,		1.040177929777694e+03,		1.040666042855067e+03,
		1.041152710241684e+03,		1.041637941473522e+03,		1.042121745989545e+03,		1.042604133133042e+03,		1.043085112152936e+03,
		1.043564692205077e+03,		1.044042882353506e+03,		1.044519691571707e+03,		1.044995128743823e+03,		1.045469202665866e+03,
		1.045941922046898e+03,		1.046413295510193e+03,		1.046883331594380e+03,		1.047352038754573e+03,		1.047819425363466e+03,
		1.048285499712429e+03,		1.048750270012573e+03,		1.049213744395799e+03,		1.049675930915835e+03,		1.050136837549252e+03,
		1.050596472196465e+03,		1.051054842682711e+03,		1.051511956759021e+03,		1.051967822103174e+03,		1.052422446320630e+03,
		1.052875836945449e+03,		1.053328001441204e+03,		1.053778947201868e+03,		1.054228681552692e+03,		1.054677211751072e+03,
		1.055124544987394e+03,		1.055570688385878e+03,		1.056015649005393e+03,		1.056459433840273e+03,		1.056902049821113e+03,
		1.057343503815557e+03,		1.057783802629066e+03,		1.058222953005682e+03,		1.058660961628779e+03,		1.059097835121799e+03,
		1.059533580048981e+03,		1.059968202916071e+03,		1.060401710171031e+03,		1.060834108204732e+03,		1.061265403351640e+03,
		1.061695601890483e+03,		1.062124710044917e+03,		1.062552733984181e+03,		1.062979679823738e+03,		1.063405553625909e+03,
		1.063830361400496e+03,		1.064254109105397e+03,		1.064676802647216e+03,		1.065098447881855e+03,		1.065519050615104e+03,
		1.065938616603222e+03,		1.066357151553504e+03,		1.066774661124848e+03,		1.067191150928309e+03,		1.067606626527643e+03,
		1.068021093439849e+03,		1.068434557135696e+03,		1.068847023040254e+03,		1.069258496533399e+03,		1.069668982950333e+03,
		1.070078487582074e+03,		1.070487015675962e+03,		1.070894572436137e+03,		1.071301163024024e+03,		1.071706792558804e+03,
		1.072111466117886e+03,		1.072515188737364e+03,		1.072917965412467e+03,		1.073319801098016e+03,		1.073720700708860e+03,
		1.074120669120314e+03,		1.074519711168584e+03,		1.074917831651195e+03,		1.075315035327412e+03,		1.075711326918643e+03,
		1.076106711108855e+03,		1.076501192544969e+03,		1.076894775837259e+03,		1.077287465559741e+03,		1.077679266250557e+03,
		1.078070182412359e+03,		1.078460218512679e+03,		1.078849378984304e+03,		1.079237668225636e+03,		1.079625090601056e+03,
		1.080011650441278e+03,		1.080397352043697e+03,		1.080782199672743e+03,		1.081166197560212e+03,		1.081549349905614e+03,
		1.081931660876498e+03,		1.082313134608781e+03,		1.082693775207076e+03,		1.083073586745013e+03,		1.083452573265546e+03,
		1.083830738781277e+03,		1.084208087274751e+03,		1.084584622698774e+03,		1.084960348976700e+03,		1.085335270002735e+03,
		1.085709389642226e+03,		1.086082711731953e+03,		1.086455240080412e+03,		1.086826978468094e+03,		1.087197930647768e+03,
		1.087568100344752e+03,		1.087937491257187e+03,		1.088306107056302e+03,		1.088673951386678e+03,		1.089041027866513e+03,
		1.089407340087876e+03,		1.089772891616963e+03,		1.090137685994350e+03,		1.090501726735238e+03,		1.090865017329705e+03,
		1.091227561242939e+03,		1.091589361915487e+03,		1.091950422763485e+03,		1.092310747178896e+03,		1.092670338529737e+03,
		1.093029200160310e+03,		1.093387335391430e+03,		1.093744747520638e+03,		1.094101439822435e+03,		1.094457415548487e+03,
		1.094812677927844e+03,		1.095167230167159e+03,		1.095521075450886e+03,		1.095874216941496e+03,		1.096226657779680e+03,
		1.096578401084549e+03,		1.096929449953838e+03,		1.097279807464098e+03,		1.097629476670898e+03,		1.097978460609015e+03,
		1.098326762292625e+03,		1.098674384715491e+03,		1.099021330851152e+03,		1.099367603653105e+03,		1.099713206054989e+03,
		1.100058140970764e+03,		1.100402411294890e+03,		1.100746019902502e+03,		1.101088969649586e+03,		1.101431263373151e+03,
		1.101772903891396e+03,		1.102113894003881e+03,		1.102454236491693e+03,		1.102793934117613e+03,		1.103132989626273e+03,
		1.103471405744320e+03,		1.103809185180577e+03,		1.104146330626197e+03,		1.104482844754820e+03,		1.104818730222728e+03,
		1.105153989668992e+03,		1.105488625715630e+03,		1.105822640967750e+03,		1.106156038013700e+03,		1.106488819425211e+03,
		1.106820987757545e+03,		1.107152545549632e+03,		1.107483495324217e+03,		1.107813839587993e+03,		1.108143580831741e+03,
		1.108472721530472e+03,		1.108801264143552e+03,		1.109129211114842e+03,		1.109456564872828e+03,		1.109783327830753e+03,
		1.110109502386742e+03,		1.110435090923934e+03,		1.110760095810608e+03,		1.111084519400305e+03,		1.111408364031955e+03,
		1.111731632029998e+03,		1.112054325704504e+03,		1.112376447351297e+03,		1.112697999252065e+03,		1.113018983674490e+03,
		1.113339402872353e+03,		1.113659259085652e+03,		1.113978554540721e+03,		1.114297291450334e+03,		1.114615472013823e+03
	},
	{
		1.727752841004466e+00,		5.234323948568894e+00,		8.806853739974414e+00,		1.244850079114007e+01,		1.616267124687471e+01,
		1.995304572891025e+01,		2.382361005130649e+01,		2.777869041733443e+01,		3.182299391687629e+01,		3.596165532532962e+01,
		4.020029143501937e+01,		4.454506444305286e+01,		4.900275629554906e+01,		5.358085637483227e+01,		5.828766555172073e+01,
		6.313242046295991e+01,		6.812544298995573e+01,		7.327832141805193e+01,		7.860413180398517e+01,		8.411771090669393e+01,
		8.983599599439748e+01,		9.577845246514141e+01,		1.019676183441485e+02,		1.084298066780478e+02,		1.151960247966545e+02,
		1.223031969714153e+02,		1.297958203796562e+02,		1.377282545198237e+02,		1.461679616400790e+02,		1.552002193755116e+02,
		1.649351953035584e+02,		1.755189742213674e+02,		1.871515446994610e+02,		2.001178248681612e+02,		2.148451060093185e+02,
		2.320197283644981e+02,		2.528560287190034e+02,		2.798409591289320e+02,		3.194810646723878e+02,		3.986720633077883e+02,
		5.399696391778905e+02,		5.972530691527103e+02,		6.276362005288113e+02,		6.485242827010960e+02,		6.645733687104563e+02,
		6.776895954821681e+02,		6.888354349954371e+02,		6.985640354240971e+02,		7.072224477614598e+02,		7.150426748161127e+02,
		7.221874671024565e+02,		7.287754195178738e+02,		7.348956619230787e+02,		7.406169200076150e+02,		7.459933468799916e+02,
		7.510684116474830e+02,		7.558775714577780e+02,		7.604501557390031e+02,		7.648107252708547e+02,		7.689800722088327e+02,
		7.729759691101680e+02,		7.768137389841023e+02,		7.805066954329111e+02,		7.840664869698448e+02,		7.875033696143990e+02,
		7.908264250802669e+02,		7.940437371797128e+02,		7.971625357727459e+02,		8.001893152402960e+02,		8.031299327637204e+02,
		8.059896904516970e+02,		8.087734044370658e+02,		8.114854633791577e+02,		8.141298782880325e+02,		8.167103251910504e+02,
		8.192301818573914e+02,		8.216925595596368e+02,		8.241003306663800e+02,		8.264561527139758e+02,		8.287624894897108e+02,
		8.310216295660681e+02,		8.332357026512891e+02,		8.354066940611829e+02,		8.375364575679986e+02,		8.396267268420564e+02,
		8.416791256687600e+02,		8.436951770962715e+02,		8.456763116464233e+02,		8.476238747024560e+02,		8.495391331713248e+02,
		8.514232815048805e+02,		8.532774471529509e+02,		8.551026955117590e+02,		8.569000344229269e+02,		8.586704182713606e+02,
		8.604147517242945e+02,		8.621338931486860e+02,		8.638286577396340e+02,		8.654998203887669e+02,		8.671481183181062e+02,
		8.687742535020942e+02,		8.703788948979253e+02,		8.719626805021115e+02,		8.735262192492810e+02,		8.750700927675164e+02,
		8.765948570030583e+02,		8.781010437258388e+02,		8.795891619262098e+02,		8.810596991121298e+02,		8.825131225152259e+02,
		8.839498802132726e+02,		8.853704021759654e+02,		8.867751012401600e+02,		8.881643740202211e+02,		8.895386017585909e+02,
		8.908981511212037e+02,		8.922433749419981e+02,		8.935746129203707e+02,		8.948921922750950e+02,		8.961964283579234e+02,
		8.974876252298163e+02,		8.987660762024899e+02,		9.000320643477623e+02,		9.012858629769605e+02,		9.025277360924778e+02,
		9.037579388133975e+02,		9.049767177769509e+02,		9.061843115174295e+02,		9.073809508240699e+02,		9.085668590792724e+02,
		9.097422525784609e+02,		9.109073408327457e+02,		9.120623268554989e+02,		9.132074074338578e+02,		9.143427733860922e+02,
		9.154686098057198e+02,		9.165850962931643e+02,		9.176924071757284e+02,		9.187907117165823e+02,		9.198801743133974e+02,
		9.209609546872747e+02,		9.220332080624928e+02,		9.230970853376351e+02,		9.241527332485648e+02,		9.252002945237443e+02,
		9.262399080322799e+02,		9.272717089251479e+02,		9.282958287699416e+02,		9.293123956795001e+02,		9.303215344347678e+02,
		9.313233666021703e+02,		9.323180106458160e+02,		9.333055820347849e+02,		9.342861933457629e+02,		9.352599543612724e+02,
		9.362269721637124e+02,		9.371873512254290e+02,		9.381411934950138e+02,		9.390885984800190e+02,		9.400296633262719e+02,
		9.409644828939480e+02,		9.418931498305650e+02,		9.428157546410555e+02,		9.437323857550357e+02,		9.446431295914319e+02,
		9.455480706205689e+02,		9.464472914238492e+02,		9.473408727511326e+02,		9.482288935759206e+02,		9.491114311484524e+02,
		9.499885610467931e+02,		9.508603572260284e+02,		9.517268920656276e+02,		9.525882364150634e+02,		9.534444596377833e+02,
		9.542956296535614e+02,		9.551418129793582e+02,		9.559830747687038e+02,		9.568194788496926e+02,		9.576510877616458e+02,
		9.584779627904909e+02,		9.593001640029185e+02,		9.601177502793656e+02,		9.609307793458694e+02,		9.617393078048469e+02,
		9.625433911648363e+02,		9.633430838692458e+02,		9.641384393241457e+02,		9.649295099251534e+02,		9.657163470834222e+02,
		9.664990012508107e+02,		9.672775219442160e+02,		9.680519577691398e+02,		9.688223564425036e+02,		9.695887648147408e+02,
		9.703512288911929e+02,		9.711097938528400e+02,		9.718645040763927e+02,		9.726154031537613e+02,		9.733625339109259e+02,
		9.741059384262412e+02,		9.748456580481840e+02,		9.755817334125686e+02,		9.763142044592481e+02,		9.770431104483225e+02,
		9.777684899758735e+02,		9.784903809892299e+02,		9.792088208017918e+02,		9.799238461074380e+02,		9.806354929945027e+02,
		9.813437969593639e+02,		9.820487929196440e+02,		9.827505152270386e+02,		9.834489976797819e+02,		9.841442735347720e+02,
		9.848363755193501e+02,		9.855253358427721e+02,		9.862111862073436e+02,		9.868939578192753e+02,		9.875736813992238e+02,
		9.882503871925671e+02,		9.889241049793890e+02,		9.895948640842137e+02,		9.902626933854708e+02,		9.909276213247160e+02,
		9.915896759156091e+02,		9.922488847526665e+02,		9.929052750197741e+02,		9.935588734984931e+02,		9.942097065761459e+02,
		9.948578002536996e+02,		9.955031801534528e+02,		9.961458715265215e+02,		9.967858992601438e+02,		9.974232878848045e+02,
		9.980580615811712e+02,		9.986902441868824e+02,		9.993198592031405e+02,		9.999469298011713e+02,		1.000571478828505e+03,
		1.001193528815123e+03,		1.001813101979447e+03,		1.002430220234185e+03,		1.003044905192046e+03,		1.003657178171315e+03,
		1.004267060201290e+03,		1.004874572027610e+03,		1.005479734117440e+03,		1.006082566664547e+03,		1.006683089594253e+03,
		1.007281322568283e+03,		1.007877284989494e+03,		1.008470996006495e+03,		1.009062474518175e+03,		1.009651739178118e+03,
		1.010238808398923e+03,		1.010823700356424e+03,		1.011406432993824e+03,		1.011987024025736e+03,		1.012565490942124e+03,
		1.013141851012177e+03,		1.013716121288083e+03,		1.014288318608728e+03,		1.014858459603316e+03,		1.015426560694904e+03,
		1.015992638103878e+03,		1.016556707851334e+03,		1.017118785762402e+03,		1.017678887469496e+03,		1.018237028415496e+03,
		1.018793223856862e+03,		1.019347488866685e+03,		1.019899838337675e+03,		1.020450286985088e+03,		1.020998849349589e+03,
		1.021545539800063e+03,		1.022090372536360e+03,		1.022633361592000e+03,		1.023174520836801e+03,		1.023713863979473e+03,
		1.024251404570157e+03,		1.024787156002905e+03,		1.025321131518117e+03,		1.025853344204931e+03,		1.026383807003562e+03,
		1.026912532707599e+03,		1.027439533966258e+03,		1.027964823286583e+03,		1.028488413035616e+03,		1.029010315442516e+03,
		1.029530542600645e+03,		1.030049106469608e+03,		1.030566018877255e+03,		1.031081291521652e+03,		1.031594935973003e+03,
		1.032106963675549e+03,		1.032617385949419e+03,		1.033126213992456e+03,		1.033633458882007e+03,		1.034139131576677e+03,
		1.034643242918048e+03,		1.035145803632379e+03,		1.035646824332261e+03,		1.036146315518250e+03,		1.036644287580467e+03,
		1.037140750800171e+03,		1.037635715351303e+03,		1.038129191302000e+03,		1.038621188616088e+03,		1.039111717154545e+03,
		1.039600786676932e+03,		1.040088406842809e+03,		1.040574587213124e+03,		1.041059337251569e+03,		1.041542666325925e+03,
		1.042024583709373e+03,		1.042505098581790e+03,		1.042984220031016e+03,		1.043461957054104e+03,		1.043938318558549e+03,
		1.044413313363492e+03,		1.044886950200903e+03,		1.045359237716755e+03,		1.045830184472161e+03,		1.046299798944506e+03,
		1.046768089528553e+03,		1.047235064537530e+03,		1.047700732204207e+03,		1.048165100681945e+03,		1.048628178045731e+03,
		1.049089972293200e+03,		1.049550491345636e+03,		1.050009743048960e+03,		1.050467735174693e+03,		1.050924475420918e+03,
		1.051379971413215e+03,		1.051834230705584e+03,		1.052287260781353e+03,		1.052739069054075e+03,		1.053189662868406e+03,
		1.053639049500970e+03,		1.054087236161213e+03,		1.054534229992239e+03,		1.054980038071637e+03,		1.055424667412294e+03,
		1.055868124963193e+03,		1.056310417610204e+03,		1.056751552176852e+03,		1.057191535425088e+03,		1.057630374056033e+03,
		1.058068074710725e+03,		1.058504643970839e+03,		1.058940088359413e+03,		1.059374414341546e+03,		1.059807628325100e+03,
		1.060239736661382e+03,		1.060670745645818e+03,		1.061100661518620e+03,		1.061529490465436e+03,		1.061957238618003e+03,
		1.062383912054771e+03,		1.062809516801539e+03,		1.063234058832066e+03,		1.063657544068677e+03,		1.064079978382868e+03,
		1.064501367595889e+03,		1.064921717479327e+03,		1.065341033755679e+03,		1.065759322098918e+03,		1.066176588135046e+03,
		1.066592837442642e+03,		1.067008075553405e+03,		1.067422307952685e+03,		1.067835540080004e+03,		1.068247777329581e+03,
		1.068659025050833e+03,		1.069069288548886e+03,		1.069478573085064e+03,		1.069886883877381e+03,		1.070294226101021e+03,
		1.070700604888814e+03,		1.071106025331705e+03,		1.071510492479213e+03,		1.071914011339890e+03,		1.072316586881766e+03,
		1.072718224032794e+03,		1.073118927681288e+03,		1.073518702676351e+03,		1.073917553828302e+03,		1.074315485909092e+03,
		1.074712503652723e+03,		1.075108611755649e+03,		1.075503814877183e+03,		1.075898117639890e+03,		1.076291524629983e+03,
		1.076684040397705e+03,		1.077075669457711e+03,		1.077466416289446e+03,		1.077856285337514e+03,		1.078245281012043e+03,
		1.078633407689049e+03,		1.079020669710789e+03,		1.079407071386117e+03,		1.079792616990826e+03,		1.080177310767994e+03,
		1.080561156928322e+03,		1.080944159650463e+03,		1.081326323081360e+03,		1.081707651336563e+03,		1.082088148500553e+03,
		1.082467818627058e+03,		1.082846665739368e+03,		1.083224693830641e+03,		1.083601906864207e+03,		1.083978308773872e+03,
		1.084353903464212e+03,		1.084728694810869e+03,		1.085102686660837e+03,		1.085475882832753e+03,		1.085848287117172e+03,
		1.086219903276852e+03,		1.086590735047028e+03,		1.086960786135680e+03,		1.087330060223808e+03,		1.087698560965690e+03,
		1.088066291989149e+03,		1.088433256895811e+03,		1.088799459261355e+03,		1.089164902635774e+03,		1.089529590543617e+03,
		1.089893526484240e+03,		1.090256713932043e+03,		1.090619156336718e+03,		1.090980857123482e+03,		1.091341819693307e+03,
		1.091702047423162e+03,		1.092061543666233e+03,		1.092420311752154e+03,		1.092778354987227e+03,		1.093135676654643e+03,
		1.093492280014703e+03,		1.093848168305032e+03,		1.094203344740788e+03,		1.094557812514880e+03,		1.094911574798169e+03,
		1.095264634739677e+03,		1.095616995466789e+03,		1.095968660085453e+03,		1.096319631680381e+03,		1.096669913315239e+03,
		1.097019508032851e+03,		1.097368418855378e+03,		1.097716648784518e+03,		1.098064200801687e+03,		1.098411077868205e+03,
		1.098757282925478e+03,		1.099102818895185e+03,		1.099447688679446e+03,		1.099791895161006e+03,		1.100135441203410e+03,
		1.100478329651172e+03,		1.100820563329945e+03,		1.101162145046695e+03,		1.101503077589862e+03,		1.101843363729532e+03,
		1.102183006217589e+03,		1.102522007787888e+03,		1.102860371156409e+03,		1.103198099021412e+03,		1.103535194063601e+03,
		1.103871658946268e+03,		1.104207496315455e+03,		1.104542708800099e+03,		1.104877299012183e+03,		1.105211269546882e+03,
		1.105544622982712e+03,		1.105877361881674e+03,		1.106209488789391e+03,		1.106541006235259e+03,		1.106871916732575e+03,
		1.107202222778688e+03,		1.107531926855122e+03,		1.107861031427726e+03,		1.108189538946793e+03,		1.108517451847204e+03,
		1.108844772548549e+03,		1.109171503455269e+03,		1.109497646956769e+03,		1.109823205427557e+03,		1.110148181227363e+03,
		1.110472576701267e+03,		1.110796394179817e+03,		1.111119635979153e+03,		1.111442304401129e+03,		1.111764401733430e+03,
		1.112085930249688e+03,		1.112406892209602e+03,		1.112727289859051e+03,		1.113047125430207e+03,		1.113366401141652e+03
	},
	{
		1.724323492998824e+00,		5.223617396135993e+00,		8.788279231022736e+00,		1.242141238587076e+01,		1.612636120362931e+01,
		1.990673689389138e+01,		2.376644706914623e+01,		2.770972953928511e+01,		3.174119113281478e+01,		3.586585248168673e+01,
		4.008919991898630e+01,		4.441724590830491e+01,		4.885659976849225e+01,		5.341455090227895e+01,		5.809916731590694e+01,
		6.291941297668017e+01,		6.788528856286847e+01,		7.300800151072112e+01,		7.830017309392133e+01,		8.377609278326834e+01,
		8.945203362910979e+01,		9.534664734123903e+01,		1.014814648131145e+02,		1.078815381555496e+02,		1.145762756503748e+02,
		1.216005443450547e+02,		1.289961512656140e+02,		1.368138721318070e+02,		1.451162917573767e+02,		1.539818826099636e+02,
		1.635110354884933e+02,		1.738352894460514e+02,		1.851320519928635e+02,		1.976492817840254e+02,		2.117495399812970e+02,
		2.279951405023392e+02,		2.473310830620601e+02,		2.715397285878758e+02,		3.046354778207022e+02,		3.586620125390474e+02,
		4.733260161602981e+02,		5.648815911606277e+02,		6.060564211279434e+02,		6.318406205924944e+02,		6.506979268329479e+02,
		6.656472503965301e+02,		6.780920532469845e+02,		6.887944214004173e+02,		6.982133344909815e+02,		7.066463170780634e+02,
		7.142971056750043e+02,		7.213112806639207e+02,		7.277964782146317e+02,		7.338345448505506e+02,		7.394891985335290e+02,
		7.448110480718070e+02,		7.498409904006436e+02,		7.546125746959800e+02,		7.591536875944570e+02,		7.634877801157470e+02,
		7.676347778109598e+02,		7.716117673341546e+02,		7.754335222411632e+02,		7.791129112172922e+02,		7.826612190050097e+02,
		7.860884015999653e+02,		7.894032913185249e+02,		7.926137631835031e+02,		7.957268711340379e+02,		7.987489604560061e+02,
		8.016857612966282e+02,		8.045424669995925e+02,		8.073238001589251e+02,		8.100340686601303e+02,		8.126772134992779e+02,
		8.152568498049811e+02,		8.177763022056038e+02,		8.202386354640972e+02,		8.226466811302473e+02,		8.250030608236303e+02,
		8.273102066520411e+02,		8.295703791830797e+02,		8.317856833165013e+02,		8.339580823480138e+02,		8.360894104687702e+02,
		8.381813839068392e+02,		8.402356108854925e+02,		8.422536005472008e+02,		8.442367709706053e+02,		8.461864563896833e+02,
		8.481039137091012e+02,		8.499903283970091e+02,		8.518468198257056e+02,		8.536744461213757e+02,		8.554742085763185e+02,
		8.572470556703435e+02,		8.589938867423001e+02,		8.607155553477230e+02,		8.624128723343359e+02,		8.640866086634381e+02,
		8.657374980020062e+02,		8.673662391075203e+02,		8.689734980251221e+02,		8.705599101145585e+02,		8.721260819224774e+02,
		8.736725929140491e+02,		8.751999970763941e+02,		8.767088244050080e+02,		8.781995822833296e+02,		8.796727567644728e+02,
		8.811288137633700e+02,		8.825682001667031e+02,		8.839913448673368e+02,		8.853986597293150e+02,		8.867905404889478e+02,
		8.881673675969831e+02,		8.895295070064255e+02,		8.908773109101459e+02,		8.922111184320669e+02,		8.935312562754037e+02,
		8.948380393310804e+02,		8.961317712492528e+02,		8.974127449765709e+02,		8.986812432616089e+02,		8.999375391307108e+02,
		9.011818963362925e+02,		9.024145697794950e+02,		9.036358059089220e+02,		9.048458430970740e+02,		9.060449119959571e+02,
		9.072332358732240e+02,		9.084110309301257e+02,		9.095785066024306e+02,		9.107358658453971e+02,		9.118833054038149e+02,
		9.130210160680132e+02,		9.141491829167472e+02,		9.152679855477157e+02,		9.163775982964950e+02,		9.174781904445579e+02,
		9.185699264170375e+02,		9.196529659708319e+02,		9.207274643736113e+02,		9.217935725742536e+02,		9.228514373651944e+02,
		9.239012015371529e+02,		9.249430040266490e+02,		9.259769800567304e+02,		9.270032612712580e+02,		9.280219758631320e+02,
		9.290332486967460e+02,		9.300372014250194e+02,		9.310339526012629e+02,		9.320236177861635e+02,		9.330063096501489e+02,
		9.339821380713503e+02,		9.349512102294135e+02,		9.359136306953435e+02,		9.368695015176061e+02,		9.378189223046598e+02,
		9.387619903040937e+02,		9.396988004785475e+02,		9.406294455785595e+02,		9.415540162125022e+02,		9.424726009137379e+02,
		9.433852862051257e+02,		9.442921566610070e+02,		9.451932949667918e+02,		9.460887819762494e+02,		9.469786967666171e+02,
		9.478631166916115e+02,		9.487421174324708e+02,		9.496157730470669e+02,		9.504841560172240e+02,		9.513473372942882e+02,
		9.522053863430422e+02,		9.530583711840325e+02,		9.539063584343749e+02,		9.547494133471117e+02,		9.555875998491707e+02,
		9.564209805780100e+02,		9.572496169169557e+02,		9.580735690293508e+02,		9.588928958915128e+02,		9.597076553245688e+02,
		9.605179040252243e+02,		9.613236975954864e+02,		9.621250905714015e+02,		9.629221364508422e+02,		9.637148877203745e+02,
		9.645033958812541e+02,		9.652877114745720e+02,		9.660678841056016e+02,		9.668439624673450e+02,		9.676159943633603e+02,
		9.683840267298384e+02,		9.691481056570126e+02,		9.699082764098823e+02,		9.706645834483040e+02,		9.714170704464659e+02,
		9.721657803117630e+02,		9.729107552030961e+02,		9.736520365486356e+02,		9.743896650630265e+02,		9.751236807641092e+02,
		9.758541229891210e+02,		9.765810304104409e+02,		9.773044410508575e+02,		9.780243922984099e+02,		9.787409209207839e+02,
		9.794540630793093e+02,		9.801638543425518e+02,		9.808703296995154e+02,		9.815735235724811e+02,		9.822734698294843e+02,
		9.829702017964387e+02,		9.836637522689350e+02,		9.843541535237031e+02,		9.850414373297725e+02,		9.857256349593216e+02,
		9.864067771982361e+02,		9.870848943563872e+02,		9.877600162776245e+02,		9.884321723495191e+02,		9.891013915128349e+02,
		9.897677022707625e+02,		9.904311326978993e+02,		9.910917104490115e+02,		9.917494627675565e+02,		9.924044164939955e+02,
		9.930565980738876e+02,		9.937060335657816e+02,		9.943527486489063e+02,		9.949967686306727e+02,		9.956381184539773e+02,
		9.962768227043407e+02,		9.969129056168539e+02,		9.975463910829566e+02,		9.981773026570650e+02,		9.988056635630127e+02,
		9.994314967003588e+02,		1.000054824650526e+03,		1.000675669682813e+03,		1.001294053760232e+03,		1.001909998545244e+03,
		1.002523525405326e+03,		1.003134655418437e+03,		1.003743409378327e+03,		1.004349807799746e+03,		1.004953870923525e+03,
		1.005555618721529e+03,		1.006155070901515e+03,		1.006752246911871e+03,		1.007347165946236e+03,		1.007939846948044e+03,
		1.008530308614930e+03,		1.009118569403071e+03,		1.009704647531405e+03,		1.010288560985773e+03,		1.010870327522964e+03,
		1.011449964674664e+03,		1.012027489751336e+03,		1.012602919845998e+03,		1.013176271837928e+03,		1.013747562396291e+03,
		1.014316807983680e+03,		1.014884024859591e+03,		1.015449229083823e+03,		1.016012436519791e+03,		1.016573662837794e+03,
		1.017132923518195e+03,		1.017690233854543e+03,		1.018245608956628e+03,		1.018799063753477e+03,		1.019350612996279e+03,
		1.019900271261259e+03,		1.020448052952493e+03,		1.020993972304659e+03,		1.021538043385736e+03,		1.022080280099653e+03,
		1.022620696188879e+03,		1.023159305236961e+03,		1.023696120671016e+03,		1.024231155764175e+03,		1.024764423637968e+03,
		1.025295937264676e+03,		1.025825709469624e+03,		1.026353752933443e+03,		1.026880080194278e+03,		1.027404703649953e+03,
		1.027927635560106e+03,		1.028448888048262e+03,		1.028968473103897e+03,		1.029486402584428e+03,		1.030002688217192e+03,
		1.030517341601379e+03,		1.031030374209921e+03,		1.031541797391362e+03,		1.032051622371673e+03,		1.032559860256055e+03,
		1.033066522030693e+03,		1.033571618564479e+03,		1.034075160610714e+03,		1.034577158808771e+03,		1.035077623685721e+03,
		1.035576565657948e+03,		1.036073995032719e+03,		1.036569922009730e+03,		1.037064356682628e+03,		1.037557309040502e+03,
		1.038048788969349e+03,		1.038538806253513e+03,		1.039027370577102e+03,		1.039514491525373e+03,		1.040000178586102e+03,
		1.040484441150922e+03,		1.040967288516645e+03,		1.041448729886551e+03,		1.041928774371667e+03,		1.042407430992015e+03,
		1.042884708677846e+03,		1.043360616270839e+03,		1.043835162525300e+03,		1.044308356109326e+03,		1.044780205605950e+03,
		1.045250719514274e+03,		1.045719906250579e+03,		1.046187774149414e+03,		1.046654331464675e+03,		1.047119586370652e+03,
		1.047583546963074e+03,		1.048046221260128e+03,		1.048507617203463e+03,		1.048967742659182e+03,		1.049426605418804e+03,
		1.049884213200232e+03,		1.050340573648685e+03,		1.050795694337629e+03,		1.051249582769681e+03,		1.051702246377514e+03,
		1.052153692524732e+03,		1.052603928506737e+03,		1.053052961551590e+03,		1.053500798820845e+03,		1.053947447410377e+03,
		1.054392914351198e+03,		1.054837206610261e+03,		1.055280331091241e+03,		1.055722294635321e+03,		1.056163104021950e+03,
		1.056602765969600e+03,		1.057041287136504e+03,		1.057478674121390e+03,		1.057914933464195e+03,		1.058350071646778e+03,
		1.058784095093613e+03,		1.059217010172477e+03,		1.059648823195127e+03,		1.060079540417965e+03,		1.060509168042696e+03,
		1.060937712216969e+03,		1.061365179035023e+03,		1.061791574538301e+03,		1.062216904716081e+03,		1.062641175506077e+03,
		1.063064392795041e+03,		1.063486562419355e+03,		1.063907690165611e+03,		1.064327781771184e+03,		1.064746842924804e+03,
		1.065164879267108e+03,		1.065581896391186e+03,		1.065997899843131e+03,		1.066412895122567e+03,		1.066826887683176e+03,
		1.067239882933216e+03,		1.067651886236034e+03,		1.068062902910567e+03,		1.068472938231842e+03,		1.068881997431462e+03,
		1.069290085698093e+03,		1.069697208177935e+03,		1.070103369975197e+03,		1.070508576152555e+03,		1.070912831731612e+03,
		1.071316141693346e+03,		1.071718510978554e+03,		1.072119944488290e+03,		1.072520447084300e+03,		1.072920023589439e+03,
		1.073318678788103e+03,		1.073716417426635e+03,		1.074113244213734e+03,		1.074509163820862e+03,		1.074904180882641e+03,
		1.075298299997239e+03,		1.075691525726770e+03,		1.076083862597660e+03,		1.076475315101040e+03,		1.076865887693102e+03,
		1.077255584795480e+03,		1.077644410795602e+03,		1.078032370047051e+03,		1.078419466869920e+03,		1.078805705551154e+03,
		1.079191090344901e+03,		1.079575625472841e+03,		1.079959315124530e+03,		1.080342163457726e+03,		1.080724174598713e+03,
		1.081105352642625e+03,		1.081485701653766e+03,		1.081865225665916e+03,		1.082243928682647e+03,		1.082621814677629e+03,
		1.082998887594925e+03,		1.083375151349294e+03,		1.083750609826483e+03,		1.084125266883520e+03,		1.084499126348997e+03,
		1.084872192023354e+03,		1.085244467679159e+03,		1.085615957061385e+03,		1.085986663887679e+03,		1.086356591848635e+03,
		1.086725744608058e+03,		1.087094125803228e+03,		1.087461739045154e+03,		1.087828587918838e+03,		1.088194675983521e+03,
		1.088560006772937e+03,		1.088924583795559e+03,		1.089288410534840e+03,		1.089651490449457e+03,		1.090013826973548e+03,
		1.090375423516947e+03,		1.090736283465417e+03,		1.091096410180874e+03,		1.091455807001622e+03,		1.091814477242571e+03,
		1.092172424195461e+03,		1.092529651129079e+03,		1.092886161289476e+03,		1.093241957900179e+03,		1.093597044162403e+03,
		1.093951423255261e+03,		1.094305098335966e+03,		1.094658072540039e+03,		1.095010348981507e+03,		1.095361930753102e+03,
		1.095712820926459e+03,		1.096063022552312e+03,		1.096412538660678e+03,		1.096761372261058e+03,		1.097109526342615e+03,
		1.097457003874365e+03,		1.097803807805358e+03,		1.098149941064860e+03,		1.098495406562531e+03,		1.098840207188603e+03,
		1.099184345814055e+03,		1.099527825290786e+03,		1.099870648451788e+03,		1.100212818111309e+03,		1.100554337065027e+03,
		1.100895208090212e+03,		1.101235433945894e+03,		1.101575017373014e+03,		1.101913961094596e+03,		1.102252267815900e+03,
		1.102589940224576e+03,		1.102926980990823e+03,		1.103263392767540e+03,		1.103599178190475e+03,		1.103934339878379e+03,
		1.104268880433151e+03,		1.104602802439984e+03,		1.104936108467514e+03,		1.105268801067954e+03,		1.105600882777246e+03,
		1.105932356115196e+03,		1.106263223585612e+03,		1.106593487676440e+03,		1.106923150859904e+03,		1.107252215592638e+03,
		1.107580684315816e+03,		1.107908559455286e+03,		1.108235843421700e+03,		1.108562538610641e+03,		1.108888647402752e+03,
		1.109214172163857e+03,		1.109539115245094e+03,		1.109863478983028e+03,		1.110187265699780e+03,		1.110510477703143e+03,
		1.110833117286709e+03,		1.111155186729974e+03,		1.111476688298466e+03,		1.111797624243857e+03,		1.112117996804076e+03
	},
	{
		1.720907945507420e+00,		5.212956604834649e+00,		8.769788981709711e+00,		1.239445432718122e+01,		1.609023641913852e+01,
		1.986067851595574e+01,		2.370961176034874e+01,		2.764118762955490e+01,		3.165991515285113e+01,		3.577070377338530e+01,
		3.997891292731926e+01,		4.429040966138657e+01,		4.871163592632890e+01,		5.324968759026445e+01,		5.791240774299382e+01,
		6.270849755134233e+01,		6.764764883543216e+01,		7.274070374935009e+01,		7.799984858640889e+01,		8.343885096303390e+01,
		8.907335272347227e+01,		9.492123523665421e+01,		1.010030799180204e+02,		1.073427557251152e+02,		1.139681785146673e+02,
		1.209123069039666e+02,		1.282144696525507e+02,		1.359221674579942e+02,		1.440935696789247e+02,		1.528010564078462e+02,
		1.621363818197669e+02,		1.722184430330428e+02,		1.832054154522350e+02,		1.953145822417428e+02,		2.088565762922123e+02,
		2.242987525600424e+02,		2.423934244068512e+02,		2.644699750615789e+02,		2.932163329138610e+02,		3.352619348343845e+02,
		4.114002288813895e+02,		5.210017214320391e+02,		5.799522667395960e+02,		6.127362371821570e+02,		6.353040572923717e+02,
		6.525552732425080e+02,		6.665744342071321e+02,		6.784269728632570e+02,		6.887267006980736e+02,		6.978584407695071e+02,
		7.060789713292788e+02,		7.135680052274605e+02,		7.204561584950596e+02,		7.268413235215642e+02,		7.327987648554724e+02,
		7.383876137480347e+02,		7.436551959259122e+02,		7.486400028535210e+02,		7.533737847063486e+02,		7.578830580307385e+02,
		7.621902134229714e+02,		7.663143437768406e+02,		7.702718734510619e+02,		7.740770430866215e+02,		7.777422880816725e+02,
		7.812785375831261e+02,		7.846954532786087e+02,		7.880016220353812e+02,		7.912047127548967e+02,		7.943116051912068e+02,
		7.973284965896911e+02,		8.002609906196083e+02,		8.031141720518724e+02,		8.058926698694427e+02,		8.086007109213072e+02,
		8.112421657918338e+02,		8.138205882196814e+02,		8.163392491389184e+02,		8.188011662105898e+02,		8.212091295521641e+02,
		8.235657242448483e+02,		8.258733500970116e+02,		8.281342390602515e+02,		8.303504706286880e+02,		8.325239854983802e+02,
		8.346565977199426e+02,		8.367500055414208e+02,		8.388058011087596e+02,		8.408254791665161e+02,		8.428104448809096e+02,
		8.447620208901039e+02,		8.466814536721330e+02,		8.485699193086640e+02,		8.504285287124874e+02,		8.522583323777660e+02,
		8.540603247046141e+02,		8.558354479431426e+02,		8.575845957965751e+02,		8.593086167182827e+02,		8.610083169335018e+02,
		8.626844632129024e+02,		8.643377854221071e+02,		8.659689788685477e+02,		8.675787064647187e+02,		8.691676007247705e+02,
		8.707362656096653e+02,		8.722852782344165e+02,		8.738151904496390e+02,		8.753265303083172e+02,		8.768198034276533e+02,
		8.782954942548553e+02,		8.797540672448741e+02,		8.811959679573318e+02,		8.826216240792050e+02,		8.840314463791776e+02,
		8.854258295990859e+02,		8.868051532873557e+02,		8.881697825788794e+02,		8.895200689254224e+02,		8.908563507802589e+02,
		8.921789542404422e+02,		8.934881936497926e+02,		8.947843721654763e+02,		8.960677822907387e+02,		8.973387063762300e+02,
		8.985974170920716e+02,		8.998441778727246e+02,		9.010792433364896e+02,		9.023028596813675e+02,		9.035152650588553e+02,
		9.047166899271286e+02,		9.059073573849736e+02,		9.070874834876990e+02,		9.082572775461875e+02,		9.094169424101585e+02,
		9.105666747366201e+02,		9.117066652444411e+02,		9.128370989558988e+02,		9.139581554259632e+02,		9.150700089601172e+02,
		9.161728288213143e+02,		9.172667794268042e+02,		9.183520205353384e+02,		9.194287074253710e+02,		9.204969910647394e+02,
		9.215570182723225e+02,		9.226089318721238e+02,		9.236528708402008e+02,		9.246889704448471e+02,		9.257173623803701e+02,
		9.267381748948524e+02,		9.277515329121804e+02,		9.287575581486700e+02,		9.297563692245741e+02,		9.307480817707229e+02,
		9.317328085305738e+02,		9.327106594578862e+02,		9.336817418102586e+02,		9.346461602387333e+02,		9.356040168736619e+02,
		9.365554114070259e+02,		9.375004411713778e+02,		9.384392012155832e+02,		9.393717843774963e+02,		9.402982813537440e+02,
		9.412187807667341e+02,		9.421333692290327e+02,		9.430421314052271e+02,		9.439451500713990e+02,		9.448425061723107e+02,
		9.457342788764124e+02,		9.466205456287810e+02,		9.475013822020562e+02,		9.483768627454989e+02,		9.492470598322278e+02,
		9.501120445047321e+02,		9.509718863187239e+02,		9.518266533854106e+02,		9.526764124122543e+02,		9.535212287422817e+02,
		9.543611663920065e+02,		9.551962880880210e+02,		9.560266553023231e+02,		9.568523282864140e+02,		9.576733661042347e+02,
		9.584898266639773e+02,		9.593017667488259e+02,		9.601092420466614e+02,		9.609123071787801e+02,		9.617110157276625e+02,
		9.625054202638245e+02,		9.632955723718035e+02,		9.640815226752909e+02,		9.648633208614640e+02,		9.656410157045354e+02,
		9.664146550885563e+02,		9.671842860295011e+02,		9.679499546966621e+02,		9.687117064333736e+02,		9.694695857771003e+02,
		9.702236364789035e+02,		9.709739015223173e+02,		9.717204231416549e+02,		9.724632428397545e+02,		9.732024014052008e+02,
		9.739379389290389e+02,		9.746698948209767e+02,		9.753983078251346e+02,		9.761232160353164e+02,		9.768446569098486e+02,
		9.775626672859840e+02,		9.782772833939011e+02,		9.789885408702953e+02,		9.796964747715969e+02,		9.804011195868014e+02,
		9.811025092499596e+02,		9.818006771523055e+02,		9.824956561540533e+02,		9.831874785958760e+02,		9.838761763100636e+02,
		9.845617806313769e+02,		9.852443224076198e+02,		9.859238320099137e+02,		9.866003393427035e+02,		9.872738738535011e+02,
		9.879444645423703e+02,		9.886121399711562e+02,		9.892769282724840e+02,		9.899388571585160e+02,		9.905979539294883e+02,
		9.912542454820256e+02,		9.919077583172412e+02,		9.925585185486400e+02,		9.932065519098111e+02,		9.938518837619343e+02,
		9.944945391010973e+02,		9.951345425654333e+02,		9.957719184420754e+02,		9.964066906739499e+02,		9.970388828663926e+02,
		9.976685182936146e+02,		9.982956199050030e+02,		9.989202103312764e+02,		9.995423118904903e+02,		1.000161946593897e+03,
		1.000779136151673e+03,		1.001393901978500e+03,		1.002006265199031e+03,		1.002616246653215e+03,		1.003223866901501e+03,
		1.003829146229930e+03,		1.004432104655098e+03,		1.005032761929016e+03,		1.005631137543845e+03,		1.006227250736542e+03,
		1.006821120493391e+03,		1.007412765554427e+03,		1.008002204417774e+03,		1.008589455343877e+03,		1.009174536359644e+03,
		1.009757465262496e+03,		1.010338259624327e+03,		1.010916936795383e+03,		1.011493513908048e+03,		1.012068007880553e+03,
		1.012640435420613e+03,		1.013210813028963e+03,		1.013779157002851e+03,		1.014345483439425e+03,		1.014909808239074e+03,
		1.015472147108678e+03,		1.016032515564811e+03,		1.016590928936854e+03,		1.017147402370064e+03,		1.017701950828566e+03,
		1.018254589098293e+03,		1.018805331789856e+03,		1.019354193341365e+03,		1.019901188021187e+03,		1.020446329930647e+03,
		1.020989633006684e+03,		1.021531111024436e+03,		1.022070777599799e+03,		1.022608646191909e+03,		1.023144730105588e+03,
		1.023679042493747e+03,		1.024211596359731e+03,		1.024742404559622e+03,		1.025271479804496e+03,		1.025798834662641e+03,
		1.026324481561730e+03,		1.026848432790949e+03,		1.027370700503085e+03,		1.027891296716579e+03,		1.028410233317537e+03,
		1.028927522061702e+03,		1.029443174576385e+03,		1.029957202362374e+03,		1.030469616795790e+03,		1.030980429129919e+03,
		1.031489650497008e+03,		1.031997291910028e+03,		1.032503364264397e+03,		1.033007878339692e+03,		1.033510844801300e+03,
		1.034012274202065e+03,		1.034512176983896e+03,		1.035010563479337e+03,		1.035507443913126e+03,		1.036002828403711e+03,
		1.036496726964750e+03,		1.036989149506572e+03,		1.037480105837629e+03,		1.037969605665906e+03,		1.038457658600316e+03,
		1.038944274152067e+03,		1.039429461736010e+03,		1.039913230671949e+03,		1.040395590185954e+03,		1.040876549411624e+03,
		1.041356117391344e+03,		1.041834303077523e+03,		1.042311115333796e+03,		1.042786562936221e+03,		1.043260654574445e+03,
		1.043733398852861e+03,		1.044204804291731e+03,		1.044674879328304e+03,		1.045143632317910e+03,		1.045611071535032e+03,
		1.046077205174364e+03,		1.046542041351858e+03,		1.047005588105741e+03,		1.047467853397518e+03,		1.047928845112974e+03,
		1.048388571063134e+03,		1.048847038985231e+03,		1.049304256543648e+03,		1.049760231330837e+03,		1.050214970868240e+03,
		1.050668482607187e+03,		1.051120773929770e+03,		1.051571852149725e+03,		1.052021724513281e+03,		1.052470398200001e+03,
		1.052917880323615e+03,		1.053364177932833e+03,		1.053809298012151e+03,		1.054253247482638e+03,		1.054696033202719e+03,
		1.055137661968937e+03,		1.055578140516711e+03,		1.056017475521076e+03,		1.056455673597415e+03,		1.056892741302185e+03,
		1.057328685133618e+03,		1.057763511532423e+03,		1.058197226882477e+03,		1.058629837511498e+03,		1.059061349691715e+03,
		1.059491769640528e+03,		1.059921103521148e+03,		1.060349357443245e+03,		1.060776537463566e+03,		1.061202649586566e+03,
		1.061627699765007e+03,		1.062051693900564e+03,		1.062474637844419e+03,		1.062896537397843e+03,		1.063317398312772e+03,
		1.063737226292368e+03,		1.064156026991588e+03,		1.064573806017728e+03,		1.064990568930963e+03,		1.065406321244888e+03,
		1.065821068427043e+03,		1.066234815899432e+03,		1.066647569039035e+03,		1.067059333178312e+03,		1.067470113605704e+03,
		1.067879915566123e+03,		1.068288744261432e+03,		1.068696604850928e+03,		1.069103502451808e+03,		1.069509442139635e+03,
		1.069914428948797e+03,		1.070318467872951e+03,		1.070721563865480e+03,		1.071123721839919e+03,		1.071524946670397e+03,
		1.071925243192058e+03,		1.072324616201489e+03,		1.072723070457125e+03,		1.073120610679670e+03,		1.073517241552490e+03,
		1.073912967722022e+03,		1.074307793798161e+03,		1.074701724354648e+03,		1.075094763929456e+03,		1.075486917025165e+03,
		1.075878188109337e+03,		1.076268581614880e+03,		1.076658101940419e+03,		1.077046753450639e+03,		1.077434540476658e+03,
		1.077821467316357e+03,		1.078207538234739e+03,		1.078592757464258e+03,		1.078977129205161e+03,		1.079360657625817e+03,
		1.079743346863041e+03,		1.080125201022419e+03,		1.080506224178627e+03,		1.080886420375745e+03,		1.081265793627563e+03,
		1.081644347917891e+03,		1.082022087200863e+03,		1.082399015401232e+03,		1.082775136414664e+03,		1.083150454108032e+03,
		1.083524972319703e+03,		1.083898694859819e+03,		1.084271625510579e+03,		1.084643768026514e+03,		1.085015126134766e+03,
		1.085385703535348e+03,		1.085755503901419e+03,		1.086124530879543e+03,		1.086492788089949e+03,		1.086860279126787e+03,
		1.087227007558387e+03,		1.087592976927503e+03,		1.087958190751560e+03,		1.088322652522905e+03,		1.088686365709044e+03,
		1.089049333752876e+03,		1.089411560072941e+03,		1.089773048063638e+03,		1.090133801095466e+03,		1.090493822515246e+03,
		1.090853115646349e+03,		1.091211683788910e+03,		1.091569530220058e+03,		1.091926658194124e+03,		1.092283070942860e+03,
		1.092638771675646e+03,		1.092993763579704e+03,		1.093348049820299e+03,		1.093701633540949e+03,		1.094054517863622e+03,
		1.094406705888937e+03,		1.094758200696360e+03,		1.095109005344402e+03,		1.095459122870807e+03,		1.095808556292745e+03,
		1.096157308606998e+03,		1.096505382790150e+03,		1.096852781798767e+03,		1.097199508569576e+03,		1.097545566019652e+03,
		1.097890957046592e+03,		1.098235684528686e+03,		1.098579751325098e+03,		1.098923160276033e+03,		1.099265914202908e+03,
		1.099608015908519e+03,		1.099949468177206e+03,		1.100290273775022e+03,		1.100630435449886e+03,		1.100969955931752e+03,
		1.101308837932763e+03,		1.101647084147408e+03,		1.101984697252679e+03,		1.102321679908224e+03,		1.102658034756494e+03,
		1.102993764422901e+03,		1.103328871515959e+03,		1.103663358627433e+03,		1.103997228332489e+03,		1.104330483189828e+03,
		1.104663125741837e+03,		1.104995158514723e+03,		1.105326584018655e+03,		1.105657404747901e+03,		1.105987623180964e+03,
		1.106317241780715e+03,		1.106646262994527e+03,		1.106974689254409e+03,		1.107302522977128e+03,		1.107629766564350e+03,
		1.107956422402757e+03,		1.108282492864177e+03,		1.108607980305711e+03,		1.108932887069851e+03,		1.109257215484606e+03,
		1.109580967863624e+03,		1.109904146506305e+03,		1.110226753697928e+03,		1.110548791709762e+03,		1.110870262799182e+03
	},
	{
		1.717506113503941e+00,		5.202341263573348e+00,		8.751382364925579e+00,		1.236762555939876e+01,		1.605429526835339e+01,
		1.981486822440168e+01,		2.365310078766143e+01,		2.757306010710186e+01,		3.157915980350153e+01,		3.567620099493077e+01,
		3.986941966663896e+01,		4.416454161558040e+01,		4.856784649004614e+01,		5.308624281658341e+01,		5.772735638634773e+01,
		6.249963499816764e+01,		6.741247337739568e+01,		7.247636318070235e+01,		7.770307446106679e+01,		8.310587695446074e+01,
		8.869981228051995e+01,		9.450203195250572e+01,		1.005322214654351e+02,		1.068131384450236e+02,		1.133713041066309e+02,
		1.202379040456634e+02,		1.274499798815329e+02,		1.350520329694549e+02,		1.430982248225710e+02,		1.516554633001454e+02,
		1.608078414071639e+02,		1.706632102635552e+02,		1.813632505482119e+02,		1.930995443158604e+02,		2.061405135279898e+02,
		2.208793907974822e+02,		2.379264038386028e+02,		2.583041104879089e+02,		2.839170729063551e+02,		3.188705781456019e+02,
		3.736783448051204e+02,		4.676595125877431e+02,		5.474673453618077e+02,		5.905067648955537e+02,		6.180418252783160e+02,
		6.382150000843179e+02,		6.541587586998219e+02,		6.673789040852587e+02,		6.787042168650432e+02,		6.886363008435892e+02,
		6.975007848150185e+02,		7.055206354957995e+02,		7.128550339144712e+02,		7.196215066404544e+02,		7.259092621639713e+02,
		7.317876081770935e+02,		7.373114713143829e+02,		7.425251349955936e+02,		7.474648409674242e+02,		7.521606434610180e+02,
		7.566377584544528e+02,		7.609175637954170e+02,		7.650183528590903e+02,		7.689559109916243e+02,		7.727439624056078e+02,
		7.763945209411906e+02,		7.799181685046135e+02,		7.833242784095752e+02,		7.866211962546520e+02,		7.898163877197658e+02,
		7.929165603329178e+02,		7.959277645637552e+02,		7.988554783549318e+02,		8.017046782762015e+02,		8.044798997909579e+02,
		8.071852885977357e+02,		8.098246446060948e+02,		8.124014597950512e+02,		8.149189509603656e+02,		8.173800881673463e+02,
		8.197876195761265e+02,		8.221440931874176e+02,		8.244518759615479e+02,		8.267131706869794e+02,		8.289300309124568e+02,
		8.311043742063646e+02,		8.332379939655389e+02,		8.353325699616993e+02,		8.373896777854970e+02,		8.394107973247711e+02,
		8.413973203940939e+02,		8.433505576162422e+02,		8.452717446425067e+02,		8.471620477870869e+02,		8.490225691408956e+02,
		8.508543512217208e+02,		8.526583812105329e+02,		8.544355948174469e+02,		8.561868798157193e+02,		8.579130792774508e+02,
		8.596149945407756e+02,		8.612933879349001e+02,		8.629489852863385e+02,		8.645824782271225e+02,		8.661945263234753e+02,
		8.677857590414632e+02,		8.693567775643492e+02,		8.709081564749216e+02,		8.724404453146009e+02,		8.739541700300240e+02,
		8.754498343166902e+02,		8.769279208683226e+02,		8.783888925397644e+02,		8.798331934305003e+02,		8.812612498951617e+02,
		8.826734714868958e+02,		8.840702518388092e+02,		8.854519694883239e+02,		8.868189886488261e+02,		8.881716599325650e+02,
		8.895103210284597e+02,		8.908352973381461e+02,		8.921469025732951e+02,		8.934454393169987e+02,		8.947311995517983e+02,
		8.960044651566502e+02,		8.972655083750684e+02,		8.985145922563510e+02,		8.997519710717700e+02,		9.009778907073909e+02,
		9.021925890350817e+02,		9.033962962631296e+02,		9.045892352678263e+02,		9.057716219072173e+02,		9.069436653181723e+02,
		9.081055681978133e+02,		9.092575270702899e+02,		9.103997325398022e+02,		9.115323695307201e+02,		9.126556175155579e+02,
		9.137696507315654e+02,		9.148746383865952e+02,		9.159707448548641e+02,		9.170581298632255e+02,		9.181369486684819e+02,
		9.192073522262515e+02,		9.202694873518744e+02,		9.213234968738041e+02,		9.223695197798833e+02,		9.234076913569396e+02,
		9.244381433240045e+02,		9.254610039595686e+02,		9.264763982231374e+02,		9.274844478714168e+02,		9.284852715694146e+02,
		9.294789849967077e+02,		9.304657009491377e+02,		9.314455294361659e+02,		9.324185777741169e+02,		9.333849506754905e+02,
		9.343447503345860e+02,		9.352980765095673e+02,		9.362450266011972e+02,		9.371856957283634e+02,		9.381201768005697e+02,
		9.390485605875381e+02,		9.399709357860579e+02,		9.408873890842028e+02,		9.417980052230629e+02,		9.427028670560795e+02,
		9.436020556061113e+02,		9.444956501203320e+02,		9.453837281230603e+02,		9.462663654666047e+02,		9.471436363802264e+02,
		9.480156135172986e+02,		9.488823680007401e+02,		9.497439694667906e+02,		9.506004861072309e+02,		9.514519847100727e+02,
		9.522985306988091e+02,		9.531401881702943e+02,		9.539770199312836e+02,		9.548090875337132e+02,		9.556364513087635e+02,
		9.564591703997539e+02,		9.572773027939194e+02,		9.580909053531263e+02,		9.589000338435395e+02,		9.597047429643230e+02,
		9.605050863753787e+02,		9.613011167241813e+02,		9.620928856717371e+02,		9.628804439177063e+02,		9.636638412247135e+02,
		9.644431264418845e+02,		9.652183475276343e+02,		9.659895515717467e+02,		9.667567848167474e+02,		9.675200926786290e+02,
		9.682795197669229e+02,		9.690351099041683e+02,		9.697869061447709e+02,		9.705349507933136e+02,		9.712792854222924e+02,
		9.720199508893386e+02,		9.727569873539197e+02,		9.734904342935600e+02,		9.742203305195628e+02,		9.749467141923011e+02,
		9.756696228360474e+02,		9.763890933533806e+02,		9.771051620391792e+02,		9.778178645942245e+02,		9.785272361384109e+02,
		9.792333112235807e+02,		9.799361238460193e+02,		9.806357074585795e+02,		9.813320949824889e+02,		9.820253188188243e+02,
		9.827154108596744e+02,		9.834024024990071e+02,		9.840863246432240e+02,		9.847672077214640e+02,		9.854450816955923e+02,
		9.861199760699641e+02,		9.867919199008998e+02,		9.874609418059308e+02,		9.881270699727925e+02,		9.887903321681951e+02,
		9.894507557463612e+02,		9.901083676573411e+02,		9.907631944551255e+02,		9.914152623055484e+02,		9.920645969939861e+02,
		9.927112239328678e+02,		9.933551681690018e+02,		9.939964543907118e+02,		9.946351069348015e+02,		9.952711497933502e+02,
		9.959046066203388e+02,		9.965355007381116e+02,		9.971638551436946e+02,		9.977896925149482e+02,		9.984130352165747e+02,
		9.990339053059949e+02,		9.996523245390650e+02,		1.000268314375682e+03,		1.000881895985238e+03,		1.001493090251956e+03,
		1.002101917780104e+03,		1.002708398899085e+03,		1.003312553668407e+03,		1.003914401882548e+03,		1.004513963075699e+03,
		1.005111256526414e+03,		1.005706301262139e+03,		1.006299116063652e+03,		1.006889719469398e+03,		1.007478129779727e+03,
		1.008064365061043e+03,		1.008648443149858e+03,		1.009230381656757e+03,		1.009810197970279e+03,		1.010387909260709e+03,
		1.010963532483796e+03,		1.011537084384384e+03,		1.012108581499967e+03,		1.012678040164174e+03,		1.013245476510162e+03,
		1.013810906473970e+03,		1.014374345797767e+03,		1.014935810033052e+03,		1.015495314543790e+03,		1.016052874509465e+03,
		1.016608504928091e+03,		1.017162220619147e+03,		1.017714036226457e+03,		1.018263966221007e+03,		1.018812024903718e+03,
		1.019358226408143e+03,		1.019902584703126e+03,		1.020445113595397e+03,		1.020985826732131e+03,		1.021524737603432e+03,
		1.022061859544787e+03,		1.022597205739471e+03,		1.023130789220889e+03,		1.023662622874895e+03,		1.024192719442043e+03,
		1.024721091519812e+03,		1.025247751564782e+03,		1.025772711894761e+03,		1.026295984690888e+03,		1.026817581999674e+03,
		1.027337515735031e+03,		1.027855797680229e+03,		1.028372439489856e+03,		1.028887452691703e+03,		1.029400848688642e+03,
		1.029912638760451e+03,		1.030422834065618e+03,		1.030931445643103e+03,		1.031438484414072e+03,		1.031943961183596e+03,
		1.032447886642327e+03,		1.032950271368128e+03,		1.033451125827691e+03,		1.033950460378115e+03,		1.034448285268459e+03,
		1.034944610641267e+03,		1.035439446534065e+03,		1.035932802880833e+03,		1.036424689513447e+03,		1.036915116163106e+03,
		1.037404092461720e+03,		1.037891627943280e+03,		1.038377732045209e+03,		1.038862414109684e+03,		1.039345683384931e+03,
		1.039827549026513e+03,		1.040308020098573e+03,		1.040787105575080e+03,		1.041264814341036e+03,		1.041741155193670e+03,
		1.042216136843609e+03,		1.042689767916037e+03,		1.043162056951820e+03,		1.043633012408626e+03,		1.044102642662021e+03,
		1.044570956006543e+03,		1.045037960656764e+03,		1.045503664748334e+03,		1.045968076339002e+03,		1.046431203409628e+03,
		1.046893053865176e+03,		1.047353635535683e+03,		1.047812956177228e+03,		1.048271023472868e+03,		1.048727845033574e+03,
		1.049183428399140e+03,		1.049637781039090e+03,		1.050090910353552e+03,		1.050542823674139e+03,		1.050993528264804e+03,
		1.051443031322680e+03,		1.051891339978919e+03,		1.052338461299500e+03,		1.052784402286038e+03,		1.053229169876579e+03,
		1.053672770946377e+03,		1.054115212308662e+03,		1.054556500715397e+03,		1.054996642858021e+03,		1.055435645368185e+03,
		1.055873514818469e+03,		1.056310257723101e+03,		1.056745880538647e+03,		1.057180389664708e+03,		1.057613791444596e+03,
		1.058046092166004e+03,		1.058477298061662e+03,		1.058907415309993e+03,		1.059336450035744e+03,		1.059764408310620e+03,
		1.060191296153907e+03,		1.060617119533076e+03,		1.061041884364395e+03,		1.061465596513513e+03,		1.061888261796053e+03,
		1.062309885978184e+03,		1.062730474777188e+03,		1.063150033862025e+03,		1.063568568853879e+03,		1.063986085326705e+03,
		1.064402588807764e+03,		1.064818084778152e+03,		1.065232578673319e+03,		1.065646075883585e+03,		1.066058581754645e+03,
		1.066470101588065e+03,		1.066880640641779e+03,		1.067290204130570e+03,		1.067698797226552e+03,		1.068106425059638e+03,
		1.068513092718004e+03,		1.068918805248553e+03,		1.069323567657361e+03,		1.069727384910129e+03,		1.070130261932616e+03,
		1.070532203611079e+03,		1.070933214792696e+03,		1.071333300285991e+03,		1.071732464861250e+03,		1.072130713250928e+03,
		1.072528050150061e+03,		1.072924480216655e+03,		1.073320008072094e+03,		1.073714638301516e+03,		1.074108375454204e+03,
		1.074501224043962e+03,		1.074893188549491e+03,		1.075284273414751e+03,		1.075674483049337e+03,		1.076063821828822e+03,
		1.076452294095126e+03,		1.076839904156855e+03,		1.077226656289653e+03,		1.077612554736536e+03,		1.077997603708234e+03,
		1.078381807383521e+03,		1.078765169909539e+03,		1.079147695402124e+03,		1.079529387946126e+03,		1.079910251595721e+03,
		1.080290290374726e+03,		1.080669508276901e+03,		1.081047909266254e+03,		1.081425497277342e+03,		1.081802276215564e+03,
		1.082178249957454e+03,		1.082553422350967e+03,		1.082927797215767e+03,		1.083301378343503e+03,		1.083674169498091e+03,
		1.084046174415982e+03,		1.084417396806441e+03,		1.084787840351804e+03,		1.085157508707749e+03,		1.085526405503556e+03,
		1.085894534342358e+03,		1.086261898801403e+03,		1.086628502432302e+03,		1.086994348761273e+03,		1.087359441289393e+03,
		1.087723783492834e+03,		1.088087378823106e+03,		1.088450230707290e+03,		1.088812342548276e+03,		1.089173717724986e+03,
		1.089534359592609e+03,		1.089894271482821e+03,		1.090253456704012e+03,		1.090611918541500e+03,		1.090969660257752e+03,
		1.091326685092599e+03,		1.091682996263445e+03,		1.092038596965477e+03,		1.092393490371875e+03,		1.092747679634012e+03,
		1.093101167881660e+03,		1.093453958223188e+03,		1.093806053745760e+03,		1.094157457515530e+03,		1.094508172577833e+03,
		1.094858201957381e+03,		1.095207548658445e+03,		1.095556215665045e+03,		1.095904205941134e+03,		1.096251522430780e+03,
		1.096598168058347e+03,		1.096944145728666e+03,		1.097289458327221e+03,		1.097634108720319e+03,		1.097978099755257e+03,
		1.098321434260501e+03,		1.098664115045845e+03,		1.099006144902585e+03,		1.099347526603679e+03,		1.099688262903909e+03,
		1.100028356540044e+03,		1.100367810230999e+03,		1.100706626677990e+03,		1.101044808564691e+03,		1.101382358557386e+03,
		1.101719279305124e+03,		1.102055573439867e+03,		1.102391243576638e+03,		1.102726292313671e+03,		1.103060722232553e+03,
		1.103394535898370e+03,		1.103727735859849e+03,		1.104060324649500e+03,		1.104392304783749e+03,		1.104723678763086e+03,
		1.105054449072192e+03,		1.105384618180079e+03,		1.105714188540220e+03,		1.106043162590683e+03,		1.106371542754264e+03,
		1.106699331438609e+03,		1.107026531036348e+03,		1.107353143925218e+03,		1.107679172468191e+03,		1.108004619013593e+03,
		1.108329485895232e+03,		1.108653775432515e+03,		1.108977489930569e+03,		1.109300631680360e+03,		1.109623202958811e+03
	},
	{
		1.714117912680429e+00,		5.191771064279026e+00,		8.733058760382532e+00,		1.234092503953130e+01,		1.601853614756001e+01,
		1.976930368230796e+01,		2.359691086518563e+01,		2.750534246674075e+01,		3.149891902100407e+01,		3.558233609707690e+01,
		3.976070956349369e+01,		4.403962799107686e+01,		4.842521360628550e+01,		5.292419354693047e+01,		5.754398360936425e+01,
		6.229278724348902e+01,		6.717971329443944e+01,		7.221491697109570e+01,		7.740976983182715e+01,		8.277706634668709e+01,
		8.833127701164688e+01,		9.408886133394265e+01,		1.000686586985497e+02,		1.062923818072361e+02,		1.127852470562615e+02,
		1.195767904829256e+02,		1.267019393652895e+02,		1.342024425485436e+02,		1.421288145634211e+02,		1.505430328431009e+02,
		1.595223681816064e+02,		1.691649725957068e+02,		1.795982892904114e+02,		1.909921836253791e+02,		2.035803644451501e+02,
		2.176972386290522e+02,		2.338456095563580e+02,		2.528316107660955e+02,		2.760623433186291e+02,		3.062842402473592e+02,
		3.495830526256329e+02,		4.197404628008851e+02,		5.072153056931878e+02,		5.642299642686008e+02,		5.984829955985543e+02,
		6.223885596254197e+02,		6.406997958007776e+02,		6.555549819420633e+02,		6.680798222071381e+02,		6.789320444763072e+02,
		6.885267139639872e+02,		6.971416412933779e+02,		7.049715162695862e+02,		7.121578806914135e+02,		7.188067714901987e+02,
		7.249996397780811e+02,		7.308003939774597e+02,		7.362601027965143e+02,		7.414202290549129e+02,		7.463149100637939e+02,
		7.509726013529364e+02,		7.554172846271075e+02,		7.596693708980024e+02,		7.637463862410913e+02,		7.676634998421339e+02,
		7.714339358259620e+02,		7.750692982225714e+02,		7.785798301638907e+02,		7.819746226848338e+02,		7.852617844801580e+02,
		7.884485811002450e+02,		7.915415499963427e+02,		7.945465963101404e+02,		7.974690731816690e+02,		8.003138495119607e+02,
		8.030853674847834e+02,		8.057876916704585e+02,		8.084245511649460e+02,		8.109993759310023e+02,		8.135153282846853e+02,
		8.159753302946779e+02,		8.183820877227797e+02,		8.207381110229627e+02,		8.230457338274033e+02,		8.253071292760878e+02,
		8.275243244883517e+02,		8.296992134270930e+02,		8.318335683674039e+02,		8.339290501491735e+02,		8.359872173665653e+02,
		8.380095346250716e+02,		8.399973799782874e+02,		8.419520516409949e+02,		8.438747740619821e+02,		8.457667034289481e+02,
		8.476289326683857e+02,		8.494624959952930e+02,		8.512683730607010e+02,		8.530474927390736e+02,		8.548007365926036e+02,
		8.565289420449741e+02,		8.582329052934450e+02,		8.599133839847419e+02,		8.615710996774088e+02,		8.632067401107842e+02,
		8.648209612985239e+02,		8.664143894627225e+02,		8.679876228229747e+02,		8.695412332532388e+02,		8.710757678180145e+02,
		8.725917501982751e+02,		8.740896820164475e+02,		8.755700440689316e+02,		8.770332974737435e+02,		8.784798847402268e+02,
		8.799102307670533e+02,		8.813247437742174e+02,		8.827238161741748e+02,		8.841078253868108e+02,		8.854771346025602e+02,
		8.868320934975179e+02,		8.881730389041704e+02,		8.895002954409675e+02,		8.908141761037325e+02,		8.921149828216656e+02,
		8.934030069804070e+02,		8.946785299145147e+02,		8.959418233714449e+02,		8.971931499490039e+02,		8.984327635080430e+02,
		8.996609095620939e+02,		9.008778256454356e+02,		9.020837416610226e+02,		9.032788802095919e+02,		9.044634569011247e+02,
		9.056376806498191e+02,		9.068017539535855e+02,		9.079558731590351e+02,		9.091002287128658e+02,		9.102350054004471e+02,
		9.113603825724135e+02,		9.124765343599543e+02,		9.135836298794752e+02,		9.146818334272699e+02,		9.157713046647632e+02,
		9.168521987948790e+02,		9.179246667300303e+02,		9.189888552522166e+02,		9.200449071656577e+02,		9.210929614423893e+02,
		9.221331533611926e+02,		9.231656146402364e+02,		9.241904735637625e+02,		9.252078551031302e+02,		9.262178810325306e+02,
		9.272206700396312e+02,		9.282163378314469e+02,		9.292049972356408e+02,		9.301867582975325e+02,		9.311617283730008e+02,
		9.321300122175011e+02,		9.330917120713899e+02,		9.340469277417396e+02,		9.349957566808188e+02,		9.359382940613823e+02,
		9.368746328489597e+02,		9.378048638712553e+02,		9.387290758848081e+02,		9.396473556390449e+02,		9.405597879378448e+02,
		9.414664556987290e+02,		9.423674400097893e+02,		9.432628201844561e+02,		9.441526738142049e+02,		9.450370768192980e+02,
		9.459161034976348e+02,		9.467898265718239e+02,		9.476583172345131e+02,		9.485216451921045e+02,		9.493798787068702e+02,
		9.502330846375887e+02,		9.510813284787272e+02,		9.519246743982488e+02,		9.527631852741067e+02,		9.535969227294647e+02,
		9.544259471667091e+02,		9.552503178003038e+02,		9.560700926885236e+02,		9.568853287641235e+02,		9.576960818639785e+02,
		9.585024067577455e+02,		9.593043571755713e+02,		9.601019858349024e+02,		9.608953444664145e+02,		9.616844838391119e+02,
		9.624694537846150e+02,		9.632503032206748e+02,		9.640270801739507e+02,		9.647998318020610e+02,		9.655686044149506e+02,
		9.663334434955948e+02,		9.670943937200628e+02,		9.678514989769750e+02,		9.686048023863510e+02,		9.693543463179049e+02,
		9.701001724087826e+02,		9.708423215807699e+02,		9.715808340569937e+02,		9.723157493781232e+02,		9.730471064181053e+02,
		9.737749433994379e+02,		9.744992979079988e+02,		9.752202069074517e+02,		9.759377067532382e+02,		9.766518332061779e+02,
		9.773626214456715e+02,		9.780701060825463e+02,		9.787743211715396e+02,		9.794753002234307e+02,		9.801730762168447e+02,
		9.808676816097305e+02,		9.815591483505195e+02,		9.822475078889989e+02,		9.829327911868687e+02,		9.836150287280403e+02,
		9.842942505286360e+02,		9.849704861467484e+02,		9.856437646919213e+02,		9.863141148343988e+02,		9.869815648141176e+02,
		9.876461424494869e+02,		9.883078751459198e+02,		9.889667899041633e+02,		9.896229133284047e+02,		9.902762716341815e+02,
		9.909268906560883e+02,		9.915747958552842e+02,		9.922200123268260e+02,		9.928625648068089e+02,		9.935024776793352e+02,
		9.941397749833094e+02,		9.947744804190748e+02,		9.954066173548777e+02,		9.960362088331842e+02,		9.966632775768431e+02,
		9.972878459950988e+02,		9.979099361894639e+02,		9.985295699594519e+02,		9.991467688081729e+02,		9.997615539478053e+02,
		1.000373946304929e+03,		1.000983966525743e+03,		1.001591634981164e+03,		1.002196971771797e+03,		1.002799996732807e+03,
		1.003400729438663e+03,		1.003999189207796e+03,		1.004595395107130e+03,		1.005189365956527e+03,		1.005781120333123e+03,
		1.006370676575577e+03,		1.006958052788219e+03,		1.007543266845107e+03,		1.008126336393998e+03,		1.008707278860237e+03,
		1.009286111450546e+03,		1.009862851156753e+03,		1.010437514759418e+03,		1.011010118831401e+03,		1.011580679741343e+03,
		1.012149213657074e+03,		1.012715736548958e+03,		1.013280264193151e+03,		1.013842812174807e+03,		1.014403395891214e+03,
		1.014962030554852e+03,		1.015518731196405e+03,		1.016073512667706e+03,		1.016626389644614e+03,		1.017177376629839e+03,
		1.017726487955716e+03,		1.018273737786907e+03,		1.018819140123060e+03,		1.019362708801416e+03,		1.019904457499359e+03,
		1.020444399736912e+03,		1.020982548879197e+03,		1.021518918138832e+03,		1.022053520578286e+03,		1.022586369112197e+03,
		1.023117476509629e+03,		1.023646855396296e+03,		1.024174518256743e+03,		1.024700477436480e+03,		1.025224745144079e+03,
		1.025747333453232e+03,		1.026268254304762e+03,		1.026787519508611e+03,		1.027305140745770e+03,		1.027821129570200e+03,
		1.028335497410684e+03,		1.028848255572677e+03,		1.029359415240099e+03,		1.029868987477106e+03,		1.030376983229823e+03,
		1.030883413328050e+03,		1.031388288486934e+03,		1.031891619308611e+03,		1.032393416283818e+03,		1.032893689793479e+03,
		1.033392450110257e+03,		1.033889707400081e+03,		1.034385471723651e+03,		1.034879753037905e+03,		1.035372561197475e+03,
		1.035863905956097e+03,		1.036353796968019e+03,		1.036842243789368e+03,		1.037329255879502e+03,		1.037814842602331e+03,
		1.038299013227621e+03,		1.038781776932278e+03,		1.039263142801604e+03,		1.039743119830525e+03,		1.040221716924822e+03,
		1.040698942902313e+03,		1.041174806494034e+03,		1.041649316345392e+03,		1.042122481017301e+03,		1.042594308987296e+03,
		1.043064808650635e+03,		1.043533988321376e+03,		1.044001856233439e+03,		1.044468420541651e+03,		1.044933689322770e+03,
		1.045397670576500e+03,		1.045860372226484e+03,		1.046321802121276e+03,		1.046781968035309e+03,		1.047240877669839e+03,
		1.047698538653875e+03,		1.048154958545096e+03,		1.048610144830753e+03,		1.049064104928554e+03,		1.049516846187539e+03,
		1.049968375888936e+03,		1.050418701247014e+03,		1.050867829409903e+03,		1.051315767460425e+03,		1.051762522416894e+03,
		1.052208101233912e+03,		1.052652510803148e+03,		1.053095757954110e+03,		1.053537849454903e+03,		1.053978792012974e+03,
		1.054418592275843e+03,		1.054857256831834e+03,		1.055294792210780e+03,		1.055731204884727e+03,		1.056166501268626e+03,
		1.056600687721014e+03,		1.057033770544680e+03,		1.057465755987331e+03,		1.057896650242236e+03,		1.058326459448872e+03,
		1.058755189693553e+03,		1.059182847010053e+03,		1.059609437380214e+03,		1.060034966734556e+03,		1.060459440952869e+03,
		1.060882865864797e+03,		1.061305247250422e+03,		1.061726590840822e+03,		1.062146902318646e+03,		1.062566187318653e+03,
		1.062984451428269e+03,		1.063401700188115e+03,		1.063817939092542e+03,		1.064233173590148e+03,		1.064647409084299e+03,
		1.065060650933629e+03,		1.065472904452546e+03,		1.065884174911721e+03,		1.066294467538574e+03,		1.066703787517757e+03,
		1.067112139991622e+03,		1.067519530060690e+03,		1.067925962784109e+03,		1.068331443180107e+03,		1.068735976226440e+03,
		1.069139566860831e+03,		1.069542219981409e+03,		1.069943940447129e+03,		1.070344733078204e+03,		1.070744602656518e+03,
		1.071143553926036e+03,		1.071541591593214e+03,		1.071938720327394e+03,		1.072334944761207e+03,		1.072730269490952e+03,
		1.073124699076992e+03,		1.073518238044122e+03,		1.073910890881955e+03,		1.074302662045279e+03,		1.074693555954434e+03,
		1.075083576995662e+03,		1.075472729521467e+03,		1.075861017850963e+03,		1.076248446270220e+03,		1.076635019032609e+03,
		1.077020740359132e+03,		1.077405614438760e+03,		1.077789645428756e+03,		1.078172837455008e+03,		1.078555194612335e+03,
		1.078936720964817e+03,		1.079317420546096e+03,		1.079697297359688e+03,		1.080076355379285e+03,		1.080454598549060e+03,
		1.080832030783953e+03,		1.081208655969973e+03,		1.081584477964481e+03,		1.081959500596478e+03,		1.082333727666886e+03,
		1.082707162948821e+03,		1.083079810187874e+03,		1.083451673102379e+03,		1.083822755383681e+03,		1.084193060696402e+03,
		1.084562592678696e+03,		1.084931354942517e+03,		1.085299351073863e+03,		1.085666584633035e+03,		1.086033059154883e+03,
		1.086398778149051e+03,		1.086763745100221e+03,		1.087127963468350e+03,		1.087491436688909e+03,		1.087854168173117e+03,
		1.088216161308170e+03,		1.088577419457471e+03,		1.088937945960854e+03,		1.089297744134809e+03,		1.089656817272699e+03,
		1.090015168644981e+03,		1.090372801499417e+03,		1.090729719061293e+03,		1.091085924533620e+03,		1.091441421097349e+03,
		1.091796211911573e+03,		1.092150300113728e+03,		1.092503688819796e+03,		1.092856381124502e+03,		1.093208380101510e+03,
		1.093559688803616e+03,		1.093910310262938e+03,		1.094260247491107e+03,		1.094609503479451e+03,		1.094958081199184e+03,
		1.095305983601584e+03,		1.095653213618176e+03,		1.095999774160908e+03,		1.096345668122332e+03,		1.096690898375772e+03,
		1.097035467775502e+03,		1.097379379156913e+03,		1.097722635336682e+03,		1.098065239112939e+03,		1.098407193265434e+03,
		1.098748500555694e+03,		1.099089163727191e+03,		1.099429185505497e+03,		1.099768568598441e+03,		1.100107315696270e+03,
		1.100445429471795e+03,		1.100782912580551e+03,		1.101119767660943e+03,		1.101455997334396e+03,		1.101791604205504e+03,
		1.102126590862173e+03,		1.102460959875767e+03,		1.102794713801252e+03,		1.103127855177335e+03,		1.103460386526602e+03,
		1.103792310355658e+03,		1.104123629155268e+03,		1.104454345400481e+03,		1.104784461550776e+03,		1.105113980050183e+03,
		1.105442903327425e+03,		1.105771233796037e+03,		1.106098973854500e+03,		1.106426125886369e+03,		1.106752692260391e+03,
		1.107078675330636e+03,		1.107404077436616e+03,		1.107728900903410e+03,		1.108053148041781e+03,		1.108376821148293e+03
	},
	{
		1.710743259439439e+00,		5.181245701857988e+00,		8.714817554514681e+00,		1.231435173706128e+01,		1.598295747400059e+01,
		1.972398258588258e+01,		2.354103875730783e+01,		2.743803027744495e+01,		3.141918684868344e+01,		3.548910118280599e+01,
		3.965277225830611e+01,		4.391565530594409e+01,		4.828371983396002e+01,		5.276351731515101e+01,		5.736226055638866e+01,
		6.208791728595266e+01,		6.694932116510846e+01,		7.195630431320656e+01,		7.711985660861612e+01,		8.245231860300487e+01,
		8.796761702593037e+01,		9.368155479840300e+01,		9.961217157282346e+01,		1.057801966103251e+02,		1.122096241252227e+02,
		1.189284533768511e+02,		1.259696538739923e+02,		1.333724435401909e+02,		1.411840104293403e+02,		1.494618767888739e+02,
		1.582772163238898e+02,		1.677196257640780e+02,		1.779041871941446e+02,		1.889822748218188e+02,		2.011587539446031e+02,
		2.147206678896572e+02,		2.300878762795335e+02,		2.479088124104836e+02,		2.692571344279887e+02,		2.960740292837126e+02,
		3.322271864054585e+02,		3.857799613998012e+02,		4.640600794721109e+02,		5.329079472733284e+02,		5.761145235799182e+02,
		6.048008993471593e+02,		6.260311467767306e+02,		6.428473561110187e+02,		6.567796388668452e+02,		6.686927205285930e+02,
		6.791174223695068e+02,		6.884009721060578e+02,		6.967821391045768e+02,		7.044317950956798e+02,		7.114762533123675e+02,
		7.180114312874007e+02,		7.241118344316541e+02,		7.298364697275218e+02,		7.352328625457802e+02,		7.403398591251288e+02,
		7.451896276904985e+02,		7.498091166681883e+02,		7.542211365661474e+02,		7.584451756545974e+02,		7.624980239311474e+02,
		7.663942567630384e+02,		7.701466143079626e+02,		7.737663024863233e+02,		7.772632341763865e+02,		7.806462243415373e+02,
		7.839231492805808e+02,		7.871010776633909e+02,		7.901863791746056e+02,		7.931848152339893e+02,		7.961016152549037e+02,
		7.989415411456051e+02,		8.017089421842511e+02,		8.044078019593653e+02,		8.070417787289007e+02,		8.096142402876384e+02,
		8.121282942263831e+02,		8.145868143036735e+02,		8.169924635214920e+02,		8.193477143930596e+02,		8.216548668078209e+02,
		8.239160638313624e+02,		8.261333057234275e+02,		8.283084624123831e+02,		8.304432846277588e+02,		8.325394138620828e+02,
		8.345983913080319e+02,		8.366216658958597e+02,		8.386106015385203e+02,		8.405664836770449e+02,		8.424905252062649e+02,
		8.443838718503872e+02,		8.462476070489051e+02,		8.480827564056897e+02,		8.498902917474556e+02,		8.516711348322366e+02,
		8.534261607435513e+02,		8.551562010017929e+02,		8.568620464206954e+02,		8.585444497335984e+02,		8.602041280114063e+02,
		8.618417648918239e+02,		8.634580126372304e+02,		8.650534940367999e+02,		8.666288041667773e+02,		8.681845120214166e+02,
		8.697211620258028e+02,		8.712392754406874e+02,		8.727393516684081e+02,		8.742218694681613e+02,		8.756872880880348e+02,
		8.771360483205453e+02,		8.785685734877916e+02,		8.799852703617686e+02,		8.813865300248805e+02,		8.827727286752566e+02,
		8.841442283810363e+02,		8.855013777874666e+02,		8.868445127802925e+02,		8.881739571086276e+02,		8.894900229702505e+02,
		8.907930115619888e+02,		8.920832135976634e+02,		8.933609097958600e+02,		8.946263713395981e+02,		8.958798603098174e+02,
		8.971216300944499e+02,		8.983519257747108e+02,		8.995709844900879e+02,		9.007790357834515e+02,		9.019763019275581e+02,
		9.031629982341067e+02,		9.043393333465095e+02,		9.055055095173471e+02,		9.066617228714742e+02,		9.078081636556610e+02,
		9.089450164755923e+02,		9.100724605209547e+02,		9.111906697793650e+02,		9.122998132397637e+02,		9.134000550859103e+02,
		9.144915548805305e+02,		9.155744677406839e+02,		9.166489445048142e+02,		9.177151318919844e+02,		9.187731726537008e+02,
		9.198232057187623e+02,		9.208653663315031e+02,		9.218997861837853e+02,		9.229265935410871e+02,		9.239459133629932e+02,
		9.249578674183884e+02,		9.259625743956317e+02,		9.269601500079635e+02,		9.279507070944086e+02,		9.289343557163821e+02,
		9.299112032502425e+02,		9.308813544759656e+02,		9.318449116621638e+02,		9.328019746476026e+02,		9.337526409194107e+02,
		9.346970056881241e+02,		9.356351619597290e+02,		9.365672006048468e+02,		9.374932104251898e+02,		9.384132782174222e+02,
		9.393274888345425e+02,		9.402359252449141e+02,		9.411386685890352e+02,		9.420357982341568e+02,		9.429273918268673e+02,
		9.438135253436899e+02,		9.446942731398366e+02,		9.455697079961495e+02,		9.464399011643483e+02,		9.473049224106334e+02,
		9.481648400577230e+02,		9.490197210254025e+02,		9.498696308696307e+02,		9.507146338202743e+02,		9.515547928175361e+02,
		9.523901695471084e+02,		9.532208244741344e+02,		9.540468168760041e+02,		9.548682048740333e+02,		9.556850454640960e+02,
		9.564973945462078e+02,		9.573053069531594e+02,		9.581088364781790e+02,		9.589080359017086e+02,		9.597029570173025e+02,
		9.604936506566939e+02,		9.612801667140569e+02,		9.620625541694932e+02,		9.628408611117876e+02,		9.636151347604324e+02,
		9.643854214869805e+02,		9.651517668357250e+02,		9.659142155437535e+02,		9.666728115603717e+02,		9.674275980659589e+02,
		9.681786174902370e+02,		9.689259115299955e+02,		9.696695211662936e+02,		9.704094866811433e+02,		9.711458476737123e+02,
		9.718786430760441e+02,		9.726079111683231e+02,		9.733336895936986e+02,		9.740560153726848e+02,		9.747749249171505e+02,
		9.754904540439046e+02,		9.762026379879089e+02,		9.769115114151112e+02,		9.776171084349264e+02,		9.783194626123650e+02,
		9.790186069798431e+02,		9.797145740486455e+02,		9.804073958200985e+02,		9.810971037964260e+02,		9.817837289913221e+02,
		9.824673019402330e+02,		9.831478527103744e+02,		9.838254109104773e+02,		9.845000057002748e+02,		9.851716657997503e+02,
		9.858404194981398e+02,		9.865062946626963e+02,		9.871693187472392e+02,		9.878295188004766e+02,		9.884869214741169e+02,
		9.891415530307800e+02,		9.897934393517057e+02,		9.904426059442679e+02,		9.910890779493001e+02,		9.917328801482528e+02,
		9.923740369701508e+02,		9.930125724984034e+02,		9.936485104774345e+02,		9.942818743191533e+02,		9.949126871092787e+02,
		9.955409716134955e+02,		9.961667502834779e+02,		9.967900452627624e+02,		9.974108783924875e+02,		9.980292712169871e+02,
		9.986452449892672e+02,		9.992588206763481e+02,		9.998700189644769e+02,		1.000478860264232e+03,		1.001085364715504e+03,
		1.001689552192358e+03,		1.002291442307798e+03,		1.002891054418409e+03,		1.003488407628907e+03,		1.004083520796580e+03,
		1.004676412535630e+03,		1.005267101221425e+03,		1.005855604994648e+03,		1.006441941765362e+03,		1.007026129216983e+03,
		1.007608184810167e+03,		1.008188125786612e+03,		1.008765969172782e+03,		1.009341731783542e+03,		1.009915430225726e+03,
		1.010487080901625e+03,		1.011056700012394e+03,		1.011624303561402e+03,		1.012189907357493e+03,		1.012753527018203e+03,
		1.013315177972879e+03,		1.013874875465766e+03,		1.014432634559005e+03,		1.014988470135586e+03,		1.015542396902227e+03,
		1.016094429392208e+03,		1.016644581968138e+03,		1.017192868824667e+03,		1.017739303991149e+03,		1.018283901334251e+03,
		1.018826674560498e+03,		1.019367637218786e+03,		1.019906802702833e+03,		1.020444184253587e+03,		1.020979794961580e+03,
		1.021513647769248e+03,		1.022045755473192e+03,		1.022576130726409e+03,		1.023104786040470e+03,		1.023631733787657e+03,
		1.024156986203067e+03,		1.024680555386669e+03,		1.025202453305320e+03,		1.025722691794754e+03,		1.026241282561516e+03,
		1.026758237184884e+03,		1.027273567118727e+03,		1.027787283693351e+03,		1.028299398117302e+03,		1.028809921479134e+03,
		1.029318864749149e+03,		1.029826238781102e+03,		1.030332054313874e+03,		1.030836321973122e+03,		1.031339052272890e+03,
		1.031840255617195e+03,		1.032339942301586e+03,		1.032838122514671e+03,		1.033334806339624e+03,		1.033830003755656e+03,
		1.034323724639467e+03,		1.034815978766670e+03,		1.035306775813190e+03,		1.035796125356638e+03,		1.036284036877662e+03,
		1.036770519761277e+03,		1.037255583298167e+03,		1.037739236685965e+03,		1.038221489030517e+03,		1.038702349347120e+03,
		1.039181826561737e+03,		1.039659929512196e+03,		1.040136666949365e+03,		1.040612047538309e+03,		1.041086079859429e+03,
		1.041558772409579e+03,		1.042030133603165e+03,		1.042500171773227e+03,		1.042968895172502e+03,		1.043436311974473e+03,
		1.043902430274394e+03,		1.044367258090301e+03,		1.044830803364014e+03,		1.045293073962109e+03,		1.045754077676885e+03,
		1.046213822227314e+03,		1.046672315259964e+03,		1.047129564349931e+03,		1.047585577001730e+03,		1.048040360650187e+03,
		1.048493922661318e+03,		1.048946270333183e+03,		1.049397410896738e+03,		1.049847351516664e+03,		1.050296099292192e+03,
		1.050743661257910e+03,		1.051190044384556e+03,		1.051635255579802e+03,		1.052079301689027e+03,		1.052522189496072e+03,
		1.052963925723991e+03,		1.053404517035784e+03,		1.053843970035126e+03,		1.054282291267072e+03,		1.054719487218771e+03,
		1.055155564320148e+03,		1.055590528944592e+03,		1.056024387409626e+03,		1.056457145977567e+03,		1.056888810856180e+03,
		1.057319388199317e+03,		1.057748884107549e+03,		1.058177304628797e+03,		1.058604655758933e+03,		1.059030943442395e+03,
		1.059456173572778e+03,		1.059880351993422e+03,		1.060303484497993e+03,		1.060725576831050e+03,		1.061146634688610e+03,
		1.061566663718697e+03,		1.061985669521896e+03,		1.062403657651884e+03,		1.062820633615962e+03,		1.063236602875581e+03,
		1.063651570846854e+03,		1.064065542901066e+03,		1.064478524365175e+03,		1.064890520522302e+03,		1.065301536612225e+03,
		1.065711577831855e+03,		1.066120649335707e+03,		1.066528756236372e+03,		1.066935903604976e+03,		1.067342096471632e+03,
		1.067747339825886e+03,		1.068151638617168e+03,		1.068554997755215e+03,		1.068957422110509e+03,		1.069358916514700e+03,
		1.069759485761018e+03,		1.070159134604694e+03,		1.070557867763358e+03,		1.070955689917450e+03,		1.071352605710605e+03,
		1.071748619750051e+03,		1.072143736606994e+03,		1.072537960816993e+03,		1.072931296880341e+03,		1.073323749262432e+03,
		1.073715322394125e+03,		1.074106020672109e+03,		1.074495848459256e+03,		1.074884810084969e+03,		1.075272909845535e+03,
		1.075660152004461e+03,		1.076046540792814e+03,		1.076432080409557e+03,		1.076816775021871e+03,		1.077200628765486e+03,
		1.077583645744995e+03,		1.077965830034179e+03,		1.078347185676310e+03,		1.078727716684467e+03,		1.079107427041833e+03,
		1.079486320702001e+03,		1.079864401589271e+03,		1.080241673598936e+03,		1.080618140597581e+03,		1.080993806423358e+03,
		1.081368674886281e+03,		1.081742749768488e+03,		1.082116034824533e+03,		1.082488533781644e+03,		1.082860250340000e+03,
		1.083231188172993e+03,		1.083601350927487e+03,		1.083970742224080e+03,		1.084339365657357e+03,		1.084707224796148e+03,
		1.085074323183765e+03,		1.085440664338260e+03,		1.085806251752663e+03,		1.086171088895221e+03,		1.086535179209637e+03,
		1.086898526115304e+03,		1.087261133007537e+03,		1.087623003257800e+03,		1.087984140213934e+03,		1.088344547200379e+03,
		1.088704227518397e+03,		1.089063184446286e+03,		1.089421421239596e+03,		1.089778941131349e+03,		1.090135747332238e+03,
		1.090491843030844e+03,		1.090847231393838e+03,		1.091201915566185e+03,		1.091555898671341e+03,		1.091909183811457e+03,
		1.092261774067572e+03,		1.092613672499809e+03,		1.092964882147560e+03,		1.093315406029685e+03,		1.093665247144693e+03,
		1.094014408470927e+03,		1.094362892966751e+03,		1.094710703570724e+03,		1.095057843201788e+03,		1.095404314759434e+03,
		1.095750121123886e+03,		1.096095265156270e+03,		1.096439749698784e+03,		1.096783577574868e+03,		1.097126751589369e+03,
		1.097469274528711e+03,		1.097811149161051e+03,		1.098152378236447e+03,		1.098492964487017e+03,		1.098832910627093e+03,
		1.099172219353376e+03,		1.099510893345098e+03,		1.099848935264170e+03,		1.100186347755329e+03,		1.100523133446297e+03,
		1.100859294947920e+03,		1.101194834854318e+03,		1.101529755743029e+03,		1.101864060175152e+03,		1.102197750695488e+03,
		1.102530829832681e+03,		1.102863300099355e+03,		1.103195163992249e+03,		1.103526423992359e+03,		1.103857082565065e+03,
		1.104187142160267e+03,		1.104516605212513e+03,		1.104845474141135e+03,		1.105173751350369e+03,		1.105501439229491e+03,
		1.105828540152932e+03,		1.106155056480413e+03,		1.106480990557060e+03,		1.106806344713531e+03,		1.107131121266133e+03
	},
	{
		1.707382070886297e+00,		5.170764874157499e+00,		8.696658140379894e+00,		1.228790463374409e+01,		1.594755768550302e+01,
		1.967890266382782e+01,		2.348548127765984e+01,		2.737111918069757e+01,		3.133995743439714e+01,		3.539648850344206e+01,
		3.954559759953390e+01,		4.379261036743802e+01,		4.814334813140901e+01,		5.260419220433749e+01,		5.718215912496473e+01,
		6.188498915580526e+01,		6.672125098102741e+01,		7.170046633805744e+01,		7.683325936726423e+01,		8.213153686750832e+01,
		8.760870754070820e+01,		9.327995089857846e+01,		9.916255008906207e+01,		1.052763079289613e+02,		1.116440725909866e+02,
		1.182924097593036e+02,		1.252524733404002e+02,		1.325611497630580e+02,		1.402625861326675e+02,		1.484102679148297e+02,
		1.570699013451917e+02,		1.663235048449255e+02,		1.762753706491928e+02,		1.870610182591296e+02,		1.988611239431763e+02,
		2.119241111027495e+02,		2.266046377583116e+02,		2.434331178974973e+02,		2.632501207316167e+02,		2.874854387971336e+02,
		3.187641239951724e+02,		3.621023773571646e+02,		4.253689544042472e+02,		4.973086641178638e+02,		5.503661696524529e+02,
		5.851436215998912e+02,		6.099691210813133e+02,		6.291370877407311e+02,		6.447226082205160e+02,		6.578606480933651e+02,
		6.692303358347266e+02,		6.792662593676763e+02,		6.882617082861593e+02,		6.964232705310600e+02,		7.039016228004517e+02,
		7.108098701998944e+02,		7.172349887661270e+02,		7.232452508562044e+02,		7.288952070032066e+02,		7.342291247990293e+02,
		7.392834215884174e+02,		7.440884225018019e+02,		7.486696550315286e+02,		7.530488183997725e+02,		7.572445203925877e+02,
		7.612728451061558e+02,		7.651477958635004e+02,		7.688816446987141e+02,		7.724852110231748e+02,		7.759680859893055e+02,
		7.793388147671794e+02,		7.826050458748740e+02,		7.857736544773446e+02,		7.888508449375274e+02,		7.918422366954051e+02,
		7.947529366467725e+02,		7.975876005107325e+02,		8.003504851544930e+02,		8.030454934441352e+02,		8.056762128801388e+02,
		8.082459490345715e+02,		8.107577546167070e+02,		8.132144548433507e+02,		8.156186696701376e+02,		8.179728333440368e+02,
		8.202792116596772e+02,		8.225399172392749e+02,		8.247569231046392e+02,		8.269320747677368e+02,		8.290671010316257e+02,
		8.311636236649498e+02,		8.332231660893364e+02,		8.352471611991407e+02,		8.372369584162888e+02,		8.391938300689184e+02,
		8.411189771706395e+02,		8.430135346671555e+02,		8.448785762083797e+02,		8.467151184968928e+02,		8.485241252572664e+02,
		8.503065108653668e+02,		8.520631436721440e+02,		8.537948490522842e+02,		8.555024122047241e+02,		8.571865807288538e+02,
		8.588480669977164e+02,		8.604875503470410e+02,		8.621056790970862e+02,		8.637030724223162e+02,		8.652803220824834e+02,
		8.668379940272479e+02,		8.683766298852405e+02,		8.698967483474287e+02,		8.713988464536072e+02,		8.728834007900718e+02,
		8.743508686056965e+02,		8.758016888529868e+02,		8.772362831600659e+02,		8.786550567390181e+02,		8.800583992355013e+02,
		8.814466855241210e+02,		8.828202764536594e+02,		8.841795195458997e+02,		8.855247496514445e+02,		8.868562895656860e+02,
		8.881744506077600e+02,		8.894795331651425e+02,		8.907718272062716e+02,		8.920516127634463e+02,		8.933191603880159e+02,
		8.945747315797572e+02,		8.958185791921629e+02,		8.970509478152455e+02,		8.982720741373373e+02,		8.994821872872436e+02,
		9.006815091580140e+02,		9.018702547135131e+02,		9.030486322788533e+02,		9.042168438157238e+02,		9.053750851835183e+02,
		9.065235463871461e+02,		9.076624118123433e+02,		9.087918604491962e+02,		9.099120661046234e+02,		9.110231976044263e+02,
		9.121254189855323e+02,		9.132188896790102e+02,		9.143037646843421e+02,		9.153801947355022e+02,		9.164483264592552e+02,
		9.175083025261342e+02,		9.185602617944884e+02,		9.196043394479856e+02,		9.206406671269199e+02,		9.216693730536562e+02,
		9.226905821525289e+02,		9.237044161644747e+02,		9.247109937566946e+02,		9.257104306275828e+02,		9.267028396071670e+02,
		9.276883307533164e+02,		9.286670114438864e+02,		9.296389864650384e+02,		9.306043580959188e+02,		9.315632261898543e+02,
		9.325156882522756e+02,		9.334618395154714e+02,		9.344017730103884e+02,		9.353355796355634e+02,		9.362633482233608e+02,
		9.371851656036209e+02,		9.381011166648508e+02,		9.390112844130597e+02,		9.399157500283685e+02,		9.408145929194649e+02,
		9.417078907760322e+02,		9.425957196192140e+02,		9.434781538502314e+02,		9.443552662972049e+02,		9.452271282602829e+02,
		9.460938095551447e+02,		9.469553785549291e+02,		9.478119022306956e+02,		9.486634461904388e+02,		9.495100747167459e+02,
		9.503518508031390e+02,		9.511888361891694e+02,		9.520210913943009e+02,		9.528486757506447e+02,		9.536716474345889e+02,
		9.544900634973590e+02,		9.553039798945724e+02,		9.561134515148010e+02,		9.569185322072047e+02,		9.577192748082595e+02,
		9.585157311676189e+02,		9.593079521731444e+02,		9.600959877751303e+02,		9.608798870097648e+02,		9.616596980218513e+02,
		9.624354680868053e+02,		9.632072436319879e+02,		9.639750702573543e+02,		9.647389927554869e+02,		9.654990551310073e+02,
		9.662553006194016e+02,		9.670077717052752e+02,		9.677565101400693e+02,		9.685015569592367e+02,		9.692429524989184e+02,
		9.699807364121306e+02,		9.707149476844714e+02,		9.714456246493824e+02,		9.721728050029542e+02,		9.728965258183242e+02,
		9.736168235596512e+02,		9.743337340957030e+02,		9.750472927130483e+02,		9.757575341288981e+02,		9.764644925035728e+02,
		9.771682014526318e+02,		9.778686940586672e+02,		9.785660028827796e+02,		9.792601599757334e+02,		9.799511968888187e+02,
		9.806391446844165e+02,		9.813240339462807e+02,		9.820058947895527e+02,		9.826847568705051e+02,		9.833606493960308e+02,
		9.840336011328893e+02,		9.847036404166998e+02,		9.853707951607225e+02,		9.860350928643901e+02,		9.866965606216434e+02,
		9.873552251290372e+02,		9.880111126936526e+02,		9.886642492408076e+02,		9.893146603215696e+02,		9.899623711200902e+02,
		9.906074064607498e+02,		9.912497908151300e+02,		9.918895483088189e+02,		9.925267027280419e+02,		9.931612775261401e+02,
		9.937932958298870e+02,		9.944227804456578e+02,		9.950497538654487e+02,		9.956742382727529e+02,		9.962962555482978e+02,
		9.969158272756542e+02,		9.975329747467028e+02,		9.981477189669801e+02,		9.987600806609029e+02,		9.993700802768641e+02,
		9.999777379922209e+02,		1.000583073718163e+03,		1.001186107104475e+03,		1.001786857544182e+03,		1.002385344178105e+03,
		1.002981585899300e+03,		1.003575601357409e+03,		1.004167408962909e+03,		1.004757026891266e+03,		1.005344473087008e+03,
		1.005929765267689e+03,		1.006512920927790e+03,		1.007093957342520e+03,		1.007672891571542e+03,		1.008249740462610e+03,
		1.008824520655143e+03,		1.009397248583714e+03,		1.009967940481460e+03,		1.010536612383433e+03,		1.011103280129871e+03,
		1.011667959369405e+03,		1.012230665562197e+03,		1.012791413983016e+03,		1.013350219724245e+03,		1.013907097698836e+03,
		1.014462062643191e+03,		1.015015129120001e+03,		1.015566311521012e+03,		1.016115624069746e+03,		1.016663080824161e+03,
		1.017208695679258e+03,		1.017752482369645e+03,		1.018294454472038e+03,		1.018834625407718e+03,		1.019373008444945e+03,
		1.019909616701312e+03,		1.020444463146067e+03,		1.020977560602382e+03,		1.021508921749577e+03,		1.022038559125306e+03,
		1.022566485127702e+03,		1.023092712017472e+03,		1.023617251919964e+03,		1.024140116827184e+03,		1.024661318599786e+03,
		1.025180868969014e+03,		1.025698779538612e+03,		1.026215061786703e+03,		1.026729727067627e+03,		1.027242786613745e+03,
		1.027754251537213e+03,		1.028264132831724e+03,		1.028772441374213e+03,		1.029279187926537e+03,		1.029784383137121e+03,
		1.030288037542573e+03,		1.030790161569277e+03,		1.031290765534948e+03,		1.031789859650164e+03,		1.032287454019874e+03,
		1.032783558644872e+03,		1.033278183423248e+03,		1.033771338151823e+03,		1.034263032527537e+03,		1.034753276148833e+03,
		1.035242078517013e+03,		1.035729449037559e+03,		1.036215397021448e+03,		1.036699931686424e+03,		1.037183062158279e+03,
		1.037664797472070e+03,		1.038145146573359e+03,		1.038624118319397e+03,		1.039101721480313e+03,		1.039577964740260e+03,
		1.040052856698569e+03,		1.040526405870859e+03,		1.040998620690141e+03,		1.041469509507898e+03,		1.041939080595157e+03,
		1.042407342143534e+03,		1.042874302266256e+03,		1.043339968999190e+03,		1.043804350301827e+03,		1.044267454058268e+03,
		1.044729288078189e+03,		1.045189860097793e+03,		1.045649177780735e+03,		1.046107248719051e+03,		1.046564080434058e+03,
		1.047019680377244e+03,		1.047474055931144e+03,		1.047927214410201e+03,		1.048379163061621e+03,		1.048829909066197e+03,
		1.049279459539142e+03,		1.049727821530888e+03,		1.050175002027892e+03,		1.050621007953415e+03,		1.051065846168294e+03,
		1.051509523471706e+03,		1.051952046601913e+03,		1.052393422236997e+03,		1.052833656995594e+03,		1.053272757437602e+03,
		1.053710730064885e+03,		1.054147581321973e+03,		1.054583317596734e+03,		1.055017945221058e+03,		1.055451470471513e+03,
		1.055883899569998e+03,		1.056315238684388e+03,		1.056745493929167e+03,		1.057174671366051e+03,		1.057602777004605e+03,
		1.058029816802846e+03,		1.058455796667844e+03,		1.058880722456303e+03,		1.059304599975152e+03,		1.059727434982107e+03,
		1.060149233186236e+03,		1.060570000248515e+03,		1.060989741782377e+03,		1.061408463354249e+03,		1.061826170484081e+03,
		1.062242868645875e+03,		1.062658563268195e+03,		1.063073259734685e+03,		1.063486963384562e+03,		1.063899679513118e+03,
		1.064311413372199e+03,		1.064722170170696e+03,		1.065131955075015e+03,		1.065540773209543e+03,		1.065948629657110e+03,
		1.066355529459447e+03,		1.066761477617633e+03,		1.067166479092535e+03,		1.067570538805245e+03,		1.067973661637515e+03,
		1.068375852432177e+03,		1.068777115993563e+03,		1.069177457087917e+03,		1.069576880443806e+03,		1.069975390752515e+03,
		1.070372992668455e+03,		1.070769690809541e+03,		1.071165489757589e+03,		1.071560394058692e+03,		1.071954408223593e+03,
		1.072347536728063e+03,		1.072739784013262e+03,		1.073131154486101e+03,		1.073521652519599e+03,		1.073911282453236e+03,
		1.074300048593297e+03,		1.074687955213215e+03,		1.075075006553914e+03,		1.075461206824136e+03,		1.075846560200776e+03,
		1.076231070829203e+03,		1.076614742823585e+03,		1.076997580267202e+03,		1.077379587212762e+03,		1.077760767682708e+03,
		1.078141125669522e+03,		1.078520665136030e+03,		1.078899390015695e+03,		1.079277304212915e+03,		1.079654411603306e+03,
		1.080030716033996e+03,		1.080406221323900e+03,		1.080780931264009e+03,		1.081154849617652e+03,		1.081527980120783e+03,
		1.081900326482236e+03,		1.082271892384002e+03,		1.082642681481482e+03,		1.083012697403753e+03,		1.083381943753821e+03,
		1.083750424108871e+03,		1.084118142020521e+03,		1.084485101015065e+03,		1.084851304593720e+03,		1.085216756232866e+03,
		1.085581459384277e+03,		1.085945417475367e+03,		1.086308633909414e+03,		1.086671112065792e+03,		1.087032855300195e+03,
		1.087393866944866e+03,		1.087754150308813e+03,		1.088113708678029e+03,		1.088472545315709e+03,		1.088830663462463e+03,
		1.089188066336526e+03,		1.089544757133968e+03,		1.089900739028896e+03,		1.090256015173663e+03,		1.090610588699065e+03,
		1.090964462714541e+03,		1.091317640308372e+03,		1.091670124547871e+03,		1.092021918479576e+03,		1.092373025129443e+03,
		1.092723447503029e+03,		1.093073188585682e+03,		1.093422251342719e+03,		1.093770638719613e+03,		1.094118353642168e+03,
		1.094465399016698e+03,		1.094811777730200e+03,		1.095157492650530e+03,		1.095502546626573e+03,		1.095846942488411e+03,
		1.096190683047491e+03,		1.096533771096795e+03,		1.096876209410993e+03,		1.097218000746616e+03,		1.097559147842209e+03,
		1.097899653418493e+03,		1.098239520178519e+03,		1.098578750807824e+03,		1.098917347974584e+03,		1.099255314329763e+03,
		1.099592652507268e+03,		1.099929365124092e+03,		1.100265454780462e+03,		1.100600924059985e+03,		1.100935775529789e+03,
		1.101270011740668e+03,		1.101603635227218e+03,		1.101936648507980e+03,		1.102269054085573e+03,		1.102600854446833e+03,
		1.102932052062946e+03,		1.103262649389581e+03,		1.103592648867019e+03,		1.103922052920288e+03,		1.104250863959287e+03,
		1.104579084378915e+03,		1.104906716559199e+03,		1.105233762865411e+03,		1.105560225648204e+03,		1.105886107243721e+03
	},
	{
		1.704034264821469e+00,		5.160328281927975e+00,		8.678579917563482e+00,		1.226158272341051e+01,		1.591233524011908e+01,
		1.963406167672093e+01,		2.343023528810655e+01,		2.730460488888970e+01,		3.126122502805998e+01,		3.530449045489168e+01,
		3.943917563803486e+01,		4.367048026363705e+01,		4.800408184406428e+01,		5.244619682872796e+01,		5.700365193933833e+01,
		6.168396787614426e+01,		6.649545809019041e+01,		7.144734603183862e+01,		7.654990522705559e+01,		8.181462778389965e+01,
		8.725442861166880e+01,		9.288389491702989e+01,		9.871959367849540e+01,		1.047804541701085e+02,		1.110882487780979e+02,
		1.176682042101088e+02,		1.245497881166267e+02,		1.317677353436358e+02,		1.393634071503727e+02,		1.473866218781594e+02,
		1.558981673477099e+02,		1.649733226362054e+02,		1.747069148838783e+02,		1.852207827703490e+02,		1.966751474209547e+02,
		2.092865876580674e+02,		2.233577056740191e+02,		2.393285954169084e+02,		2.578713085667281e+02,		2.800733494224779e+02,
		3.078056562173319e+02,		3.444006075452085e+02,		3.953263047081055e+02,		4.615766413527013e+02,		5.211402612861218e+02,
		5.630866412582562e+02,		5.923182544765737e+02,		6.142979857666779e+02,		6.318223353810607e+02,		6.463743606638263e+02,
		6.588202171751495e+02,		6.697032121057308e+02,		6.793835878115895e+02,		6.881112069193347e+02,		6.960658999494226e+02,
		7.033811157721713e+02,		7.101584538495325e+02,		7.164769649224201e+02,		7.223993154310855e+02,		7.279759977485792e+02,
		7.332482810483301e+02,		7.382503264451452e+02,		7.430107332010579e+02,		7.475536888657524e+02,		7.518998382082482e+02,
		7.560669489605983e+02,		7.600704284241278e+02,		7.639237290460056e+02,		7.676386702611284e+02,		7.712256964312745e+02,
		7.746940854800702e+02,		7.780521190993064e+02,		7.813072227188472e+02,		7.844660814745620e+02,		7.875347369645873e+02,
		7.905186685077281e+02,		7.934228618076346e+02,		7.962518673110679e+02,		7.990098500772958e+02,		8.017006326117723e+02,
		8.043277318340722e+02,		8.068943911282774e+02,		8.094036082487916e+02,		8.118581597156585e+02,		8.142606222221762e+02,
		8.166133914883283e+02,		8.189186989212635e+02,		8.211786263852479e+02,		8.233951193355873e+02,		8.255699985314593e+02,
		8.277049705100726e+02,		8.298016369775809e+02,		8.318615032496116e+02,		8.338859858555222e+02,		8.358764194046107e+02,
		8.378340627992440e+02,		8.397601048685073e+02,		8.416556694864348e+02,		8.435218202307113e+02,		8.453595646306601e+02,
		8.471698580474663e+02,		8.489536072242553e+02,		8.507116735393315e+02,		8.524448759919086e+02,		8.541539939463748e+02,
		8.558397696581782e+02,		8.575029106018937e+02,		8.591440916197741e+02,		8.607639569071649e+02,		8.623631218494122e+02,
		8.639421747233944e+02,		8.655016782754763e+02,		8.670421711864677e+02,		8.685641694331822e+02,		8.700681675551841e+02,
		8.715546398345411e+02,		8.730240413956427e+02,		8.744768092314763e+02,		8.759133631621712e+02,		8.773341067310942e+02,
		8.787394280433110e+02,		8.801297005507722e+02,		8.815052837882512e+02,		8.828665240636670e+02,		8.842137551061339e+02,
		8.855472986748111e+02,		8.868674651313397e+02,		8.881745539784529e+02,		8.894688543671233e+02,		8.907506455744057e+02,
		8.920201974540070e+02,		8.932777708613954e+02,		8.945236180551706e+02,		8.957579830762581e+02,		8.969811021063742e+02,
		8.981932038071160e+02,		8.993945096408970e+02,		9.005852341749020e+02,		9.017655853691056e+02,		9.029357648493625e+02,
		9.040959681664706e+02,		9.052463850420767e+02,		9.063871996021987e+02,		9.075185905991297e+02,		9.086407316223806e+02,
		9.097537912993300e+02,		9.108579334861575e+02,		9.119533174496357e+02,		9.130400980402844e+02,		9.141184258573919e+02,
		9.151884474063411e+02,		9.162503052486834e+02,		9.173041381453345e+02,		9.183500811933035e+02,		9.193882659562541e+02,
		9.204188205892824e+02,		9.214418699581689e+02,		9.224575357534286e+02,		9.234659365994147e+02,		9.244671881587320e+02,
		9.254614032322042e+02,		9.264486918546231e+02,		9.274291613864831e+02,		9.284029166019060e+02,		9.293700597729494e+02,
		9.303306907504734e+02,		9.312849070417259e+02,		9.322328038848211e+02,		9.331744743202353e+02,		9.341100092594986e+02,
		9.350394975511759e+02,		9.359630260442890e+02,		9.368806796492919e+02,		9.377925413967110e+02,		9.386986924935611e+02,
		9.395992123776244e+02,		9.404941787697160e+02,		9.413836677239981e+02,		9.422677536764440e+02,		9.431465094915311e+02,
		9.440200065072396e+02,		9.448883145784326e+02,		9.457515021186847e+02,		9.466096361406239e+02,		9.474627822948561e+02,
		9.483110049075294e+02,		9.491543670165894e+02,		9.499929304067911e+02,		9.508267556435104e+02,		9.516559021054048e+02,
		9.524804280159722e+02,		9.533003904740589e+02,		9.541158454833457e+02,		9.549268479808617e+02,		9.557334518645629e+02,
		9.565357100200163e+02,		9.573336743462067e+02,		9.581273957805397e+02,		9.589169243230110e+02,		9.597023090596434e+02,
		9.604835981851626e+02,		9.612608390249731e+02,		9.620340780564464e+02,		9.628033609295574e+02,		9.635687324868813e+02,
		9.643302367829790e+02,		9.650879171032072e+02,		9.658418159819466e+02,		9.665919752202966e+02,		9.673384359032351e+02,
		9.680812384162809e+02,		9.688204224616561e+02,		9.695560270739855e+02,		9.702880906355373e+02,		9.710166508910246e+02,
		9.717417449619808e+02,		9.724634093607316e+02,		9.731816800039637e+02,		9.738965922259204e+02,		9.746081807912177e+02,
		9.753164799073155e+02,		9.760215232366346e+02,		9.767233439083479e+02,		9.774219745298437e+02,		9.781174471978808e+02,
		9.788097935094399e+02,		9.794990445722921e+02,		9.801852310152702e+02,		9.808683829982808e+02,		9.815485302220463e+02,
		9.822257019375917e+02,		9.828999269554807e+02,		9.835712336548236e+02,		9.842396499920353e+02,		9.849052035093828e+02,
		9.855679213433083e+02,		9.862278302325411e+02,		9.868849565260058e+02,		9.875393261905323e+02,		9.881909648183688e+02,
		9.888398976345161e+02,		9.894861495038714e+02,		9.901297449382041e+02,		9.907707081029588e+02,		9.914090628238854e+02,
		9.920448325935217e+02,		9.926780405775103e+02,		9.933087096207646e+02,		9.939368622534962e+02,		9.945625206970868e+02,
		9.951857068698282e+02,		9.958064423925347e+02,		9.964247485940060e+02,		9.970406465163835e+02,		9.976541569203658e+02,
		9.982653002903166e+02,		9.988740968392473e+02,		9.994805665136897e+02,		1.000084728998459e+03,		1.000686603721307e+03,
		1.001286209857471e+03,		1.001883566334121e+03,		1.002478691834712e+03,		1.003071604803231e+03,		1.003662323448361e+03,
		1.004250865747546e+03,		1.004837249450967e+03,		1.005421492085442e+03,		1.006003610958225e+03,		1.006583623160737e+03,
		1.007161545572213e+03,		1.007737394863264e+03,		1.008311187499377e+03,		1.008882939744332e+03,		1.009452667663540e+03,
		1.010020387127336e+03,		1.010586113814171e+03,		1.011149863213761e+03,		1.011711650630165e+03,		1.012271491184796e+03,
		1.012829399819371e+03,		1.013385391298802e+03,		1.013939480214033e+03,		1.014491680984811e+03,		1.015042007862408e+03,
		1.015590474932281e+03,		1.016137096116691e+03,		1.016681885177254e+03,		1.017224855717456e+03,		1.017766021185111e+03,
		1.018305394874771e+03,		1.018842989930090e+03,		1.019378819346142e+03,		1.019912895971697e+03,		1.020445232511444e+03,
		1.020975841528181e+03,		1.021504735444961e+03,		1.022031926547192e+03,		1.022557426984700e+03,		1.023081248773756e+03,
		1.023603403799063e+03,		1.024123903815700e+03,		1.024642760451039e+03,		1.025159985206621e+03,		1.025675589459995e+03,
		1.026189584466531e+03,		1.026701981361191e+03,		1.027212791160272e+03,		1.027722024763117e+03,		1.028229692953794e+03,
		1.028735806402745e+03,		1.029240375668404e+03,		1.029743411198790e+03,		1.030244923333062e+03,		1.030744922303063e+03,
		1.031243418234813e+03,		1.031740421150002e+03,		1.032235940967436e+03,		1.032729987504464e+03,		1.033222570478385e+03,
		1.033713699507826e+03,		1.034203384114096e+03,		1.034691633722512e+03,		1.035178457663717e+03,		1.035663865174957e+03,
		1.036147865401352e+03,		1.036630467397129e+03,		1.037111680126852e+03,		1.037591512466615e+03,		1.038069973205228e+03,
		1.038547071045373e+03,		1.039022814604745e+03,		1.039497212417177e+03,		1.039970272933738e+03,		1.040442004523821e+03,
		1.040912415476209e+03,		1.041381514000124e+03,		1.041849308226260e+03,		1.042315806207793e+03,		1.042781015921389e+03,
		1.043244945268177e+03,		1.043707602074720e+03,		1.044168994093964e+03,		1.044629129006176e+03,		1.045088014419862e+03,
		1.045545657872674e+03,		1.046002066832301e+03,		1.046457248697344e+03,		1.046911210798187e+03,		1.047363960397837e+03,
		1.047815504692765e+03,		1.048265850813731e+03,		1.048715005826594e+03,		1.049162976733103e+03,		1.049609770471694e+03,
		1.050055393918254e+03,		1.050499853886889e+03,		1.050943157130668e+03,		1.051385310342364e+03,		1.051826320155184e+03,
		1.052266193143478e+03,		1.052704935823453e+03,		1.053142554653858e+03,		1.053579056036678e+03,		1.054014446317798e+03,
		1.054448731787673e+03,		1.054881918681983e+03,		1.055314013182269e+03,		1.055745021416576e+03,		1.056174949460077e+03,
		1.056603803335683e+03,		1.057031589014654e+03,		1.057458312417200e+03,		1.057883979413065e+03,		1.058308595822111e+03,
		1.058732167414889e+03,		1.059154699913202e+03,		1.059576198990664e+03,		1.059996670273244e+03,		1.060416119339812e+03,
		1.060834551722666e+03,		1.061251972908054e+03,		1.061668388336702e+03,		1.062083803404314e+03,		1.062498223462081e+03,
		1.062911653817171e+03,		1.063324099733224e+03,		1.063735566430829e+03,		1.064146059088002e+03,		1.064555582840654e+03,
		1.064964142783051e+03,		1.065371743968275e+03,		1.065778391408667e+03,		1.066184090076274e+03,		1.066588844903286e+03,
		1.066992660782466e+03,		1.067395542567577e+03,		1.067797495073799e+03,		1.068198523078146e+03,		1.068598631319871e+03,
		1.068997824500872e+03,		1.069396107286087e+03,		1.069793484303886e+03,		1.070189960146460e+03,		1.070585539370200e+03,
		1.070980226496076e+03,		1.071374026010006e+03,		1.071766942363227e+03,		1.072158979972649e+03,		1.072550143221222e+03,
		1.072940436458280e+03,		1.073329863999894e+03,		1.073718430129211e+03,		1.074106139096800e+03,		1.074492995120977e+03,
		1.074879002388140e+03,		1.075264165053100e+03,		1.075648487239390e+03,		1.076031973039595e+03,		1.076414626515659e+03,
		1.076796451699193e+03,		1.077177452591787e+03,		1.077557633165306e+03,		1.077936997362190e+03,		1.078315549095748e+03,
		1.078693292250448e+03,		1.079070230682206e+03,		1.079446368218662e+03,		1.079821708659470e+03,		1.080196255776567e+03,
		1.080570013314445e+03,		1.080942984990427e+03,		1.081315174494927e+03,		1.081686585491713e+03,		1.082057221618172e+03,
		1.082427086485557e+03,		1.082796183679251e+03,		1.083164516759008e+03,		1.083532089259203e+03,		1.083898904689081e+03,
		1.084264966532989e+03,		1.084630278250621e+03,		1.084994843277252e+03,		1.085358665023969e+03,		1.085721746877900e+03,
		1.086084092202444e+03,		1.086445704337493e+03,		1.086806586599655e+03,		1.087166742282470e+03,		1.087526174656630e+03,
		1.087884886970192e+03,		1.088242882448786e+03,		1.088600164295827e+03,		1.088956735692724e+03,		1.089312599799076e+03,
		1.089667759752879e+03,		1.090022218670727e+03,		1.090375979648004e+03,		1.090729045759081e+03,		1.091081420057509e+03,
		1.091433105576208e+03,		1.091784105327655e+03,		1.092134422304070e+03,		1.092484059477600e+03,		1.092833019800501e+03,
		1.093181306205317e+03,		1.093528921605056e+03,		1.093875868893369e+03,		1.094222150944719e+03,		1.094567770614557e+03,
		1.094912730739488e+03,		1.095257034137441e+03,		1.095600683607834e+03,		1.095943681931737e+03,		1.096286031872037e+03,
		1.096627736173595e+03,		1.096968797563406e+03,		1.097309218750757e+03,		1.097649002427379e+03,		1.097988151267604e+03,
		1.098326667928513e+03,		1.098664555050090e+03,		1.099001815255368e+03,		1.099338451150574e+03,		1.099674465325278e+03,
		1.100009860352535e+03,		1.100344638789024e+03,		1.100678803175196e+03,		1.101012356035403e+03,		1.101345299878044e+03,
		1.101677637195697e+03,		1.102009370465252e+03,		1.102340502148051e+03,		1.102671034690009e+03,		1.103000970521757e+03,
		1.103330312058755e+03,		1.103659061701438e+03,		1.103987221835327e+03,		1.104314794831160e+03,		1.104641783045018e+03
	},
	{
		1.700699759733023e+00,		5.149935628785823e+00,		8.660582292083715e+00,		1.223538501177344e+01,		1.587728861577066e+01,
		1.958945741641003e+01,		2.337529769776037e+01,		2.723848318376398e+01,		3.118298397924372e+01,		3.521309957400636e+01,
		3.933349662162701e+01,		4.354925235538531e+01,		4.786590469260147e+01,		5.228951031636359e+01,		5.682671232514519e+01,
		6.148481942601407e+01,		6.627189914313308e+01,		7.119688815724189e+01,		7.626972373537619e+01,		8.150150132553161e+01,
		8.690466488087584e+01,		9.249323848971386e+01,		9.828311063501467e+01,		1.042923862072339e+02,		1.105418267206293e+02,
		1.170554067591091e+02,		1.238610256249327e+02,		1.309914292587552e+02,		1.384854216164562e+02,		1.463894815875585e+02,
		1.547599593154996e+02,		1.636661185911254e+02,		1.731944454003799e+02,		1.834549044822612e+02,		1.945902885452765e+02,
		2.067906555364611e+02,		2.203164802748307e+02,		2.355374077631400e+02,		2.530002400330130e+02,		2.735537207205669e+02,
		2.985826813845939e+02,		3.304156293720706e+02,		3.727740737231317e+02,		4.293373026472401e+02,		4.900220093223569e+02,
		5.384485947366619e+02,		5.728793624796715e+02,		5.982015391535543e+02,		6.179903450479158e+02,		6.341703676018076e+02,
		6.478401691202380e+02,		6.596762580195596e+02,		6.701201459975861e+02,		6.794737065703416e+02,		6.879514463682846e+02,
		6.957107723923709e+02,		7.028703535878883e+02,		7.095217256742495e+02,		7.157368938836994e+02,		7.215734719281238e+02,
		7.270782510375658e+02,		7.322897377228896e+02,		7.372399957562035e+02,		7.419560075842303e+02,		7.464606968980240e+02,
		7.507737078790560e+02,		7.549120068411725e+02,		7.588903523222685e+02,		7.627216664334627e+02,		7.664173311862282e+02,
		7.699874271800352e+02,		7.734409275459341e+02,		7.767858568215331e+02,		7.800294220931677e+02,		7.831781220213825e+02,
		7.862378380886989e+02,		7.892139114505998e+02,		7.921112080452986e+02,		7.949341740642490e+02,		7.976868834589119e+02,
		8.003730788286966e+02,		8.029962067766188e+02,		8.055594486158659e+02,		8.080657471495111e+02,		8.105178301172593e+02,
		8.129182308002411e+02,		8.152693061918401e+02,		8.175732530753683e+02,		8.198321222944029e+02,		8.220478314567854e+02,
		8.242221762762202e+02,		8.263568407247817e+02,		8.284534061442541e+02,		8.305133594429667e+02,		8.325381004869882e+02,
		8.345289487796114e+02,		8.364871495103625e+02,		8.384138790441156e+02,		8.403102499117101e+02,		8.421773153557264e+02,
		8.440160734783847e+02,		8.458274710328176e+02,		8.476124068940084e+02,		8.493717352414479e+02,		8.511062684818330e+02,
		8.528167799369228e+02,		8.545040063189050e+02,		8.561686500130943e+02,		8.578113811857336e+02,		8.594328397327092e+02,
		8.610336370834012e+02,		8.626143578723720e+02,		8.641755614903533e+02,		8.657177835248231e+02,		8.672415370994501e+02,
		8.687473141208184e+02,		8.702355864399822e+02,		8.717068069357582e+02,		8.731614105259540e+02,		8.745998151122243e+02,
		8.760224224636762e+02,		8.774296190439371e+02,		8.788217767859402e+02,		8.801992538183473e+02,		8.815623951471711e+02,
		8.829115332958561e+02,		8.842469889068253e+02,		8.855690713072192e+02,		8.868780790413546e+02,		8.881743003722225e+02,
		8.894580137541458e+02,		8.907294882785603e+02,		8.919889840947311e+02,		8.932367528070695e+02,		8.944730378505888e+02,
		8.956980748459282e+02,		8.969120919352514e+02,		8.981153101002508e+02,		8.993079434633805e+02,		9.004901995733652e+02,
		9.016622796759625e+02,		9.028243789708758e+02,		9.039766868556571e+02,		9.051193871573967e+02,		9.062526583528914e+02,
		9.073766737780132e+02,		9.084916018268693e+02,		9.095976061413734e+02,		9.106948457917510e+02,		9.117834754485178e+02,
		9.128636455463896e+02,		9.139355024405924e+02,		9.149991885559635e+02,		9.160548425292759e+02,		9.171025993451225e+02,
		9.181425904657159e+02,		9.191749439549345e+02,		9.201997845969075e+02,		9.212172340094382e+02,		9.222274107525153e+02,
		9.232304304321831e+02,		9.242264057999986e+02,		9.252154468482956e+02,		9.261976609014773e+02,		9.271731527035264e+02,
		9.281420245019115e+02,		9.291043761280978e+02,		9.300603050747858e+02,		9.310099065700633e+02,		9.319532736486148e+02,
		9.328904972201182e+02,		9.338216661349647e+02,		9.347468672474391e+02,		9.356661854764602e+02,		9.365797038639995e+02,
		9.374875036312976e+02,		9.383896642329540e+02,		9.392862634090087e+02,		9.401773772350866e+02,		9.410630801707066e+02,
		9.419434451058289e+02,		9.428185434057091e+02,		9.436884449541486e+02,		9.445532181952004e+02,		9.454129301733980e+02,
		9.462676465725664e+02,		9.471174317532900e+02,		9.479623487890698e+02,		9.488024595012425e+02,		9.496378244927124e+02,
		9.504685031805282e+02,		9.512945538273711e+02,		9.521160335719906e+02,		9.529329984586227e+02,		9.537455034654469e+02,
		9.545536025321007e+02,		9.553573485863122e+02,		9.561567935696604e+02,		9.569519884625129e+02,		9.577429833081731e+02,
		9.585298272362570e+02,		9.593125684853352e+02,		9.600912544248729e+02,		9.608659315764814e+02,		9.616366456345161e+02,
		9.624034414860498e+02,		9.631663632302309e+02,		9.639254541970521e+02,		9.646807569655690e+02,		9.654323133815614e+02,
		9.661801645746742e+02,		9.669243509750571e+02,		9.676649123295057e+02,		9.684018877171501e+02,		9.691353155646688e+02,
		9.698652336610761e+02,		9.705916791720892e+02,		9.713146886540774e+02,		9.720342980676253e+02,		9.727505427907079e+02,
		9.734634576315036e+02,		9.741730768408499e+02,		9.748794341243524e+02,		9.755825626541630e+02,		9.762824950804427e+02,
		9.769792635425007e+02,		9.776728996796440e+02,		9.783634346417380e+02,		9.790508990994674e+02,		9.797353232543500e+02,
		9.804167368484674e+02,		9.810951691739505e+02,		9.817706490822135e+02,		9.824432049929475e+02,		9.831128649028896e+02,
		9.837796563943562e+02,		9.844436066435671e+02,		9.851047424287564e+02,		9.857630901380749e+02,		9.864186757773010e+02,
		9.870715249773524e+02,		9.877216630016154e+02,		9.883691147530927e+02,		9.890139047813742e+02,		9.896560572894383e+02,
		9.902955961402871e+02,		9.909325448634230e+02,		9.915669266611698e+02,		9.921987644148321e+02,		9.928280806907308e+02,
		9.934548977460703e+02,		9.940792375346811e+02,		9.947011217126291e+02,		9.953205716436842e+02,		9.959376084046738e+02,
		9.965522527907016e+02,		9.971645253202522e+02,		9.977744462401797e+02,		9.983820355305807e+02,		9.989873129095529e+02,
		9.995902978378576e+02,		1.000191009523464e+03,		1.000789466926002e+03,		1.001385688761110e+03,		1.001979693504693e+03,
		1.002571499397079e+03,		1.003161124447087e+03,		1.003748586436011e+03,		1.004333902921514e+03,		1.004917091241435e+03,
		1.005498168517517e+03,		1.006077151659056e+03,		1.006654057366471e+03,		1.007228902134799e+03,		1.007801702257112e+03,
		1.008372473827871e+03,		1.008941232746198e+03,		1.009507994719094e+03,		1.010072775264574e+03,		1.010635589714751e+03,
		1.011196453218850e+03,		1.011755380746159e+03,		1.012312387088928e+03,		1.012867486865195e+03,		1.013420694521571e+03,
		1.013972024335957e+03,		1.014521490420213e+03,		1.015069106722766e+03,		1.015614887031181e+03,		1.016158844974663e+03,
		1.016700994026523e+03,		1.017241347506588e+03,		1.017779918583572e+03,		1.018316720277389e+03,		1.018851765461435e+03,
		1.019385066864815e+03,		1.019916637074527e+03,		1.020446488537619e+03,		1.020974633563284e+03,		1.021501084324933e+03,
		1.022025852862212e+03,		1.022548951083001e+03,		1.023070390765359e+03,		1.023590183559435e+03,		1.024108340989356e+03,
		1.024624874455061e+03,		1.025139795234118e+03,		1.025653114483497e+03,		1.026164843241315e+03,		1.026674992428549e+03,
		1.027183572850713e+03,		1.027690595199517e+03,		1.028196070054478e+03,		1.028700007884519e+03,		1.029202419049527e+03,
		1.029703313801894e+03,		1.030202702288020e+03,		1.030700594549795e+03,		1.031197000526059e+03,		1.031691930054024e+03,
		1.032185392870687e+03,		1.032677398614204e+03,		1.033167956825247e+03,		1.033657076948338e+03,		1.034144768333162e+03,
		1.034631040235846e+03,		1.035115901820233e+03,		1.035599362159119e+03,		1.036081430235478e+03,		1.036562114943666e+03,
		1.037041425090598e+03,		1.037519369396912e+03,		1.037995956498114e+03,		1.038471194945691e+03,		1.038945093208232e+03,
		1.039417659672496e+03,		1.039888902644494e+03,		1.040358830350531e+03,		1.040827450938245e+03,		1.041294772477620e+03,
		1.041760802961985e+03,		1.042225550309003e+03,		1.042689022361631e+03,		1.043151226889080e+03,		1.043612171587746e+03,
		1.044071864082135e+03,		1.044530311925765e+03,		1.044987522602068e+03,		1.045443503525262e+03,		1.045898262041215e+03,
		1.046351805428296e+03,		1.046804140898220e+03,		1.047255275596860e+03,		1.047705216605072e+03,		1.048153970939483e+03,
		1.048601545553285e+03,		1.049047947337007e+03,		1.049493183119274e+03,		1.049937259667566e+03,		1.050380183688950e+03,
		1.050821961830811e+03,		1.051262600681572e+03,		1.051702106771395e+03,		1.052140486572877e+03,		1.052577746501742e+03,
		1.053013892917508e+03,		1.053448932124155e+03,		1.053882870370779e+03,		1.054315713852239e+03,		1.054747468709790e+03,
		1.055178141031710e+03,		1.055607736853920e+03,		1.056036262160585e+03,		1.056463722884722e+03,		1.056890124908782e+03,
		1.057315474065235e+03,		1.057739776137146e+03,		1.058163036858735e+03,		1.058585261915935e+03,		1.059006456946949e+03,
		1.059426627542774e+03,		1.059845779247753e+03,		1.060263917560087e+03,		1.060681047932358e+03,		1.061097175772042e+03,
		1.061512306442010e+03,		1.061926445261024e+03,		1.062339597504230e+03,		1.062751768403635e+03,		1.063162963148591e+03,
		1.063573186886257e+03,		1.063982444722064e+03,		1.064390741720174e+03,		1.064798082903929e+03,		1.065204473256293e+03,
		1.065609917720294e+03,		1.066014421199450e+03,		1.066417988558201e+03,		1.066820624622326e+03,		1.067222334179359e+03,
		1.067623121978996e+03,		1.068022992733501e+03,		1.068421951118104e+03,		1.068820001771389e+03,		1.069217149295689e+03,
		1.069613398257463e+03,		1.070008753187675e+03,		1.070403218582165e+03,		1.070796798902019e+03,		1.071189498573927e+03,
		1.071581321990546e+03,		1.071972273510851e+03,		1.072362357460481e+03,		1.072751578132086e+03,		1.073139939785665e+03,
		1.073527446648902e+03,		1.073914102917494e+03,		1.074299912755483e+03,		1.074684880295571e+03,		1.075069009639446e+03,
		1.075452304858087e+03,		1.075834769992084e+03,		1.076216409051935e+03,		1.076597226018354e+03,		1.076977224842567e+03,
		1.077356409446611e+03,		1.077734783723614e+03,		1.078112351538095e+03,		1.078489116726242e+03,		1.078865083096190e+03,
		1.079240254428301e+03,		1.079614634475436e+03,		1.079988226963226e+03,		1.080361035590337e+03,		1.080733064028733e+03,
		1.081104315923937e+03,		1.081474794895288e+03,		1.081844504536194e+03,		1.082213448414382e+03,		1.082581630072149e+03,
		1.082949053026599e+03,		1.083315720769893e+03,		1.083681636769484e+03,		1.084046804468351e+03,		1.084411227285232e+03,
		1.084774908614861e+03,		1.085137851828185e+03,		1.085500060272598e+03,		1.085861537272155e+03,		1.086222286127797e+03,
		1.086582310117567e+03,		1.086941612496822e+03,		1.087300196498445e+03,		1.087658065333056e+03,		1.088015222189219e+03,
		1.088371670233644e+03,		1.088727412611390e+03,		1.089082452446064e+03,		1.089436792840021e+03,		1.089790436874555e+03,
		1.090143387610097e+03,		1.090495648086399e+03,		1.090847221322725e+03,		1.091198110318042e+03,		1.091548318051197e+03,
		1.091897847481101e+03,		1.092246701546914e+03,		1.092594883168213e+03,		1.092942395245178e+03,		1.093289240658758e+03,
		1.093635422270849e+03,		1.093980942924459e+03,		1.094325805443878e+03,		1.094670012634846e+03,		1.095013567284714e+03,
		1.095356472162608e+03,		1.095698730019591e+03,		1.096040343588820e+03,		1.096381315585703e+03,		1.096721648708056e+03,
		1.097061345636255e+03,		1.097400409033390e+03,		1.097738841545411e+03,		1.098076645801283e+03,		1.098413824413129e+03,
		1.098750379976376e+03,		1.099086315069898e+03,		1.099421632256160e+03,		1.099756334081359e+03,		1.100090423075562e+03,
		1.100423901752844e+03,		1.100756772611424e+03,		1.101089038133801e+03,		1.101420700786885e+03,		1.101751763022134e+03,
		1.102082227275677e+03,		1.102412095968450e+03,		1.102741371506320e+03,		1.103070056280211e+03,		1.103398152666233e+03
	},
	{
		1.697378474789211e+00,		5.139586621176883e+00,		8.642664676299040e+00,		1.220931051623839e+01,		1.584241630990399e+01,
		1.954508770542461e+01,		2.332066546202147e+01,		2.717274991490189e+01,		3.110522873484877e+01,		3.512230853506214e+01,
		3.922855098983524e+01,		4.342891426853079e+01,		4.772880076155339e+01,		5.213411229246633e+01,		5.665131428521815e+01,
		6.128751070524162e+01,		6.605053204180902e+01,		7.094903917901121e+01,		7.599264675896357e+01,		8.119207063584945e+01,
		8.655930534129784e+01,		9.210783925595130e+01,		9.785291759024817e+01,		1.038118665848443e+02,		1.100044969418850e+02,
		1.164536109872276e+02,		1.231856473533829e+02,		1.302315104902409e+02,		1.376276523316009e+02,		1.454175036811347e+02,
		1.536533995290210e+02,		1.623992161931030e+02,		1.717340576295495e+02,		1.817575275410571e+02,		1.925974670062900e+02,
		2.044216484741390e+02,		2.174560447217757e+02,		2.320144433725212e+02,		2.485483764719155e+02,		2.677343907391435e+02,
		2.906288055325422e+02,		3.189242511430836e+02,		3.552409162983372e+02,		4.028220747171575e+02,		4.597675787800507e+02,
		5.117487954938888e+02,		5.515147422471350e+02,		5.807230610737859e+02,		6.031399952177328e+02,		6.211857516749301e+02,
		6.362431672728761e+02,		6.491494861816140e+02,		6.604433860604814e+02,		6.704885235082387e+02,		6.795402958220621e+02,
		6.877841354846556e+02,		6.953585220903320e+02,		7.023693779386716e+02,		7.088994021656709e+02,		7.150143188144912e+02,
		7.207671780002369e+02,		7.262013903443798e+02,		7.313529142062076e+02,		7.362518622980659e+02,		7.409237017120525e+02,
		7.453901637383736e+02,		7.496699429975288e+02,		7.537792412761185e+02,		7.577321953145688e+02,		7.615412167892300e+02,
		7.652172650962744e+02,		7.687700681654591e+02,		7.722083026875783e+02,		7.755397423569954e+02,		7.787713806927296e+02,
		7.819095334929031e+02,		7.849599248490904e+02,		7.879277597955488e+02,		7.908177860198712e+02,		7.936343465638494e+02,
		7.963814250582325e+02,		7.990626847349522e+02,		8.016815022248747e+02,		8.042409969631469e+02,		8.067440568762130e+02,
		8.091933609064116e+02,		8.115913988348182e+02,		8.139404887861405e+02,		8.162427927367743e+02,		8.185003302960977e+02,
		8.207149909889830e+02,		8.228885452328570e+02,		8.250226541739274e+02,		8.271188785232197e+02,		8.291786865130803e+02,
		8.312034610779757e+02,		8.331945063493355e+02,		8.351530535420698e+02,		8.370802663003693e+02,		8.389772455616567e+02,
		8.408450339901102e+02,		8.426846200249475e+02,		8.444969415830799e+02,		8.462828894510867e+02,		8.480433103973771e+02,
		8.497790100318476e+02,		8.514907554372900e+02,		8.531792775940845e+02,		8.548452736173971e+02,		8.564894088240301e+02,
		8.581123186442397e+02,		8.597146103922912e+02,		8.612968649080734e+02,		8.628596380808777e+02,		8.644034622653302e+02,
		8.659288475984982e+02,		8.674362832263317e+02,		8.689262384467825e+02,		8.703991637763270e+02,		8.718554919459315e+02,
		8.732956388319724e+02,		8.747200043271538e+02,		8.761289731559577e+02,		8.775229156388344e+02,		8.789021884089095e+02,
		8.802671350847207e+02,		8.816180869021513e+02,		8.829553633084985e+02,		8.842792725213542e+02,		8.855901120547539e+02,
		8.868881692148784e+02,		8.881737215673734e+02,		8.894470373782196e+02,		8.907083760299183e+02,		8.919579884146360e+02,
		8.931961173057986e+02,		8.944229977095657e+02,		8.956388571974362e+02,		8.968439162212119e+02,		8.980383884114186e+02,
		8.992224808602110e+02,		9.003963943897234e+02,		9.015603238067450e+02,		9.027144581445551e+02,		9.038589808926786e+02,
		9.049940702152809e+02,		9.061198991588677e+02,		9.072366358499116e+02,		9.083444436829827e+02,		9.094434814999262e+02,
		9.105339037605999e+02,		9.116158607056256e+02,		9.126894985116237e+02,		9.137549594393125e+02,		9.148123819748979e+02,
		9.158619009650834e+02,		9.169036477460571e+02,		9.179377502667760e+02,		9.189643332068447e+02,		9.199835180892725e+02,
		9.209954233883653e+02,		9.220001646330193e+02,		9.229978545056318e+02,		9.239886029368607e+02,		9.249725171964459e+02,
		9.259497019802621e+02,		9.269202594938274e+02,		9.278842895324095e+02,		9.288418895579052e+02,		9.297931547726508e+02,
		9.307381781903052e+02,		9.316770507039487e+02,		9.326098611515223e+02,		9.335366963787372e+02,		9.344576412995699e+02,
		9.353727789544491e+02,		9.362821905662431e+02,		9.371859555941561e+02,		9.380841517856027e+02,		9.389768552261846e+02,
		9.398641403878178e+02,		9.407460801751171e+02,		9.416227459701092e+02,		9.424942076753325e+02,		9.433605337554109e+02,
		9.442217912771580e+02,		9.450780459482712e+02,		9.459293621546790e+02,		9.467758029966053e+02,		9.476174303233828e+02,
		9.484543047670900e+02,		9.492864857750449e+02,		9.501140316412124e+02,		9.509369995365523e+02,		9.517554455383771e+02,
		9.525694246587307e+02,		9.533789908718428e+02,		9.541841971406989e+02,		9.549850954427387e+02,		9.557817367947507e+02,
		9.565741712769590e+02,		9.573624480563529e+02,		9.581466154092876e+02,		9.589267207433783e+02,		9.597028106187108e+02,
		9.604749307684068e+02,		9.612431261185577e+02,		9.620074408075453e+02,		9.627679182047910e+02,		9.635246009289335e+02,
		9.642775308654632e+02,		9.650267491838459e+02,		9.657722963541254e+02,		9.665142121630550e+02,		9.672525357297495e+02,
		9.679873055208890e+02,		9.687185593654857e+02,		9.694463344692299e+02,		9.701706674284230e+02,		9.708915942435267e+02,
		9.716091503323216e+02,		9.723233705427075e+02,		9.730342891651445e+02,		9.737419399447474e+02,		9.744463560930623e+02,
		9.751475702995059e+02,		9.758456147425028e+02,		9.765405211003264e+02,		9.772323205616397e+02,		9.779210438357661e+02,
		9.786067211626799e+02,		9.792893823227398e+02,		9.799690566461617e+02,		9.806457730222477e+02,		9.813195599083807e+02,
		9.819904453387794e+02,		9.826584569330316e+02,		9.833236219044155e+02,		9.839859670679996e+02,		9.846455188485520e+02,
		9.853023032882379e+02,		9.859563460541348e+02,		9.866076724455544e+02,		9.872563074011954e+02,		9.879022755061011e+02,
		9.885456009984687e+02,		9.891863077762800e+02,		9.898244194037717e+02,		9.904599591177589e+02,		9.910929498338011e+02,
		9.917234141522196e+02,		9.923513743639774e+02,		9.929768524564178e+02,		9.935998701188740e+02,		9.942204487481333e+02,
		9.948386094537964e+02,		9.954543730634912e+02,		9.960677601279808e+02,		9.966787909261488e+02,		9.972874854698784e+02,
		9.978938635088057e+02,		9.984979445349855e+02,		9.990997477874354e+02,		9.996992922565901e+02,		1.000296596688650e+03,
		1.000891679589837e+03,		1.001484559230556e+03,		1.002075253649464e+03,		1.002663780657453e+03,		1.003250157841542e+03,
		1.003834402568694e+03,		1.004416531989533e+03,		1.004996563042011e+03,		1.005574512454960e+03,		1.006150396751600e+03,
		1.006724232252960e+03,		1.007296035081222e+03,		1.007865821163008e+03,		1.008433606232583e+03,		1.008999405835010e+03,
		1.009563235329221e+03,		1.010125109891039e+03,		1.010685044516129e+03,		1.011243054022901e+03,		1.011799153055336e+03,
		1.012353356085767e+03,		1.012905677417608e+03,		1.013456131188014e+03,		1.014004731370504e+03,		1.014551491777517e+03,
		1.015096426062929e+03,		1.015639547724514e+03,		1.016180870106361e+03,		1.016720406401239e+03,		1.017258169652917e+03,
		1.017794172758447e+03,		1.018328428470389e+03,		1.018860949399006e+03,		1.019391748014413e+03,		1.019920836648674e+03,
		1.020448227497884e+03,		1.020973932624182e+03,		1.021497963957754e+03,		1.022020333298775e+03,		1.022541052319329e+03,
		1.023060132565293e+03,		1.023577585458176e+03,		1.024093422296934e+03,		1.024607654259748e+03,		1.025120292405769e+03,
		1.025631347676833e+03,		1.026140830899139e+03,		1.026648752784911e+03,		1.027155123934008e+03,		1.027659954835527e+03,
		1.028163255869363e+03,		1.028665037307747e+03,		1.029165309316757e+03,		1.029664081957797e+03,		1.030161365189059e+03,
		1.030657168866948e+03,		1.031151502747496e+03,		1.031644376487736e+03,		1.032135799647061e+03,		1.032625781688566e+03,
		1.033114331980348e+03,		1.033601459796801e+03,		1.034087174319883e+03,		1.034571484640357e+03,		1.035054399759019e+03,
		1.035535928587898e+03,		1.036016079951441e+03,		1.036494862587675e+03,		1.036972285149350e+03,		1.037448356205065e+03,
		1.037923084240372e+03,		1.038396477658864e+03,		1.038868544783247e+03,		1.039339293856385e+03,		1.039808733042342e+03,
		1.040276870427397e+03,		1.040743714021043e+03,		1.041209271756976e+03,		1.041673551494057e+03,		1.042136561017277e+03,
		1.042598308038683e+03,		1.043058800198305e+03,		1.043518045065071e+03,		1.043976050137687e+03,		1.044432822845532e+03,
		1.044888370549513e+03,		1.045342700542922e+03,		1.045795820052271e+03,		1.046247736238124e+03,		1.046698456195903e+03,
		1.047147986956690e+03,		1.047596335488019e+03,		1.048043508694647e+03,		1.048489513419320e+03,		1.048934356443522e+03,
		1.049378044488219e+03,		1.049820584214588e+03,		1.050261982224730e+03,		1.050702245062386e+03,		1.051141379213625e+03,
		1.051579391107538e+03,		1.052016287116904e+03,		1.052452073558867e+03,		1.052886756695582e+03,		1.053320342734868e+03,
		1.053752837830839e+03,		1.054184248084539e+03,		1.054614579544549e+03,		1.055043838207605e+03,		1.055472030019193e+03,
		1.055899160874141e+03,		1.056325236617206e+03,		1.056750263043640e+03,		1.057174245899762e+03,		1.057597190883515e+03,
		1.058019103645011e+03,		1.058439989787079e+03,		1.058859854865797e+03,		1.059278704391017e+03,		1.059696543826883e+03,
		1.060113378592348e+03,		1.060529214061672e+03,		1.060944055564924e+03,		1.061357908388472e+03,		1.061770777775462e+03,
		1.062182668926298e+03,		1.062593586999118e+03,		1.063003537110244e+03,		1.063412524334655e+03,		1.063820553706422e+03,
		1.064227630219168e+03,		1.064633758826494e+03,		1.065038944442421e+03,		1.065443191941811e+03,		1.065846506160790e+03,
		1.066248891897164e+03,		1.066650353910827e+03,		1.067050896924166e+03,		1.067450525622461e+03,		1.067849244654276e+03,
		1.068247058631847e+03,		1.068643972131471e+03,		1.069039989693873e+03,		1.069435115824589e+03,		1.069829354994328e+03,
		1.070222711639340e+03,		1.070615190161767e+03,		1.071006794930007e+03,		1.071397530279050e+03,		1.071787400510834e+03,
		1.072176409894582e+03,		1.072564562667132e+03,		1.072951863033276e+03,		1.073338315166082e+03,		1.073723923207220e+03,
		1.074108691267275e+03,		1.074492623426070e+03,		1.074875723732970e+03,		1.075257996207192e+03,		1.075639444838106e+03,
		1.076020073585535e+03,		1.076399886380049e+03,		1.076778887123258e+03,		1.077157079688097e+03,		1.077534467919115e+03,
		1.077911055632751e+03,		1.078286846617614e+03,		1.078661844634755e+03,		1.079036053417937e+03,		1.079409476673905e+03,
		1.079782118082647e+03,		1.080153981297654e+03,		1.080525069946180e+03,		1.080895387629492e+03,		1.081264937923128e+03,
		1.081633724377137e+03,		1.082001750516325e+03,		1.082369019840506e+03,		1.082735535824731e+03,		1.083101301919526e+03,
		1.083466321551131e+03,		1.083830598121724e+03,		1.084194135009651e+03,		1.084556935569654e+03,		1.084919003133090e+03,
		1.085280341008150e+03,		1.085640952480080e+03,		1.086000840811394e+03,		1.086360009242084e+03,		1.086718460989831e+03,
		1.087076199250213e+03,		1.087433227196913e+03,		1.087789547981911e+03,		1.088145164735693e+03,		1.088500080567448e+03,
		1.088854298565260e+03,		1.089207821796302e+03,		1.089560653307029e+03,		1.089912796123363e+03,		1.090264253250885e+03,
		1.090615027675015e+03,		1.090965122361194e+03,		1.091314540255066e+03,		1.091663284282658e+03,		1.092011357350552e+03,
		1.092358762346062e+03,		1.092705502137407e+03,		1.093051579573876e+03,		1.093396997486003e+03,		1.093741758685731e+03,
		1.094085865966575e+03,		1.094429322103785e+03,		1.094772129854511e+03,		1.095114291957955e+03,		1.095455811135537e+03,
		1.095796690091044e+03,		1.096136931510786e+03,		1.096476538063749e+03,		1.096815512401746e+03,		1.097153857159563e+03,
		1.097491574955112e+03,		1.097828668389569e+03,		1.098165140047526e+03,		1.098500992497128e+03,		1.098836228290216e+03,
		1.099170849962467e+03,		1.099504860033533e+03,		1.099838261007173e+03,		1.100171055371393e+03,		1.100503245598579e+03,
		1.100834834145625e+03,		1.101165823454070e+03,		1.101496215950222e+03,		1.101826014045288e+03,		1.102155220135504e+03
	},
	{
		1.694070329831133e+00,		5.129280968340455e+00,		8.624826488817041e+00,		1.218335826571797e+01,		1.580771683915144e+01,
		1.950095039640017e+01,		2.326633558164281e+01,		2.710740099825305e+01,		3.102795383684526e+01,		3.503211014635092e+01,
		3.912432936881640e+01,		4.330945388644437e+01,		4.759275448836227e+01,		5.197998286349903e+01,		5.647743247645266e+01,
		6.109200950091013e+01,		6.583131589100395e+01,		7.070374719343405e+01,		7.571860838130094e+01,		8.088625187846301e+01,
		8.621824311654213e+01,		9.172756053260954e+01,		9.742883902760929e+01,		1.033386687865312e+02,		1.094759653391083e+02,
		1.158624323040987e+02,		1.225231461542439e+02,		1.294873037104491e+02,		1.367891897282510e+02,		1.444694467762699e+02,
		1.525767673828994e+02,		1.611701871396978e+02,		1.703222508816572e+02,		1.801234766277903e+02,		1.906887981153807e+02,
		2.021671096662436e+02,		2.147558258700778e+02,		2.287238098119926e+02,		2.444486885256791e+02,		2.624793498874457e+02,
		2.836414982970668e+02,		3.092052665843559e+02,		3.410787232721673e+02,		3.817406423969744e+02,		4.322515871834509e+02,
		4.845006260567967e+02,		5.283861030380584e+02,		5.617714471121047e+02,		5.871911565159735e+02,		6.073611399250888e+02,
		6.239840702007480e+02,		6.380879180374329e+02,		6.503257780489349e+02,		6.611336439331740e+02,		6.708145792647096e+02,
		6.795865106100816e+02,		6.876107454425697e+02,		6.950096810255783e+02,		7.018781926839110e+02,		7.082911922323908e+02,
		7.143087887774108e+02,		7.199799023781778e+02,		7.253448513151085e+02,		7.304372411968189e+02,		7.352853684465068e+02,
		7.399132792291446e+02,		7.443415795484311e+02,		7.485880627892298e+02,		7.526682014182535e+02,		7.565955362999171e+02,
		7.603819879384871e+02,		7.640381075446585e+02,		7.675732812608928e+02,		7.709958975888444e+02,		7.743134856599291e+02,
		7.775328302168700e+02,		7.806600678518300e+02,		7.837007680512809e+02,		7.866600018417514e+02,		7.895424002515542e+02,
		7.923522043568114e+02,		7.950933083325444e+02,		7.977692966576980e+02,		8.003834764084972e+02,		8.029389054044876e+02,
		8.054384168360106e+02,		8.078846408928783e+02,		8.102800238261931e+02,		8.126268448039360e+02,		8.149272308628161e+02,
		8.171831702111932e+02,		8.193965240987160e+02,		8.215690374357664e+02,		8.237023483189631e+02,		8.257979965963372e+02,
		8.278574315870791e+02,		8.298820190548147e+02,		8.318730475200286e+02,		8.338317339859132e+02,		8.357592291422462e+02,
		8.376566221037200e+02,		8.395249447320891e+02,		8.413651755854095e+02,		8.431782435325322e+02,		8.449650310664065e+02,
		8.467263773459352e+02,		8.484630809926934e+02,		8.501759026658884e+02,		8.518655674363738e+02,		8.535327669782430e+02,
		8.551781615946156e+02,		8.568023820924063e+02,		8.584060315194217e+02,		8.599896867757207e+02,		8.615539001099784e+02,
		8.630992005105861e+02,		8.646260950002095e+02,		8.661350698417244e+02,		8.676265916627165e+02,		8.691011085050189e+02,
		8.705590508051998e+02,		8.720008323113738e+02,		8.734268509412127e+02,		8.748374895856085e+02,		8.762331168620721e+02,
		8.776140878215616e+02,		8.789807446121562e+02,		8.803334171026801e+02,		8.816724234691370e+02,		8.829980707465743e+02,
		8.843106553487952e+02,		8.856104635581034e+02,		8.868977719871718e+02,		8.881728480148637e+02,		8.894359501977722e+02,
		8.906873286590723e+02,		8.919272254561565e+02,		8.931558749284357e+02,		8.943735040265655e+02,		8.955803326242725e+02,
		8.967765738138737e+02,		8.979624341864840e+02,		8.991381140978801e+02,		9.003038079208585e+02,		9.014597042849259e+02,
		9.026059863040567e+02,		9.037428317932395e+02,		9.048704134744489e+02,		9.059888991726759e+02,		9.070984520025596e+02,
		9.081992305461858e+02,		9.092913890225201e+02,		9.103750774489642e+02,		9.114504417954566e+02,		9.125176241315380e+02,
		9.135767627667456e+02,		9.146279923847201e+02,		9.156714441713362e+02,		9.167072459371934e+02,		9.177355222347439e+02,
		9.187563944703545e+02,		9.197699810115492e+02,		9.207763972896892e+02,		9.217757558983157e+02,		9.227681666873701e+02,
		9.237537368535175e+02,		9.247325710267276e+02,		9.257047713533480e+02,		9.266704375757873e+02,		9.276296671090166e+02,
		9.285825551140094e+02,		9.295291945682906e+02,		9.304696763337056e+02,		9.314040892215671e+02,		9.323325200552755e+02,
		9.332550537305503e+02,		9.341717732733680e+02,		9.350827598957148e+02,		9.359880930492590e+02,		9.368878504770200e+02,
		9.377821082631482e+02,		9.386709408808690e+02,		9.395544212386950e+02,		9.404326207249702e+02,		9.413056092508249e+02,
		9.421734552915975e+02,		9.430362259268045e+02,		9.438939868787076e+02,		9.447468025495391e+02,		9.455947360574513e+02,
		9.464378492712206e+02,		9.472762028437880e+02,		9.481098562446541e+02,		9.489388677911934e+02,		9.497632946789239e+02,
		9.505831930107780e+02,		9.513986178254079e+02,		9.522096231245717e+02,		9.530162618996297e+02,		9.538185861571895e+02,
		9.546166469439250e+02,		9.554104943706199e+02,		9.562001776354385e+02,		9.569857450464777e+02,		9.577672440436108e+02,
		9.585447212196558e+02,		9.593182223408986e+02,		9.600877923669815e+02,		9.608534754701956e+02,		9.616153150541841e+02,
		9.623733537720924e+02,		9.631276335441727e+02,		9.638781955748702e+02,		9.646250803694060e+02,		9.653683277498740e+02,
		9.661079768708728e+02,		9.668440662346892e+02,		9.675766337060318e+02,		9.683057165263652e+02,		9.690313513278226e+02,
		9.697535741467302e+02,		9.704724204367560e+02,		9.711879250816856e+02,		9.719001224078543e+02,		9.726090461962272e+02,
		9.733147296941532e+02,		9.740172056268023e+02,		9.747165062082853e+02,		9.754126631524806e+02,		9.761057076835718e+02,
		9.767956705463015e+02,		9.774825820159590e+02,		9.781664719080940e+02,		9.788473695879949e+02,		9.795253039799011e+02,
		9.802003035759956e+02,		9.808723964451426e+02,		9.815416102414313e+02,		9.822079722124765e+02,		9.828715092075236e+02,
		9.835322476853439e+02,		9.841902137219353e+02,		9.848454330180267e+02,		9.854979309064036e+02,		9.861477323590464e+02,
		9.867948619940939e+02,		9.874393440826497e+02,		9.880812025553995e+02,		9.887204610090905e+02,		9.893571427128500e+02,
		9.899912706143404e+02,		9.906228673457877e+02,		9.912519552298526e+02,		9.918785562853681e+02,		9.925026922329464e+02,
		9.931243845004467e+02,		9.937436542283277e+02,		9.943605222748647e+02,		9.949750092212562e+02,		9.955871353766106e+02,
		9.961969207828137e+02,		9.968043852193007e+02,		9.974095482077050e+02,		9.980124290164083e+02,		9.986130466649992e+02,
		9.992114199286160e+02,		9.998075673422031e+02,		1.000401507204676e+03,		1.000993257582988e+03,		1.001582836316116e+03,
		1.002170261018951e+03,		1.002755549086114e+03,		1.003338717695679e+03,		1.003919783812835e+03,		1.004498764193445e+03,
		1.005075675387547e+03,		1.005650533742784e+03,		1.006223355407740e+03,		1.006794156335237e+03,		1.007362952285535e+03,
		1.007929758829484e+03,		1.008494591351604e+03,		1.009057465053102e+03,		1.009618394954828e+03,		1.010177395900174e+03,
		1.010734482557906e+03,		1.011289669424946e+03,		1.011842970829101e+03,		1.012394400931722e+03,		1.012943973730331e+03,
		1.013491703061180e+03,		1.014037602601763e+03,		1.014581685873288e+03,		1.015123966243083e+03,		1.015664456926972e+03,
		1.016203170991595e+03,		1.016740121356689e+03,		1.017275320797316e+03,		1.017808781946059e+03,		1.018340517295173e+03,
		1.018870539198682e+03,		1.019398859874467e+03,		1.019925491406273e+03,		1.020450445745720e+03,		1.020973734714240e+03,
		1.021495370005007e+03,		1.022015363184815e+03,		1.022533725695918e+03,		1.023050468857853e+03,		1.023565603869215e+03,
		1.024079141809403e+03,		1.024591093640336e+03,		1.025101470208138e+03,		1.025610282244790e+03,		1.026117540369756e+03,
		1.026623255091577e+03,		1.027127436809431e+03,		1.027630095814682e+03,		1.028131242292384e+03,		1.028630886322764e+03,
		1.029129037882689e+03,		1.029625706847084e+03,		1.030120902990353e+03,		1.030614635987756e+03,		1.031106915416767e+03,
		1.031597750758413e+03,		1.032087151398580e+03,		1.032575126629315e+03,		1.033061685650078e+03,		1.033546837569001e+03,
		1.034030591404108e+03,		1.034512956084520e+03,		1.034993940451639e+03,		1.035473553260309e+03,		1.035951803179968e+03,
		1.036428698795770e+03,		1.036904248609686e+03,		1.037378461041604e+03,		1.037851344430391e+03,		1.038322907034949e+03,
		1.038793157035249e+03,		1.039262102533352e+03,		1.039729751554413e+03,		1.040196112047661e+03,		1.040661191887374e+03,
		1.041124998873832e+03,		1.041587540734258e+03,		1.042048825123735e+03,		1.042508859626125e+03,		1.042967651754960e+03,
		1.043425208954320e+03,		1.043881538599702e+03,		1.044336647998875e+03,		1.044790544392716e+03,		1.045243234956040e+03,
		1.045694726798414e+03,		1.046145026964954e+03,		1.046594142437116e+03,		1.047042080133479e+03,		1.047488846910496e+03,
		1.047934449563259e+03,		1.048378894826239e+03,		1.048822189374007e+03,		1.049264339821963e+03,		1.049705352727041e+03,
		1.050145234588406e+03,		1.050583991848140e+03,		1.051021630891920e+03,		1.051458158049688e+03,		1.051893579596298e+03,
		1.052327901752175e+03,		1.052761130683944e+03,		1.053193272505061e+03,		1.053624333276431e+03,		1.054054319007017e+03,
		1.054483235654445e+03,		1.054911089125592e+03,		1.055337885277165e+03,		1.055763629916288e+03,		1.056188328801056e+03,
		1.056611987641105e+03,		1.057034612098151e+03,		1.057456207786543e+03,		1.057876780273789e+03,		1.058296335081089e+03,
		1.058714877683856e+03,		1.059132413512222e+03,		1.059548947951547e+03,		1.059964486342918e+03,		1.060379033983640e+03,
		1.060792596127717e+03,		1.061205177986333e+03,		1.061616784728322e+03,		1.062027421480630e+03,		1.062437093328778e+03,
		1.062845805317309e+03,		1.063253562450233e+03,		1.063660369691474e+03,		1.064066231965291e+03,		1.064471154156716e+03,
		1.064875141111972e+03,		1.065278197638886e+03,		1.065680328507306e+03,		1.066081538449499e+03,		1.066481832160552e+03,
		1.066881214298772e+03,		1.067279689486064e+03,		1.067677262308326e+03,		1.068073937315819e+03,		1.068469719023543e+03,
		1.068864611911609e+03,		1.069258620425597e+03,		1.069651748976918e+03,		1.070044001943171e+03,		1.070435383668485e+03,
		1.070825898463873e+03,		1.071215550607565e+03,		1.071604344345349e+03,		1.071992283890901e+03,		1.072379373426111e+03,
		1.072765617101413e+03,		1.073151019036092e+03,		1.073535583318613e+03,		1.073919314006922e+03,		1.074302215128758e+03,
		1.074684290681955e+03,		1.075065544634741e+03,		1.075445980926035e+03,		1.075825603465736e+03,		1.076204416135015e+03,
		1.076582422786598e+03,		1.076959627245046e+03,		1.077336033307037e+03,		1.077711644741630e+03,		1.078086465290551e+03,
		1.078460498668447e+03,		1.078833748563157e+03,		1.079206218635970e+03,		1.079577912521886e+03,		1.079948833829867e+03,
		1.080318986143091e+03,		1.080688373019197e+03,		1.081056997990537e+03,		1.081424864564409e+03,		1.081791976223307e+03,
		1.082158336425148e+03,		1.082523948603513e+03,		1.082888816167874e+03,		1.083252942503822e+03,		1.083616330973297e+03,
		1.083978984914804e+03,		1.084340907643640e+03,		1.084702102452105e+03,		1.085062572609723e+03,		1.085422321363452e+03,
		1.085781351937892e+03,		1.086139667535495e+03,		1.086497271336771e+03,		1.086854166500486e+03,		1.087210356163869e+03,
		1.087565843442805e+03,		1.087920631432031e+03,		1.088274723205333e+03,		1.088628121815733e+03,		1.088980830295683e+03,
		1.089332851657246e+03,		1.089684188892283e+03,		1.090034844972641e+03,		1.090384822850324e+03,		1.090734125457680e+03,
		1.091082755707570e+03,		1.091430716493551e+03,		1.091778010690042e+03,		1.092124641152495e+03,		1.092470610717566e+03,
		1.092815922203283e+03,		1.093160578409208e+03,		1.093504582116599e+03,		1.093847936088575e+03,		1.094190643070274e+03,
		1.094532705789012e+03,		1.094874126954434e+03,		1.095214909258674e+03,		1.095555055376506e+03,		1.095894567965492e+03,
		1.096233449666136e+03,		1.096571703102026e+03,		1.096909330879988e+03,		1.097246335590221e+03,		1.097582719806447e+03,
		1.097918486086050e+03,		1.098253636970212e+03,		1.098588174984061e+03,		1.098922102636795e+03,		1.099255422421830e+03,
		1.099588136816922e+03,		1.099920248284312e+03,		1.100251759270844e+03,		1.100582672208107e+03,		1.100912989512552e+03
	},
	{
		1.690775245365510e+00,		5.119018382273910e+00,		8.607067154405046e+00,		1.215752730045002e+01,		1.577318873900082e+01,
		1.945704337151652e+01,		2.321230510181912e+01,		2.704243241470491e+01,		3.095115392008057e+01,		3.494249734687920e+01,
		3.902082256645473e+01,		4.319085934280655e+01,		4.745775065284982e+01,		5.182710260187330e+01,		5.630504218767287e+01,
		6.089828445537725e+01,		6.561421095213473e+01,		7.046096186152087e+01,		7.544754480573492e+01,		8.058396409614987e+01,
		8.588137525461231e+01,		9.135227101049044e+01,		9.701070683185311e+01,		1.028725765604676e+02,		1.089559521624285e+02,
		1.152815063827420e+02,		1.218730438089172e+02,		1.287581754297952e+02,		1.359691856561309e+02,		1.435441612177911e+02,
		1.515284820298693e+02,		1.599768210617073e+02,		1.689558736257084e+02,		1.785481538961481e+02,		1.888573889201801e+02,
		2.000163639313367e+02,		2.121986299816627e+02,		2.256364625630402e+02,		2.406491791102592e+02,		2.576888120335547e+02,
		2.774140353587273e+02,		3.008031433720706e+02,		3.292856997762667e+02,		3.647382555182165e+02,		4.087423539520109e+02,
		4.583938679582377e+02,		5.042305363825199e+02,		5.413969650110345e+02,		5.700859885626944e+02,		5.926442309806326e+02,
		6.110218334066466e+02,		6.264590363760060e+02,		6.397412818399744e+02,		6.513879923810772e+02,		6.617570373558100e+02,
		6.711035995494526e+02,		6.796150581225265e+02,		6.874325377814559e+02,		6.946646874749672e+02,		7.013967648582636e+02,
		7.076967955680084e+02,		7.136198564558915e+02,		7.192111227251182e+02,		7.245080800188639e+02,		7.295421594082784e+02,
		7.343399652942483e+02,		7.389242108400913e+02,		7.433144398119225e+02,		7.475275901252819e+02,		7.515784385195803e+02,
		7.554799548890323e+02,		7.592435871973071e+02,		7.628794925171363e+02,		7.663967258660692e+02,		7.698033956939886e+02,
		7.731067928055855e+02,		7.763134979596980e+02,		7.794294722297022e+02,		7.824601333320343e+02,		7.854104204593314e+02,
		7.882848496385036e+02,		7.910875612332688e+02,		7.938223608976991e+02,		7.964927550409923e+02,		7.991019816688670e+02,
		8.016530373116658e+02,		8.041487006249808e+02,		8.065915531484649e+02,		8.089839976274330e+02,		8.113282742358321e+02,
		8.136264749852882e+02,		8.158805565605193e+02,		8.180923517847967e+02,		8.202635798888759e+02,		8.223958557314605e+02,
		8.244906980981663e+02,		8.265495371882363e+02,		8.285737213832961e+02,		8.305645233797979e+02,		8.325231457561096e+02,
		8.344507260360230e+02,		8.363483413026928e+02,		8.382170124103120e+02,		8.400577078350819e+02,		8.418713472020638e+02,
		8.436588045202269e+02,		8.454209111542737e+02,		8.471584585586120e+02,		8.488722007959628e+02,		8.505628568607315e+02,
		8.522311128249994e+02,		8.538776238231781e+02,		8.555030158896503e+02,		8.571078876623011e+02,		8.586928119634656e+02,
		8.602583372687645e+02,		8.618049890731893e+02,		8.633332711629484e+02,		8.648436668007447e+02,		8.663366398314546e+02,
		8.678126357145243e+02,		8.692720824887995e+02,		8.707153916750565e+02,		8.721429591209362e+02,		8.735551657926563e+02,
		8.749523785174540e+02,		8.763349506803793e+02,		8.777032228787508e+02,		8.790575235373254e+02,		8.803981694869548e+02,
		8.817254665093035e+02,		8.830397098499717e+02,		8.843411847021837e+02,		8.856301666630640e+02,		8.869069221642992e+02,
		8.881717088789221e+02,		8.894247761057591e+02,		8.906663651330060e+02,		8.918967095822684e+02,		8.931160357342983e+02,
		8.943245628376088e+02,		8.955225034009925e+02,		8.967100634709659e+02,		8.978874428950601e+02,		8.990548355717896e+02,
		9.002124296881282e+02,		9.013604079451994e+02,		9.024989477729140e+02,		9.036282215341514e+02,		9.047483967191334e+02,
		9.058596361305059e+02,		9.069620980597012e+02,		9.080559364550243e+02,		9.091413010819560e+02,		9.102183376760864e+02,
		9.112871880890820e+02,		9.123479904280709e+02,		9.134008791887874e+02,		9.144459853828131e+02,		9.154834366592414e+02,
		9.165133574210161e+02,		9.175358689362718e+02,		9.185510894448867e+02,		9.195591342605281e+02,		9.205601158683918e+02,
		9.215541440188647e+02,		9.225413258173110e+02,		9.235217658101747e+02,		9.244955660675708e+02,		9.254628262625496e+02,
		9.264236437471741e+02,		9.273781136255880e+02,		9.283263288241949e+02,		9.292683801590949e+02,		9.302043564009036e+02,
		9.311343443370856e+02,		9.320584288318917e+02,		9.329766928840314e+02,		9.338892176821868e+02,		9.347960826584367e+02,
		9.356973655397142e+02,		9.365931423973700e+02,		9.374834876949230e+02,		9.383684743340880e+02,		9.392481736991444e+02,
		9.401226556997252e+02,		9.409919888120845e+02,		9.418562401189205e+02,		9.427154753478039e+02,		9.435697589082765e+02,
		9.444191539276685e+02,		9.452637222856981e+02,		9.461035246478940e+02,		9.469386204978885e+02,		9.477690681686356e+02,
		9.485949248725868e+02,		9.494162467308751e+02,		9.502330888015401e+02,		9.510455051068321e+02,		9.518535486596348e+02,
		9.526572714890455e+02,		9.534567246651271e+02,		9.542519583228818e+02,		9.550430216854758e+02,		9.558299630867255e+02,
		9.566128299928918e+02,		9.573916690238023e+02,		9.581665259733215e+02,		9.589374458291999e+02,		9.597044727923206e+02,
		9.604676502953671e+02,		9.612270210209317e+02,		9.619826269190866e+02,		9.627345092244361e+02,		9.634827084726693e+02,
		9.642272645166244e+02,		9.649682165418948e+02,		9.657056030819797e+02,		9.664394620330063e+02,		9.671698306680231e+02,
		9.678967456509001e+02,		9.686202430498292e+02,		9.693403583504513e+02,		9.700571264686213e+02,		9.707705817628076e+02,
		9.714807580461661e+02,		9.721876885982779e+02,		9.728914061765630e+02,		9.735919430273964e+02,		9.742893308969157e+02,
		9.749836010415449e+02,		9.756747842382391e+02,		9.763629107944574e+02,		9.770480105578744e+02,		9.777301129258378e+02,
		9.784092468545773e+02,		9.790854408681837e+02,		9.797587230673489e+02,		9.804291211378883e+02,		9.810966623590426e+02,
		9.817613736115746e+02,		9.824232813856545e+02,		9.830824117885586e+02,		9.837387905521673e+02,		9.843924430402838e+02,
		9.850433942557679e+02,		9.856916688474985e+02,		9.863372911171671e+02,		9.869802850259016e+02,		9.876206742007380e+02,
		9.882584819409262e+02,		9.888937312241037e+02,		9.895264447122947e+02,		9.901566447578001e+02,		9.907843534089213e+02,
		9.914095924155657e+02,		9.920323832347206e+02,		9.926527470357911e+02,		9.932707047058253e+02,		9.938862768546170e+02,
		9.944994838196862e+02,		9.951103456711552e+02,		9.957188822165086e+02,		9.963251130052481e+02,		9.969290573334431e+02,
		9.975307342481797e+02,		9.981301625519122e+02,		9.987273608067171e+02,		9.993223473384528e+02,		9.999151402408307e+02,
		1.000505757379400e+03,		1.001094216395437e+03,		1.001680534709763e+03,		1.002264729526468e+03,		1.002846817836564e+03,
		1.003426816421557e+03,		1.004004741856946e+03,		1.004580610515638e+03,		1.005154438571309e+03,		1.005726242001681e+03,
		1.006296036591733e+03,		1.006863837936849e+03,		1.007429661445905e+03,		1.007993522344278e+03,		1.008555435676808e+03,
		1.009115416310696e+03,		1.009673478938339e+03,		1.010229638080112e+03,		1.010783908087092e+03,		1.011336303143730e+03,
		1.011886837270467e+03,		1.012435524326299e+03,		1.012982378011295e+03,		1.013527411869054e+03,		1.014070639289135e+03,
		1.014612073509415e+03,		1.015151727618417e+03,		1.015689614557591e+03,		1.016225747123549e+03,		1.016760137970251e+03,
		1.017292799611167e+03,		1.017823744421371e+03,		1.018352984639625e+03,		1.018880532370401e+03,		1.019406399585875e+03,
		1.019930598127885e+03,		1.020453139709842e+03,		1.020974035918623e+03,		1.021493298216411e+03,		1.022010937942513e+03,
		1.022526966315138e+03,		1.023041394433150e+03,		1.023554233277776e+03,		1.024065493714299e+03,		1.024575186493710e+03,
		1.025083322254334e+03,		1.025589911523422e+03,		1.026094964718720e+03,		1.026598492150013e+03,		1.027100504020631e+03,
		1.027601010428935e+03,		1.028100021369781e+03,		1.028597546735950e+03,		1.029093596319555e+03,		1.029588179813428e+03,
		1.030081306812482e+03,		1.030572986815040e+03,		1.031063229224157e+03,		1.031552043348907e+03,		1.032039438405651e+03,
		1.032525423519286e+03,		1.033010007724473e+03,		1.033493199966839e+03,		1.033975009104162e+03,		1.034455443907542e+03,
		1.034934513062541e+03,		1.035412225170309e+03,		1.035888588748698e+03,		1.036363612233347e+03,		1.036837303978753e+03,
		1.037309672259329e+03,		1.037780725270438e+03,		1.038250471129413e+03,		1.038718917876563e+03,		1.039186073476154e+03,
		1.039651945817388e+03,		1.040116542715350e+03,		1.040579871911959e+03,		1.041041941076879e+03,		1.041502757808443e+03,
		1.041962329634540e+03,		1.042420664013500e+03,		1.042877768334960e+03,		1.043333649920725e+03,		1.043788316025595e+03,
		1.044241773838208e+03,		1.044694030481846e+03,		1.045145093015235e+03,		1.045594968433343e+03,		1.046043663668151e+03,
		1.046491185589422e+03,		1.046937541005450e+03,		1.047382736663810e+03,		1.047826779252083e+03,		1.048269675398579e+03,
		1.048711431673041e+03,		1.049152054587353e+03,		1.049591550596217e+03,		1.050029926097838e+03,		1.050467187434589e+03,
		1.050903340893671e+03,		1.051338392707753e+03,		1.051772349055621e+03,		1.052205216062799e+03,		1.052636999802170e+03,
		1.053067706294589e+03,		1.053497341509484e+03,		1.053925911365446e+03,		1.054353421730815e+03,		1.054779878424255e+03,
		1.055205287215325e+03,		1.055629653825032e+03,		1.056052983926387e+03,		1.056475283144946e+03,		1.056896557059349e+03,
		1.057316811201842e+03,		1.057736051058802e+03,		1.058154282071250e+03,		1.058571509635355e+03,		1.058987739102935e+03,
		1.059402975781944e+03,		1.059817224936965e+03,		1.060230491789680e+03,		1.060642781519349e+03,		1.061054099263266e+03,
		1.061464450117229e+03,		1.061873839135981e+03,		1.062282271333662e+03,		1.062689751684252e+03,		1.063096285121995e+03,
		1.063501876541840e+03,		1.063906530799852e+03,		1.064310252713632e+03,		1.064713047062733e+03,		1.065114918589059e+03,
		1.065515871997267e+03,		1.065915911955163e+03,		1.066315043094089e+03,		1.066713270009310e+03,		1.067110597260390e+03,
		1.067507029371568e+03,		1.067902570832127e+03,		1.068297226096759e+03,		1.068690999585919e+03,		1.069083895686191e+03,
		1.069475918750624e+03,		1.069867073099091e+03,		1.070257363018620e+03,		1.070646792763738e+03,		1.071035366556797e+03,
		1.071423088588307e+03,		1.071809963017257e+03,		1.072195993971437e+03,		1.072581185547751e+03,		1.072965541812531e+03,
		1.073349066801842e+03,		1.073731764521790e+03,		1.074113638948815e+03,		1.074494694029999e+03,		1.074874933683341e+03,
		1.075254361798064e+03,		1.075632982234887e+03,		1.076010798826312e+03,		1.076387815376903e+03,		1.076764035663559e+03,
		1.077139463435782e+03,		1.077514102415952e+03,		1.077887956299585e+03,		1.078261028755600e+03,		1.078633323426571e+03,
		1.079004843928988e+03,		1.079375593853504e+03,		1.079745576765187e+03,		1.080114796203764e+03,		1.080483255683866e+03,
		1.080850958695265e+03,		1.081217908703112e+03,		1.081584109148174e+03,		1.081949563447061e+03,		1.082314274992458e+03,
		1.082678247153348e+03,		1.083041483275237e+03,		1.083403986680376e+03,		1.083765760667975e+03,		1.084126808514422e+03,
		1.084487133473494e+03,		1.084846738776568e+03,		1.085205627632827e+03,		1.085563803229471e+03,		1.085921268731912e+03,
		1.086278027283980e+03,		1.086634082008123e+03,		1.086989436005597e+03,		1.087344092356664e+03,		1.087698054120784e+03,
		1.088051324336802e+03,		1.088403906023136e+03,		1.088755802177964e+03,		1.089107015779404e+03,		1.089457549785696e+03,
		1.089807407135382e+03,		1.090156590747483e+03,		1.090505103521670e+03,		1.090852948338442e+03,		1.091200128059293e+03,
		1.091546645526883e+03,		1.091892503565205e+03,		1.092237704979748e+03,		1.092582252557665e+03,		1.092926149067929e+03,
		1.093269397261498e+03,		1.093611999871470e+03,		1.093953959613236e+03,		1.094295279184643e+03,		1.094635961266143e+03,
		1.094976008520938e+03,		1.095315423595138e+03,		1.095654209117908e+03,		1.095992367701609e+03,		1.096329901941945e+03,
		1.096666814418112e+03,		1.097003107692927e+03,		1.097338784312983e+03,		1.097673846808775e+03,		1.098008297694844e+03,
		1.098342139469912e+03,		1.098675374617011e+03,		1.099008005603625e+03,		1.099340034881811e+03,		1.099671464888336e+03
	},
	{
		1.687493142557550e+00,		5.108798577697866e+00,		8.589386103902340e+00,		1.213181667181941e+01,		1.573883056347188e+01,
		1.941336454194942e+01,		2.315857111129902e+01,		2.697784020869154e+01,		3.087482371015090e+01,		3.485346320316974e+01,
		3.891802156762065e+01,		4.307311901465042e+01,		4.732377436708498e+01,		5.167545253127246e+01,		5.613411931844545e+01,
		6.070630503575046e+01,		6.539917859928877e+01,		7.022063434563719e+01,		7.517939426393072e+01,		8.028512907814483e+01,
		8.554860253461479e+01,		9.098184447110557e+01,		9.659835987103385e+01,		1.024133832969678e+02,		1.084441910785447e+02,
		1.147104877342349e+02,		1.212348888281745e+02,		1.280435305476466e+02,		1.351668478750663e+02,		1.426405800991051e+02,
		1.505070873854345e+02,		1.588170997745617e+02,		1.676320778278533e+02,		1.770274548916201e+02,		1.870971763679424e+02,
		1.979601894110128e+02,		2.097699335866537e+02,		2.227285535780349e+02,		2.371086794553755e+02,		2.532873959577043e+02,
		2.717991978962614e+02,		2.934141842257571e+02,		3.192294361166574e+02,		3.506847566139606e+02,		3.892270019750484e+02,
		4.344642159041246e+02,		4.801987274115415e+02,		5.199578049046984e+02,		5.518417854449186e+02,		5.769991575991329e+02,
		5.973221544429323e+02,		6.142344227969334e+02,		6.286664974190713e+02,		6.412322382960234e+02,		6.523516037669756e+02,
		6.623219396707299e+02,		6.713600835954787e+02,		6.796282622579098e+02,		6.872505893158664e+02,		6.943238944864415e+02,
		7.009250264569021e+02,		7.071159019004044e+02,		7.129470766382547e+02,		7.184603240887722e+02,		7.236905316462905e+02,
		7.286671185941832e+02,		7.334151119990825e+02,		7.379559739449764e+02,		7.423082452123796e+02,		7.464880515972077e+02,
		7.505095061621654e+02,		7.543850317556672e+02,		7.581256218138268e+02,		7.617410529375203e+02,		7.652400594563064e+02,
		7.686304777832063e+02,		7.719193665781658e+02,		7.751131073993045e+02,		7.782174895086528e+02,		7.812377817268427e+02,
		7.841787936374445e+02,		7.870449279816812e+02,		7.898402257255442e+02,		7.925684049995124e+02,		7.952328948885248e+02,
		7.978368648727968e+02,		8.003832505786124e+02,		8.028747763843926e+02,		8.053139753354300e+02,		8.077032067459345e+02,
		8.100446718060596e+02,		8.123404274615897e+02,		8.145923987927002e+02,		8.168023900841254e+02,		8.189720947507356e+02,
		8.211031042588153e+02,		8.231969161635772e+02,		8.252549413667151e+02,		8.272785106837832e+02,		8.292688807992265e+02,
		8.312272396767651e+02,		8.331547114841969e+02,		8.350523610842901e+02,		8.369211981370451e+02,		8.387621808532140e+02,
		8.405762194341870e+02,		8.423641792292601e+02,		8.441268836378133e+02,		8.458651167807822e+02,		8.475796259631254e+02,
		8.492711239466360e+02,		8.509402910503966e+02,		8.525877770943024e+02,		8.542142031995543e+02,		8.558201634585376e+02,
		8.574062264853130e+02,		8.589729368567765e+02,		8.605208164536454e+02,		8.620503657094492e+02,		8.635620647750058e+02,
		8.650563746051607e+02,		8.665337379738686e+02,		8.679945804232482e+02,		8.694393111516579e+02,		8.708683238454286e+02,
		8.722819974584688e+02,		8.736806969436128e+02,		8.750647739392406e+02,		8.764345674143773e+02,		8.777904042752774e+02,
		8.791325999361820e+02,		8.804614588567546e+02,		8.817772750485042e+02,		8.830803325522985e+02,		8.843709058889341e+02,
		8.856492604845386e+02,		8.869156530724881e+02,		8.881703320733621e+02,		8.894135379543550e+02,		8.906455035694661e+02,
		8.918664544816726e+02,		8.930766092682272e+02,		8.942761798101199e+02,		8.954653715666680e+02,		8.966443838361650e+02,
		8.978134100033935e+02,		8.989726377748129e+02,		9.001222494021341e+02,		9.012624218949699e+02,		9.023933272231822e+02,
		9.035151325095337e+02,		9.046280002131824e+02,		9.057320883045369e+02,		9.068275504319625e+02,		9.079145360807837e+02,
		9.089931907250000e+02,		9.100636559721264e+02,		9.111260697015118e+02,		9.121805661964991e+02,		9.132272762707373e+02,
		9.142663273889717e+02,		9.152978437825850e+02,		9.163219465601608e+02,		9.173387538133316e+02,		9.183483807181564e+02,
		9.193509396322290e+02,		9.203465401877529e+02,		9.213352893807795e+02,		9.223172916567853e+02,		9.232926489927852e+02,
		9.242614609761295e+02,		9.252238248801591e+02,		9.261798357368665e+02,		9.271295864066955e+02,		9.280731676456156e+02,
		9.290106681696158e+02,		9.299421747167066e+02,		9.308677721065690e+02,		9.317875432979492e+02,		9.327015694438948e+02,
		9.336099299449412e+02,		9.345127025003301e+02,		9.354099631573474e+02,		9.363017863588733e+02,		9.371882449892048e+02,
		9.380694104182433e+02,		9.389453525441041e+02,		9.398161398342228e+02,		9.406818393650185e+02,		9.415425168601732e+02,
		9.423982367275942e+02,		9.432490620950991e+02,		9.440950548448878e+02,		9.449362756468480e+02,		9.457727839907408e+02,
		9.466046382173084e+02,		9.474318955483548e+02,		9.482546121158307e+02,		9.490728429899724e+02,		9.498866422065215e+02,
		9.506960627930696e+02,		9.515011567945587e+02,		9.523019752979631e+02,		9.530985684562022e+02,		9.538909855112878e+02,
		9.546792748167613e+02,		9.554634838594280e+02,		9.562436592804193e+02,		9.570198468956210e+02,		9.577920917154632e+02,
		9.585604379641306e+02,		9.593249290981779e+02,		9.600856078246034e+02,		9.608425161183764e+02,		9.615956952394567e+02,
		9.623451857493055e+02,		9.630910275269232e+02,		9.638332597844227e+02,		9.645719210821439e+02,		9.653070493433546e+02,
		9.660386818685126e+02,		9.667668553491461e+02,		9.674916058813228e+02,		9.682129689787592e+02,		9.689309795855589e+02,
		9.696456720885984e+02,		9.703570803295805e+02,		9.710652376167458e+02,		9.717701767362790e+02,		9.724719299634028e+02,
		9.731705290731702e+02,		9.738660053509793e+02,		9.745583896027952e+02,		9.752477121651175e+02,		9.759340029146740e+02,
		9.766172912778665e+02,		9.772976062399779e+02,		9.779749763541262e+02,		9.786494297500085e+02,		9.793209941424013e+02,
		9.799896968394642e+02,		9.806555647508233e+02,		9.813186243954486e+02,		9.819789019093461e+02,		9.826364230530492e+02,
		9.832912132189313e+02,		9.839432974383298e+02,		9.845927003885113e+02,		9.852394463994472e+02,		9.858835594604443e+02,
		9.865250632266030e+02,		9.871639810251266e+02,		9.878003358614811e+02,		9.884341504254032e+02,		9.890654470967714e+02,
		9.896942479513392e+02,		9.903205747663319e+02,		9.909444490259150e+02,		9.915658919265367e+02,		9.921849243821440e+02,
		9.928015670292870e+02,		9.934158402320933e+02,		9.940277640871460e+02,		9.946373584282418e+02,		9.952446428310404e+02,
		9.958496366176171e+02,		9.964523588609090e+02,		9.970528283890646e+02,		9.976510637896998e+02,		9.982470834140524e+02,
		9.988409053810574e+02,		9.994325475813226e+02,		1.000022027681028e+03,		1.000609363125735e+03,		1.001194571144114e+03,
		1.001777668751593e+03,		1.002358672753937e+03,		1.002937599750735e+03,		1.003514466138829e+03,		1.004089288115664e+03,
		1.004662081682566e+03,		1.005232862647962e+03,		1.005801646630517e+03,		1.006368449062228e+03,		1.006933285191430e+03,
		1.007496170085762e+03,		1.008057118635062e+03,		1.008616145554200e+03,		1.009173265385868e+03,		1.009728492503300e+03,
		1.010281841112942e+03,		1.010833325257073e+03,		1.011382958816370e+03,		1.011930755512421e+03,		1.012476728910195e+03,
		1.013020892420457e+03,		1.013563259302136e+03,		1.014103842664658e+03,		1.014642655470215e+03,		1.015179710536012e+03,
		1.015715020536448e+03,		1.016248598005278e+03,		1.016780455337716e+03,		1.017310604792509e+03,		1.017839058493966e+03,
		1.018365828433953e+03,		1.018890926473849e+03,		1.019414364346461e+03,		1.019936153657916e+03,		1.020456305889502e+03,
		1.020974832399487e+03,		1.021491744424900e+03,		1.022007053083278e+03,		1.022520769374388e+03,		1.023032904181909e+03,
		1.023543468275087e+03,		1.024052472310366e+03,		1.024559926832978e+03,		1.025065842278519e+03,		1.025570228974480e+03,
		1.026073097141769e+03,		1.026574456896194e+03,		1.027074318249919e+03,		1.027572691112904e+03,		1.028069585294315e+03,
		1.028565010503903e+03,		1.029058976353374e+03,		1.029551492357717e+03,		1.030042567936524e+03,		1.030532212415284e+03,
		1.031020435026649e+03,		1.031507244911679e+03,		1.031992651121081e+03,		1.032476662616403e+03,		1.032959288271227e+03,
		1.033440536872332e+03,		1.033920417120846e+03,		1.034398937633365e+03,		1.034876106943070e+03,		1.035351933500814e+03,
		1.035826425676195e+03,		1.036299591758610e+03,		1.036771439958295e+03,		1.037241978407344e+03,		1.037711215160713e+03,
		1.038179158197212e+03,		1.038645815420470e+03,		1.039111194659897e+03,		1.039575303671624e+03,		1.040038150139425e+03,
		1.040499741675634e+03,		1.040960085822041e+03,		1.041419190050769e+03,		1.041877061765146e+03,		1.042333708300566e+03,
		1.042789136925318e+03,		1.043243354841427e+03,		1.043696369185462e+03,		1.044148187029341e+03,		1.044598815381123e+03,
		1.045048261185784e+03,		1.045496531325984e+03,		1.045943632622823e+03,		1.046389571836584e+03,		1.046834355667462e+03,
		1.047277990756288e+03,		1.047720483685238e+03,		1.048161840978534e+03,		1.048602069103126e+03,		1.049041174469377e+03,
		1.049479163431731e+03,		1.049916042289368e+03,		1.050351817286853e+03,		1.050786494614778e+03,		1.051220080410387e+03,
		1.051652580758200e+03,		1.052084001690624e+03,		1.052514349188554e+03,		1.052943629181965e+03,		1.053371847550499e+03,
		1.053799010124043e+03,		1.054225122683293e+03,		1.054650190960316e+03,		1.055074220639103e+03,		1.055497217356112e+03,
		1.055919186700804e+03,		1.056340134216172e+03,		1.056760065399261e+03,		1.057178985701684e+03,		1.057596900530127e+03,
		1.058013815246848e+03,		1.058429735170174e+03,		1.058844665574976e+03,		1.059258611693161e+03,		1.059671578714134e+03,
		1.060083571785272e+03,		1.060494596012373e+03,		1.060904656460117e+03,		1.061313758152514e+03,		1.061721906073334e+03,
		1.062129105166552e+03,		1.062535360336776e+03,		1.062940676449662e+03,		1.063345058332337e+03,		1.063748510773811e+03,
		1.064151038525383e+03,		1.064552646301036e+03,		1.064953338777839e+03,		1.065353120596333e+03,		1.065751996360917e+03,
		1.066149970640228e+03,		1.066547047967514e+03,		1.066943232841006e+03,		1.067338529724280e+03,		1.067732943046618e+03,
		1.068126477203367e+03,		1.068519136556282e+03,		1.068910925433880e+03,		1.069301848131777e+03,		1.069691908913025e+03,
		1.070081112008446e+03,		1.070469461616965e+03,		1.070856961905924e+03,		1.071243617011413e+03,		1.071629431038578e+03,
		1.072014408061939e+03,		1.072398552125694e+03,		1.072781867244025e+03,		1.073164357401398e+03,		1.073546026552860e+03,
		1.073926878624330e+03,		1.074306917512893e+03,		1.074686147087080e+03,		1.075064571187154e+03,		1.075442193625383e+03,
		1.075819018186324e+03,		1.076195048627087e+03,		1.076570288677605e+03,		1.076944742040901e+03,		1.077318412393350e+03,
		1.077691303384933e+03,		1.078063418639500e+03,		1.078434761755013e+03,		1.078805336303803e+03,		1.079175145832813e+03,
		1.079544193863841e+03,		1.079912483893781e+03,		1.080280019394860e+03,		1.080646803814873e+03,		1.081012840577415e+03,
		1.081378133082108e+03,		1.081742684704830e+03,		1.082106498797936e+03,		1.082469578690482e+03,		1.082831927688440e+03,
		1.083193549074916e+03,		1.083554446110362e+03,		1.083914622032788e+03,		1.084274080057967e+03,		1.084632823379646e+03,
		1.084990855169744e+03,		1.085348178578559e+03,		1.085704796734959e+03,		1.086060712746586e+03,		1.086415929700045e+03,
		1.086770450661098e+03,		1.087124278674856e+03,		1.087477416765958e+03,		1.087829867938769e+03,		1.088181635177554e+03,
		1.088532721446659e+03,		1.088883129690698e+03,		1.089232862834720e+03,		1.089581923784395e+03,		1.089930315426175e+03,
		1.090278040627478e+03,		1.090625102236843e+03,		1.090971503084114e+03,		1.091317245980590e+03,		1.091662333719198e+03,
		1.092006769074652e+03,		1.092350554803613e+03,		1.092693693644848e+03,		1.093036188319386e+03,		1.093378041530672e+03,
		1.093719255964722e+03,		1.094059834290273e+03,		1.094399779158935e+03,		1.094739093205334e+03,		1.095077779047265e+03,
		1.095415839285833e+03,		1.095753276505596e+03,		1.096090093274710e+03,		1.096426292145067e+03,		1.096761875652432e+03,
		1.097096846316587e+03,		1.097431206641458e+03,		1.097764959115257e+03,		1.098098106210608e+03,		1.098430650384686e+03
	},
	{
		1.684223943223908e+00,		5.098621272021922e+00,		8.571782774133963e+00,		1.210622544218333e+01,		1.570464088479969e+01,
		1.936991184733483e+01,		2.310513074151947e+01,		2.691362048683988e+01,		3.079895802133429e+01,		3.476500090616202e+01,
		3.881591752958558e+01,		4.295622151564842e+01,		4.719081106563050e+01,		5.152501411255820e+01,		5.596464035878990e+01,
		6.051604150473727e+01,		6.518618127737165e+01,		6.998271724937109e+01,		7.491409692930669e+01,		7.998967123512810e+01,
		8.521982928543289e+01,		9.061615952219270e+01,		9.619164360806802e+01,		1.019608914533024e+02,		1.079404283107574e+02,
		1.141490484074714e+02,		1.206082544606677e+02,		1.273428092564878e+02,		1.343814351598506e+02,		1.417577113697257e+02,
		1.495112391152735e+02,		1.576891752659402e+02,		1.663482805951175e+02,		1.755576993807659e+02,		1.854027974664489e+02,
		1.959905621187597e+02,		2.074573522276851e+02,		2.199802516698300e+02,		2.337940224823127e+02,		2.492167599164108e+02,
		2.666885693041625e+02,		2.868269276618127e+02,		3.104912408141829e+02,		3.388039050089906e+02,		3.729747183158987e+02,
		4.134703049610256e+02,		4.573142193805012e+02,		4.981465970602661e+02,		5.326434232282004e+02,		5.604346024263045e+02,
		5.828634873011640e+02,		6.013917405631952e+02,		6.170818728981683e+02,		6.306496544667606e+02,		6.425840309741086e+02,
		6.532293756822517e+02,		6.628354024241823e+02,		6.715878733626943e+02,		6.796281180879896e+02,		6.870658143927288e+02,
		6.939875782199462e+02,		7.004628768331156e+02,		7.065481909776637e+02,		7.122900053600939e+02,		7.177269978843395e+02,
		7.228916696151539e+02,		7.278115768758802e+02,		7.325102753517101e+02,		7.370080524307166e+02,		7.413225016183836e+02,
		7.454689776634809e+02,		7.494609605347435e+02,		7.533103490150633e+02,		7.570276994238858e+02,		7.606224211794612e+02,
		7.641029381326481e+02,		7.674768225463571e+02,		7.707509070559536e+02,		7.739313787844364e+02,		7.770238589016236e+02,
		7.800334702374455e+02,		7.829648950342287e+02,		7.858224245136313e+02,		7.886100016130368e+02,		7.913312579929544e+02,
		7.939895462160057e+02,		7.965879678375079e+02,		7.991293980188542e+02,		8.016165071708413e+02,		8.040517800498277e+02,
		8.064375326607270e+02,		8.087759272646755e+02,		8.110689857427877e+02,		8.133186015292094e+02,		8.155265502948824e+02,
		8.176944995370474e+02,		8.198240172073034e+02,		8.219165794925138e+02,		8.239735778472126e+02,		8.259963253628641e+02,
		8.279860625481477e+02,		8.299439625848235e+02,		8.318711361156080e+02,		8.337686356134359e+02,		8.356374593755053e+02,
		8.374785551802628e+02,		8.392928236410455e+02,		8.410811212861834e+02,		8.428442633919581e+02,		8.445830265919308e+02,
		8.462981512834954e+02,		8.479903438503371e+02,		8.496602787174330e+02,		8.513086002535364e+02,		8.529359245345150e+02,
		8.545428409795950e+02,		8.561299138713258e+02,		8.576976837690362e+02,		8.592466688246043e+02,		8.607773660085275e+02,
		8.622902522534940e+02,		8.637857855220504e+02,		8.652644058042771e+02,		8.667265360509321e+02,		8.681725830469541e+02,
		8.696029382298661e+02,		8.710179784571573e+02,		8.724180667264108e+02,		8.738035528516200e+02,		8.751747740988332e+02,
		8.765320557840156e+02,		8.778757118357985e+02,		8.792060453255268e+02,		8.805233489668710e+02,		8.818279055870657e+02,
		8.831199885716613e+02,		8.843998622845842e+02,		8.856677824650822e+02,		8.869239966030987e+02,		8.881687442944404e+02,
		8.894022575770213e+02,		8.906247612494026e+02,		8.918364731726928e+02,		8.930376045568711e+02,		8.942283602324686e+02,
		8.954089389084921e+02,		8.965795334174226e+02,		8.977403309480599e+02,		8.988915132669053e+02,		9.000332569287841e+02,
		9.011657334772950e+02,		9.022891096356968e+02,		9.034035474887470e+02,		9.045092046560309e+02,		9.056062344572202e+02,
		9.066947860697353e+02,		9.077750046792122e+02,		9.088470316231641e+02,		9.099110045282048e+02,		9.109670574411790e+02,
		9.120153209545221e+02,		9.130559223261378e+02,		9.140889855940998e+02,		9.151146316864293e+02,		9.161329785261953e+02,
		9.171441411321949e+02,		9.181482317154112e+02,		9.191453597714764e+02,		9.201356321693311e+02,		9.211191532362594e+02,
		9.220960248394972e+02,		9.230663464645424e+02,		9.240302152903745e+02,		9.249877262616778e+02,		9.259389721582450e+02,
		9.268840436616896e+02,		9.278230294195686e+02,		9.287560161070617e+02,		9.296830884863042e+02,		9.306043294634883e+02,
		9.315198201438157e+02,		9.324296398844230e+02,		9.333338663453546e+02,		9.342325755386660e+02,		9.351258418757468e+02,
		9.360137382129441e+02,		9.368963358955450e+02,		9.377737048002035e+02,		9.386459133758726e+02,		9.395130286832939e+02,
		9.403751164331333e+02,		9.412322410227791e+02,		9.420844655718980e+02,		9.429318519567695e+02,		9.437744608434657e+02,
		9.446123517199185e+02,		9.454455829269166e+02,		9.462742116880731e+02,		9.470982941388194e+02,		9.479178853544388e+02,
		9.487330393772033e+02,		9.495438092426269e+02,		9.503502470048875e+02,		9.511524037614321e+02,		9.519503296768139e+02,
		9.527440740057746e+02,		9.535336851156121e+02,		9.543192105078546e+02,		9.551006968392653e+02,		9.558781899422096e+02,
		9.566517348443981e+02,		9.574213757880434e+02,		9.581871562484273e+02,		9.589491189519316e+02,		9.597073058935218e+02,
		9.604617583537213e+02,		9.612125169150924e+02,		9.619596214782315e+02,		9.627031112773054e+02,		9.634430248951406e+02,
		9.641794002778845e+02,		9.649122747492478e+02,		9.656416850243418e+02,		9.663676672231360e+02,		9.670902568835351e+02,
		9.678094889740912e+02,		9.685253979063712e+02,		9.692380175469850e+02,		9.699473812292779e+02,		9.706535217647195e+02,
		9.713564714539726e+02,		9.720562620976790e+02,		9.727529250069434e+02,		9.734464910135511e+02,		9.741369904799161e+02,
		9.748244533087585e+02,		9.755089089525434e+02,		9.761903864226662e+02,		9.768689142984038e+02,		9.775445207356368e+02,
		9.782172334753494e+02,		9.788870798519198e+02,		9.795540868011850e+02,		9.802182808683219e+02,		9.808796882155241e+02,
		9.815383346294848e+02,		9.821942455287023e+02,		9.828474459705983e+02,		9.834979606584741e+02,		9.841458139482804e+02,
		9.847910298552422e+02,		9.854336320603096e+02,		9.860736439164650e+02,		9.867110884548712e+02,		9.873459883908815e+02,
		9.879783661299024e+02,		9.886082437731236e+02,		9.892356431231117e+02,		9.898605856892700e+02,		9.904830926931830e+02,
		9.911031850738287e+02,		9.917208834926757e+02,		9.923362083386581e+02,		9.929491797330506e+02,		9.935598175342202e+02,
		9.941681413422789e+02,		9.947741705036307e+02,		9.953779241154172e+02,		9.959794210298630e+02,		9.965786798585314e+02,
		9.971757189764804e+02,		9.977705565263293e+02,		9.983632104222401e+02,		9.989536983538112e+02,		9.995420377898888e+02,
		1.000128245982289e+03,		1.000712339969451e+03,		1.001294336580010e+03,		1.001874252436289e+03,		1.002452103957723e+03,
		1.003027907364209e+03,		1.003601678679389e+03,		1.004173433733858e+03,		1.004743188168316e+03,		1.005310957436645e+03,
		1.005876756808930e+03,		1.006440601374415e+03,		1.007002506044403e+03,		1.007562485555086e+03,		1.008120554470336e+03,
		1.008676727184427e+03,		1.009231017924699e+03,		1.009783440754192e+03,		1.010334009574194e+03,		1.010882738126769e+03,
		1.011429639997220e+03,		1.011974728616502e+03,		1.012518017263603e+03,		1.013059519067860e+03,		1.013599247011242e+03,
		1.014137213930589e+03,		1.014673432519800e+03,		1.015207915331992e+03,		1.015740674781605e+03,		1.016271723146473e+03,
		1.016801072569859e+03,		1.017328735062446e+03,		1.017854722504296e+03,		1.018379046646769e+03,		1.018901719114406e+03,
		1.019422751406779e+03,		1.019942154900310e+03,		1.020459940850049e+03,		1.020976120391426e+03,		1.021490704541967e+03,
		1.022003704202985e+03,		1.022515130161234e+03,		1.023024993090533e+03,		1.023533303553366e+03,		1.024040072002454e+03,
		1.024545308782291e+03,		1.025049024130662e+03,		1.025551228180125e+03,		1.026051930959477e+03,		1.026551142395189e+03,
		1.027048872312813e+03,		1.027545130438369e+03,		1.028039926399713e+03,		1.028533269727865e+03,		1.029025169858330e+03,
		1.029515636132393e+03,		1.030004677798387e+03,		1.030492304012938e+03,		1.030978523842203e+03,		1.031463346263069e+03,
		1.031946780164344e+03,		1.032428834347919e+03,		1.032909517529925e+03,		1.033388838341852e+03,		1.033866805331662e+03,
		1.034343426964885e+03,		1.034818711625684e+03,		1.035292667617917e+03,		1.035765303166175e+03,		1.036236626416802e+03,
		1.036706645438898e+03,		1.037175368225313e+03,		1.037642802693617e+03,		1.038108956687055e+03,		1.038573837975494e+03,
		1.039037454256343e+03,		1.039499813155473e+03,		1.039960922228109e+03,		1.040420788959712e+03,		1.040879420766855e+03,
		1.041336824998075e+03,		1.041793008934712e+03,		1.042247979791745e+03,		1.042701744718604e+03,		1.043154310799974e+03,
		1.043605685056589e+03,		1.044055874446009e+03,		1.044504885863385e+03,		1.044952726142219e+03,		1.045399402055104e+03,
		1.045844920314461e+03,		1.046289287573255e+03,		1.046732510425710e+03,		1.047174595408006e+03,		1.047615548998972e+03,
		1.048055377620758e+03,		1.048494087639515e+03,		1.048931685366041e+03,		1.049368177056441e+03,		1.049803568912763e+03,
		1.050237867083624e+03,		1.050671077664837e+03,		1.051103206700020e+03,		1.051534260181201e+03,		1.051964244049408e+03,
		1.052393164195259e+03,		1.052821026459535e+03,		1.053247836633754e+03,		1.053673600460726e+03,		1.054098323635108e+03,
		1.054522011803952e+03,		1.054944670567235e+03,		1.055366305478392e+03,		1.055786922044841e+03,		1.056206525728489e+03,
		1.056625121946250e+03,		1.057042716070535e+03,		1.057459313429750e+03,		1.057874919308782e+03,		1.058289538949479e+03,
		1.058703177551120e+03,		1.059115840270884e+03,		1.059527532224306e+03,		1.059938258485737e+03,		1.060348024088785e+03,
		1.060756834026759e+03,		1.061164693253103e+03,		1.061571606681828e+03,		1.061977579187929e+03,		1.062382615607812e+03,
		1.062786720739696e+03,		1.063189899344028e+03,		1.063592156143879e+03,		1.063993495825340e+03,		1.064393923037916e+03,
		1.064793442394906e+03,		1.065192058473788e+03,		1.065589775816591e+03,		1.065986598930266e+03,		1.066382532287052e+03,
		1.066777580324834e+03,		1.067171747447503e+03,		1.067565038025304e+03,		1.067957456395182e+03,		1.068349006861129e+03,
		1.068739693694513e+03,		1.069129521134420e+03,		1.069518493387977e+03,		1.069906614630683e+03,		1.070293889006722e+03,
		1.070680320629285e+03,		1.071065913580880e+03,		1.071450671913644e+03,		1.071834599649641e+03,		1.072217700781170e+03,
		1.072599979271058e+03,		1.072981439052955e+03,		1.073362084031622e+03,		1.073741918083217e+03,		1.074120945055580e+03,
		1.074499168768509e+03,		1.074876593014037e+03,		1.075253221556703e+03,		1.075629058133823e+03,		1.076004106455753e+03,
		1.076378370206151e+03,		1.076751853042239e+03,		1.077124558595053e+03,		1.077496490469703e+03,		1.077867652245618e+03,
		1.078238047476792e+03,		1.078607679692031e+03,		1.078976552395188e+03,		1.079344669065411e+03,		1.079712033157365e+03,
		1.080078648101473e+03,		1.080444517304144e+03,		1.080809644147997e+03,		1.081174031992085e+03,		1.081537684172121e+03,
		1.081900604000690e+03,		1.082262794767470e+03,		1.082624259739443e+03,		1.082985002161108e+03,		1.083345025254686e+03,
		1.083704332220332e+03,		1.084062926236332e+03,		1.084420810459309e+03,		1.084777988024420e+03,		1.085134462045555e+03,
		1.085490235615528e+03,		1.085845311806270e+03,		1.086199693669023e+03,		1.086553384234523e+03,		1.086906386513187e+03,
		1.087258703495299e+03,		1.087610338151188e+03,		1.087961293431408e+03,		1.088311572266920e+03,		1.088661177569260e+03,
		1.089010112230719e+03,		1.089358379124511e+03,		1.089705981104940e+03,		1.090052921007575e+03,		1.090399201649411e+03,
		1.090744825829033e+03,		1.091089796326778e+03,		1.091434115904896e+03,		1.091777787307712e+03,		1.092120813261773e+03,
		1.092463196476015e+03,		1.092804939641911e+03,		1.093146045433617e+03,		1.093486516508134e+03,		1.093826355505447e+03,
		1.094165565048673e+03,		1.094504147744213e+03,		1.094842106181885e+03,		1.095179442935076e+03,		1.095516160560877e+03,
		1.095852261600221e+03,		1.096187748578025e+03,		1.096522624003326e+03,		1.096856890369407e+03,		1.097190550153943e+03
	},
	{
		1.680967569825741e+00,		5.088486185310923e+00,		8.554256607826041e+00,		1.208075268470007e+01,		1.567061829312491e+01,
		1.932668325524581e+01,		2.305198116576178e+01,		2.684976941665226e+01,		3.072355175458297e+01,		3.467710376820753e+01,
		3.871450177758666e+01,		4.284015568963297e+01,		4.705884649615052e+01,		5.137576923023247e+01,		5.579658236973923e+01,
		6.032746489279477e+01,		6.497518246223888e+01,		6.974716456043436e+01,		7.465159483511951e+01,		7.969751748136993e+01,
		8.489496321547456e+01,		9.025509935048147e+01,		9.579040973938585e+01,		1.015149120214718e+02,		1.074444218479060e+02,
		1.135968768009181e+02,		1.199927368862603e+02,		1.266554842564133e+02,		1.336122529366056e+02,		1.408946308739181e+02,
		1.485396932965144e+02,		1.565913507827863e+02,		1.651021317561918e+02,		1.741355740072217e+02,		1.837694840980050e+02,
		1.941004546708883e+02,		2.052502358852306e+02,		2.173748812299523e+02,		2.306780845329619e+02,		2.454308190578660e+02,
		2.620000665308621e+02,		2.808887913131549e+02,		3.027822851259435e+02,		3.285687745101322e+02,		3.592411701040928e+02,
		3.954739729199780e+02,		4.361885532603270e+02,		4.767637260659093e+02,		5.128973276554864e+02,		5.430552555247360e+02,
		5.676531567595158e+02,		5.879188147670070e+02,		6.049731952097502e+02,		6.196270082125919e+02,		6.324425265816733e+02,
		6.438155384571700e+02,		6.540319270066786e+02,		6.633033973572932e+02,		6.717902591129016e+02,		6.796163381646387e+02,
		6.868789848543360e+02,		6.936559460799853e+02,		7.000101855544896e+02,		7.059933331530987e+02,		7.116481996028402e+02,
		7.170106413383287e+02,		7.221109650375598e+02,		7.269750003447554e+02,		7.316249295468275e+02,		7.360799366093003e+02,
		7.403567201722382e+02,		7.444699028665384e+02,		7.484323607552351e+02,		7.522554906303492e+02,		7.559494285219056e+02,
		7.595232295847122e+02,		7.629850171728796e+02,		7.663421071542573e+02,		7.696011121924402e+02,		7.727680297167942e+02,
		7.758483165288378e+02,		7.788469523967711e+02,		7.817684945257629e+02,		7.846171244279750e+02,		7.873966884297247e+02,
		7.901107328258026e+02,		7.927625345097536e+02,		7.953551277634695e+02,		7.978913277723265e+02,		8.003737513371148e+02,
		8.028048351767721e+02,		8.051868521526814e+02,		8.075219256934280e+02,		8.098120426560473e+02,		8.120590648242932e+02,
		8.142647392149682e+02,		8.164307073386891e+02,		8.185585135407400e+02,		8.206496125303811e+02,		8.227053761921521e+02,
		8.247270997604024e+02,		8.267160074275849e+02,		8.286732574479001e+02,		8.305999467901037e+02,		8.324971153866915e+02,
		8.343657500209482e+02,		8.362067878884370e+02,		8.380211198652300e+02,		8.398095935114754e+02,		8.415730158356811e+02,
		8.433121558422984e+02,		8.450277468826874e+02,		8.467204888274366e+02,		8.483910500761071e+02,		8.500400694187682e+02,
		8.516681577622736e+02,		8.532758997328880e+02,		8.548638551657328e+02,		8.564325604905156e+02,		8.579825300220560e+02,
		8.595142571633535e+02,		8.610282155281985e+02,		8.625248599896779e+02,		8.640046276603682e+02,		8.654679388094505e+02,
		8.669151977215676e+02,		8.683467935017795e+02,		8.697631008306214e+02,		8.711644806729148e+02,		8.725512809436674e+02,
		8.739238371341580e+02,		8.752824729009876e+02,		8.766275006207038e+02,		8.779592219123742e+02,		8.792779281302896e+02,
		8.805839008288168e+02,		8.818774122012798e+02,		8.831587254945440e+02,		8.844280954009395e+02,		8.856857684289555e+02,
		8.869319832540857e+02,		8.881669710510616e+02,		8.893909558086630e+02,		8.906041546281723e+02,		8.918067780064863e+02,
		8.929990301048043e+02,		8.941811090037903e+02,		8.953532069459836e+02,		8.965155105662375e+02,		8.976682011108680e+02,
		8.988114546461824e+02,		8.999454422569897e+02,		9.010703302356626e+02,		9.021862802622932e+02,		9.032934495764213e+02,
		9.043919911408288e+02,		9.054820537978145e+02,		9.065637824183603e+02,		9.076373180445941e+02,		9.087027980258681e+02,
		9.097603561488386e+02,		9.108101227618224e+02,		9.118522248937495e+02,		9.128867863679841e+02,		9.139139279112879e+02,
		9.149337672581482e+02,		9.159464192507345e+02,		9.169519959346806e+02,		9.179506066509095e+02,		9.189423581236905e+02,
		9.199273545451158e+02,		9.209056976561704e+02,		9.218774868245580e+02,		9.228428191194338e+02,		9.238017893831983e+02,
		9.247544903004814e+02,		9.257010124644595e+02,		9.266414444406114e+02,		9.275758728280471e+02,		9.285043823185152e+02,
		9.294270557531912e+02,		9.303439741773363e+02,		9.312552168929519e+02,		9.321608615094860e+02,		9.330609839926946e+02,
		9.339556587117276e+02,		9.348449584845351e+02,		9.357289546216446e+02,		9.366077169683875e+02,		9.374813139456423e+02,
		9.383498125891618e+02,		9.392132785875228e+02,		9.400717763187856e+02,		9.409253688858886e+02,		9.417741181508482e+02,
		9.426180847678017e+02,		9.434573282149513e+02,		9.442919068254361e+02,		9.451218778171921e+02,		9.459472973218340e+02,
		9.467682204125906e+02,		9.475847011313407e+02,		9.483967925147790e+02,		9.492045466197470e+02,		9.500080145477598e+02,
		9.508072464687607e+02,		9.516022916441334e+02,		9.523931984489971e+02,		9.531800143938117e+02,		9.539627861453238e+02,
		9.547415595468721e+02,		9.555163796380689e+02,		9.562872906739054e+02,		9.570543361432735e+02,		9.578175587869349e+02,
		9.585770006149698e+02,		9.593327029237022e+02,		9.600847063121362e+02,		9.608330506979153e+02,		9.615777753328198e+02,
		9.623189188178210e+02,		9.630565191177053e+02,		9.637906135752847e+02,		9.645212389252065e+02,		9.652484313073791e+02,
		9.659722262800171e+02,		9.666926588323357e+02,		9.674097633968871e+02,		9.681235738615609e+02,		9.688341235812655e+02,
		9.695414453892823e+02,		9.702455716083253e+02,		9.709465340612944e+02,		9.716443640817554e+02,		9.723390925241300e+02,
		9.730307497736279e+02,		9.737193657559141e+02,		9.744049699465246e+02,		9.750875913800444e+02,		9.757672586590385e+02,
		9.764439999627682e+02,		9.771178430556755e+02,		9.777888152956535e+02,		9.784569436421151e+02,		9.791222546638567e+02,
		9.797847745467176e+02,		9.804445291010657e+02,		9.811015437690867e+02,		9.817558436318974e+02,		9.824074534164856e+02,
		9.830563975024859e+02,		9.837026999287856e+02,		9.843463843999729e+02,		9.849874742926386e+02,		9.856259926615154e+02,
		9.862619622454846e+02,		9.868954054734326e+02,		9.875263444699732e+02,		9.881548010610384e+02,		9.887807967793370e+02,
		9.894043528696858e+02,		9.900254902942265e+02,		9.906442297375131e+02,		9.912605916114867e+02,		9.918745960603460e+02,
		9.924862629652947e+02,		9.930956119491897e+02,		9.937026623810920e+02,		9.943074333806987e+02,		9.949099438226989e+02,
		9.955102123410137e+02,		9.961082573329600e+02,		9.967040969633099e+02,		9.972977491682739e+02,		9.978892316593876e+02,
		9.984785619273241e+02,		9.990657572456178e+02,		9.996508346743110e+02,		1.000233811063528e+03,		1.000814703056966e+03,
		1.001393527095314e+03,		1.001970299419610e+03,		1.002545036074515e+03,		1.003117752911526e+03,		1.003688465592122e+03,
		1.004257189590844e+03,		1.004823940198315e+03,		1.005388732524197e+03,		1.005951581500080e+03,		1.006512501882331e+03,
		1.007071508254866e+03,		1.007628615031883e+03,		1.008183836460522e+03,		1.008737186623496e+03,		1.009288679441646e+03,
		1.009838328676462e+03,		1.010386147932547e+03,		1.010932150660041e+03,		1.011476350156981e+03,		1.012018759571637e+03,
		1.012559391904784e+03,		1.013098260011946e+03,		1.013635376605582e+03,		1.014170754257245e+03,		1.014704405399688e+03,
		1.015236342328937e+03,		1.015766577206325e+03,		1.016295122060482e+03,		1.016821988789295e+03,		1.017347189161828e+03,
		1.017870734820208e+03,		1.018392637281471e+03,		1.018912907939381e+03,		1.019431558066215e+03,		1.019948598814508e+03,
		1.020464041218776e+03,		1.020977896197202e+03,		1.021490174553293e+03,		1.022000886977504e+03,		1.022510044048845e+03,
		1.023017656236438e+03,		1.023523733901070e+03,		1.024028287296703e+03,		1.024531326571959e+03,		1.025032861771587e+03,
		1.025532902837894e+03,		1.026031459612161e+03,		1.026528541836026e+03,		1.027024159152847e+03,		1.027518321109042e+03,
		1.028011037155405e+03,		1.028502316648402e+03,		1.028992168851432e+03,		1.029480602936093e+03,		1.029967627983399e+03,
		1.030453252984987e+03,		1.030937486844317e+03,		1.031420338377824e+03,		1.031901816316082e+03,		1.032381929304917e+03,
		1.032860685906532e+03,		1.033338094600587e+03,		1.033814163785285e+03,		1.034288901778418e+03,		1.034762316818412e+03,
		1.035234417065350e+03,		1.035705210601970e+03,		1.036174705434668e+03,		1.036642909494458e+03,		1.037109830637938e+03,
		1.037575476648230e+03,		1.038039855235906e+03,		1.038502974039904e+03,		1.038964840628426e+03,		1.039425462499815e+03,
		1.039884847083440e+03,		1.040343001740533e+03,		1.040799933765050e+03,		1.041255650384491e+03,		1.041710158760717e+03,
		1.042163465990760e+03,		1.042615579107613e+03,		1.043066505081003e+03,		1.043516250818169e+03,		1.043964823164614e+03,
		1.044412228904843e+03,		1.044858474763110e+03,		1.045303567404127e+03,		1.045747513433782e+03,		1.046190319399841e+03,
		1.046631991792628e+03,		1.047072537045720e+03,		1.047511961536605e+03,		1.047950271587344e+03,		1.048387473465223e+03,
		1.048823573383393e+03,		1.049258577501499e+03,		1.049692491926301e+03,		1.050125322712292e+03,		1.050557075862294e+03,
		1.050987757328059e+03,		1.051417373010849e+03,		1.051845928762022e+03,		1.052273430383593e+03,		1.052699883628799e+03,
		1.053125294202654e+03,		1.053549667762488e+03,		1.053973009918493e+03,		1.054395326234245e+03,		1.054816622227233e+03,
		1.055236903369366e+03,		1.055656175087490e+03,		1.056074442763882e+03,		1.056491711736744e+03,		1.056907987300694e+03,
		1.057323274707243e+03,		1.057737579165266e+03,		1.058150905841474e+03,		1.058563259860869e+03,		1.058974646307204e+03,
		1.059385070223426e+03,		1.059794536612115e+03,		1.060203050435930e+03,		1.060610616618028e+03,		1.061017240042495e+03,
		1.061422925554759e+03,		1.061827677962006e+03,		1.062231502033586e+03,		1.062634402501415e+03,		1.063036384060369e+03,
		1.063437451368677e+03,		1.063837609048307e+03,		1.064236861685346e+03,		1.064635213830374e+03,		1.065032669998838e+03,
		1.065429234671411e+03,		1.065824912294364e+03,		1.066219707279911e+03,		1.066613624006569e+03,		1.067006666819497e+03,
		1.067398840030849e+03,		1.067790147920099e+03,		1.068180594734388e+03,		1.068570184688846e+03,		1.068958921966916e+03,
		1.069346810720677e+03,		1.069733855071166e+03,		1.070120059108684e+03,		1.070505426893106e+03,		1.070889962454189e+03,
		1.071273669791872e+03,		1.071656552876572e+03,		1.072038615649480e+03,		1.072419862022849e+03,		1.072800295880282e+03,
		1.073179921077012e+03,		1.073558741440186e+03,		1.073936760769136e+03,		1.074313982835655e+03,		1.074690411384264e+03,
		1.075066050132478e+03,		1.075440902771070e+03,		1.075814972964328e+03,		1.076188264350314e+03,		1.076560780541114e+03,
		1.076932525123090e+03,		1.077303501657126e+03,		1.077673713678872e+03,		1.078043164698985e+03,		1.078411858203369e+03,
		1.078779797653407e+03,		1.079146986486194e+03,		1.079513428114771e+03,		1.079879125928344e+03,		1.080244083292517e+03,
		1.080608303549508e+03,		1.080971790018368e+03,		1.081334545995200e+03,		1.081696574753371e+03,		1.082057879543725e+03,
		1.082418463594790e+03,		1.082778330112984e+03,		1.083137482282823e+03,		1.083495923267119e+03,		1.083853656207177e+03,
		1.084210684223000e+03,		1.084567010413476e+03,		1.084922637856575e+03,		1.085277569609536e+03,		1.085631808709059e+03,
		1.085985358171487e+03,		1.086338220992992e+03,		1.086690400149759e+03,		1.087041898598159e+03,		1.087392719274935e+03,
		1.087742865097371e+03,		1.088092338963469e+03,		1.088441143752119e+03,		1.088789282323272e+03,		1.089136757518103e+03,
		1.089483572159183e+03,		1.089829729050636e+03,		1.090175230978308e+03,		1.090520080709926e+03,		1.090864280995252e+03,
		1.091207834566245e+03,		1.091550744137218e+03,		1.091893012404985e+03,		1.092234642049019e+03,		1.092575635731600e+03,
		1.092915996097960e+03,		1.093255725776438e+03,		1.093594827378620e+03,		1.093933303499481e+03,		1.094271156717533e+03,
		1.094608389594963e+03,		1.094945004677770e+03,		1.095281004495908e+03,		1.095616391563417e+03,		1.095951168378559e+03
	},
	{
		1.677723945461853e+00,		5.078393040251763e+00,		8.536807053522610e+00,		1.205539748316107e+01,		1.563676139619058e+01,
		1.928367676068120e+01,		2.299911959832851e+01,		2.678628322522385e+01,		3.064859989557251e+01,		3.458976522015607e+01,
		3.861376580053453e+01,		4.272491060433978e+01,		4.692786671036232e+01,		5.122770017942699e+01,		5.562992296470630e+01,
		6.014054697150625e+01,		6.476614662269610e+01,		6.951393159641086e+01,		7.439183179689662e+01,		7.940859712353715e+01,
		8.457391525267776e+01,		8.989855149035273e+01,		9.539451585840354e+01,		1.010752640350939e+02,		1.069559407156141e+02,
		1.130536765748631e+02,		1.193879535737607e+02,		1.259810582430023e+02,		1.328586493822581e+02,		1.400504761905948e+02,
		1.475912964990011e+02,		1.555220645046322e+02,		1.638914863022937e+02,		1.727580844133456e+02,		1.821929770439442e+02,
		1.922836759034915e+02,		2.031393563383153e+02,		2.148982811584214e+02,		2.277383933653711e+02,		2.418925308665548e+02,
		2.576700840714278e+02,		2.754863586600212e+02,		2.958963354111157e+02,		3.196127291709315e+02,		3.474496359159286e+02,
		3.800794219576673e+02,		4.172948830323705e+02,		4.564402836161981e+02,		4.931562055165617e+02,		5.251052163608891e+02,
		5.517569037636027e+02,		5.738234750303492e+02,		5.923344659648246e+02,		6.081556876372051e+02,		6.219184116975057e+02,
		6.340723137383982e+02,		6.449422631538208e+02,		6.547681606351775e+02,		6.637310074166029e+02,		6.719700661203791e+02,
		6.795943921457990e+02,		6.866907479803343e+02,		6.933291445700861e+02,		6.995667955785547e+02,		7.054509904415411e+02,
		7.110212174497057e+02,		7.163107573224229e+02,		7.213478965002380e+02,		7.261568629067297e+02,		7.307585561366059e+02,
		7.351711232899338e+02,		7.394104174742358e+02,		7.434903661157218e+02,		7.474232692365772e+02,		7.512200428454508e+02,
		7.548904189459836e+02,		7.584431109870383e+02,		7.618859515823553e+02,		7.652260078261672e+02,		7.684696783917295e+02,
		7.716227757269496e+02,		7.746905959880643e+02,		7.776779788285587e+02,		7.805893587509893e+02,		7.834288094064742e+02,
		7.862000819709275e+02,		7.889066385233463e+02,		7.915516811880992e+02,		7.941381776717193e+02,		7.966688837182322e+02,
		7.991463629205100e+02,		8.015730042544283e+02,		8.039510376445820e+02,		8.062825478225066e+02,		8.085694866987387e+02,
		8.108136844372608e+02,		8.130168593933575e+02,		8.151806270530292e+02,		8.173065080927711e+02,		8.193959356622681e+02,
		8.214502619788112e+02,		8.234707643105290e+02,		8.254586504155626e+02,		8.274150634958381e+02,		8.293410867167756e+02,
		8.312377473380039e+02,		8.331060204947637e+02,		8.349468326649813e+02,		8.367610648529849e+02,		8.385495555172704e+02,
		8.403131032667044e+02,		8.420524693468203e+02,		8.437683799355772e+02,		8.454615282658456e+02,		8.471325765900907e+02,
		8.487821580011483e+02,		8.504108781215399e+02,		8.520193166725621e+02,		8.536080289332664e+02,		8.551775470984589e+02,
		8.567283815439805e+02,		8.582610220067634e+02,		8.597759386864067e+02,		8.612735832745057e+02,		8.627543899172611e+02,
		8.642187761165225e+02,		8.656671435739059e+02,		8.670998789822370e+02,		8.685173547681843e+02,		8.699199297896641e+02,
		8.713079499912616e+02,		8.726817490206428e+02,		8.740416488087208e+02,		8.753879601160637e+02,		8.767209830479076e+02,
		8.780410075398673e+02,		8.793483138163317e+02,		8.806431728233642e+02,		8.819258466377673e+02,		8.831965888538842e+02,
		8.844556449495485e+02,		8.857032526325308e+02,		8.869396421686911e+02,		8.881650366930032e+02,		8.893796525044839e+02,
		8.905836993460315e+02,		8.917773806700789e+02,		8.929608938909115e+02,		8.941344306244490e+02,		8.952981769162200e+02,
		8.964523134582239e+02,		8.975970157953219e+02,		8.987324545217530e+02,		8.998587954683310e+02,		9.009761998808661e+02,
		9.020848245902673e+02,		9.031848221748124e+02,		9.042763411150033e+02,		9.053595259414050e+02,		9.064345173758544e+02,
		9.075014524663849e+02,		9.085604647161961e+02,		9.096116842069952e+02,		9.106552377169861e+02,		9.116912488337852e+02,
		9.127198380625393e+02,		9.137411229294554e+02,		9.147552180810159e+02,		9.157622353790489e+02,		9.167622839918992e+02,
		9.177554704818608e+02,		9.187418988890718e+02,		9.197216708120320e+02,		9.206948854849071e+02,		9.216616398517810e+02,
		9.226220286379837e+02,		9.235761444186467e+02,		9.245240776846025e+02,		9.254659169057650e+02,		9.264017485920925e+02,
		9.273316573522500e+02,		9.282557259500668e+02,		9.291740353589066e+02,		9.300866648140156e+02,		9.309936918629663e+02,
		9.318951924142531e+02,		9.327912407841459e+02,		9.336819097418514e+02,		9.345672705530829e+02,		9.354473930220752e+02,
		9.363223455321345e+02,		9.371921950847778e+02,		9.380570073375127e+02,		9.389168466403254e+02,		9.397717760709211e+02,
		9.406218574687747e+02,		9.414671514680350e+02,		9.423077175293261e+02,		9.431436139705045e+02,		9.439748979963931e+02,
		9.448016257275455e+02,		9.456238522280798e+02,		9.464416315326075e+02,		9.472550166723031e+02,		9.480640597001445e+02,
		9.488688117153462e+02,		9.496693228870388e+02,		9.504656424771974e+02,		9.512578188628578e+02,		9.520458995576564e+02,
		9.528299312327082e+02,		9.536099597368388e+02,		9.543860301162201e+02,		9.551581866334033e+02,		9.559264727857893e+02,
		9.566909313235507e+02,		9.574516042670201e+02,		9.582085329235789e+02,		9.589617579040382e+02,		9.597113191385641e+02,
		9.604572558921257e+02,		9.611996067795166e+02,		9.619384097799366e+02,		9.626737022511738e+02,		9.634055209433726e+02,
		9.641339020124321e+02,		9.648588810330226e+02,		9.655804930112457e+02,		9.662987723969447e+02,		9.670137530956856e+02,
		9.677254684803993e+02,		9.684339514027259e+02,		9.691392342040460e+02,		9.698413487262095e+02,		9.705403263219995e+02,
		9.712361978653033e+02,		9.719289937610182e+02,		9.726187439547131e+02,		9.733054779420164e+02,		9.739892247777834e+02,
		9.746700130850141e+02,		9.753478710635463e+02,		9.760228264985346e+02,		9.766949067687061e+02,		9.773641388544121e+02,
		9.780305493454840e+02,		9.786941644488809e+02,		9.793550099961631e+02,		9.800131114507708e+02,		9.806684939151302e+02,
		9.813211821375801e+02,		9.819712005191425e+02,		9.826185731201194e+02,		9.832633236665301e+02,		9.839054755564100e+02,
		9.845450518659383e+02,		9.851820753554396e+02,		9.858165684752355e+02,		9.864485533713573e+02,		9.870780518911334e+02,
		9.877050855886430e+02,		9.883296757300403e+02,		9.889518432987645e+02,		9.895716090006272e+02,		9.901889932687816e+02,
		9.908040162685826e+02,		9.914166979023395e+02,		9.920270578139548e+02,		9.926351153934706e+02,		9.932408897815027e+02,
		9.938443998735856e+02,		9.944456643244184e+02,		9.950447015520166e+02,		9.956415297417770e+02,		9.962361668504495e+02,
		9.968286306100332e+02,		9.974189385315742e+02,		9.980071079088938e+02,		9.985931558222373e+02,		9.991770991418333e+02,
		9.997589545313958e+02,		1.000338738451538e+03,		1.000916467163123e+03,		1.001492156730538e+03,		1.002065823024914e+03,
		1.002637481727260e+03,		1.003207148331549e+03,		1.003774838147731e+03,		1.004340566304694e+03,		1.004904347753155e+03,
		1.005466197268496e+03,		1.006026129453549e+03,		1.006584158741317e+03,		1.007140299397646e+03,		1.007694565523843e+03,
		1.008246971059235e+03,		1.008797529783696e+03,		1.009346255320103e+03,		1.009893161136756e+03,		1.010438260549751e+03,
		1.010981566725307e+03,		1.011523092682037e+03,		1.012062851293194e+03,		1.012600855288859e+03,		1.013137117258100e+03,
		1.013671649651069e+03,		1.014204464781091e+03,		1.014735574826681e+03,		1.015264991833548e+03,		1.015792727716549e+03,
		1.016318794261606e+03,		1.016843203127598e+03,		1.017365965848207e+03,		1.017887093833733e+03,		1.018406598372880e+03,
		1.018924490634508e+03,		1.019440781669345e+03,		1.019955482411687e+03,		1.020468603681038e+03,		1.020980156183754e+03,
		1.021490150514634e+03,		1.021998597158489e+03,		1.022505506491687e+03,		1.023010888783666e+03,		1.023514754198424e+03,
		1.024017112795981e+03,		1.024517974533813e+03,		1.025017349268266e+03,		1.025515246755942e+03,		1.026011676655064e+03,
		1.026506648526813e+03,		1.027000171836643e+03,		1.027492255955581e+03,		1.027982910161495e+03,		1.028472143640345e+03,
		1.028959965487409e+03,		1.029446384708499e+03,		1.029931410221144e+03,		1.030415050855758e+03,		1.030897315356792e+03,
		1.031378212383860e+03,		1.031857750512852e+03,		1.032335938237030e+03,		1.032812783968096e+03,		1.033288296037254e+03,
		1.033762482696248e+03,		1.034235352118385e+03,		1.034706912399542e+03,		1.035177171559158e+03,		1.035646137541201e+03,
		1.036113818215135e+03,		1.036580221376860e+03,		1.037045354749636e+03,		1.037509225985003e+03,		1.037971842663675e+03,
		1.038433212296427e+03,		1.038893342324965e+03,		1.039352240122783e+03,		1.039809912996008e+03,		1.040266368184228e+03,
		1.040721612861312e+03,		1.041175654136214e+03,		1.041628499053764e+03,		1.042080154595454e+03,		1.042530627680197e+03,
		1.042979925165094e+03,		1.043428053846170e+03,		1.043875020459117e+03,		1.044320831680006e+03,		1.044765494126010e+03,
		1.045209014356096e+03,		1.045651398871720e+03,		1.046092654117507e+03,		1.046532786481922e+03,		1.046971802297926e+03,
		1.047409707843633e+03,		1.047846509342943e+03,		1.048282212966181e+03,		1.048716824830714e+03,		1.049150351001564e+03,
		1.049582797492018e+03,		1.050014170264217e+03,		1.050444475229742e+03,		1.050873718250199e+03,		1.051301905137784e+03,
		1.051729041655843e+03,		1.052155133519432e+03,		1.052580186395855e+03,		1.053004205905210e+03,		1.053427197620911e+03,
		1.053849167070219e+03,		1.054270119734751e+03,		1.054690061050994e+03,		1.055108996410800e+03,		1.055526931161883e+03,
		1.055943870608308e+03,		1.056359820010969e+03,		1.056774784588065e+03,		1.057188769515562e+03,		1.057601779927662e+03,
		1.058013820917250e+03,		1.058424897536347e+03,		1.058835014796549e+03,		1.059244177669467e+03,		1.059652391087151e+03,
		1.060059659942522e+03,		1.060465989089783e+03,		1.060871383344839e+03,		1.061275847485699e+03,		1.061679386252880e+03,
		1.062082004349805e+03,		1.062483706443193e+03,		1.062884497163444e+03,		1.063284381105021e+03,		1.063683362826828e+03,
		1.064081446852579e+03,		1.064478637671163e+03,		1.064874939737007e+03,		1.065270357470433e+03,		1.065664895258009e+03,
		1.066058557452900e+03,		1.066451348375201e+03,		1.066843272312290e+03,		1.067234333519148e+03,		1.067624536218700e+03,
		1.068013884602134e+03,		1.068402382829223e+03,		1.068790035028647e+03,		1.069176845298301e+03,		1.069562817705606e+03,
		1.069947956287815e+03,		1.070332265052318e+03,		1.070715747976930e+03,		1.071098409010196e+03,		1.071480252071675e+03,
		1.071861281052229e+03,		1.072241499814306e+03,		1.072620912192217e+03,		1.072999521992417e+03,		1.073377332993776e+03,
		1.073754348947842e+03,		1.074130573579120e+03,		1.074506010585324e+03,		1.074880663637639e+03,		1.075254536380984e+03,
		1.075627632434254e+03,		1.075999955390580e+03,		1.076371508817572e+03,		1.076742296257564e+03,		1.077112321227855e+03,
		1.077481587220947e+03,		1.077850097704783e+03,		1.078217856122977e+03,		1.078584865895044e+03,		1.078951130416630e+03,
		1.079316653059735e+03,		1.079681437172931e+03,		1.080045486081591e+03,		1.080408803088092e+03,		1.080771391472046e+03,
		1.081133254490494e+03,		1.081494395378128e+03,		1.081854817347492e+03,		1.082214523589189e+03,		1.082573517272078e+03,
		1.082931801543483e+03,		1.083289379529376e+03,		1.083646254334591e+03,		1.084002429042997e+03,		1.084357906717702e+03,
		1.084712690401238e+03,		1.085066783115744e+03,		1.085420187863154e+03,		1.085772907625377e+03,		1.086124945364479e+03,
		1.086476304022856e+03,		1.086826986523419e+03,		1.087176995769757e+03,		1.087526334646318e+03,		1.087875006018573e+03,
		1.088223012733189e+03,		1.088570357618189e+03,		1.088917043483125e+03,		1.089263073119234e+03,		1.089608449299600e+03,
		1.089953174779316e+03,		1.090297252295634e+03,		1.090640684568133e+03,		1.090983474298860e+03,		1.091325624172491e+03,
		1.091667136856474e+03,		1.092008015001188e+03,		1.092348261240080e+03,		1.092687878189815e+03,		1.093026868450423e+03,
		1.093365234605436e+03,		1.093702979222032e+03,		1.094040104851175e+03,		1.094376614027751e+03,		1.094712509270705e+03
	},
	{
		1.674492993861929e+00,		5.068341562120702e+00,		8.519433565503920e+00,		1.203015893182629e+01,		1.560306881904530e+01,
		1.924089038556612e+01,		2.294654329374058e+01,		2.672315819799387e+01,		3.057409751280609e+01,		3.450297880852979e+01,
		3.851370124685891e+01,		4.261047554536508e+01,		4.679785805531665e+01,		5.108078965339511e+01,		5.546464029161456e+01,
		5.995526022811920e+01,		6.455903918426071e+01,		6.928297495317841e+01,		7.413475333893511e+01,		7.912284175570380e+01,
		8.425659939402594e+01,		8.954640760716265e+01,		9.500382514176569e+01,		1.006417741119608e+02,		1.064747643039711e+02,
		1.125191656540101e+02,		1.187935417852395e+02,		1.253190616366833e+02,		1.321200119288357e+02,		1.392244411653557e+02,
		1.466649770766898e+02,		1.544798753870274e+02,		1.627143808333541e+02,		1.714225150009052e+02,		1.806694551344996e+02,
		1.905347417493497e+02,		2.011166623789036e+02,		2.125383195206680e+02,		2.249561163348772e+02,		2.385716699926090e+02,
		2.536483526336022e+02,		2.705331867114314e+02,		2.896817670419484e+02,		3.116732859653466e+02,		3.371779363663704e+02,
		3.668064409996003e+02,		4.007038958124966e+02,		4.375602135960701e+02,		4.739617877864268e+02,		5.069517781504889e+02,
		5.353284771229655e+02,		5.591512050080174e+02,		5.791742382709089e+02,		5.962337860843826e+02,		6.110069772572081e+02,
		6.239943296972766e+02,		6.355610531346242e+02,		6.459770591193693e+02,		6.554455927474426e+02,		6.641225792495934e+02,
		6.721297264738681e+02,		6.795635408760321e+02,		6.865016426233159e+02,		6.930072668067396e+02,		6.991325266245091e+02,
		7.049208179301502e+02,		7.104086186058900e+02,		7.156268545081034e+02,		7.206019501081491e+02,		7.253566463342718e+02,
		7.299106441427955e+02,		7.342811159690955e+02,		7.384831158519386e+02,		7.425299110292081e+02,		7.464332520913484e+02,
		7.502035946414022e+02,		7.538502823749990e+02,		7.573816992398371e+02,		7.608053966428744e+02,		7.641282003916734e+02,
		7.673563010761692e+02,		7.704953308415821e+02,		7.735504289162160e+02,		7.765262977989313e+02,		7.794272516497125e+02,
		7.822572581405810e+02,		7.850199747961748e+02,		7.877187806708602e+02,		7.903568040622513e+02,		7.929369468423272e+02,
		7.954619058906377e+02,		7.979341920354036e+02,		8.003561468436180e+02,		8.027299575480702e+02,		8.050576703552376e+02,
		8.073412023414826e+02,		8.095823521145427e+02,		8.117828093919172e+02,		8.139441636263549e+02,		8.160679117906852e+02,
		8.181554654190372e+02,		8.202081569885756e+02,		8.222272457149626e+02,		8.242139228253513e+02,		8.261693163647332e+02,
		8.280944955845769e+02,		8.299904749567704e+02,		8.318582178507663e+02,		8.336986399074234e+02,		8.355126121391583e+02,
		8.373009637827146e+02,		8.390644849279113e+02,		8.408039289432127e+02,		8.425200147166868e+02,		8.442134287290027e+02,
		8.458848269733315e+02,		8.475348367355634e+02,		8.491640582468195e+02,		8.507730662191321e+02,		8.523624112740217e+02,
		8.539326212728311e+02,		8.554842025567785e+02,		8.570176411039945e+02,		8.585334036100824e+02,		8.600319384982052e+02,
		8.615136768640934e+02,		8.629790333609723e+02,		8.644284070288711e+02,		8.658621820724942e+02,		8.672807285913715e+02,
		8.686844032657923e+02,		8.700735500016565e+02,		8.714485005371610e+02,		8.728095750139918e+02,		8.741570825154561e+02,
		8.754913215738521e+02,		8.768125806491116e+02,		8.781211385806703e+02,		8.794172650143189e+02,		8.807012208056733e+02,
		8.819732584017844e+02,		8.832336222022857e+02,		8.844825489013670e+02,		8.857202678117886e+02,		8.869470011720532e+02,
		8.881629644377568e+02,		8.893683665580951e+02,		8.905634102384192e+02,		8.917482921896697e+02,		8.929232033654635e+02,
		8.940883291875656e+02,		8.952438497604118e+02,		8.963899400753149e+02,		8.975267702049429e+02,		8.986545054886151e+02,
		8.997733067089356e+02,		9.008833302602395e+02,		9.019847283092995e+02,		9.030776489487279e+02,		9.041622363434465e+02,
		9.052386308706164e+02,		9.063069692533630e+02,		9.073673846886254e+02,		9.084200069694365e+02,		9.094649626019236e+02,
		9.105023749173007e+02,		9.115323641791023e+02,		9.125550476859008e+02,		9.135705398697449e+02,		9.145789523905098e+02,
		9.155803942263768e+02,		9.165749717606345e+02,		9.175627888649576e+02,		9.185439469793627e+02,		9.195185451889730e+02,
		9.204866802977631e+02,		9.214484468994103e+02,		9.224039374454021e+02,		9.233532423105116e+02,		9.242964498557745e+02,
		9.252336464890757e+02,		9.261649167234502e+02,		9.270903432332137e+02,		9.280100069079994e+02,		9.289239869048207e+02,
		9.298323606982140e+02,		9.307352041285798e+02,		9.316325914487671e+02,		9.325245953690098e+02,		9.334112871002500e+02,
		9.342927363959509e+02,		9.351690115924362e+02,		9.360401796478359e+02,		9.369063061796818e+02,		9.377674555012237e+02,
		9.386236906565031e+02,		9.394750734542469e+02,		9.403216645006222e+02,		9.411635232309029e+02,		9.420007079400851e+02,
		9.428332758124978e+02,		9.436612829504488e+02,		9.444847844019406e+02,		9.453038341874932e+02,		9.461184853261127e+02,
		9.469287898604233e+02,		9.477347988810252e+02,		9.485365625500671e+02,		9.493341301241020e+02,		9.501275499762211e+02,
		9.509168696175186e+02,		9.517021357178904e+02,		9.524833941262091e+02,		9.532606898898835e+02,		9.540340672738365e+02,
		9.548035697789123e+02,		9.555692401597450e+02,		9.563311204420909e+02,		9.570892519396650e+02,		9.578436752704814e+02,
		9.585944303727175e+02,		9.593415565201346e+02,		9.600850923370461e+02,		9.608250758128621e+02,		9.615615443162354e+02,
		9.622945346087902e+02,		9.630240828584883e+02,		9.637502246526127e+02,		9.644729950103928e+02,		9.651924283952894e+02,
		9.659085587269436e+02,		9.666214193927966e+02,		9.673310432594029e+02,		9.680374626834341e+02,		9.687407095223987e+02,
		9.694408151450654e+02,		9.701378104416227e+02,		9.708317258335682e+02,		9.715225912833371e+02,		9.722104363036843e+02,
		9.728952899668283e+02,		9.735771809133514e+02,		9.742561373608813e+02,		9.749321871125500e+02,		9.756053575652387e+02,
		9.762756757176116e+02,		9.769431681779602e+02,		9.776078611718422e+02,		9.782697805495345e+02,		9.789289517933081e+02,
		9.795854000245190e+02,		9.802391500105285e+02,		9.808902261714560e+02,		9.815386525867742e+02,		9.821844530017358e+02,
		9.828276508336572e+02,		9.834682691780503e+02,		9.841063308146025e+02,		9.847418582130290e+02,		9.853748735387793e+02,
		9.860053986586139e+02,		9.866334551460507e+02,		9.872590642866871e+02,		9.878822470834051e+02,		9.885030242614470e+02,
		9.891214162733799e+02,		9.897374433039630e+02,		9.903511252748768e+02,		9.909624818493726e+02,		9.915715324368066e+02,
		9.921782961970717e+02,		9.927827920449415e+02,		9.933850386543074e+02,		9.939850544623299e+02,		9.945828576735017e+02,
		9.951784662636147e+02,		9.957718979836503e+02,		9.963631703635804e+02,		9.969523007160884e+02,		9.975393061402149e+02,
		9.981242035249207e+02,		9.987070095525795e+02,		9.992877407023931e+02,		9.998664132537393e+02,		1.000443043289448e+03,
		1.001017646699009e+03,		1.001590239181720e+03,		1.002160836249754e+03,		1.002729453231187e+03,		1.003296105272943e+03,
		1.003860807343695e+03,		1.004423574236693e+03,		1.004984420572553e+03,		1.005543360801974e+03,		1.006100409208406e+03,
		1.006655579910673e+03,		1.007208886865533e+03,		1.007760343870191e+03,		1.008309964564770e+03,		1.008857762434722e+03,
		1.009403750813205e+03,		1.009947942883399e+03,		1.010490351680794e+03,		1.011030990095418e+03,		1.011569870874040e+03,
		1.012107006622310e+03,		1.012642409806882e+03,		1.013176092757475e+03,		1.013708067668909e+03,		1.014238346603101e+03,
		1.014766941491018e+03,		1.015293864134603e+03,		1.015819126208653e+03,		1.016342739262674e+03,		1.016864714722696e+03,
		1.017385063893059e+03,		1.017903797958158e+03,		1.018420927984168e+03,		1.018936464920726e+03,		1.019450419602593e+03,
		1.019962802751280e+03,		1.020473624976649e+03,		1.020982896778478e+03,		1.021490628548008e+03,		1.021996830569456e+03,
		1.022501513021507e+03,		1.023004685978770e+03,		1.023506359413222e+03,		1.024006543195613e+03,		1.024505247096860e+03,
		1.025002480789404e+03,		1.025498253848555e+03,		1.025992575753806e+03,		1.026485455890130e+03,		1.026976903549249e+03,
		1.027466927930888e+03,		1.027955538144002e+03,		1.028442743207987e+03,		1.028928552053870e+03,		1.029412973525471e+03,
		1.029896016380561e+03,		1.030377689291987e+03,		1.030858000848785e+03,		1.031336959557270e+03,		1.031814573842119e+03,
		1.032290852047420e+03,		1.032765802437718e+03,		1.033239433199035e+03,		1.033711752439878e+03,		1.034182768192233e+03,
		1.034652488412532e+03,		1.035120920982618e+03,		1.035588073710687e+03,		1.036053954332219e+03,		1.036518570510884e+03,
		1.036981929839452e+03,		1.037444039840670e+03,		1.037904907968136e+03,		1.038364541607159e+03,		1.038822948075598e+03,
		1.039280134624697e+03,		1.039736108439906e+03,		1.040190876641676e+03,		1.040644446286264e+03,		1.041096824366505e+03,
		1.041548017812587e+03,		1.041998033492804e+03,		1.042446878214305e+03,		1.042894558723826e+03,		1.043341081708413e+03,
		1.043786453796136e+03,		1.044230681556790e+03,		1.044673771502585e+03,		1.045115730088829e+03,		1.045556563714597e+03,
		1.045996278723393e+03,		1.046434881403796e+03,		1.046872377990109e+03,		1.047308774662987e+03,		1.047744077550060e+03,
		1.048178292726544e+03,		1.048611426215850e+03,		1.049043483990175e+03,		1.049474471971097e+03,		1.049904396030143e+03,
		1.050333261989368e+03,		1.050761075621914e+03,		1.051187842652563e+03,		1.051613568758285e+03,		1.052038259568777e+03,
		1.052461920666991e+03,		1.052884557589660e+03,		1.053306175827813e+03,		1.053726780827285e+03,		1.054146377989213e+03,
		1.054564972670541e+03,		1.054982570184497e+03,		1.055399175801080e+03,		1.055814794747532e+03,		1.056229432208807e+03,
		1.056643093328033e+03,		1.057055783206961e+03,		1.057467506906425e+03,		1.057878269446770e+03,		1.058288075808303e+03,
		1.058696930931713e+03,		1.059104839718500e+03,		1.059511807031397e+03,		1.059917837694774e+03,		1.060322936495059e+03,
		1.060727108181129e+03,		1.061130357464712e+03,		1.061532689020779e+03,		1.061934107487930e+03,		1.062334617468774e+03,
		1.062734223530307e+03,		1.063132930204283e+03,		1.063530741987580e+03,		1.063927663342565e+03,		1.064323698697445e+03,
		1.064718852446624e+03,		1.065113128951050e+03,		1.065506532538558e+03,		1.065899067504208e+03,		1.066290738110619e+03,
		1.066681548588304e+03,		1.067071503135991e+03,		1.067460605920945e+03,		1.067848861079288e+03,		1.068236272716312e+03,
		1.068622844906788e+03,		1.069008581695273e+03,		1.069393487096410e+03,		1.069777565095229e+03,		1.070160819647437e+03,
		1.070543254679715e+03,		1.070924874089999e+03,		1.071305681747766e+03,		1.071685681494317e+03,		1.072064877143045e+03,
		1.072443272479721e+03,		1.072820871262752e+03,		1.073197677223451e+03,		1.073573694066304e+03,		1.073948925469225e+03,
		1.074323375083818e+03,		1.074697046535623e+03,		1.075069943424374e+03,		1.075442069324243e+03,		1.075813427784088e+03,
		1.076184022327685e+03,		1.076553856453982e+03,		1.076922933637321e+03,		1.077291257327678e+03,		1.077658830950891e+03,
		1.078025657908892e+03,		1.078391741579923e+03,		1.078757085318768e+03,		1.079121692456965e+03,		1.079485566303026e+03,
		1.079848710142654e+03,		1.080211127238948e+03,		1.080572820832622e+03,		1.080933794142202e+03,		1.081294050364238e+03,
		1.081653592673502e+03,		1.082012424223190e+03,		1.082370548145120e+03,		1.082727967549924e+03,		1.083084685527245e+03,
		1.083440705145925e+03,		1.083796029454195e+03,		1.084150661479863e+03,		1.084504604230494e+03,		1.084857860693596e+03,
		1.085210433836800e+03,		1.085562326608036e+03,		1.085913541935711e+03,		1.086264082728882e+03,		1.086613951877431e+03,
		1.086963152252231e+03,		1.087311686705318e+03,		1.087659558070054e+03,		1.088006769161297e+03,		1.088353322775559e+03,
		1.088699221691168e+03,		1.089044468668428e+03,		1.089389066449780e+03,		1.089733017759949e+03,		1.090076325306108e+03,
		1.090418991778022e+03,		1.090761019848205e+03,		1.091102412172065e+03,		1.091443171388055e+03,		1.091783300117815e+03,
		1.092122800966319e+03,		1.092461676522017e+03,		1.092799929356976e+03,		1.093137562027020e+03,		1.093474577071865e+03
	},
	{
		1.671274639379863e+00,		5.058331478751191e+00,		8.502135603706130e+00,		1.200503613526271e+01,		1.556953920375267e+01,
		1.919832217826369e+01,		2.289424954595388e+01,		2.666039067752944e+01,		3.050003975577155e+01,		3.441673819278129e+01,
		3.841429992048592e+01,		4.249684001032667e+01,		4.666880716499138e+01,		5.093502073148142e+01,		5.530071301575482e+01,
		5.977157784118170e+01,		6.435382649458501e+01,		6.905425245584347e+01,		7.388030662460712e+01,		7.884018516014642e+01,
		8.394293256388971e+01,		8.919856329410611e+01,		9.461820605650496e+01,		1.002142760291658e+02,		1.060006817464151e+02,
		1.119930753114530e+02,		1.182091572113323e+02,		1.246690505259763e+02,		1.313957641227255e+02,		1.384157710425920e+02,
		1.457597374948062e+02,		1.534634508353336e+02,		1.615690133259493e+02,		1.701263949043521e+02,		1.791954764215626e+02,
		1.888487703019172e+02,		1.991750858707370e+02,		2.102845204987159e+02,		2.223153103892660e+02,		2.354432483350784e+02,
		2.498944637399472e+02,		2.659619679778786e+02,		2.840242763621746e+02,		3.045575755877204e+02,		3.281168137990750e+02,
		3.552389202410307e+02,		3.861975453940931e+02,		4.204289239273822e+02,		4.557147648069112e+02,		4.890053566818254e+02,
		5.186121486259424e+02,		5.440044497989002e+02,		5.655265938429083e+02,		5.838703605265083e+02,		5.997090277548244e+02,
		6.135796128527101e+02,		6.258853379657305e+02,		6.369268076734090e+02,		6.469306774024826e+02,		6.560706091860601e+02,
		6.644818461698562e+02,		6.722713389475389e+02,		6.795248658095361e+02,		6.863121137110585e+02,		6.926903596398763e+02,
		6.987071786336517e+02,		7.044024654391010e+02,		7.098099651966843e+02,		7.149584477755925e+02,		7.198726197420985e+02,
		7.245738404900753e+02,		7.290806903017466e+02,		7.334094251203326e+02,		7.375743437017203e+02,		7.415880863259948e+02,
		7.454618795688950e+02,		7.492057382115447e+02,		7.528286328342675e+02,		7.563386297447524e+02,		7.597430084571741e+02,
		7.630483608445655e+02,		7.662606752439124e+02,		7.693854081396023e+02,		7.724275455396746e+02,		7.753916557572113e+02,
		7.782819349907751e+02,		7.811022468444463e+02,		7.838561567250161e+02,		7.865469618906534e+02,		7.891777177934267e+02,
		7.917512612507761e+02,		7.942702308935999e+02,		7.967370852668927e+02,		7.991541188999605e+02,		8.015234766144188e+02,
		8.038471662978610e+02,		8.061270703373519e+02,		8.083649558788728e+02,		8.105624840552034e+02,		8.127212183049397e+02,
		8.148426318885550e+02,		8.169281146932815e+02,		8.189789794064797e+02,		8.209964671269023e+02,		8.229817524745199e+02,
		8.249359482519374e+02,		8.268601097040603e+02,		8.287552384170327e+02,		8.306222858925911e+02,		8.324621568298862e+02,
		8.342757121431096e+02,		8.360637717401061e+02,		8.378271170843731e+02,		8.395664935604875e+02,		8.412826126607443e+02,
		8.429761540090454e+02,		8.446477672363399e+02,		8.462980737205281e+02,		8.479276682023800e+02,		8.495371202879400e+02,
		8.511269758468368e+02,		8.526977583150120e+02,		8.542499699096182e+02,		8.557840927630641e+02,		8.573005899825685e+02,
		8.587999066410026e+02,		8.602824707042921e+02,		8.617486939001792e+02,		8.631989725327197e+02,		8.646336882465066e+02,
		8.660532087443129e+02,		8.674578884614905e+02,		8.688480692001999e+02,		8.702240807263134e+02,		8.715862413315668e+02,
		8.729348583633582e+02,		8.742702287244106e+02,		8.755926393442902e+02,		8.769023676246779e+02,		8.781996818601174e+02,
		8.794848416358315e+02,		8.807580982040741e+02,		8.820196948404160e+02,		8.832698671811958e+02,		8.845088435433339e+02,
		8.857368452275981e+02,		8.869540868063217e+02,		8.881607763965279e+02,		8.893571159193380e+02,		8.905433013464685e+02,
		8.917195229345841e+02,		8.928859654482129e+02,		8.940428083718882e+02,		8.951902261121337e+02,		8.963283881898503e+02,
		8.974574594236830e+02,		8.985776001048284e+02,		8.996889661637792e+02,		9.007917093294402e+02,		9.018859772810355e+02,
		9.029719137931860e+02,		9.040496588745220e+02,		9.051193489001859e+02,		9.061811167385174e+02,		9.072350918722627e+02,
		9.082814005145491e+02,		9.093201657199298e+02,		9.103515074907081e+02,		9.113755428788241e+02,		9.123923860834873e+02,
		9.134021485447862e+02,		9.144049390334611e+02,		9.154008637370449e+02,		9.163900263425161e+02,		9.173725281156616e+02,
		9.183484679772978e+02,		9.193179425764828e+02,		9.202810463608802e+02,		9.212378716443942e+02,		9.221885086722109e+02,
		9.231330456833613e+02,		9.240715689709070e+02,		9.250041629398839e+02,		9.259309101630672e+02,		9.268518914346920e+02,
		9.277671858221901e+02,		9.286768707160469e+02,		9.295810218778522e+02,		9.304797134866296e+02,		9.313730181835090e+02,
		9.322610071148257e+02,		9.331437499736963e+02,		9.340213150401516e+02,		9.348937692198731e+02,		9.357611780816053e+02,
		9.366236058932809e+02,		9.374811156569276e+02,		9.383337691423939e+02,		9.391816269199528e+02,		9.400247483918151e+02,
		9.408631918226074e+02,		9.416970143688530e+02,		9.425262721074862e+02,		9.433510200634456e+02,		9.441713122363938e+02,
		9.449872016265632e+02,		9.457987402597967e+02,		9.466059792118000e+02,		9.474089686316258e+02,		9.482077577644354e+02,
		9.490023949735512e+02,		9.497929277618418e+02,		9.505794027924469e+02,		9.513618659088678e+02,		9.521403621544714e+02,
		9.529149357913938e+02,		9.536856303188885e+02,		9.544524884911320e+02,		9.552155523345010e+02,		9.559748631643564e+02,
		9.567304616013229e+02,		9.574823875871185e+02,		9.582306803999161e+02,		9.589753786692700e+02,		9.597165203906193e+02,
		9.604541429393910e+02,		9.611882830846961e+02,		9.619189770026460e+02,		9.626462602893134e+02,		9.633701679733156e+02,
		9.640907345280724e+02,		9.648079938837216e+02,		9.655219794387082e+02,		9.662327240710745e+02,		9.669402601494312e+02,
		9.676446195436556e+02,		9.683458336352898e+02,		9.690439333276781e+02,		9.697389490558279e+02,		9.704309107960247e+02,
		9.711198480751954e+02,		9.718057899800218e+02,		9.724887651658307e+02,		9.731688018652636e+02,		9.738459278967015e+02,
		9.745201706725071e+02,		9.751915572070452e+02,		9.758601141245007e+02,		9.765258676665129e+02,		9.771888436996143e+02,
		9.778490677224845e+02,		9.785065648730431e+02,		9.791613599353446e+02,		9.798134773463275e+02,		9.804629412024004e+02,
		9.811097752658532e+02,		9.817540029711322e+02,		9.823956474309659e+02,		9.830347314423340e+02,		9.836712774923117e+02,
		9.843053077637694e+02,		9.849368441409380e+02,		9.855659082148521e+02,		9.861925212886663e+02,		9.868167043828457e+02,
		9.874384782402415e+02,		9.880578633310564e+02,		9.886748798576853e+02,		9.892895477594628e+02,		9.899018867172929e+02,
		9.905119161581780e+02,		9.911196552596583e+02,		9.917251229541363e+02,		9.923283379331170e+02,		9.929293186513581e+02,
		9.935280833309200e+02,		9.941246499651372e+02,		9.947190363225053e+02,		9.953112599504691e+02,		9.959013381791547e+02,
		9.964892881249976e+02,		9.970751266943133e+02,		9.976588705867835e+02,		9.982405362988681e+02,		9.988201401271518e+02,
		9.993976981716187e+02,		9.999732263388559e+02,		1.000546740345199e+03,		1.001118255719802e+03,		1.001687787807657e+03,
		1.002255351772543e+03,		1.002820962599917e+03,		1.003384635099757e+03,		1.003946383909328e+03,		1.004506223495910e+03,
		1.005064168159473e+03,		1.005620232035276e+03,		1.006174429096444e+03,		1.006726773156475e+03,		1.007277277871710e+03,
		1.007825956743743e+03,		1.008372823121792e+03,		1.008917890205026e+03,		1.009461171044839e+03,		1.010002678547089e+03,
		1.010542425474292e+03,		1.011080424447765e+03,		1.011616687949746e+03,		1.012151228325459e+03,		1.012684057785147e+03,
		1.013215188406067e+03,		1.013744632134442e+03,		1.014272400787386e+03,		1.014798506054791e+03,		1.015322959501169e+03,
		1.015845772567473e+03,		1.016366956572879e+03,		1.016886522716541e+03,		1.017404482079302e+03,		1.017920845625387e+03,
		1.018435624204059e+03,		1.018948828551248e+03,		1.019460469291146e+03,		1.019970556937783e+03,		1.020479101896566e+03,
		1.020986114465792e+03,		1.021491604838142e+03,		1.021995583102138e+03,		1.022498059243588e+03,		1.022999043146985e+03,
		1.023498544596908e+03,		1.023996573279378e+03,		1.024493138783201e+03,		1.024988250601282e+03,		1.025481918131923e+03,
		1.025974150680094e+03,		1.026464957458688e+03,		1.026954347589742e+03,		1.027442330105653e+03,		1.027928913950369e+03,
		1.028414107980552e+03,		1.028897920966730e+03,		1.029380361594430e+03,		1.029861438465285e+03,		1.030341160098132e+03,
		1.030819534930085e+03,		1.031296571317597e+03,		1.031772277537490e+03,		1.032246661787995e+03,		1.032719732189742e+03,
		1.033191496786765e+03,		1.033661963547470e+03,		1.034131140365596e+03,		1.034599035061156e+03,		1.035065655381370e+03,
		1.035531009001581e+03,		1.035995103526146e+03,		1.036457946489332e+03,		1.036919545356183e+03,		1.037379907523372e+03,
		1.037839040320057e+03,		1.038296951008707e+03,		1.038753646785917e+03,		1.039209134783220e+03,		1.039663422067880e+03,
		1.040116515643666e+03,		1.040568422451630e+03,		1.041019149370863e+03,		1.041468703219235e+03,		1.041917090754137e+03,
		1.042364318673201e+03,		1.042810393615014e+03,		1.043255322159820e+03,		1.043699110830209e+03,		1.044141766091801e+03,
		1.044583294353920e+03,		1.045023701970246e+03,		1.045462995239476e+03,		1.045901180405961e+03,		1.046338263660336e+03,
		1.046774251140151e+03,		1.047209148930475e+03,		1.047642963064509e+03,		1.048075699524180e+03,		1.048507364240724e+03,
		1.048937963095273e+03,		1.049367501919419e+03,		1.049795986495781e+03,		1.050223422558557e+03,		1.050649815794072e+03,
		1.051075171841316e+03,		1.051499496292477e+03,		1.051922794693462e+03,		1.052345072544415e+03,		1.052766335300225e+03,
		1.053186588371032e+03,		1.053605837122716e+03,		1.054024086877390e+03,		1.054441342913878e+03,		1.054857610468189e+03,
		1.055272894733992e+03,		1.055687200863067e+03,		1.056100533965770e+03,		1.056512899111478e+03,		1.056924301329029e+03,
		1.057334745607164e+03,		1.057744236894954e+03,		1.058152780102232e+03,		1.058560380100003e+03,		1.058967041720861e+03,
		1.059372769759404e+03,		1.059777568972627e+03,		1.060181444080326e+03,		1.060584399765486e+03,		1.060986440674672e+03,
		1.061387571418407e+03,		1.061787796571550e+03,		1.062187120673669e+03,		1.062585548229409e+03,		1.062983083708848e+03,
		1.063379731547862e+03,		1.063775496148472e+03,		1.064170381879197e+03,		1.064564393075394e+03,		1.064957534039598e+03,
		1.065349809041859e+03,		1.065741222320067e+03,		1.066131778080287e+03,		1.066521480497074e+03,		1.066910333713794e+03,
		1.067298341842935e+03,		1.067685508966424e+03,		1.068071839135925e+03,		1.068457336373148e+03,		1.068842004670139e+03,
		1.069225847989587e+03,		1.069608870265105e+03,		1.069991075401518e+03,		1.070372467275153e+03,		1.070753049734115e+03,
		1.071132826598562e+03,		1.071511801660985e+03,		1.071889978686472e+03,		1.072267361412977e+03,		1.072643953551583e+03,
		1.073019758786762e+03,		1.073394780776634e+03,		1.073769023153220e+03,		1.074142489522690e+03,		1.074515183465616e+03,
		1.074887108537213e+03,		1.075258268267582e+03,		1.075628666161950e+03,		1.075998305700904e+03,		1.076367190340627e+03,
		1.076735323513127e+03,		1.077102708626464e+03,		1.077469349064977e+03,		1.077835248189506e+03,		1.078200409337610e+03,
		1.078564835823786e+03,		1.078928530939686e+03,		1.079291497954321e+03,		1.079653740114281e+03,		1.080015260643937e+03,
		1.080376062745644e+03,		1.080736149599947e+03,		1.081095524365780e+03,		1.081454190180665e+03,		1.081812150160903e+03,
		1.082169407401773e+03,		1.082525964977721e+03,		1.082881825942547e+03,		1.083236993329593e+03,		1.083591470151930e+03,
		1.083945259402537e+03,		1.084298364054482e+03,		1.084650787061104e+03,		1.085002531356183e+03,		1.085353599854122e+03,
		1.085703995450112e+03,		1.086053721020309e+03,		1.086402779421998e+03,		1.086751173493761e+03,		1.087098906055645e+03,
		1.087445979909319e+03,		1.087792397838241e+03,		1.088138162607816e+03,		1.088483276965551e+03,		1.088827743641212e+03,
		1.089171565346983e+03,		1.089514744777610e+03,		1.089857284610561e+03,		1.090199187506169e+03,		1.090540456107783e+03,
		1.090881093041909e+03,		1.091221100918363e+03,		1.091560482330407e+03,		1.091899239854893e+03,		1.092237376052401e+03
	},
	{
		1.668068806987163e+00,		5.048362520502202e+00,		8.484912633642454e+00,		1.198002820818587e+01,		1.553617120910671e+01,
		1.915597021309777e+01,		2.284223568759488e+01,		2.659797706234081e+01,		3.042642185314953e+01,		3.433103714263280e+01,
		3.831555377694223e+01,		4.238399370322099e+01,		4.654070095218483e+01,		5.079037686754720e+01,		5.513812030333088e+01,
		5.958947365721909e+01,		6.415047579044686e+01,		6.882772311203931e+01,		7.362844039023284e+01,		7.856056321353765e+01,
		8.363283448056970e+01,		8.885491788160357e+01,		9.423753208644123e+01,		9.979261032801729e+01,		1.055334913451478e+02,
		1.114751493260937e+02,		1.176344727238451e+02,		1.240306048006342e+02,		1.306853627960866e+02,		1.376237581196273e+02,
		1.448746475471584e+02,		1.524715559299018e+02,		1.604537256723362e+02,		1.688674690528690e+02,		1.777679289925749e+02,
		1.872213957990028e+02,		1.973083864324994e+02,		2.081277737388057e+02,		2.198023564307353e+02,		2.324863681682736e+02,
		2.463754540214800e+02,		2.617193212024042e+02,		2.788358071303451e+02,		2.981205910367187e+02,		3.200362189916090e+02,
		3.450485195451155e+02,		3.734674678920049e+02,		4.051071651071045e+02,		4.386695717811439e+02,		4.716336770676879e+02,
		5.019059176355057e+02,		5.285493314128406e+02,		5.514636924316285e+02,		5.710925218812548e+02,		5.880338444415073e+02,
		6.028307515634878e+02,		6.159150640072231e+02,		6.276162105434707e+02,		6.381845363019058e+02,		6.478121811117962e+02,
		6.566486674595991e+02,		6.648120281756366e+02,		6.723967192138915e+02,		6.794792944805331e+02,		6.861225252596935e+02,
		6.923784303375219e+02,		6.982905352272571e+02,		7.038955793399806e+02,		7.092248227651696e+02,		7.143050588149524e+02,
		7.191594074828263e+02,		7.238079436866484e+02,		7.282681994159922e+02,		7.325555685644175e+02,		7.366836358884083e+02,
		7.406644462575961e+02,		7.445087265173332e+02,		7.482260694498988e+02,		7.518250872053694e+02,		7.553135399777177e+02,
		7.586984444860185e+02,		7.619861658861181e+02,		7.651824960138014e+02,		7.682927202946100e+02,		7.713216752107376e+02,
		7.742737978632420e+02,		7.771531688876228e+02,		7.799635497565225e+02,		7.827084153228413e+02,		7.853909823106890e+02,
		7.880142343431487e+02,		7.905809439991756e+02,		7.930936923127653e+02,		7.955548860624698e+02,		7.979667731455263e+02,
		8.003314562862748e+02,		8.026509052915296e+02,		8.049269680344955e+02,		8.071613803229750e+02,		8.093557747857358e+02,
		8.115116888924963e+02,		8.136305722074450e+02,		8.157137929629666e+02,		8.177626440289770e+02,		8.197783483436525e+02,
		8.217620638631039e+02,		8.237148880804618e+02,		8.256378621587189e+02,		8.275319747164638e+02,		8.293981653009814e+02,
		8.312373275793420e+02,		8.330503122745656e+02,		8.348379298709763e+02,		8.366009531102378e+02,		8.383401192972233e+02,
		8.400561324328792e+02,		8.417496651894365e+02,		8.434213607417466e+02,		8.450718344671586e+02,		8.467016755250760e+02,
		8.483114483262769e+02,		8.499016939010907e+02,		8.514729311746570e+02,		8.530256581567365e+02,		8.545603530528213e+02,
		8.560774753027204e+02,		8.575774665521914e+02,		8.590607515627308e+02,		8.605277390641731e+02,		8.619788225543365e+02,
		8.634143810496124e+02,		8.648347797900396e+02,		8.662403709021402e+02,		8.676314940224930e+02,		8.690084768847896e+02,
		8.703716358729213e+02,		8.717212765423817e+02,		8.730576941121710e+02,		8.743811739291380e+02,		8.756919919066092e+02,
		8.769904149389727e+02,		8.782767012937808e+02,		8.795511009828138e+02,		8.808138561134311e+02,		8.820652012214597e+02,
		8.833053635867547e+02,		8.845345635325090e+02,		8.857530147092921e+02,		8.869609243647509e+02,		8.881584935998151e+02,
		8.893459176122172e+02,		8.905233859280720e+02,		8.916910826221921e+02,		8.928491865278082e+02,		8.939978714362870e+02,
		8.951373062874094e+02,		8.962676553507483e+02,		8.973890783986243e+02,		8.985017308711181e+02,		8.996057640335652e+02,
		9.007013251269257e+02,		9.017885575114461e+02,		9.028676008039296e+02,		9.039385910089717e+02,		9.050016606444824e+02,
		9.060569388617694e+02,		9.071045515604807e+02,		9.081446214986601e+02,		9.091772683981685e+02,		9.102026090456798e+02,
		9.112207573895164e+02,		9.122318246324811e+02,		9.132359193209120e+02,		9.142331474301344e+02,		9.152236124464770e+02,
		9.162074154460307e+02,		9.171846551702902e+02,		9.181554280988320e+02,		9.191198285191685e+02,		9.200779485939014e+02,
		9.210298784253125e+02,		9.219757061174897e+02,		9.229155178361164e+02,		9.238493978660225e+02,		9.247774286665978e+02,
		9.256996909251578e+02,		9.266162636083651e+02,		9.275272240117719e+02,		9.284326478075855e+02,		9.293326090907179e+02,
		9.302271804232008e+02,		9.311164328770316e+02,		9.320004360755208e+02,		9.328792582331996e+02,		9.337529661943446e+02,
		9.346216254701925e+02,		9.354853002748705e+02,		9.363440535601309e+02,		9.371979470488948e+02,		9.380470412677041e+02,
		9.388913955780730e+02,		9.397310682068231e+02,		9.405661162754212e+02,		9.413965958283652e+02,		9.422225618606531e+02,
		9.430440683443696e+02,		9.438611682544366e+02,		9.446739135935352e+02,		9.454823554162522e+02,		9.462865438524744e+02,
		9.470865281300474e+02,		9.478823565967531e+02,		9.486740767415938e+02,		9.494617352154415e+02,		9.502453778510639e+02,
		9.510250496825366e+02,		9.518007949640897e+02,		9.525726571883832e+02,		9.533406791042499e+02,		9.541049027339162e+02,
		9.548653693897253e+02,		9.556221196903624e+02,		9.563751935766302e+02,		9.571246303267611e+02,		9.578704685712991e+02,
		9.586127463075564e+02,		9.593515009136670e+02,		9.600867691622495e+02,		9.608185872336827e+02,		9.615469907290209e+02,
		9.622720146825521e+02,		9.629936935740150e+02,		9.637120613404803e+02,		9.644271513879145e+02,		9.651389966024311e+02,
		9.658476293612456e+02,		9.665530815433323e+02,		9.672553845398065e+02,		9.679545692640314e+02,		9.686506661614590e+02,
		9.693437052192201e+02,		9.700337159754624e+02,		9.707207275284516e+02,		9.714047685454351e+02,		9.720858672712889e+02,
		9.727640515369370e+02,		9.734393487675657e+02,		9.741117859906263e+02,		9.747813898436469e+02,		9.754481865818414e+02,
		9.761122020855381e+02,		9.767734618674232e+02,		9.774319910796094e+02,		9.780878145205337e+02,		9.787409566416823e+02,
		9.793914415541632e+02,		9.800392930351189e+02,		9.806845345339825e+02,		9.813271891785907e+02,		9.819672797811508e+02,
		9.826048288440711e+02,		9.832398585656491e+02,		9.838723908456338e+02,		9.845024472906598e+02,		9.851300492195493e+02,
		9.857552176685065e+02,		9.863779733961775e+02,		9.869983368886089e+02,		9.876163283640888e+02,		9.882319677778804e+02,
		9.888452748268489e+02,		9.894562689539914e+02,		9.900649693528551e+02,		9.906713949718691e+02,		9.912755645185835e+02,
		9.918774964637993e+02,		9.924772090456264e+02,		9.930747202734508e+02,		9.936700479318042e+02,		9.942632095841677e+02,
		9.948542225766819e+02,		9.954431040417869e+02,		9.960298709017798e+02,		9.966145398722965e+02,		9.971971274657312e+02,
		9.977776499945694e+02,		9.983561235746643e+02,		9.989325641284361e+02,		9.995069873880173e+02,		1.000079408898319e+03,
		1.000649844020047e+03,		1.001218307932652e+03,		1.001784815637216e+03,		1.002349381959290e+03,		1.002912021551666e+03,
		1.003472748897099e+03,		1.004031578310977e+03,		1.004588523943926e+03,		1.005143599784378e+03,		1.005696819661086e+03,
		1.006248197245577e+03,		1.006797746054579e+03,		1.007345479452380e+03,		1.007891410653154e+03,		1.008435552723241e+03,
		1.008977918583373e+03,		1.009518521010880e+03,		1.010057372641827e+03,		1.010594485973128e+03,		1.011129873364620e+03,
		1.011663547041087e+03,		1.012195519094256e+03,		1.012725801484758e+03,		1.013254406044038e+03,		1.013781344476244e+03,
		1.014306628360082e+03,		1.014830269150622e+03,		1.015352278181084e+03,		1.015872666664598e+03,		1.016391445695905e+03,
		1.016908626253056e+03,		1.017424219199068e+03,		1.017938235283551e+03,		1.018450685144303e+03,		1.018961579308886e+03,
		1.019470928196164e+03,		1.019978742117817e+03,		1.020485031279836e+03,		1.020989805783978e+03,		1.021493075629208e+03,
		1.021994850713111e+03,		1.022495140833273e+03,		1.022993955688654e+03,		1.023491304880922e+03,		1.023987197915772e+03,
		1.024481644204219e+03,		1.024974653063876e+03,		1.025466233720198e+03,		1.025956395307718e+03,		1.026445146871253e+03,
		1.026932497367093e+03,		1.027418455664176e+03,		1.027903030545227e+03,		1.028386230707899e+03,		1.028868064765879e+03,
		1.029348541249987e+03,		1.029827668609244e+03,		1.030305455211936e+03,		1.030781909346657e+03,		1.031257039223326e+03,
		1.031730852974199e+03,		1.032203358654858e+03,		1.032674564245191e+03,		1.033144477650345e+03,		1.033613106701676e+03,
		1.034080459157674e+03,		1.034546542704879e+03,		1.035011364958784e+03,		1.035474933464717e+03,		1.035937255698713e+03,
		1.036398339068375e+03,		1.036858190913716e+03,		1.037316818507998e+03,		1.037774229058538e+03,		1.038230429707525e+03,
		1.038685427532812e+03,		1.039139229548694e+03,		1.039591842706681e+03,		1.040043273896252e+03,		1.040493529945609e+03,
		1.040942617622403e+03,		1.041390543634466e+03,		1.041837314630518e+03,		1.042282937200873e+03,		1.042727417878129e+03,
		1.043170763137851e+03,		1.043612979399244e+03,		1.044054073025808e+03,		1.044494050325997e+03,		1.044932917553859e+03,
		1.045370680909666e+03,		1.045807346540539e+03,		1.046242920541065e+03,		1.046677408953899e+03,		1.047110817770358e+03,
		1.047543152931020e+03,		1.047974420326291e+03,		1.048404625796981e+03,		1.048833775134871e+03,		1.049261874083261e+03,
		1.049688928337521e+03,		1.050114943545630e+03,		1.050539925308706e+03,		1.050963879181534e+03,		1.051386810673075e+03,
		1.051808725246986e+03,		1.052229628322114e+03,		1.052649525272994e+03,		1.053068421430336e+03,		1.053486322081514e+03,
		1.053903232471028e+03,		1.054319157800985e+03,		1.054734103231553e+03,		1.055148073881420e+03,		1.055561074828244e+03,
		1.055973111109094e+03,		1.056384187720888e+03,		1.056794309620826e+03,		1.057203481726813e+03,		1.057611708917880e+03,
		1.058018996034601e+03,		1.058425347879495e+03,		1.058830769217435e+03,		1.059235264776043e+03,		1.059638839246084e+03,
		1.060041497281852e+03,		1.060443243501551e+03,		1.060844082487677e+03,		1.061244018787383e+03,		1.061643056912853e+03,
		1.062041201341659e+03,		1.062438456517123e+03,		1.062834826848669e+03,		1.063230316712167e+03,		1.063624930450286e+03,
		1.064018672372825e+03,		1.064411546757052e+03,		1.064803557848033e+03,		1.065194709858964e+03,		1.065585006971487e+03,
		1.065974453336010e+03,		1.066363053072024e+03,		1.066750810268411e+03,		1.067137728983751e+03,		1.067523813246625e+03,
		1.067909067055912e+03,		1.068293494381087e+03,		1.068677099162510e+03,		1.069059885311715e+03,		1.069441856711692e+03,
		1.069823017217171e+03,		1.070203370654896e+03,		1.070582920823902e+03,		1.070961671495781e+03,		1.071339626414953e+03,
		1.071716789298927e+03,		1.072093163838563e+03,		1.072468753698331e+03,		1.072843562516561e+03,		1.073217593905697e+03,
		1.073590851452547e+03,		1.073963338718521e+03,		1.074335059239882e+03,		1.074706016527981e+03,		1.075076214069491e+03,
		1.075445655326645e+03,		1.075814343737467e+03,		1.076182282715994e+03,		1.076549475652507e+03,		1.076915925913755e+03,
		1.077281636843169e+03,		1.077646611761083e+03,		1.078010853964951e+03,		1.078374366729555e+03,		1.078737153307218e+03,
		1.079099216928011e+03,		1.079460560799956e+03,		1.079821188109231e+03,		1.080181102020372e+03,		1.080540305676466e+03,
		1.080898802199350e+03,		1.081256594689806e+03,		1.081613686227747e+03,		1.081970079872414e+03,		1.082325778662554e+03,
		1.082680785616613e+03,		1.083035103732913e+03,		1.083388735989834e+03,		1.083741685345996e+03,		1.084093954740432e+03,
		1.084445547092762e+03,		1.084796465303370e+03,		1.085146712253570e+03,		1.085496290805777e+03,		1.085845203803677e+03,
		1.086193454072384e+03,		1.086541044418612e+03,		1.086887977630831e+03,		1.087234256479429e+03,		1.087579883716871e+03,
		1.087924862077850e+03,		1.088269194279448e+03,		1.088612883021285e+03,		1.088955930985670e+03,		1.089298340837752e+03,
		1.089640115225670e+03,		1.089981256780692e+03,		1.090321768117367e+03,		1.090661651833664e+03,		1.091000910511117e+03
	},
	{
		1.664875422266452e+00,		5.038434420227030e+00,		8.467764126325623e+00,		1.195513427530456e+01,		1.550296351035323e+01,
		1.911383258988635e+01,		2.279049908921451e+01,		2.653591380572722e+01,		3.035323911107092e+01,		3.424586953549343e+01,
		3.821745491958078e+01,		4.227192652896741e+01,		4.641352660069526e+01,		5.064684187882958e+01,		5.497684180566083e+01,
		5.940892216839680e+01,		6.394895516622194e+01,		6.860334706744871e+01,		7.337910488229846e+01,		7.828391379818159e+01,
		8.332622753046499e+01,		8.851537425827607e+01,		9.386168147629706e+01,		9.937662394623112e+01,		1.050730000389014e+02,
		1.109651432064600e+02,		1.170691772336274e+02,		1.234033264537986e+02,		1.299882955135434e+02,		1.368477378565116e+02,
		1.440088383414455e+02,		1.515030439722614e+02,		1.593669885440516e+02,		1.676436734286075e+02,		1.763839895787545e+02,
		1.856486975547098e+02,		1.955110258295386e+02,		2.060601051099935e+02,		2.174055261009994e+02,		2.296833732624843e+02,
		2.430640848514228e+02,		2.577622276963511e+02,		2.740472309869616e+02,		2.922510793012191e+02,		3.127619518053413e+02,
		3.359818049065022e+02,		3.622185300937762e+02,		3.914716676731838e+02,		4.230289178116165e+02,		4.550995594444748e+02,
		4.855066966385343e+02,		5.129998441955444e+02,		5.371022031645394e+02,		5.579536923157481e+02,		5.760039240451993e+02,
		5.917570177705901e+02,		6.056539731162766e+02,		6.180465562102988e+02,		6.292072601075207e+02,		6.393467428427259e+02,
		6.486292657176491e+02,		6.571844575752510e+02,		6.651159139194388e+02,		6.725074421578707e+02,		6.794276225890698e+02,
		6.859331720217178e+02,		6.920714528032272e+02,		6.978823670858073e+02,		7.033998044521710e+02,		7.086527613996769e+02,
		7.136662168624933e+02,		7.184618241567101e+02,		7.230584631474344e+02,		7.274726847860426e+02,		7.317190719000305e+02,
		7.358105341881538e+02,		7.397585510683519e+02,		7.435733728621061e+02,		7.472641884463945e+02,		7.508392657352304e+02,
		7.543060700085141e+02,		7.576713640745958e+02,		7.609412934547194e+02,		7.641214591548566e+02,		7.672169801010754e+02,
		7.702325469276011e+02,		7.731724684986448e+02,		7.760407122986180e+02,		7.788409396270180e+02,		7.815765363739287e+02,
		7.842506400219229e+02,		7.868661634139081e+02,		7.894258157394457e+02,		7.919321211205527e+02,		7.943874351188774e+02,
		7.967939594372090e+02,		7.991537550475326e+02,		8.014687539438486e+02,		8.037407696895624e+02,		8.059715069052118e+02,
		8.081625698222686e+02,		8.103154700115550e+02,		8.124316333804517e+02,		8.145124065206891e+02,		8.165590624780184e+02,
		8.185728060060966e+02,		8.205547783591184e+02,		8.225060616711664e+02,		8.244276829644622e+02,		8.263206178237457e+02,
		8.281857937697023e+02,		8.300240933606506e+02,		8.318363570483667e+02,		8.336233858111344e+02,		8.353859435846042e+02,
		8.371247595087921e+02,		8.388405300077268e+02,		8.405339207164504e+02,		8.422055682686447e+02,		8.438560819568057e+02,
		8.454860452757060e+02,		8.470960173588495e+02,		8.486865343166953e+02,		8.502581104845782e+02,		8.518112395875410e+02,
		8.533463958286081e+02,		8.548640349064498e+02,		8.563645949678494e+02,		8.578484974999118e+02,		8.593161481665067e+02,
		8.607679375930763e+02,		8.622042421035678e+02,		8.636254244129339e+02,		8.650318342783803e+02,		8.664238091122513e+02,
		8.678016745592190e+02,		8.691657450402537e+02,		8.705163242656022e+02,		8.718537057188917e+02,		8.731781731142547e+02,
		8.744900008282646e+02,		8.757894543083169e+02,		8.770767904589865e+02,		8.783522580077260e+02,		8.796160978512736e+02,
		8.808685433839112e+02,		8.821098208087384e+02,		8.833401494329813e+02,		8.845597419483087e+02,		8.857688046970643e+02,
		8.869675379252349e+02,		8.881561360229555e+02,		8.893347877532652e+02,		8.905036764697965e+02,		8.916629803240332e+02,
		8.928128724627277e+02,		8.939535212160303e+02,		8.950850902768492e+02,		8.962077388719279e+02,		8.973216219250845e+02,
		8.984268902130483e+02,		8.995236905142908e+02,		9.006121657512150e+02,		9.016924551260659e+02,		9.027646942508850e+02,
		9.038290152718179e+02,		9.048855469880724e+02,		9.059344149657929e+02,		9.069757416471136e+02,		9.080096464546275e+02,
		9.090362458915168e+02,		9.100556536375293e+02,		9.110679806410334e+02,		9.120733352073308e+02,		9.130718230834054e+02,
		9.140635475392809e+02,		9.150486094461590e+02,		9.160271073514690e+02,		9.169991375509945e+02,		9.179647941582004e+02,
		9.189241691708958e+02,		9.198773525353500e+02,		9.208244322079844e+02,		9.217654942147359e+02,		9.227006227082168e+02,
		9.236299000227516e+02,		9.245534067273906e+02,		9.254712216769924e+02,		9.263834220614500e+02,		9.272900834531562e+02,
		9.281912798527667e+02,		9.290870837333445e+02,		9.299775660829482e+02,		9.308627964457379e+02,		9.317428429616514e+02,
		9.326177724047112e+02,		9.334876502200254e+02,		9.343525405595283e+02,		9.352125063165199e+02,		9.360676091590427e+02,
		9.369179095621495e+02,		9.377634668391041e+02,		9.386043391715634e+02,		9.394405836387648e+02,		9.402722562457733e+02,
		9.410994119508272e+02,		9.419221046917939e+02,		9.427403874117967e+02,		9.435543120840315e+02,		9.443639297358029e+02,
		9.451692904718095e+02,		9.459704434967175e+02,		9.467674371370292e+02,		9.475603188622908e+02,		9.483491353056542e+02,
		9.491339322838143e+02,		9.499147548163545e+02,		9.506916471445155e+02,		9.514646527493989e+02,		9.522338143696458e+02,
		9.529991740185957e+02,		9.537607730009406e+02,		9.545186519289039e+02,		9.552728507379506e+02,		9.560234087020518e+02,
		9.567703644485146e+02,		9.575137559723890e+02,		9.582536206504831e+02,		9.589899952549663e+02,		9.597229159666192e+02,
		9.604524183877006e+02,		9.611785375544681e+02,		9.619013079493592e+02,		9.626207635128355e+02,		9.633369376549177e+02,
		9.640498632664006e+02,		9.647595727297775e+02,		9.654660979298701e+02,		9.661694702641837e+02,		9.668697206529794e+02,
		9.675668795491003e+02,		9.682609769475299e+02,		9.689520423947075e+02,		9.696401049976097e+02,		9.703251934325895e+02,
		9.710073359540057e+02,		9.716865604026182e+02,		9.723628942137885e+02,		9.730363644254629e+02,		9.737069976859622e+02,
		9.743748202615828e+02,		9.750398580440014e+02,		9.757021365575106e+02,		9.763616809660671e+02,		9.770185160801767e+02,
		9.776726663636092e+02,		9.783241559399573e+02,		9.789730085990319e+02,		9.796192478031143e+02,		9.802628966930532e+02,
		9.809039780942240e+02,		9.815425145223421e+02,		9.821785281891539e+02,		9.828120410079778e+02,		9.834430745991322e+02,
		9.840716502952354e+02,		9.846977891463838e+02,		9.853215119252078e+02,		9.859428391318215e+02,		9.865617909986582e+02,
		9.871783874951952e+02,		9.877926483325761e+02,		9.884045929681299e+02,		9.890142406097905e+02,		9.896216102204182e+02,
		9.902267205220277e+02,		9.908295899999275e+02,		9.914302369067607e+02,		9.920286792664649e+02,		9.926249348781514e+02,
		9.932190213198909e+02,		9.938109559524273e+02,		9.944007559228085e+02,		9.949884381679420e+02,		9.955740194180773e+02,
		9.961575162002123e+02,		9.967389448414322e+02,		9.973183214721774e+02,		9.978956620294440e+02,		9.984709822599190e+02,
		9.990442977230518e+02,		9.996156237940627e+02,		1.000184975666890e+03,		1.000752368357081e+03,		1.001317816704617e+03,
		1.001881335376691e+03,		1.002442938870427e+03,		1.003002641515537e+03,		1.003560457476945e+03,		1.004116400757334e+03,
		1.004670485199666e+03,		1.005222724489640e+03,		1.005773132158104e+03,		1.006321721583424e+03,		1.006868505993804e+03,
		1.007413498469562e+03,		1.007956711945365e+03,		1.008498159212420e+03,		1.009037852920616e+03,		1.009575805580644e+03,
		1.010112029566059e+03,		1.010646537115305e+03,		1.011179340333722e+03,		1.011710451195484e+03,		1.012239881545531e+03,
		1.012767643101445e+03,		1.013293747455303e+03,		1.013818206075490e+03,		1.014341030308483e+03,		1.014862231380596e+03,
		1.015381820399705e+03,		1.015899808356929e+03,		1.016416206128289e+03,		1.016931024476338e+03,		1.017444274051753e+03,
		1.017955965394911e+03,		1.018466108937426e+03,		1.018974715003667e+03,		1.019481793812246e+03,		1.019987355477478e+03,
		1.020491410010821e+03,		1.020993967322285e+03,		1.021495037221820e+03,		1.021994629420682e+03,		1.022492753532769e+03,
		1.022989419075943e+03,		1.023484635473318e+03,		1.023978412054541e+03,		1.024470758057034e+03,		1.024961682627234e+03,
		1.025451194821793e+03,		1.025939303608774e+03,		1.026426017868818e+03,		1.026911346396291e+03,		1.027395297900421e+03,
		1.027877881006403e+03,		1.028359104256496e+03,		1.028838976111106e+03,		1.029317504949828e+03,		1.029794699072504e+03,
		1.030270566700237e+03,		1.030745115976402e+03,		1.031218354967635e+03,		1.031690291664812e+03,		1.032160933984007e+03,
		1.032630289767437e+03,		1.033098366784389e+03,		1.033565172732139e+03,		1.034030715236851e+03,		1.034495001854459e+03,
		1.034958040071544e+03,		1.035419837306194e+03,		1.035880400908840e+03,		1.036339738163100e+03,		1.036797856286590e+03,
		1.037254762431734e+03,		1.037710463686557e+03,		1.038164967075465e+03,		1.038618279560020e+03,		1.039070408039695e+03,
		1.039521359352620e+03,		1.039971140276317e+03,		1.040419757528430e+03,		1.040867217767429e+03,		1.041313527593322e+03,
		1.041758693548342e+03,		1.042202722117629e+03,		1.042645619729904e+03,		1.043087392758127e+03,		1.043528047520155e+03,
		1.043967590279380e+03,		1.044406027245363e+03,		1.044843364574455e+03,		1.045279608370417e+03,		1.045714764685024e+03,
		1.046148839518660e+03,		1.046581838820905e+03,		1.047013768491121e+03,		1.047444634379017e+03,		1.047874442285216e+03,
		1.048303197961807e+03,		1.048730907112900e+03,		1.049157575395152e+03,		1.049583208418313e+03,		1.050007811745745e+03,
		1.050431390894933e+03,		1.050853951338004e+03,		1.051275498502227e+03,		1.051696037770507e+03,		1.052115574481870e+03,
		1.052534113931956e+03,		1.052951661373482e+03,		1.053368222016721e+03,		1.053783801029958e+03,		1.054198403539945e+03,
		1.054612034632359e+03,		1.055024699352236e+03,		1.055436402704414e+03,		1.055847149653964e+03,		1.056256945126614e+03,
		1.056665794009170e+03,		1.057073701149935e+03,		1.057480671359109e+03,		1.057886709409197e+03,		1.058291820035411e+03,
		1.058696007936056e+03,		1.059099277772921e+03,		1.059501634171663e+03,		1.059903081722179e+03,		1.060303624978984e+03,
		1.060703268461576e+03,		1.061102016654800e+03,		1.061499874009202e+03,		1.061896844941389e+03,		1.062292933834373e+03,
		1.062688145037916e+03,		1.063082482868873e+03,		1.063475951611520e+03,		1.063868555517895e+03,		1.064260298808118e+03,
		1.064651185670715e+03,		1.065041220262939e+03,		1.065430406711084e+03,		1.065818749110789e+03,		1.066206251527359e+03,
		1.066592917996053e+03,		1.066978752522389e+03,		1.067363759082445e+03,		1.067747941623141e+03,		1.068131304062532e+03,
		1.068513850290090e+03,		1.068895584166991e+03,		1.069276509526383e+03,		1.069656630173668e+03,		1.070035949886769e+03,
		1.070414472416395e+03,		1.070792201486313e+03,		1.071169140793599e+03,		1.071545294008902e+03,		1.071920664776696e+03,
		1.072295256715535e+03,		1.072669073418293e+03,		1.073042118452422e+03,		1.073414395360181e+03,		1.073785907658885e+03,
		1.074156658841138e+03,		1.074526652375068e+03,		1.074895891704555e+03,		1.075264380249466e+03,		1.075632121405872e+03,
		1.075999118546278e+03,		1.076365375019839e+03,		1.076730894152581e+03,		1.077095679247614e+03,		1.077459733585343e+03,
		1.077823060423683e+03,		1.078185662998263e+03,		1.078547544522634e+03,		1.078908708188466e+03,		1.079269157165758e+03,
		1.079628894603028e+03,		1.079987923627513e+03,		1.080346247345362e+03,		1.080703868841827e+03,		1.081060791181454e+03,
		1.081417017408267e+03,		1.081772550545956e+03,		1.082127393598060e+03,		1.082481549548145e+03,		1.082835021359986e+03,
		1.083187811977742e+03,		1.083539924326130e+03,		1.083891361310602e+03,		1.084242125817512e+03,		1.084592220714286e+03,
		1.084941648849589e+03,		1.085290413053490e+03,		1.085638516137628e+03,		1.085985960895373e+03,		1.086332750101980e+03,
		1.086678886514755e+03,		1.087024372873210e+03,		1.087369211899212e+03,		1.087713406297142e+03,		1.088056958754044e+03,
		1.088399871939774e+03,		1.088742148507151e+03,		1.089083791092097e+03,		1.089424802313794e+03,		1.089765184774809e+03
	},
	{
		1.661694411405047e+00,		5.028546913242593e+00,		8.450689558191707e+00,		1.193035347116832e+01,		1.546991479891691e+01,
		1.907190743348530e+01,		2.273903715855997e+01,		2.647419741465220e+01,		3.028048691142185e+01,		3.416122935395155e+01,
		3.811999559592348e+01,		4.216062858813261e+01,		4.628727155777414e+01,		5.050439993521511e+01,		5.481685764400119e+01,
		5.922989849111780e+01,		6.374923354375542e+01,		6.838108556342206e+01,		7.313225179781368e+01,		7.801017671796254e+01,
		8.302303664934092e+01,		8.817983870265954e+01,		9.349053699214912e+01,		9.896616987513630e+01,		1.046190229093131e+02,
		1.104628234746586e+02,		1.165129746431016e+02,		1.227868380349336e+02,		1.293040782623007e+02,		1.360870853847813e+02,
		1.431614969496207e+02,		1.505568481610776e+02,		1.583073882156519e+02,		1.664531138067432e+02,		1.750410885123756e+02,
		1.841271408111893e+02,		1.937780654773240e+02,		2.040744938835006e+02,		2.151146453748994e+02,		2.270192096469307e+02,
		2.399375908069879e+02,		2.540555309741137e+02,		2.696033736778848e+02,		2.868621359440376e+02,		3.061598339391136e+02,
		3.278427837076736e+02,		3.522007040331778e+02,		3.793229864984128e+02,		4.088403739655508e+02,		4.395794285929092e+02,
		4.696683319982210e+02,		4.975858253822262e+02,		5.225969679880257e+02,		5.445387204969069e+02,		5.636605148892328e+02,
		5.803776311871609e+02,		5.951111584529159e+02,		6.082223075676437e+02,		6.200010660454442e+02,		6.306753186210772e+02,
		6.404239673570002e+02,		6.493885092633675e+02,		6.576820312770077e+02,		6.653959283238800e+02,		6.726048776710395e+02,
		6.793705331669464e+02,		6.857442898784019e+02,		6.917693733053055e+02,		6.974824351879425e+02,		7.029147859497577e+02,
		7.080933569299461e+02,		7.130414595212953e+02,		7.177793899619680e+02,		7.223249155367323e+02,		7.266936686971079e+02,
		7.308994689753807e+02,		7.349545877594771e+02,		7.388699674727437e+02,		7.426554040921244e+02,		7.463196999820059e+02,
		7.498707925390299e+02,		7.533158630094204e+02,		7.566614289645780e+02,		7.599134232388219e+02,		7.630772615976107e+02,
		7.661579009816390e+02,		7.691598898353944e+02,		7.720874117595167e+02,		7.749443235095772e+02,		7.777341881887044e+02,
		7.804603043391471e+02,		7.831257315217856e+02,		7.857333128774726e+02,		7.882856950857791e+02,		7.907853460722356e+02,
		7.932345707614545e+02,		7.956355251291458e+02,		7.979902287687418e+02,		8.003005761573314e+02,		8.025683467793740e+02,
		8.047952142447155e+02,		8.069827545187115e+02,		8.091324533665536e+02,		8.112457131003857e+02,		8.133238587064185e+02,
		8.153681434193461e+02,		8.173797538030976e+02,		8.193598143895846e+02,		8.213093919209724e+02,		8.232294992355839e+02,
		8.251210988328446e+02,		8.269851061486634e+02,		8.288223925690768e+02,		8.306337882069162e+02,		8.324200844635445e+02,
		8.341820363953585e+02,		8.359203649026614e+02,		8.376357587566583e+02,		8.393288764787791e+02,		8.410003480850073e+02,
		8.426507767067142e+02,		8.442807400983241e+02,		8.458907920411535e+02,		8.474814636518752e+02,		8.490532646032798e+02,
		8.506066842642584e+02,		8.521421927653362e+02,		8.536602419955178e+02,		8.551612665356398e+02,		8.566456845330398e+02,
		8.581138985218897e+02,		8.595662961931697e+02,		8.610032511179623e+02,		8.624251234273695e+02,		8.638322604521748e+02,
		8.652249973250103e+02,		8.666036575476788e+02,		8.679685535259663e+02,		8.693199870741811e+02,		8.706582498914180e+02,
		8.719836240114396e+02,		8.732963822278790e+02,		8.745967884963939e+02,		8.758850983152141e+02,		8.771615590854805e+02,
		8.784264104526320e+02,		8.796798846300173e+02,		8.809222067058394e+02,		8.821535949344222e+02,		8.833742610127753e+02,
		8.845844103433122e+02,		8.857842422835535e+02,		8.869739503835764e+02,		8.881537226119159e+02,		8.893237415705909e+02,
		8.904841846998652e+02,		8.916352244733416e+02,		8.927770285838984e+02,		8.939097601210138e+02,		8.950335777399226e+02,
		8.961486358230624e+02,		8.972550846342281e+02,		8.983530704658223e+02,		8.994427357795606e+02,		9.005242193409903e+02,
		9.015976563481398e+02,		9.026631785545927e+02,		9.037209143872931e+02,		9.047709890593269e+02,		9.058135246779595e+02,
		9.068486403481394e+02,		9.078764522717103e+02,		9.088970738425459e+02,		9.099106157377972e+02,		9.109171860054342e+02,
		9.119168901482927e+02,		9.129098312047448e+02,		9.138961098262033e+02,		9.148758243515663e+02,		9.158490708787764e+02,
		9.168159433336077e+02,		9.177765335358207e+02,		9.187309312627980e+02,		9.196792243107777e+02,		9.206214985537914e+02,
		9.215578380004135e+02,		9.224883248484138e+02,		9.234130395374011e+02,		9.243320607995646e+02,		9.252454657085732e+02,
		9.261533297267235e+02,		9.270557267504153e+02,		9.279527291540078e+02,		9.288444078321510e+02,		9.297308322406366e+02,
		9.306120704358348e+02,		9.314881891127725e+02,		9.323592536419205e+02,		9.332253281047343e+02,		9.340864753279906e+02,
		9.349427569169811e+02,		9.357942332876090e+02,		9.366409636974208e+02,		9.374830062756259e+02,		9.383204180521360e+02,
		9.391532549856695e+02,		9.399815719909527e+02,		9.408054229650559e+02,		9.416248608128906e+02,		9.424399374719027e+02,
		9.432507039360047e+02,		9.440572102787513e+02,		9.448595056758073e+02,		9.456576384267205e+02,		9.464516559760384e+02,
		9.472416049337750e+02,		9.480275310952728e+02,		9.488094794604625e+02,		9.495874942525494e+02,		9.503616189361542e+02,
		9.511318962349177e+02,		9.518983681485862e+02,		9.526610759696105e+02,		9.534200602992568e+02,		9.541753610632655e+02,
		9.549270175270547e+02,		9.556750683104977e+02,		9.564195514022822e+02,		9.571605041738693e+02,		9.578979633930626e+02,
		9.586319652372015e+02,		9.593625453059916e+02,		9.600897386339842e+02,		9.608135797027168e+02,		9.615341024525260e+02,
		9.622513402940367e+02,		9.629653261193512e+02,		9.636760923129400e+02,		9.643836707622377e+02,		9.650880928679678e+02,
		9.657893895541939e+02,		9.664875912781099e+02,		9.671827280395739e+02,		9.678748293904044e+02,		9.685639244434277e+02,
		9.692500418813071e+02,		9.699332099651360e+02,		9.706134565428265e+02,		9.712908090572762e+02,		9.719652945543409e+02,
		9.726369396906051e+02,		9.733057707409589e+02,		9.739718136059968e+02,		9.746350938192239e+02,		9.752956365540996e+02,
		9.759534666308990e+02,		9.766086085234236e+02,		9.772610863655331e+02,		9.779109239575425e+02,		9.785581447724486e+02,
		9.792027719620222e+02,		9.798448283627531e+02,		9.804843365016563e+02,		9.811213186019422e+02,		9.817557965885621e+02,
		9.823877920936141e+02,		9.830173264616409e+02,		9.836444207547933e+02,		9.842690957578807e+02,		9.848913719833150e+02,
		9.855112696759330e+02,		9.861288088177165e+02,		9.867440091324066e+02,		9.873568900900165e+02,		9.879674709112433e+02,
		9.885757705717841e+02,		9.891818078065572e+02,		9.897856011138341e+02,		9.903871687592786e+02,		9.909865287798984e+02,
		9.915836989879186e+02,		9.921786969745642e+02,		9.927715401137675e+02,		9.933622455657962e+02,		9.939508302808042e+02,
		9.945373110023094e+02,		9.951217042705931e+02,		9.957040264260406e+02,		9.962842936124030e+02,		9.968625217799901e+02,
		9.974387266888119e+02,		9.980129239116378e+02,		9.985851288370031e+02,		9.991553566721615e+02,		9.997236224459592e+02,
		1.000289941011672e+03,		1.000854327049769e+03,		1.001416795070637e+03,		1.001977359417231e+03,		1.002536034267695e+03,
		1.003092833637912e+03,		1.003647771384017e+03,		1.004200861204855e+03,		1.004752116644393e+03,		1.005301551094082e+03,
		1.005849177795181e+03,		1.006395009841028e+03,		1.006939060179275e+03,		1.007481341614075e+03,		1.008021866808230e+03,
		1.008560648285297e+03,		1.009097698431658e+03,		1.009633029498547e+03,		1.010166653604044e+03,		1.010698582735022e+03,
		1.011228828749073e+03,		1.011757403376388e+03,		1.012284318221600e+03,		1.012809584765607e+03,		1.013333214367346e+03,
		1.013855218265544e+03,		1.014375607580439e+03,		1.014894393315461e+03,		1.015411586358889e+03,		1.015927197485480e+03,
		1.016441237358068e+03,		1.016953716529128e+03,		1.017464645442318e+03,		1.017974034434001e+03,		1.018481893734723e+03,
		1.018988233470683e+03,		1.019493063665162e+03,		1.019996394239940e+03,		1.020498235016681e+03,		1.020998595718297e+03,
		1.021497485970287e+03,		1.021994915302052e+03,		1.022490893148197e+03,		1.022985428849793e+03,		1.023478531655634e+03,
		1.023970210723470e+03,		1.024460475121208e+03,		1.024949333828107e+03,		1.025436795735947e+03,		1.025922869650176e+03,
		1.026407564291042e+03,		1.026890888294708e+03,		1.027372850214339e+03,		1.027853458521185e+03,		1.028332721605634e+03,
		1.028810647778259e+03,		1.029287245270835e+03,		1.029762522237354e+03,		1.030236486755009e+03,		1.030709146825175e+03,
		1.031180510374368e+03,		1.031650585255187e+03,		1.032119379247248e+03,		1.032586900058094e+03,		1.033053155324097e+03,
		1.033518152611350e+03,		1.033981899416528e+03,		1.034444403167756e+03,		1.034905671225453e+03,		1.035365710883160e+03,
		1.035824529368362e+03,		1.036282133843298e+03,		1.036738531405748e+03,		1.037193729089821e+03,		1.037647733866725e+03,
		1.038100552645519e+03,		1.038552192273871e+03,		1.039002659538781e+03,		1.039451961167317e+03,		1.039900103827320e+03,
		1.040347094128112e+03,		1.040792938621187e+03,		1.041237643800893e+03,		1.041681216105102e+03,		1.042123661915877e+03,
		1.042564987560120e+03,		1.043005199310215e+03,		1.043444303384664e+03,		1.043882305948707e+03,		1.044319213114942e+03,
		1.044755030943924e+03,		1.045189765444772e+03,		1.045623422575745e+03,		1.046056008244835e+03,		1.046487528310329e+03,
		1.046917988581376e+03,		1.047347394818546e+03,		1.047775752734370e+03,		1.048203067993888e+03,		1.048629346215174e+03,
		1.049054592969866e+03,		1.049478813783682e+03,		1.049902014136929e+03,		1.050324199465004e+03,		1.050745375158896e+03,
		1.051165546565668e+03,		1.051584718988946e+03,		1.052002897689390e+03,		1.052420087885161e+03,		1.052836294752392e+03,
		1.053251523425637e+03,		1.053665778998321e+03,		1.054079066523191e+03,		1.054491391012743e+03,		1.054902757439666e+03,
		1.055313170737257e+03,		1.055722635799849e+03,		1.056131157483222e+03,		1.056538740605013e+03,		1.056945389945122e+03,
		1.057351110246108e+03,		1.057755906213579e+03,		1.058159782516587e+03,		1.058562743788005e+03,		1.058964794624907e+03,
		1.059365939588940e+03,		1.059766183206693e+03,		1.060165529970057e+03,		1.060563984336589e+03,		1.060961550729858e+03,
		1.061358233539802e+03,		1.061754037123065e+03,		1.062148965803344e+03,		1.062543023871719e+03,		1.062936215586988e+03,
		1.063328545175993e+03,		1.063720016833944e+03,		1.064110634724736e+03,		1.064500402981265e+03,		1.064889325705739e+03,
		1.065277406969985e+03,		1.065664650815753e+03,		1.066051061255011e+03,		1.066436642270247e+03,		1.066821397814756e+03,
		1.067205331812930e+03,		1.067588448160542e+03,		1.067970750725030e+03,		1.068352243345770e+03,		1.068732929834352e+03,
		1.069112813974854e+03,		1.069491899524103e+03,		1.069870190211946e+03,		1.070247689741510e+03,		1.070624401789453e+03,
		1.071000330006226e+03,		1.071375478016325e+03,		1.071749849418533e+03,		1.072123447786172e+03,		1.072496276667344e+03,
		1.072868339585166e+03,		1.073239640038017e+03,		1.073610181499761e+03,		1.073979967419985e+03,		1.074349001224226e+03,
		1.074717286314198e+03,		1.075084826068010e+03,		1.075451623840395e+03,		1.075817682962920e+03,		1.076183006744207e+03,
		1.076547598470140e+03,		1.076911461404083e+03,		1.077274598787081e+03,		1.077637013838071e+03,		1.077998709754080e+03,
		1.078359689710429e+03,		1.078719956860934e+03,		1.079079514338091e+03,		1.079438365253289e+03,		1.079796512696980e+03,
		1.080153959738888e+03,		1.080510709428180e+03,		1.080866764793666e+03,		1.081222128843969e+03,		1.081576804567715e+03,
		1.081930794933711e+03,		1.082284102891116e+03,		1.082636731369622e+03,		1.082988683279626e+03,		1.083339961512399e+03,
		1.083690568940259e+03,		1.084040508416733e+03,		1.084389782776726e+03,		1.084738394836687e+03,		1.085086347394765e+03,
		1.085433643230972e+03,		1.085780285107343e+03,		1.086126275768090e+03,		1.086471617939759e+03,		1.086816314331380e+03,
		1.087160367634619e+03,		1.087503780523934e+03,		1.087846555656716e+03,		1.088188695673437e+03,		1.088530203197796e+03
	},
	{
		1.658525701188622e+00,		5.018699737299185e+00,		8.433688411025241e+00,		1.190568494001790e+01,		1.543702378213396e+01,
		1.903019289334220e+01,		2.268784733986369e+01,		2.641282444864739e+01,		3.020816071019453e+01,		3.407711068333968e+01,
		3.802316819411635e+01,		4.205009017182692e+01,		4.616192352684134e+01,		5.036303554890811e+01,		5.465814839496423e+01,
		5.905237834550675e+01,		6.355128064355790e+01,		6.816090089657081e+01,		7.288783422761752e+01,		7.773929361870329e+01,
		8.272318921021079e+01,		8.784822072488055e+01,		9.312398569695762e+01,		9.856110683985071e+01,		1.041713827225474e+02,
		1.099679670048867e+02,		1.159655828840748e+02,		1.221807812375680e+02,		1.286322533580607e+02,		1.353412123665976e+02,
		1.423318616361931e+02,		1.496319742383344e+02,		1.572736150494371e+02,		1.652940474015355e+02,		1.737368798922982e+02,
		1.826535271766049e+02,		1.921050821127165e+02,		2.021647254540239e+02,		2.129208300576250e+02,		2.244809367819326e+02,
		2.369767518938367e+02,		2.505701428630803e+02,		2.654595513491969e+02,		2.818847795515057e+02,		3.001248784171420e+02,
		3.204784428136239e+02,		3.432107899176827e+02,		3.684531296195781e+02,		3.960319485799441e+02,		4.252108687621090e+02,
		4.545688217791891e+02,		4.825217067052042e+02,		5.081229970916719e+02,		5.309616347102891e+02,		5.510674357252246e+02,
		5.687255498446889e+02,		5.843033734031692e+02,		5.981522659606369e+02,		6.105708396247784e+02,		6.218007564090686e+02,
		6.320344675006427e+02,		6.414251634711816e+02,		6.500955699531780e+02,		6.581449067412969e+02,		6.656541886682118e+02,
		6.726902210199731e+02,		6.793086132090166e+02,		6.855560650756012e+02,		6.914721157067070e+02,		6.970904938608182e+02,
		7.024401712229035e+02,		7.075461921397864e+02,		7.124303336209331e+02,		7.171116351380917e+02,		7.216068275285865e+02,
		7.259306829368018e+02,		7.300963023819392e+02,		7.341153536277129e+02,		7.379982691382246e+02,		7.417544117446114e+02,
		7.453922140168069e+02,		7.489192960913392e+02,		7.523425657485058e+02,		7.556683037881547e+02,		7.589022371700412e+02,
		7.620496019244829e+02,		7.651151974729781e+02,		7.681034337058159e+02,		7.710183719282347e+02,		7.738637605962543e+02,
		7.766430666087549e+02,		7.793595027959861e+02,		7.820160521414091e+02,		7.846154891885035e+02,		7.871603990139780e+02,
		7.896531940904869e+02,		7.920961293135369e+02,		7.944913154267171e+02,		7.968407310456413e+02,		7.991462334524155e+02,
		8.014095683085189e+02,		8.036323784137209e+02,		8.058162116214410e+02,		8.079625280064098e+02,		8.100727063679607e+02,
		8.121480501416966e+02,		8.141897927831194e+02,		8.161991026789888e+02,		8.181770876353609e+02,		8.201247989854877e+02,
		8.220432353556621e+02,		8.239333461226856e+02,		8.257960345928486e+02,		8.276321609289664e+02,		8.294425448490850e+02,
		8.312279681179301e+02,		8.329891768499472e+02,		8.347268836407605e+02,		8.364417695421921e+02,		8.381344858944144e+02,
		8.398056560274530e+02,		8.414558768430704e+02,		8.430857202869464e+02,		8.446957347201840e+02,		8.462864461982548e+02,
		8.478583596647604e+02,		8.494119600667467e+02,		8.509477133976288e+02,		8.524660676733015e+02,		8.539674538464693e+02,
		8.554522866638464e+02,		8.569209654704097e+02,		8.583738749645969e+02,		8.598113859079599e+02,		8.612338557925408e+02,
		8.626416294689230e+02,		8.640350397377071e+02,		8.654144079069272e+02,		8.667800443177238e+02,		8.681322488404001e+02,
		8.694713113428459e+02,		8.707975121331309e+02,		8.721111223779748e+02,		8.734124044986198e+02,		8.747016125455624e+02,
		8.759789925534826e+02,		8.772447828775929e+02,		8.784992145125740e+02,		8.797425113951368e+02,		8.809748906912467e+02,
		8.821965630688758e+02,		8.834077329571960e+02,		8.846085987929747e+02,		8.857993532549399e+02,		8.869801834867980e+02,
		8.881512713095640e+02,		8.893127934238032e+02,		8.904649216023616e+02,		8.916078228740937e+02,		8.927416596991114e+02,
		8.938665901360038e+02,		8.949827680014628e+02,		8.960903430227228e+02,		8.971894609832116e+02,		8.982802638617493e+02,
		8.993628899656497e+02,		9.004374740580379e+02,		9.015041474796803e+02,		9.025630382656005e+02,		9.036142712567680e+02,
		9.046579682070761e+02,		9.056942478858748e+02,		9.067232261762562e+02,		9.077450161693115e+02,		9.087597282545535e+02,
		9.097674702066932e+02,		9.107683472689395e+02,		9.117624622329887e+02,		9.127499155158688e+02,		9.137308052337703e+02,
		9.147052272730192e+02,		9.156732753583165e+02,		9.166350411183683e+02,		9.175906141490259e+02,		9.185400820740589e+02,
		9.194835306036446e+02,		9.204210435907032e+02,		9.213527030851467e+02,		9.222785893861599e+02,		9.231987810925697e+02,
		9.241133551514193e+02,		9.250223869047894e+02,		9.259259501349702e+02,		9.268241171080329e+02,		9.277169586158859e+02,
		9.286045440168633e+02,		9.294869412749150e+02,		9.303642169974552e+02,		9.312364364719261e+02,		9.321036637011181e+02,
		9.329659614373152e+02,		9.338233912152971e+02,		9.346760133842462e+02,		9.355238871386109e+02,		9.363670705479600e+02,
		9.372056205858651e+02,		9.380395931578577e+02,		9.388690431284836e+02,		9.396940243475046e+02,		9.405145896752704e+02,
		9.413307910072855e+02,		9.421426792980244e+02,		9.429503045839950e+02,		9.437537160061006e+02,		9.445529618313129e+02,
		9.453480894736890e+02,		9.461391455147457e+02,		9.469261757232354e+02,		9.477092250743182e+02,		9.484883377681725e+02,
		9.492635572480555e+02,		9.500349262178311e+02,		9.508024866589940e+02,		9.515662798471960e+02,		9.523263463682941e+02,
		9.530827261339466e+02,		9.538354583967598e+02,		9.545845817650114e+02,		9.553301342169490e+02,		9.560721531147090e+02,
		9.568106752178277e+02,		9.575457366963910e+02,		9.582773731438224e+02,		9.590056195893146e+02,		9.597305105099343e+02,
		9.604520798423902e+02,		9.611703609944914e+02,		9.618853868562959e+02,		9.625971898109665e+02,		9.633058017453375e+02,
		9.640112540602047e+02,		9.647135776803481e+02,		9.654128030642896e+02,		9.661089602138077e+02,		9.668020786831966e+02,
		9.674921875882951e+02,		9.681793156152895e+02,		9.688634910292811e+02,		9.695447416826555e+02,		9.702230950232273e+02,
		9.708985781021902e+02,		9.715712175818702e+02,		9.722410397432830e+02,		9.729080704935110e+02,		9.735723353728993e+02,
		9.742338595620736e+02,		9.748926678887956e+02,		9.755487848346478e+02,		9.762022345415617e+02,		9.768530408181889e+02,
		9.775012271461243e+02,		9.781468166859781e+02,		9.787898322833132e+02,		9.794302964744352e+02,		9.800682314920559e+02,
		9.807036592708209e+02,		9.813366014527151e+02,		9.819670793923368e+02,		9.825951141620637e+02,		9.832207265570887e+02,
		9.838439371003525e+02,		9.844647660473634e+02,		9.850832333909029e+02,		9.856993588656375e+02,		9.863131619526188e+02,
		9.869246618836914e+02,		9.875338776458008e+02,		9.881408279852092e+02,		9.887455314116183e+02,		9.893480062022022e+02,
		9.899482704055572e+02,		9.905463418455668e+02,		9.911422381251764e+02,		9.917359766300999e+02,		9.923275745324394e+02,
		9.929170487942333e+02,		9.935044161709254e+02,		9.940896932147679e+02,		9.946728962781490e+02,		9.952540415168542e+02,
		9.958331448932586e+02,		9.964102221794552e+02,		9.969852889603229e+02,		9.975583606365202e+02,		9.981294524274364e+02,
		9.986985793740656e+02,		9.992657563418368e+02,		9.998309980233792e+02,		1.000394318941235e+03,		1.000955733450519e+03,
		1.001515255741530e+03,		1.002072899842297e+03,		1.002628679621095e+03,		1.003182608788895e+03,		1.003734700901777e+03,
		1.004284969363294e+03,		1.004833427426782e+03,		1.005380088197644e+03,		1.005924964635571e+03,		1.006468069556735e+03,
		1.007009415635931e+03,		1.007549015408684e+03,		1.008086881273315e+03,		1.008623025492970e+03,		1.009157460197607e+03,
		1.009690197385950e+03,		1.010221248927406e+03,		1.010750626563945e+03,		1.011278341911950e+03,		1.011804406464025e+03,
		1.012328831590782e+03,		1.012851628542581e+03,		1.013372808451253e+03,		1.013892382331783e+03,		1.014410361083964e+03,
		1.014926755494026e+03,		1.015441576236228e+03,		1.015954833874431e+03,		1.016466538863637e+03,		1.016976701551504e+03,
		1.017485332179831e+03,		1.017992440886020e+03,		1.018498037704513e+03,		1.019002132568206e+03,		1.019504735309823e+03,
		1.020005855663298e+03,		1.020505503265097e+03,		1.021003687655545e+03,		1.021500418280117e+03,		1.021995704490707e+03,
		1.022489555546885e+03,		1.022981980617122e+03,		1.023472988780002e+03,		1.023962589025408e+03,		1.024450790255690e+03,
		1.024937601286821e+03,		1.025423030849521e+03,		1.025907087590372e+03,		1.026389780072910e+03,		1.026871116778704e+03,
		1.027351106108410e+03,		1.027829756382815e+03,		1.028307075843860e+03,		1.028783072655647e+03,		1.029257754905432e+03,
		1.029731130604601e+03,		1.030203207689626e+03,		1.030673994023013e+03,		1.031143497394233e+03,		1.031611725520632e+03,
		1.032078686048333e+03,		1.032544386553129e+03,		1.033008834541344e+03,		1.033472037450700e+03,		1.033934002651161e+03,
		1.034394737445764e+03,		1.034854249071436e+03,		1.035312544699808e+03,		1.035769631438003e+03,		1.036225516329419e+03,
		1.036680206354503e+03,		1.037133708431505e+03,		1.037586029417229e+03,		1.038037176107766e+03,		1.038487155239220e+03,
		1.038935973488420e+03,		1.039383637473627e+03,		1.039830153755223e+03,		1.040275528836393e+03,		1.040719769163802e+03,
		1.041162881128250e+03,		1.041604871065330e+03,		1.042045745256069e+03,		1.042485509927564e+03,		1.042924171253599e+03,
		1.043361735355267e+03,		1.043798208301574e+03,		1.044233596110038e+03,		1.044667904747273e+03,		1.045101140129575e+03,
		1.045533308123491e+03,		1.045964414546380e+03,		1.046394465166976e+03,		1.046823465705930e+03,		1.047251421836352e+03,
		1.047678339184341e+03,		1.048104223329516e+03,		1.048529079805528e+03,		1.048952914100570e+03,		1.049375731657885e+03,
		1.049797537876257e+03,		1.050218338110504e+03,		1.050638137671960e+03,		1.051056941828947e+03,		1.051474755807249e+03,
		1.051891584790573e+03,		1.052307433921006e+03,		1.052722308299462e+03,		1.053136212986132e+03,		1.053549153000918e+03,
		1.053961133323866e+03,		1.054372158895591e+03,		1.054782234617703e+03,		1.055191365353215e+03,		1.055599555926955e+03,
		1.056006811125972e+03,		1.056413135699934e+03,		1.056818534361518e+03,		1.057223011786802e+03,		1.057626572615645e+03,
		1.058029221452067e+03,		1.058430962864620e+03,		1.058831801386762e+03,		1.059231741517208e+03,		1.059630787720301e+03,
		1.060028944426358e+03,		1.060426216032027e+03,		1.060822606900621e+03,		1.061218121362469e+03,		1.061612763715245e+03,
		1.062006538224301e+03,		1.062399449122999e+03,		1.062791500613026e+03,		1.063182696864721e+03,		1.063573042017386e+03,
		1.063962540179598e+03,		1.064351195429516e+03,		1.064739011815184e+03,		1.065125993354833e+03,		1.065512144037172e+03,
		1.065897467821685e+03,		1.066281968638916e+03,		1.066665650390757e+03,		1.067048516950726e+03,		1.067430572164246e+03,
		1.067811819848922e+03,		1.068192263794807e+03,		1.068571907764676e+03,		1.068950755494286e+03,		1.069328810692636e+03,
		1.069706077042231e+03,		1.070082558199332e+03,		1.070458257794208e+03,		1.070833179431389e+03,		1.071207326689907e+03,
		1.071580703123542e+03,		1.071953312261059e+03,		1.072325157606449e+03,		1.072696242639159e+03,		1.073066570814328e+03,
		1.073436145563011e+03,		1.073804970292412e+03,		1.074173048386095e+03,		1.074540383204221e+03,		1.074906978083751e+03,
		1.075272836338673e+03,		1.075637961260207e+03,		1.076002356117020e+03,		1.076366024155435e+03,		1.076728968599633e+03,
		1.077091192651856e+03,		1.077452699492614e+03,		1.077813492280878e+03,		1.078173574154277e+03,		1.078532948229295e+03,
		1.078891617601462e+03,		1.079249585345539e+03,		1.079606854515714e+03,		1.079963428145780e+03,		1.080319309249322e+03,
		1.080674500819899e+03,		1.081029005831219e+03,		1.081382827237321e+03,		1.081735967972748e+03,		1.082088430952718e+03,
		1.082440219073301e+03,		1.082791335211585e+03,		1.083141782225840e+03,		1.083491562955690e+03,		1.083840680222276e+03,
		1.084189136828411e+03,		1.084536935558750e+03,		1.084884079179942e+03,		1.085230570440787e+03,		1.085576412072397e+03,
		1.085921606788341e+03,		1.086266157284802e+03,		1.086610066240724e+03,		1.086953336317965e+03,		1.087295970161438e+03
	},
	{
		1.655369218994953e+00,		5.008892632550693e+00,		8.416760171885633e+00,		1.188112783563846e+01,		1.540428918299021e+01,
		1.898868714305996e+01,		2.263692711314913e+01,		2.635179151874410e+01,		3.013625603588284e+01,		3.399350770936923e+01,
		3.792696523949304e+01,		4.194030175676676e+01,		4.603747046045137e+01,		5.022273356447683e+01,		5.450069507649995e+01,
		5.887633803573691e+01,		6.335506695725449e+01,		6.794275638022455e+01,		7.264580660245670e+01,		7.747120791265357e+01,
		8.242661491738734e+01,		8.752043291758142e+01,		9.276191874003210e+01,		9.816129900057412e+01,		1.037299095031446e+02,
		1.094803604115206e+02,		1.154267330325302e+02,		1.215848156078306e+02,		1.279723875427361e+02,		1.346095641624837e+02,
		1.415192175904512e+02,		1.487274939719998e+02,		1.562644533941713e+02,		1.641648669511752e+02,		1.724692160500542e+02,
		1.812249528336802e+02,		1.904880978840140e+02,		2.003252715933943e+02,		2.108162754581722e+02,		2.220573485546438e+02,
		2.341651941554974e+02,		2.472817307557814e+02,		2.615791050551129e+02,		2.772634646374739e+02,		2.945737511525304e+02,
		3.137679576260929e+02,		3.350854282955023e+02,		3.586741432748237e+02,		3.844726165913933e+02,		4.120296624116921e+02,
		4.403349624079788e+02,		4.679865948096883e+02,		4.938542236634366e+02,		5.173556039536548e+02,		5.383105236281730e+02,
		5.568502591674401e+02,		5.732576825732807e+02,		5.878512428175414e+02,		6.009250208233766e+02,		6.127281579804131e+02,
		6.234640289572905e+02,		6.332965897753353e+02,		6.423579917401939e+02,		6.507553436932191e+02,		6.585761539969837e+02,
		6.658925513309537e+02,		6.727645186672700e+02,		6.792423680936644e+02,		6.853686423945171e+02,		6.911795861934366e+02,
		6.967062936056417e+02,		7.019756116487870e+02,		7.070108579525056e+02,		7.118323960778173e+02,		7.164581006460104e+02,
		7.209037363876163e+02,		7.251832693220241e+02,		7.293091239527558e+02,		7.332923971689139e+02,		7.371430371624610e+02,
		7.408699938797491e+02,		7.444813461639678e+02,		7.479844096999808e+02,		7.513858290631169e+02,		7.546916565403526e+02,
		7.579074198933035e+02,		7.610381808365328e+02,		7.640885856878679e+02,		7.670629093932044e+02,		7.699650939222639e+02,
		7.727987818647071e+02,		7.755673459195534e+02,		7.782739148588400e+02,		7.809213964545161e+02,		7.835124977813351e+02,
		7.860497432454936e+02,		7.885354906362245e+02,		7.909719454537100e+02,		7.933611737299726e+02,		7.957051135285564e+02,
		7.980055852828190e+02,		8.002643011106647e+02,		8.024828732249366e+02,		8.046628215428840e+02,		8.068055805845524e+02,
		8.089125057385079e+02,		8.109848789633410e+02,		8.130239139849558e+02,		8.150307610423080e+02,		8.170065112279602e+02,
		8.189522004643247e+02,		8.208688131517964e+02,		8.227572855207089e+02,		8.246185087156351e+02,		8.264533316372458e+02,
		8.282625635643061e+02,		8.300469765759054e+02,		8.318073077919265e+02,		8.335442614478884e+02,		8.352585108186390e+02,
		8.369507000039226e+02,		8.386214455875319e+02,		8.402713381806512e+02,		8.419009438589152e+02,		8.435108055018773e+02,
		8.451014440426718e+02,		8.466733596350189e+02,		8.482270327440193e+02,		8.497629251666348e+02,		8.512814809871710e+02,
		8.527831274727046e+02,		8.542682759128769e+02,		8.557373224081455e+02,		8.571906486102384e+02,		8.586286224182236e+02,
		8.600515986333515e+02,		8.614599195755234e+02,		8.628539156640844e+02,		8.642339059653418e+02,		8.656001987090776e+02,
		8.669530917761400e+02,		8.682928731589900e+02,		8.696198213970190e+02,		8.709342059882387e+02,		8.722362877788737e+02,
		8.735263193322520e+02,		8.748045452782918e+02,		8.760712026447978e+02,		8.773265211716844e+02,		8.785707236091497e+02,
		8.798040260008015e+02,		8.810266379525974e+02,		8.822387628884674e+02,		8.834405982933841e+02,		8.846323359446105e+02,
		8.858141621318181e+02,		8.869862578666803e+02,		8.881487990825837e+02,		8.893019568249529e+02,		8.904458974327597e+02,
		8.915807827116663e+02,		8.927067700992803e+02,		8.938240128229377e+02,		8.949326600504098e+02,		8.960328570339282e+02,
		8.971247452478532e+02,		8.982084625203447e+02,		8.992841431593201e+02,		9.003519180730166e+02,		9.014119148854159e+02,
		9.024642580467961e+02,		9.035090689396588e+02,		9.045464659802527e+02,		9.055765647159212e+02,		9.065994779184686e+02,
		9.076153156737419e+02,		9.086241854676208e+02,		9.096261922685622e+02,		9.106214386068870e+02,		9.116100246509583e+02,
		9.125920482803774e+02,		9.135676051563688e+02,		9.145367887894416e+02,		9.154996906044980e+02,		9.164564000034630e+02,
		9.174070044255795e+02,		9.183515894054462e+02,		9.192902386289190e+02,		9.202230339869602e+02,		9.211500556275273e+02,
		9.220713820055811e+02,		9.229870899313099e+02,		9.238972546166223e+02,		9.248019497200089e+02,		9.257012473898164e+02,
		9.265952183060183e+02,		9.274839317205414e+02,		9.283674554961979e+02,		9.292458561442951e+02,		9.301191988609670e+02,
		9.309875475622759e+02,		9.318509649181548e+02,		9.327095123852038e+02,		9.335632502384158e+02,		9.344122376018582e+02,
		9.352565324783568e+02,		9.360961917782166e+02,		9.369312713470210e+02,		9.377618259925458e+02,		9.385879095108133e+02,
		9.394095747113323e+02,		9.402268734415418e+02,		9.410398566104981e+02,		9.418485742118270e+02,		9.426530753459722e+02,
		9.434534082417636e+02,		9.442496202773302e+02,		9.450417580003890e+02,		9.458298671479150e+02,		9.466139926652327e+02,
		9.473941787245425e+02,		9.481704687429004e+02,		9.489429053996713e+02,		9.497115306534756e+02,		9.504763857586478e+02,
		9.512375112812194e+02,		9.519949471144483e+02,		9.527487324939076e+02,		9.534989060121447e+02,		9.542455056329353e+02,
		9.549885687051328e+02,		9.557281319761402e+02,		9.564642316050072e+02,		9.571969031751698e+02,		9.579261817068419e+02,
		9.586521016690679e+02,		9.593746969914606e+02,		9.600940010756078e+02,		9.608100468061969e+02,		9.615228665618232e+02,
		9.622324922255267e+02,		9.629389551950480e+02,		9.636422863928188e+02,		9.643425162756924e+02,		9.650396748444211e+02,
		9.657337916528945e+02,		9.664248958171412e+02,		9.671130160241001e+02,		9.677981805401708e+02,		9.684804172195506e+02,
		9.691597535123634e+02,		9.698362164725860e+02,		9.705098327657768e+02,		9.711806286766180e+02,		9.718486301162714e+02,
		9.725138626295521e+02,		9.731763514019377e+02,		9.738361212663955e+02,		9.744931967100586e+02,		9.751476018807363e+02,
		9.757993605932680e+02,		9.764484963357343e+02,		9.770950322755149e+02,		9.777389912652108e+02,		9.783803958484239e+02,
		9.790192682654057e+02,		9.796556304585736e+02,		9.802895040779059e+02,		9.809209104862053e+02,		9.815498707642512e+02,
		9.821764057158309e+02,		9.828005358726584e+02,		9.834222814991807e+02,		9.840416625972863e+02,		9.846586989108989e+02,
		9.852734099304695e+02,		9.858858148973811e+02,		9.864959328082468e+02,		9.871037824191147e+02,		9.877093822495896e+02,
		9.883127505868562e+02,		9.889139054896219e+02,		9.895128647919735e+02,		9.901096461071531e+02,		9.907042668312503e+02,
		9.912967441468232e+02,		9.918870950264343e+02,		9.924753362361229e+02,		9.930614843387957e+02,		9.936455556975525e+02,
		9.942275664789451e+02,		9.948075326561604e+02,		9.953854700121503e+02,		9.959613941426878e+02,		9.965353204593674e+02,
		9.971072641925423e+02,		9.976772403942003e+02,		9.982452639407913e+02,		9.988113495359840e+02,		9.993755117133825e+02,
		9.999377648391776e+02,		1.000498123114755e+03,		1.001056600579244e+03,		1.001613211112024e+03,		1.002167968435180e+03,
		1.002720886115904e+03,		1.003271977568858e+03,		1.003821256058495e+03,		1.004368734701321e+03,		1.004914426468127e+03,
		1.005458344186174e+03,		1.006000500541337e+03,		1.006540908080212e+03,		1.007079579212171e+03,		1.007616526211397e+03,
		1.008151761218869e+03,		1.008685296244311e+03,		1.009217143168111e+03,		1.009747313743198e+03,		1.010275819596886e+03,
		1.010802672232693e+03,		1.011327883032115e+03,		1.011851463256367e+03,		1.012373424048111e+03,		1.012893776433130e+03,
		1.013412531321988e+03,		1.013929699511651e+03,		1.014445291687085e+03,		1.014959318422823e+03,		1.015471790184508e+03,
		1.015982717330398e+03,		1.016492110112862e+03,		1.016999978679834e+03,		1.017506333076252e+03,		1.018011183245465e+03,
		1.018514539030621e+03,		1.019016410176031e+03,		1.019516806328503e+03,		1.020015737038663e+03,		1.020513211762244e+03,
		1.021009239861362e+03,		1.021503830605764e+03,		1.021996993174058e+03,		1.022488736654921e+03,		1.022979070048286e+03,
		1.023468002266514e+03,		1.023955542135545e+03,		1.024441698396016e+03,		1.024926479704392e+03,		1.025409894634042e+03,
		1.025891951676323e+03,		1.026372659241638e+03,		1.026852025660475e+03,		1.027330059184430e+03,		1.027806767987217e+03,
		1.028282160165659e+03,		1.028756243740660e+03,		1.029229026658168e+03,		1.029700516790120e+03,		1.030170721935367e+03,
		1.030639649820598e+03,		1.031107308101228e+03,		1.031573704362294e+03,		1.032038846119323e+03,		1.032502740819192e+03,
		1.032965395840975e+03,		1.033426818496770e+03,		1.033887016032525e+03,		1.034345995628841e+03,		1.034803764401766e+03,
		1.035260329403580e+03,		1.035715697623563e+03,		1.036169875988754e+03,		1.036622871364701e+03,		1.037074690556190e+03,
		1.037525340307979e+03,		1.037974827305505e+03,		1.038423158175587e+03,		1.038870339487124e+03,		1.039316377751774e+03,
		1.039761279424624e+03,		1.040205050904856e+03,		1.040647698536403e+03,		1.041089228608579e+03,		1.041529647356727e+03,
		1.041968960962837e+03,		1.042407175556159e+03,		1.042844297213813e+03,		1.043280331961386e+03,		1.043715285773519e+03,
		1.044149164574490e+03,		1.044581974238784e+03,		1.045013720591657e+03,		1.045444409409694e+03,		1.045874046421356e+03,
		1.046302637307518e+03,		1.046730187702006e+03,		1.047156703192115e+03,		1.047582189319138e+03,		1.048006651578863e+03,
		1.048430095422088e+03,		1.048852526255110e+03,		1.049273949440217e+03,		1.049694370296173e+03,		1.050113794098688e+03,
		1.050532226080895e+03,		1.050949671433803e+03,		1.051366135306767e+03,		1.051781622807927e+03,		1.052196139004657e+03,
		1.052609688924005e+03,		1.053022277553119e+03,		1.053433909839684e+03,		1.053844590692330e+03,		1.054254324981059e+03,
		1.054663117537646e+03,		1.055070973156049e+03,		1.055477896592802e+03,		1.055883892567416e+03,		1.056288965762760e+03,
		1.056693120825449e+03,		1.057096362366218e+03,		1.057498694960301e+03,		1.057900123147791e+03,		1.058300651434014e+03,
		1.058700284289876e+03,		1.059099026152227e+03,		1.059496881424206e+03,		1.059893854475585e+03,		1.060289949643112e+03,
		1.060685171230846e+03,		1.061079523510490e+03,		1.061473010721717e+03,		1.061865637072492e+03,		1.062257406739398e+03,
		1.062648323867944e+03,		1.063038392572879e+03,		1.063427616938500e+03,		1.063816001018956e+03,		1.064203548838546e+03,
		1.064590264392016e+03,		1.064976151644850e+03,		1.065361214533561e+03,		1.065745456965974e+03,		1.066128882821509e+03,
		1.066511495951459e+03,		1.066893300179263e+03,		1.067274299300777e+03,		1.067654497084547e+03,		1.068033897272066e+03,
		1.068412503578042e+03,		1.068790319690652e+03,		1.069167349271801e+03,		1.069543595957369e+03,		1.069919063357465e+03,
		1.070293755056671e+03,		1.070667674614284e+03,		1.071040825564556e+03,		1.071413211416935e+03,		1.071784835656296e+03,
		1.072155701743173e+03,		1.072525813113987e+03,		1.072895173181278e+03,		1.073263785333920e+03,		1.073631652937347e+03,
		1.073998779333772e+03,		1.074365167842400e+03,		1.074730821759644e+03,		1.075095744359333e+03,		1.075459938892920e+03,
		1.075823408589693e+03,		1.076186156656972e+03,		1.076548186280315e+03,		1.076909500623713e+03,		1.077270102829792e+03,
		1.077629996019999e+03,		1.077989183294804e+03,		1.078347667733880e+03,		1.078705452396299e+03,		1.079062540320714e+03,
		1.079418934525540e+03,		1.079774638009143e+03,		1.080129653750008e+03,		1.080483984706928e+03,		1.080837633819173e+03,
		1.081190604006662e+03,		1.081542898170142e+03,		1.081894519191349e+03,		1.082245469933179e+03,		1.082595753239858e+03,
		1.082945371937098e+03,		1.083294328832266e+03,		1.083642626714541e+03,		1.083990268355072e+03,		1.084337256507140e+03,
		1.084683593906304e+03,		1.085029283270565e+03,		1.085374327300511e+03,		1.085718728679467e+03,		1.086062490073647e+03
	},
	{
		1.652224892787747e+00,		4.999125341525281e+00,		8.399904333034824e+00,		1.185668132121560e+01,		1.537170973986463e+01,
		1.894738837997006e+01,		2.258627399355291e+01,		2.629109528643169e+01,		3.006476848792059e+01,		3.391041471583288e+01,
		3.783137939124251e+01,		4.183125400049585e+01,		4.591390055349976e+01,		5.008347914925989e+01,		5.434447913441646e+01,
		5.870175443115683e+01,		6.316056372122103e+01,		6.772661630764654e+01,		7.240612464167103e+01,		7.720586470684863e+01,
		8.213324570629197e+01,		8.719639081544334e+01,		9.240423115938925e+01,		9.776661567332238e+01,		1.032944401373762e+02,
		1.089997994823274e+02,		1.148961684930303e+02,		1.209986173614405e+02,		1.273240702530285e+02,		1.338916172716103e+02,
		1.407228930994754e+02,		1.478425393625687e+02,		1.552787726928379e+02,		1.630640868599119e+02,		1.712361255888452e+02,
		1.798387730934874e+02,		1.889235219859276e+02,		1.985511922613097e+02,		2.087940874164198e+02,		2.197386757409599e+02,
		2.314888544741426e+02,		2.441697398435252e+02,		2.579316110011407e+02,		2.729528854535216e+02,		2.894394315605796e+02,
		3.076148237189361e+02,		3.276931319179408e+02,		3.498256052069980e+02,		3.740154723542580e+02,		3.999921169062285e+02,
		4.270617940604650e+02,		4.541046939054922e+02,		4.799471299784159e+02,		5.038591325001218e+02,		5.254919833246696e+02,
		5.448178757714555e+02,		5.620134906632796e+02,		5.773419518678198e+02,		5.910768392940217e+02,		6.034655639323692e+02,
		6.147178274080372e+02,		6.250063090769481e+02,		6.344717934312969e+02,		6.432290502609011e+02,		6.513720907819763e+02,
		6.589784650549091e+02,		6.661126508989631e+02,		6.728286902578682e+02,		6.791722340678617e+02,		6.851821323428649e+02,
		6.908916775070920e+02,		6.963295836729403e+02,		7.015207642368968e+02,		7.064869545536001e+02,		7.112472147237193e+02,
		7.158183388308115e+02,		7.202151905382865e+02,		7.244509802155044e+02,		7.285374952493815e+02,		7.324852925802766e+02,
		7.363038605346588e+02,		7.400017555369484e+02,		7.435867181430081e+02,		7.470657719572371e+02,		7.504453083091764e+02,
		7.537311590261363e+02,		7.569286592110850e+02,		7.600427015940257e+02,		7.630777837511768e+02,		7.660380492649665e+02,
		7.689273237180315e+02,		7.717491462676546e+02,		7.745067974266551e+02,		7.772033235777270e+02,		7.798415586661694e+02,
		7.824241434480626e+02,		7.849535426143285e+02,		7.874320600638158e+02,		7.898618525589916e+02,		7.922449419644964e+02,
		7.945832262407789e+02,		7.968784893412935e+02,		7.991324101416558e+02,		8.013465705120321e+02,		8.035224626294686e+02,
		8.056614956144643e+02,		8.077650015653400e+02,		8.098342410548589e+02,		8.118704081456440e+02,		8.138746349741112e+02,
		8.158479959467616e+02,		8.177915115875511e+02,		8.197061520706277e+02,		8.215928404688431e+02,		8.234524557450685e+02,
		8.252858355103750e+02,		8.270937785705906e+02,		8.288770472803969e+02,		8.306363697221809e+02,		8.323724417250653e+02,
		8.340859287379659e+02,		8.357774675691621e+02,		8.374476680036247e+02,		8.390971143082492e+02,		8.407263666341768e+02,
		8.423359623245266e+02,		8.439264171350726e+02,		8.454982263747032e+02,		8.470518659719152e+02,		8.485877934729863e+02,
		8.501064489770082e+02,		8.516082560124910e+02,		8.530936223598675e+02,		8.545629408238118e+02,		8.560165899590210e+02,
		8.574549347527477e+02,		8.588783272671394e+02,		8.602871072441720e+02,		8.616816026757614e+02,		8.630621303414063e+02,
		8.644289963155550e+02,		8.657824964467103e+02,		8.671229168101218e+02,		8.684505341358031e+02,		8.697656162134430e+02,
		8.710684222757017e+02,		8.723592033612357e+02,		8.736382026587412e+02,		8.749056558331687e+02,		8.761617913352131e+02,
		8.774068306950868e+02,		8.786409888015149e+02,		8.798644741668534e+02,		8.810774891791093e+02,		8.822802303416615e+02,
		8.834728885013817e+02,		8.846556490658057e+02,		8.858286922100009e+02,		8.869921930736843e+02,		8.881463219491598e+02,
		8.892912444605518e+02,		8.904271217348430e+02,		8.915541105651361e+02,		8.926723635665704e+02,		8.937820293252822e+02,
		8.948832525407745e+02,		8.959761741620459e+02,		8.970609315177962e+02,		8.981376584410258e+02,		8.992064853882988e+02,
		9.002675395539561e+02,		9.013209449795288e+02,		9.023668226585773e+02,		9.034052906372063e+02,		9.044364641104515e+02,
		9.054604555147379e+02,		9.064773746166136e+02,		9.074873285979251e+02,		9.084904221376075e+02,		9.094867574902507e+02,
		9.104764345615904e+02,		9.114595509810704e+02,		9.124362021716069e+02,		9.134064814166867e+02,		9.143704799249207e+02,
		9.153282868921648e+02,		9.162799895613163e+02,		9.172256732798978e+02,		9.181654215555155e+02,		9.190993161092914e+02,
		9.200274369273538e+02,		9.209498623104812e+02,		9.218666689219582e+02,		9.227779318337417e+02,		9.236837245709922e+02,
		9.245841191550493e+02,		9.254791861449158e+02,		9.263689946773007e+02,		9.272536125052972e+02,		9.281331060357402e+02,
		9.290075403653050e+02,		9.298769793153809e+02,		9.307414854657994e+02,		9.316011201874285e+02,		9.324559436737070e+02,
		9.333060149711368e+02,		9.341513920087915e+02,		9.349921316268724e+02,		9.358282896043482e+02,		9.366599206857118e+02,
		9.374870786068972e+02,		9.383098161203715e+02,		9.391281850194551e+02,		9.399422361618790e+02,		9.407520194926157e+02,
		9.415575840660141e+02,		9.423589780672602e+02,		9.431562488331845e+02,		9.439494428724464e+02,		9.447386058851143e+02,
		9.455237827816666e+02,		9.463050177014251e+02,		9.470823540304559e+02,		9.478558344189424e+02,		9.486255007980554e+02,
		9.493913943963389e+02,		9.501535557556222e+02,		9.509120247464862e+02,		9.516668405832836e+02,		9.524180418387398e+02,
		9.531656664581479e+02,		9.539097517731652e+02,		9.546503345152240e+02,		9.553874508285878e+02,		9.561211362830309e+02,
		9.568514258861899e+02,		9.575783540955713e+02,		9.583019548302406e+02,		9.590222614821976e+02,		9.597393069274478e+02,
		9.604531235367865e+02,		9.611637431862858e+02,		9.618711972675291e+02,		9.625755166975564e+02,		9.632767319285679e+02,
		9.639748729573722e+02,		9.646699693345937e+02,		9.653620501736417e+02,		9.660511441594574e+02,		9.667372795570423e+02,
		9.674204842197639e+02,		9.681007855974640e+02,		9.687782107443592e+02,		9.694527863267497e+02,		9.701245386305399e+02,
		9.707934935685711e+02,		9.714596766877813e+02,		9.721231131761866e+02,		9.727838278697004e+02,		9.734418452587839e+02,
		9.740971894949431e+02,		9.747498843970678e+02,		9.753999534576229e+02,		9.760474198486980e+02,		9.766923064279083e+02,
		9.773346357441656e+02,		9.779744300433089e+02,		9.786117112736142e+02,		9.792465010911727e+02,		9.798788208651446e+02,
		9.805086916828975e+02,		9.811361343550288e+02,		9.817611694202749e+02,		9.823838171503081e+02,		9.830040975544292e+02,
		9.836220303841573e+02,		9.842376351377166e+02,		9.848509310644238e+02,		9.854619371689816e+02,		9.860706722156792e+02,
		9.866771547325009e+02,		9.872814030151446e+02,		9.878834351309582e+02,		9.884832689227868e+02,		9.890809220127456e+02,
		9.896764118059039e+02,		9.902697554938965e+02,		9.908609700584626e+02,		9.914500722749038e+02,		9.920370787154736e+02,
		9.926220057526986e+02,		9.932048695626265e+02,		9.937856861280148e+02,		9.943644712414458e+02,		9.949412405083835e+02,
		9.955160093501707e+02,		9.960887930069567e+02,		9.966596065405751e+02,		9.972284648373630e+02,		9.977953826109199e+02,
		9.983603744048125e+02,		9.989234545952301e+02,		9.994846373935833e+02,		1.000043936849057e+03,		1.000601366851108e+03,
		1.001156941131917e+03,		1.001710673268790e+03,		1.002262576686524e+03,		1.002812664659709e+03,		1.003360950315009e+03,
		1.003907446633372e+03,		1.004452166452226e+03,		1.004995122467617e+03,		1.005536327236309e+03,		1.006075793177843e+03,
		1.006613532576570e+03,		1.007149557583630e+03,		1.007683880218903e+03,		1.008216512372922e+03,		1.008747465808754e+03,
		1.009276752163841e+03,		1.009804382951812e+03,		1.010330369564257e+03,		1.010854723272480e+03,		1.011377455229204e+03,
		1.011898576470261e+03,		1.012418097916241e+03,		1.012936030374116e+03,		1.013452384538836e+03,		1.013967170994899e+03,
		1.014480400217880e+03,		1.014992082575952e+03,		1.015502228331370e+03,		1.016010847641927e+03,		1.016517950562392e+03,
		1.017023547045919e+03,		1.017527646945428e+03,		1.018030260014975e+03,		1.018531395911080e+03,		1.019031064194050e+03,
		1.019529274329268e+03,		1.020026035688468e+03,		1.020521357550978e+03,		1.021015249104957e+03,		1.021507719448596e+03,
		1.021998777591310e+03,		1.022488432454905e+03,		1.022976692874728e+03,		1.023463567600793e+03,		1.023949065298897e+03,
		1.024433194551711e+03,		1.024915963859854e+03,		1.025397381642955e+03,		1.025877456240686e+03,		1.026356195913795e+03,
		1.026833608845102e+03,		1.027309703140504e+03,		1.027784486829936e+03,		1.028257967868340e+03,		1.028730154136606e+03,
		1.029201053442502e+03,		1.029670673521586e+03,		1.030139022038111e+03,		1.030606106585907e+03,		1.031071934689257e+03,
		1.031536513803752e+03,		1.031999851317135e+03,		1.032461954550143e+03,		1.032922830757313e+03,		1.033382487127799e+03,
		1.033840930786160e+03,		1.034298168793145e+03,		1.034754208146466e+03,		1.035209055781551e+03,		1.035662718572293e+03,
		1.036115203331789e+03,		1.036566516813061e+03,		1.037016665709772e+03,		1.037465656656928e+03,		1.037913496231569e+03,
		1.038360190953457e+03,		1.038805747285744e+03,		1.039250171635634e+03,		1.039693470355037e+03,		1.040135649741213e+03,
		1.040576716037404e+03,		1.041016675433459e+03,		1.041455534066449e+03,		1.041893298021273e+03,		1.042329973331258e+03,
		1.042765565978744e+03,		1.043200081895668e+03,		1.043633526964135e+03,		1.044065907016982e+03,		1.044497227838334e+03,
		1.044927495164151e+03,		1.045356714682772e+03,		1.045784892035441e+03,		1.046212032816841e+03,		1.046638142575604e+03,
		1.047063226814827e+03,		1.047487290992572e+03,		1.047910340522364e+03,		1.048332380773681e+03,		1.048753417072436e+03,
		1.049173454701454e+03,		1.049592498900940e+03,		1.050010554868942e+03,		1.050427627761813e+03,		1.050843722694655e+03,
		1.051258844741765e+03,		1.051672998937078e+03,		1.052086190274592e+03,		1.052498423708803e+03,		1.052909704155119e+03,
		1.053320036490280e+03,		1.053729425552764e+03,		1.054137876143195e+03,		1.054545393024738e+03,		1.054951980923498e+03,
		1.055357644528902e+03,		1.055762388494088e+03,		1.056166217436280e+03,		1.056569135937161e+03,		1.056971148543246e+03,
		1.057372259766238e+03,		1.057772474083394e+03,		1.058171795937875e+03,		1.058570229739099e+03,		1.058967779863082e+03,
		1.059364450652784e+03,		1.059760246418437e+03,		1.060155171437888e+03,		1.060549229956919e+03,		1.060942426189572e+03,
		1.061334764318472e+03,		1.061726248495135e+03,		1.062116882840289e+03,		1.062506671444176e+03,		1.062895618366854e+03,
		1.063283727638503e+03,		1.063671003259715e+03,		1.064057449201790e+03,		1.064443069407025e+03,		1.064827867788998e+03,
		1.065211848232847e+03,		1.065595014595555e+03,		1.065977370706219e+03,		1.066358920366324e+03,		1.066739667350010e+03,
		1.067119615404339e+03,		1.067498768249553e+03,		1.067877129579336e+03,		1.068254703061067e+03,		1.068631492336074e+03,
		1.069007501019880e+03,		1.069382732702455e+03,		1.069757190948451e+03,		1.070130879297451e+03,		1.070503801264202e+03,
		1.070875960338848e+03,		1.071247359987164e+03,		1.071618003650788e+03,		1.071987894747441e+03,		1.072357036671155e+03,
		1.072725432792495e+03,		1.073093086458773e+03,		1.073460000994269e+03,		1.073826179700441e+03,		1.074191625856135e+03,
		1.074556342717799e+03,		1.074920333519683e+03,		1.075283601474048e+03,		1.075646149771359e+03,		1.076007981580495e+03,
		1.076369100048937e+03,		1.076729508302969e+03,		1.077089209447862e+03,		1.077448206568072e+03,		1.077806502727427e+03,
		1.078164100969306e+03,		1.078521004316829e+03,		1.078877215773039e+03,		1.079232738321077e+03,		1.079587574924364e+03,
		1.079941728526771e+03,		1.080295202052800e+03,		1.080647998407748e+03,		1.081000120477884e+03,		1.081351571130611e+03,
		1.081702353214635e+03,		1.082052469560126e+03,		1.082401922978888e+03,		1.082750716264507e+03,		1.083098852192525e+03,
		1.083446333520580e+03,		1.083793162988579e+03,		1.084139343318836e+03,		1.084484877216236e+03,		1.084829767368377e+03
	},
	{
		1.649092651110541e+00,		4.989397609096499e+00,		8.383120391866173e+00,		1.183234456919397e+01,		1.533928420627787e+01,
		1.890629482471498e+01,		2.253588553066275e+01,		2.623073246264196e+01,		2.999369373516154e+01,		3.382782608237189e+01,
		3.773640343917700e+01,		4.172293773675921e+01,		4.579120223665993e+01,		4.994525778411769e+01,		5.418948242941312e+01,
		5.852860494817774e+01,		6.296774289134513e+01,		6.751244591691207e+01,		7.216874530433398e+01,		7.694321073509850e+01,
		8.184301564864538e+01,		8.687601276270803e+01,		9.205082169605360e+01,		9.737693106858131e+01,		1.028648180036524e+02,
		1.085260886528136e+02,		1.143736442461846e+02,		1.204218782982787e+02,		1.266869120415788e+02,		1.331868770134297e+02,
		1.399422561078992e+02,		1.469762974782626e+02,		1.543155196284682e+02,		1.619903310841236e+02,		1.700357944080815e+02,
		1.784925721661566e+02,		1.874081016143626e+02,		1.968380544614290e+02,		2.068481452726133e+02,		2.175163497680774e+02,
		2.289355654422708e+02,		2.412166532239883e+02,		2.544915581396609e+02,		2.689156578347694e+02,		2.846673681807862e+02,
		3.019411124756688e+02,		3.209274557847360e+02,		3.417735783114047e+02,		3.645200087631977e+02,		3.890103057983438e+02,
		4.147756773931458e+02,		4.409695724147999e+02,		4.665308662986931e+02,		4.906036617018446e+02,		5.127215446269815e+02,
		5.327079045934798e+02,		5.506228625257185e+02,		5.666564919294866e+02,		5.810456910334835e+02,		5.940248829860848e+02,
		6.058034881304093e+02,		6.165594735086241e+02,		6.264406402544398e+02,		6.355687400136659e+02,		6.440440577552015e+02,
		6.519495385703283e+02,		6.593542117988085e+02,		6.663159329957844e+02,		6.728835473550606e+02,		6.790985890335689e+02,
		6.849966174473482e+02,		6.906082726939691e+02,		6.959601143716632e+02,		7.010752931228208e+02,		7.059740924228307e+02,
		7.106743690762365e+02,		7.151919140437634e+02,		7.195407501024093e+02,		7.237333790150593e+02,		7.277809880233877e+02,
		7.316936233255780e+02,		7.354803365715027e+02,		7.391493091650185e+02,		7.427079582062402e+02,		7.461630271634911e+02,
		7.495206637823372e+02,		7.527864872789988e+02,		7.559656464990500e+02,		7.590628704285861e+02,		7.620825122078110e+02,
		7.650285876045818e+02,		7.679048087482420e+02,		7.707146137953044e+02,		7.734611930923727e+02,		7.761475123139213e+02,
		7.787763329797791e+02,		7.813502306963668e+02,		7.838716114151309e+02,		7.863427259590347e+02,		7.887656830322529e+02,
		7.911424608980171e+02,		7.934749178841358e+02,		7.957648018540103e+02,		7.980137587626504e+02,		8.002233404014529e+02,
		8.023950114221915e+02,		8.045301557190880e+02,		8.066300822380842e+02,		8.086960302738595e+02,		8.107291743078455e+02,
		8.127306284341843e+02,		8.147014504150062e+02,		8.166426454017045e+02,		8.185551693546893e+02,		8.204399321904675e+02,
		8.222978006817500e+02,		8.241296011334686e+02,		8.259361218551818e+02,		8.277181154481740e+02,		8.294763009236468e+02,
		8.312113656667722e+02,		8.329239672598386e+02,		8.346147351764492e+02,		8.362842723575482e+02,		8.379331566790139e+02,
		8.395619423196355e+02,		8.411711610374554e+02,		8.427613233617516e+02,		8.443329197072021e+02,		8.458864214162934e+02,
		8.474222817353724e+02,		8.489409367293723e+02,		8.504428061397480e+02,		8.519282941897771e+02,		8.533977903410555e+02,
		8.548516700046747e+02,		8.562902952102768e+02,		8.577140152359531e+02,		8.591231672016704e+02,		8.605180766287376e+02,
		8.618990579675939e+02,		8.632664150960478e+02,		8.646204417899061e+02,		8.659614221678195e+02,		8.672896311119918e+02,
		8.686053346663186e+02,		8.699087904133700e+02,		8.712002478315602e+02,		8.724799486337160e+02,		8.737481270882090e+02,
		8.750050103236968e+02,		8.762508186184699e+02,		8.774857656753195e+02,		8.787100588827894e+02,		8.799238995635964e+02,
		8.811274832109802e+02,		8.823209997136638e+02,		8.835046335700804e+02,		8.846785640924689e+02,		8.858429656014115e+02,
		8.869980076113296e+02,		8.881438550074544e+02,		8.892806682147138e+02,		8.904086033589967e+02,		8.915278124211861e+02,
		8.926384433843384e+02,		8.937406403743987e+02,		8.948345437947600e+02,		8.959202904549958e+02,		8.969980136940718e+02,
		8.980678434983033e+02,		8.991299066143406e+02,		9.001843266574169e+02,		9.012312242150987e+02,		9.022707169467684e+02,
		9.033029196790344e+02,		9.043279444972728e+02,		9.053459008334981e+02,		9.063568955507094e+02,		9.073610330239115e+02,
		9.083584152179487e+02,		9.093491417623015e+02,		9.103333100229935e+02,		9.113110151717378e+02,		9.122823502524463e+02,
		9.132474062452266e+02,		9.142062721279727e+02,		9.151590349356750e+02,		9.161057798175146e+02,		9.170465900918834e+02,
		9.179815472993879e+02,		9.189107312539375e+02,		9.198342200919990e+02,		9.207520903200970e+02,		9.216644168606275e+02,
		9.225712730960654e+02,		9.234727309116287e+02,		9.243688607364578e+02,		9.252597315833870e+02,		9.261454110873518e+02,
		9.270259655424854e+02,		9.279014599379811e+02,		9.287719579927325e+02,		9.296375221888417e+02,		9.304982138040070e+02,
		9.313540929428515e+02,		9.322052185672309e+02,		9.330516485255615e+02,		9.338934395812005e+02,		9.347306474399187e+02,
		9.355633267765098e+02,		9.363915312605468e+02,		9.372153135813369e+02,		9.380347254721081e+02,		9.388498177334285e+02,
		9.396606402559180e+02,		9.404672420422686e+02,		9.412696712285812e+02,		9.420679751050732e+02,		9.428622001361588e+02,
		9.436523919799265e+02,		9.444385955070474e+02,		9.452208548191207e+02,		9.459992132664854e+02,		9.467737134655098e+02,
		9.475443973153867e+02,		9.483113060144393e+02,		9.490744800759649e+02,		9.498339593436277e+02,		9.505897830064147e+02,
		9.513419896131765e+02,		9.520906170867554e+02,		9.528357027377253e+02,		9.535772832777538e+02,		9.543153948325918e+02,
		9.550500729547140e+02,		9.557813526356158e+02,		9.565092683177733e+02,		9.572338539062904e+02,		9.579551427802282e+02,
		9.586731678036336e+02,		9.593879613362877e+02,		9.600995552441548e+02,		9.608079809095746e+02,		9.615132692411770e+02,
		9.622154506835528e+02,		9.629145552266639e+02,		9.636106124150248e+02,		9.643036513566427e+02,		9.649937007317315e+02,
		9.656807888012149e+02,		9.663649434150042e+02,		9.670461920200866e+02,		9.677245616683914e+02,		9.684000790244860e+02,
		9.690727703730670e+02,		9.697426616262745e+02,		9.704097783308290e+02,		9.710741456749954e+02,		9.717357884953790e+02,
		9.723947312835624e+02,		9.730509981925819e+02,		9.737046130432483e+02,		9.743555993303262e+02,		9.750039802285611e+02,
		9.756497785985732e+02,		9.762930169926052e+02,		9.769337176601488e+02,		9.775719025534315e+02,		9.782075933327836e+02,
		9.788408113718871e+02,		9.794715777628930e+02,		9.800999133214367e+02,		9.807258385915342e+02,		9.813493738503701e+02,
		9.819705391129780e+02,		9.825893541368221e+02,		9.832058384262725e+02,		9.838200112369851e+02,		9.844318915801847e+02,
		9.850414982268595e+02,		9.856488497118562e+02,		9.862539643378990e+02,		9.868568601795088e+02,		9.874575550868514e+02,
		9.880560666894976e+02,		9.886524124001021e+02,		9.892466094180118e+02,		9.898386747327916e+02,		9.904286251276820e+02,
		9.910164771829800e+02,		9.916022472793554e+02,		9.921859516010945e+02,		9.927676061392810e+02,		9.933472266949087e+02,
		9.939248288819318e+02,		9.945004281302553e+02,		9.950740396886653e+02,		9.956456786276964e+02,		9.962153598424444e+02,
		9.967830980553302e+02,		9.973489078187910e+02,		9.979128035179402e+02,		9.984747993731582e+02,		9.990349094426394e+02,
		9.995931476248916e+02,		1.000149527661182e+03,		1.000704063137940e+03,		1.001256767489111e+03,		1.001807653998467e+03,
		1.002356735801867e+03,		1.002904025889490e+03,		1.003449537108007e+03,		1.003993282162723e+03,		1.004535273619678e+03,
		1.005075523907702e+03,		1.005614045320443e+03,		1.006150850018347e+03,		1.006685950030606e+03,		1.007219357257070e+03,
		1.007751083470123e+03,		1.008281140316527e+03,		1.008809539319225e+03,		1.009336291879126e+03,		1.009861409276840e+03,
		1.010384902674396e+03,		1.010906783116920e+03,		1.011427061534289e+03,		1.011945748742752e+03,		1.012462855446524e+03,
		1.012978392239353e+03,		1.013492369606054e+03,		1.014004797924022e+03,		1.014515687464717e+03,		1.015025048395120e+03,
		1.015532890779172e+03,		1.016039224579175e+03,		1.016544059657181e+03,		1.017047405776353e+03,		1.017549272602299e+03,
		1.018049669704389e+03,		1.018548606557046e+03,		1.019046092541018e+03,		1.019542136944626e+03,		1.020036748964990e+03,
		1.020529937709242e+03,		1.021021712195704e+03,		1.021512081355066e+03,		1.022001054031529e+03,		1.022488638983934e+03,
		1.022974844886872e+03,		1.023459680331780e+03,		1.023943153828014e+03,		1.024425273803906e+03,		1.024906048607804e+03,
		1.025385486509095e+03,		1.025863595699213e+03,		1.026340384292628e+03,		1.026815860327824e+03,		1.027290031768253e+03,
		1.027762906503283e+03,		1.028234492349128e+03,		1.028704797049757e+03,		1.029173828277801e+03,		1.029641593635431e+03,
		1.030108100655239e+03,		1.030573356801089e+03,		1.031037369468965e+03,		1.031500145987804e+03,		1.031961693620312e+03,
		1.032422019563775e+03,		1.032881130950852e+03,		1.033339034850351e+03,		1.033795738268010e+03,		1.034251248147246e+03,
		1.034705571369908e+03,		1.035158714757009e+03,		1.035610685069454e+03,		1.036061489008749e+03,		1.036511133217709e+03,
		1.036959624281150e+03,		1.037406968726569e+03,		1.037853173024817e+03,		1.038298243590763e+03,		1.038742186783945e+03,
		1.039185008909213e+03,		1.039626716217364e+03,		1.040067314905765e+03,		1.040506811118968e+03,		1.040945210949321e+03,
		1.041382520437556e+03,		1.041818745573390e+03,		1.042253892296095e+03,		1.042687966495078e+03,		1.043120974010440e+03,
		1.043552920633533e+03,		1.043983812107513e+03,		1.044413654127873e+03,		1.044842452342981e+03,		1.045270212354601e+03,
		1.045696939718418e+03,		1.046122639944542e+03,		1.046547318498013e+03,		1.046970980799299e+03,		1.047393632224786e+03,
		1.047815278107261e+03,		1.048235923736382e+03,		1.048655574359160e+03,		1.049074235180411e+03,		1.049491911363217e+03,
		1.049908608029381e+03,		1.050324330259864e+03,		1.050739083095226e+03,		1.051152871536064e+03,		1.051565700543432e+03,
		1.051977575039266e+03,		1.052388499906796e+03,		1.052798479990960e+03,		1.053207520098808e+03,		1.053615624999896e+03,
		1.054022799426685e+03,		1.054429048074930e+03,		1.054834375604057e+03,		1.055238786637551e+03,		1.055642285763320e+03,
		1.056044877534071e+03,		1.056446566467669e+03,		1.056847357047497e+03,		1.057247253722814e+03,		1.057646260909100e+03,
		1.058044382988402e+03,		1.058441624309680e+03,		1.058837989189136e+03,		1.059233481910550e+03,		1.059628106725612e+03,
		1.060021867854235e+03,		1.060414769484887e+03,		1.060806815774899e+03,		1.061198010850776e+03,		1.061588358808510e+03,
		1.061977863713882e+03,		1.062366529602759e+03,		1.062754360481392e+03,		1.063141360326711e+03,		1.063527533086612e+03,
		1.063912882680241e+03,		1.064297412998277e+03,		1.064681127903215e+03,		1.065064031229630e+03,		1.065446126784463e+03,
		1.065827418347273e+03,		1.066207909670519e+03,		1.066587604479807e+03,		1.066966506474159e+03,		1.067344619326261e+03,
		1.067721946682723e+03,		1.068098492164321e+03,		1.068474259366248e+03,		1.068849251858355e+03,		1.069223473185393e+03,
		1.069596926867249e+03,		1.069969616399183e+03,		1.070341545252058e+03,		1.070712716872571e+03,		1.071083134683478e+03,
		1.071452802083818e+03,		1.071821722449135e+03,		1.072189899131695e+03,		1.072557335460705e+03,		1.072924034742526e+03,
		1.073290000260880e+03,		1.073655235277063e+03,		1.074019743030152e+03,		1.074383526737202e+03,		1.074746589593457e+03,
		1.075108934772540e+03,		1.075470565426657e+03,		1.075831484686789e+03,		1.076191695662880e+03,		1.076551201444038e+03,
		1.076910005098711e+03,		1.077268109674880e+03,		1.077625518200242e+03,		1.077982233682390e+03,		1.078338259108991e+03,
		1.078693597447973e+03,		1.079048251647686e+03,		1.079402224637089e+03,		1.079755519325913e+03,		1.080108138604836e+03,
		1.080460085345648e+03,		1.080811362401421e+03,		1.081161972606665e+03,		1.081511918777501e+03,		1.081861203711816e+03,
		1.082209830189419e+03,		1.082557800972206e+03,		1.082905118804309e+03,		1.083251786412251e+03,		1.083597806505101e+03
	},
	{
		1.645972423080688e+00,		4.979709182454845e+00,		8.366407850834563e+00,		1.180811676113863e+01,		1.530701135064601e+01,
		1.886540472083984e+01,		2.248575930787078e+01,		2.617069980675880e+01,		2.992302751439974e+01,		3.374573628230650e+01,
		3.764203030059705e+01,		4.161534397102422e+01,		4.566936417004105e+01,		4.980805525451350e+01,		5.403568722460355e+01,
		5.835686753288471e+01,		6.277657711885424e+01,		6.730021135735721e+01,		7.193362674270675e+01,		7.668319429338584e+01,
		8.155586086269012e+01,		8.655921978815108e+01,		9.170159261943139e+01,		9.699212404649683e+01,		1.024408926277691e+02,
		1.080590405181297e+02,		1.138589261533419e+02,		1.198543048049218e+02,		1.260605431346554e+02,		1.324948754235758e+02,
		1.391767111180006e+02,		1.461280058380502e+02,		1.533737111647732e+02,		1.609423225035326e+02,		1.688665492361803e+02,
		1.771841372483598e+02,		1.859388805021242e+02,		1.951818646981642e+02,		2.049729897791610e+02,		2.153828132067438e+02,
		2.264947294031047e+02,		2.384074239580558e+02,		2.512373553355030e+02,		2.651206098762976e+02,		2.802126682480111e+02,
		2.966832413444658e+02,		3.147015922614900e+02,		3.344069725966999e+02,		3.558607817380228e+02,		3.789795636088597e+02,
		4.034488935976249e+02,		4.286477850150108e+02,		4.536945875682992e+02,		4.777051351302006e+02,		5.001075380047603e+02,
		5.206075532722161e+02,		5.391486154283567e+02,		5.558367046034545e+02,		5.708582318190205e+02,		5.844229113781280e+02,
		5.967317963835967e+02,		6.079632921103160e+02,		6.182695950653763e+02,		6.277781402255135e+02,		6.365949025202110e+02,
		6.448080002103200e+02,		6.524909652153329e+02,		6.597054940009275e+02,		6.665036819099882e+02,		6.729298094097710e+02,
		6.790217618410322e+02,		6.848121577240704e+02,		6.903292483887194e+02,		6.955976391043752e+02,		7.006388708924744e+02,
		7.054718932547223e+02,		7.101134510305822e+02,		7.145784032047407e+02,		7.188799873884078e+02,		7.230300406013440e+02,
		7.270391846404558e+02,		7.309169825455828e+02,		7.346720713195240e+02,		7.383122750195879e+02,		7.418447015328798e+02,
		7.452758257188374e+02,		7.486115611074109e+02,		7.518573219481090e+02,		7.550180770906899e+02,		7.580983969248579e+02,
		7.611024944009059e+02,		7.640342609857152e+02,		7.668972982712294e+02,		7.696949458393490e+02,		7.724303058937386e+02,
		7.751062650912764e+02,		7.777255139412083e+02,		7.802905640858335e+02,		7.828037637312581e+02,		7.852673114584408e+02,
		7.876832686125503e+02,		7.900535704413762e+02,		7.923800361303611e+02,		7.946643778621558e+02,		7.969082090117772e+02,
		7.991130515741319e+02,		8.012803429083013e+02,		8.034114418725025e+02,		8.055076344144413e+02,		8.075701386739983e+02,
		8.096001096483566e+02,		8.115986434637769e+02,		8.135667812931631e+02,		8.155055129540373e+02,		8.174157802177176e+02,
		8.192984798570399e+02,		8.211544664570356e+02,		8.229845550103198e+02,		8.247895233166865e+02,		8.265701142043381e+02,
		8.283270375884252e+02,		8.300609723809696e+02,		8.317725682648428e+02,		8.334624473432370e+02,		8.351312056749559e+02,
		8.367794147048312e+02,		8.384076225977849e+02,		8.400163554841472e+02,		8.416061186232355e+02,		8.431773974915130e+02,
		8.447306588011305e+02,		8.462663514540669e+02,		8.477849074367098e+02,		8.492867426592603e+02,		8.507722577439786e+02,
		8.522418387659375e+02,		8.536958579496930e+02,		8.551346743249408e+02,		8.565586343440203e+02,		8.579680724639031e+02,
		8.593633116950374e+02,		8.607446641193281e+02,		8.621124313792589e+02,		8.634669051400766e+02,		8.648083675267935e+02,
		8.661370915376032e+02,		8.674533414352472e+02,		8.687573731176891e+02,		8.700494344694172e+02,		8.713297656945410e+02,
		8.725985996328296e+02,		8.738561620597001e+02,		8.751026719711207e+02,		8.763383418543395e+02,		8.775633779452619e+02,
		8.787779804732545e+02,		8.799823438941027e+02,		8.811766571118063e+02,		8.823611036898384e+02,		8.835358620524570e+02,
		8.847011056766364e+02,		8.858570032751231e+02,		8.870037189711013e+02,		8.881414124649407e+02,		8.892702391934262e+02,
		8.903903504818915e+02,		8.915018936896180e+02,		8.926050123488636e+02,		8.936998462978422e+02,		8.947865318079640e+02,
		8.958652017056511e+02,		8.969359854889710e+02,		8.979990094393740e+02,		8.990543967287701e+02,		9.001022675221735e+02,
		9.011427390761339e+02,		9.021759258331663e+02,		9.032019395123583e+02,		9.042208891963564e+02,		9.052328814148894e+02,
		9.062380202249933e+02,		9.072364072881053e+02,		9.082281419441588e+02,		9.092133212828162e+02,		9.101920402119960e+02,
		9.111643915237720e+02,		9.121304659578119e+02,		9.130903522624349e+02,		9.140441372534009e+02,		9.149919058705324e+02,
		9.159337412322728e+02,		9.168697246882595e+02,		9.177999358699965e+02,		9.187244527397187e+02,		9.196433516375212e+02,
		9.205567073268177e+02,		9.214645930382156e+02,		9.223670805118578e+02,		9.232642400383021e+02,		9.241561404980015e+02,
		9.250428493994360e+02,		9.259244329159517e+02,		9.268009559213715e+02,		9.276724820243995e+02,		9.285390736019042e+02,
		9.294007918310878e+02,		9.302576967206165e+02,		9.311098471407273e+02,		9.319573008523739e+02,		9.328001145354249e+02,
		9.336383438159741e+02,		9.344720432927813e+02,		9.353012665628796e+02,		9.361260662463834e+02,		9.369464940105274e+02,
		9.377626005929601e+02,		9.385744358243289e+02,		9.393820486501670e+02,		9.401854871521234e+02,		9.409847985685568e+02,
		9.417800293145032e+02,		9.425712250010613e+02,		9.433584304541963e+02,		9.441416897329913e+02,		9.449210461473735e+02,
		9.456965422753194e+02,		9.464682199795591e+02,		9.472361204238168e+02,		9.480002840885697e+02,		9.487607507863722e+02,
		9.495175596767439e+02,		9.502707492806445e+02,		9.510203574945374e+02,		9.517664216040685e+02,		9.525089782973733e+02,
		9.532480636780085e+02,		9.539837132775421e+02,		9.547159620677930e+02,		9.554448444727509e+02,		9.561703943801676e+02,
		9.568926451528467e+02,		9.576116296396316e+02,		9.583273801861006e+02,		9.590399286449923e+02,		9.597493063863429e+02,
		9.604555443073805e+02,		9.611586728421481e+02,		9.618587219708859e+02,		9.625557212291778e+02,		9.632496997168620e+02,
		9.639406861067146e+02,		9.646287086529237e+02,		9.653137951993392e+02,		9.659959731875324e+02,		9.666752696646449e+02,
		9.673517112910488e+02,		9.680253243478221e+02,		9.686961347440341e+02,		9.693641680238679e+02,		9.700294493735561e+02,
		9.706920036281640e+02,		9.713518552781994e+02,		9.720090284760727e+02,		9.726635470424056e+02,		9.733154344721834e+02,
		9.739647139407740e+02,		9.746114083097985e+02,		9.752555401328702e+02,		9.758971316611991e+02,		9.765362048490730e+02,
		9.771727813592033e+02,		9.778068825679615e+02,		9.784385295704898e+02,		9.790677431856989e+02,		9.796945439611490e+02,
		9.803189521778364e+02,		9.809409878548552e+02,		9.815606707539687e+02,		9.821780203840801e+02,		9.827930560055936e+02,
		9.834057966346987e+02,		9.840162610475445e+02,		9.846244677843374e+02,		9.852304351533396e+02,		9.858341812347907e+02,
		9.864357238847423e+02,		9.870350807388104e+02,		9.876322692158519e+02,		9.882273065215581e+02,		9.888202096519818e+02,
		9.894109953969808e+02,		9.899996803436004e+02,		9.905862808793763e+02,		9.911708131955774e+02,		9.917532932903786e+02,
		9.923337369719674e+02,		9.929121598615927e+02,		9.934885773965474e+02,		9.940630048330917e+02,		9.946354572493190e+02,
		9.952059495479683e+02,		9.957744964591699e+02,		9.963411125431489e+02,		9.969058121928688e+02,		9.974686096366233e+02,
		9.980295189405842e+02,		9.985885540112840e+02,		9.991457285980736e+02,		9.997010562955099e+02,		1.000254550545713e+03,
		1.000806224640670e+03,		1.001356091724500e+03,		1.001904164795670e+03,		1.002450456709176e+03,		1.002994980178681e+03,
		1.003537747778607e+03,		1.004078771946195e+03,		1.004618064983523e+03,		1.005155639059492e+03,		1.005691506211764e+03,
		1.006225678348677e+03,		1.006758167251117e+03,		1.007288984574359e+03,		1.007818141849874e+03,		1.008345650487100e+03,
		1.008871521775187e+03,		1.009395766884706e+03,		1.009918396869334e+03,		1.010439422667494e+03,		1.010958855103986e+03,
		1.011476704891572e+03,		1.011992982632541e+03,		1.012507698820251e+03,		1.013020863840629e+03,		1.013532487973665e+03,
		1.014042581394858e+03,		1.014551154176659e+03,		1.015058216289870e+03,		1.015563777605030e+03,		1.016067847893779e+03,
		1.016570436830184e+03,		1.017071553992064e+03,		1.017571208862276e+03,		1.018069410829980e+03,		1.018566169191897e+03,
		1.019061493153527e+03,		1.019555391830361e+03,		1.020047874249067e+03,		1.020538949348654e+03,		1.021028625981624e+03,
		1.021516912915095e+03,		1.022003818831918e+03,		1.022489352331760e+03,		1.022973521932191e+03,		1.023456336069726e+03,
		1.023937803100876e+03,		1.024417931303165e+03,		1.024896728876137e+03,		1.025374203942348e+03,		1.025850364548339e+03,
		1.026325218665596e+03,		1.026798774191490e+03,		1.027271038950212e+03,		1.027742020693681e+03,		1.028211727102446e+03,
		1.028680165786574e+03,		1.029147344286517e+03,		1.029613270073974e+03,		1.030077950552732e+03,		1.030541393059502e+03,
		1.031003604864738e+03,		1.031464593173439e+03,		1.031924365125945e+03,		1.032382927798720e+03,		1.032840288205123e+03,
		1.033296453296163e+03,		1.033751429961248e+03,		1.034205225028922e+03,		1.034657845267584e+03,		1.035109297386208e+03,
		1.035559588035044e+03,		1.036008723806307e+03,		1.036456711234867e+03,		1.036903556798913e+03,		1.037349266920617e+03,
		1.037793847966794e+03,		1.038237306249535e+03,		1.038679648026846e+03,		1.039120879503271e+03,		1.039561006830509e+03,
		1.040000036108016e+03,		1.040437973383609e+03,		1.040874824654047e+03,		1.041310595865621e+03,		1.041745292914719e+03,
		1.042178921648391e+03,		1.042611487864909e+03,		1.043042997314312e+03,		1.043473455698946e+03,		1.043902868673999e+03,
		1.044331241848026e+03,		1.044758580783463e+03,		1.045184890997147e+03,		1.045610177960806e+03,		1.046034447101569e+03,
		1.046457703802446e+03,		1.046879953402820e+03,		1.047301201198914e+03,		1.047721452444265e+03,		1.048140712350190e+03,
		1.048558986086238e+03,		1.048976278780645e+03,		1.049392595520776e+03,		1.049807941353565e+03,		1.050222321285946e+03,
		1.050635740285282e+03,		1.051048203279787e+03,		1.051459715158938e+03,		1.051870280773886e+03,		1.052279904937865e+03,
		1.052688592426585e+03,		1.053096347978628e+03,		1.053503176295839e+03,		1.053909082043706e+03,		1.054314069851743e+03,
		1.054718144313859e+03,		1.055121309988727e+03,		1.055523571400153e+03,		1.055924933037430e+03,		1.056325399355691e+03,
		1.056724974776269e+03,		1.057123663687029e+03,		1.057521470442719e+03,		1.057918399365302e+03,		1.058314454744289e+03,
		1.058709640837067e+03,		1.059103961869226e+03,		1.059497422034875e+03,		1.059890025496957e+03,		1.060281776387566e+03,
		1.060672678808247e+03,		1.061062736830310e+03,		1.061451954495121e+03,		1.061840335814403e+03,		1.062227884770530e+03,
		1.062614605316810e+03,		1.063000501377778e+03,		1.063385576849473e+03,		1.063769835599720e+03,		1.064153281468400e+03,
		1.064535918267727e+03,		1.064917749782515e+03,		1.065298779770440e+03,		1.065679011962308e+03,		1.066058450062307e+03,
		1.066437097748267e+03,		1.066814958671911e+03,		1.067192036459105e+03,		1.067568334710104e+03,		1.067943856999796e+03,
		1.068318606877941e+03,		1.068692587869414e+03,		1.069065803474429e+03,		1.069438257168785e+03,		1.069809952404086e+03,
		1.070180892607969e+03,		1.070551081184330e+03,		1.070920521513546e+03,		1.071289216952689e+03,		1.071657170835749e+03,
		1.072024386473841e+03,		1.072390867155423e+03,		1.072756616146498e+03,		1.073121636690826e+03,		1.073485932010124e+03,
		1.073849505304267e+03,		1.074212359751495e+03,		1.074574498508598e+03,		1.074935924711123e+03,		1.075296641473556e+03,
		1.075656651889519e+03,		1.076015959031956e+03,		1.076374565953318e+03,		1.076732475685750e+03,		1.077089691241270e+03,
		1.077446215611948e+03,		1.077802051770089e+03,		1.078157202668402e+03,		1.078511671240180e+03,		1.078865460399467e+03,
		1.079218573041231e+03,		1.079571012041530e+03,		1.079922780257680e+03,		1.080273880528420e+03,		1.080624315674071e+03,
		1.080974088496701e+03,		1.081323201780281e+03,		1.081671658290844e+03,		1.082019460776639e+03,		1.082366611968288e+03
	},
	{
		1.642864138383419e+00,		4.970059811079738e+00,		8.349766217387678e+00,		1.178399708759889e+01,		1.527488995603918e+01,
		1.882471633439278e+01,		2.243589294174201e+01,		2.611099412565246e+01,		2.985276562892884e+01,		3.366413988052723e+01,
		3.754825301724960e+01,		4.150846387614315e+01,		4.554837523705798e+01,		4.967185764191040e+01,		5.388307617350561e+01,
		5.818652064433661e+01,		6.258703972715664e+01,		6.708987965751443e+01,		7.170072825787274e+01,		7.642576517846638e+01,
		8.127171942812296e+01,		8.624593548700005e+01,		9.135644956296275e+01,		9.661207788734454e+01,		1.020225193609869e+02,
		1.075984753793136e+02,		1.133517903133004e+02,		1.192956169366185e+02,		1.254446121122943e+02,		1.318151693404480e+02,
		1.384256963901122e+02,		1.452969482735807e+02,		1.524524283609803e+02,		1.599188735627036e+02,		1.677268432814189e+02,
		1.759114362041919e+02,		1.845131636649061e+02,		1.935790123770822e+02,		2.031637306840176e+02,		2.133313663105673e+02,
		2.241570596423975e+02,		2.357290334390393e+02,		2.481505750778815e+02,		2.615415023067673e+02,		2.760380138215677e+02,
		2.917888267380628e+02,		3.089441959924865e+02,		3.276336174657951e+02,		3.479292399436324e+02,		3.697947949203401e+02,
		3.930209504233296e+02,		4.171584845961128e+02,		4.415084633682092e+02,		4.652584671096831e+02,		4.877500337782890e+02,
		5.086054485407267e+02,		5.276606114290014e+02,		5.449330207545323e+02,		5.605487060265449e+02,		5.746821480585370e+02,
		5.875174644900835e+02,		5.992275816121191e+02,		6.099654596705268e+02,		6.198621812666355e+02,		6.290283553047520e+02,
		6.375567698217573e+02,		6.455252492675162e+02,		6.529992684239357e+02,		6.600341793113791e+02,		6.666770438949983e+02,
		6.729681173667718e+02,		6.789420402688004e+02,		6.846287954000082e+02,		6.900544776550939e+02,		6.952419161278215e+02,
		7.002111797260191e+02,		7.049799907529504e+02,		7.095640654574578e+02,		7.139773962905440e+02,		7.182324873191315e+02,
		7.223405517325548e+02,		7.263116784570954e+02,		7.301549734250806e+02,		7.338786799168599e+02,		7.374902815219159e+02,
		7.409965905860713e+02,		7.444038244788323e+02,		7.477176715929066e+02,		7.509433486515328e+02,		7.540856506288887e+02,
		7.571489943700349e+02,		7.601374568188088e+02,		7.630548086161467e+02,		7.659045437112995e+02,		7.686899055290775e+02,
		7.714139101538537e+02,		7.740793669222369e+02,		7.766888967589036e+02,		7.792449485417288e+02,		7.817498137417285e+02,
		7.842056395490641e+02,		7.866144406671908e+02,		7.889781099326586e+02,		7.912984278970234e+02,		7.935770714894319e+02,
		7.958156218630855e+02,		7.980155715157025e+02,		8.001783307627594e+02,		8.023052336325942e+02,		8.043975432440526e+02,
		8.064564567200995e+02,		8.084831096845339e+02,		8.104785803834451e+02,		8.124438934683332e+02,		8.143800234736085e+02,
		8.162878980176209e+02,		8.181684007531193e+02,		8.200223740902976e+02,		8.218506217131276e+02,		8.236539109074681e+02,
		8.254329747176211e+02,		8.271885139462132e+02,		8.289211990108793e+02,		8.306316716698386e+02,		8.323205466272966e+02,
		8.339884130285642e+02,		8.356358358538381e+02,		8.372633572187372e+02,		8.388714975890016e+02,		8.404607569159904e+02,
		8.420316156991223e+02,		8.435845359807861e+02,		8.451199622787922e+02,		8.466383224609890e+02,		8.481400285663050e+02,
		8.496254775760515e+02,		8.510950521390748e+02,		8.525491212540096e+02,		8.539880409116170e+02,		8.554121546999781e+02,
		8.568217943750843e+02,		8.582172803991340e+02,		8.595989224487201e+02,		8.609670198948867e+02,		8.623218622568901e+02,
		8.636637296313661e+02,		8.649928930984872e+02,		8.663096151065512e+02,		8.676141498363634e+02,		8.689067435466663e+02,
		8.701876349017791e+02,		8.714570552825262e+02,		8.727152290814657e+02,		8.739623739833578e+02,		8.751987012317388e+02,
		8.764244158824092e+02,		8.776397170446176e+02,		8.788447981106137e+02,		8.800398469742669e+02,		8.812250462393396e+02,
		8.824005734180097e+02,		8.835666011201766e+02,		8.847232972340622e+02,		8.858708250985701e+02,		8.870093436678555e+02,
		8.881390076685300e+02,		8.892599677498695e+02,		8.903723706274228e+02,		8.914763592203345e+02,		8.925720727827319e+02,
		8.936596470294744e+02,		8.947392142565321e+02,		8.958109034563020e+02,		8.968748404280806e+02,		8.979311478839537e+02,
		8.989799455503198e+02,		9.000213502652688e+02,		9.010554760720055e+02,		9.020824343085214e+02,		9.031023336936803e+02,
		9.041152804099021e+02,		9.051213781825944e+02,		9.061207283564852e+02,		9.071134299690053e+02,		9.080995798208486e+02,
		9.090792725438478e+02,		9.100526006662815e+02,		9.110196546757276e+02,		9.119805230795727e+02,		9.129352924632909e+02,
		9.138840475465749e+02,		9.148268712374246e+02,		9.157638446842745e+02,		9.166950473262563e+02,		9.176205569416554e+02,
		9.185404496946664e+02,		9.194548001804883e+02,		9.203636814688579e+02,		9.212671651460653e+02,		9.221653213555261e+02,
		9.230582188369625e+02,		9.239459249642575e+02,		9.248285057820284e+02,		9.257060260409751e+02,		9.265785492320523e+02,
		9.274461376195150e+02,		9.283088522728732e+02,		9.291667530978026e+02,		9.300198988660652e+02,		9.308683472444504e+02,
		9.317121548228037e+02,		9.325513771411544e+02,		9.333860687159936e+02,		9.342162830657236e+02,		9.350420727353159e+02,
		9.358634893202025e+02,		9.366805834894385e+02,		9.374934050081431e+02,		9.383020027592722e+02,		9.391064247647259e+02,
		9.399067182058224e+02,		9.407029294431601e+02,		9.414951040358961e+02,		9.422832867604491e+02,		9.430675216286553e+02,
		9.438478519054032e+02,		9.446243201257447e+02,		9.453969681115279e+02,		9.461658369875397e+02,		9.469309671972014e+02,
		9.476923985178091e+02,		9.484501700753600e+02,		9.492043203589471e+02,		9.499548872347679e+02,		9.507019079597367e+02,
		9.514454191947291e+02,		9.521854570174622e+02,		9.529220569350211e+02,		9.536552538960540e+02,		9.543850823026346e+02,
		9.551115760218104e+02,		9.558347683968392e+02,		9.565546922581357e+02,		9.572713799339263e+02,		9.579848632606261e+02,
		9.586951735929445e+02,		9.594023418137330e+02,		9.601063983435754e+02,		9.608073731501376e+02,		9.615052957572767e+02,
		9.622001952539182e+02,		9.628921003027127e+02,		9.635810391484717e+02,		9.642670396264024e+02,		9.649501291701216e+02,
		9.656303348194913e+02,		9.663076832282504e+02,		9.669822006714614e+02,		9.676539130527768e+02,		9.683228459115346e+02,
		9.689890244296733e+02,		9.696524734384959e+02,		9.703132174252560e+02,		9.709712805396026e+02,		9.716266865998621e+02,
		9.722794590991841e+02,		9.729296212115310e+02,		9.735771957975395e+02,		9.742222054102399e+02,		9.748646723006460e+02,
		9.755046184232189e+02,		9.761420654412051e+02,		9.767770347318499e+02,		9.774095473915002e+02,		9.780396242405858e+02,
		9.786672858284942e+02,		9.792925524383379e+02,		9.799154440916070e+02,		9.805359805527332e+02,		9.811541813335390e+02,
		9.817700656976052e+02,		9.823836526645288e+02,		9.829949610140962e+02,		9.836040092903701e+02,		9.842108158056791e+02,
		9.848153986445286e+02,		9.854177756674305e+02,		9.860179645146439e+02,		9.866159826098462e+02,		9.872118471637199e+02,
		9.878055751774658e+02,		9.883971834462519e+02,		9.889866885625767e+02,		9.895741069195723e+02,		9.901594547142402e+02,
		9.907427479506146e+02,		9.913240024428686e+02,		9.919032338183542e+02,		9.924804575205781e+02,		9.930556888121222e+02,
		9.936289427775062e+02,		9.942002343259867e+02,		9.947695781943100e+02,		9.953369889494026e+02,		9.959024809910126e+02,
		9.964660685542980e+02,		9.970277657123692e+02,		9.975875863787718e+02,		9.981455443099323e+02,		9.987016531075511e+02,
		9.992559262209501e+02,		9.998083769493741e+02,		1.000359018444255e+03,		1.000907863711421e+03,		1.001454925613282e+03,
		1.002000216870950e+03,		1.002543750066343e+03,		1.003085537644238e+03,		1.003625591914282e+03,		1.004163925052976e+03,
		1.004700549105619e+03,		1.005235475988210e+03,		1.005768717489323e+03,		1.006300285271946e+03,		1.006830190875282e+03,
		1.007358445716524e+03,		1.007885061092594e+03,		1.008410048181851e+03,		1.008933418045768e+03,		1.009455181630585e+03,
		1.009975349768923e+03,		1.010493933181377e+03,		1.011010942478076e+03,		1.011526388160219e+03,		1.012040280621586e+03,
		1.012552630150013e+03,		1.013063446928855e+03,		1.013572741038412e+03,		1.014080522457339e+03,		1.014586801064021e+03,
		1.015091586637942e+03,		1.015594888861010e+03,		1.016096717318874e+03,		1.016597081502218e+03,		1.017095990808019e+03,
		1.017593454540804e+03,		1.018089481913873e+03,		1.018584082050504e+03,		1.019077263985138e+03,		1.019569036664546e+03,
		1.020059408948979e+03,		1.020548389613288e+03,		1.021035987348042e+03,		1.021522210760614e+03,		1.022007068376255e+03,
		1.022490568639153e+03,		1.022972719913467e+03,		1.023453530484354e+03,		1.023933008558974e+03,		1.024411162267473e+03,
		1.024887999663966e+03,		1.025363528727494e+03,		1.025837757362958e+03,		1.026310693402060e+03,		1.026782344604204e+03,
		1.027252718657406e+03,		1.027721823179176e+03,		1.028189665717382e+03,		1.028656253751121e+03,		1.029121594691551e+03,
		1.029585695882728e+03,		1.030048564602429e+03,		1.030510208062947e+03,		1.030970633411896e+03,		1.031429847732985e+03,
		1.031887858046794e+03,		1.032344671311524e+03,		1.032800294423751e+03,		1.033254734219158e+03,		1.033707997473260e+03,
		1.034160090902118e+03,		1.034611021163040e+03,		1.035060794855275e+03,		1.035509418520695e+03,		1.035956898644467e+03,
		1.036403241655714e+03,		1.036848453928169e+03,		1.037292541780819e+03,		1.037735511478533e+03,		1.038177369232692e+03,
		1.038618121201802e+03,		1.039057773492099e+03,		1.039496332158151e+03,		1.039933803203440e+03,		1.040370192580950e+03,
		1.040805506193733e+03,		1.041239749895476e+03,		1.041672929491056e+03,		1.042105050737092e+03,		1.042536119342478e+03,
		1.042966140968922e+03,		1.043395121231471e+03,		1.043823065699022e+03,		1.044249979894844e+03,		1.044675869297072e+03,
		1.045100739339208e+03,		1.045524595410609e+03,		1.045947442856973e+03,		1.046369286980811e+03,		1.046790133041922e+03,
		1.047209986257851e+03,		1.047628851804348e+03,		1.048046734815820e+03,		1.048463640385778e+03,		1.048879573567269e+03,
		1.049294539373312e+03,		1.049708542777330e+03,		1.050121588713563e+03,		1.050533682077488e+03,		1.050944827726229e+03,
		1.051355030478961e+03,		1.051764295117308e+03,		1.052172626385741e+03,		1.052580028991959e+03,		1.052986507607284e+03,
		1.053392066867027e+03,		1.053796711370873e+03,		1.054200445683239e+03,		1.054603274333649e+03,		1.055005201817085e+03,
		1.055406232594345e+03,		1.055806371092393e+03,		1.056205621704700e+03,		1.056603988791597e+03,		1.057001476680594e+03,
		1.057398089666731e+03,		1.057793832012891e+03,		1.058188707950134e+03,		1.058582721678011e+03,		1.058975877364883e+03,
		1.059368179148233e+03,		1.059759631134970e+03,		1.060150237401738e+03,		1.060540001995215e+03,		1.060928928932406e+03,
		1.061317022200943e+03,		1.061704285759365e+03,		1.062090723537411e+03,		1.062476339436300e+03,		1.062861137329009e+03,
		1.063245121060547e+03,		1.063628294448230e+03,		1.064010661281948e+03,		1.064392225324428e+03,		1.064772990311500e+03,
		1.065152959952354e+03,		1.065532137929795e+03,		1.065910527900495e+03,		1.066288133495246e+03,		1.066664958319205e+03,
		1.067041005952134e+03,		1.067416279948648e+03,		1.067790783838443e+03,		1.068164521126543e+03,		1.068537495293522e+03,
		1.068909709795739e+03,		1.069281168065561e+03,		1.069651873511594e+03,		1.070021829518894e+03,		1.070391039449196e+03,
		1.070759506641125e+03,		1.071127234410410e+03,		1.071494226050097e+03,		1.071860484830756e+03,		1.072226014000691e+03,
		1.072590816786139e+03,		1.072954896391475e+03,		1.073318255999412e+03,		1.073680898771194e+03,		1.074042827846796e+03,
		1.074404046345116e+03,		1.074764557364158e+03,		1.075124363981231e+03,		1.075483469253130e+03,		1.075841876216316e+03,
		1.076199587887108e+03,		1.076556607261852e+03,		1.076912937317108e+03,		1.077268581009819e+03,		1.077623541277490e+03,
		1.077977821038355e+03,		1.078331423191554e+03,		1.078684350617294e+03,		1.079036606177020e+03,		1.079388192713578e+03,
		1.079739113051376e+03,		1.080089369996548e+03,		1.080438966337113e+03,		1.080787904843128e+03,		1.081136188266851e+03
	},
	{
		1.639767727265973e+00,		4.960449246711935e+00,		8.333195003898444e+00,		1.175998474797471e+01,		1.524291881994512e+01,
		1.878422795353395e+01,		2.238628408139719e+01,		2.605161227273745e+01,		2.978290394713920e+01,		3.358303153144483e+01,
		3.745506475237631e+01,		4.140228878815152e+01,		4.542822453850469e+01,		4.953665131547037e+01,		5.373163230847801e+01,
		5.801754323852202e+01,		6.239910468964328e+01,		6.688141869445501e+01,		7.147001025743032e+01,		7.617087462947991e+01,
		8.099053130544031e+01,		8.593608590933404e+01,		9.101530136932507e+01,		9.623668007613172e+01,		1.016095590791295e+02,
		1.071442208209772e+02,		1.128520224663758e+02,		1.187455475711462e+02,		1.248387846984838e+02,		1.311473386618946e+02,
		1.376886814087605e+02,		1.444824512110972e+02,		1.515508108589188e+02,		1.589188780035396e+02,		1.666152436799561e+02,
		1.746725982541746e+02,		1.831284872684519e+02,		1.920262220798131e+02,		2.014159699722132e+02,		2.113560416656254e+02,
		2.219143727989355e+02,		2.331701439173373e+02,		2.452153697256986e+02,		2.581560571176227e+02,		2.721120960647672e+02,
		2.872143175098158e+02,		3.035961737350951e+02,		3.213767785107731e+02,		3.406327055861598e+02,		3.613583304661732e+02,
		3.834162839076627e+02,		4.064831892879305e+02,		4.300196291260770e+02,		4.533294186823504e+02,		4.757363081647632e+02,
		4.967863206350926e+02,		5.162313520011755e+02,		5.340019955251647e+02,		5.501582290588746e+02,		5.648310750831236e+02,
		5.781797467148092e+02,		5.903653521368612e+02,		6.015372072810468e+02,		6.118272730111033e+02,		6.213491867974485e+02,
		6.301995386366169e+02,		6.384600101564619e+02,		6.461996584892413e+02,		6.534770221818350e+02,		6.603419366820365e+02,
		6.668370468489239e+02,		6.729990452474470e+02,		6.788596778488928e+02,		6.844465589549296e+02,		6.897838324098191e+02,
		6.948927100438667e+02,		6.997919123565928e+02,		7.044980312895444e+02,		7.090258306964765e+02,		7.133884967386218e+02,
		7.175978477884466e+02,		7.216645113772827e+02,		7.255980741423174e+02,		7.294072095098785e+02,		7.330997869088368e+02,
		7.366829655745209e+02,		7.401632754290889e+02,		7.435466870712836e+02,		7.468386725482226e+02,		7.500442582934809e+02,
		7.531680713828231e+02,		7.562143800699366e+02,		7.591871294098554e+02,		7.620899726506822e+02,		7.649262989692306e+02,
		7.676992580389750e+02,		7.704117818460113e+02,		7.730666041079485e+02,		7.756662775994970e+02,		7.782131896455775e+02,
		7.807095760063326e+02,		7.831575333476659e+02,		7.855590304647494e+02,		7.879159184036415e+02,		7.902299396071173e+02,
		7.925027361945587e+02,		7.947358574717214e+02,		7.969307667542515e+02,		7.990888475784095e+02,		8.012114093635747e+02,
		8.032996925833349e+02,		8.053548734952753e+02,		8.073780684737600e+02,		8.093703379849048e+02,		8.113326902385511e+02,
		8.132660845481323e+02,		8.151714344259884e+02,		8.170496104386706e+02,		8.189014428441899e+02,		8.207277240308520e+02,
		8.225292107752805e+02,		8.243066263354599e+02,		8.260606623930116e+02,		8.277919808575299e+02,		8.295012155445335e+02,
		8.311889737374900e+02,		8.328558376433587e+02,		8.345023657502318e+02,		8.361290940948317e+02,		8.377365374469515e+02,
		8.393251904172403e+02,		8.408955284942074e+02,		8.424480090157688e+02,		8.439830720802358e+02,		8.455011414011691e+02,
		8.470026251102134e+02,		8.484879165116209e+02,		8.499573947919260e+02,		8.514114256878793e+02,		8.528503621155768e+02,
		8.542745447634189e+02,		8.556843026513641e+02,		8.570799536587404e+02,		8.584618050226953e+02,		8.598301538092188e+02,
		8.611852873585098e+02,		8.625274837063562e+02,		8.638570119830260e+02,		8.651741327911191e+02,		8.664790985636556e+02,
		8.677721539036497e+02,		8.690535359062864e+02,		8.703234744647532e+02,		8.715821925607070e+02,		8.728299065403049e+02,
		8.740668263766100e+02,		8.752931559192044e+02,		8.765090931317277e+02,		8.777148303180293e+02,		8.789105543375944e+02,
		8.800964468108263e+02,		8.812726843147681e+02,		8.824394385697749e+02,		8.835968766176414e+02,		8.847451609916480e+02,
		8.858844498789470e+02,		8.870148972757183e+02,		8.881366531354514e+02,		8.892498635107388e+02,		8.903546706888925e+02,
		8.914512133217264e+02,		8.925396265497814e+02,		8.936200421212900e+02,		8.946925885061327e+02,		8.957573910050507e+02,
		8.968145718543333e+02,		8.978642503262056e+02,		8.989065428251440e+02,		8.999415629802891e+02,		9.009694217341585e+02,
		9.019902274278373e+02,		9.030040858828022e+02,		9.040111004795441e+02,		9.050113722331449e+02,		9.060049998659237e+02,
		9.069920798773215e+02,		9.079727066111251e+02,		9.089469723201474e+02,		9.099149672285134e+02,		9.108767795916066e+02,
		9.118324957538189e+02,		9.127822002041902e+02,		9.137259756300176e+02,		9.146639029685394e+02,		9.155960614567613e+02,
		9.165225286795162e+02,		9.174433806158254e+02,		9.183586916836340e+02,		9.192685347829907e+02,		9.201729813377324e+02,
		9.210721013357399e+02,		9.219659633678197e+02,		9.228546346652693e+02,		9.237381811361811e+02,		9.246166674005271e+02,
		9.254901568240887e+02,		9.263587115512602e+02,		9.272223925367784e+02,		9.280812595764305e+02,		9.289353713367510e+02,
		9.297847853837834e+02,		9.306295582109140e+02,		9.314697452658253e+02,		9.323054009766016e+02,		9.331365787770194e+02,
		9.339633311310483e+02,		9.347857095565943e+02,		9.356037646485197e+02,		9.364175461009517e+02,		9.372271027289258e+02,
		9.380324824893654e+02,		9.388337325014405e+02,		9.396308990663185e+02,		9.404240276863312e+02,		9.412131630835720e+02,
		9.419983492179620e+02,		9.427796293047771e+02,		9.435570458316803e+02,		9.443306405752555e+02,		9.451004546170809e+02,
		9.458665283593269e+02,		9.466289015399390e+02,		9.473876132473739e+02,		9.481427019349359e+02,		9.488942054347095e+02,
		9.496421609711130e+02,		9.503866051740799e+02,		9.511275740918733e+02,		9.518651032035656e+02,		9.525992274311693e+02,
		9.533299811514522e+02,		9.540573982074320e+02,		9.547815119195679e+02,		9.555023550966592e+02,		9.562199600464519e+02,
		9.569343585859754e+02,		9.576455820516089e+02,		9.583536613088838e+02,		9.590586267620431e+02,		9.597605083633496e+02,
		9.604593356221592e+02,		9.611551376137663e+02,		9.618479429880276e+02,		9.625377799777679e+02,		9.632246764069782e+02,
		9.639086596988118e+02,		9.645897568833836e+02,		9.652679946053726e+02,		9.659433991314534e+02,		9.666159963575266e+02,
		9.672858118157988e+02,		9.679528706816709e+02,		9.686171977804756e+02,		9.692788175940517e+02,		9.699377542671608e+02,
		9.705940316137512e+02,		9.712476731230870e+02,		9.718987019657169e+02,		9.725471409993165e+02,		9.731930127743954e+02,
		9.738363395398675e+02,		9.744771432484994e+02,		9.751154455622298e+02,		9.757512678573759e+02,		9.763846312297163e+02,
		9.770155564994583e+02,		9.776440642161031e+02,		9.782701746631963e+02,		9.788939078629729e+02,		9.795152835809046e+02,
		9.801343213301412e+02,		9.807510403758646e+02,		9.813654597395374e+02,		9.819775982030679e+02,		9.825874743128808e+02,
		9.831951063839044e+02,		9.838005125034687e+02,		9.844037105351257e+02,		9.850047181223832e+02,		9.856035526923662e+02,
		9.862002314593971e+02,		9.867947714285029e+02,		9.873871893988503e+02,		9.879775019671057e+02,		9.885657255307362e+02,
		9.891518762912289e+02,		9.897359702572568e+02,		9.903180232477725e+02,		9.908980508950435e+02,		9.914760686476260e+02,
		9.920520917732746e+02,		9.926261353618036e+02,		9.931982143278776e+02,		9.937683434137600e+02,		9.943365371920027e+02,
		9.949028100680741e+02,		9.954671762829545e+02,		9.960296499156608e+02,		9.965902448857370e+02,		9.971489749556901e+02,
		9.977058537333781e+02,		9.982608946743562e+02,		9.988141110841750e+02,		9.993655161206377e+02,		9.999151227960122e+02,
		1.000462943979201e+03,		1.001008992397878e+03,		1.001553280640566e+03,		1.002095821158705e+03,		1.002636626268653e+03,
		1.003175708153667e+03,		1.003713078865845e+03,		1.004248750328026e+03,		1.004782734335661e+03,		1.005315042558651e+03,
		1.005845686543147e+03,		1.006374677713319e+03,		1.006902027373093e+03,		1.007427746707861e+03,		1.007951846786156e+03,
		1.008474338561295e+03,		1.008995232872998e+03,		1.009514540448981e+03,		1.010032271906508e+03,		1.010548437753931e+03,
		1.011063048392191e+03,		1.011576114116304e+03,		1.012087645116812e+03,		1.012597651481208e+03,		1.013106143195353e+03,
		1.013613130144841e+03,		1.014118622116371e+03,		1.014622628799067e+03,		1.015125159785801e+03,		1.015626224574473e+03,
		1.016125832569285e+03,		1.016623993081983e+03,		1.017120715333082e+03,		1.017616008453075e+03,		1.018109881483611e+03,
		1.018602343378667e+03,		1.019093403005688e+03,		1.019583069146719e+03,		1.020071350499508e+03,		1.020558255678603e+03,
		1.021043793216417e+03,		1.021527971564292e+03,		1.022010799093527e+03,		1.022492284096410e+03,		1.022972434787216e+03,
		1.023451259303197e+03,		1.023928765705557e+03,		1.024404961980409e+03,		1.024879856039717e+03,		1.025353455722224e+03,
		1.025825768794367e+03,		1.026296802951168e+03,		1.026766565817131e+03,		1.027235064947102e+03,		1.027702307827132e+03,
		1.028168301875321e+03,		1.028633054442645e+03,		1.029096572813776e+03,		1.029558864207893e+03,		1.030019935779468e+03,
		1.030479794619048e+03,		1.030938447754032e+03,		1.031395902149418e+03,		1.031852164708557e+03,		1.032307242273887e+03,
		1.032761141627652e+03,		1.033213869492621e+03,		1.033665432532791e+03,		1.034115837354072e+03,		1.034565090504977e+03,
		1.035013198477288e+03,		1.035460167706722e+03,		1.035906004573581e+03,		1.036350715403395e+03,		1.036794306467556e+03,
		1.037236783983941e+03,		1.037678154117527e+03,		1.038118422981000e+03,		1.038557596635347e+03,		1.038995681090450e+03,
		1.039432682305664e+03,		1.039868606190389e+03,		1.040303458604635e+03,		1.040737245359576e+03,		1.041169972218101e+03,
		1.041601644895352e+03,		1.042032269059255e+03,		1.042461850331054e+03,		1.042890394285814e+03,		1.043317906452947e+03,
		1.043744392316706e+03,		1.044169857316684e+03,		1.044594306848305e+03,		1.045017746263306e+03,		1.045440180870213e+03,
		1.045861615934809e+03,		1.046282056680605e+03,		1.046701508289286e+03,		1.047119975901170e+03,		1.047537464615648e+03,
		1.047953979491628e+03,		1.048369525547963e+03,		1.048784107763878e+03,		1.049197731079394e+03,		1.049610400395743e+03,
		1.050022120575778e+03,		1.050432896444374e+03,		1.050842732788833e+03,		1.051251634359276e+03,		1.051659605869028e+03,
		1.052066651995007e+03,		1.052472777378102e+03,		1.052877986623540e+03,		1.053282284301266e+03,		1.053685674946296e+03,
		1.054088163059085e+03,		1.054489753105875e+03,		1.054890449519051e+03,		1.055290256697481e+03,		1.055689179006861e+03,
		1.056087220780048e+03,		1.056484386317400e+03,		1.056880679887095e+03,		1.057276105725461e+03,		1.057670668037294e+03,
		1.058064370996173e+03,		1.058457218744775e+03,		1.058849215395181e+03,		1.059240365029177e+03,		1.059630671698563e+03,
		1.060020139425440e+03,		1.060408772202510e+03,		1.060796573993360e+03,		1.061183548732753e+03,		1.061569700326906e+03,
		1.061955032653770e+03,		1.062339549563305e+03,		1.062723254877755e+03,		1.063106152391911e+03,		1.063488245873382e+03,
		1.063869539062850e+03,		1.064250035674341e+03,		1.064629739395466e+03,		1.065008653887684e+03,		1.065386782786549e+03,
		1.065764129701955e+03,		1.066140698218383e+03,		1.066516491895137e+03,		1.066891514266589e+03,		1.067265768842404e+03,
		1.067639259107785e+03,		1.068011988523691e+03,		1.068383960527069e+03,		1.068755178531082e+03,		1.069125645925322e+03,
		1.069495366076036e+03,		1.069864342326340e+03,		1.070232577996431e+03,		1.070600076383804e+03,		1.070966840763452e+03,
		1.071332874388082e+03,		1.071698180488314e+03,		1.072062762272884e+03,		1.072426622928842e+03,		1.072789765621751e+03,
		1.073152193495883e+03,		1.073513909674409e+03,		1.073874917259590e+03,		1.074235219332970e+03,		1.074594818955551e+03,
		1.074953719167993e+03,		1.075311922990781e+03,		1.075669433424416e+03,		1.076026253449587e+03,		1.076382386027348e+03,
		1.076737834099293e+03,		1.077092600587729e+03,		1.077446688395844e+03,		1.077800100407877e+03,		1.078152839489282e+03,
		1.078504908486897e+03,		1.078856310229103e+03,		1.079207047525984e+03,		1.079557123169492e+03,		1.079906539933600e+03
	},
	{
		1.636683120531809e+00,		4.950877243326344e+00,		8.316693727598599e+00,		1.173607895038554e+01,		1.521109675403731e+01,
		1.874393788815298e+01,		2.233693040790996e+01,		2.599255114705377e+01,		2.971343840115181e+01,		3.350240597699733e+01,
		3.736245878784869e+01,		4.129681020219770e+01,		4.530890138682360e+01,		4.940242292404321e+01,		5.358133902958303e+01,
		5.784991475294042e+01,		6.221274660840432e+01,		6.667479716446447e+01,		7.124143421512875e+01,		7.591847527239584e+01,
		8.071223825942025e+01,		8.562959945453707e+01,		9.067805994452054e+01,		9.586582210028755e+01,		1.012018779010526e+02,
		1.066961113178240e+02,		1.123594174416526e+02,		1.182038416278200e+02,		1.242427426504427e+02,		1.304909847539784e+02,
		1.369651645845361e+02,		1.436838803227341e+02,		1.506680519558113e+02,		1.579413035384833e+02,		1.655304204757166e+02,
		1.734658971958004e+02,		1.817825927450039e+02,		1.905205130879323e+02,		1.997257376775051e+02,		2.094515009813481e+02,
		2.197594207991818e+02,		2.307208221532393e+02,		2.424180154612842e+02,		2.549452106867093e+02,		2.684084241814438e+02,
		2.829231969237949e+02,		2.986082096998499e+02,		3.155722677343969e+02,		3.338924243303236e+02,		3.535828188179632e+02,
		3.745558680791682e+02,		3.965791420678612e+02,		4.192418228254048e+02,		4.419709443670734e+02,		4.641372500645405e+02,
		4.852271843050319e+02,		5.049319620288177e+02,		5.231032008988773e+02,		5.397331128266123e+02,		5.549036984218836e+02,
		5.687426703359387e+02,		5.813932763842149e+02,		5.929964356367328e+02,		6.036816482137488e+02,		6.135634339913728e+02,
		6.227409018376354e+02,		6.312988708666393e+02,		6.393096029580782e+02,		6.468346421465052e+02,		6.539265237938506e+02,
		6.606302643891213e+02,		6.669846169551730e+02,		6.730231099967915e+02,		6.787748996773973e+02,		6.842654665498715e+02,
		6.895171854581773e+02,		6.945497930305846e+02,		6.993807728442883e+02,		7.040256744247389e+02,		7.084983789390715e+02,
		7.128113217594018e+02,		7.169756799398141e+02,		7.210015309791324e+02,		7.248979879384783e+02,		7.286733149687701e+02,
		7.323350265130449e+02,		7.358899728299368e+02,		7.393444139976306e+02,		7.427040841716361e+02,		7.459742475615446e+02,
		7.491597473440755e+02,		7.522650485289904e+02,		7.552942756307064e+02,		7.582512458641243e+02,		7.611394984724147e+02,
		7.639623207024850e+02,		7.667227708672887e+02,		7.694236988701067e+02,		7.720677645119951e+02,		7.746574538583490e+02,
		7.771950939020680e+02,		7.796828657284306e+02,		7.821228163589931e+02,		7.845168694284151e+02,		7.868668348278818e+02,
		7.891744174315860e+02,		7.914412250079574e+02,		7.936687754045712e+02,		7.958585030846888e+02,		7.980117650839472e+02,
		8.001298464474291e+02,		8.022139652003253e+02,		8.042652768991264e+02,		8.062848788049400e+02,		8.082738137158294e+02,
		8.102330734909278e+02,		8.121636022955188e+02,		8.140662995930913e+02,		8.159420229076146e+02,		8.177915903768255e+02,
		8.196157831151688e+02,		8.214153474031068e+02,		8.231909967178689e+02,		8.249434136191705e+02,		8.266732515021112e+02,
		8.283811362283117e+02,		8.300676676452497e+02,		8.317334210028479e+02,		8.333789482754979e+02,		8.350047793969957e+02,
		8.366114234151228e+02,		8.381993695720832e+02,		8.397690883163763e+02,		8.413210322512692e+02,		8.428556370245376e+02,
		8.443733221637783e+02,		8.458744918612189e+02,		8.473595357116245e+02,		8.488288294066117e+02,		8.502827353884093e+02,
		8.517216034658627e+02,		8.531457713952544e+02,		8.545555654283002e+02,		8.559513008295352e+02,		8.573332823650856e+02,
		8.587018047647020e+02,		8.600571531587797e+02,		8.613996034919712e+02,		8.627294229148542e+02,		8.640468701550554e+02,
		8.653521958690666e+02,		8.666456429759813e+02,		8.679274469742138e+02,		8.691978362422388e+02,		8.704570323243156e+02,
		8.717052502020568e+02,		8.729426985526941e+02,		8.741695799947969e+02,		8.753860913221669e+02,		8.765924237265882e+02,
		8.777887630100505e+02,		8.789752897870397e+02,		8.801521796774399e+02,		8.813196034905748e+02,		8.824777274008518e+02,
		8.836267131154804e+02,		8.847667180346706e+02,		8.858978954047235e+02,		8.870203944643836e+02,		8.881343605848040e+02,
		8.892399354034478e+02,		8.903372569522473e+02,		8.914264597803121e+02,		8.925076750714469e+02,		8.935810307567580e+02,
		8.946466516225810e+02,		8.957046594139597e+02,		8.967551729338968e+02,		8.977983081385847e+02,		8.988341782288003e+02,
		8.998628937376559e+02,		9.008845626148754e+02,		9.018992903077533e+02,		9.029071798389687e+02,		9.039083318813758e+02,
		9.049028448299287e+02,		9.058908148708655e+02,		9.068723360482733e+02,		9.078475003281502e+02,		9.088163976600907e+02,
		9.097791160366775e+02,		9.107357415506959e+02,		9.116863584502644e+02,		9.126310491919688e+02,		9.135698944920791e+02,
		9.145029733759544e+02,		9.154303632256808e+02,		9.163521398260450e+02,		9.172683774088911e+02,		9.181791486959509e+02,
		9.190845249401866e+02,		9.199845759657267e+02,		9.208793702064424e+02,		9.217689747432163e+02,		9.226534553399738e+02,
		9.235328764784988e+02,		9.244073013921128e+02,		9.252767920982374e+02,		9.261414094298938e+02,		9.270012130661891e+02,
		9.278562615618096e+02,		9.287066123755792e+02,		9.295523218980999e+02,		9.303934454785334e+02,		9.312300374505173e+02,
		9.320621511573057e+02,		9.328898389760984e+02,		9.337131523416413e+02,		9.345321417690952e+02,		9.353468568762122e+02,
		9.361573464048399e+02,		9.369636582417783e+02,		9.377658394390153e+02,		9.385639362333621e+02,		9.393579940655084e+02,
		9.401480575985158e+02,		9.409341707357768e+02,		9.417163766384504e+02,		9.424947177423954e+02,		9.432692357746179e+02,
		9.440399717692542e+02,		9.448069660830980e+02,		9.455702584106886e+02,		9.463298877989830e+02,		9.470858926616137e+02,
		9.478383107927555e+02,		9.485871793806110e+02,		9.493325350205225e+02,		9.500744137277369e+02,		9.508128509498135e+02,
		9.515478815787070e+02,		9.522795399625242e+02,		9.530078599169666e+02,		9.537328747364734e+02,		9.544546172050685e+02,
		9.551731196069263e+02,		9.558884137366589e+02,		9.566005309093392e+02,		9.573095019702702e+02,		9.580153573044934e+02,
		9.587181268460654e+02,		9.594178400870961e+02,		9.601145260865530e+02,		9.608082134788594e+02,		9.614989304822581e+02,
		9.621867049069839e+02,		9.628715641632324e+02,		9.635535352689195e+02,		9.642326448572693e+02,		9.649089191842069e+02,
		9.655823841355741e+02,		9.662530652341725e+02,		9.669209876466373e+02,		9.675861761901471e+02,		9.682486553389772e+02,
		9.689084492308929e+02,		9.695655816733995e+02,		9.702200761498394e+02,		9.708719558253533e+02,		9.715212435526981e+02,
		9.721679618779353e+02,		9.728121330459895e+02,		9.734537790060732e+02,		9.740929214169971e+02,		9.747295816523550e+02,
		9.753637808055950e+02,		9.759955396949728e+02,		9.766248788684026e+02,		9.772518186081920e+02,		9.778763789356764e+02,
		9.784985796157538e+02,		9.791184401613149e+02,		9.797359798375808e+02,		9.803512176663476e+02,		9.809641724301354e+02,
		9.815748626762487e+02,		9.821833067207571e+02,		9.827895226523807e+02,		9.833935283363010e+02,		9.839953414178884e+02,
		9.845949793263513e+02,		9.851924592783097e+02,		9.857877982812934e+02,		9.863810131371711e+02,		9.869721204455019e+02,
		9.875611366068249e+02,		9.881480778258801e+02,		9.887329601147595e+02,		9.893157992959951e+02,		9.898966110055951e+02,
		9.904754106960000e+02,		9.910522136389983e+02,		9.916270349285699e+02,		9.921998894836827e+02,		9.927707920510286e+02,
		9.933397572077064e+02,		9.939067993638542e+02,		9.944719327652288e+02,		9.950351714957333e+02,		9.955965294798995e+02,
		9.961560204853199e+02,		9.967136581250318e+02,		9.972694558598606e+02,		9.978234270007122e+02,		9.983755847108271e+02,
		9.989259420079870e+02,		9.994745117666871e+02,		1.000021306720258e+03,		1.000566339462956e+03,		1.001109622452010e+03,
		1.001651168009634e+03,		1.002190988325001e+03,		1.002729095456171e+03,		1.003265501332007e+03,		1.003800217754031e+03,
		1.004333256398261e+03,		1.004864628817008e+03,		1.005394346440647e+03,		1.005922420579349e+03,		1.006448862424787e+03,
		1.006973683051809e+03,		1.007496893420080e+03,		1.008018504375704e+03,		1.008538526652801e+03,		1.009056970875073e+03,
		1.009573847557330e+03,		1.010089167107000e+03,		1.010602939825600e+03,		1.011115175910199e+03,		1.011625885454833e+03,
		1.012135078451918e+03,		1.012642764793627e+03,		1.013148954273240e+03,		1.013653656586484e+03,		1.014156881332838e+03,
		1.014658638016822e+03,		1.015158936049263e+03,		1.015657784748540e+03,		1.016155193341808e+03,		1.016651170966199e+03,
		1.017145726670011e+03,		1.017638869413866e+03,		1.018130608071858e+03,		1.018620951432680e+03,		1.019109908200729e+03,
		1.019597486997195e+03,		1.020083696361137e+03,		1.020568544750530e+03,		1.021052040543313e+03,		1.021534192038398e+03,
		1.022015007456683e+03,		1.022494494942034e+03,		1.022972662562264e+03,		1.023449518310082e+03,		1.023925070104043e+03,
		1.024399325789469e+03,		1.024872293139363e+03,		1.025343979855311e+03,		1.025814393568358e+03,		1.026283541839886e+03,
		1.026751432162466e+03,		1.027218071960706e+03,		1.027683468592075e+03,		1.028147629347727e+03,		1.028610561453303e+03,
		1.029072272069726e+03,		1.029532768293976e+03,		1.029992057159869e+03,		1.030450145638807e+03,		1.030907040640522e+03,
		1.031362749013821e+03,		1.031817277547297e+03,		1.032270632970051e+03,		1.032722821952392e+03,		1.033173851106526e+03,
		1.033623726987240e+03,		1.034072456092576e+03,		1.034520044864486e+03,		1.034966499689489e+03,		1.035411826899316e+03,
		1.035856032771533e+03,		1.036299123530176e+03,		1.036741105346359e+03,		1.037181984338882e+03,		1.037621766574829e+03,
		1.038060458070155e+03,		1.038498064790268e+03,		1.038934592650599e+03,		1.039370047517165e+03,		1.039804435207131e+03,
		1.040237761489349e+03,		1.040670032084906e+03,		1.041101252667650e+03,		1.041531428864720e+03,		1.041960566257062e+03,
		1.042388670379940e+03,		1.042815746723440e+03,		1.043241800732962e+03,		1.043666837809718e+03,		1.044090863311207e+03,
		1.044513882551695e+03,		1.044935900802685e+03,		1.045356923293380e+03,		1.045776955211135e+03,		1.046196001701919e+03,
		1.046614067870749e+03,		1.047031158782132e+03,		1.047447279460499e+03,		1.047862434890631e+03,		1.048276630018084e+03,
		1.048689869749596e+03,		1.049102158953505e+03,		1.049513502460151e+03,		1.049923905062273e+03,		1.050333371515406e+03,
		1.050741906538270e+03,		1.051149514813151e+03,		1.051556200986282e+03,		1.051961969668215e+03,		1.052366825434192e+03,
		1.052770772824507e+03,		1.053173816344865e+03,		1.053575960466740e+03,		1.053977209627720e+03,		1.054377568231858e+03,
		1.054777040650009e+03,		1.055175631220170e+03,		1.055573344247808e+03,		1.055970184006196e+03,		1.056366154736729e+03,
		1.056761260649245e+03,		1.057155505922349e+03,		1.057548894703715e+03,		1.057941431110400e+03,		1.058333119229147e+03,
		1.058723963116684e+03,		1.059113966800023e+03,		1.059503134276750e+03,		1.059891469515318e+03,		1.060278976455328e+03,
		1.060665659007818e+03,		1.061051521055535e+03,		1.061436566453215e+03,		1.061820799027851e+03,		1.062204222578966e+03,
		1.062586840878876e+03,		1.062968657672952e+03,		1.063349676679880e+03,		1.063729901591916e+03,		1.064109336075139e+03,
		1.064487983769703e+03,		1.064865848290079e+03,		1.065242933225302e+03,		1.065619242139214e+03,		1.065994778570697e+03,
		1.066369546033910e+03,		1.066743548018525e+03,		1.067116787989951e+03,		1.067489269389568e+03,		1.067860995634940e+03,
		1.068231970120050e+03,		1.068602196215510e+03,		1.068971677268779e+03,		1.069340416604383e+03,		1.069708417524117e+03,
		1.070075683307261e+03,		1.070442217210784e+03,		1.070808022469549e+03,		1.071173102296515e+03,		1.071537459882934e+03,
		1.071901098398554e+03,		1.072264020991808e+03,		1.072626230790011e+03,		1.072987730899546e+03,		1.073348524406060e+03,
		1.073708614374643e+03,		1.074068003850015e+03,		1.074426695856709e+03,		1.074784693399252e+03,		1.075141999462336e+03,
		1.075498617011006e+03,		1.075854548990824e+03,		1.076209798328046e+03,		1.076564367929789e+03,		1.076918260684205e+03,
		1.077271479460642e+03,		1.077624027109811e+03,		1.077975906463949e+03,		1.078327120336978e+03,		1.078677671524669e+03
	},
	{
		1.633610249534893e+00,		4.941343557105267e+00,		8.300261910513417e+00,		1.171227891154165e+01,		1.517942258394791e+01,
		1.870384446949469e+01,		2.228782963371797e+01,		2.593380769237053e+01,		2.964436498548767e+01,		3.342225804471216e+01,
		3.727042852138736e+01,		4.119201976859883e+01,		4.519039530056246e+01,		4.926915938843321e+01,		5.343218009385757e+01,
		5.768361509177964e+01,		6.202794069381360e+01,		6.646998455498186e+01,		7.101496263234031e+01,		7.566852106712682e+01,
		8.043678378648767e+01,		8.532640677141030e+01,		9.034464012023476e+01,		9.549939925948651e+01,		1.007993469249906e+02,
		1.062539878676400e+02,		1.118737786436757e+02,		1.176702553456550e+02,		1.236561827373051e+02,		1.298457289960107e+02,
		1.362546711656029e+02,		1.429006375036185e+02,		1.498033941890336e+02,		1.569851853378627e+02,		1.644711369116171e+02,
		1.722897367651940e+02,		1.804734044560932e+02,		1.890591648682477e+02,		1.980894378652623e+02,		2.076129494827707e+02,
		2.176857536198647e+02,		2.283723174630305e+02,		2.397465520574150e+02,		2.518925326930705e+02,		2.649044087889416e+02,
		2.788846028836803e+02,		2.939388477619500e+02,		3.101661055180298e+02,		3.276414947398778e+02,		3.463916200524884e+02,
		3.663636528394170e+02,		3.873908991468181e+02,		4.091620425003369e+02,		4.312167638161125e+02,		4.530024480356451e+02,
		4.739946777990916e+02,		4.938290920944067e+02,		5.122962189599310e+02,		5.293226481068385e+02,		5.449383851989083e+02,
		5.592347335793751e+02,		5.723318770256951e+02,		5.843577289917737e+02,		5.954357172083029e+02,		6.056786755611994e+02,
		6.151865445675085e+02,		6.240462432878431e+02,		6.323326367214722e+02,		6.401099459393937e+02,		6.474332400800245e+02,
		6.543498330596582e+02,		6.609005135899986e+02,		6.671205927633215e+02,		6.730407798397995e+02,		6.786879073351735e+02,
		6.840855289046908e+02,		6.892544121715497e+02,		6.942129458268706e+02,		6.989774771698675e+02,		7.035625932874451e+02,
		7.079813564983860e+02,		7.122455025536751e+02,		7.163656083629238e+02,		7.203512346492331e+02,		7.242110478576896e+02,
		7.279529247971434e+02,		7.315840428310596e+02,		7.351109579102223e+02,		7.385396723262693e+02,		7.418756937353620e+02,
		7.451240867371376e+02,		7.482895180806522e+02,		7.513762963956542e+02,		7.543884072055913e+02,		7.573295438618696e+02,
		7.602031349421476e+02,		7.630123685749644e+02,		7.657602140855556e+02,		7.684494413013297e+02,		7.710826378077371e+02,
		7.736622244050168e+02,		7.761904689821409e+02,		7.786694989952186e+02,		7.811013127128017e+02,		7.834877893693675e+02,
		7.858306983500856e+02,		7.881317075143536e+02,		7.903923907521634e+02,		7.926142348557793e+02,		7.947986457791819e+02,
		7.969469543490635e+02,		7.990604214836103e+02,		8.011402429687961e+02,		8.031875538361808e+02,		8.052034323812248e+02,
		8.071889038568130e+02,		8.091449438728217e+02,		8.110724815292557e+02,		8.129724023075063e+02,		8.148455507417359e+02,
		8.166927328900491e+02,		8.185147186231500e+02,		8.203122437463470e+02,		8.220860119692297e+02,		8.238366967358808e+02,
		8.255649429272946e+02,		8.272713684464981e+02,		8.289565656959129e+02,		8.306211029556144e+02,		8.322655256702965e+02,
		8.338903576521016e+02,		8.354961022057960e+02,		8.370832431822034e+02,		8.386522459652817e+02,		8.402035583977984e+02,
		8.417376116500861e+02,		8.432548210360227e+02,		8.447555867800113e+02,		8.462402947384285e+02,		8.477093170787419e+02,
		8.491630129192152e+02,		8.506017289319002e+02,		8.520257999114070e+02,		8.534355493117492e+02,		8.548312897533594e+02,
		8.562133235022480e+02,		8.575819429231054e+02,		8.589374309080195e+02,		8.602800612823584e+02,		8.616100991892538e+02,
		8.629278014540128e+02,		8.642334169297008e+02,		8.655271868250461e+02,		8.668093450157148e+02,		8.680801183399893e+02,
		8.693397268797273e+02,		8.705883842275049e+02,		8.718262977407238e+02,		8.730536687834473e+02,		8.742706929566568e+02,
		8.754775603175817e+02,		8.766744555887327e+02,		8.778615583571836e+02,		8.790390432646649e+02,		8.802070801889540e+02,
		8.813658344170374e+02,		8.825154668104889e+02,		8.836561339634774e+02,		8.847879883537879e+02,		8.859111784872262e+02,
		8.870258490357527e+02,		8.881321409696610e+02,		8.892301916841072e+02,		8.903201351202828e+02,		8.914021018814889e+02,
		8.924762193443727e+02,		8.935426117655689e+02,		8.946014003839600e+02,		8.956527035187743e+02,		8.966966366637337e+02,
		8.977333125774131e+02,		8.987628413700253e+02,		8.997853305867721e+02,		9.008008852879342e+02,		9.018096081258577e+02,
		9.028115994189631e+02,		9.038069572229322e+02,		9.047957773991877e+02,		9.057781536807880e+02,		9.067541777358689e+02,
		9.077239392287158e+02,		9.086875258785960e+02,		9.096450235164281e+02,		9.105965161394040e+02,		9.115420859636290e+02,
		9.124818134748809e+02,		9.134157774775722e+02,		9.143440551419673e+02,		9.152667220497602e+02,		9.161838522380529e+02,
		9.170955182418199e+02,		9.180017911349139e+02,		9.189027405696689e+02,		9.197984348151660e+02,		9.206889407942114e+02,
		9.215743241190729e+02,		9.224546491260353e+02,		9.233299789088196e+02,		9.242003753508982e+02,		9.250658991567631e+02,
		9.259266098821842e+02,		9.267825659634972e+02,		9.276338247459465e+02,		9.284804425111461e+02,		9.293224745036564e+02,
		9.301599749567457e+02,		9.309929971173407e+02,		9.318215932702029e+02,		9.326458147613757e+02,		9.334657120209001e+02,
		9.342813345848517e+02,		9.350927311167078e+02,		9.358999494280749e+02,		9.367030364988021e+02,		9.375020384964944e+02,
		9.382970007954532e+02,		9.390879679950654e+02,		9.398749839376537e+02,		9.406580917258110e+02,		9.414373337392415e+02,
		9.422127516511165e+02,		9.429843864439623e+02,		9.437522784251094e+02,		9.445164672417002e+02,		9.452769918952763e+02,
		9.460338907559695e+02,		9.467872015762908e+02,		9.475369615045508e+02,		9.482832070979059e+02,		9.490259743350538e+02,
		9.497652986285906e+02,		9.505012148370263e+02,		9.512337572764891e+02,		9.519629597321144e+02,		9.526888554691361e+02,
		9.534114772436818e+02,		9.541308573132899e+02,		9.548470274471568e+02,		9.555600189361111e+02,		9.562698626023364e+02,
		9.569765888088467e+02,		9.576802274687229e+02,		9.583808080541031e+02,		9.590783596049655e+02,		9.597729107376769e+02,
		9.604644896533333e+02,		9.611531241458978e+02,		9.618388416101288e+02,		9.625216690493276e+02,		9.632016330828777e+02,
		9.638787599536224e+02,		9.645530755350500e+02,		9.652246053383067e+02,		9.658933745190553e+02,		9.665594078841515e+02,
		9.672227298981780e+02,		9.678833646898155e+02,		9.685413360580692e+02,		9.691966674783467e+02,		9.698493821084001e+02,
		9.704995027941233e+02,		9.711470520752215e+02,		9.717920521907506e+02,		9.724345250845284e+02,		9.730744924104251e+02,
		9.737119755375326e+02,		9.743469955552195e+02,		9.749795732780725e+02,		9.756097292507278e+02,		9.762374837525966e+02,
		9.768628568024845e+02,		9.774858681631108e+02,		9.781065373455291e+02,		9.787248836134538e+02,		9.793409259874861e+02,
		9.799546832492607e+02,		9.805661739454906e+02,		9.811754163919372e+02,		9.817824286772837e+02,		9.823872286669416e+02,
		9.829898340067640e+02,		9.835902621266868e+02,		9.841885302442919e+02,		9.847846553683025e+02,		9.853786543019968e+02,
		9.859705436465538e+02,		9.865603398043389e+02,		9.871480589821114e+02,		9.877337171941698e+02,		9.883173302654403e+02,
		9.888989138344912e+02,		9.894784833564986e+02,		9.900560541061450e+02,		9.906316411804593e+02,		9.912052595016110e+02,
		9.917769238196342e+02,		9.923466487151111e+02,		9.929144486017944e+02,		9.934803377291838e+02,		9.940443301850481e+02,
		9.946064398979032e+02,		9.951666806394389e+02,		9.957250660268979e+02,		9.962816095254160e+02,		9.968363244503081e+02,
		9.973892239693221e+02,		9.979403211048379e+02,		9.984896287360363e+02,		9.990371596010178e+02,		9.995829262988910e+02,
		1.000126941291814e+03,		1.000669216907001e+03,		1.001209765338700e+03,		1.001748598650112e+03,		1.002285728775304e+03,
		1.002821167521065e+03,		1.003354926568738e+03,		1.003887017476015e+03,		1.004417451678705e+03,		1.004946240492464e+03,
		1.005473395114497e+03,		1.005998926625229e+03,		1.006522845989950e+03,		1.007045164060422e+03,		1.007565891576470e+03,
		1.008085039167531e+03,		1.008602617354190e+03,		1.009118636549677e+03,		1.009633107061348e+03,		1.010146039092133e+03,
		1.010657442741959e+03,		1.011167328009162e+03,		1.011675704791852e+03,		1.012182582889272e+03,		1.012687972003131e+03,
		1.013191881738907e+03,		1.013694321607140e+03,		1.014195301024691e+03,		1.014694829315987e+03,		1.015192915714242e+03,
		1.015689569362665e+03,		1.016184799315635e+03,		1.016678614539868e+03,		1.017171023915560e+03,		1.017662036237512e+03,
		1.018151660216233e+03,		1.018639904479034e+03,		1.019126777571095e+03,		1.019612287956521e+03,		1.020096444019372e+03,
		1.020579254064692e+03,		1.021060726319508e+03,		1.021540868933813e+03,		1.022019689981544e+03,		1.022497197461537e+03,
		1.022973399298463e+03,		1.023448303343765e+03,		1.023921917376554e+03,		1.024394249104523e+03,		1.024865306164817e+03,
		1.025335096124912e+03,		1.025803626483465e+03,		1.026270904671160e+03,		1.026736938051536e+03,		1.027201733921809e+03,
		1.027665299513668e+03,		1.028127641994076e+03,		1.028588768466046e+03,		1.029048685969408e+03,		1.029507401481572e+03,
		1.029964921918266e+03,		1.030421254134276e+03,		1.030876404924165e+03,		1.031330381022991e+03,		1.031783189107002e+03,
		1.032234835794332e+03,		1.032685327645683e+03,		1.033134671164993e+03,		1.033582872800096e+03,		1.034029938943381e+03,
		1.034475875932428e+03,		1.034920690050640e+03,		1.035364387527871e+03,		1.035806974541037e+03,		1.036248457214724e+03,
		1.036688841621783e+03,		1.037128133783923e+03,		1.037566339672280e+03,		1.038003465208002e+03,		1.038439516262807e+03,
		1.038874498659533e+03,		1.039308418172697e+03,		1.039741280529024e+03,		1.040173091407987e+03,		1.040603856442330e+03,
		1.041033581218583e+03,		1.041462271277575e+03,		1.041889932114938e+03,		1.042316569181601e+03,		1.042742187884280e+03,
		1.043166793585964e+03,		1.043590391606385e+03,		1.044012987222493e+03,		1.044434585668919e+03,		1.044855192138426e+03,
		1.045274811782369e+03,		1.045693449711130e+03,		1.046111110994565e+03,		1.046527800662430e+03,		1.046943523704812e+03,
		1.047358285072549e+03,		1.047772089677645e+03,		1.048184942393681e+03,		1.048596848056217e+03,		1.049007811463197e+03,
		1.049417837375337e+03,		1.049826930516515e+03,		1.050235095574157e+03,		1.050642337199615e+03,		1.051048660008537e+03,
		1.051454068581243e+03,		1.051858567463081e+03,		1.052262161164792e+03,		1.052664854162863e+03,		1.053066650899875e+03,
		1.053467555784853e+03,		1.053867573193602e+03,		1.054266707469050e+03,		1.054664962921574e+03,		1.055062343829330e+03,
		1.055458854438584e+03,		1.055854498964022e+03,		1.056249281589071e+03,		1.056643206466211e+03,		1.057036277717284e+03,
		1.057428499433794e+03,		1.057819875677212e+03,		1.058210410479273e+03,		1.058600107842263e+03,		1.058988971739314e+03,
		1.059377006114689e+03,		1.059764214884064e+03,		1.060150601934805e+03,		1.060536171126244e+03,		1.060920926289956e+03,
		1.061304871230018e+03,		1.061688009723284e+03,		1.062070345519642e+03,		1.062451882342274e+03,		1.062832623887912e+03,
		1.063212573827095e+03,		1.063591735804408e+03,		1.063970113438740e+03,		1.064347710323524e+03,		1.064724530026976e+03,
		1.065100576092335e+03,		1.065475852038098e+03,		1.065850361358253e+03,		1.066224107522507e+03,		1.066597093976515e+03,
		1.066969324142104e+03,		1.067340801417492e+03,		1.067711529177512e+03,		1.068081510773825e+03,		1.068450749535134e+03,
		1.068819248767397e+03,		1.069187011754037e+03,		1.069554041756147e+03,		1.069920342012694e+03,		1.070285915740723e+03,
		1.070650766135552e+03,		1.071014896370978e+03,		1.071378309599463e+03,		1.071741008952331e+03,		1.072102997539961e+03,
		1.072464278451970e+03,		1.072824854757405e+03,		1.073184729504923e+03,		1.073543905722977e+03,		1.073902386419990e+03,
		1.074260174584542e+03,		1.074617273185540e+03,		1.074973685172392e+03,		1.075329413475183e+03,		1.075684461004843e+03,
		1.076038830653315e+03,		1.076392525293722e+03,		1.076745547780534e+03,		1.077097900949728e+03,		1.077449587618950e+03
	},
	{
		1.630549046174048e+00,		4.931847946412010e+00,		8.283899079397472e+00,		1.168858385661775e+01,		1.514789514904508e+01,
		1.866394604979263e+01,		2.223897950204726e+01,		2.587537889631150e+01,		2.957567975577166e+01,		3.334258264582139e+01,
		3.717896746386191e+01,		4.108790928901796e+01,		4.507269599901226e+01,		4.913684789393177e+01,		5.328413960497339e+01,
		5.751862461166147e+01,		6.184466274493978e+01,		6.626695111773684e+01,		7.079055900126826e+01,		7.542096725715724e+01,
		8.016411304572497e+01,		8.502644066357932e+01,		9.001495952390471e+01,		9.513731048673201e+01,		1.004018419814156e+02,
		1.058176976486217e+02,		1.113949175752102e+02,		1.171445556153277e+02,		1.230788157996143e+02,		1.292112114479419e+02,
		1.355567513360847e+02,		1.421321581371206e+02,		1.489561253697686e+02,		1.560496202243568e+02,		1.634362408479608e+02,
		1.711426378182415e+02,		1.791990103312117e+02,		1.876396874917554e+02,		1.965038029062549e+02,		2.058360644151727e+02,
		2.156876063340145e+02,		2.261168818305444e+02,		2.371904954256262e+02,		2.489837690647460e+02,		2.615806487870448e+02,
		2.750722589418107e+02,		2.895529958600890e+02,		3.051126454038289e+02,		3.218229758273966e+02,		3.397181033536386e+02,
		3.587695746903282e+02,		3.788585153057685e+02,		3.997492121564093e+02,		4.210765763610789e+02,		4.423719671796308e+02,
		4.631424509301731e+02,		4.829826702474701e+02,		5.016381840106284e+02,		5.189768517044631e+02,		5.349762582615130e+02,
		5.496880808348667e+02,		5.632053226343908e+02,		5.756388090119575e+02,		5.871023500553821e+02,		5.977043124252251e+02,
		6.075434647244419e+02,		6.167074825056632e+02,		6.252729862174680e+02,		6.333063674655126e+02,		6.408649426640447e+02,
		6.479981713828352e+02,		6.547488050273216e+02,		6.611539081715846e+02,		6.672457371084392e+02,		6.730524813573096e+02,
		6.785988830298829e+02,		6.839067516836145e+02,		6.889953918381256e+02,		6.938819584868271e+02,		6.985817536562386e+02,
		7.031084748196766e+02,		7.074744239669507e+02,		7.116906844343466e+02,		7.157672712069793e+02,		7.197132592848374e+02,
		7.235368938118504e+02,		7.272456849604409e+02,		7.308464900051467e+02,		7.343455845757635e+02,		7.377487247278534e+02,
		7.410612011864099e+02,		7.442878868914473e+02,		7.474332787901706e+02,		7.505015346704286e+02,		7.534965057067482e+02,
		7.564217652886186e+02,		7.592806346159838e+02,		7.620762054764132e+02,		7.648113605591275e+02,		7.674887916112427e+02,
		7.701110156993223e+02,		7.726803898036746e+02,		7.751991239423091e+02,		7.776692929954777e+02,		7.800928473795838e+02,
		7.824716227000633e+02,		7.848073484965795e+02,		7.871016561796430e+02,		7.893560862456551e+02,		7.915720948468208e+02,
		7.937510597831946e+02,		7.958942859762526e+02,		7.980030104764271e+02,		8.000784070510711e+02,		8.021215903940088e+02,
		8.041336199933022e+02,		8.061155036897694e+02,		8.080682009552985e+02,		8.099926259168944e+02,		8.118896501496151e+02,
		8.137601052591928e+02,		8.156047852729668e+02,		8.174244488558691e+02,		8.192198213665473e+02,		8.209915967671898e+02,
		8.227404393993347e+02,		8.244669856367315e+02,		8.261718454252764e+02,		8.278556037191512e+02,		8.295188218213603e+02,
		8.311620386362164e+02,		8.327857718405597e+02,		8.343905189799473e+02,		8.359767584954695e+02,		8.375449506863749e+02,
		8.390955386132365e+02,		8.406289489459803e+02,		8.421455927607672e+02,		8.436458662893365e+02,		8.451301516241858e+02,
		8.465988173826386e+02,		8.480522193326195e+02,		8.494907009827718e+02,		8.509145941392816e+02,		8.523242194316434e+02,
		8.537198868094015e+02,		8.551018960117589e+02,		8.564705370118156e+02,		8.578260904370233e+02,		8.591688279673934e+02,
		8.604990127128228e+02,		8.618168995708396e+02,		8.631227355659703e+02,		8.644167601718343e+02,		8.656992056170101e+02,
		8.669702971756366e+02,		8.682302534436527e+02,		8.694792866015021e+02,		8.707176026641039e+02,		8.719454017187981e+02,
		8.731628781519699e+02,		8.743702208649721e+02,		8.755676134799497e+02,		8.767552345361346e+02,		8.779332576771067e+02,
		8.791018518295432e+02,		8.802611813738871e+02,		8.814114063073920e+02,		8.825526823999181e+02,		8.836851613428872e+02,
		8.848089908917342e+02,		8.859243150022004e+02,		8.870312739607816e+02,		8.881300045096182e+02,		8.892206399661324e+02,
		8.903033103376448e+02,		8.913781424312394e+02,		8.924452599591036e+02,		8.935047836395648e+02,		8.945568312940356e+02,
		8.956015179400545e+02,		8.966389558806206e+02,		8.976692547899909e+02,		8.986925217961057e+02,		8.997088615597987e+02,
		9.007183763509497e+02,		9.017211661217094e+02,		9.027173285769310e+02,		9.037069592419440e+02,		9.046901515277799e+02,
		9.056669967939660e+02,		9.066375844089996e+02,		9.076020018086018e+02,		9.085603345518406e+02,		9.095126663752292e+02,
		9.104590792448786e+02,		9.113996534067876e+02,		9.123344674353499e+02,		9.132635982801560e+02,		9.141871213111632e+02,
		9.151051103622867e+02,		9.160176377735023e+02,		9.169247744315010e+02,		9.178265898089618e+02,		9.187231520024945e+02,
		9.196145277693236e+02,		9.205007825627355e+02,		9.213819805663552e+02,		9.222581847273061e+02,		9.231294567882774e+02,
		9.239958573185513e+02,		9.248574457440372e+02,		9.257142803763331e+02,		9.265664184408755e+02,		9.274139161041866e+02,
		9.282568285002752e+02,		9.290952097562068e+02,		9.299291130168838e+02,		9.307585904690648e+02,		9.315836933646373e+02,
		9.324044720431965e+02,		9.332209759539279e+02,		9.340332536768406e+02,		9.348413529433607e+02,		9.356453206563182e+02,
		9.364452029093360e+02,		9.372410450056580e+02,		9.380328914764195e+02,		9.388207860983989e+02,		9.396047719112446e+02,
		9.403848912342157e+02,		9.411611856824486e+02,		9.419336961827527e+02,		9.427024629889703e+02,		9.434675256969018e+02,
		9.442289232588157e+02,		9.449866939975606e+02,		9.457408756202817e+02,		9.464915052317687e+02,		9.472386193474367e+02,
		9.479822539059562e+02,		9.487224442815422e+02,		9.494592252959181e+02,		9.501926312299582e+02,		9.509226958350172e+02,
		9.516494523439757e+02,		9.523729334819762e+02,		9.530931714769001e+02,		9.538101980695561e+02,		9.545240445236200e+02,
		9.552347416353048e+02,		9.559423197427999e+02,		9.566468087354614e+02,		9.573482380627677e+02,		9.580466367430660e+02,
		9.587420333720751e+02,		9.594344561312059e+02,		9.601239327956513e+02,		9.608104907422908e+02,		9.614941569574024e+02,
		9.621749580441767e+02,		9.628529202300600e+02,		9.635280693739148e+02,		9.642004309730074e+02,		9.648700301698350e+02,
		9.655368917587816e+02,		9.662010401926269e+02,		9.668624995888963e+02,		9.675212937360583e+02,		9.681774460995907e+02,
		9.688309798278905e+02,		9.694819177580604e+02,		9.701302824215543e+02,		9.707760960497019e+02,		9.714193805790942e+02,
		9.720601576568648e+02,		9.726984486458377e+02,		9.733342746295696e+02,		9.739676564172689e+02,		9.745986145486225e+02,
		9.752271692984950e+02,		9.758533406815424e+02,		9.764771484567141e+02,		9.770986121316619e+02,		9.777177509670528e+02,
		9.783345839807829e+02,		9.789491299521125e+02,		9.795614074256985e+02,		9.801714347155532e+02,		9.807792299089119e+02,
		9.813848108700221e+02,		9.819881952438468e+02,		9.825894004597054e+02,		9.831884437348186e+02,		9.837853420777948e+02,
		9.843801122920381e+02,		9.849727709790890e+02,		9.855633345418920e+02,		9.861518191880056e+02,		9.867382409327322e+02,
		9.873226156022029e+02,		9.879049588363868e+02,		9.884852860920442e+02,		9.890636126456203e+02,		9.896399535960848e+02,
		9.902143238677105e+02,		9.907867382127978e+02,		9.913572112143481e+02,		9.919257572886839e+02,		9.924923906880207e+02,
		9.930571255029760e+02,		9.936199756650541e+02,		9.941809549490546e+02,		9.947400769754598e+02,		9.952973552127598e+02,
		9.958528029797413e+02,		9.964064334477303e+02,		9.969582596427921e+02,		9.975082944478952e+02,		9.980565506050253e+02,
		9.986030407172678e+02,		9.991477772508514e+02,		9.996907725371437e+02,		1.000232038774629e+03,		1.000771588030828e+03,
		1.001309432244200e+03,		1.001845583226000e+03,		1.002380052662107e+03,		1.002912852114819e+03,		1.003443993024610e+03,
		1.003973486711864e+03,		1.004501344378577e+03,		1.005027577110017e+03,		1.005552195876368e+03,		1.006075211534344e+03,
		1.006596634828764e+03,		1.007116476394108e+03,		1.007634746756051e+03,		1.008151456332950e+03,		1.008666615437329e+03,
		1.009180234277327e+03,		1.009692322958115e+03,		1.010202891483302e+03,		1.010711949756308e+03,		1.011219507581717e+03,
		1.011725574666603e+03,		1.012230160621843e+03,		1.012733274963393e+03,		1.013234927113559e+03,		1.013735126402235e+03,
		1.014233882068121e+03,		1.014731203259932e+03,		1.015227099037570e+03,		1.015721578373296e+03,		1.016214650152858e+03,
		1.016706323176626e+03,		1.017196606160695e+03,		1.017685507737970e+03,		1.018173036459237e+03,		1.018659200794212e+03,
		1.019144009132584e+03,		1.019627469785022e+03,		1.020109590984191e+03,		1.020590380885728e+03,		1.021069847569215e+03,
		1.021547999039139e+03,		1.022024843225824e+03,		1.022500387986365e+03,		1.022974641105533e+03,		1.023447610296672e+03,
		1.023919303202587e+03,		1.024389727396404e+03,		1.024858890382436e+03,		1.025326799597012e+03,		1.025793462409322e+03,
		1.026258886122220e+03,		1.026723077973034e+03,		1.027186045134359e+03,		1.027647794714834e+03,		1.028108333759911e+03,
		1.028567669252610e+03,		1.029025808114266e+03,		1.029482757205262e+03,		1.029938523325753e+03,		1.030393113216374e+03,
		1.030846533558945e+03,		1.031298790977163e+03,		1.031749892037278e+03,		1.032199843248768e+03,		1.032648651065001e+03,
		1.033096321883879e+03,		1.033542862048489e+03,		1.033988277847729e+03,		1.034432575516934e+03,		1.034875761238489e+03,
		1.035317841142436e+03,		1.035758821307067e+03,		1.036198707759519e+03,		1.036637506476345e+03,		1.037075223384093e+03,
		1.037511864359863e+03,		1.037947435231867e+03,		1.038381941779978e+03,		1.038815389736261e+03,		1.039247784785515e+03,
		1.039679132565793e+03,		1.040109438668919e+03,		1.040538708641001e+03,		1.040966947982931e+03,		1.041394162150885e+03,
		1.041820356556806e+03,		1.042245536568895e+03,		1.042669707512081e+03,		1.043092874668492e+03,		1.043515043277916e+03,
		1.043936218538265e+03,		1.044356405606017e+03,		1.044775609596664e+03,		1.045193835585153e+03,		1.045611088606314e+03,
		1.046027373655288e+03,		1.046442695687951e+03,		1.046857059621328e+03,		1.047270470334000e+03,		1.047682932666512e+03,
		1.048094451421773e+03,		1.048505031365443e+03,		1.048914677226331e+03,		1.049323393696773e+03,		1.049731185433012e+03,
		1.050138057055569e+03,		1.050544013149618e+03,		1.050949058265343e+03,		1.051353196918303e+03,		1.051756433589780e+03,
		1.052158772727140e+03,		1.052560218744164e+03,		1.052960776021402e+03,		1.053360448906504e+03,		1.053759241714552e+03,
		1.054157158728389e+03,		1.054554204198946e+03,		1.054950382345556e+03,		1.055345697356278e+03,		1.055740153388202e+03,
		1.056133754567759e+03,		1.056526504991028e+03,		1.056918408724034e+03,		1.057309469803044e+03,		1.057699692234863e+03,
		1.058089079997119e+03,		1.058477637038554e+03,		1.058865367279305e+03,		1.059252274611176e+03,		1.059638362897926e+03,
		1.060023635975528e+03,		1.060408097652449e+03,		1.060791751709906e+03,		1.061174601902136e+03,		1.061556651956651e+03,
		1.061937905574492e+03,		1.062318366430489e+03,		1.062698038173504e+03,		1.063076924426680e+03,		1.063455028787684e+03,
		1.063832354828953e+03,		1.064208906097926e+03,		1.064584686117282e+03,		1.064959698385170e+03,		1.065333946375445e+03,
		1.065707433537888e+03,		1.066080163298435e+03,		1.066452139059395e+03,		1.066823364199675e+03,		1.067193842074990e+03,
		1.067563576018081e+03,		1.067932569338925e+03,		1.068300825324947e+03,		1.068668347241224e+03,		1.069035138330688e+03,
		1.069401201814333e+03,		1.069766540891408e+03,		1.070131158739624e+03,		1.070495058515338e+03,		1.070858243353754e+03,
		1.071220716369111e+03,		1.071582480654872e+03,		1.071943539283908e+03,		1.072303895308688e+03,		1.072663551761455e+03,
		1.073022511654411e+03,		1.073380777979891e+03,		1.073738353710546e+03,		1.074095241799508e+03,		1.074451445180570e+03,
		1.074806966768354e+03,		1.075161809458477e+03,		1.075515976127720e+03,		1.075869469634195e+03,		1.076222292817504e+03
	},
	{
		1.627499442887386e+00,		4.922390171764925e+00,		8.267604765671543e+00,		1.166499301912896e+01,		1.511651330221485e+01,
		1.862424100191070e+01,		2.219037778634997e+01,		2.581726178950187e+01,		2.950737882747005e+01,		3.326337477342899e+01,
		3.708806923666973e+01,		4.098447071275902e+01,		4.495579339701874e+01,		4.900547588310596e+01,		5.313720200327168e+01,
		5.735492410793076e+01,		6.166288913074415e+01,		6.606566784302480e+01,		7.056818776979775e+01,		7.517577032154375e+01,
		7.989417279330978e+01,		8.472963599985991e+01,		8.968893845597802e+01,		9.477945817990140e+01,		1.000092434011736e+02,
		1.053870936991118e+02,		1.109226533930404e+02,		1.166265193601420e+02,		1.225103658819989e+02,		1.285870896278441e+02,
		1.348709784814274e+02,		1.413779086156158e+02,		1.481255750114286e+02,		1.551337614837054e+02,		1.624246571534621e+02,
		1.700232270647630e+02,		1.779576450165414e+02,		1.862597961600372e+02,		1.949658545552203e+02,		2.041169349538551e+02,
		2.137598054605288e+02,		2.239476228888311e+02,		2.347406060864583e+02,		2.462064788407601e+02,		2.584203708697513e+02,
		2.714636384453011e+02,		2.854207518635098e+02,		3.003730726303761e+02,		3.163882557443804e+02,		3.335045546841091e+02,
		3.517105965893289e+02,		3.709225632520401e+02,		3.909619176571582e+02,		4.115407226912529e+02,		4.322700961501909e+02,
		4.527085165610213e+02,		4.724441771648134e+02,		4.911819246784651e+02,		5.087445341882976e+02,		5.250594974877632e+02,
		5.401373226443649e+02,		5.540408307205158e+02,		5.668603933050859e+02,		5.786969977322522e+02,		5.896517897010478e+02,
		5.998201969271142e+02,		6.092890684514402e+02,		6.181356982085845e+02,		6.264279494339963e+02,		6.342249566906978e+02,
		6.415780746060974e+02,		6.485318790490996e+02,		6.551251174746949e+02,		6.613915615079096e+02,		6.673607472017585e+02,
		6.730586054620082e+02,		6.785079930585739e+02,		6.837291374442780e+02,		6.887400087182913e+02,		6.935566309220610e+02,
		6.981933432282822e+02,		7.026630198910922e+02,		7.069772562656123e+02,		7.111465268543917e+02,		7.151803202113201e+02,
		7.190872546140903e+02,		7.228751776761253e+02,		7.265512524770915e+02,		7.301220323195620e+02,		7.335935258430438e+02,
		7.369712539256279e+02,		7.402602995616188e+02,		7.434653517078892e+02,		7.465907439327864e+02,		7.496404885712036e+02,
		7.526183069822625e+02,		7.555276564172652e+02,		7.583717539315479e+02,		7.611535977119105e+02,		7.638759861392223e+02,
		7.665415348616660e+02,		7.691526921168092e+02,		7.717117525088901e+02,		7.742208694205507e+02,		7.766820662150659e+02,
		7.790972463651898e+02,		7.814682026275702e+02,		7.837966253669388e+02,		7.860841101215173e+02,		7.883321644900011e+02,
		7.905422144109360e+02,		7.927156098969480e+02,		7.948536302790325e+02,		7.969574890098178e+02,		7.990283380691543e+02,
		8.010672720105517e+02,		8.030753316827977e+02,		8.050535076572779e+02,		8.070027433883316e+02,		8.089239381310459e+02,
		8.108179496383392e+02,		8.126855966569726e+02,		8.145276612401120e+02,		8.163448908922744e+02,		8.181380005609853e+02,
		8.199076744880161e+02,		8.216545679318616e+02,		8.233793087720110e+02,		8.250824990045500e+02,		8.267647161377896e+02,
		8.284265144957573e+02,		8.300684264367546e+02,		8.316909634934822e+02,		8.332946174406851e+02,		8.348798612957414e+02,
		8.364471502571849e+02,		8.379969225856595e+02,		8.395296004315028e+02,		8.410455906127511e+02,		8.425452853470758e+02,
		8.440290629408609e+02,		8.454972884383872e+02,		8.469503142338397e+02,		8.483884806486574e+02,		8.498121164765236e+02,
		8.512215394981597e+02,		8.526170569678724e+02,		8.539989660736940e+02,		8.553675543728031e+02,		8.567231002038010e+02,
		8.580658730772745e+02,		8.593961340460137e+02,		8.607141360561344e+02,		8.620201242802461e+02,		8.633143364337790e+02,
		8.645970030754513e+02,		8.658683478928324e+02,		8.671285879738515e+02,		8.683779340651021e+02,		8.696165908176646e+02,
		8.708447570211912e+02,		8.720626258268888e+02,		8.732703849600396e+02,		8.744682169226331e+02,		8.756562991866508e+02,
		8.768348043785186e+02,		8.780039004551995e+02,		8.791637508723769e+02,		8.803145147451505e+02,		8.814563470016294e+02,
		8.825893985298111e+02,		8.837138163180758e+02,		8.848297435896337e+02,		8.859373199312350e+02,		8.870366814164283e+02,
		8.881279607236368e+02,		8.892112872493217e+02,		8.902867872164682e+02,		8.913545837786180e+02,		8.924147971196783e+02,
		8.934675445496945e+02,		8.945129405967974e+02,		8.955510970954884e+02,		8.965821232714542e+02,		8.976061258230491e+02,
		8.986232089996341e+02,		8.996334746768754e+02,		9.006370224291794e+02,		9.016339495993716e+02,		9.026243513657505e+02,
		9.036083208066391e+02,		9.045859489625294e+02,		9.055573248959457e+02,		9.065225357491151e+02,		9.074816667995437e+02,
		9.084348015135830e+02,		9.093820215980851e+02,		9.103234070502198e+02,		9.112590362055269e+02,		9.121889857842915e+02,
		9.131133309362989e+02,		9.140321452840435e+02,		9.149455009644555e+02,		9.158534686692013e+02,		9.167561176836202e+02,
		9.176535159243488e+02,		9.185457299756961e+02,		9.194328251247938e+02,		9.203148653956056e+02,		9.211919135818117e+02,
		9.220640312786226e+02,		9.229312789135713e+02,		9.237937157763062e+02,		9.246514000474407e+02,		9.255043888264827e+02,
		9.263527381588898e+02,		9.271965030622705e+02,		9.280357375517688e+02,		9.288704946646756e+02,		9.297008264842678e+02,
		9.305267841629334e+02,		9.313484179445804e+02,		9.321657771863872e+02,		9.329789103798830e+02,		9.337878651714084e+02,
		9.345926883819739e+02,		9.353934260265232e+02,		9.361901233326440e+02,		9.369828247587225e+02,		9.377715740115839e+02,
		9.385564140636180e+02,		9.393373871694185e+02,		9.401145348819484e+02,		9.408878980682493e+02,		9.416575169247078e+02,
		9.424234309918991e+02,		9.431856791690115e+02,		9.439442997278813e+02,		9.446993303266362e+02,		9.454508080229647e+02,
		9.461987692870338e+02,		9.469432500140480e+02,		9.476842855364758e+02,		9.484219106359519e+02,		9.491561595548558e+02,
		9.498870660075956e+02,		9.506146631915830e+02,		9.513389837979306e+02,		9.520600600218675e+02,		9.527779235728880e+02,
		9.534926056846338e+02,		9.542041371245299e+02,		9.549125482031742e+02,		9.556178687834833e+02,		9.563201282896179e+02,
		9.570193557156733e+02,		9.577155796341675e+02,		9.584088282043036e+02,		9.590991291800385e+02,		9.597865099179523e+02,
		9.604709973849215e+02,		9.611526181656097e+02,		9.618313984697775e+02,		9.625073641394108e+02,		9.631805406556873e+02,
		9.638509531457718e+02,		9.645186263894487e+02,		9.651835848256051e+02,		9.658458525585532e+02,		9.665054533642137e+02,
		9.671624106961488e+02,		9.678167476914584e+02,		9.684684871765412e+02,		9.691176516727244e+02,		9.697642634017600e+02,
		9.704083442912056e+02,		9.710499159796739e+02,		9.716889998219709e+02,		9.723256168941170e+02,		9.729597879982583e+02,
		9.735915336674616e+02,		9.742208741704140e+02,		9.748478295160161e+02,		9.754724194578674e+02,		9.760946634986643e+02,
		9.767145808944971e+02,		9.773321906590587e+02,		9.779475115677537e+02,		9.785605621617341e+02,		9.791713607518342e+02,
		9.797799254224332e+02,		9.803862740352332e+02,		9.809904242329510e+02,		9.815923934429464e+02,		9.821921988807637e+02,
		9.827898575536024e+02,		9.833853862637195e+02,		9.839788016117577e+02,		9.845701200000118e+02,		9.851593576356206e+02,
		9.857465305336965e+02,		9.863316545204001e+02,		9.869147452359404e+02,		9.874958181375213e+02,		9.880748885022317e+02,
		9.886519714298728e+02,		9.892270818457323e+02,		9.898002345033067e+02,		9.903714439869614e+02,		9.909407247145499e+02,
		9.915080909399753e+02,		9.920735567557028e+02,		9.926371360952245e+02,		9.931988427354805e+02,		9.937586902992227e+02,
		9.943166922573492e+02,		9.948728619311818e+02,		9.954272124947050e+02,		9.959797569767629e+02,		9.965305082632152e+02,
		9.970794790990522e+02,		9.976266820904698e+02,		9.981721297069066e+02,		9.987158342830446e+02,		9.992578080207727e+02,
		9.997980629911100e+02,		1.000336611136102e+03,		1.000873464270673e+03,		1.001408634084457e+03,		1.001942132143576e+03,
		1.002473969892413e+03,		1.003004158655330e+03,		1.003532709638365e+03,		1.004059633930901e+03,		1.004584942507299e+03,
		1.005108646228508e+03,		1.005630755843643e+03,		1.006151281991539e+03,		1.006670235202270e+03,		1.007187625898655e+03,
		1.007703464397721e+03,		1.008217760912162e+03,		1.008730525551742e+03,		1.009241768324712e+03,		1.009751499139174e+03,
		1.010259727804428e+03,		1.010766464032307e+03,		1.011271717438478e+03,		1.011775497543722e+03,		1.012277813775201e+03,
		1.012778675467694e+03,		1.013278091864819e+03,		1.013776072120229e+03,		1.014272625298795e+03,		1.014767760377766e+03,
		1.015261486247903e+03,		1.015753811714616e+03,		1.016244745499048e+03,		1.016734296239178e+03,		1.017222472490879e+03,
		1.017709282728979e+03,		1.018194735348281e+03,		1.018678838664593e+03,		1.019161600915724e+03,		1.019643030262471e+03,
		1.020123134789584e+03,		1.020601922506728e+03,		1.021079401349415e+03,		1.021555579179936e+03,		1.022030463788260e+03,
		1.022504062892943e+03,		1.022976384141998e+03,		1.023447435113770e+03,		1.023917223317789e+03,		1.024385756195610e+03,
		1.024853041121645e+03,		1.025319085403973e+03,		1.025783896285150e+03,		1.026247480942995e+03,		1.026709846491372e+03,
		1.027170999980954e+03,		1.027630948399985e+03,		1.028089698675017e+03,		1.028547257671649e+03,		1.029003632195243e+03,
		1.029458828991644e+03,		1.029912854747872e+03,		1.030365716092821e+03,		1.030817419597930e+03,		1.031267971777862e+03,
		1.031717379091161e+03,		1.032165647940899e+03,		1.032612784675323e+03,		1.033058795588487e+03,		1.033503686920869e+03,
		1.033947464859992e+03,		1.034390135541023e+03,		1.034831705047373e+03,		1.035272179411284e+03,		1.035711564614408e+03,
		1.036149866588377e+03,		1.036587091215368e+03,		1.037023244328658e+03,		1.037458331713169e+03,		1.037892359106010e+03,
		1.038325332197007e+03,		1.038757256629229e+03,		1.039188137999504e+03,		1.039617981858931e+03,		1.040046793713380e+03,
		1.040474579023990e+03,		1.040901343207657e+03,		1.041327091637520e+03,		1.041751829643429e+03,		1.042175562512422e+03,
		1.042598295489185e+03,		1.043020033776508e+03,		1.043440782535736e+03,		1.043860546887214e+03,		1.044279331910723e+03,
		1.044697142645917e+03,		1.045113984092742e+03,		1.045529861211868e+03,		1.045944778925093e+03,		1.046358742115760e+03,
		1.046771755629159e+03,		1.047183824272925e+03,		1.047594952817435e+03,		1.048005145996195e+03,		1.048414408506220e+03,
		1.048822745008420e+03,		1.049230160127964e+03,		1.049636658454660e+03,		1.050042244543307e+03,		1.050446922914064e+03,
		1.050850698052800e+03,		1.051253574411442e+03,		1.051655556408326e+03,		1.052056648428536e+03,		1.052456854824237e+03,
		1.052856179915011e+03,		1.053254627988188e+03,		1.053652203299163e+03,		1.054048910071721e+03,		1.054444752498352e+03,
		1.054839734740564e+03,		1.055233860929188e+03,		1.055627135164686e+03,		1.056019561517446e+03,		1.056411144028085e+03,
		1.056801886707741e+03,		1.057191793538356e+03,		1.057580868472969e+03,		1.057969115435997e+03,		1.058356538323511e+03,
		1.058743141003513e+03,		1.059128927316210e+03,		1.059513901074278e+03,		1.059898066063132e+03,		1.060281426041188e+03,
		1.060663984740119e+03,		1.061045745865112e+03,		1.061426713095125e+03,		1.061806890083130e+03,		1.062186280456365e+03,
		1.062564887816576e+03,		1.062942715740259e+03,		1.063319767778897e+03,		1.063696047459196e+03,		1.064071558283317e+03,
		1.064446303729106e+03,		1.064820287250323e+03,		1.065193512276863e+03,		1.065565982214980e+03,		1.065937700447505e+03,
		1.066308670334065e+03,		1.066678895211294e+03,		1.067048378393049e+03,		1.067417123170613e+03,		1.067785132812908e+03,
		1.068152410566694e+03,		1.068518959656777e+03,		1.068884783286202e+03,		1.069249884636457e+03,		1.069614266867665e+03,
		1.069977933118774e+03,		1.070340886507754e+03,		1.070703130131783e+03,		1.071064667067431e+03,		1.071425500370848e+03,
		1.071785633077945e+03,		1.072145068204574e+03,		1.072503808746706e+03,		1.072861857680609e+03,		1.073219217963019e+03,
		1.073575892531318e+03,		1.073931884303696e+03,		1.074287196179330e+03,		1.074641831038542e+03,		1.074995791742967e+03
	},
	{
		1.624461372646806e+00,		4.912969995811825e+00,		8.251378505360515e+00,		1.164150564080904e+01,		1.508527590964717e+01,
		1.858472771899222e+01,		2.214202228975470e+01,		2.575945344473577e+01,		2.943945837466032e+01,		3.318462950072769e+01,
		3.699772756918999e+01,		4.088169613317443e+01,		4.483967759996123e+01,		4.887503104883205e+01,		5.299135205615401e+01,
		5.719249480146215e+01,		6.148259677202724e+01,		6.586610643506121e+01,		7.034781430790157e+01,		7.493288792915384e+01,
		7.962691132017606e+01,		8.443592962927191e+01,		8.936649977388663e+01,		9.442574804301985e+01,		9.962143579776556e+01,
		1.049620346179865e+02,		1.104568124940706e+02,		1.161159329617062e+02,		1.219505694322299e+02,		1.279730373886402e+02,
		1.341969476032822e+02,		1.406373840883827e+02,		1.473111111062286e+02,		1.542368142142157e+02,		1.614353809386457e+02,
		1.689302271339311e+02,		1.767476751511158e+02,		1.849173891703466e+02,		1.934728706504315e+02,		2.024520113994701e+02,
		2.118976907889126e+02,		2.218583828335863e+02,		2.323887010643944e+02,		2.435497429409095e+02,		2.554089847873688e+02,
		2.680393051984943e+02,		2.815164755600678e+02,		2.959142001517336e+02,		3.112956812925540e+02,		3.277010201462474e+02,
		3.451307267991148e+02,		3.635268461726915e+02,		3.827541816356846e+02,		4.025859810811492e+02,		4.227035302382222e+02,
		4.427231966503786e+02,		4.622546452435047e+02,		4.809745240572636e+02,		4.986717859049515e+02,		5.152298222588195e+02,
		5.306182430383955e+02,		5.448677872174850e+02,		5.580457551213573e+02,		5.702375915486866e+02,		5.815346939837139e+02,
		5.920269885415892e+02,		6.017987861167455e+02,		6.109267888783263e+02,		6.194794514173747e+02,		6.275171454764370e+02,
		6.350927550808123e+02,		6.422524607841331e+02,		6.490365672772849e+02,		6.554802940422787e+02,		6.616144906333034e+02,
		6.674662631721627e+02,		6.730595124306346e+02,		6.784153906795843e+02,		6.835526872019817e+02,		6.884881528358281e+02,
		6.932367732513823e+02,		6.978119995235647e+02,		7.022259432919608e+02,		7.064895425892963e+02,		7.106127033447574e+02,
		7.146044206560640e+02,		7.184728831688540e+02,		7.222255632870761e+02,		7.258692954417859e+02,		7.294103442470946e+02,
		7.328544640519094e+02,		7.362069511385580e+02,		7.394726896115457e+02,		7.426561918509481e+02,		7.457616342671843e+02,
		7.487928889810250e+02,		7.517535519591111e+02,		7.546469680578326e+02,		7.574762533634765e+02,		7.602443151621499e+02,
		7.629538698270995e+02,		7.656074588720244e+02,		7.682074633859971e+02,		7.707561170372865e+02,		7.732555178092321e+02,
		7.757076386105659e+02,		7.781143368847240e+02,		7.804773633272291e+02,		7.827983698070119e+02,		7.850789165758817e+02,
		7.873204788404473e+02,		7.895244527619813e+02,		7.916921609422326e+02,		7.938248574464653e+02,		7.959237324093255e+02,
		7.979899162639508e+02,		8.000244836303880e+02,		8.020284568954204e+02,		8.040028095124870e+02,		8.059484690473447e+02,
		8.078663199924497e+02,		8.097572063706627e+02,		8.116219341468052e+02,		8.134612734637045e+02,		8.152759607177595e+02,
		8.170667004875570e+02,		8.188341673277685e+02,		8.205790074394135e+02,		8.223018402264969e+02,		8.240032597481348e+02,
		8.256838360744105e+02,		8.273441165534944e+02,		8.289846269968544e+02,		8.306058727887868e+02,		8.322083399259799e+02,
		8.337924959922925e+02,		8.353587910734968e+02,		8.369076586163604e+02,		8.384395162360515e+02,		8.399547664755194e+02,
		8.414537975202321e+02,		8.429369838713507e+02,		8.444046869802035e+02,		8.458572558466678e+02,		8.472950275838831e+02,
		8.487183279515426e+02,		8.501274718598013e+02,		8.515227638457243e+02,		8.529044985240394e+02,		8.542729610138232e+02,
		8.556284273426389e+02,		8.569711648295219e+02,		8.583014324481442e+02,		8.596194811713302e+02,		8.609255542980897e+02,
		8.622198877641898e+02,		8.635027104372607e+02,		8.647742443973244e+02,		8.660347052036221e+02,		8.672843021485039e+02,
		8.685232384991440e+02,		8.697517117277486e+02,		8.709699137309294e+02,		8.721780310388189e+02,		8.733762450145102e+02,
		8.745647320443508e+02,		8.757436637195722e+02,		8.769132070097361e+02,		8.780735244284309e+02,		8.792247741916157e+02,
		8.803671103690147e+02,		8.815006830289111e+02,		8.826256383766824e+02,		8.837421188874048e+02,		8.848502634328173e+02,
		8.859502074029332e+02,		8.870420828225704e+02,		8.881260184630455e+02,		8.892021399492751e+02,		8.902705698624985e+02,
		8.913314278388514e+02,		8.923848306639643e+02,		8.934308923638063e+02,		8.944697242919169e+02,		8.955014352132313e+02,
		8.965261313846213e+02,		8.975439166323373e+02,		8.985548924264714e+02,		8.995591579525820e+02,		9.005568101806193e+02,
		9.015479439312531e+02,		9.025326519397385e+02,		9.035110249174131e+02,		9.044831516109446e+02,		9.054491188594079e+02,
		9.064090116493049e+02,		9.073629131676048e+02,		9.083109048528925e+02,		9.092530664447007e+02,		9.101894760311134e+02,
		9.111202100946994e+02,		9.120453435568581e+02,		9.129649498206304e+02,		9.138791008120518e+02,		9.147878670200921e+02,
		9.156913175352532e+02,		9.165895200868705e+02,		9.174825410791670e+02,		9.183704456261199e+02,		9.192532975851798e+02,
		9.201311595898858e+02,		9.210040930814256e+02,		9.218721583391754e+02,		9.227354145102644e+02,		9.235939196381937e+02,
		9.244477306905586e+02,		9.252969035858891e+02,		9.261414932196592e+02,		9.269815534894904e+02,		9.278171373195705e+02,
		9.286482966843332e+02,		9.294750826314095e+02,		9.302975453038864e+02,		9.311157339619008e+02,		9.319296970035788e+02,
		9.327394819853574e+02,		9.335451356417110e+02,		9.343467039042885e+02,		9.351442319204971e+02,		9.359377640715468e+02,
		9.367273439899777e+02,		9.375130145766756e+02,		9.382948180174080e+02,		9.390727957988958e+02,		9.398469887244222e+02,
		9.406174369290140e+02,		9.413841798941899e+02,		9.421472564623101e+02,		9.429067048505237e+02,		9.436625626643374e+02,
		9.444148669108140e+02,		9.451636540114090e+02,		9.459089598144732e+02,		9.466508196074062e+02,		9.473892681284938e+02,
		9.481243395784325e+02,		9.488560676315442e+02,		9.495844854467075e+02,		9.503096256779918e+02,		9.510315204850220e+02,
		9.517502015430788e+02,		9.524657000529321e+02,		9.531780467504321e+02,		9.538872719158485e+02,		9.545934053829802e+02,
		9.552964765480311e+02,		9.559965143782741e+02,		9.566935474204819e+02,		9.573876038091666e+02,		9.580787112746096e+02,
		9.587668971506931e+02,		9.594521883825414e+02,		9.601346115339828e+02,		9.608141927948218e+02,		9.614909579879467e+02,
		9.621649325762603e+02,		9.628361416694461e+02,		9.635046100305842e+02,		9.641703620825957e+02,		9.648334219145507e+02,
		9.654938132878221e+02,		9.661515596420952e+02,		9.668066841012451e+02,		9.674592094790737e+02,		9.681091582849180e+02,
		9.687565527291277e+02,		9.694014147284269e+02,		9.700437659111429e+02,		9.706836276223280e+02,		9.713210209287621e+02,
		9.719559666238463e+02,		9.725884852323846e+02,		9.732185970152660e+02,		9.738463219740373e+02,		9.744716798553859e+02,
		9.750946901555091e+02,		9.757153721244106e+02,		9.763337447700817e+02,		9.769498268626143e+02,		9.775636369382086e+02,
		9.781751933031049e+02,		9.787845140374332e+02,		9.793916169989751e+02,		9.799965198268551e+02,		9.805992399451433e+02,
		9.811997945663998e+02,		9.817982006951304e+02,		9.823944751311788e+02,		9.829886344730485e+02,		9.835806951211532e+02,
		9.841706732810081e+02,		9.847585849663508e+02,		9.853444460021994e+02,		9.859282720278510e+02,		9.865100784998233e+02,
		9.870898806947315e+02,		9.876676937121106e+02,		9.882435324771837e+02,		9.888174117435752e+02,		9.893893460959672e+02,
		9.899593499527130e+02,		9.905274375683863e+02,		9.910936230362948e+02,		9.916579202909365e+02,		9.922203431104140e+02,
		9.927809051187963e+02,		9.933396197884439e+02,		9.938965004422844e+02,		9.944515602560455e+02,		9.950048122604461e+02,
		9.955562693433518e+02,		9.961059442518774e+02,		9.966538495944673e+02,		9.971999978429204e+02,		9.977444013343928e+02,
		9.982870722733518e+02,		9.988280227335002e+02,		9.993672646596660e+02,		9.999048098696533e+02,		1.000440670056063e+03,
		1.000974856788082e+03,		1.001507381513239e+03,		1.002038255559123e+03,		1.002567490135081e+03,		1.003095096333881e+03,
		1.003621085133344e+03,		1.004145467397947e+03,		1.004668253880405e+03,		1.005189455223214e+03,		1.005709081960178e+03,
		1.006227144517900e+03,		1.006743653217257e+03,		1.007258618274835e+03,		1.007772049804363e+03,		1.008283957818091e+03,
		1.008794352228179e+03,		1.009303242848029e+03,		1.009810639393622e+03,		1.010316551484812e+03,		1.010820988646616e+03,
		1.011323960310465e+03,		1.011825475815448e+03,		1.012325544409528e+03,		1.012824175250735e+03,		1.013321377408355e+03,
		1.013817159864076e+03,		1.014311531513136e+03,		1.014804501165440e+03,		1.015296077546664e+03,		1.015786269299335e+03,
		1.016275084983906e+03,		1.016762533079799e+03,		1.017248621986440e+03,		1.017733360024278e+03,		1.018216755435779e+03,
		1.018698816386415e+03,		1.019179550965634e+03,		1.019658967187808e+03,		1.020137072993172e+03,		1.020613876248751e+03,
		1.021089384749267e+03,		1.021563606218032e+03,		1.022036548307834e+03,		1.022508218601797e+03,		1.022978624614240e+03,
		1.023447773791515e+03,		1.023915673512837e+03,		1.024382331091097e+03,		1.024847753773667e+03,		1.025311948743183e+03,
		1.025774923118336e+03,		1.026236683954628e+03,		1.026697238245129e+03,		1.027156592921227e+03,		1.027614754853350e+03,
		1.028071730851699e+03,		1.028527527666949e+03,		1.028982151990956e+03,		1.029435610457443e+03,		1.029887909642682e+03,
		1.030339056066164e+03,		1.030789056191256e+03,		1.031237916425855e+03,		1.031685643123026e+03,		1.032132242581637e+03,
		1.032577721046976e+03,		1.033022084711370e+03,		1.033465339714786e+03,		1.033907492145427e+03,		1.034348548040323e+03,
		1.034788513385906e+03,		1.035227394118581e+03,		1.035665196125290e+03,		1.036101925244069e+03,		1.036537587264589e+03,
		1.036972187928700e+03,		1.037405732930963e+03,		1.037838227919168e+03,		1.038269678494859e+03,		1.038700090213839e+03,
		1.039129468586673e+03,		1.039557819079184e+03,		1.039985147112944e+03,		1.040411458065752e+03,		1.040836757272114e+03,
		1.041261050023709e+03,		1.041684341569852e+03,		1.042106637117954e+03,		1.042527941833965e+03,		1.042948260842825e+03,
		1.043367599228900e+03,		1.043785962036413e+03,		1.044203354269870e+03,		1.044619780894485e+03,		1.045035246836588e+03,
		1.045449756984045e+03,		1.045863316186650e+03,		1.046275929256534e+03,		1.046687600968552e+03,		1.047098336060678e+03,
		1.047508139234380e+03,		1.047917015155007e+03,		1.048324968452156e+03,		1.048732003720042e+03,		1.049138125517866e+03,
		1.049543338370169e+03,		1.049947646767187e+03,		1.050351055165206e+03,		1.050753567986902e+03,		1.051155189621682e+03,
		1.051555924426024e+03,		1.051955776723809e+03,		1.052354750806646e+03,		1.052752850934200e+03,		1.053150081334507e+03,
		1.053546446204296e+03,		1.053941949709298e+03,		1.054336595984551e+03,		1.054730389134709e+03,		1.055123333234340e+03,
		1.055515432328225e+03,		1.055906690431644e+03,		1.056297111530677e+03,		1.056686699582481e+03,		1.057075458515570e+03,
		1.057463392230106e+03,		1.057850504598161e+03,		1.058236799463998e+03,		1.058622280644336e+03,		1.059006951928616e+03,
		1.059390817079262e+03,		1.059773879831943e+03,		1.060156143895828e+03,		1.060537612953837e+03,		1.060918290662892e+03,
		1.061298180654166e+03,		1.061677286533323e+03,		1.062055611880762e+03,		1.062433160251854e+03,		1.062809935177178e+03,
		1.063185940162751e+03,		1.063561178690263e+03,		1.063935654217299e+03,		1.064309370177566e+03,		1.064682329981114e+03,
		1.065054537014557e+03,		1.065425994641286e+03,		1.065796706201688e+03,		1.066166675013351e+03,		1.066535904371282e+03,
		1.066904397548105e+03,		1.067272157794274e+03,		1.067639188338267e+03,		1.068005492386791e+03,		1.068371073124977e+03,
		1.068735933716579e+03,		1.069100077304160e+03,		1.069463507009291e+03,		1.069826225932733e+03,		1.070188237154628e+03,
		1.070549543734681e+03,		1.070910148712343e+03,		1.071270055106993e+03,		1.071629265918113e+03,		1.071987784125467e+03,
		1.072345612689274e+03,		1.072702754550380e+03,		1.073059212630434e+03,		1.073414989832045e+03,		1.073770089038962e+03
	},
	{
		1.621434768952557e+00,		4.903587183304770e+00,		8.235219839032379e+00,		1.161812097149095e+01,		1.505418185062640e+01,
		1.854540461411652e+01,		2.209391084452955e+01,		2.570195097616381e+01,		2.937191462883278e+01,		3.310634197926466e+01,
		3.690793629631116e+01,		4.077957778418207e+01,		4.472433889889238e+01,		4.874550132756445e+01,		5.284657484881629e+01,
		5.703131832596236e+01,		6.130376312408940e+01,		6.566823928836291e+01,		7.012940487551921e+01,		7.469227889501815e+01,
		7.936227839270865e+01,		8.414526030041105e+01,		8.904756878229615e+01,		9.407608893658934e+01,		9.923830786273928e+01,
		1.045423842841020e+02,		1.099972281292562e+02,		1.156125917264602e+02,		1.213991745605947e+02,		1.273687438844736e+02,
		1.335342738685633e+02,		1.399101064118997e+02,		1.465121372096337e+02,		1.533580311487869e+02,		1.604674715213822e+02,
		1.678624477853935e+02,		1.755675864544056e+02,		1.836105287746903e+02,		1.920223564844856e+02,		2.008380619855717e+02,
		2.100970497080153e+02,		2.198436379768890e+02,		2.301274998351773e+02,		2.410039285691810e+02,		2.525337272887388e+02,
		2.647823889728241e+02,		2.778180502011585e+02,		2.917075002876798e+02,		3.065094197713432e+02,		3.222642214497631e+02,
		3.389805630066311e+02,		3.566196415367772e+02,		3.750792803959914e+02,		3.941808373242386e+02,		4.136647137420465e+02,
		4.332040460567552e+02,		4.524435408893349e+02,		4.710561150319721e+02,		4.888007878067132e+02,		5.055272638295842e+02,
		5.211666032115771e+02,		5.357167525312331e+02,		5.492200567164796e+02,		5.617442126374991e+02,		5.733686800023600e+02,
		5.841758777744319e+02,		5.942458661285458e+02,		6.036533898325870e+02,		6.124664729285385e+02,		6.207460015927454e+02,
		6.285459027602618e+02,		6.359136484629239e+02,		6.428909073740518e+02,		6.495142327673257e+02,		6.558157237645536e+02,
		6.618236282492586e+02,		6.675628752943438e+02,		6.730555361274579e+02,		6.783212184730113e+02,		6.833774016572429e+02,
		6.882397205354039e+02,		6.929222059780390e+02,		6.974374888678293e+02,		7.017969736144867e+02,		7.060109862568886e+02,
		7.100889013677338e+02,		7.140392512368533e+02,		7.178698201886931e+02,		7.215877263780177e+02,		7.251994929911469e+02,
		7.287111104425569e+02,		7.321280908838102e+02,		7.354555161211351e+02,		7.386980798589358e+02,		7.418601250406206e+02,
		7.449456769387374e+02,		7.479584725479641e+02,		7.509019867530568e+02,		7.537794556759329e+02,		7.565938975491823e+02,
		7.593481314154079e+02,		7.620447939113167e+02,		7.646863543610348e+02,		7.672751283737691e+02,		7.698132901158770e+02,
		7.723028834058043e+02,		7.747458317617902e+02,		7.771439475162935e+02,		7.794989400971865e+02,		7.818124235637621e+02,
		7.840859234752274e+02,		7.863208831601983e+02,		7.885186694478957e+02,		7.906805779147344e+02,		7.928078376940451e+02,
		7.949016158912858e+02,		7.969630216425230e+02,		7.989931098498452e+02,		8.009928846237419e+02,		8.029633024593768e+02,
		8.049052751708085e+02,		8.068196726047952e+02,		8.087073251535809e+02,		8.105690260841383e+02,		8.124055336995855e+02,
		8.142175733470089e+02,		8.160058392844695e+02,		8.177709964188364e+02,		8.195136819249246e+02,		8.212345067554968e+02,
		8.229340570507495e+02,		8.246128954551748e+02,		8.262715623489695e+02,		8.279105770004807e+02,		8.295304386456859e+02,
		8.311316275001286e+02,		8.327146057082778e+02,		8.342798182348788e+02,		8.358276937024868e+02,		8.373586451789541e+02,
		8.388730709184605e+02,		8.403713550592673e+02,		8.418538682811939e+02,		8.433209684255562e+02,		8.447730010800748e+02,
		8.462103001311012e+02,		8.476331882853183e+02,		8.490419775628883e+02,		8.504369697638900e+02,		8.518184569097765e+02,
		8.531867216613867e+02,		8.545420377150253e+02,		8.558846701779327e+02,		8.572148759244280e+02,		8.585329039338867e+02,
		8.598389956116632e+02,		8.611333850939492e+02,		8.624162995375383e+02,		8.636879593953653e+02,		8.649485786786543e+02,
		8.661983652064237e+02,		8.674375208431030e+02,		8.686662417248953e+02,		8.698847184755247e+02,		8.710931364119800e+02,
		8.722916757407570e+02,		8.734805117451698e+02,		8.746598149641643e+02,		8.758297513631213e+02,		8.769904824970598e+02,
		8.781421656666502e+02,		8.792849540673818e+02,		8.804189969322944e+02,		8.815444396685447e+02,		8.826614239881643e+02,
		8.837700880332724e+02,		8.848705664960540e+02,		8.859629907337194e+02,		8.870474888787398e+02,		8.881241859445494e+02,
		8.891932039269683e+02,		8.902546619015212e+02,		8.913086761168696e+02,		8.923553600845343e+02,		8.933948246650858e+02,
		8.944271781509536e+02,		8.954525263460448e+02,		8.964709726422690e+02,		8.974826180931567e+02,		8.984875614846874e+02,
		8.994858994034347e+02,		9.004777263021774e+02,		9.014631345630704e+02,		9.024422145584915e+02,		9.034150547096600e+02,
		9.043817415431246e+02,		9.053423597452230e+02,		9.062969922145851e+02,		9.072457201127652e+02,		9.081886229131005e+02,
		9.091257784478495e+02,		9.100572629536815e+02,		9.109831511156059e+02,		9.119035161093876e+02,		9.128184296425195e+02,
		9.137279619937942e+02,		9.146321820515655e+02,		9.155311573507071e+02,		9.164249541083683e+02,		9.173136372585271e+02,
		9.181972704854321e+02,		9.190759162559345e+02,		9.199496358507992e+02,		9.208184893949856e+02,		9.216825358869721e+02,
		9.225418332271604e+02,		9.233964382453631e+02,		9.242464067274475e+02,		9.250917934411398e+02,		9.259326521610428e+02,
		9.267690356928648e+02,		9.276009958969300e+02,		9.284285837109677e+02,		9.292518491721958e+02,		9.300708414387735e+02,
		9.308856088105942e+02,		9.316961987494607e+02,		9.325026578986735e+02,		9.333050321020520e+02,		9.341033664223805e+02,
		9.348977051593452e+02,		9.356880918669315e+02,		9.364745693703518e+02,		9.372571797824567e+02,		9.380359645197215e+02,
		9.388109643177436e+02,		9.395822192463417e+02,		9.403497687242142e+02,		9.411136515331970e+02,		9.418739058321335e+02,
		9.426305691703631e+02,		9.433836785008410e+02,		9.441332701929098e+02,		9.448793800447231e+02,		9.456220432953291e+02,
		9.463612946364595e+02,		9.470971682239718e+02,		9.478296976890200e+02,		9.485589161489155e+02,		9.492848562177116e+02,
		9.500075500165168e+02,		9.507270291835391e+02,		9.514433248838736e+02,		9.521564678190402e+02,		9.528664882362827e+02,
		9.535734159376315e+02,		9.542772802887372e+02,		9.549781102274932e+02,		9.556759342724251e+02,		9.563707805308989e+02,
		9.570626767071045e+02,		9.577516501098565e+02,		9.584377276602040e+02,		9.591209358988561e+02,		9.598013009934185e+02,
		9.604788487454806e+02,		9.611536045975078e+02,		9.618255936395808e+02,		9.624948406159853e+02,		9.631613699316341e+02,
		9.638252056583377e+02,		9.644863715409455e+02,		9.651448910033245e+02,		9.658007871542163e+02,		9.664540827929497e+02,
		9.671048004150291e+02,		9.677529622175913e+02,		9.683985901047473e+02,		9.690417056927873e+02,		9.696823303152937e+02,
		9.703204850281136e+02,		9.709561906142401e+02,		9.715894675885852e+02,		9.722203362026257e+02,		9.728488164489837e+02,
		9.734749280658746e+02,		9.740986905414741e+02,		9.747201231181895e+02,		9.753392447968448e+02,		9.759560743407582e+02,
		9.765706302797465e+02,		9.771829309140571e+02,		9.777929943181806e+02,		9.784008383446220e+02,		9.790064806275705e+02,
		9.796099385864906e+02,		9.802112294296617e+02,		9.808103701576219e+02,		9.814073775665431e+02,		9.820022682515514e+02,
		9.825950586099666e+02,		9.831857648444849e+02,		9.837744029662825e+02,		9.843609887980809e+02,		9.849455379771214e+02,
		9.855280659581119e+02,		9.861085880160820e+02,		9.866871192492140e+02,		9.872636745815921e+02,		9.878382687659093e+02,
		9.884109163861257e+02,		9.889816318600647e+02,		9.895504294419635e+02,		9.901173232249743e+02,		9.906823271436234e+02,
		9.912454549762077e+02,		9.918067203471657e+02,		9.923661367293794e+02,		9.929237174464578e+02,		9.934794756749644e+02,
		9.940334244465978e+02,		9.945855766503382e+02,		9.951359450345631e+02,		9.956845422091008e+02,		9.962313806472696e+02,
		9.967764726878612e+02,		9.973198305371017e+02,		9.978614662705694e+02,		9.984013918350723e+02,		9.989396190505081e+02,
		9.994761596116742e+02,		1.000011025090051e+03,		1.000544226935558e+03,		1.001075776478271e+03,		1.001605684930110e+03,
		1.002133963386506e+03,		1.002660622828023e+03,		1.003185674121969e+03,		1.003709128023959e+03,		1.004230995179469e+03,
		1.004751286125357e+03,		1.005270011291343e+03,		1.005787181001494e+03,		1.006302805475653e+03,		1.006816894830858e+03,
		1.007329459082741e+03,		1.007840508146889e+03,		1.008350051840195e+03,		1.008858099882180e+03,		1.009364661896292e+03,
		1.009869747411192e+03,		1.010373365861996e+03,		1.010875526591530e+03,		1.011376238851531e+03,		1.011875511803855e+03,
		1.012373354521642e+03,		1.012869775990482e+03,		1.013364785109544e+03,		1.013858390692704e+03,		1.014350601469637e+03,
		1.014841426086910e+03,		1.015330873109038e+03,		1.015818951019537e+03,		1.016305668221958e+03,		1.016791033040892e+03,
		1.017275053722985e+03,		1.017757738437903e+03,		1.018239095279313e+03,		1.018719132265826e+03,		1.019197857341944e+03,
		1.019675278378967e+03,		1.020151403175919e+03,		1.020626239460426e+03,		1.021099794889605e+03,		1.021572077050930e+03,
		1.022043093463077e+03,		1.022512851576775e+03,		1.022981358775621e+03,		1.023448622376905e+03,		1.023914649632403e+03,
		1.024379447729172e+03,		1.024843023790327e+03,		1.025305384875802e+03,		1.025766537983111e+03,		1.026226490048085e+03,
		1.026685247945610e+03,		1.027142818490340e+03,		1.027599208437417e+03,		1.028054424483162e+03,		1.028508473265766e+03,
		1.028961361365976e+03,		1.029413095307754e+03,		1.029863681558946e+03,		1.030313126531924e+03,		1.030761436584229e+03,
		1.031208618019203e+03,		1.031654677086613e+03,		1.032099619983259e+03,		1.032543452853580e+03,		1.032986181790252e+03,
		1.033427812834769e+03,		1.033868351978031e+03,		1.034307805160900e+03,		1.034746178274780e+03,		1.035183477162157e+03,
		1.035619707617150e+03,		1.036054875386053e+03,		1.036488986167863e+03,		1.036922045614806e+03,		1.037354059332849e+03,
		1.037785032882213e+03,		1.038214971777878e+03,		1.038643881490073e+03,		1.039071767444767e+03,		1.039498635024148e+03,
		1.039924489567108e+03,		1.040349336369699e+03,		1.040773180685602e+03,		1.041196027726586e+03,		1.041617882662950e+03,
		1.042038750623972e+03,		1.042458636698349e+03,		1.042877545934624e+03,		1.043295483341613e+03,		1.043712453888832e+03,
		1.044128462506901e+03,		1.044543514087966e+03,		1.044957613486091e+03,		1.045370765517665e+03,		1.045782974961792e+03,
		1.046194246560682e+03,		1.046604585020029e+03,		1.047013995009396e+03,		1.047422481162583e+03,		1.047830048077998e+03,
		1.048236700319018e+03,		1.048642442414354e+03,		1.049047278858397e+03,		1.049451214111577e+03,		1.049854252600700e+03,
		1.050256398719292e+03,		1.050657656827939e+03,		1.051058031254614e+03,		1.051457526295009e+03,		1.051856146212855e+03,
		1.052253895240247e+03,		1.052650777577954e+03,		1.053046797395739e+03,		1.053441958832655e+03,		1.053836265997361e+03,
		1.054229722968415e+03,		1.054622333794575e+03,		1.055014102495088e+03,		1.055405033059981e+03,		1.055795129450349e+03,
		1.056184395598634e+03,		1.056572835408902e+03,		1.056960452757128e+03,		1.057347251491454e+03,		1.057733235432471e+03,
		1.058118408373475e+03,		1.058502774080733e+03,		1.058886336293745e+03,		1.059269098725491e+03,		1.059651065062695e+03,
		1.060032238966066e+03,		1.060412624070551e+03,		1.060792223985574e+03,		1.061171042295279e+03,		1.061549082558771e+03,
		1.061926348310346e+03,		1.062302843059728e+03,		1.062678570292297e+03,		1.063053533469312e+03,		1.063427736028148e+03,
		1.063801181382501e+03,		1.064173872922622e+03,		1.064545814015521e+03,		1.064917008005195e+03,		1.065287458212827e+03,
		1.065657167937002e+03,		1.066026140453912e+03,		1.066394379017561e+03,		1.066761886859967e+03,		1.067128667191361e+03,
		1.067494723200388e+03,		1.067860058054295e+03,		1.068224674899132e+03,		1.068588576859938e+03,		1.068951767040930e+03,
		1.069314248525693e+03,		1.069676024377360e+03,		1.070037097638799e+03,		1.070397471332789e+03,		1.070757148462199e+03,
		1.071116132010169e+03,		1.071474424940278e+03,		1.071832030196720e+03,		1.072188950704476e+03,		1.072545189369477e+03
	},
	{
		1.618419565827876e+00,		4.894241501075241e+00,		8.219128311738192e+00,		1.159483826898941e+01,		1.502323001732572e+01,
		1.850627011996283e+01,		2.204604131155704e+01,		2.564475153850028e+01,		2.930474387772251e+01,		3.302850743725386e+01,
		3.681868935602897e+01,		4.067810803688729e+01,		4.460976776583262e+01,		4.861687489283091e+01,		5.270285577531004e+01,
		5.687137671574538e+01,		6.112636616007123e+01,		6.547203946510389e+01,		6.991292659183183e+01,		7.445390313868045e+01,
		7.910022519629574e+01,		8.385756858491415e+01,		8.873207312922383e+01,		9.373039273635749e+01,		9.885975217325043e+01,
		1.041280115933510e+02,		1.095437400431291e+02,		1.151162993895845e+02,		1.208559403541704e+02,		1.267739126181941e+02,
		1.328825912791605e+02,		1.391956222809171e+02,		1.457280897977810e+02,		1.524967088925810e+02,		1.595200470308831e+02,
		1.668187781101908e+02,		1.744159723629742e+02,		1.823374244865813e+02,		1.906120200790291e+02,		1.992721359669784e+02,
		2.083540617123694e+02,		2.178984148655469e+02,		2.279504972201802e+02,		2.385604970791171e+02,		2.497833746653450e+02,
		2.616781649256001e+02,		2.743062909401522e+02,		2.877283229096728e+02,		3.019985183126279e+02,		3.171565914481373e+02,
		3.332166520911996e+02,		3.501540912054846e+02,		3.678920230477324e+02,		3.862895854281815e+02,		4.051358233791968e+02,
		4.241555285734421e+02,		4.430337812113557e+02,		4.614583368259434e+02,		4.791688135920606e+02,		4.959891892757875e+02,
		5.118171451105078e+02,		5.266185125083584e+02,		5.404095769007772e+02,		5.532385802660609e+02,		5.651712184138355e+02,
		5.762806388015574e+02,		5.866410474313351e+02,		5.963238610096200e+02,		6.053955723805266e+02,		6.139167489491555e+02,
		6.219417622565273e+02,		6.295189657330317e+02,		6.366911224746150e+02,		6.434959491889726e+02,		6.499666910825472e+02,
		6.561326776074914e+02,		6.620198329114273e+02,		6.676511301032206e+02,		6.730469875362193e+02,		6.782256102605496e+02,
		6.832032821312198e+02,		6.879946148356457e+02,		6.926127600147300e+02,		6.970695901299823e+02,		7.013758530335098e+02,
		7.055413044737950e+02,		7.095748220924883e+02,		7.134845038691303e+02,		7.172777534604332e+02,		7.209613544550776e+02,
		7.245415352147201e+02,		7.280240256856828e+02,		7.314141073330842e+02,		7.347166571595696e+02,		7.379361866164676e+02,
		7.410768760888192e+02,		7.441426055319403e+02,		7.471369817513560e+02,		7.500633627467718e+02,		7.529248794811513e+02,
		7.557244553860962e+02,		7.584648238724242e+02,		7.611485440791785e+02,		7.637780150637706e+02,		7.663554886099569e+02,
		7.688830808079964e+02,		7.713627825421223e+02,		7.737964690038474e+02,		7.761859083353082e+02,		7.785327694943846e+02,
		7.808386294225070e+02,		7.831049795866534e+02,		7.853332319588285e+02,		7.875247244891212e+02,		7.896807261221466e+02,
		7.918024414011688e+02,		7.938910146993711e+02,		7.959475341134425e+02,		7.979730350509335e+02,		7.999685035395042e+02,
		8.019348792832599e+02,		8.038730584887734e+02,		8.057838964811265e+02,		8.076682101282321e+02,		8.095267800899010e+02,
		8.113603529065222e+02,		8.131696429407606e+02,		8.149553341844186e+02,		8.167180819414556e+02,		8.184585143971369e+02,
		8.201772340823583e+02,		8.218748192413726e+02,		8.235518251104311e+02,		8.252087851141343e+02,		8.268462119857394e+02,
		8.284645988170978e+02,		8.300644200434421e+02,		8.316461323677494e+02,		8.332101756290723e+02,		8.347569736188249e+02,
		8.362869348486836e+02,		8.378004532735029e+02,		8.392979089723249e+02,		8.407796687903671e+02,		8.422460869445921e+02,
		8.436975055953192e+02,		8.451342553861140e+02,		8.465566559540100e+02,		8.479650164120166e+02,		8.493596358056545e+02,
		8.507408035451917e+02,		8.521087998150831e+02,		8.534638959620495e+02,		8.548063548630892e+02,		8.561364312746691e+02,
		8.574543721642095e+02,		8.587604170249302e+02,		8.600547981750397e+02,		8.613377410421989e+02,		8.626094644340875e+02,
		8.638701807958977e+02,		8.651200964554967e+02,		8.663594118569401e+02,		8.675883217830090e+02,		8.688070155673655e+02,
		8.700156772969059e+02,		8.712144860048437e+02,		8.724036158550249e+02,		8.735832363179427e+02,		8.747535123389044e+02,
		8.759146044987388e+02,		8.770666691674733e+02,		8.782098586513064e+02,		8.793443213332431e+02,		8.804702018077120e+02,
		8.815876410094718e+02,		8.826967763370789e+02,		8.837977417712083e+02,		8.848906679880660e+02,		8.859756824681509e+02,
		8.870529096005604e+02,		8.881224707830976e+02,		8.891844845183492e+02,		8.902390665059347e+02,		8.912863297311146e+02,
		8.923263845499196e+02,		8.933593387709645e+02,		8.943852977341065e+02,		8.954043643860797e+02,		8.964166393532545e+02,
		8.974222210116537e+02,		8.984212055543279e+02,		8.994136870562371e+02,		9.003997575367291e+02,		9.013795070197179e+02,
		9.023530235916853e+02,		9.033203934575689e+02,		9.042817009946499e+02,		9.052370288045217e+02,		9.061864577632109e+02,
		9.071300670695383e+02,		9.080679342917952e+02,		9.090001354127975e+02,		9.099267448733794e+02,		9.108478356144174e+02,
		9.117634791174077e+02,		9.126737454436828e+02,		9.135787032723130e+02,		9.144784199367465e+02,		9.153729614602281e+02,
		9.162623925900657e+02,		9.171467768307682e+02,		9.180261764761171e+02,		9.189006526401913e+02,		9.197702652874152e+02,
		9.206350732616332e+02,		9.214951343142798e+02,		9.223505051316514e+02,		9.232012413613357e+02,		9.240473976378181e+02,
		9.248890276072958e+02,		9.257261839517362e+02,		9.265589184121989e+02,		9.273872818114530e+02,		9.282113240759119e+02,
		9.290310942569164e+02,		9.298466405513805e+02,		9.306580103218312e+02,		9.314652501158542e+02,		9.322684056849772e+02,
		9.330675220030043e+02,		9.338626432838161e+02,		9.346538129986687e+02,		9.354410738929859e+02,		9.362244680026911e+02,
		9.370040366700661e+02,		9.377798205591693e+02,		9.385518596708278e+02,		9.393201933572080e+02,		9.400848603359901e+02,
		9.408458987041470e+02,		9.416033459513583e+02,		9.423572389730519e+02,		9.431076140830945e+02,		9.438545070261484e+02,
		9.445979529896933e+02,		9.453379866157314e+02,		9.460746420121815e+02,		9.468079527639798e+02,		9.475379519438841e+02,
		9.482646721230041e+02,		9.489881453810561e+02,		9.497084033163541e+02,		9.504254770555488e+02,		9.511393972631163e+02,
		9.518501941506083e+02,		9.525578974856726e+02,		9.532625366008397e+02,		9.539641404021005e+02,		9.546627373772644e+02,
		9.553583556041198e+02,		9.560510227583820e+02,		9.567407661214596e+02,		9.574276125880272e+02,		9.581115886734135e+02,
		9.587927205208174e+02,		9.594710339083474e+02,		9.601465542558911e+02,		9.608193066318327e+02,		9.614893157595992e+02,
		9.621566060240636e+02,		9.628212014777930e+02,		9.634831258471525e+02,		9.641424025382712e+02,		9.647990546428662e+02,
		9.654531049439387e+02,		9.661045759213367e+02,		9.667534897571925e+02,		9.673998683412367e+02,		9.680437332759972e+02,
		9.686851058818759e+02,		9.693240072021177e+02,		9.699604580076642e+02,		9.705944788019084e+02,		9.712260898253336e+02,
		9.718553110600651e+02,		9.724821622343090e+02,		9.731066628267055e+02,		9.737288320705826e+02,		9.743486889581212e+02,
		9.749662522444308e+02,		9.755815404515356e+02,		9.761945718722831e+02,		9.768053645741621e+02,		9.774139364030472e+02,
		9.780203049868612e+02,		9.786244877391647e+02,		9.792265018626648e+02,		9.798263643526631e+02,		9.804240920004186e+02,
		9.810197013964556e+02,		9.816132089337905e+02,		9.822046308111082e+02,		9.827939830358630e+02,		9.833812814273191e+02,
		9.839665416195352e+02,		9.845497790642866e+02,		9.851310090339241e+02,		9.857102466241926e+02,		9.862875067569677e+02,
		9.868628041829671e+02,		9.874361534843900e+02,		9.880075690775134e+02,		9.885770652152332e+02,		9.891446559895631e+02,
		9.897103553340766e+02,		9.902741770263126e+02,		9.908361346901252e+02,		9.913962417979958e+02,		9.919545116732969e+02,
		9.925109574925184e+02,		9.930655922874477e+02,		9.936184289473099e+02,		9.941694802208708e+02,		9.947187587184944e+02,
		9.952662769141753e+02,		9.958120471475163e+02,		9.963560816256835e+02,		9.968983924253234e+02,		9.974389914944351e+02,
		9.979778906542242e+02,		9.985151016009120e+02,		9.990506359075134e+02,		9.995845050255896e+02,		1.000116720286961e+03,
		1.000647292905395e+03,		1.001176233978263e+03,		1.001703554488169e+03,		1.002229265304542e+03,		1.002753377185216e+03,
		1.003275900777963e+03,		1.003796846622020e+03,		1.004316225149570e+03,		1.004834046687213e+03,		1.005350321457399e+03,
		1.005865059579850e+03,		1.006378271072940e+03,		1.006889965855074e+03,		1.007400153746022e+03,		1.007908844468244e+03,
		1.008416047648186e+03,		1.008921772817561e+03,		1.009426029414599e+03,		1.009928826785286e+03,		1.010430174184576e+03,
		1.010930080777585e+03,		1.011428555640764e+03,		1.011925607763057e+03,		1.012421246047033e+03,		1.012915479310007e+03,
		1.013408316285138e+03,		1.013899765622509e+03,		1.014389835890192e+03,		1.014878535575297e+03,		1.015365873084997e+03,
		1.015851856747547e+03,		1.016336494813277e+03,		1.016819795455577e+03,		1.017301766771859e+03,		1.017782416784513e+03,
		1.018261753441837e+03,		1.018739784618961e+03,		1.019216518118758e+03,		1.019691961672727e+03,		1.020166122941877e+03,
		1.020639009517596e+03,		1.021110628922495e+03,		1.021580988611252e+03,		1.022050095971436e+03,		1.022517958324319e+03,
		1.022984582925678e+03,		1.023449976966586e+03,		1.023914147574185e+03,		1.024377101812451e+03,		1.024838846682951e+03,
		1.025299389125581e+03,		1.025758736019300e+03,		1.026216894182848e+03,		1.026673870375458e+03,		1.027129671297552e+03,
		1.027584303591433e+03,		1.028037773841959e+03,		1.028490088577217e+03,		1.028941254269176e+03,		1.029391277334340e+03,
		1.029840164134389e+03,		1.030287920976803e+03,		1.030734554115491e+03,		1.031180069751399e+03,		1.031624474033113e+03,
		1.032067773057457e+03,		1.032509972870075e+03,		1.032951079466016e+03,		1.033391098790295e+03,		1.033830036738464e+03,
		1.034267899157156e+03,		1.034704691844642e+03,		1.035140420551360e+03,		1.035575090980451e+03,		1.036008708788280e+03,
		1.036441279584954e+03,		1.036872808934830e+03,		1.037303302357018e+03,		1.037732765325875e+03,		1.038161203271492e+03,
		1.038588621580181e+03,		1.039015025594940e+03,		1.039440420615934e+03,		1.039864811900947e+03,		1.040288204665842e+03,
		1.040710604085011e+03,		1.041132015291817e+03,		1.041552443379033e+03,		1.041971893399273e+03,		1.042390370365420e+03,
		1.042807879251043e+03,		1.043224424990813e+03,		1.043640012480915e+03,		1.044054646579447e+03,		1.044468332106824e+03,
		1.044881073846165e+03,		1.045292876543687e+03,		1.045703744909085e+03,		1.046113683615910e+03,		1.046522697301943e+03,
		1.046930790569563e+03,		1.047337967986113e+03,		1.047744234084250e+03,		1.048149593362311e+03,		1.048554050284658e+03,
		1.048957609282018e+03,		1.049360274751832e+03,		1.049762051058586e+03,		1.050162942534144e+03,		1.050562953478079e+03,
		1.050962088157994e+03,		1.051360350809842e+03,		1.051757745638240e+03,		1.052154276816788e+03,		1.052549948488367e+03,
		1.052944764765450e+03,		1.053338729730400e+03,		1.053731847435765e+03,		1.054124121904575e+03,		1.054515557130626e+03,
		1.054906157078771e+03,		1.055295925685196e+03,		1.055684866857706e+03,		1.056072984475994e+03,		1.056460282391916e+03,
		1.056846764429759e+03,		1.057232434386510e+03,		1.057617296032107e+03,		1.058001353109714e+03,		1.058384609335962e+03,
		1.058767068401213e+03,		1.059148733969805e+03,		1.059529609680294e+03,		1.059909699145710e+03,		1.060289005953785e+03,
		1.060667533667201e+03,		1.061045285823819e+03,		1.061422265936915e+03,		1.061798477495409e+03,		1.062173923964091e+03,
		1.062548608783845e+03,		1.062922535371875e+03,		1.063295707121919e+03,		1.063668127404467e+03,		1.064039799566978e+03,
		1.064410726934090e+03,		1.064780912807827e+03,		1.065150360467810e+03,		1.065519073171457e+03,		1.065887054154190e+03,
		1.066254306629629e+03,		1.066620833789794e+03,		1.066986638805300e+03,		1.067351724825548e+03,		1.067716094978917e+03,
		1.068079752372952e+03,		1.068442700094552e+03,		1.068804941210154e+03,		1.069166478765912e+03,		1.069527315787885e+03,
		1.069887455282207e+03,		1.070246900235268e+03,		1.070605653613889e+03,		1.070963718365492e+03,		1.071321097418270e+03
	},
	{
		1.615415697813696e+00,		4.884932718009696e+00,		8.203103472953099e+00,		1.157165679898579e+01,		1.499241931460579e+01,
		1.846732268848130e+01,		2.199841157982118e+01,		2.558785232624936e+01,		2.923794246417136e+01,		3.295112117793405e+01,
		3.672998078711312e+01,		4.057727939630671e+01,		4.449595484921412e+01,		4.848914014894481e+01,		5.256018052991856e+01,
		5.671265239396030e+01,		6.095038435494301e+01,		6.527748067339925e+01,		6.969834740586177e+01,		7.421772164443600e+01,
		7.884070428157506e+01,		8.357279680476800e+01,		8.841994270765241e+01,		9.338857419995537e+01,		9.848566501092658e+01,
		1.037187902120083e+02,		1.090961941368912e+02,		1.146268676531645e+02,		1.203206362411394e+02,		1.261882605623710e+02,
		1.322415514503617e+02,		1.384935015213467e+02,		1.449584358675324e+02,		1.516521845273212e+02,		1.585922795702458e+02,
		1.657981795898701e+02,		1.732915239973028e+02,		1.810964184676898e+02,		1.892397507395796e+02,		1.977515319218688e+02,
		2.066652512494979e+02,		2.160182197957058e+02,		2.258518577865819e+02,		2.362118461011958e+02,		2.471480088519285e+02,
		2.587137137572161e+02,		2.709644678172402e+02,		2.839552615224109e+02,		2.977361275081352e+02,		3.123454384709779e+02,
		3.278008107404211e+02,		3.440881319197018e+02,		3.611499698535583e+02,		3.788751975857586e+02,		3.970924300452969e+02,
		4.155714608304699e+02,		4.340380502888210e+02,		4.522041817075657e+02,		4.698073571553873e+02,		4.866494815323010e+02,
		5.026027895182411e+02,		5.176032662253945e+02,		5.316409526428627e+02,		5.447434452247304e+02,		5.569611979448598e+02,
		5.683565863161574e+02,		5.789965351365207e+02,		5.889478409394554e+02,		5.982743581866005e+02,		6.070354401696460e+02,
		6.152852178373460e+02,		6.230724270366580e+02,		6.304405775283496e+02,		6.374283164391878e+02,		6.440698845211411e+02,
		6.503955989378280e+02,		6.564323225096282e+02,		6.622038976854705e+02,		6.677315355642241e+02,		6.730341577022849e+02,
		6.781286926477815e+02,		6.830303312497908e+02,		6.877527456056844e+02,		6.923082765764900e+02,		6.967080944715959e+02,
		7.009623369983831e+02,		7.050802280165516e+02,		7.090701801003966e+02,		7.129398834281985e+02,		7.166963830984829e+02,
		7.203461466184276e+02,		7.238951230150032e+02,		7.273487947766423e+02,		7.307122236341494e+02,		7.339900910268035e+02,
		7.371867339660541e+02,		7.403061768996938e+02,		7.433521600889557e+02,		7.463281649361335e+02,		7.492374366378392e+02,
		7.520830044869000e+02,		7.548677001018094e+02,		7.575941738255051e+02,		7.602649095036187e+02,		7.628822378253348e+02,
		7.654483483868976e+02,		7.679653006179038e+02,		7.704350336933841e+02,		7.728593755397866e+02,		7.752400510301970e+02,
		7.775786894528385e+02,		7.798768313272215e+02,		7.821359346337763e+02,		7.843573805153520e+02,		7.865424785024613e+02,
		7.886924713084175e+02,		7.908085392354840e+02,		7.928918042287459e+02,		7.949433336104649e+02,		7.969641435242844e+02,
		7.989552021155848e+02,		8.009174324715643e+02,		8.028517153422813e+02,		8.047588916617256e+02,		8.066397648861119e+02,
		8.084951031649217e+02,		8.103256413586940e+02,		8.121320829162673e+02,		8.139151016229259e+02,		8.156753432298775e+02,
		8.174134269745257e+02,		8.191299470001159e+02,		8.208254736825781e+02,		8.225005548717022e+02,		8.241557170531320e+02,
		8.257914664371244e+02,		8.274082899795034e+02,		8.290066563397456e+02,		8.305870167808012e+02,		8.321498060147613e+02,
		8.336954429982438e+02,		8.352243316810018e+02,		8.367368617109878e+02,		8.382334090988644e+02,		8.397143368447011e+02,
		8.411799955293782e+02,		8.426307238730653e+02,		8.440668492629123e+02,		8.454886882519432e+02,		8.468965470310354e+02,
		8.482907218756565e+02,		8.496714995689754e+02,		8.510391578028168e+02,		8.523939655578047e+02,		8.537361834639991e+02,
		8.550660641431805e+02,		8.563838525338899e+02,		8.576897862002627e+02,		8.589840956255797e+02,		8.602670044914579e+02,
		8.615387299434888e+02,		8.627994828441088e+02,		8.640494680134210e+02,		8.652888844586514e+02,		8.665179255928692e+02,
		8.677367794435596e+02,		8.689456288516174e+02,		8.701446516612621e+02,		8.713340209013834e+02,		8.725139049587600e+02,
		8.736844677435865e+02,		8.748458688477127e+02,		8.759982636959729e+02,		8.771418036909624e+02,		8.782766363515971e+02,
		8.794029054457708e+02,		8.805207511174063e+02,		8.816303100081886e+02,		8.827317153742290e+02,		8.838250971979214e+02,
		8.849105822952246e+02,		8.859882944185889e+02,		8.870583543557290e+02,		8.881208800244628e+02,		8.891759865637766e+02,
		8.902237864213130e+02,		8.912643894374411e+02,		8.922979029260661e+02,		8.933244317523291e+02,		8.943440784073418e+02,
		8.953569430800894e+02,		8.963631237266214e+02,		8.973627161366669e+02,		8.983558139977729e+02,		8.993425089570862e+02,
		9.003228906808731e+02,		9.012970469118775e+02,		9.022650635246213e+02,		9.032270245787167e+02,		9.041830123702873e+02,
		9.051331074815780e+02,		9.060773888288210e+02,		9.070159337084407e+02,		9.079488178416607e+02,		9.088761154175769e+02,
		9.097978991347659e+02,		9.107142402414812e+02,		9.116252085745015e+02,		9.125308725966747e+02,		9.134312994332208e+02,
		9.143265549068349e+02,		9.152167035716429e+02,		9.161018087460461e+02,		9.169819325445128e+02,		9.178571359083385e+02,
		9.187274786354322e+02,		9.195930194091541e+02,		9.204538158262422e+02,		9.213099244238700e+02,		9.221614007058537e+02,
		9.230082991680591e+02,		9.238506733230178e+02,		9.246885757237952e+02,		9.255220579871381e+02,		9.263511708159126e+02,
		9.271759640208805e+02,		9.279964865418207e+02,		9.288127864680223e+02,		9.296249110581825e+02,		9.304329067597081e+02,
		9.312368192274713e+02,		9.320366933420094e+02,		9.328325732272052e+02,		9.336245022674686e+02,		9.344125231244142e+02,
		9.351966777530810e+02,		9.359770074176918e+02,		9.367535527069699e+02,		9.375263535490308e+02,		9.382954492258651e+02,
		9.390608783874203e+02,		9.398226790652978e+02,		9.405808886860789e+02,		9.413355440842925e+02,		9.420866815150276e+02,
		9.428343366662154e+02,		9.435785446705821e+02,		9.443193401172869e+02,		9.450567570632502e+02,		9.457908290441893e+02,
		9.465215890853671e+02,		9.472490697120577e+02,		9.479733029597525e+02,		9.486943203840897e+02,		9.494121530705464e+02,
		9.501268316438770e+02,		9.508383862773138e+02,		9.515468467015367e+02,		9.522522422134247e+02,		9.529546016845810e+02,
		9.536539535696564e+02,		9.543503259144626e+02,		9.550437463638879e+02,		9.557342421696239e+02,		9.564218401976980e+02,
		9.571065669358343e+02,		9.577884485006292e+02,		9.584675106445610e+02,		9.591437787628329e+02,		9.598172779000483e+02,
		9.604880327567424e+02,		9.611560676957436e+02,		9.618214067484040e+02,		9.624840736206750e+02,		9.631440916990420e+02,
		9.638014840563334e+02,		9.644562734573848e+02,		9.651084823645830e+02,		9.657581329432799e+02,		9.664052470670871e+02,
		9.670498463230499e+02,		9.676919520167093e+02,		9.683315851770477e+02,		9.689687665613239e+02,		9.696035166598152e+02,
		9.702358557004300e+02,		9.708658036532481e+02,		9.714933802349452e+02,		9.721186049131246e+02,		9.727414969105567e+02,
		9.733620752093362e+02,		9.739803585549314e+02,		9.745963654601691e+02,		9.752101142091169e+02,		9.758216228609023e+02,
		9.764309092534320e+02,		9.770379910070488e+02,		9.776428855281065e+02,		9.782456100124720e+02,		9.788461814489538e+02,
		9.794446166226622e+02,		9.800409321183004e+02,		9.806351443233889e+02,		9.812272694314235e+02,		9.818173234449706e+02,
		9.824053221787018e+02,		9.829912812623631e+02,		9.835752161436925e+02,		9.841571420912721e+02,		9.847370741973297e+02,
		9.853150273804816e+02,		9.858910163884237e+02,		9.864650558005712e+02,		9.870371600306405e+02,		9.876073433291939e+02,
		9.881756197861205e+02,		9.887420033330811e+02,		9.893065077458991e+02,		9.898691466469108e+02,		9.904299335072664e+02,
		9.909888816491947e+02,		9.915460042482147e+02,		9.921013143353185e+02,		9.926548247991004e+02,		9.932065483878570e+02,
		9.937564977116444e+02,		9.943046852442950e+02,		9.948511233254000e+02,		9.953958241622558e+02,		9.959387998317751e+02,
		9.964800622823612e+02,		9.970196233357502e+02,		9.975574946888206e+02,		9.980936879153666e+02,		9.986282144678444e+02,
		9.991610856790852e+02,		9.996923127639790e+02,		1.000221906821122e+03,		1.000749878834450e+03,		1.001276239674826e+03,
		1.001801000101609e+03,		1.002324170764196e+03,		1.002845762203535e+03,		1.003365784853611e+03,		1.003884249042907e+03,
		1.004401164995845e+03,		1.004916542834189e+03,		1.005430392578443e+03,		1.005942724149206e+03,		1.006453547368520e+03,
		1.006962871961184e+03,		1.007470707556053e+03,		1.007977063687308e+03,		1.008481949795716e+03,		1.008985375229856e+03,
		1.009487349247333e+03,		1.009987881015974e+03,		1.010486979614992e+03,		1.010984654036147e+03,		1.011480913184875e+03,
		1.011975765881405e+03,		1.012469220861857e+03,		1.012961286779320e+03,		1.013451972204917e+03,		1.013941285628851e+03,
		1.014429235461428e+03,		1.014915830034072e+03,		1.015401077600324e+03,		1.015884986336816e+03,		1.016367564344240e+03,
		1.016848819648299e+03,		1.017328760200632e+03,		1.017807393879748e+03,		1.018284728491917e+03,		1.018760771772073e+03,
		1.019235531384683e+03,		1.019709014924617e+03,		1.020181229917996e+03,		1.020652183823028e+03,		1.021121884030836e+03,
		1.021590337866268e+03,		1.022057552588696e+03,		1.022523535392808e+03,		1.022988293409378e+03,		1.023451833706034e+03,
		1.023914163288009e+03,		1.024375289098882e+03,		1.024835218021311e+03,		1.025293956877745e+03,		1.025751512431144e+03,
		1.026207891385667e+03,		1.026663100387364e+03,		1.027117146024854e+03,		1.027570034829994e+03,		1.028021773278533e+03,
		1.028472367790763e+03,		1.028921824732161e+03,		1.029370150414010e+03,		1.029817351094032e+03,		1.030263432976988e+03,
		1.030708402215288e+03,		1.031152264909584e+03,		1.031595027109355e+03,		1.032036694813483e+03,		1.032477273970827e+03,
		1.032916770480781e+03,		1.033355190193824e+03,		1.033792538912076e+03,		1.034228822389823e+03,		1.034664046334058e+03,
		1.035098216404998e+03,		1.035531338216603e+03,		1.035963417337080e+03,		1.036394459289391e+03,		1.036824469551743e+03,
		1.037253453558077e+03,		1.037681416698552e+03,		1.038108364320012e+03,		1.038534301726464e+03,		1.038959234179533e+03,
		1.039383166898920e+03,		1.039806105062850e+03,		1.040228053808517e+03,		1.040649018232521e+03,		1.041069003391299e+03,
		1.041488014301549e+03,		1.041906055940655e+03,		1.042323133247097e+03,		1.042739251120861e+03,		1.043154414423844e+03,
		1.043568627980249e+03,		1.043981896576984e+03,		1.044394224964044e+03,		1.044805617854895e+03,		1.045216079926858e+03,
		1.045625615821471e+03,		1.046034230144865e+03,		1.046441927468126e+03,		1.046848712327654e+03,		1.047254589225513e+03,
		1.047659562629786e+03,		1.048063636974915e+03,		1.048466816662049e+03,		1.048869106059369e+03,		1.049270509502431e+03,
		1.049671031294488e+03,		1.050070675706815e+03,		1.050469446979028e+03,		1.050867349319402e+03,		1.051264386905178e+03,
		1.051660563882875e+03,		1.052055884368593e+03,		1.052450352448313e+03,		1.052843972178190e+03,		1.053236747584854e+03,
		1.053628682665688e+03,		1.054019781389124e+03,		1.054410047694919e+03,		1.054799485494433e+03,		1.055188098670912e+03,
		1.055575891079747e+03,		1.055962866548757e+03,		1.056349028878443e+03,		1.056734381842255e+03,		1.057118929186850e+03,
		1.057502674632349e+03,		1.057885621872590e+03,		1.058267774575372e+03,		1.058649136382712e+03,		1.059029710911079e+03,
		1.059409501751641e+03,		1.059788512470502e+03,		1.060166746608934e+03,		1.060544207683614e+03,		1.060920899186850e+03,
		1.061296824586812e+03,		1.061671987327752e+03,		1.062046390830228e+03,		1.062420038491325e+03,		1.062792933684867e+03,
		1.063165079761637e+03,		1.063536480049582e+03,		1.063907137854029e+03,		1.064277056457886e+03,		1.064646239121851e+03,
		1.065014689084611e+03,		1.065382409563043e+03,		1.065749403752410e+03,		1.066115674826561e+03,		1.066481225938117e+03,
		1.066846060218668e+03,		1.067210180778957e+03,		1.067573590709072e+03,		1.067936293078623e+03,		1.068298290936932e+03,
		1.068659587313208e+03,		1.069020185216730e+03,		1.069380087637017e+03,		1.069739297544010e+03,		1.070097817888236e+03
	},
	{
		1.612423099963406e+00,		4.875660605025456e+00,		8.187144876518293e+00,		1.154857583491498e+01,		1.496174865981723e+01,
		1.842856079057092e+01,		2.195101956590596e+01,		2.553125057294989e+01,		2.917150678501867e+01,		3.287417857797085e+01,
		3.664180472684001e+01,		4.047708449818979e+01,		4.438289096946816e+01,		4.836228572492646e+01,		5.241853509883395e+01,
		5.655512816125176e+01,		6.077579667011312e+01,		6.508453724647192e+01,		6.948563606832846e+01,		7.398369642335652e+01,
		7.858366951322007e+01,		8.329088896323265e+01,		8.811110956229082e+01,		9.305055084088220e+01,		9.811594619124131e+01,
		1.033145983451599e+02,		1.086544421532355e+02,		1.141441157557851e+02,		1.197930414007937e+02,		1.256115173470702e+02,
		1.316108224874116e+02,		1.378033355283135e+02,		1.442026707527113e+02,		1.508238325398780e+02,		1.576833908691360e+02,
		1.647996799022747e+02,		1.721930212752915e+02,		1.798859726897094e+02,		1.879036003801858e+02,		1.962737704064973e+02,
		2.050274474469694e+02,		2.141989792394342e+02,		2.238263275470546e+02,		2.339511789093093e+02,		2.446188256995783e+02,
		2.558776451076596e+02,		2.677779186300579e+02,		2.803696369164603e+02,		2.936988603117999e+02,		3.078022319474829e+02,
		3.226994748215374e+02,		3.383841993350255e+02,		3.548139779360050e+02,		3.719011687486829e+02,		3.895064385606333e+02,
		4.074378153881642e+02,		4.254591571039203e+02,		4.433109232525396e+02,		4.607409649752551e+02,		4.775378126162166e+02,
		4.935539648798658e+02,		5.086999635919421e+02,		5.229405131785360e+02,		5.362819791478777e+02,		5.487584442266364e+02,
		5.604202624037800e+02,		5.713258468176732e+02,		5.815362134717103e+02,		5.911115289597925e+02,		6.001090303367719e+02,
		6.085818734213569e+02,		6.165786085914655e+02,		6.241430733082818e+02,		6.313145485872470e+02,		6.381280684841861e+02,
		6.446148045376443e+02,		6.508024731116604e+02,		6.567157333356934e+02,		6.623765575130966e+02,		6.678045654438403e+02,
		6.730173201734459e+02,		6.780305862450775e+02,		6.828585534136880e+02,		6.875140295913525e+02,		6.920086069607916e+02,
		6.963528050060219e+02,		7.005561938480275e+02,		7.046275008494074e+02,		7.085747030284635e+02,		7.124051074320486e+02,
		7.161254212718543e+02,		7.197418133336473e+02,		7.232599679208865e+02,		7.266851323879381e+02,		7.300221591478236e+02,
		7.332755428992521e+02,		7.364494537022239e+02,		7.395477664362522e+02,		7.425740870964573e+02,		7.455317763172285e+02,
		7.484239704584702e+02,		7.512536005434820e+02,		7.540234092987956e+02,		7.567359665134325e+02,		7.593936829070503e+02,
		7.619988226725153e+02,		7.645535148379198e+02,		7.670597635752669e+02,		7.695194575678266e+02,		7.719343785348128e+02,
		7.743062090005304e+02,		7.766365393850606e+02,		7.789268744847701e+02,		7.811786394032679e+02,		7.833931849866399e+02,
		7.855717928109573e+02,		7.877156797647441e+02,		7.898260022646276e+02,		7.919038601382160e+02,		7.939503002048174e+02,
		7.959663195813076e+02,		7.979528687377789e+02,		7.999108543250251e+02,		8.018411417937677e+02,		8.037445578235348e+02,
		8.056218925773560e+02,		8.074739017969003e+02,		8.093013087512533e+02,		8.111048060513278e+02,		8.128850573407385e+02,
		8.146426988730229e+02,		8.163783409841499e+02,		8.180925694684781e+02,		8.197859468655870e+02,		8.214590136647716e+02,
		8.231122894333676e+02,		8.247462738745744e+02,		8.263614478199497e+02,		8.279582741613168e+02,		8.295371987264314e+02,
		8.310986511023898e+02,		8.326430454104540e+02,		8.341707810356656e+02,		8.356822433143382e+02,		8.371778041823027e+02,
		8.386578227865336e+02,		8.401226460625884e+02,		8.415726092801117e+02,		8.430080365584893e+02,		8.444292413545535e+02,
		8.458365269241463e+02,		8.472301867591849e+02,		8.486105050017392e+02,		8.499777568365757e+02,		8.513322088634694e+02,
		8.526741194505126e+02,		8.540037390695617e+02,		8.553213106149034e+02,		8.566270697060987e+02,		8.579212449759611e+02,
		8.592040583445057e+02,		8.604757252796940e+02,		8.617364550457067e+02,		8.629864509394648e+02,		8.642259105160406e+02,
		8.654550258035840e+02,		8.666739835083356e+02,		8.678829652102684e+02,		8.690821475498599e+02,		8.702717024064674e+02,
		8.714517970687699e+02,		8.726225943976599e+02,		8.737842529820202e+02,		8.749369272877142e+02,		8.760807678001722e+02,
		8.772159211608734e+02,		8.783425302980497e+02,		8.794607345518889e+02,		8.805706697945228e+02,		8.816724685450438e+02,
		8.827662600798036e+02,		8.838521705382204e+02,		8.849303230243088e+02,		8.860008377041408e+02,		8.870638318994251e+02,
		8.881194201773966e+02,		8.891677144371786e+02,		8.902088239927921e+02,		8.912428556529545e+02,		8.922699137978274e+02,
		8.932901004528410e+02,		8.943035153597365e+02,		8.953102560449383e+02,		8.963104178853966e+02,		8.973040941719795e+02,
		8.982913761705626e+02,		8.992723531808715e+02,		9.002471125932179e+02,		9.012157399431852e+02,		9.021783189643708e+02,
		9.031349316392607e+02,		9.040856582483182e+02,		9.050305774173524e+02,		9.059697661632525e+02,		9.069032999381420e+02,
		9.078312526720238e+02,		9.087536968139793e+02,		9.096707033719723e+02,		9.105823419513252e+02,		9.114886807919066e+02,
		9.123897868040949e+02,		9.132857256035586e+02,		9.141765615448950e+02,		9.150623577541903e+02,		9.159431761605168e+02,
		9.168190775264304e+02,		9.176901214774953e+02,		9.185563665308705e+02,		9.194178701230079e+02,		9.202746886364762e+02,
		9.211268774259569e+02,		9.219744908434378e+02,		9.228175822626354e+02,		9.236562041026730e+02,		9.244904078510380e+02,
		