% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictlvm}
\alias{predictlvm}
\title{Predict function for latent variable models}
\usage{
predictlvm(object, formula, p = coef(object), data = model.frame(object), ...)
}
\arguments{
\item{object}{Model object}

\item{formula}{Formula specifying which variables to predict and which to condition on}

\item{p}{Parameter vector}

\item{data}{Data.frame}

\item{...}{Additional arguments to lower level functions}
}
\description{
Predictions of conditinoal mean and variance and calculation of
jacobian with respect to parameter vector.
}
\examples{
m <- lvm(c(x1,x2,x3)~u1,u1~z,
         c(y1,y2,y3)~u2,u2~u1+z)
latent(m) <- ~u1+u2
d <- simulate(m,10,"u2,u2"=2,"u1,u1"=0.5,seed=123)
e <- estimate(m,d)

## Conditional mean given covariates
predictlvm(e,c(x1,x2)~1)$mean
## Conditional variance of u1,y1 given x1,x2
predictlvm(e,c(u1,y1)~x1+x2)$var
}
\seealso{
predict.lvm
}
