% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{meanAbsorptionTime}
\alias{meanAbsorptionTime}
\title{Mean absorption time}
\usage{
meanAbsorptionTime(object)
}
\arguments{
\item{object}{the markovchain object}
}
\value{
A named vector with the expected number of steps to go from a
  transient state to any of the recurrent ones
}
\description{
Computes the expected number of steps to go from any of the
  transient states to any of the recurrent states. The Markov chain should
  have at least one transient state for this method to work
}
\examples{
m <- matrix(c(1/2, 1/2, 0,
              1/2, 1/2, 0,
                0, 1/2, 1/2), ncol = 3, byrow = TRUE)
mc <- new("markovchain", states = letters[1:3], transitionMatrix = m)
times <- meanAbsorptionTime(mc)

}
\references{
C. M. Grinstead and J. L. Snell. Introduction to Probability.
American Mathematical Soc., 2012.
}
\author{
Ignacio Cordón
}
